/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.DBVersion;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.gray.MetaGrayInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.BuildFormDesignMeta;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaRebuilder;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.devportal.AppDesignMetaReader;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.filter.FilterColumnAp;
import kd.bos.metadata.filter.SchemeFilterColumnAp;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.MobileBillFormAp;
import kd.bos.metadata.form.MobileFormAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.mcontrol.MobSortColumnAp;
import kd.bos.metadata.list.CardListColumnAp;
import kd.bos.metadata.list.ComboListColumnAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metagray.MetaGrayService;
import kd.bos.mservice.svc.earlywarn.IEarlyWarnProxy;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.botp.BOTPServiceFactory;
import kd.bos.service.botp.metadata.IBOTPMetadataReaderProxy;
import kd.bos.service.botp.metadata.ICtBOTPMetadataReaderProxy;
import kd.bos.service.metadata.AppMetadataServiceReader;
import kd.bos.service.metadata.FormFunctionInfo;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.MetadataServiceBalanceReader;
import kd.bos.service.metadata.MetadataServiceImpl;
import kd.bos.service.metadata.MetadataServiceReader;
import kd.bos.service.metadata.RuntimeMetadataShareService;
import kd.bos.service.upgrade.DeployPackageParam;
import kd.bos.service.upgrade.after.DeployPackageApp;
import kd.bos.service.upgrade.after.DeployPackageMeta;
import kd.bos.service.upgrade.after.RebuildType;
import kd.bos.service.upgrade.entity.DeployState;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.userbehavior.UserBehaviorLogServiceHelper;
import kd.bos.sharemeta.ShareMetaUtil;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.TimeSpan;
import kd.bos.utils.TabLayoutUtil;

public class MetadataServiceImpl
implements MetadataService {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String SUCCESS = "success";
    private static final String FAILED = "failed";
    private static final String MOB_META = "MobMeta";
    private static final String FORM_META = "formmeta";
    private static final String ENTITY_META = "entitymeta";
    private static final String ITEMS = "Items";
    private static final String LANGUAGE = "language";
    private static final String VALUE = "value";
    private static final String CONTEXT = "context";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static Log log = LogFactory.getLog(MetadataServiceImpl.class);
    private static volatile MetadataServiceReader reader;
    private static int MAX_Threads;
    private static String rebuild_thread_core;
    private static ExecutorService es;
    private static final int BATCH_SIZE = 200;
    private String appGroup;
    private static boolean rebuildNoDiffVer;
    private static String rebuild_no_diff_ver;

    private static MetadataServiceReader getInstance() {
        if (reader == null) {
            reader = new MetadataServiceReader();
        }
        return reader;
    }

    public String getAppGroup() {
        return this.appGroup;
    }

    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
    }

    public MetadataServiceImpl() {
        reader = MetadataServiceImpl.getInstance();
    }

    public String getRuntimeMetadataVersion(String number) {
        String version = reader.getRuntimeFormMetaVersion(number);
        if (BOSRuntime.checkBosVersionExpire((String)version)) {
            this.rebuildRuntimeMetaDiffVer(number);
            this.removeCache(number);
            version = reader.getRuntimeFormMetaVersion(number);
        }
        return version;
    }

    public Map<String, String> batchLoadRuntimeMetadataVersion(Collection<String> numbers) {
        Map numMaps = reader.batchLoadRuntimeFormMetaVersion(numbers);
        if (numMaps != null && !numMaps.isEmpty()) {
            boolean needReload = false;
            for (Map.Entry it : numMaps.entrySet()) {
                if (!BOSRuntime.checkBosVersionExpire((String)((String)it.getValue()))) continue;
                this.rebuildRuntimeMetaDiffVer((String)it.getKey());
                this.removeCache((String)it.getKey());
                needReload = true;
            }
            if (needReload) {
                numMaps = reader.batchLoadRuntimeFormMetaVersion(numbers);
            }
        }
        return numMaps;
    }

    public String getEntityNumberById(String entityId) {
        return MetadataDao.getEntityNumberById((String)entityId);
    }

    public String getAppNumberById(String id) {
        return (String)ThreadCache.get((Object)("appNum." + id), () -> AppReader.getAppNumberById((String)id));
    }

    public List<String> loadGrayAppInfoList() {
        RequestContext rc = RequestContext.get();
        Map map = GrayStrategy.getUserAppGroup((String)rc.getAccountId());
        if (AppGroupUtils.isOutLog()) {
            try {
                String msg = SerializationUtils.toJsonString((Object)map);
                log.info("loadGrayAppInfoList:{}; getCurrentAppGroup:{} , ", (Object)msg, (Object)AppGroupUtils.getCurrentAppGroup());
            }
            catch (Exception e) {
                log.error("loadGrayAppInfoList out gray log error.", (Throwable)e);
            }
        }
        ArrayList<String> appInfoList = new ArrayList<String>();
        for (Map.Entry entry : map.entrySet()) {
            String infoStr = reader.loadAppInfo((String)entry.getValue(), (String)entry.getKey());
            if (!StringUtils.isNotBlank((CharSequence)infoStr)) continue;
            appInfoList.add(infoStr);
        }
        return appInfoList;
    }

    public List<String> loadGrayFormConfigList(String appGroup) {
        MetaGrayService mgs = new MetaGrayService();
        List metaGrayInfoList = mgs.getMasterMetaGrayInfoByGroup(appGroup);
        String appId = "bos";
        RequestContext rc = RequestContext.get();
        Map map = GrayStrategy.getUserAppGroup((String)rc.getAccountId());
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getValue()).equals(appGroup)) continue;
            appId = (String)entry.getKey();
            if (!appId.equals("*")) break;
            appId = "bos";
            break;
        }
        log.info("loadGrayFormConfigList - appid={}, appGroup={}", (Object)appId, (Object)appGroup);
        ArrayList<String> formConfigList = new ArrayList<String>(metaGrayInfoList.size());
        MetadataServiceImpl metaService = new MetadataServiceImpl();
        metaService.setAppGroup(appGroup);
        for (MetaGrayInfo metaGrayInfo : metaGrayInfoList) {
            String strConfig = (String)DispatchServiceHelper.invokeBOSService((String)(appId == null ? "bos" : appId), (String)"MetadataService", (String)"loadFormConfig", (Object[])new Object[]{metaGrayInfo.getNumber()});
            formConfigList.add(strConfig);
        }
        return formConfigList;
    }

    public String loadAppInfo(String number) {
        RequestContext rc;
        Map map;
        String currentAppGroup;
        String infoStr = reader.loadAppInfo(number);
        if (StringUtils.isBlank((CharSequence)infoStr) && StringUtils.isNotBlank((CharSequence)(currentAppGroup = (String)(map = GrayStrategy.getUserAppGroup((String)(rc = RequestContext.get()).getUserId(), (String)rc.getAccountId())).get(number))) && !"defaultGroup".equals(currentAppGroup)) {
            infoStr = reader.loadAppInfo(currentAppGroup, number);
        }
        return infoStr;
    }

    public Map<String, String> loadAllCloudInfo() {
        AppMetadataServiceReader appReader = new AppMetadataServiceReader();
        return appReader.loadAllCloudInfo();
    }

    public Map<String, String> loadAllAppInfo() {
        AppMetadataServiceReader appReader = new AppMetadataServiceReader();
        return appReader.loadAllAppInfo();
    }

    public Map<String, String> loadAllAppMenusInfo() {
        AppMetadataServiceReader appReader = new AppMetadataServiceReader();
        return appReader.loadAllAppMenusInfo();
    }

    public Map<String, String> getAppNumbers() {
        AppMetadataServiceReader appReader = new AppMetadataServiceReader();
        return appReader.getAppNumbers();
    }

    public String getAppMenusInfoByAppId(String number) {
        return reader.getAppMenusInfoByAppId(number);
    }

    public String loadEntityMeta(String number) {
        try (EntityTraceSpan span = EntityTracer.create((String)"MetadataService", (String)("loadEntityMeta." + number));){
            String entityMeta = reader.loadEntityMeta(number);
            if (this.checkBosVersionExpire(entityMeta)) {
                this.removeCache(number);
                this.rebuildFormRuntimeMeta(number);
                entityMeta = reader.loadEntityMeta(number);
            }
            String string = entityMeta;
            return string;
        }
    }

    public Map<String, String> loadEntityMetas(Collection<String> numbers) {
        Map entityMetas = reader.loadEntityMetas(numbers.toArray(new String[0]));
        for (Map.Entry entry : entityMetas.entrySet()) {
            String number = (String)entry.getKey();
            String entityMeta = (String)entry.getValue();
            if (!this.checkBosVersionExpire(entityMeta)) continue;
            this.removeCache(number);
            this.rebuildFormRuntimeMeta(number);
            entityMeta = reader.loadEntityMeta(number);
            entityMetas.put(number, entityMeta);
        }
        return entityMetas;
    }

    public Map<String, String> getAppNumberByEntityNumbers(List<Object> entityNumbers) {
        return reader.getAppNumberByEntityNumbers(entityNumbers);
    }

    public Map<String, Object> savePageJsScript(Map<String, Object> scriptContext) {
        Object scriptId = scriptContext.get("scriptId");
        Object bizAppId = scriptContext.get("bizAppId");
        Object formId = scriptContext.get("formId");
        Object formType = scriptContext.get("formType");
        Object scriptContent = scriptContext.get("scriptContent");
        Map scriptContentMap = (Map)SerializationUtils.fromJsonString((String)((String)scriptContent), Map.class);
        String encodeType = (String)scriptContentMap.get("Encode");
        if ("base64".equals(encodeType)) {
            String source = (String)scriptContentMap.get("Source");
            String compile = (String)scriptContentMap.get("Compile");
            scriptContentMap.put("Source", new String(Base64.getDecoder().decode(source)));
            scriptContentMap.put("Compile", new String(Base64.getDecoder().decode(compile)));
            scriptContent = SerializationUtils.toJsonString((Object)scriptContentMap);
        }
        DynamicObject[] scriptObj = BusinessDataServiceHelper.load((Object[])new Object[]{scriptId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)IDE_PLUGINSCRIPT));
        DynamicObject scriptDynamicObj = null;
        if (scriptObj != null && scriptObj.length > 0) {
            scriptDynamicObj = scriptObj[0];
            scriptDynamicObj.set("txt_scriptcontext_tag", scriptContent);
            scriptDynamicObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            String formatStr = "yyyy-MM-dd HH:mm:ss";
            Timestamp timestamp = Timestamp.valueOf(new SimpleDateFormat(formatStr).format(new Date()));
            scriptDynamicObj.set("modifydate", (Object)timestamp);
        } else {
            scriptDynamicObj = BusinessDataServiceHelper.newDynamicObject((String)IDE_PLUGINSCRIPT);
            scriptDynamicObj.set("id", scriptId);
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", formId)};
            DynamicObject[] formObj = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"number", (QFilter[])qFilters);
            String formNumber = (String)(formObj == null || formObj.length <= 0 ? formId : formObj[0].get("number"));
            String name = String.format("%s_JSScript_%s", formNumber, scriptId);
            if ("mobile".equals(formType)) {
                name = String.format("%s_mob_JSScript_%s", formNumber, scriptId);
            }
            scriptDynamicObj.set("txt_scriptname", (Object)name);
            scriptDynamicObj.set("txt_scriptnumber", (Object)name);
            scriptDynamicObj.set("cmb_ftype", (Object)"1");
            scriptDynamicObj.set("cbox_script_type", (Object)"14");
            scriptDynamicObj.set("txt_scriptcontext_tag", scriptContent);
            scriptDynamicObj.set("bizappid", bizAppId);
            QFilter qFormId = new QFilter("form", "=", formId);
            DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizunit,bizapp", (QFilter[])new QFilter[]{qFormId});
            String bizUnitId = pageRelInfo == null ? "" : pageRelInfo.getString("bizunit");
            scriptDynamicObj.set("bizunitid", (Object)bizUnitId);
            scriptDynamicObj.set("creater", (Object)RequestContext.get().getCurrUserId());
            scriptDynamicObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            String formatStr = "yyyy-MM-dd HH:mm:ss";
            Timestamp timestamp = Timestamp.valueOf(new SimpleDateFormat(formatStr).format(new Date()));
            scriptDynamicObj.set("createdate", (Object)timestamp);
            scriptDynamicObj.set("modifydate", (Object)timestamp);
            scriptDynamicObj.set("isv", (Object)ISVService.getISVInfo().getId());
            String className = formId + "_" + scriptId;
            if ("mobile".equals(formType)) {
                className = formId + "_mob_" + scriptId;
            }
            scriptDynamicObj.set("classname", (Object)className);
            scriptDynamicObj.set("enginetype", (Object)"2");
        }
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scriptDynamicObj});
            result.put(SUCCESS, Boolean.TRUE);
            boolean isFormScript = this.checkFormHasTheScript((String)formId, (String)scriptId, (String)formType);
            if (!isFormScript) {
                result.put("needSave", true);
            }
        }
        catch (Exception e) {
            log.error("pageJsScript save error", (Throwable)e);
            result.put("errorMessage", e.getMessage());
            result.put(SUCCESS, Boolean.FALSE);
        }
        return result;
    }

    private boolean checkFormHasTheScript(String formId, String scriptId, String formType) {
        AbstractMetadata meta = MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        if (!(meta instanceof FormMetadata)) {
            return false;
        }
        FormMetadata formMetadata = (FormMetadata)meta;
        ControlAp rootAp = (ControlAp)formMetadata.getItems().get(0);
        FormAp needCheckFormAp = null;
        if (rootAp instanceof BillFormAp && !(rootAp instanceof MobileBillFormAp)) {
            ControlAp mobControlAp;
            FormMetadata mobMeta;
            if ("pc".equals(formType)) {
                needCheckFormAp = (FormAp)rootAp;
            } else if ("mobile".equals(formType) && (mobMeta = ((BillFormAp)rootAp).getMobMeta()) != null && (mobControlAp = (ControlAp)mobMeta.getItems().get(0)) instanceof FormAp) {
                needCheckFormAp = (FormAp)mobControlAp;
            }
        } else if (rootAp instanceof FormAp) {
            needCheckFormAp = (FormAp)rootAp;
        }
        boolean isFormScript = false;
        if (needCheckFormAp != null) {
            List jsPlugins = needCheckFormAp.getJsPlugins();
            for (Plugin jsPlugin : jsPlugins) {
                if (!StringUtils.equals((CharSequence)scriptId, (CharSequence)jsPlugin.getFpk())) continue;
                isFormScript = true;
                break;
            }
        }
        return isFormScript;
    }

    public List<Object> loadPageJsScript(List<String> scriptIds) {
        if (CollectionUtils.isEmpty(scriptIds)) {
            return Collections.emptyList();
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", scriptIds), new QFilter("cbox_script_type", "=", (Object)"14")};
        Map scriptObjMap = BusinessDataReader.loadFromCache((String)IDE_PLUGINSCRIPT, (String)"id, txt_scriptcontext_tag, isv", (QFilter[])qFilters);
        ArrayList<Object> result = new ArrayList<Object>(scriptIds.size());
        if (!CollectionUtils.isEmpty((Map)scriptObjMap)) {
            for (Map.Entry scriptObj : scriptObjMap.entrySet()) {
                Map scriptContentMap;
                String encode;
                String id = (String)scriptObj.getKey();
                DynamicObject value = (DynamicObject)scriptObj.getValue();
                String scriptContent = value.getString("txt_scriptcontext_tag");
                if (StringUtils.isNotBlank((CharSequence)scriptContent) && (encode = (String)(scriptContentMap = (Map)SerializationUtils.fromJsonString((String)scriptContent, Map.class)).get("Encode")) != null) {
                    scriptContentMap.put("Encode", "");
                    scriptContent = SerializationUtils.toJsonString((Object)scriptContentMap);
                }
                String isv = value.getString("isv");
                HashMap<String, String> item = new HashMap<String, String>(8);
                item.put("id", id);
                item.put("scriptContent", scriptContent);
                item.put("isv", isv);
                result.add(item);
            }
        }
        return result;
    }

    private boolean checkBosVersionExpire(String entityMeta) {
        String prefix = "\"Version\":\"";
        int index = entityMeta.lastIndexOf(prefix);
        if (index == -1) {
            return false;
        }
        String runtimeVersion = entityMeta.substring(index += prefix.length(), index + BOSRuntime.getVersion().length());
        return BOSRuntime.checkBosVersionExpire((String)runtimeVersion);
    }

    public String loadEntityMetaFromCache(String number) {
        return EntityItemTypes.toJsonString((IDataEntityType)EntityMetadataCache.getDataEntityType((String)number));
    }

    public String loadTableDefine(String entityNumber, String entityKey) {
        return reader.loadTableDefine(entityNumber, entityKey);
    }

    public String loadTableDefine(Long tableId) {
        return reader.loadTableDefine(tableId);
    }

    public String loadEntityOperationMeta(String number, String operKey) {
        return reader.loadEntityOperationMeta(number, operKey);
    }

    public List<String> loadEntityAllOperationMeta(String number) {
        return reader.loadEntityAllOperationMeta(number);
    }

    public List<String> loadEntityNetCtrlOperationMeta(String number) {
        return reader.loadEntityNetCtrlOperationMeta(number);
    }

    public String loadEntityPrincipalRelationMeta(String number) {
        return reader.loadEntityPrincipalRelationMeta(number);
    }

    public Set<String> loadPermissionItems(String number) {
        return reader.loadPermissionItems(number);
    }

    public String loadEntityRuntimeMeta(String entityNumber, int entityMetaType, String key) {
        return reader.loadEntityRuntimeMeta(entityNumber, entityMetaType, key);
    }

    public String loadFormMeta(String number) {
        return reader.loadFormRuntimeMeta(number, RuntimeMetaType.Form.getValue(), number);
    }

    public String loadClientFormMeta(String number) {
        try (TimeSpan ts = new TimeSpan();){
            String str = "";
            if (ShareMetaUtil.enableShareMeta()) {
                RuntimeMetadataShareService service = (RuntimeMetadataShareService)ServiceFactory.getService((String)"RuntimeMetadataShareService");
                str = service.loadFormRuntimeMeta(number, RuntimeMetaType.Client.getValue(), number);
            } else {
                String str2 = TabLayoutUtil.enable() ? reader.loadFormRuntimeMeta(number, RuntimeMetaType.TabLayout.getValue(), RuntimeMetaType.TabLayout.name().toLowerCase()) : "";
                str = StringUtils.isBlank((CharSequence)str2) ? reader.loadFormRuntimeMeta(number, RuntimeMetaType.Client.getValue(), number) : str2;
            }
            Long timeSpan = ts.getCostMS();
            String appId = "";
            if (StringUtils.isNotBlank((CharSequence)number)) {
                appId = FormMetadataCache.getFormConfig((String)number).getAppId();
            }
            UserBehaviorLogServiceHelper.writeLog((String)appId, (String)number, (String)"getMetadata", (long)timeSpan);
            String string = str;
            return string;
        }
    }

    public String loadFormConfig(String number) {
        return reader.loadFormConfig(number);
    }

    public String loadFormPluginScriptMeta(String number, String key) {
        return reader.loadFormPluginScript(number, key);
    }

    public String loadFormRuntimeMeta(String formId, short formMetaType, String key) {
        return reader.loadFormRuntimeMeta(formId, formMetaType, key);
    }

    public String loadBaseDataFieldFilterMeta(String entityNumber, String key) {
        return reader.loadBaseDataFieldFilterMeta(entityNumber, key);
    }

    public String loadConvertRule(String ruleId) {
        return ((IBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(IBOTPMetadataReaderProxy.class)).loadConvertRule(ruleId);
    }

    public List<String> loadConvertRules(String sourceEntityNumber, String targetEntityNumber) {
        return ((IBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(IBOTPMetadataReaderProxy.class)).loadConvertRules(sourceEntityNumber, targetEntityNumber);
    }

    public List<String> loadConvertRuleIds(String sourceEntityNumber, String targetEntityNumber) {
        return ((IBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(IBOTPMetadataReaderProxy.class)).loadConvertRuleIds(sourceEntityNumber, targetEntityNumber);
    }

    public String loadCtConvertRule(String ruleId) {
        return ((ICtBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(ICtBOTPMetadataReaderProxy.class)).loadCtConvertRule(ruleId);
    }

    public String loadCtConvertRuleByVerId(String ruleId, String verId, String extVerId) {
        return ((ICtBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(ICtBOTPMetadataReaderProxy.class)).loadCtConvertRuleByVerId(ruleId, verId, extVerId);
    }

    public List<String> loadCtConvertRules(String sourceTenant, String sourceDataCenter, String sourceEntityNumber, String targetTenant, String targetDataCenter, String targetEntityNumber) {
        return ((ICtBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(ICtBOTPMetadataReaderProxy.class)).loadCtConvertRules(sourceTenant, sourceDataCenter, sourceEntityNumber, targetTenant, targetDataCenter, targetEntityNumber);
    }

    public List<String> loadCtConvertRuleIds(String sourceTenant, String sourceDataCenter, String sourceEntityNumber, String targetTenant, String targetDataCenter, String targetEntityNumber) {
        return ((ICtBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(ICtBOTPMetadataReaderProxy.class)).loadCtConvertRuleIds(sourceTenant, sourceDataCenter, sourceEntityNumber, targetTenant, targetDataCenter, targetEntityNumber);
    }

    public String loadWriteBackRule(String ruleId) {
        return ((IBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(IBOTPMetadataReaderProxy.class)).loadWriteBackRule(ruleId);
    }

    public List<String> loadWriteBackRules(String targetEntityNumber) {
        return ((IBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(IBOTPMetadataReaderProxy.class)).loadWriteBackRules(targetEntityNumber);
    }

    public List<String> loadWriteBackRuleIds(String targetEntityNumber) {
        return ((IBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(IBOTPMetadataReaderProxy.class)).loadWriteBackRuleIds(targetEntityNumber);
    }

    public String loadWriteBackRuleVersion(long verId) {
        return ((IBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(IBOTPMetadataReaderProxy.class)).loadWriteBackRuleVersion(verId);
    }

    public String loadBalanceRule(String ruleNumber) {
        return MetadataServiceBalanceReader.loadBalanceRle((String)ruleNumber);
    }

    public List<String> loadBalanceRuleByBill(String sourceEntityNumber) {
        return MetadataServiceBalanceReader.loadBalanceRuleByBill((String)sourceEntityNumber);
    }

    public List<String> loadBalanceRuleByBalTable(String balanceTableNumber) {
        return MetadataServiceBalanceReader.loadBalanceRuleByBalTable((String)balanceTableNumber);
    }

    public String loadEarlyWarn(String earlyWarnId) {
        IEarlyWarnProxy earlyWarnService = (IEarlyWarnProxy)ServiceFactory.getService(IEarlyWarnProxy.class);
        return earlyWarnService.loadEarlyWarn(earlyWarnId);
    }

    public String loadWarnSchedule(String warnScheduleId) {
        IEarlyWarnProxy earlyWarnService = (IEarlyWarnProxy)ServiceFactory.getService(IEarlyWarnProxy.class);
        return earlyWarnService.loadWarnSchedule(warnScheduleId);
    }

    public void removeCache(String number) {
        MetaCacheUtils.removeDistributeCache((String[])new String[]{number});
    }

    public void rebuildFormRuntimeMeta(String number) {
        MetaRebuilder mr = new MetaRebuilder(this.appGroup);
        mr.rebuildRuntimeMetaByNumber(number);
    }

    public void rebuildRuntimeMetaDiffVer(String number) {
        MetaRebuilder mr = new MetaRebuilder(this.appGroup);
        mr.rebuildRuntimeMetaDiffVer(number);
    }

    public Map<String, Object> rebuildAll(boolean forceRebuild) {
        Map balRuleResult;
        Map<String, Object> appResult;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Map<String, Object> formResult = this.rebuildAllDiffVer(forceRebuild, false);
        List successResult = (List)formResult.get(SUCCESS);
        if (formResult != null) {
            result.put("formResult", formResult);
        }
        if ((appResult = this.rebuildAllApp(null)) != null) {
            result.put("appResult", appResult);
        }
        if ((balRuleResult = MetadataServiceBalanceReader.rebuildAllRuntimeRules((boolean)forceRebuild)).containsKey(SUCCESS)) {
            successResult.addAll((List)balRuleResult.get(SUCCESS));
        }
        if (balRuleResult.containsKey(FAILED)) {
            if (!formResult.containsKey(FAILED)) {
                formResult.put(FAILED, new ArrayList());
            }
            List failedResult = (List)formResult.get(FAILED);
            failedResult.addAll((List)balRuleResult.get(FAILED));
        }
        return result;
    }

    public Map<String, Object> rebuildAllApp(List<String> rebuidAppParams) {
        DeployPackageApp deployPackageApp = new DeployPackageApp();
        long taskId = DB.genGlobalLongId();
        DeployPackageParam dpParam = new DeployPackageParam(taskId, DBVersion.getVer(), ISVServiceHelper.getISVInfo().getIsvId());
        if (rebuidAppParams != null && !rebuidAppParams.isEmpty()) {
            dpParam.getAppList().addAll(rebuidAppParams);
        }
        DeployState deployState = new DeployState(taskId);
        return deployPackageApp.rebuildAllAppMeta(dpParam, this.appGroup, deployState, RebuildType.RebuildAllApp);
    }

    public Map<String, Object> rebuildAllDiffVer(boolean forceRebuild, boolean diffVer) {
        String buildAppGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isNotBlank((CharSequence)this.appGroup)) {
            buildAppGroup = this.appGroup;
        }
        long taskId = DB.genGlobalLongId();
        DeployPackageParam dpParam = new DeployPackageParam(taskId, DBVersion.getVer(), "", "");
        dpParam.setDiffVer(diffVer);
        dpParam.setRebuildType(RebuildType.RebuildAllMeta);
        DeployState deployState = new DeployState(taskId);
        DeployPackageMeta deployPackageMeta = new DeployPackageMeta();
        return deployPackageMeta.rebuildAllMeta(dpParam, deployState);
    }

    public Map<String, Object> rebuildByApps(boolean forceRebuild, List<String> rebuildAppParams) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select a.FID, b.FNUMBER from T_META_FORMDESIGN a inner join T_META_BIZAPP b on a.FBIZAPPID = b.FID where ", new Object[0]).appendIn("b.FNUMBER", rebuildAppParams.toArray());
        2 action = new /* Unavailable Anonymous Inner Class!! */;
        Map map = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, (ResultSetHandler)action);
        if (map == null) {
            return result;
        }
        for (Map.Entry entry : map.entrySet()) {
            result.putAll(this.rebuildRunTimeMetas((String)entry.getKey(), (List)entry.getValue()));
        }
        this.rebuildAllDiffVer(true, true);
        return result;
    }

    public Map<String, Object> rebuildForms(Map<String, Object> param) {
        DeployPackageMeta deployPackageMeta = new DeployPackageMeta();
        return deployPackageMeta.batchRebuildForm(param);
    }

    @Deprecated
    public Map<String, Object> rebuildRunTimeMetas(String mainAppId, Set<String> appFids, List<String> formIds) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        HashMap appResult = (HashMap)result.get(mainAppId);
        if (appResult == null) {
            appResult = new HashMap();
            result.put(mainAppId, appResult);
        }
        ArrayList<String> successResult = new ArrayList<String>();
        ArrayList<String> failedResult = new ArrayList<String>();
        appResult.put(SUCCESS, successResult);
        appResult.put(FAILED, failedResult);
        long rebuildFormCost = 0L;
        long getRFCost = 0L;
        long delRMCost = 0L;
        long rebuildAppCost = 0L;
        long rebuildFormStart = System.currentTimeMillis();
        if (formIds != null && !formIds.isEmpty()) {
            List metas = MetadataDao.getRebuildFormDesignMeta(formIds);
            long getRFEnd = System.currentTimeMillis();
            getRFCost = getRFEnd - rebuildFormStart;
            try {
                ArrayList<String> delIds = new ArrayList<String>(10);
                for (int i = 0; i < metas.size(); ++i) {
                    BuildFormDesignMeta meta = (BuildFormDesignMeta)metas.get(i);
                    delIds.add(meta.getId());
                }
                Object[] ids = new String[delIds.size()];
                for (int j = 0; j < delIds.size(); ++j) {
                    ids[j] = (String)delIds.get(j);
                }
                long delRMStart = System.currentTimeMillis();
                Arrays.sort(ids);
                MetadataDao.delRuntimeMeta((String[])ids);
                long delRMEnd = System.currentTimeMillis();
                delRMCost = delRMEnd - delRMStart;
                Map<String, Object> appFormResult = this.rebuildFormMetas(true, true, metas);
                MetadataDao.clearCache((List)metas);
                if (appFormResult.containsKey(SUCCESS)) {
                    successResult.addAll((List)appFormResult.get(SUCCESS));
                }
                if (appFormResult.containsKey(FAILED)) {
                    failedResult.addAll((List)appFormResult.get(FAILED));
                }
            }
            catch (Exception e) {
                failedResult.add(String.format(ResManager.loadKDString((String)"\u6784\u5efa\u5e94\u7528\u5305\u3010%1$s\u3011\u8868\u5355\u5143\u6570\u636e\u5931\u8d25\uff1a%2$s", (String)"MetadataServiceImpl_26", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), mainAppId, this.getErrorMsg(e)));
            }
        }
        long rebuildFormEnd = System.currentTimeMillis();
        rebuildFormCost = rebuildFormEnd - rebuildFormStart;
        if (appFids != null) {
            ThreadCache.put((Object)"AppMetaDao.querySubApp.ignoreExtApp", (Object)"true");
            Iterator<String> iterator = appFids.iterator();
            while (iterator.hasNext()) {
                String fid;
                String appId = fid = iterator.next();
                try {
                    long rebuildAppStart = System.currentTimeMillis();
                    appId = AppReader.getAppNumberById((String)fid);
                    try {
                        MetadataDao.rebuildRuntimeAppMetaByNumber((String)appId);
                        successResult.add(String.format(ResManager.loadKDString((String)"\u6784\u5efa\u5e94\u7528\u3010%s\u3011\u5143\u6570\u636e\u6210\u529f\uff01", (String)"MetadataServiceImpl_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appId));
                    }
                    catch (Exception e) {
                        failedResult.add(String.format(ResManager.loadKDString((String)"\u6784\u5efa\u5e94\u7528\u3010%1$s\u3011\u5143\u6570\u636e\u5931\u8d25\uff1a%2$s", (String)"MetadataServiceImpl_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appId, e.getMessage()));
                    }
                    long rebuildAppEnd = System.currentTimeMillis();
                    rebuildAppCost = rebuildAppEnd - rebuildAppStart;
                    Map balRuleBuildResult = MetadataServiceBalanceReader.rebuildAppRuntimeRules((boolean)true, (String)appId);
                    if (balRuleBuildResult.containsKey(SUCCESS)) {
                        successResult.addAll((List)balRuleBuildResult.get(SUCCESS));
                    }
                    if (balRuleBuildResult.containsKey(FAILED)) {
                        failedResult.addAll((List)balRuleBuildResult.get(FAILED));
                    }
                    long rebuildBalEnd = System.currentTimeMillis();
                    long rebuildBalCost = rebuildBalEnd - rebuildAppEnd;
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u91cd\u5efa\u8017\u65f6\uff1a%2$s\uff0c\u4f59\u989d\u8868\u91cd\u5efa\u8017\u65f6\uff1a%3$s", (String)"MetadataServiceImpl_28", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appId, rebuildAppCost, rebuildBalCost);
                    successResult.add(msg);
                }
                catch (Exception e) {
                    failedResult.add(String.format(ResManager.loadKDString((String)"\u6784\u5efa\u5e94\u7528\u3010%1$s\u3011\u6216\u5176\u4f59\u989d\u8868\u5931\u8d25\uff1a%2$s", (String)"MetadataServiceImpl_27", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appId, this.getErrorMsg(e)));
                }
            }
            ThreadCache.remove((Object)"AppMetaDao.querySubApp.ignoreExtApp");
        }
        String msg = String.format(ResManager.loadKDString((String)"\u8017\u65f6\u7edf\u8ba1\uff0c\u8868\u5355\u91cd\u5efa\u8017\u65f6\u5171\uff1a%1$s\uff0c\u5176\u4e2d\u8ba1\u7b97\u8868\u5355\u5173\u7cfb\u8017\u65f6\uff1a%2$s,\u5220\u9664\u8868\u5355\u8fd0\u884c\u65f6\u8017\u65f6\uff1a%3$s\uff0c\u5e94\u7528\u91cd\u5efa+\u4f59\u989d\u8868\u91cd\u5efa\u8017\u65f6\uff1a%4$s", (String)"MetadataServiceImpl_29", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), rebuildFormCost, getRFCost, delRMCost, System.currentTimeMillis() - rebuildFormEnd);
        successResult.add(msg);
        return result;
    }

    public Map<String, Object> rebuildRunTimeFormMetas(List<String> formIds) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        ArrayList successResult = new ArrayList();
        ArrayList failedResult = new ArrayList();
        result.put(SUCCESS, successResult);
        result.put(FAILED, failedResult);
        MetaRebuilder metaRebuilder = new MetaRebuilder(this.appGroup);
        if (formIds != null && !formIds.isEmpty()) {
            List metas = metaRebuilder.getRebuildFormDesignMeta(formIds);
            ArrayList<String> delIds = new ArrayList<String>(10);
            for (int i = 0; i < metas.size(); ++i) {
                BuildFormDesignMeta meta = (BuildFormDesignMeta)metas.get(i);
                delIds.add(meta.getId());
            }
            Object[] ids = new String[delIds.size()];
            for (int j = 0; j < delIds.size(); ++j) {
                ids[j] = (String)delIds.get(j);
            }
            Arrays.sort(ids);
            metaRebuilder.delRuntimeMeta((String[])ids);
            Map<String, Object> appFormResult = this.rebuildFormMetas(true, true, metas);
            metaRebuilder.clearCache(metas);
            if (appFormResult.containsKey(SUCCESS)) {
                successResult.addAll((List)appFormResult.get(SUCCESS));
            }
            if (appFormResult.containsKey(FAILED)) {
                failedResult.addAll((List)appFormResult.get(FAILED));
            }
        }
        return result;
    }

    public Map<String, Object> rebuildRunTimeAppMetas(Set<String> appFids) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        ArrayList<String> successResult = new ArrayList<String>();
        ArrayList<String> failedResult = new ArrayList<String>();
        result.put(SUCCESS, successResult);
        result.put(FAILED, failedResult);
        MetaRebuilder metaRebuilder = new MetaRebuilder(this.appGroup);
        if (appFids != null) {
            Iterator<String> iterator = appFids.iterator();
            while (iterator.hasNext()) {
                String fid;
                String appId = fid = iterator.next();
                try {
                    AppDesignMetaReader amr = new AppDesignMetaReader();
                    amr.setAppGroup(this.appGroup);
                    appId = amr.getAppNumberById(fid);
                    if (StringUtils.isBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)this.appGroup) && !"defaultGroup".equals(this.appGroup)) {
                        amr = new AppDesignMetaReader();
                        appId = amr.getAppNumberById(fid);
                    }
                    try {
                        metaRebuilder.rebuildRuntimeAppMetaByNumber(appId);
                        successResult.add(String.format(ResManager.loadKDString((String)"\u6784\u5efa\u5e94\u7528\u3010%s\u3011\u5143\u6570\u636e\u6210\u529f\uff01", (String)"MetadataServiceImpl_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appId));
                    }
                    catch (Exception e) {
                        failedResult.add(String.format(ResManager.loadKDString((String)"\u6784\u5efa\u5e94\u7528\u3010%1$s\u3011\u5143\u6570\u636e\u5931\u8d25\uff1a%2$s", (String)"MetadataServiceImpl_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appId, e.getMessage()));
                    }
                    Map balRuleBuildResult = MetadataServiceBalanceReader.rebuildAppRuntimeRules((boolean)true, (String)appId);
                    if (balRuleBuildResult.containsKey(SUCCESS)) {
                        successResult.addAll((List)balRuleBuildResult.get(SUCCESS));
                    }
                    if (!balRuleBuildResult.containsKey(FAILED)) continue;
                    failedResult.addAll((List)balRuleBuildResult.get(FAILED));
                }
                catch (Exception e) {
                    failedResult.add(String.format(ResManager.loadKDString((String)"\u6784\u5efa\u5e94\u7528\u3010%1$s\u3011\u6216\u5176\u4f59\u989d\u8868\u5931\u8d25\uff1a%2$s", (String)"MetadataServiceImpl_27", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appId, this.getErrorMsg(e)));
                }
            }
            metaRebuilder.cleanAllAppMetadataCache();
        }
        return result;
    }

    public Map<String, Object> rebuildVerDiffFormMetasByApps(List<String> appNumbers) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        for (String appNumber : appNumbers) {
            Map map = MetadataDao.getMetaVersion((String)appNumber);
            ArrayList<String> list = new ArrayList<String>(map.keySet());
            result.putAll(this.rebuildVerDiffFormMetas(appNumber, list));
        }
        return result;
    }

    private Map<String, Object> rebuildVerDiffFormMetas(String appNumber, List<String> formIds) {
        List ids = MetadataDao.getIdByVerDiff(formIds);
        return this.rebuildRunTimeMetas(appNumber, ids);
    }

    public Map<String, Object> rebuildRunTimeMetas(String appNumber, List<String> formIds) {
        HashSet<String> appFids = new HashSet<String>();
        if (appNumber != null) {
            String fid = null;
            try {
                AppDesignMetaReader amr = new AppDesignMetaReader();
                amr.setAppGroup(this.appGroup);
                fid = amr.getAppIdByNumber(appNumber);
                if (fid != null) {
                    appFids.add(fid);
                }
            }
            catch (Exception ex) {
                log.error("\u3010" + appNumber + "\u3011\u5e94\u7528\u5df2\u7ecf\u4e0d\u5b58\u5728\uff01");
            }
        }
        return this.rebuildRunTimeMetas(appNumber, appFids, formIds);
    }

    public Map<String, Object> rebuildFormMetasByDesignMeta(boolean forceRebuild, boolean diffVer, List<BuildFormDesignMeta> metas) {
        return this.rebuildFormMetas(forceRebuild, diffVer, metas);
    }

    private Map<String, Object> rebuildFormMetas(boolean forceRebuild, boolean diffVer, List<BuildFormDesignMeta> metas) {
        List successResult = Collections.synchronizedList(new ArrayList());
        List failedResult = Collections.synchronizedList(new ArrayList());
        ArrayList<String> numbers = new ArrayList<String>(10);
        for (BuildFormDesignMeta meta : metas) {
            numbers.add(meta.getNumber());
        }
        Map runtimeVerMap = MetadataDao.getRuntimeMetaVersion(numbers);
        ArrayList<Builder> tasks = new ArrayList<Builder>();
        for (BuildFormDesignMeta meta : metas) {
            if (meta.getDevType().compareTo("1") == 0 || meta.getDevType().compareTo("3") == 0) continue;
            String runtimeVer = (String)runtimeVerMap.get(meta.getNumber());
            Builder builder = new Builder(this, meta, forceRebuild, diffVer, RequestContext.get());
            builder.setRuntimeVer(runtimeVer);
            builder.setAppGroup(this.appGroup);
            tasks.add(builder);
        }
        try {
            ArrayList results = new ArrayList(tasks.size());
            for (int i = 0; i < tasks.size(); i += 200) {
                int startIndex = i;
                int endIndex = i + 200;
                if (endIndex > tasks.size()) {
                    endIndex = tasks.size();
                }
                ArrayList batchTasks = new ArrayList(tasks.subList(startIndex, endIndex));
                results.addAll(es.invokeAll(batchTasks));
            }
            long buildTimeOut = this.getBuildTimeOut();
            results.forEach(result -> {
                try {
                    Tuple r = (Tuple)result.get(buildTimeOut, TimeUnit.MINUTES);
                    if (((Boolean)r.item1).booleanValue()) {
                        successResult.add(r.item2);
                    } else {
                        failedResult.add(r.item2);
                    }
                }
                catch (Exception e) {
                    failedResult.add(String.format(ResManager.loadKDString((String)"\u6784\u5efaForm\u5143\u6570\u636e\u5931\u8d25\uff1a%s", (String)"MetadataServiceImpl_4", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), this.getErrorMsg(e)));
                }
            });
        }
        catch (Exception e) {
            ErrorCode ec = new ErrorCode("BOS_META", e.getMessage());
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("count", metas.size());
        result2.put(FAILED, failedResult);
        result2.put(SUCCESS, successResult);
        return result2;
    }

    private long getBuildTimeOut() {
        int timeout = 120;
        String buildTimeout = System.getProperty("build.timeout");
        if (!StringUtils.isEmpty((CharSequence)buildTimeout)) {
            timeout = Integer.parseInt(buildTimeout);
        }
        return timeout;
    }

    private String getErrorMsg(Exception e) {
        String err = e.getMessage();
        if (StringUtils.isBlank((CharSequence)err)) {
            err = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        }
        return err;
    }

    public String getExportWriter(String formId, long templateId, String pluginClassName, String extenddata) {
        IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
        return exportService.getExportWriter(formId, templateId, pluginClassName, extenddata);
    }

    public String getExportWriter(String formId, long templateId, String pluginClassName, String importPluginType, String extenddata) {
        IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
        return exportService.getExportWriter(formId, templateId, pluginClassName, importPluginType, extenddata);
    }

    public boolean isEntityItemReferenced(String entityId, String entityItemId) {
        String sql = String.format("select fid from t_meta_formdesign where fentityid = '%s'", entityId);
        List formIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
            ArrayList<String> idlist = new ArrayList<String>(16);
            while (rs.next()) {
                String formId = rs.getString(1);
                idlist.add(formId);
            }
            return idlist;
        });
        if (formIds.size() == 0) {
            return false;
        }
        for (String formId : formIds) {
            AbstractMetadata rtMetadata = MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
            if (!(rtMetadata instanceof FormMetadata)) continue;
            FormMetadata metadata = (FormMetadata)rtMetadata;
            boolean isFldRef = metadata.getItems().stream().anyMatch(i -> i instanceof FieldAp && entityItemId.equalsIgnoreCase(((FieldAp)i).getFieldId()));
            if (isFldRef) {
                return true;
            }
            boolean isEntryRef = metadata.getItems().stream().anyMatch(i -> i instanceof EntryAp && entityItemId.equalsIgnoreCase(((EntryAp)i).getEntryId()));
            if (!isEntryRef) continue;
            return true;
        }
        return false;
    }

    public List<Map<String, Object>> getFiledReferencedList(Map<String, Object> content, List<Map<String, Object>> filedList) {
        ArrayList<Map<String, Object>> filedReferencedList = new ArrayList<Map<String, Object>>();
        FormMetadataConverter formMetadataConverter = new FormMetadataConverter();
        AbstractMetadata abstractMetadata = formMetadataConverter.convertTo(content);
        BillFormAp billFormAp = null;
        FormMetadata metadata = null;
        if (abstractMetadata instanceof FormMetadata) {
            metadata = (FormMetadata)abstractMetadata;
            List controlAps = metadata.getItems();
            for (ControlAp controlAp : controlAps) {
                if (!(controlAp instanceof BillFormAp)) continue;
                billFormAp = (BillFormAp)controlAp;
            }
        }
        FormMetadata listMeta = null == billFormAp ? null : billFormAp.getListMeta();
        FormMetadata mobMeta = null == billFormAp ? null : billFormAp.getMobMeta();
        FormMetadata mobListMeta = null == billFormAp ? null : billFormAp.getMobListMeta();
        for (Map<String, Object> filed : filedList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            filed = this.getFiledByFormMetadata(filed, metadata);
            List<String> listMetaIdList = this.getFiledRelevanceControlApList(listMeta, filed);
            List<String> mobMetaIdList = this.getFiledRelevanceControlApList(mobMeta, filed);
            List<String> mobListMetaIdList = this.getFiledRelevanceControlApList(mobListMeta, filed);
            if (listMetaIdList.size() <= 0 && mobMetaIdList.size() <= 0 && mobListMetaIdList.size() <= 0) continue;
            map.put("ListMeta", listMetaIdList);
            map.put(MOB_META, mobMetaIdList);
            map.put("MobListMeta", mobListMetaIdList);
            map.put("key", filed.get("key"));
            map.put("name", filed.get("name"));
            filedReferencedList.add(map);
        }
        return filedReferencedList;
    }

    public String getDesignerMetadata(String formId, String designerMetaType, String lang) {
        return this.innerGetDesignerMetadata(formId, designerMetaType, lang, "", "");
    }

    public String getDesignerMetadata2(String formId, String designerMetaType, String lang, String srcFormId, String srcScriptId) {
        return this.innerGetDesignerMetadata(formId, designerMetaType, lang, srcFormId, srcScriptId);
    }

    /*
     * WARNING - void declaration
     */
    private String innerGetDesignerMetadata(String formId, String designerMetaType, String lang, String srcFormId, String srcScriptId) {
        void var18_28;
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        String propertyName = this.convertDesignerMetaType(designerMetaType);
        List<Object> srcJsPlugins = Collections.emptyList();
        if (StringUtils.isNotBlank((CharSequence)srcFormId)) {
            srcJsPlugins = this.getSrcJsPlugins(srcFormId, propertyName, srcScriptId);
        }
        MetadataReader reader = new MetadataReader(false, lang);
        AbstractMetadata metadata = reader.readMeta(id, OrmUtils.getDataEntityType(DesignFormMeta.class));
        Map content = metadata.buildDesignMeta(lang);
        if (MOB_META.equals(propertyName) && "MobileFormModel".equals(content.get("modelType"))) {
            Map formMetaMap = (Map)content.get(FORM_META);
            List items = (List)formMetaMap.get(ITEMS);
            Map rootApMap = (Map)items.get(0);
            ArrayList jsPlugins = (ArrayList)rootApMap.get("JsPlugins");
            if (jsPlugins == null) {
                jsPlugins = new ArrayList();
                rootApMap.put("JsPlugins", jsPlugins);
            }
            ArrayList srcJsPluginsMap = new ArrayList(srcJsPlugins.size());
            for (Plugin plugin : srcJsPlugins) {
                HashMap<String, Object> itemPlugin = new HashMap<String, Object>(8);
                itemPlugin.put("FPK", plugin.getFpk());
                itemPlugin.put("_Type_", plugin.getClass().getSimpleName());
                itemPlugin.put("SourceNumber", plugin.getSourceNumber());
                itemPlugin.put("ClassName", plugin.getClassName());
                itemPlugin.put("Enabled", plugin.isEnabled());
                itemPlugin.put("SourceName", plugin.getSourceName().getLocaleValue());
                srcJsPluginsMap.add(itemPlugin);
            }
            jsPlugins.addAll(srcJsPluginsMap);
            return SerializationUtils.toJsonString((Object)content);
        }
        Map formMeta = (Map)content.get(FORM_META);
        Map entityMeta = (Map)content.get(ENTITY_META);
        List items = (List)formMeta.get(ITEMS);
        Map formAp = (Map)items.get(0);
        String itemId = (String)formAp.get("Id");
        HashMap param = new HashMap(2);
        param.put(VALUE, formAp.get(propertyName));
        param.put(LANGUAGE, content.get(LANGUAGE));
        if (MOB_META.equals(propertyName)) {
            ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>(2);
            items = (List)formMeta.get(ITEMS);
            arrayList.add(items);
            arrayList.add((List<Object>)entityMeta.get(ITEMS));
            param.put(CONTEXT, arrayList);
        } else {
            param.put(CONTEXT, entityMeta.get(ITEMS));
        }
        if (MOB_META.equals(propertyName)) {
            Map<String, Object> map = this.loadDataMobMeta(param.get(CONTEXT), propertyName, param.get(VALUE), param.get(LANGUAGE).toString(), srcJsPlugins);
        } else {
            Map<String, Object> map = this.loadDataMobListMeta(param.get(CONTEXT), propertyName, param.get(VALUE), param.get(LANGUAGE).toString());
        }
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("itemId", itemId);
        params.put("metaType", FORM_META);
        var18_28.put("designerparams", params);
        var18_28.put("designer", propertyName);
        var18_28.put(ENTITY_META, entityMeta);
        return SerializationUtils.toJsonString((Object)var18_28);
    }

    private List<Plugin> getSrcJsPlugins(String srcFormId, String propertyName, String srcScriptId) {
        List srcJsPlugins = Collections.emptyList();
        AbstractMetadata meta = MetadataDao.readMeta((String)srcFormId, (MetaCategory)MetaCategory.Form);
        if (!(meta instanceof FormMetadata)) {
            return srcJsPlugins;
        }
        FormMetadata formMetadata = (FormMetadata)meta;
        if (MOB_META.equals(propertyName)) {
            ControlAp mobControlAp;
            FormMetadata mobMeta;
            ControlAp controlAp = (ControlAp)formMetadata.getItems().get(0);
            String sourceNumber = "";
            LocaleString sourceName = null;
            if (controlAp instanceof MobileFormAp || controlAp instanceof MobileBillFormAp) {
                FormAp rootAp = (FormAp)controlAp;
                srcJsPlugins = rootAp.getJsPlugins();
                sourceNumber = rootAp.getKey();
                sourceName = rootAp.getName();
            } else if (controlAp instanceof BillFormAp && (mobMeta = ((BillFormAp)controlAp).getMobMeta()) != null && (mobControlAp = (ControlAp)mobMeta.getItems().get(0)) instanceof FormAp) {
                FormAp mobFormAp = (FormAp)mobControlAp;
                srcJsPlugins = mobFormAp.getJsPlugins();
                sourceNumber = mobFormAp.getKey();
                sourceName = mobFormAp.getName();
            }
            if (CollectionUtils.isEmpty((Collection)srcJsPlugins)) {
                Plugin jsPlugin = new Plugin();
                jsPlugin.setFpk(srcScriptId);
                jsPlugin.setEnabled(true);
                jsPlugin.setClassName(srcFormId + "_mob_" + srcScriptId);
                jsPlugin.setSourceNumber(sourceNumber);
                jsPlugin.setSourceName(sourceName);
                srcJsPlugins.add(jsPlugin);
            }
        }
        return srcJsPlugins;
    }

    public Map<String, Object> getFiledByFormMetadata(Map<String, Object> filed, FormMetadata formMetadata) {
        if (formMetadata == null) {
            return filed;
        }
        String id = (String)filed.get("id");
        List controlAps = formMetadata.getItems();
        for (ControlAp controlAp : controlAps) {
            if (!(controlAp instanceof FieldAp) || !id.equals(controlAp.getId())) continue;
            filed.put("name", controlAp.getName().getLocaleValue_zh_CN());
            break;
        }
        return filed;
    }

    private List<String> getFiledRelevanceControlApList(FormMetadata formMetadata, Map<String, Object> filedMap) {
        String filedId = (String)filedMap.get("id");
        String key = (String)filedMap.get("key");
        ArrayList<String> returnList = new ArrayList<String>();
        if (formMetadata == null) {
            return returnList;
        }
        List controlApList = formMetadata.getItems();
        boolean bol = false;
        String fieldKey = "";
        for (ControlAp controlAp : controlApList) {
            if (controlAp instanceof FieldAp) {
                if (((FieldAp)controlAp).getFieldId().contains(filedId)) {
                    bol = true;
                }
            } else if (controlAp instanceof ListColumnAp) {
                fieldKey = ((ListColumnAp)controlAp).getListFieldId();
                bol = this.isFiledRelevanceControlAp(fieldKey, key);
            } else if (controlAp instanceof ComboListColumnAp) {
                fieldKey = ((ComboListColumnAp)controlAp).getListFieldId();
                bol = this.isFiledRelevanceControlAp(fieldKey, key);
            } else if (controlAp instanceof SchemeFilterColumnAp) {
                fieldKey = ((SchemeFilterColumnAp)controlAp).getFieldName();
                bol = this.isFiledRelevanceControlAp(fieldKey, key);
            } else if (controlAp instanceof CardListColumnAp) {
                fieldKey = ((CardListColumnAp)controlAp).getListFieldId();
                bol = this.isFiledRelevanceControlAp(fieldKey, key);
            } else if (controlAp instanceof FilterColumnAp) {
                fieldKey = ((FilterColumnAp)controlAp).getFieldName();
                bol = this.isFiledRelevanceControlAp(fieldKey, key);
            } else if (controlAp instanceof MobSortColumnAp) {
                fieldKey = ((MobSortColumnAp)controlAp).getFieldName();
                bol = this.isFiledRelevanceControlAp(fieldKey, key);
            }
            if (!bol) continue;
            returnList.add(controlAp.getId());
            bol = false;
        }
        return returnList;
    }

    private boolean isFiledRelevanceControlAp(String fieldKey, String key) {
        return fieldKey.split("\\.")[0].equals(key) || fieldKey.split("_")[0].equals(key) || fieldKey.split("-")[0].equals(key) || fieldKey.startsWith(key);
    }

    private String convertDesignerMetaType(String templateType) {
        String result = templateType;
        switch (templateType) {
            case "MobileFormAp": 
            case "MobileBillFormAp": {
                result = MOB_META;
                break;
            }
            case "MobileListFormAp": {
                result = "MobListMeta";
                break;
            }
        }
        return result;
    }

    private Map<String, Object> loadDataMobMeta(Object context, String propertyName, Object value, String lang, List<Plugin> srcJsPlugins) {
        Map<String, Object> tMap;
        if (context instanceof List) {
            HashMap<String, Object> entityMeta = new HashMap<String, Object>();
            entityMeta.put(ITEMS, ((List)context).get(1));
            entityMeta.put("_Type_", "EntityMetadata");
            Map formmeta = null;
            if (value instanceof Map) {
                formmeta = (Map)value;
            }
            Map item = (Map)((List)((List)context).get(0)).get(0);
            String id = (String)item.get("Id");
            String key = item.get("Key") + "_mob";
            tMap = this.createMobFormMetadataMobBill(id, key, formmeta, entityMeta, lang, srcJsPlugins);
        } else {
            tMap = new HashMap<String, Object>();
        }
        return tMap;
    }

    private Map<String, Object> loadDataMobListMeta(Object context, String propertyName, Object value, String lang) {
        Map formmeta = null;
        boolean isMob = "MobListMeta".equals(propertyName);
        Map<String, Object> tMap = new HashMap<String, Object>();
        if (value instanceof Map) {
            if (!isMob) {
                Map mapName = (Map)value;
                String billName = (String)((Map)((List)context).get(0)).get("Name");
                ((Map)((List)mapName.get(ITEMS)).get(0)).put("Name", billName);
                formmeta = mapName;
            } else {
                formmeta = (Map)value;
            }
        }
        if (isMob) {
            tMap = this.createMobFormMetadataMobList(formmeta, (List)context, lang);
        }
        return tMap;
    }

    private Map<String, Object> createMobFormMetadataMobBill(String id, String key, Map<String, Object> srcFormmeta, Map<String, Object> srcEntityMeta, String lang, List<Plugin> srcJsPlugins) {
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)"MobileBillFormModel"));
        FormMetadata formMeta = null;
        Objects.requireNonNull(srcFormmeta);
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        formMeta = (FormMetadata)ser.deserializeFromMap(srcFormmeta, null);
        formMeta.setId(id);
        formMeta.setKey(key);
        formMeta.getRootAp().setLanguage(lang);
        formMeta.getRootAp().setJsPlugins(srcJsPlugins);
        EntityMetadata entityMeta = (EntityMetadata)ser.deserializeFromMap(srcEntityMeta, null);
        entityMeta.setId(entityMeta.getRootEntity().getId());
        formMeta.setEntityId(entityMeta.getRootEntity().getId());
        formMeta.bindEntityMetadata(entityMeta);
        HashMap<String, Object> tMap = new HashMap<String, Object>(8);
        tMap.put("entityreadonly", true);
        tMap.put("entitytree", entityMeta.buildDesgnerTree());
        tMap.put("id", formMeta.getId());
        binder.setWriteInheritFlag(true);
        tMap.put(ENTITY_META, ser.serializeToMap((Object)entityMeta, null));
        tMap.put("ui", formMeta.builderDesgnerControls());
        tMap.put(FORM_META, ser.serializeToMap((Object)formMeta, null));
        tMap.put("islayout", true);
        tMap.put("isPC", false);
        return tMap;
    }

    private Map<String, Object> createMobFormMetadataMobList(Map<String, Object> srcFormmeta, List<Map<String, Object>> context, String lang) {
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)"MobileListModel"));
        FormMetadata formMeta = null;
        String name = "";
        String entityId = null;
        if (context != null && !context.isEmpty()) {
            Map<String, Object> curItem = context.get(0);
            name = (String)curItem.get("Name");
            entityId = (String)curItem.get("Id");
        }
        Objects.requireNonNull(srcFormmeta);
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        formMeta = (FormMetadata)ser.deserializeFromMap(srcFormmeta, null);
        formMeta.createIndex();
        formMeta.getRootAp().setLanguage(lang);
        HashMap<String, Object> tMap = new HashMap<String, Object>(8);
        tMap.put("entityreadonly", true);
        tMap.put("entitytree", EntityMetadataUtil.getlistFieldTree(context));
        tMap.put("id", formMeta.getId());
        tMap.put("ui", formMeta.builderDesgnerControls());
        binder.setWriteInheritFlag(true);
        tMap.put(FORM_META, ser.serializeToMap((Object)formMeta, null));
        tMap.put("islayout", true);
        tMap.put("isPC", false);
        return tMap;
    }

    public Map<String, List<String>> getEnabledControlsMap(String formId) {
        return reader.getEnabledControlsMap(formId);
    }

    public String loadFormFunctions(String formId) {
        FormFunctionInfo formFunctionInfo = new FormFunctionInfo();
        formFunctionInfo.setFormId(formId);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        if (formConfig == null || formConfig.getAppId() == null) {
            return null;
        }
        formFunctionInfo.setFormName(formConfig.getCaption().getLocaleValue());
        String appId = formConfig.getBizAppNumber();
        AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)appId);
        if (appInfo == null || appInfo.getCloudId() == null) {
            return null;
        }
        StringBuilder appNameBuilder = new StringBuilder();
        appNameBuilder.append(appInfo.getName().getLocaleValue());
        formFunctionInfo.setAppName(appNameBuilder.toString());
        String clientFormMetaStr = this.loadClientFormMeta(formId);
        if (StringUtils.isNotBlank((CharSequence)clientFormMetaStr)) {
            ArrayList functionForms = new ArrayList(16);
            Map clientFormMeta = (Map)SerializationUtils.fromJsonString((String)clientFormMetaStr, Map.class);
            formFunctionInfo.findFunctionLists(clientFormMeta, functionForms);
            formFunctionInfo.setFunctionForms(functionForms);
        }
        ArrayList functionLists = new ArrayList(16);
        Map listToolBarMeta = FormMetadataCache.getListToolBar((String)formId);
        formFunctionInfo.findFunctionLists(listToolBarMeta, functionLists);
        formFunctionInfo.setFunctionLists(functionLists);
        return SerializationUtils.toJsonString((Object)formFunctionInfo);
    }

    public boolean checkPermission(Long userId, Long orgId, String appId, String entityNum, String permItemId) {
        int flag = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)appId, (String)entityNum, (String)permItemId);
        return flag == 1;
    }

    public List<Map<String, Object>> getIndustryVersion(String productNumber) {
        try {
            List infos = IndustryVersionServiceHelper.getVersion((String)productNumber);
            if (infos.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(infos.size());
            for (IndustryVersionInfo info : infos) {
                HashMap<String, String> v = new HashMap<String, String>(2);
                v.put("version", info.getVersion());
                v.put("upgradeTime", info.getUpgradeTime());
                v.put("isv", info.getIsv());
                datas.add(v);
            }
            return datas;
        }
        catch (Exception e) {
            log.error("getIndustryVersion error ", (Throwable)e);
            return super.getIndustryVersion(productNumber);
        }
    }

    public Map<String, List<String>> getDataEntityOperationKeys(Collection<String> entityNumbers) {
        return MetadataServiceImpl.getInstance().getDataEntityOperationKeys(entityNumbers);
    }

    static /* synthetic */ boolean access$002(boolean x0) {
        rebuildNoDiffVer = x0;
        return rebuildNoDiffVer;
    }

    static /* synthetic */ String access$100() {
        return rebuild_no_diff_ver;
    }

    static {
        MAX_Threads = 5;
        rebuild_thread_core = "rebuild.thread.core";
        MAX_Threads = Integer.parseInt(System.getProperty(rebuild_thread_core, "5"));
        es = ThreadPools.newExecutorService((String)"metadatabuilder", (int)MAX_Threads);
        rebuildNoDiffVer = false;
        rebuild_no_diff_ver = "rebuild.no.diff.ver";
        rebuildNoDiffVer = Boolean.parseBoolean(System.getProperty(rebuild_no_diff_ver));
        ConfigurationUtil.observeChange((String)rebuild_no_diff_ver, (ConfigurationChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }
}

