/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.ColumnParam;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.UserProp;
import kd.bos.filter.DefaultHiddenField;
import kd.bos.filter.DependField;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterSchemeUIProxy;
import kd.bos.filter.ListSysPublicParameter;
import kd.bos.filter.OrgDependField;
import kd.bos.filter.helper.DataPermFilterHelper;
import kd.bos.filter.helper.QueryBaseDataParameter;
import kd.bos.filter.helper.QueryBaseDataParameterWithTopSize;
import kd.bos.filter.mcontrol.MobCommonFilterColumn;
import kd.bos.form.CoreSingleOrgContextHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class CommonFilterColumn
extends FilterColumn {
    private static final int TOPSIZE = 20;
    private boolean isNeedNoLimitOption = true;
    private static final String VALUE = "value";
    private static final String CATION = "caption";
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final String COMPARE = "compare";
    private List<Object> selectedCommomFilterFieldValues = new ArrayList<Object>();
    private boolean canRemove = true;
    private String defValue;
    private boolean mustInput;
    private boolean isMulti;
    private boolean isCustom;
    private boolean defCollapse = false;
    private boolean isAdvField = false;
    private boolean multiLine = false;
    @SdkInternal
    protected List<ComboItem> comboItems = new ArrayList<ComboItem>();
    private List<Consumer<SetFilterEvent>> setFilterListeners = new ArrayList<Consumer<SetFilterEvent>>();
    private boolean isLazyLoadMissing;
    private boolean isNeedLoadMissing = true;
    private String compareType;
    private Map<String, List<DependField>> dependFieldMap = new HashMap<String, List<DependField>>();
    private Map<String, List<Object>> commonFilters = new HashMap<String, List<Object>>();
    private List<String> topPkList = new ArrayList<String>();
    private boolean hasInit;
    private List<QFilter> initQFilters = new ArrayList<QFilter>();
    private String orderBy;
    private List<QFilter> pluginInitQFilters = new ArrayList<QFilter>(10);
    private FilterField realFilterField;

    @SdkInternal
    protected void setNeedNoLimitOption(boolean isNeedNoLimitOption) {
        this.isNeedNoLimitOption = isNeedNoLimitOption;
    }

    @SdkInternal
    protected void setSelectedCommomFilterFieldValues(List<Object> selectedCommomFilterFieldValues) {
        this.selectedCommomFilterFieldValues = selectedCommomFilterFieldValues;
    }

    public CommonFilterColumn() {
    }

    public CommonFilterColumn(String fieldName) {
        super(fieldName);
    }

    @SimplePropertyAttribute(name="CanRemove")
    @DefaultValueAttribute(value="true")
    public boolean isCanRemove() {
        return this.canRemove;
    }

    public void setCanRemove(boolean canRemove) {
        this.canRemove = canRemove;
    }

    @SdkInternal
    @SimplePropertyAttribute
    public String getDefValue() {
        return this.defValue;
    }

    @SdkInternal
    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    @SimplePropertyAttribute(name="MustInput")
    public boolean isMustInput() {
        return this.mustInput;
    }

    public void setMustInput(boolean value) {
        this.mustInput = value;
    }

    @SimplePropertyAttribute(name="Multi")
    public boolean isMulti() {
        return this.isMulti;
    }

    public void setMulti(boolean isMulti) {
        this.isMulti = isMulti;
    }

    @SdkInternal
    @SimplePropertyAttribute(name="Custom")
    public boolean isCustom() {
        return this.isCustom;
    }

    @SdkInternal
    public void setCustom(boolean isCustom) {
        this.isCustom = isCustom;
    }

    @SdkInternal
    @SimplePropertyAttribute
    public boolean isDefCollapse() {
        return this.defCollapse;
    }

    @SdkInternal
    public void setDefCollapse(boolean defCollapse) {
        this.defCollapse = defCollapse;
    }

    @SimplePropertyAttribute(name="AdvField")
    @SdkInternal
    public boolean isAdvField() {
        return this.isAdvField;
    }

    @SdkInternal
    public void setAdvField(boolean advField) {
        this.isAdvField = advField;
    }

    @SimplePropertyAttribute
    @SdkInternal
    public boolean isMultiLine() {
        return this.multiLine;
    }

    @SdkInternal
    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ComboItem.class)
    @SdkInternal
    public List<ComboItem> getComboItems() {
        return this.comboItems;
    }

    @KSMethod
    public void setComboItems(List<ComboItem> comboItems) {
        this.comboItems = comboItems;
    }

    public void addSetFilterListeners(Consumer<SetFilterEvent> setFilterListener) {
        this.setFilterListeners.add(setFilterListener);
    }

    public List<Consumer<SetFilterEvent>> getSetFilterListeners() {
        return this.setFilterListeners;
    }

    public void setSetFilterListeners(List<Consumer<SetFilterEvent>> setFilterListeners) {
        this.setFilterListeners = setFilterListeners;
    }

    void setNeedLoadMissing(boolean needLoadMissing) {
        this.isNeedLoadMissing = needLoadMissing;
    }

    @Override
    public void setDefaultValues(List<Object> defaultValues) {
        super.setDefaultValues(defaultValues);
        if (this.dependFieldMap.containsKey(this.getFieldName()) || this.context != null && !this.context.getControlFiltersMap().containsKey(this.getFilterFieldName()) || this.context == null) {
            this.addCommonFilter(this.getFieldName(), this.getDefaultValues());
        }
        if (this.entityType == null || !this.isEntityField() || this.getFilterField() == null) {
            return;
        }
        if (this.isBaseDataProp() && this.isNeedLoadMissing) {
            if (this.hasInit) {
                this.loadMissingDataItems(defaultValues);
            } else {
                this.isLazyLoadMissing = true;
            }
        } else if (this.getLatestParent() instanceof IRefBillField) {
            this.loadMissingDataItemsByRefBillField(defaultValues, (IRefBillField)this.getLatestParent());
        }
    }

    private void loadMissingDataItems(List<Object> defaultValues) {
        IDataEntityProperty latestParent = this.getLatestParent();
        if (latestParent instanceof UserProp && !FilterSchemeUIProxy.isNeedShareScheme()) {
            return;
        }
        ArrayList<Object> missingPkIds = new ArrayList<Object>();
        HashMap<String, ComboItem> comboItemMap = new HashMap<String, ComboItem>(16);
        IBasedataField basedataProp = (IBasedataField)latestParent;
        int dbType = basedataProp.getComplexType().getPrimaryKey().getDbType();
        for (ComboItem comboItem : this.getComboItems()) {
            comboItemMap.put(comboItem.getValue(), comboItem);
        }
        for (Object defaultValue : defaultValues) {
            if (!StringUtils.isNotBlank((Object)defaultValue) || this.topPkList.contains(defaultValue.toString()) || comboItemMap.containsKey(defaultValue)) continue;
            missingPkIds.add(DbTypeConverter.safeConvert((int)dbType, (Object)defaultValue));
        }
        if (!missingPkIds.isEmpty()) {
            BasedataEntityType dt = this.getBaseDataEntityType((IBasedataField)latestParent);
            String pkField = dt.getPrimaryKey().getName();
            ArrayList<ComboItem> dataItems = new ArrayList<ComboItem>();
            String nameField = this.getNameField((IBasedataField)latestParent, dt, pkField);
            ArrayList<String> selectFields = new ArrayList<String>();
            String pkWithMaster = this.getSelectFieldsWithMaster(dt, pkField);
            String nameWithMaster = this.getSelectFieldsWithMaster(dt, nameField);
            selectFields.add(pkWithMaster);
            selectFields.add(nameWithMaster);
            MainEntityType mainEntityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)dt.getName(), selectFields);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(this.initQFilters.size() + 1);
            qFilters.addAll(this.initQFilters);
            qFilters.addAll(this.getDependQFilters());
            qFilters.add(new QFilter(pkWithMaster, "in", (Object)missingPkIds.toArray()));
            Map filterSchemeMap = BusinessDataReader.loadFromCache((String)dt.getName(), (String)String.join((CharSequence)",", selectFields), (QFilter[])qFilters.toArray(new QFilter[0]));
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection((DynamicObjectType)mainEntityType, null);
            dynamicObjectCollection.addAll(filterSchemeMap.values());
            this.createBaseDataComboItems(dataItems, pkWithMaster, nameWithMaster, dynamicObjectCollection);
            this.getComboItems().addAll(dataItems);
            for (Object e : missingPkIds) {
                this.topPkList.add(e.toString());
            }
        }
    }

    private void loadMissingDataItemsByRefBillField(List<Object> defaultValues, IRefBillField refBillField) {
        ArrayList<Object> missingPkIds = new ArrayList<Object>();
        HashMap<String, ComboItem> comboItemMap = new HashMap<String, ComboItem>(16);
        int dbType = refBillField.getComplexType().getPrimaryKey().getDbType();
        for (ComboItem comboItem : this.getComboItems()) {
            comboItemMap.put(comboItem.getValue(), comboItem);
        }
        for (Object defaultValue : defaultValues) {
            if (!StringUtils.isNotBlank((Object)defaultValue) || this.topPkList.contains(defaultValue.toString()) || comboItemMap.containsKey(defaultValue)) continue;
            missingPkIds.add(DbTypeConverter.safeConvert((int)dbType, (Object)defaultValue));
        }
        if (!missingPkIds.isEmpty()) {
            BillEntityType dt = (BillEntityType)refBillField.getComplexType();
            String nameField = dt.getBillNo();
            ArrayList<String> selectFields = new ArrayList<String>();
            selectFields.add("id");
            selectFields.add(nameField);
            MainEntityType mainEntityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)dt.getName(), selectFields);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(this.initQFilters.size() + 1);
            qFilters.addAll(this.initQFilters);
            qFilters.addAll(this.getDependQFilters());
            qFilters.add(new QFilter("id", "in", (Object)missingPkIds.toArray()));
            Map filterSchemeMap = BusinessDataReader.loadFromCache((String)dt.getName(), (String)String.join((CharSequence)",", selectFields), (QFilter[])qFilters.toArray(new QFilter[0]));
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection((DynamicObjectType)mainEntityType, null);
            dynamicObjectCollection.addAll(filterSchemeMap.values());
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String pkId = dynamicObject.getString(dt.getPrimaryKey().getName());
                String billNo = dynamicObject.getString(dt.getBillNo());
                ComboItem comboItem = new ComboItem(new LocaleString(billNo), pkId);
                this.getComboItems().add(comboItem);
            }
            for (Object e : missingPkIds) {
                this.topPkList.add(e.toString());
            }
        }
    }

    public void setConstantDefaultValue(Object defaultValue) {
        this.setNeedLoadMissing(false);
        this.setDefaultValues(defaultValue);
        if (defaultValue != null) {
            this.compareType = defaultValue.toString();
        }
        this.setNeedLoadMissing(true);
    }

    @Override
    protected List<Object> getCompares() {
        List<Object> compares = super.getCompares();
        if (this.compareType != null) {
            compares.add(this.compareType);
        }
        return compares;
    }

    @Override
    public Map<String, Object> createColumn() {
        Map<String, Object> map = super.createColumn();
        ArrayList<Map<String, Object>> clientItems = new ArrayList<Map<String, Object>>(this.getClientItems());
        if (this.isEntityField() && this.getFilterField() != null && this.getLatestParent() instanceof ItemClassTypeProp) {
            this.setMulti(false);
        }
        map.put("isMulti", this.isMulti());
        this.addNoLimitOption(clientItems);
        this.addConstant(clientItems);
        map.put("items", clientItems);
        map.put("isCustom", this.isCustom);
        map.put("mustInput", this.mustInput);
        map.put("defaultValues", super.getDefaultValues());
        if (this.isAdvField()) {
            map.put("advField", true);
            map.put("defaultcollapse", this.isDefCollapse());
            map.put("multiLine", this.isMultiLine());
        }
        this.fireAfterCreateColumn(clientItems, map);
        return map;
    }

    Map<String, Object> createCommonFilterConfig(List<DefaultHiddenField> defaultHiddenFields) {
        HashMap<String, Object> commonFilterConfig = new HashMap<String, Object>();
        commonFilterConfig.put("v", this.isMustInput() || !defaultHiddenFields.stream().anyMatch(t -> t.getFieldName().equals(this.getFieldName())) ? 1 : 0);
        commonFilterConfig.put("n", this.getFilterFieldName());
        commonFilterConfig.put("c", this.getCaption());
        commonFilterConfig.put("h", this.isMustInput() || !this.isCanRemove() ? 0 : 1);
        return commonFilterConfig;
    }

    protected void fireAfterCreateColumn(List<Map<String, Object>> clientItems, Map<String, Object> map) {
        IDataEntityProperty prop = this.getLatestParent();
        if (prop instanceof BasedataProp) {
            BasedataProp bProp = (BasedataProp)prop;
            ColumnParam param = new ColumnParam(true);
            param.setClientItems(clientItems);
            bProp.afterCreateFilterColumn(map, param);
        }
    }

    protected List<ComboItem> getComboItems(ComboProp comboProp) {
        ArrayList<ComboItem> thisComboItems = new ArrayList<ComboItem>(10);
        List valueMapItems = comboProp.getComboItems();
        for (ValueMapItem valueMapItem : valueMapItems) {
            ComboItem comboItem = new ComboItem(valueMapItem.getName(), valueMapItem.getValue());
            thisComboItems.add(comboItem);
        }
        return thisComboItems;
    }

    @SdkInternal
    protected void setDependFieldMap(Map<String, List<DependField>> dependFieldMap) {
        this.dependFieldMap = dependFieldMap;
    }

    @SdkInternal
    protected void setCommonFilters(Map<String, List<Object>> commonFilters) {
        this.commonFilters = commonFilters;
    }

    @SdkInternal
    protected Map<String, List<Object>> getCommonFilters() {
        return this.commonFilters;
    }

    void addCommonFilter(String fieldName, List<Object> filterValues) {
        this.commonFilters.put(fieldName, filterValues);
    }

    private FilterColumnSetFilterEvent getSetFilterEvent(Object field, String orderBy) {
        List<QFilter> filters = null;
        String entityNmber = "";
        if (field instanceof IBasedataField) {
            IBasedataField basedataProp = (IBasedataField)field;
            filters = this.getFilter0(basedataProp);
            entityNmber = basedataProp.getBaseEntityId();
            if (basedataProp instanceof MasterBasedataProp) {
                entityNmber = ((MasterBasedataProp)basedataProp).getParent().getName();
            }
        } else if (field instanceof IRefBillField) {
            IRefBillField refBillProp = (IRefBillField)field;
            filters = this.getFilter0(refBillProp);
            entityNmber = refBillProp.getBillEntityId();
        }
        FilterColumnSetFilterEvent setFilterEvent = new FilterColumnSetFilterEvent((Object)this, filters, orderBy, this.getCommonFilters());
        QFilter specialDataPermQFilter = PermissionFilterUtil.getSpecialDataPermissionFilter((String)this.getAppId(), (String)entityNmber, (String)"view", (ITimeService)((ITimeService)this.getView().getService(ITimeService.class)), (IUserService)((IUserService)this.getView().getService(IUserService.class)));
        setFilterEvent.setSpecialDataPermQFilter(specialDataPermQFilter);
        return setFilterEvent;
    }

    private void fireSetFilterListeners(SetFilterEvent setFilterEvent) {
        for (Consumer<SetFilterEvent> consumer : this.setFilterListeners) {
            consumer.accept(setFilterEvent);
        }
    }

    void clearTopPkList() {
        this.topPkList.clear();
    }

    protected List<ComboItem> getAddtionalItems(QueryBaseDataParameter parameterObject, String pkField, int pkDbType, List<String> pkList, String nameField) {
        ArrayList<ComboItem> dataItems = new ArrayList<ComboItem>();
        ArrayList<Object> missingPkIds = new ArrayList<Object>();
        for (Object selectedCommomFilterFieldValue : this.selectedCommomFilterFieldValues) {
            if (pkList.contains(selectedCommomFilterFieldValue)) continue;
            missingPkIds.add(DbTypeConverter.safeConvert((int)pkDbType, (Object)selectedCommomFilterFieldValue));
        }
        if (missingPkIds.isEmpty()) {
            return dataItems;
        }
        parameterObject.addQfilter(new QFilter(pkField, "in", missingPkIds));
        DynamicObjectCollection queryBaseDataCollections = DataPermFilterHelper.queryBaseData((QueryBaseDataParameterWithTopSize)new QueryBaseDataParameterWithTopSize(parameterObject, this.getShowFormCustomParams(), this.getRealBasedataEntityType(), (Control)this, 20));
        List<String> otherPkList = this.createBaseDataComboItems(dataItems, pkField, nameField, queryBaseDataCollections);
        this.topPkList.addAll(otherPkList);
        return dataItems;
    }

    private String getDisplayNameValue(DynamicObject dynamicObject, String nameField) {
        StringBuilder displayNameValue = new StringBuilder();
        if (nameField.split("\\,").length > 1) {
            for (String thisNameField : nameField.split("\\,")) {
                displayNameValue.append(dynamicObject.getString(thisNameField));
                displayNameValue.append(' ');
            }
        } else {
            displayNameValue.append(dynamicObject.getString(nameField));
            displayNameValue.append(' ');
        }
        return displayNameValue.toString();
    }

    private List<ComboItem> getBaseDataItems(IBasedataField basedataProp) {
        ArrayList<ComboItem> dataItems = new ArrayList<ComboItem>();
        BasedataEntityType dt = this.getBaseDataEntityType(basedataProp);
        String nameField = this.getNameField(basedataProp, dt, dt.getPrimaryKey().getName());
        QueryBaseDataParameter parameterObject = this.createQueryBaseDataParameter(basedataProp, dt, nameField, null, new ArrayList<QFilter>());
        if (!(this.getLatestParent() instanceof UserProp)) {
            String pkWithMaster = this.getSelectFieldsWithMaster(dt, dt.getPrimaryKey().getName());
            String nameWithMaster = this.getSelectFieldsWithMaster(dt, nameField);
            List<String> pkList = this.createBaseDataComboItems(dataItems, pkWithMaster, nameWithMaster, this.queryBaseDataCollections(basedataProp, dt, parameterObject, 20));
            this.topPkList.clear();
            this.topPkList.addAll(pkList);
            dataItems.addAll(this.getAddtionalItems(parameterObject, pkWithMaster, dt.getPrimaryKey().getDbType(), pkList, nameWithMaster));
        }
        return dataItems;
    }

    private List<ComboItem> getRefBillItems(IRefBillField refBillProp) {
        BillEntityType dt = (BillEntityType)refBillProp.getComplexType();
        FilterColumnSetFilterEvent setFilterEvent = this.getSetFilterEvent(refBillProp, dt.getPrimaryKey().getName());
        this.fireSetFilterListeners((SetFilterEvent)setFilterEvent);
        List listFilters = setFilterEvent.getMergeQFilters();
        QFilter dataQFilter = this.getDataRuleQFilterByRefBillField(refBillProp);
        if (dataQFilter != null) {
            listFilters.add(dataQFilter);
        }
        ArrayList<ComboItem> dataItems = new ArrayList<ComboItem>();
        String billEntityId = refBillProp.getBillEntityId();
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("kd.bos.filter.CommonFilterColumn." + billEntityId, billEntityId, dt.getPrimaryKey().getName() + "," + dt.getBillNo(), listFilters.toArray(new QFilter[0]), setFilterEvent.getOrderBy(), 20);){
            DynamicObjectCollection dynamicObjectCollection = orm.toPlainDynamicObjectCollection(ds);
            ArrayList<String> pkList = new ArrayList<String>(dynamicObjectCollection.size());
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String pkId = dynamicObject.getString(dt.getPrimaryKey().getName());
                String billNo = dynamicObject.getString(dt.getBillNo());
                ComboItem comboItem = new ComboItem(new LocaleString(billNo), pkId);
                dataItems.add(comboItem);
                pkList.add(pkId);
            }
            this.topPkList.clear();
            this.topPkList.addAll(pkList);
        }
        return dataItems;
    }

    List<QFilter> getCommonInitFilters() {
        return this.initQFilters;
    }

    List<QFilter> getPluginInitQFilters() {
        return this.pluginInitQFilters;
    }

    @Override
    protected QueryBaseDataParameter createQueryBaseDataParameter(IBasedataField basedataProp, BasedataEntityType dt, String nameField, String inSelectFields, List<QFilter> inQfilters) {
        String baseDataEntityId = dt.getName();
        StringBuilder selectFields = this.getSelectFields(dt, nameField);
        List<Object> qfilters = new ArrayList<QFilter>(inQfilters);
        if (!this.hasInit) {
            String defaultOrderBy = dt.getNumberProperty();
            Map enableF7SchemeMap = (Map)ListSysPublicParameter.loadCustom((String)"enableBasedataOrderById");
            if (enableF7SchemeMap != null && "1".equals(enableF7SchemeMap.getOrDefault("enableBasedataOrderById", "0"))) {
                defaultOrderBy = dt.getPrimaryKey().getName();
            }
            FilterColumnSetFilterEvent setFilterEvent = this.getSetFilterEvent(basedataProp, basedataProp instanceof OrgProp ? "" : defaultOrderBy);
            List mergeQFilters = setFilterEvent.getMergeQFilters();
            this.fireSetFilterListeners((SetFilterEvent)setFilterEvent);
            HashSet<QFilter> existsInitQFilters = new HashSet<QFilter>(16);
            for (QFilter qFilter : mergeQFilters) {
                existsInitQFilters.add(qFilter);
            }
            qfilters = setFilterEvent.getMergeQFilters();
            for (QFilter qFilter : qfilters) {
                if (!existsInitQFilters.add(qFilter)) continue;
                this.pluginInitQFilters.add(qFilter);
            }
            this.initQFilters.addAll(qfilters);
            this.orderBy = setFilterEvent.getOrderBy();
            this.hasInit = true;
        } else {
            qfilters.addAll(this.initQFilters);
        }
        return new QueryBaseDataParameter(qfilters, this.orderBy, baseDataEntityId, StringUtils.isNotBlank((CharSequence)inSelectFields) ? inSelectFields : selectFields.toString());
    }

    @Override
    FilterField getOrgFieldField() {
        return super.getOrgFieldField();
    }

    protected List<String> createBaseDataComboItems(List<ComboItem> dataItems, String pkField, String nameField, DynamicObjectCollection dynamicObjectCollection) {
        ArrayList<String> pkList = new ArrayList<String>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String pkId = dynamicObject.getString(pkField);
            pkList.add(pkId);
            ComboItem comboItem = new ComboItem(new LocaleString(this.getDisplayNameValue(dynamicObject, nameField)), pkId);
            dataItems.add(comboItem);
        }
        return pkList;
    }

    @Override
    String getItemClassTypeEntityId(ItemClassProp itemClassProp) {
        String typePropName = itemClassProp.getTypePropName();
        List<Object> itemTypeList = this.getCommonFilters().get(typePropName);
        if (itemTypeList != null && !itemTypeList.isEmpty() && StringUtils.isNotEmpty((CharSequence)itemTypeList.get(0).toString())) {
            return itemTypeList.get(0).toString();
        }
        return super.getItemClassTypeEntityId(itemClassProp);
    }

    @Override
    protected BasedataEntityType getBaseDataEntityType(IBasedataField basedataProp) {
        String itemClassTypeEntityId;
        BasedataEntityType complexType = super.getBaseDataEntityType(basedataProp);
        if (basedataProp instanceof ItemClassProp && (itemClassTypeEntityId = this.getItemClassTypeEntityId((ItemClassProp)basedataProp)) != null) {
            complexType = EntityMetadataCache.getDataEntityType((String)itemClassTypeEntityId);
        }
        return complexType;
    }

    @SdkInternal
    protected void addNoLimitOption(List<Map<String, Object>> clientItems) {
        ComboItem comboItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"CommonFilterColumn_0", (String)BOS_FORM_CORE, (Object[])new Object[0])), "");
        if (this.isNeedNoLimitOption && !this.mustInput && !this.comboItems.contains(comboItem)) {
            this.comboItems.add(0, comboItem);
            HashMap<String, Object> clientItem = new HashMap<String, Object>();
            clientItem.put(CATION, comboItem.getCaption());
            clientItem.put(VALUE, comboItem.getValue());
            clientItem.put(COMPARE, comboItem.getValue());
            if (this instanceof MobCommonFilterColumn) {
                clientItem.put("vi", true);
            }
            clientItems.add(0, clientItem);
        }
    }

    @SdkInternal
    protected void addConstant(List<Map<String, Object>> clientItems) {
        if (this.getFilterField() != null && this.getLatestParent() instanceof UserProp && this.getFilterField().getFieldProp() instanceof PKFieldProp) {
            ComboItem comboItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237", (String)"CommonFilterColumn_1", (String)BOS_FORM_CORE, (Object[])new Object[0])), "103");
            this.comboItems.add(comboItem);
            HashMap<String, Object> clientItem = new HashMap<String, Object>();
            clientItem.put(CATION, comboItem.getCaption());
            clientItem.put(VALUE, comboItem.getValue());
            clientItem.put(COMPARE, comboItem.getValue());
            clientItems.add(clientItem);
            comboItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u7528\u6237", (String)"CommonFilterColumn_2", (String)BOS_FORM_CORE, (Object[])new Object[0])), "104");
            this.comboItems.add(comboItem);
            clientItem = new HashMap();
            clientItem.put(CATION, comboItem.getCaption());
            clientItem.put(VALUE, comboItem.getValue());
            clientItem.put(COMPARE, comboItem.getValue());
            clientItems.add(clientItem);
        }
    }

    @SdkInternal
    protected List<Map<String, Object>> getClientItems() {
        ArrayList<Map<String, Object>> clientItems = new ArrayList<Map<String, Object>>(10);
        for (ComboItem comboItem : this.comboItems) {
            HashMap<String, Object> clientItem = new HashMap<String, Object>();
            clientItem.put(CATION, comboItem.getCaption());
            clientItem.put(VALUE, comboItem.getValue());
            if (this instanceof MobCommonFilterColumn) {
                clientItem.put("vi", comboItem.isItemVisible());
            }
            clientItems.add(clientItem);
        }
        return clientItems;
    }

    @Override
    public void initProperties() {
        if (this.isEntityField()) {
            super.initProperties();
            if (this.comboItems.isEmpty()) {
                this.comboItems.addAll(this.getRunTimeComboItems());
            }
            this.addCustomCompareTypes();
        }
        if (!this.context.isLookup() && this.context.isInitDefaultValues()) {
            this.initDefaultValues();
        }
    }

    @Override
    void fixContext() {
        super.fixContext();
        if (this.isNewAdded()) {
            this.addCustomCompareTypes();
        }
    }

    private void addCustomCompareTypes() {
        ArrayList<ComboItem> customCompareTypeComboItems = new ArrayList<ComboItem>(10);
        for (CompareType customCompareType : this.getCustomCompareTypes()) {
            if (customCompareType.isNeedInput()) continue;
            ComboItem comboItem = new ComboItem(customCompareType.getName(), customCompareType.getId());
            customCompareTypeComboItems.add(comboItem);
        }
        this.comboItems.addAll(0, customCompareTypeComboItems);
    }

    protected void initDefaultOrgId() {
        if (this.getDefaultOrgId() != 0L) {
            this.setDefaultValue(this.getDefaultOrgId().toString());
        }
    }

    @SdkInternal
    protected void initDefaultDimObjId() {
        Long defaultDimObjId = this.getDefaultDimObjId();
        if (defaultDimObjId != null) {
            this.setDefaultValue(defaultDimObjId.toString());
        } else {
            this.setDefaultValue(null);
        }
    }

    private Long getDefaultOrgId() {
        ArrayList<Long> mainOrgIds = new ArrayList<Long>(10);
        for (ComboItem comboItem : this.comboItems) {
            if (StringUtils.isBlank((CharSequence)comboItem.getValue())) continue;
            Long orgId = Long.parseLong(comboItem.getValue());
            mainOrgIds.add(orgId);
        }
        return PermissionFilterUtil.getDefaultMainOrgId(mainOrgIds);
    }

    private Long getDefaultDimObjId() {
        ArrayList<Long> dimObjIds = new ArrayList<Long>(10);
        for (ComboItem comboItem : this.comboItems) {
            if (StringUtils.isBlank((CharSequence)comboItem.getValue())) continue;
            Long orgId = Long.parseLong(comboItem.getValue());
            dimObjIds.add(orgId);
        }
        if (!dimObjIds.isEmpty()) {
            return (Long)Collections.min(dimObjIds);
        }
        return null;
    }

    private boolean isContainOrgDependField(List<DependField> dependFields) {
        for (DependField dependField : dependFields) {
            if (!(dependField instanceof OrgDependField)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void initDefaultValues() {
        boolean isUseDimField;
        String dimFldKey = this.getEntityType().getPermissionControlType().getDataDimensionField();
        boolean isControlFuction = this.getEntityType().getPermissionControlType().isControlFunction();
        boolean bl = isUseDimField = isControlFuction && StringUtils.isNotBlank((CharSequence)dimFldKey) && !"null".equals(dimFldKey);
        if (this.isEntityField() && this.getFilterField() != null && this.getLatestParent() instanceof MainOrgProp && !isUseDimField) {
            this.initDefaultOrgId();
        } else if (this.isEntityField() && this.getFilterField() != null && isUseDimField && this.getLatestParent() instanceof BasedataProp && this.getLatestParent().getName().equals(dimFldKey)) {
            if (this.getLatestParent() instanceof OrgProp) {
                this.initDefaultOrgId();
            } else {
                this.initDefaultDimObjId();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.defValue)) {
            if (this.defValue.indexOf(44) > -1) {
                ArrayList<Object> defaultValues = new ArrayList<Object>(10);
                for (String defVal : this.defValue.split(",")) {
                    defaultValues.add(defVal);
                }
                this.setDefaultValues(defaultValues);
            } else {
                this.setDefaultValue(this.defValue);
            }
        }
        if (this.isBaseDataProp() && this.isNeedLoadMissing && this.hasInit && this.isLazyLoadMissing) {
            this.loadMissingDataItems(this.getDefaultValues());
        }
    }

    @SdkInternal
    protected List<ComboItem> getRunTimeComboItems() {
        List<Object> dataItems = new ArrayList();
        IDataEntityProperty latestParent = this.getLatestParent();
        if (this.isBaseDataField(latestParent)) {
            dataItems = this.getBaseDataItems((IBasedataField)latestParent);
        } else if (!(latestParent instanceof UserProp || !(latestParent instanceof IRefBillField) || this.filterField.getFieldProp() instanceof ComboProp || this.filterField.getFieldProp() instanceof BooleanProp || this.filterField.getFieldProp() instanceof DateTimeProp)) {
            dataItems = this.getRefBillItems((IRefBillField)latestParent);
        } else if (this.getFilterField().getFieldProp() instanceof ComboProp) {
            dataItems = this.getComboItems((ComboProp)this.getFilterField().getFieldProp());
        }
        return dataItems;
    }

    @Override
    protected FilterField convertDependOrgFilterFieldToId(FilterField dependOrgFilterField) {
        return dependOrgFilterField.convertToId();
    }

    @Override
    public FilterField getFilterField() {
        if (this.realFilterField != null) {
            return this.realFilterField;
        }
        this.realFilterField = super.getFilterField();
        if (this.realFilterField != null) {
            this.realFilterField = this.realFilterField.convertToId();
        }
        return this.realFilterField;
    }

    FilterField getOriFilterField() {
        return super.getFilterField();
    }

    @Override
    QFilter getDependFilter(DependField dependField, FilterField dependFilterField, FilterField joinPropertyFilterField) {
        return dependField.getDependFilter(dependFilterField.convertToId(), joinPropertyFilterField.convertToId(), dependFilterField.getDefaultMultiCompareTypeId(), this.commonFilters.get(dependField.getDependFieldName()), this.getBaseDataEntityType((IBasedataField)dependFilterField.getLatestParent()), this.getEntityType());
    }

    void addDependFilter(DependField dependField) {
        QFilter dependFilter = this.getDependFilter(dependField);
        if (dependFilter != null) {
            this.addDependQFilter(dependFilter);
        }
    }

    @Override
    protected boolean isNeedHideOrg() {
        if (!this.getContext().isSingleOrgMode() || this.getFilterField() == null) {
            return false;
        }
        return CoreSingleOrgContextHelper.isNeedHideOrgForCommonFilterColumn((FilterField)this.getFilterField());
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getFieldName() == null) {
            return false;
        }
        if (obj instanceof CommonFilterColumn) {
            CommonFilterColumn state = (CommonFilterColumn)((Object)obj);
            return this.getFieldName().equals(state.getFieldName());
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getFieldName().hashCode();
    }
}

