/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileFormPosition;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.TypeChange;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.param.ShowColumn;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonApproverFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterControlHelper;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.filter.helper.BaseDataSearchHelper;
import kd.bos.filter.helper.QueryLookUpdataParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FilterF7Helper;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.query.impl.BaseDataQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ShowFormHelper {
    private static final Log log = LogFactory.getLog(ShowFormHelper.class);
    private static final String FASTSEARCH_QUBU_KEY = "quanbu_id_6ab82085_7ef3_4a6d_9ad9_b02e54bfb06f";
    private static final String LISTFILTERPARAMETER = "listFilterParameter";
    private static final String PRIMARYFIELD = "primaryField";
    private static final String PAGEROW = "pageRow";

    private ShowFormHelper() {
    }

    public static ListShowParameter createShowListForm(String formId, boolean isMultiSelect) {
        return ShowFormHelper.createShowListForm(formId, isMultiSelect, 0);
    }

    @SdkInternal
    public static ListShowParameter createShowListForm(String formId, boolean isMultiSelect, int f7Style) {
        return ShowFormHelper.createShowListForm(formId, isMultiSelect, f7Style, true);
    }

    @SdkInternal
    public static ListShowParameter createShowListForm(String formId, boolean isMultiSelect, int f7Style, boolean isLookUP) {
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(isLookUP);
        para.setBillFormId(formId);
        if (isLookUP) {
            para.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            para.getOpenStyle().setInlineStyleCss(css);
            para.setFormId(ShowFormHelper.getListFormId(formId, f7Style));
            para.setF7Style(f7Style);
        } else {
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)formId);
            para.setFormId(formConfig.getListFormId());
        }
        para.setMultiSelect(isMultiSelect);
        para.setShowTitle(false);
        para.setHasRight(true);
        return para;
    }

    static ListShowParameter createShowMobileF7ListForm(String formId, boolean isMultiSelect) {
        ShowType showType;
        MobileListShowParameter para = new MobileListShowParameter();
        FormConfig formConfig = FormMetadataCache.getMobListFormConfig((String)formId);
        if (formConfig == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u8868\u5355\u6ca1\u6709\u8bbe\u8ba1\u79fb\u52a8\u5217\u8868\u3002", (String)"ShowFormHelper_0", (String)"bos-form-core", (Object[])new Object[0]), formId));
        }
        para.setCaption(formConfig.getCaption().toString());
        para.setLookUp(true);
        para.setBillFormId(formId);
        if (formConfig.getShowType() == ShowType.MainNewTabPage) {
            showType = ShowType.Floating;
        } else {
            showType = ShowType.Modal;
            para.setPosition(MobileFormPosition.Bottom);
        }
        para.getOpenStyle().setShowType(showType);
        para.setMultiSelect(isMultiSelect);
        String f7ListFormId = formConfig.getF7ListFormId();
        if (StringUtils.isNotBlank((CharSequence)f7ListFormId)) {
            para.setFormId(f7ListFormId);
        }
        return para;
    }

    private static String getListFormId(String formId, int f7Style) {
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)formId);
        switch (f7Style) {
            case 1: {
                if ("bos_user".equals(formId)) {
                    return formConfig.getF7ListFormId();
                }
                return "bos_orgtreelistf7";
            }
            case 2: {
                return "bos_listf7";
            }
        }
        if (formConfig == null) {
            return formId;
        }
        return formConfig.getF7ListFormId();
    }

    private static String serializeListShowParameter(ListShowParameter listShowParameter) {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRowCollection.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRow.class));
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return dcJsonSerializer.serializeToString((Object)listShowParameter, null);
    }

    @SdkInternal
    public static FormShowParameter createMobListF7DrawShowForm(String key, ListShowParameter listFilterParameter, String primaryField, String secondField, String iconField, boolean showModal, int pageRow, String opParameter) {
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("botp_mobiledraw");
        para.getOpenStyle().setShowType(ShowType.Floating);
        if (showModal) {
            para.getOpenStyle().setShowType(ShowType.Modal);
        }
        para.setCustomParam(LISTFILTERPARAMETER, (Object)ShowFormHelper.serializeListShowParameter(listFilterParameter));
        para.setCustomParam(PRIMARYFIELD, (Object)primaryField);
        para.setCustomParam("secondField", (Object)secondField);
        para.setCustomParam("iconField", (Object)iconField);
        para.setCustomParam("showModal", (Object)showModal);
        para.setCustomParam(PAGEROW, (Object)pageRow);
        para.setCustomParam("opparam", (Object)opParameter);
        para.setCustomParam("callBackActionId", (Object)key);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(key);
        closeCallBack.setActionId(key);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    @SdkInternal
    public static FormShowParameter createMobileListF7ShowForm(String key, ListShowParameter listFilterParameter, String primaryField, String secondField, String iconField, boolean showModal, int pageRow) {
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("bos_moblistf7");
        para.getOpenStyle().setShowType(ShowType.Floating);
        if (showModal) {
            para.getOpenStyle().setShowType(ShowType.Modal);
        }
        para.setCustomParam(LISTFILTERPARAMETER, (Object)ShowFormHelper.serializeListShowParameter(listFilterParameter));
        para.setCustomParam(PRIMARYFIELD, (Object)primaryField);
        para.setCustomParam("secondField", (Object)secondField);
        para.setCustomParam("iconField", (Object)iconField);
        para.setCustomParam("showModal", (Object)showModal);
        para.setCustomParam(PAGEROW, (Object)pageRow);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(key);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    @SdkInternal
    public static FormShowParameter createMobileTreeListF7ShowForm(String key, ListShowParameter listFilterParameter, String primaryField, int pageRow) {
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("bos_mobtreelistf7");
        para.getOpenStyle().setShowType(ShowType.Floating);
        para.setCustomParam(LISTFILTERPARAMETER, (Object)ShowFormHelper.serializeListShowParameter(listFilterParameter));
        para.setCustomParam(PRIMARYFIELD, (Object)primaryField);
        para.setCustomParam(PAGEROW, (Object)pageRow);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(key);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    @SdkInternal
    public static FormShowParameter createCustomMobileTreeListF7ShowForm(String key, ListShowParameter listFilterParameter, String primaryField, int pageRow) {
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId(listFilterParameter.getFormId());
        para.getOpenStyle().setShowType(ShowType.Floating);
        para.setCustomParam(LISTFILTERPARAMETER, (Object)ShowFormHelper.serializeListShowParameter(listFilterParameter));
        para.setCustomParam(PRIMARYFIELD, (Object)primaryField);
        para.setCustomParam(PAGEROW, (Object)pageRow);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(key);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    @SdkInternal
    public static FormShowParameter createDateSelectShowForm(String key, String value, String editor, boolean isStart, String minDate, String maxDate) {
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("bos_dateselect");
        para.getOpenStyle().setShowType(ShowType.Floating);
        para.setCustomParam("isStart", (Object)isStart);
        para.setCustomParam("value", (Object)value);
        para.setCustomParam("editor", (Object)editor);
        para.setCustomParam("minDate", (Object)minDate);
        para.setCustomParam("maxDate", (Object)maxDate);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(key);
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    @SdkInternal
    public static void showF7Form(FilterF7Helper filterF7Helper, IFormView view, String controlKey) {
        ShowFormHelper.showF7Form(filterF7Helper, view, controlKey, false);
    }

    @SdkInternal
    public static void showF7Form(FilterF7Helper filterF7Helper, IFormView view, String controlKey, boolean isMobile) {
        String pluginFormId;
        BeforeFilterF7SelectEvent evt = filterF7Helper.triggerBeforeF7SelectListeners();
        if (evt.isCancel()) {
            return;
        }
        List mergeQFilters = evt.getMergeQFilters();
        if (mergeQFilters.size() == filterF7Helper.getQfilters().size() && !filterF7Helper.getCommonFilterInitFilters().isEmpty()) {
            mergeQFilters.addAll(filterF7Helper.getCommonFilterInitFilters());
        }
        List customQfilters = filterF7Helper.addCustomQFilters(!(view instanceof IReportView));
        mergeQFilters.addAll(customQfilters);
        IBasedataField basedataProp = filterF7Helper.getBasedataField();
        if (evt.getSelectedIds().length > 0) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(customQfilters.size() + 1);
            qFilters.addAll(mergeQFilters);
            qFilters.add(new QFilter("id", "in", (Object)TypeChange.getRealPkList((DynamicObjectType)FilterControlHelper.getBasedataEntityType(filterF7Helper), Arrays.asList(evt.getSelectedIds()))));
            List validPkIds = BaseDataQuery.queryPkIdsByFilter((String)filterF7Helper.getRefEntityId(), (QFilter[])qFilters.toArray(new QFilter[0]));
            filterF7Helper.setSelectedIds(validPkIds.toArray());
        }
        ListShowParameter para = !isMobile ? ShowFormHelper.createShowListForm(filterF7Helper.isMulti(), evt.getRefEntityId(), basedataProp) : ShowFormHelper.createShowMobileF7ListForm(evt.getRefEntityId(), filterF7Helper.isMulti());
        para.getListFilterParameter().setQFilters(mergeQFilters);
        String pluginBillFormId = evt.getBillFormId();
        if (StringUtils.isEmpty((CharSequence)evt.getRefEntityId()) && StringUtils.isNotEmpty((CharSequence)pluginBillFormId)) {
            para.setBillFormId(pluginBillFormId);
        }
        if (StringUtils.isNotEmpty((CharSequence)(pluginFormId = evt.getFormId()))) {
            para.setFormId(pluginFormId);
        }
        para.setUseOrgId(evt.getUseOrgId());
        para.setCustomParams(evt.getCustomParams());
        para.setShowUsed(false);
        para.setShowApproved(true);
        Object[] selectedIds = filterF7Helper.getSelectedIds();
        ArrayList<Object> selectedPKList = new ArrayList<Object>();
        for (Object selectedId : selectedIds) {
            if (selectedId == null || !StringUtils.isNotEmpty((CharSequence)selectedId.toString())) continue;
            selectedPKList.add(selectedId);
        }
        para.setSelectedRowCondition(filterF7Helper.getSelectedRowCondition());
        para.setSelectedRows(selectedPKList.toArray());
        if (StringUtils.isNotBlank((CharSequence)filterF7Helper.getCaption())) {
            para.setCaption(filterF7Helper.getCaption());
        }
        if (basedataProp instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)basedataProp;
            String orgFuncID = orgProp.getOrgFunc();
            if (orgFuncID == null) {
                para.setCustomParam("islockfunc", (Object)false);
            } else {
                para.setCustomParam("islockfunc", (Object)true);
                para.setCustomParam("orgFuncId", (Object)orgFuncID);
            }
            OrgViewSchemeProp orgViewScheme = orgProp.getOrgViewScheme();
            if (orgViewScheme != null) {
                para.setCustomParam("orgViewSchemeNumber", (Object)orgViewScheme.getNumber());
            }
        }
        ShowFormHelper.setCloseCallBackForListShowParameter(filterF7Helper, controlKey, evt, para);
        para.setMustInput(filterF7Helper.isMustInput());
        if (filterF7Helper.getFilterColumn() instanceof SchemeFilterColumn && !para.getCustomParams().containsKey("isFromSchemeFilterColumn")) {
            para.getCustomParams().put("isFromSchemeFilterColumn", true);
        }
        if (filterF7Helper.getFilterColumn() instanceof CommonFilterColumn && !para.getCustomParams().containsKey("isFromCommonFilterColumn")) {
            para.getCustomParams().put("isFromCommonFilterColumn", true);
        }
        HashMap searchValueMap = new HashMap();
        ArrayList<String> valueList = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)filterF7Helper.getSearchValue())) {
            valueList.add(filterF7Helper.getSearchValue());
            searchValueMap.put(FASTSEARCH_QUBU_KEY, valueList);
            para.setCustomParam("searchValueMap", searchValueMap);
        }
        if (!isMobile) {
            para.setCustomParam("defaultFocus", (Object)true);
            para.setCustomParam("downKeyFocus", (Object)"billlistap");
        }
        view.showForm((FormShowParameter)para);
    }

    private static FuzzySearch loadLookUpSetting(BasedataEntityType refBDType, IFormView formView) {
        FuzzySearch setting;
        String cachedKey;
        IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
        String search = pageCache.get(cachedKey = "searchSetting" + refBDType.getName());
        if (search == null) {
            setting = BaseDataSearchHelper.loadLookUpSetting((BasedataEntityType)refBDType);
            pageCache.put(cachedKey, SerializationUtils.toJsonString((Object)setting));
        } else {
            setting = (FuzzySearch)SerializationUtils.fromJsonString((String)search, FuzzySearch.class);
        }
        BaseDataSearchHelper.setComboFieldCaption((BasedataEntityType)refBDType, (FuzzySearch)setting);
        return setting;
    }

    @SdkInternal
    public static void sendLookupData(FilterF7Helper filterF7Helper, IFormView view, Function<QueryLookUpdataParameter, DynamicObjectCollection> queryDataFunction) {
        DynamicObjectCollection queryCollection;
        List searchFields;
        FilterField filterField;
        BeforeFilterF7SelectEvent evt = filterF7Helper.triggerBeforeF7SelectListeners();
        if (evt.isCancel()) {
            return;
        }
        IBasedataField basedataProp = filterF7Helper.getBasedataField();
        ListShowParameter para = ShowFormHelper.createShowListForm(filterF7Helper.isMulti(), filterF7Helper.getRefEntityId(), basedataProp);
        para.getListFilterParameter().getQFilters().addAll(evt.getMergeQFilters());
        BasedataEntityType dt = null;
        if (filterF7Helper.getFilterColumn() instanceof CommonApproverFilterColumn) {
            dt = ((CommonApproverFilterColumn)filterF7Helper.getFilterColumn()).getBaseDataEntityType(null);
        } else {
            MainEntityType dataEntityType;
            dt = filterF7Helper.getBasedataEntityType();
            if (dt == null && (dataEntityType = EntityMetadataCache.getDataEntityType((String)filterF7Helper.getRefEntityId())) instanceof BasedataEntityType) {
                dt = (BasedataEntityType)dataEntityType;
            }
            if (dt == null) {
                dt = (BasedataEntityType)basedataProp.getComplexType();
            }
        }
        FuzzySearch setting = ShowFormHelper.loadLookUpSetting(dt, view);
        String currentName = "";
        boolean isSchemeFilterColumn = filterF7Helper.getFilterColumn() instanceof SchemeFilterColumn;
        if (isSchemeFilterColumn && (filterField = filterF7Helper.getFilterColumn().getFilterField()) != null && filterField.getFieldProp() != null) {
            currentName = filterField.getLatestParent() instanceof MasterBasedataProp && dt.getMasteridType() == 2 ? filterField.getLatestParent().getName() + "." + filterField.getFieldProp().getName() : filterField.getFieldProp().getName();
            String finalCurrentName = currentName;
            boolean isContainCurrentName = setting.getComboListFields().stream().anyMatch(p -> p.getId().equals(finalCurrentName));
            if (!isContainCurrentName) {
                ShowColumn showColumn = new ShowColumn(currentName, filterF7Helper.getFilterColumn().getCaption().toString(), false);
                setting.getComboListFields().add(showColumn);
            }
        }
        List<String> showFields = setting.getComboListFields().stream().map(ShowColumn::getId).collect(Collectors.toList());
        String fullSearchKey = filterF7Helper.getSearchKey().trim();
        QFilter searchFilter = BaseDataSearchHelper.getSearchFilter((String)fullSearchKey, (List)(searchFields = setting.getSearchFields()), (String)dt.getName());
        if (searchFilter != null) {
            para.getListFilterParameter().getQFilters().add(searchFilter);
        }
        String pkFieldName = dt.getPrimaryKey().getName();
        if (basedataProp instanceof MasterBasedataProp && ((MasterBasedataProp)basedataProp).getParent() instanceof BasedataEntityType && ((BasedataEntityType)((MasterBasedataProp)basedataProp).getParent()).getMasteridType() == 2 && !showFields.isEmpty()) {
            String masteridPropName;
            pkFieldName = masteridPropName = ((BasedataEntityType)((MasterBasedataProp)basedataProp).getParent()).getMasteridPropName();
            showFields.set(0, masteridPropName);
        }
        Map fieldsIndexMap = isSchemeFilterColumn ? ShowFormHelper.getFieldsIndexMap(dt, showFields) : BaseDataSearchHelper.getFieldsIndexMap((BasedataEntityType)dt, showFields);
        QueryLookUpdataParameter queryLookUpdataParameter = new QueryLookUpdataParameter(dt, searchFields, showFields, fullSearchKey, 0, setting.getPageSize(), fieldsIndexMap);
        queryLookUpdataParameter.setPara(para);
        if (queryDataFunction != null && (queryCollection = queryDataFunction.apply(queryLookUpdataParameter)) != null) {
            List queryLookUpdata = BaseDataSearchHelper.assembleData(showFields, (int)0, (int)setting.getPageSize(), (DynamicObjectCollection)queryCollection, (Map)fieldsIndexMap);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("columns", ShowFormHelper.createShowColumns(setting, fieldsIndexMap));
            data.put("data", queryLookUpdata);
            data.put("next", !queryLookUpdata.isEmpty() && queryLookUpdata.size() >= setting.getPageSize());
            data.put("k", filterF7Helper.getFieldName());
            data.put("size", setting.getPageSize());
            if (isSchemeFilterColumn && StringUtils.isNotBlank((CharSequence)currentName)) {
                data.put("aliasindex", pkFieldName.equals(currentName) ? fieldsIndexMap.getOrDefault(dt.getNameProperty(), 0) : fieldsIndexMap.get(currentName));
            }
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).invokeControlMethod(filterF7Helper.getControlKey(), filterF7Helper.getClientMethodName(), new Object[]{data});
        }
    }

    private static Map<String, Integer> getFieldsIndexMap(BasedataEntityType basedataEntityType, List<String> showFields) {
        HashMap<String, Integer> fieldsIndexMap = new HashMap<String, Integer>();
        int i = 0;
        for (String showField : showFields) {
            if (showField.equals(basedataEntityType.getPrimaryKey().getName())) {
                fieldsIndexMap.put(showField, 0);
                ++i;
                continue;
            }
            if (showField.equals(basedataEntityType.getNumberProperty())) {
                fieldsIndexMap.put(showField, 1);
                ++i;
                continue;
            }
            if (showField.equals(basedataEntityType.getNameProperty())) {
                fieldsIndexMap.put(showField, 2);
                ++i;
                continue;
            }
            fieldsIndexMap.put(showField, i++);
        }
        return fieldsIndexMap;
    }

    private static List<ShowColumn> createShowColumns(FuzzySearch setting, Map<String, Integer> fieldsIndexMap) {
        int index = 0;
        ArrayList<ShowColumn> showColumns = new ArrayList<ShowColumn>();
        for (ShowColumn showColumn : setting.getComboListFields()) {
            if (fieldsIndexMap.containsKey(showColumn.getId())) {
                Integer i = fieldsIndexMap.get(showColumn.getId());
                if (i == index) {
                    showColumns.add(fieldsIndexMap.get(showColumn.getId()), showColumn);
                } else {
                    showColumns.add(new ShowColumn());
                    if (i == ++index) {
                        showColumns.add(fieldsIndexMap.get(showColumn.getId()), showColumn);
                    }
                }
            } else {
                showColumns.add(showColumn);
            }
            ++index;
        }
        return showColumns;
    }

    private static void setCloseCallBackForListShowParameter(FilterF7Helper f7FormShowParameter, String controlKey, BeforeFilterF7SelectEvent evt, ListShowParameter para) {
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(controlKey);
        closeCallBack.setActionId(evt.getRefEntityId() + "$" + f7FormShowParameter.getClientType() + "$" + f7FormShowParameter.getRowIndex() + "$" + evt.getRefPropKey() + "$" + f7FormShowParameter.getClientMethodName() + "$" + f7FormShowParameter.getFieldName());
        para.setCloseCallBack(closeCallBack);
        para.setHasRight(true);
        para.setF7ClickByFilter(f7FormShowParameter.isF7ClickByFilter());
        Object showDisabledCheckbox = evt.getCustomParams().get("showDisabledCheckbox");
        if (showDisabledCheckbox != null && "false".equals(showDisabledCheckbox.toString())) {
            para.setF7ClickByFilter(false);
        }
    }

    private static ListShowParameter createShowListForm(boolean isMulti, String refEntityId, IBasedataField basedataProp) {
        int f7Style = 0;
        if (basedataProp instanceof UserProp) {
            f7Style = ((UserProp)basedataProp).getF7Style();
        } else if (basedataProp instanceof OrgProp) {
            f7Style = ((OrgProp)basedataProp).getF7Style();
        }
        return ShowFormHelper.createShowListForm(refEntityId, isMulti, f7Style);
    }

    public static String getBizAppId(FormShowParameter showParameter) {
        String formId;
        if (StringUtils.isNotBlank((CharSequence)showParameter.getAppId())) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)showParameter.getAppId());
            return appInfo.getId();
        }
        String entityTypeId = null;
        entityTypeId = showParameter instanceof ListShowParameter ? (StringUtils.isBlank((CharSequence)(formId = ((ListShowParameter)showParameter).getBillFormId())) ? showParameter.getFormId() : FormMetadataCache.getFormConfig((String)formId).getEntityTypeId()) : (showParameter instanceof BillShowParameter || showParameter instanceof MobileFormShowParameter ? showParameter.getFormConfig().getEntityTypeId() : showParameter.getFormId());
        BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        return bizAppService.getAppIdByFormNum(entityTypeId);
    }
}

