/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportSelectedRow;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractReportModel {
    private static final Log log = LogFactory.getLog((String)"AbstractReportModel");
    private IFormView view;
    private String pageId;
    private String ctrlId;
    private MainEntityType itemType;
    private String pluginClassName;
    private List<Plugin> pluginExtPlugins;
    private String dataSource;
    private boolean is_AsynQuery = false;
    private IReportCache reportCache;
    private static JobDispatcher service = null;
    private List<Plugin> reportQueryPlugins;
    private List<Map<String, String>> initField;
    private String dataSourceId;

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getPageId() {
        return this.pageId;
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public String getCtrlId() {
        return this.ctrlId;
    }

    public void setCtrlId(String ctrlId) {
        this.ctrlId = ctrlId;
    }

    public void setEntityType(MainEntityType itemType) {
        this.itemType = itemType;
    }

    public MainEntityType getItemType() {
        return this.itemType;
    }

    public void setPluginClassName(String pluginClassName) {
        this.pluginClassName = pluginClassName;
    }

    public String getPluginClassName() {
        return this.pluginClassName;
    }

    public List<Plugin> getReportQueryPlugins() {
        return this.reportQueryPlugins;
    }

    public void setReportQueryPlugins(List<Plugin> reportQueryPlugins) {
        this.reportQueryPlugins = reportQueryPlugins;
    }

    public List<Plugin> getPluginExtPlugins() {
        return this.pluginExtPlugins;
    }

    public void setPluginExtPlugins(List<Plugin> pluginExtPlugins) {
        this.pluginExtPlugins = pluginExtPlugins;
    }

    @SimplePropertyAttribute
    public List<Map<String, String>> getInitField() {
        return this.initField;
    }

    public void setInitField(List<Map<String, String>> initField) {
        this.initField = initField;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setAsynQuery(boolean isAsynQuery) {
        this.is_AsynQuery = isAsynQuery;
    }

    public boolean isAsynQuery() {
        return this.is_AsynQuery;
    }

    @SdkInternal
    protected void submitTask(ReportQueryParam queryParam, Object otherParam) {
        String directExportExcel;
        ReportTaskParam param = this.getTaskParam(otherParam);
        if (this.getView() != null && "true".equals(this.getView().getPageCache().get("isAsyncTotal"))) {
            param.setAsyncTotal(true);
        }
        String pageId = this.getPageId();
        String ctrlId = this.getCtrlId();
        if (this.getView() != null && StringUtils.isNotEmpty((CharSequence)(directExportExcel = this.getView().getPageCache().get("DirectExportExcel"))) && !StringUtils.equals((CharSequence)directExportExcel, (CharSequence)"exportreport")) {
            pageId = pageId + "_noQueryExport";
        }
        this.getReportCache().setReportTaskParam(pageId, ctrlId, param);
        this.query();
    }

    @SdkInternal
    protected ReportTaskParam getTaskParam(Object otherParam) {
        ReportTaskParam param = new ReportTaskParam();
        param.setReportName(this.itemType.getName());
        param.setPluginClassName(this.getPluginClassName());
        param.setReportQueryPlugins(this.getReportQueryPlugins());
        param.setPluginExtplugins(this.getPluginExtPlugins());
        param.setDataSource(this.getDataSource());
        param.setQueryDataSource(this.getDataSourceId());
        if (otherParam instanceof ReportSelectedRow) {
            ((ReportSelectedRow)otherParam).setEntityId(this.getItemType().getName());
        }
        param.setOtherParam(otherParam);
        return param;
    }

    @SdkInternal
    protected void refresh() {
        this.query();
    }

    @SdkInternal
    protected abstract void query();

    public int getProgress() {
        return this.getReportCache().getProgress(this.getPageId());
    }

    public void close() {
        TaskInfo taskInfo;
        ReportTaskParam reportTaskParam = this.getReportCache().getReportTaskParam(this.getPageId(), this.ctrlId);
        if (reportTaskParam != null && StringUtils.isNotBlank((CharSequence)reportTaskParam.getTaskId()) && StringUtils.equals((CharSequence)"backgroundExport", (CharSequence)reportTaskParam.getTaskType()) && (taskInfo = AbstractReportModel.getService().queryTask(reportTaskParam.getTaskId())) != null && !taskInfo.isTaskEnd()) {
            reportTaskParam.setRelease(true);
            this.getReportCache().setReportTaskParam(this.getPageId(), this.ctrlId, reportTaskParam);
            log.info(String.format("\u540e\u53f0\u4efb\u52a1\u6b63\u5728\u5bfc\u51fa\u62a5\u8868\uff0ctaskId\uff1a%s\uff0c\u4e0d\u6e05\u7a7a\u62a5\u8868\u7f13\u5b58", reportTaskParam.getTaskId()));
            return;
        }
        ReportTaskResult result = this.getReportCache().getReportTaskResult(this.pageId, this.ctrlId);
        if (result != null) {
            result.close();
        }
        this.getReportCache().clear(this.getPageId(), this.ctrlId);
        log.info("kd.bos.report.AbstractReportModel.close, pageId:{}, ctrlId:{}", (Object)this.getPageId(), (Object)this.ctrlId);
    }

    public IReportCache getReportCache() {
        if (this.reportCache == null) {
            this.reportCache = ReportCacheManager.getInstance().getCache();
        }
        return this.reportCache;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    private static JobDispatcher getService() {
        if (service == null) {
            service = (JobDispatcher)ServiceFactory.getService(JobDispatcher.class);
        }
        return service;
    }
}

