/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.Col2ndFilterOption;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportByBatchTaskResult;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportRowSet;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.report.events.ColHeadFilterClickEvent;
import kd.bos.report.events.CreateFilterInfoEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.report.processor.IReportColumnProcessor;
import kd.bos.report.processor.ReportColumnProcessorFactory;

public class TableHeadFilter {
    private static final String SPAN_TYPE = "ReportList";
    private static final String FIELDNAME = "FieldName";
    private static final String COMPARE = "Compare";
    private static final String VALUE = "Value";
    private static final String PLUG_SORT_COLS = "rpt.plug.sortcols";
    private static final String PLUG_FILTER_COLS = "rpt.plug.filtercols";
    private static final int MAX_ROWS_2NDFILTER = 100000;
    private static final int MAX_ROWS_2NDORDER = 100000;
    private ReportList reportList;

    public TableHeadFilter(ReportList reportList) {
        this.reportList = reportList;
    }

    public void afterSortAndFilterEvent(List<ReportColumn> columns, List<SortAndFilterEvent> allColumns) {
        ArrayList<String> plugSortCols = new ArrayList<String>(allColumns.size());
        ArrayList<String> plugFilterCols = new ArrayList<String>(allColumns.size());
        ReportTaskResult reportTaskResult = this.reportList.getReportCache().getReportTaskResult(this.reportList.getView().getPageId(), this.reportList.getKey());
        int filter2ndMaxRowCount = this.reportList.getFilter2ndMaxRowCount() == 0 ? 100000 : this.reportList.getFilter2ndMaxRowCount();
        int order2ndMaxRowCount = this.reportList.getOrder2ndMaxRowCount() == 0 ? 100000 : this.reportList.getOrder2ndMaxRowCount();
        boolean isLimitFilter = this.isOverMaxRow(reportTaskResult, filter2ndMaxRowCount, "filter", this.reportList.isColFilter());
        boolean colFilter = !isLimitFilter && this.reportList.isColFilter();
        boolean isLimitSort = this.isOverMaxRow(reportTaskResult, order2ndMaxRowCount, "order", this.reportList.isColSort());
        boolean colSort = !isLimitSort && this.reportList.isColSort();
        ReportTaskParam param = this.reportList.getReportCache().getReportTaskParam(this.reportList.getView().getPageId(), this.reportList.getKey());
        boolean pluginQuery = param.existQueryPlugin();
        HashMap<String, ReportColumn> columnMap = new HashMap<String, ReportColumn>(columns.size());
        for (ReportColumn col : columns) {
            columnMap.put(col.getFieldKey(), col);
        }
        for (SortAndFilterEvent event : allColumns) {
            ReportColumn col = (ReportColumn)columnMap.get(event.getColumnName());
            if (pluginQuery && event.isSort()) {
                plugSortCols.add(event.getColumnName());
            } else {
                event.setSort(!event.isDisableSort() && colSort && this.isColSupport2ndSort(col) && this.isColBindDataSource(col.getFieldKey()));
            }
            if (pluginQuery && event.isFilter()) {
                plugFilterCols.add(event.getColumnName());
                continue;
            }
            event.setFilter(!event.isDisableFilter() && colFilter && this.isColSupport2ndFilter(col) && this.isColBindDataSource(col.getFieldKey()));
        }
        this.reportList.getView().getPageCache().put(this.buildCacheKey(PLUG_SORT_COLS), SerializationUtils.toJsonString(plugSortCols));
        this.reportList.getView().getPageCache().put(this.buildCacheKey(PLUG_FILTER_COLS), SerializationUtils.toJsonString(plugFilterCols));
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"TableHeadFilter.afterSortAndFilterEvent", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addLocaleTag("isOverFilterMaxRow", (Object)isLimitFilter);
                span.addLocaleTag("isOverSortMaxRow", (Object)isLimitSort);
                span.addLocaleTag("list.isColSort()", (Object)this.reportList.isColSort());
                span.addLocaleTag("list.isColFilter()", (Object)this.reportList.isColFilter());
                span.addLocaleTag("isQueryByPlugin", (Object)pluginQuery);
                span.addLocaleTag(PLUG_SORT_COLS, (Object)this.reportList.getView().getPageCache().get(this.buildCacheKey(PLUG_SORT_COLS)));
                span.addLocaleTag(PLUG_FILTER_COLS, (Object)this.reportList.getView().getPageCache().get(this.buildCacheKey(PLUG_FILTER_COLS)));
                span.addLocaleTag("sortAndFilterEvent.args", allColumns);
            }
        }
    }

    private boolean isColSupport2ndSort(ReportColumn col) {
        if (col == null) {
            return false;
        }
        DynamicProperty prop = col.getFieldProperty();
        return prop != null && !(prop instanceof ItemClassProp) && !(prop instanceof FlexProp) && !(prop instanceof MulBasedataProp);
    }

    private boolean isColSupport2ndFilter(ReportColumn col) {
        if (col == null) {
            return false;
        }
        DynamicProperty prop = col.getFieldProperty();
        return prop != null && !(prop instanceof ItemClassProp) && !(prop instanceof FlexProp) && !(prop instanceof MulBasedataProp) && !(prop instanceof TimeProp);
    }

    private boolean isOverMaxRow(ReportTaskResult reportTaskResult, int maxRow, String type, boolean isOpen) {
        if (reportTaskResult == null) {
            return true;
        }
        boolean isLargeData = this.reportList.getReportCache().isLargeData(this.reportList.getView().getPageId());
        int rowCount = 0;
        if (isLargeData && reportTaskResult instanceof ReportByBatchTaskResult) {
            rowCount = ((ReportByBatchTaskResult)reportTaskResult).getBatchLoadInfo().getEstimateTotalRowCount();
            if (rowCount == 0) {
                rowCount = reportTaskResult.getTotalCount();
            }
        } else {
            rowCount = reportTaskResult.getTotalCount();
        }
        if (rowCount > maxRow && isOpen) {
            if (type.equals("filter")) {
                this.reportList.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u7684\u6570\u636e\u8d85\u8fc7%s\u884c\uff0c\u5217\u5934\u8fc7\u6ee4\u529f\u80fd\u4e0d\u53ef\u7528\u3002", (String)"TableHeadFilter_0", (String)"bos-form-core", (Object[])new Object[0]), maxRow));
            } else {
                this.reportList.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u7684\u6570\u636e\u8d85\u8fc7%s\u884c\uff0c\u5217\u5934\u6392\u5e8f\u529f\u80fd\u4e0d\u53ef\u7528\u3002", (String)"TableHeadFilter_1", (String)"bos-form-core", (Object[])new Object[0]), maxRow));
            }
        }
        return rowCount > maxRow;
    }

    private boolean isColBindDataSource(String columnName) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"TableHeadFilter.isBindDataSource", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            ReportColumn refCol;
            String dataIndex;
            span.addLocaleTag("columnName", (Object)columnName);
            ReportTaskResult taskResult = this.reportList.getReportCache().getReportTaskResult(this.reportList.getView().getPageId(), this.reportList.getKey());
            if (taskResult == null) {
                span.addLocaleTag("taskResult", (Object)"null");
                boolean bl = true;
                return bl;
            }
            List columns = taskResult.getReportColumnList();
            HashMap<String, ReportColumn> columnMap = new HashMap<String, ReportColumn>(columns.size());
            for (ReportColumn col : columns) {
                columnMap.put(col.getFieldKey(), col);
            }
            ReportColumn column = (ReportColumn)columnMap.get(columnName);
            if (column == null) {
                span.addLocaleTag("column", (Object)"null");
                boolean col = false;
                return col;
            }
            ReportRowSet rowSet = taskResult.getData(0, 0, null);
            boolean isBind = rowSet.containsColumn(dataIndex = StringUtils.isBlank((CharSequence)column.getDateIndex()) ? column.getFieldKey() : column.getDateIndex());
            if (!isBind && StringUtils.isNotBlank((CharSequence)column.getRefBasedataProp()) && (refCol = (ReportColumn)columnMap.get(column.getRefBasedataProp())) != null) {
                String refBasedata = StringUtils.isBlank((CharSequence)refCol.getDateIndex()) ? refCol.getFieldKey() : refCol.getDateIndex();
                isBind = rowSet.containsColumn(refBasedata);
            }
            span.addLocaleTag("column.getDateIndex", (Object)column.getDateIndex());
            span.addLocaleTag("column.getFieldKey", (Object)column.getFieldKey());
            span.addLocaleTag("dataIndex", (Object)dataIndex);
            span.addLocaleTag("isBind", (Object)isBind);
            span.addLocaleTag("rowMeta.fields", (Object)rowSet.getColumnNames());
            boolean bl = isBind;
            return bl;
        }
    }

    public void sort(String columnName, int sortStyle) {
        if (StringUtils.isBlank((CharSequence)columnName)) {
            return;
        }
        boolean isReset = sortStyle == 0;
        String forPlugColsStr = this.reportList.getView().getPageCache().get(this.buildCacheKey(PLUG_SORT_COLS));
        HashSet forPlugColSet = null;
        if (StringUtils.isBlank((CharSequence)forPlugColsStr)) {
            forPlugColSet = new HashSet(0);
        } else {
            List list = (List)SerializationUtils.fromJsonString((String)forPlugColsStr, List.class);
            forPlugColSet = new HashSet(list);
        }
        String sortName = this.getSortName(sortStyle);
        String orderby = isReset ? null : columnName + " " + sortName;
        ReportQueryParam param = this.reportList.getReportCache().getReportQueryParam(this.reportList.getView().getPageId());
        Col2ndFilterOption col2ndFilterOption = param.getFilter().getCol2ndFilterOption(this.reportList.getKey());
        if (forPlugColSet.contains(columnName)) {
            param.setSortInfo(orderby);
            param.setSortSource("singleSort");
            if (col2ndFilterOption != null) {
                col2ndFilterOption.setOrderbys(null);
            }
        } else if (this.reportList.isColSort()) {
            String[] stringArray;
            if (!this.isColBindDataSource(columnName)) {
                this.reportList.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5217\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\uff0c\u4e0d\u652f\u6301\u6392\u5e8f\u3002", (String)"TableHeadFilter_2", (String)"bos-form-core", (Object[])new Object[0]));
                return;
            }
            if (orderby == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = orderby;
            }
            String[] orderbys = stringArray;
            if (col2ndFilterOption == null) {
                col2ndFilterOption = new Col2ndFilterOption(null, orderbys);
            } else {
                col2ndFilterOption.setOrderbys(orderbys);
            }
            col2ndFilterOption.setOnly2ndFilter(StringUtils.isBlank((CharSequence)param.getSortInfo()));
            col2ndFilterOption.setBaseCol2FilterResult(true);
            param.getFilter().setCol2ndFilterOption(this.reportList.getKey(), col2ndFilterOption);
        }
        this.reportList.getReportCache().setReportQueryParam(this.reportList.getView().getPageId(), param);
        this.reportList.refresh();
    }

    private String getSortName(int sortStyle) {
        if (sortStyle == 1) {
            return "asc";
        }
        if (sortStyle == 2) {
            return "desc";
        }
        return null;
    }

    public void filter(List<Map<String, List<Object>>> filter) {
        ReportQueryParam param = this.reportList.getReportCache().getReportQueryParam(this.reportList.getView().getPageId());
        Col2ndFilterOption col2ndFilterOption = param.getFilter().getCol2ndFilterOption(this.reportList.getKey());
        if (col2ndFilterOption == null) {
            col2ndFilterOption = new Col2ndFilterOption(null, null);
        }
        col2ndFilterOption.setBaseCol2FilterResult(true);
        String forPlugColsStr = this.reportList.getView().getPageCache().get(this.buildCacheKey(PLUG_FILTER_COLS));
        HashSet forPlugColSet = null;
        if (StringUtils.isBlank((CharSequence)forPlugColsStr)) {
            forPlugColSet = new HashSet(0);
        } else {
            List list = (List)SerializationUtils.fromJsonString((String)forPlugColsStr, List.class);
            forPlugColSet = new HashSet(list);
        }
        boolean isReset = false;
        if (filter.get(0).get(VALUE).isEmpty()) {
            isReset = true;
        }
        ArrayList<Map<String, List<Object>>> forPlugFilters = new ArrayList<Map<String, List<Object>>>(filter.size());
        boolean filter2nd = false;
        for (Map<String, List<Object>> item : filter) {
            String fieldName = item.get(FIELDNAME).get(0).toString();
            if (forPlugColSet.contains(fieldName)) {
                forPlugFilters.add(item);
                continue;
            }
            if (!this.reportList.isColFilter()) continue;
            if (!this.isColBindDataSource(fieldName)) {
                this.reportList.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5217\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\uff0c\u4e0d\u652f\u6301\u8fc7\u6ee4\u3002", (String)"TableHeadFilter_3", (String)"bos-form-core", (Object[])new Object[0]));
                return;
            }
            filter2nd = true;
            if (col2ndFilterOption.removeFilterItemInfo(fieldName)) {
                col2ndFilterOption.setBaseCol2FilterResult(false);
            }
            if (isReset) continue;
            col2ndFilterOption.addFilterItemInfo(item);
        }
        if (!forPlugFilters.isEmpty()) {
            this.updateTableHeaderFilters(param, forPlugFilters);
            col2ndFilterOption.setBaseCol2FilterResult(false);
        }
        if (filter2nd) {
            col2ndFilterOption.setOnly2ndFilter(forPlugFilters.isEmpty());
            param.getFilter().setCol2ndFilterOption(this.reportList.getKey(), col2ndFilterOption);
        }
        this.reportList.getReportCache().setReportQueryParam(this.reportList.getView().getPageId(), param);
        this.reportList.refresh();
    }

    private void updateTableHeaderFilters(ReportQueryParam param, List<Map<String, List<Object>>> filter) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        boolean isReset = false;
        if (filter.get(0).get(VALUE).isEmpty()) {
            isReset = true;
        }
        String fieldName = null;
        Object value = null;
        String compareOperate = null;
        for (Map<String, List<Object>> map : filter) {
            fieldName = map.get(FIELDNAME).get(0).toString();
            fieldName = this.dealWithFlexField(fieldName);
            ArrayList<FilterItemInfo> itemInfoList = param.getFilter().getTableHeadFilterItems();
            if (itemInfoList == null) {
                itemInfoList = new ArrayList<FilterItemInfo>(10);
            }
            if (!itemInfoList.isEmpty()) {
                Iterator iterator = itemInfoList.iterator();
                while (iterator.hasNext()) {
                    FilterItemInfo itemInfo = (FilterItemInfo)iterator.next();
                    String oldFieldName = itemInfo.getPropName();
                    if (!fieldName.equals(oldFieldName)) continue;
                    iterator.remove();
                }
            }
            if (isReset) continue;
            String compareTypeId = map.get(COMPARE).get(0).toString();
            CompareType compareType = FilterMetadata.get().getCompareTypeByCompareTypeId(compareTypeId);
            compareOperate = compareType.getOperate();
            if (!StringUtils.isBlank((CharSequence)compareType.getClassName())) {
                compareOperate = compareType.getValue();
            }
            if (map.get(VALUE).get(0) == null) continue;
            value = map.get(VALUE).get(0).toString();
            if (map.get(VALUE).size() > 1) {
                value = map.get(VALUE);
            }
            itemInfoList.add(new FilterItemInfo(fieldName, value, compareOperate));
        }
        this.updateFilterInfo(param.getFilter().getTableHeadFilterItems(), fieldName, value, compareOperate);
    }

    private String dealWithFlexField(String fieldName) {
        AbstractReportListModel model = this.reportList.getAbstractReportModel();
        List cols = this.reportList.getReportListProxy().getReportColumnList(model.getColumns(), false);
        for (ReportColumn col : cols) {
            if (!fieldName.equals(col.getFieldKey())) continue;
            return fieldName;
        }
        List columns = this.reportList.getFlexColumnSplitService().flatFlextColumn(cols);
        for (ReportColumn col : columns) {
            if (!fieldName.equals(col.getFieldKey())) continue;
            FlexProperty flexProperty = (FlexProperty)this.reportList.getFlexColumnSplitService().getFlexBaseFieldKeyMap().get(fieldName);
            String flexFieldKey = this.reportList.getFlexColumnSplitService().getFlexFieldKey(fieldName);
            if ("1".equals(flexProperty.getValueType()) || "2".equals(flexProperty.getValueType())) {
                FlexProperty.DisplayProperty displayProperty = flexProperty.getDisplayStyle().getDisplayProperty();
                String dispalyName = "";
                dispalyName = "3".equals(displayProperty.getValue()) ? "name" : displayProperty.toString();
                return flexFieldKey + "_" + flexProperty.getFlexField() + "." + flexProperty.getValueSource() + "." + dispalyName;
            }
            if (!"3".equals(flexProperty.getValueType())) continue;
            return flexFieldKey + "_" + flexProperty.getFlexField() + ".value";
        }
        return fieldName;
    }

    private void updateFilterInfo(List<FilterItemInfo> tableHeadFilterItems, String fieldKey, Object value, String compareType) {
        if (!this.isSupportFilter()) {
            return;
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.reportList.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.reportList.getView().getService(IClientViewProxy.class);
            ReportViewPluginProxy proxy = (ReportViewPluginProxy)pluginProxy;
            List columnList = this.reportList.getReportListProxy().getColumnList(this.reportList.getReportModel());
            Map<String, SortAndFilterEvent> sortAndFilterEventMap = this.fireSortAndFilterEvent(columnList);
            List<CreateFilterInfoEvent> filterInfoEvent = this.createFilterInfoEvent(columnList, sortAndFilterEventMap);
            ColHeadFilterClickEvent event = new ColHeadFilterClickEvent(filterInfoEvent, tableHeadFilterItems, fieldKey, value, compareType);
            proxy.fireColHeadFilterClick(event);
            for (CreateFilterInfoEvent filterInfo : event.getFilterInfoEvents()) {
                if (CollectionUtils.isEmpty((Map)filterInfo.getFilterInfo())) continue;
                clientViewProxy.invokeControlMethod(this.reportList.getKey(), "setColProp", new Object[]{filterInfo.getFieldKey(), "comboItems", filterInfo.getFilterInfo().get("comboItems")});
            }
        }
    }

    private List<CreateFilterInfoEvent> createFilterInfoEvent(List<AbstractReportColumn> columnList, Map<String, SortAndFilterEvent> sortAndFilterEventMap) {
        ArrayList<CreateFilterInfoEvent> createFilterInfoEvents = new ArrayList<CreateFilterInfoEvent>(columnList.size());
        for (AbstractReportColumn column : columnList) {
            if (column instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)column;
                if ("fseq".equals(reportColumn.getFieldKey()) || reportColumn.isHide() || reportColumn.isPicture() || !sortAndFilterEventMap.get(reportColumn.getFieldKey()).isFilter()) continue;
                IReportColumnProcessor processor = ReportColumnProcessorFactory.createReportColumnProcessor((String)reportColumn.getFieldType());
                processor.setView(this.reportList.getView());
                processor.setFieldKey(reportColumn.getFieldKey());
                processor.setFieldType(reportColumn.getFieldType());
                createFilterInfoEvents.add(new CreateFilterInfoEvent((Object)processor, this.reportList.getView(), reportColumn.getFieldKey()));
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup groupColumn = (ReportColumnGroup)column;
            createFilterInfoEvents.addAll(this.createFilterInfoEvent(groupColumn.getChildren(), sortAndFilterEventMap));
        }
        return createFilterInfoEvents;
    }

    private boolean isSupportFilter() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"TableHeadFilter.isSupportFilter", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            String isTreeReportList = this.reportList.getView().getPageCache().get("isTreeReportList");
            boolean supportFilter = !Boolean.parseBoolean(isTreeReportList);
            span.addLocaleTag("isTreeReportList", (Object)isTreeReportList);
            span.addLocaleTag("supportFilter", (Object)supportFilter);
            boolean bl = supportFilter;
            return bl;
        }
    }

    private Map<String, SortAndFilterEvent> fireSortAndFilterEvent(List<AbstractReportColumn> columns) {
        ArrayList<SortAndFilterEvent> sortAndFilterEventList = new ArrayList<SortAndFilterEvent>(columns.size());
        HashMap<String, SortAndFilterEvent> map = new HashMap<String, SortAndFilterEvent>(columns.size());
        this.addReportColumn(columns, sortAndFilterEventList, map);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.reportList.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).setSortAndFilter(sortAndFilterEventList);
        }
        return map;
    }

    private void addReportColumn(List<AbstractReportColumn> columns, List<SortAndFilterEvent> cols, Map<String, SortAndFilterEvent> map) {
        for (AbstractReportColumn col : columns) {
            ReportColumn reportColumn;
            if (col instanceof ReportColumnGroup) {
                List children = ((ReportColumnGroup)col).getChildren();
                this.addReportColumn(children, cols, map);
                continue;
            }
            if (!(col instanceof ReportColumn) || (reportColumn = (ReportColumn)col).isHide() || reportColumn.isPicture() || "fseq".equals(reportColumn.getFieldKey())) continue;
            SortAndFilterEvent event = new SortAndFilterEvent();
            event.setColumnName(reportColumn.getFieldKey());
            event.setDisplayName(reportColumn.getCaption());
            map.put(reportColumn.getFieldKey(), event);
            cols.add(event);
        }
    }

    private String buildCacheKey(String type) {
        return type + "." + this.reportList.getKey();
    }
}

