/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.util.function.IntSupplier;
import kd.bos.config.RateLimiterConfigProvider;
import kd.bos.dataentity.limiter.CountLimiterPolicy;
import kd.bos.dataentity.limiter.ICreator;
import kd.bos.dataentity.limiter.IRateLimiter;
import kd.bos.dataentity.limiter.KingScriptHybridLimiterPolicy;
import kd.bos.dataentity.limiter.ThreadObjectStateService;
import kd.bos.dataentity.resource.ResManager;

final class BusinessDataLimiter {
    private static final KingScriptHybridLimiterPolicy<IRateLimiter> queryRowsLimiterPolicy = new KingScriptHybridLimiterPolicy((ICreator)new CountLimiterPolicy((IntSupplier)RateLimiterConfigProvider.getQueryRowsConfig().getScriptConfig(), (limiter, count) -> String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u670d\u52a1\u4f20\u5165\u7684\u6761\u4ef6\u8fc7\u4e8e\u5bbd\u677e\uff0c\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u884c\u6570\u8d85\u8fc7\u4e86\u6700\u5927\u884c\u6570\u9650\u5236%1$s\u3002\u8bf7\u7f29\u5c0f\u53d6\u6570\u8303\u56f4\uff0c\u6216\u6539\u7528QueryServiceHelper.queryDataSet\u6d41\u5f0f\u8bfb\u53d6\u3002", (String)"QueryServiceHelper_0", (String)"bos-servicehelper", (Object[])new Object[0]), limiter.getMax())), (ICreator)new CountLimiterPolicy((IntSupplier)RateLimiterConfigProvider.getQueryRowsConfig().getJvmConfig(), (limiter, count) -> String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u670d\u52a1\u4f20\u5165\u7684\u6761\u4ef6\u8fc7\u4e8e\u5bbd\u677e\uff0c\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u884c\u6570\u8d85\u8fc7\u4e86\u6700\u5927\u884c\u6570\u9650\u5236%1$s\u3002\u8bf7\u7f29\u5c0f\u53d6\u6570\u8303\u56f4\uff0c\u6216\u6539\u7528QueryServiceHelper.queryDataSet\u6d41\u5f0f\u8bfb\u53d6\u3002", (String)"QueryServiceHelper_0", (String)"bos-servicehelper", (Object[])new Object[0]), limiter.getMax())));
    private static final ICreator<IRateLimiter> queryCellsLimiterPolicy = RateLimiterConfigProvider.getQueryCellsConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limiter, count) -> String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u670d\u52a1\u4f20\u5165\u7684\u6761\u4ef6\u8fc7\u4e8e\u5bbd\u677e\uff0c\u8bfb\u53d6\u7684\u5b57\u6bb5\u8fc7\u591a\uff0c\u603b\u5355\u5143\u683c\u6570(\u884c\u6570*\u5b57\u6bb5\u6570)\u8d85\u8fc7\u4e86\u6700\u5927\u5355\u5143\u683c\u6570\u9650\u5236%1$s\u3002\u8bf7\u7f29\u5c0f\u53d6\u6570\u8303\u56f4\u3001\u51cf\u5c11\u8bfb\u53d6\u7684\u5b57\u6bb5\uff0c\u6216\u6539\u7528QueryServiceHelper.queryDataSet\u6d41\u5f0f\u8bfb\u53d6\u3002", (String)"QueryServiceHelper_1", (String)"bos-servicehelper", (Object[])new Object[0]), limiter.getMax())));
    private static final ICreator<IRateLimiter> queryPKsLimiterPolicy = RateLimiterConfigProvider.getQueryPKsConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limiter, count) -> String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u670d\u52a1\u4f20\u5165\u7684\u6761\u4ef6\u8fc7\u4e8e\u5bbd\u677e\uff0c\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5185\u7801\u4e2a\u6570\u8d85\u8fc7\u4e86\u6700\u5927\u5355\u5143\u683c\u6570\u9650\u5236%1$s\u3002\u8bf7\u7f29\u5c0f\u53d6\u6570\u8303\u56f4\u3002", (String)"QueryServiceHelper_5", (String)"bos-servicehelper", (Object[])new Object[0]), limiter.getMax())));
    private static final ICreator<IRateLimiter> queryFieldsLimiterPolicy = RateLimiterConfigProvider.getQueryFieldsConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limiter, count) -> String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u670d\u52a1\u4f20\u5165\u7684\u5b57\u6bb5\u8fc7\u591a\uff0c\u8d85\u8fc7\u5b57\u6bb5\u6570\u9650\u5236%1$s\u3002\u8bf7\u51cf\u5c11\u8bfb\u53d6\u7684\u5b57\u6bb5\uff0c\u6216\u6539\u7528QueryServiceHelper.queryDataSet\u6d41\u5f0f\u8bfb\u53d6\u3002", (String)"QueryServiceHelper_2", (String)"bos-servicehelper", (Object[])new Object[0]), limiter.getMax())));
    private static final ThreadObjectStateService<IRateLimiter> queryCallCountLimiter = new ThreadObjectStateService(RateLimiterConfigProvider.getQueryCallTimesConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limiter, count) -> String.format(ResManager.loadKDString((String)"\u8c03\u7528\u53d6\u6570\u670d\u52a1\u6b21\u6570\u8d85\u8fc7\u9650\u5236%1$s\uff0c\u8bf7\u4f18\u5316\u4ee3\u7801\uff0c\u907f\u514d\u9891\u7e41\u53d6\u6570\u3002", (String)"QueryServiceHelper_3", (String)"bos-servicehelper", (Object[])new Object[0]), limiter.getMax()))));
    private static final ThreadObjectStateService<IRateLimiter> queryTotalTimeoutLimiter = new ThreadObjectStateService(RateLimiterConfigProvider.getQueryTotalTimeoutConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limiter, count) -> String.format(ResManager.loadKDString((String)"\u8c03\u7528\u67e5\u8be2\u670d\u52a1\u7d2f\u8ba1\u8017\u65f6\u8d85\u8fc7\u9650\u5236 %1$s \u79d2\uff0c\u8bf7\u4f18\u5316\u4ee3\u7801\u907f\u514d\u8017\u65f6\u8fc7\u957f\u3002", (String)"QueryServiceHelper_6", (String)"bos-servicehelper", (Object[])new Object[0]), limiter.getMax()))));
    private static final ThreadObjectStateService<IRateLimiter> queryTotalRowsLimiter = new ThreadObjectStateService(RateLimiterConfigProvider.getQueryTotalRowsConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limiter, count) -> String.format(ResManager.loadKDString((String)"\u8c03\u7528\u53d6\u6570\u670d\u52a1\u7d2f\u8ba1\u53d6\u6570\u5df2\u8d85\u8fc7\u9650\u5236%1$s\uff0c\u8bf7\u4f18\u5316\u4ee3\u7801\uff0c\u7f29\u51cf\u53d6\u6570\u8303\u56f4\u6216\u8005\u51cf\u5c11\u53d6\u6570\u6b21\u6570\u3002", (String)"QueryServiceHelper_4", (String)"bos-servicehelper", (Object[])new Object[0]), limiter.getMax()))));
    private static final ICreator<IRateLimiter> loadBillsByIdLimiterPolicy = RateLimiterConfigProvider.getLoadBillsConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limiter, count) -> String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u670d\u52a1\u4f20\u5165\u5185\u7801\u4e2a\u6570%1$s\uff0c\u8d85\u8fc7\u4e86\u6700\u5927\u9650\u5236%2$s\u3002\u8bf7\u5206\u6279\u8bfb\u53d6\uff0c\u6216\u6539\u7528QueryServiceHelper.queryDataSet\u6d41\u5f0f\u8bfb\u53d6\u3002", (String)"BusinessDataServiceHelper_0", (String)"bos-servicehelper", (Object[])new Object[0]), count, limiter.getMax())));
    private static final ICreator<IRateLimiter> loadBillsByFilterLimiterPolicy = RateLimiterConfigProvider.getLoadBillsConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limiter, count) -> String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u670d\u52a1\u4f20\u5165\u7684\u6761\u4ef6\u8fc7\u4e8e\u5bbd\u677e\uff0c\u7b26\u5408\u6761\u4ef6\u7684\u5185\u7801\u4e2a\u6570\u8d85\u8fc7\u4e86\u6700\u5927\u9650\u5236%1$s\u3002\u8bf7\u7f29\u5c0f\u53d6\u6570\u8303\u56f4\uff0c\u6216\u6539\u7528QueryServiceHelper.queryDataSet\u6d41\u5f0f\u8bfb\u53d6\u3002", (String)"BusinessDataServiceHelper_1", (String)"bos-servicehelper", (Object[])new Object[0]), limiter.getMax())));

    BusinessDataLimiter() {
    }

    private static ICreator<IRateLimiter> getQueryRowsLimiterPolicy() {
        return queryRowsLimiterPolicy;
    }

    private static ICreator<IRateLimiter> getQueryCellsLimiterPolicy() {
        return queryCellsLimiterPolicy;
    }

    private static ICreator<IRateLimiter> getQueryPKsLimiterPolicy() {
        return queryPKsLimiterPolicy;
    }

    private static ICreator<IRateLimiter> getQueryFieldsLimiterPolicy() {
        return queryFieldsLimiterPolicy;
    }

    private static ThreadObjectStateService<IRateLimiter> getQueryCallCountLimiter() {
        return queryCallCountLimiter;
    }

    private static ThreadObjectStateService<IRateLimiter> getQueryTotalRowsLimiter() {
        return queryTotalRowsLimiter;
    }

    private static ICreator<IRateLimiter> getLoadBillsByIdLimiterPolicy() {
        return loadBillsByIdLimiterPolicy;
    }

    private static ICreator<IRateLimiter> getLoadBillsByFilterLimiterPolicy() {
        return loadBillsByFilterLimiterPolicy;
    }

    public static int getQueryRowsMax() {
        return ((IRateLimiter)BusinessDataLimiter.getQueryRowsLimiterPolicy().create()).getMax();
    }

    public static int getQueryCellsMax() {
        return ((IRateLimiter)BusinessDataLimiter.getQueryCellsLimiterPolicy().create()).getMax();
    }

    public static int getQueryPKsMax() {
        return ((IRateLimiter)BusinessDataLimiter.getQueryPKsLimiterPolicy().create()).getMax();
    }

    public static void checkQueryRows(int rowCount) {
        ((IRateLimiter)BusinessDataLimiter.getQueryRowsLimiterPolicy().create()).acquire(rowCount);
    }

    public static void checkQueryCells(int cellCount) {
        ((IRateLimiter)BusinessDataLimiter.getQueryCellsLimiterPolicy().create()).acquire(cellCount);
    }

    public static void checkQueryPKs(int pkCount) {
        ((IRateLimiter)BusinessDataLimiter.getQueryPKsLimiterPolicy().create()).acquire(pkCount);
    }

    public static long checkQueryCallTimes() {
        ((IRateLimiter)BusinessDataLimiter.getQueryCallCountLimiter().getOrCreate()).acquire();
        return System.currentTimeMillis();
    }

    private static int getExecutionTime(long beginTime) {
        return (int)(System.currentTimeMillis() - beginTime) / 1000;
    }

    public static void checkQueryTimeout(long beginTime) {
        ((IRateLimiter)queryTotalTimeoutLimiter.getOrCreate()).acquire(BusinessDataLimiter.getExecutionTime(beginTime));
    }

    public static void checkQueryTotalRows(int rowCount) {
        ((IRateLimiter)BusinessDataLimiter.getQueryTotalRowsLimiter().getOrCreate()).acquire(rowCount);
    }

    public static void checkQueryFields(int fieldCount) {
        ((IRateLimiter)BusinessDataLimiter.getQueryFieldsLimiterPolicy().create()).acquire(fieldCount);
    }

    public static long checkLoadCallTimes() {
        ((IRateLimiter)BusinessDataLimiter.getQueryCallCountLimiter().getOrCreate()).acquire();
        return System.currentTimeMillis();
    }

    public static <R> R checkTimeout(R result, long beginTime) {
        ((IRateLimiter)queryTotalTimeoutLimiter.getOrCreate()).acquire(BusinessDataLimiter.getExecutionTime(beginTime));
        return result;
    }

    public static void checkLoadBillSizeByIds(int billCount) {
        ((IRateLimiter)BusinessDataLimiter.getLoadBillsByIdLimiterPolicy().create()).acquire(billCount);
    }

    public static IRateLimiter getLoadBillSizeByFilterLimiter() {
        return (IRateLimiter)BusinessDataLimiter.getLoadBillsByFilterLimiterPolicy().create();
    }
}

