/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.operation;

import java.util.function.IntSupplier;
import kd.bos.config.RateLimiterConfigProvider;
import kd.bos.dataentity.limiter.CountLimiterPolicy;
import kd.bos.dataentity.limiter.ICreator;
import kd.bos.dataentity.limiter.IRateLimiter;
import kd.bos.dataentity.limiter.ThreadObjectStateService;
import kd.bos.dataentity.resource.ResManager;

final class BusinessDMLLimiter {
    private static final ThreadObjectStateService<IRateLimiter> callStateService = new ThreadObjectStateService(RateLimiterConfigProvider.getDmlCallTimesConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limit, count) -> ResManager.loadKDString((String)"\u6570\u636e\u64cd\u4f5c\u670d\u52a1\u7d2f\u8ba1\u8c03\u7528\u6b21\u6570\u5df2\u8d85\u8fc7\u9650\u5236%1$s\u6b21\uff0c\u8bf7\u4f18\u5316\u4ee3\u7801\u51cf\u5c11\u6b21\u6570\u3002", (String)"BusinessDMLLimiter_0", (String)"bos-servicehelper", (Object[])new Object[]{limit.getMax()}))));
    private static final ThreadObjectStateService<IRateLimiter> dmlTotalTimeoutService;
    private static final ICreator<IRateLimiter> saveLimitPolicy;
    private static final ICreator<IRateLimiter> updateLimitPolicy;
    private static final ICreator<IRateLimiter> deleteLimitPolicy;

    BusinessDMLLimiter() {
    }

    static long checkSaveCallTimes() {
        ((IRateLimiter)callStateService.getOrCreate()).acquire();
        return System.currentTimeMillis();
    }

    private static int getExecutionTime(long beginTime) {
        return (int)(System.currentTimeMillis() - beginTime) / 1000;
    }

    static void checkDmlTimeout(long beginTime) {
        ((IRateLimiter)dmlTotalTimeoutService.getOrCreate()).acquire(BusinessDMLLimiter.getExecutionTime(beginTime));
    }

    static long checkUpdateCallTimes() {
        ((IRateLimiter)callStateService.getOrCreate()).acquire();
        return System.currentTimeMillis();
    }

    static long checkDeleteCallTimes() {
        ((IRateLimiter)callStateService.getOrCreate()).acquire();
        return System.currentTimeMillis();
    }

    public static void checkSaveSize(int count) {
        ((IRateLimiter)saveLimitPolicy.create()).acquire(count);
    }

    public static void checkUpdateSize(int count) {
        ((IRateLimiter)updateLimitPolicy.create()).acquire(count);
    }

    public static void checkDeleteSize(int count) {
        ((IRateLimiter)deleteLimitPolicy.create()).acquire(count);
    }

    public static IRateLimiter getDeleteLimiter() {
        return (IRateLimiter)deleteLimitPolicy.create();
    }

    static {
        saveLimitPolicy = RateLimiterConfigProvider.getSaveBillsConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limit, count) -> ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u670d\u52a1\u4f20\u5165\u6570\u636e\u91cf\u662f%1$s\uff0c\u5df2\u8d85\u8fc7\u6700\u5927%2$s\u6761\u9650\u5236\uff0c\u8bf7\u4f18\u5316\u4ee3\u7801\u51cf\u5c11\u6570\u91cf\u6216\u8005\u5206\u6279\u5904\u7406\u3002", (String)"BusinessDMLLimiter_1", (String)"servicehelper", (Object[])new Object[]{count, limit.getMax()})));
        updateLimitPolicy = RateLimiterConfigProvider.getUpdateBillsConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limit, count) -> ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u670d\u52a1\u4f20\u5165\u6570\u636e\u91cf\u662f%1$s\uff0c\u5df2\u8d85\u8fc7\u6700\u5927%2$s\u6761\u9650\u5236\uff0c\u8bf7\u4f18\u5316\u4ee3\u7801\u51cf\u5c11\u6570\u91cf\u6216\u8005\u5206\u6279\u5904\u7406\u3002", (String)"BusinessDMLLimiter_2", (String)"servicehelper", (Object[])new Object[]{count, limit.getMax()})));
        deleteLimitPolicy = RateLimiterConfigProvider.getDeleteBillsConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limit, count) -> ResManager.loadKDString((String)"\u6570\u636e\u5220\u9664\u670d\u52a1\u4f20\u5165\u6570\u636e\u91cf\u662f%1$s\uff0c\u5df2\u8d85\u8fc7\u6700\u5927%2$s\u6761\u9650\u5236\uff0c\u8bf7\u4f18\u5316\u4ee3\u7801\u51cf\u5c11\u6570\u91cf\u6216\u8005\u5206\u6279\u5904\u7406\u3002", (String)"BusinessDMLLimiter_3", (String)"servicehelper", (Object[])new Object[]{count, limit.getMax()})));
        dmlTotalTimeoutService = new ThreadObjectStateService(RateLimiterConfigProvider.getDmlTotalTimeoutConfig().buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limit, count) -> ResManager.loadKDString((String)"\u6570\u636e\u64cd\u4f5c\u670d\u52a1\u7d2f\u8ba1\u8c03\u7528\u65f6\u95f4\u5df2\u8d85\u8fc7\u9650\u5236 %1$s \u79d2\uff0c\u8bf7\u4f18\u5316\u4ee3\u7801\u51cf\u5c11\u6267\u884c\u65f6\u95f4\u3002", (String)"BusinessDMLLimiter_4", (String)"bos-servicehelper", (Object[])new Object[]{limit.getMax()}))));
    }
}

