/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.operation;

import com.alibaba.fastjson.JSON;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dtx.DTXServiceHelper;
import kd.bos.dtx.XidInfo;
import kd.bos.dtx.util.Configuration;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.operation.BusinessDMLLimiter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.RecordSaveFormServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkService;

@KSObject
@SdkService(name="\u5355\u636e\u4fdd\u5b58\u670d\u52a1")
public class SaveServiceHelper {
    private static Log log = LogFactory.getLog(SaveServiceHelper.class);

    @KSMethod
    public static Object[] save(IDataEntityType type, Object[] dataEntities) {
        return SaveServiceHelper.save(type, dataEntities, true);
    }

    @KSMethod
    public static Object[] save(IDataEntityType type, Object[] dataEntities, OperateOption option) {
        String dbkey = type.getDBRouteKey();
        XidInfo xidInfo = DTXServiceHelper.prepareXid((String)dbkey);
        if (xidInfo != null && xidInfo.getState() == 1) {
            String op = xidInfo.getOperationResult();
            Object[] result = null;
            if (op != null) {
                result = dataEntities[0] instanceof DynamicObject ? DynamicObjectSerializeUtil.deserialize((String)op, (DynamicObjectType)((DynamicObject)dataEntities[0]).getDynamicObjectType()) : (Object[])JSON.parseObject((String)op, Object[].class);
            }
            return result;
        }
        long beginTime = BusinessDMLLimiter.checkSaveCallTimes();
        if (dataEntities != null && dataEntities.length > 0) {
            BusinessDMLLimiter.checkSaveSize(dataEntities.length);
        }
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Object[] result = BusinessDataWriter.save((IDataEntityType)type, (Object[])dataEntities, (OperateOption)option);
            if (Configuration.isEnable()) {
                if (dataEntities != null && dataEntities.length > 0 && dataEntities[0] instanceof DynamicObject) {
                    DTXServiceHelper.confirmXid((String)dbkey, result != null ? DynamicObjectSerializeUtil.serialize((Object[])result, (DynamicObjectType)((DynamicObject)dataEntities[0]).getDynamicObjectType()) : null);
                } else {
                    DTXServiceHelper.confirmXid((String)dbkey, (String)(result != null ? JSON.toJSONString((Object)result) : null));
                }
            }
            RecordSaveFormServiceHelper.recordSaveFormToCache((String)type.getName());
            BusinessDMLLimiter.checkDmlTimeout(beginTime);
            Object[] objectArray = result;
            return objectArray;
        }
        catch (Throwable e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @KSMethod
    public static Object[] save(IDataEntityType type, Object[] dataEntities, boolean commitSnapData) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("orm_commitPkSnapshot", String.valueOf(commitSnapData));
        option.setVariableValue("orm_removeDataCache", "true");
        return SaveServiceHelper.save(type, dataEntities, option);
    }

    @KSMethod
    public static Object[] save(DynamicObject[] dataEntities) {
        return SaveServiceHelper.save(dataEntities, true);
    }

    @KSMethod
    public static Object[] save(DynamicObject[] dataEntities, OperateOption option) {
        if (dataEntities.length > 0) {
            String dbkey = dataEntities[0].getDataEntityType().getDBRouteKey();
            XidInfo xidInfo = DTXServiceHelper.prepareXid((String)dbkey);
            if (xidInfo != null && xidInfo.getState() == 1) {
                String op = xidInfo.getOperationResult();
                Object[] result = null;
                if (op != null) {
                    result = DynamicObjectSerializeUtil.deserialize((String)op, (DynamicObjectType)dataEntities[0].getDynamicObjectType());
                }
                return result;
            }
            long beginTime = BusinessDMLLimiter.checkSaveCallTimes();
            BusinessDMLLimiter.checkSaveSize(dataEntities.length);
            Throwable throwable = null;
            try (TXHandle h = TX.required();){
                Object[] result = BusinessDataWriter.save((IDataEntityType)dataEntities[0].getDataEntityType(), (Object[])dataEntities, (OperateOption)option);
                if (Configuration.isEnable()) {
                    DTXServiceHelper.confirmXid((String)dbkey, result != null ? DynamicObjectSerializeUtil.serialize((Object[])result, (DynamicObjectType)dataEntities[0].getDynamicObjectType()) : null);
                }
                RecordSaveFormServiceHelper.recordSaveFormToCache((String)dataEntities[0].getDataEntityType().getName());
                BusinessDMLLimiter.checkDmlTimeout(beginTime);
                Object[] objectArray = result;
                return objectArray;
            }
            catch (Throwable e) {
                try {
                    h.markRollback();
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return dataEntities;
    }

    @KSMethod
    public static Object[] save(DynamicObject[] dataEntities, boolean commitSnapData) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("orm_commitPkSnapshot", String.valueOf(commitSnapData));
        option.setVariableValue("orm_removeDataCache", "true");
        return SaveServiceHelper.save(dataEntities, option);
    }

    @KSMethod
    public static void update(DynamicObject[] dataEntities) {
        OperateOption option = OperateOption.create();
        SaveServiceHelper.update(dataEntities, option);
    }

    @KSMethod
    public static void update(DynamicObject[] dataEntities, OperateOption option) {
        if (dataEntities.length > 0) {
            log.debug(String.format("update %s", dataEntities[0].getDataEntityType()));
            long beginTime = BusinessDMLLimiter.checkUpdateCallTimes();
            BusinessDMLLimiter.checkUpdateSize(dataEntities.length);
            try (TXHandle h = TX.required();){
                try {
                    BusinessDataWriter.update((IDataEntityType)dataEntities[0].getDataEntityType(), (Object[])dataEntities, (OperateOption)option);
                    BusinessDMLLimiter.checkDmlTimeout(beginTime);
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    @KSMethod
    public static void update(DynamicObject dataEntity) {
        OperateOption option = OperateOption.create();
        SaveServiceHelper.update(new DynamicObject[]{dataEntity}, option);
    }

    @KSMethod
    public static void update(DynamicObject dataEntity, OperateOption option) {
        SaveServiceHelper.update(new DynamicObject[]{dataEntity}, option);
    }

    @SdkInternal
    public static OperationResult saveOperate(String entityNumber, DynamicObject[] dataEntities) {
        return SaveServiceHelper.saveOperate(entityNumber, dataEntities, OperateOption.create());
    }

    public static OperationResult saveOperate(String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        if (dataEntities != null) {
            Operations operations = EntityMetadataCache.getDataEntityOperations((String)entityNumber);
            return OperationServiceHelper.executeOperate((String)(operations.getSave() == null ? "save" : operations.getSave()), (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        }
        return new OperationResult();
    }

    @SdkInternal
    public static OperationResult saveOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities) {
        return SaveServiceHelper.saveOperate(operationKey, entityNumber, dataEntities, OperateOption.create());
    }

    public static OperationResult saveOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        if (dataEntities != null) {
            return OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        }
        return new OperationResult();
    }

    public static void clearDataEntityCache(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (type == null) {
            return;
        }
        BusinessDataWriter.clearDataEntityCache((IDataEntityType)type);
    }
}

