/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.cache;

import java.util.Map;
import java.util.function.IntSupplier;
import kd.bos.dataentity.limiter.CountLimiterPolicy;
import kd.bos.dataentity.limiter.ICreator;
import kd.bos.dataentity.limiter.IRateLimiter;
import kd.bos.dataentity.limiter.LimiterIntConfig;
import kd.bos.dataentity.resource.ResManager;

final class PageCacheLimiterService {
    public static final String BOS_FORM_MVC = "bos-form-mvc";
    static final LimiterIntConfig target = new LimiterIntConfig("bos.pagecache.keysize.limit", 0x500000, -1);
    static final ICreator<IRateLimiter> policy = target.buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limiter, count) -> String.format(ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u6700\u5927\u5141\u8bb8\u5b57\u8282\u6570\uff1a%1$s\uff0c\u5f53\u524d\u8f93\u5165\u5b57\u8282\u6570\uff1a%2$s\u3002", (String)"PageCacheLimit_0", (String)BOS_FORM_MVC, (Object[])new Object[0]), limiter.getMax(), count)));
    static final LimiterIntConfig bigObjTarget = new LimiterIntConfig("bos.pagecache.bigobj.keysize.limit", 0x1400000, -1);
    static final ICreator<IRateLimiter> bitObjPolicy = bigObjTarget.buildLimiterPolicy(config -> new CountLimiterPolicy((IntSupplier)config, (limiter, count) -> String.format(ResManager.loadKDString((String)"\u9875\u9762\u7f13\u5b58\u5927\u5bf9\u8c61\u6700\u5927\u5141\u8bb8\u5b57\u8282\u6570\uff1a%1$s\uff0c\u5f53\u524d\u8f93\u5165\u5b57\u8282\u6570\uff1a%2$s\u3002", (String)"PageCacheLimit_1", (String)BOS_FORM_MVC, (Object[])new Object[0]), limiter.getMax(), count)));

    PageCacheLimiterService() {
    }

    public static LimiterIntConfig getLimiterConfig() {
        return target;
    }

    public static void limitSize(Map<String, String> values) {
        if (values == null) {
            return;
        }
        int cacheSize = 0;
        for (Map.Entry<String, String> entry : values.entrySet()) {
            int length = 0;
            if (entry.getValue() != null) {
                length = entry.getValue().length();
            }
            cacheSize += length;
        }
        ((IRateLimiter)policy.create()).acquire(cacheSize);
    }

    public static void limitBigObjSize(int size) {
        ((IRateLimiter)bitObjPolicy.create()).acquire(size);
    }

    public static LimiterIntConfig getBigObjLimiterConfig() {
        return bigObjTarget;
    }
}

