/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin.dataprovider;

import com.ibm.icu.util.Calendar;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.license.UpdateLicGroupUser;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.engine.LicenseSnapshotEngine;
import kd.bos.license.engine.LicenseUserRelEngine;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.license.util.UserLicenseGroupUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;

public class LicenseGroupConsumeProvider
extends ListDataProvider {
    private static final String ENTITY_SNAPSHOT = "lic_snapshot";
    private static final String GROUPINFO_ENTITY = "lic_groupconsumedetail";
    private static final String GROUP_NAME = "group_name";
    private static final String GROUP_TOTAL = "group_total";
    private static final String GROUP_USED = "group_used";
    private static final String GROUP_UNSYNC = "group_unsync";
    private static final String GROUP_WARN = "group_warn";
    private IFormView view = null;
    private int dataCount = 0;
    private String AFTER_NOW = ResManager.loadKDString((String)"\uff08\u5df2\u8fc7\u671f\uff09", (String)"UserLicenseGroupListPlugin_103", (String)"bos-license-formplugin", (Object[])new Object[0]);
    private String BEFORE_NOW = ResManager.loadKDString((String)"\uff08\u672a\u751f\u6548\uff09", (String)"UserLicenseGroupListPlugin_104", (String)"bos-license-formplugin", (Object[])new Object[0]);
    private static final int MAX_TOTAL_COUNT = 999999;
    private static final Log logger = LogFactory.getLog(LicenseGroupConsumeProvider.class);

    public LicenseGroupConsumeProvider() {
    }

    public LicenseGroupConsumeProvider(IFormView view) {
        this.view = view;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObject[] licensesObj;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)GROUPINFO_ENTITY);
        DynamicObjectCollection curPageData = new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
        HashMap<String, DynamicObject> groupInfos = new HashMap<String, DynamicObject>(16);
        HashSet<Integer> greyRow = new HashSet<Integer>(16);
        HashMap<String, String> greyKeyAndDate = new HashMap<String, String>(16);
        String legalPernsonId = null;
        boolean enableLegalPersonAssign = UserLicenseGroupUtil.isEnableLegalPersonAssign();
        if (null != this.view && enableLegalPersonAssign) {
            legalPernsonId = this.view.getPageCache().get("legalpersonId");
        }
        if (null == (licensesObj = BusinessDataServiceHelper.load((String)"lic_license", (String)"lic_licensedetail.group,lic_licensedetail.totalcount,lic_licensedetail.assignedcount,lic_licensedetail.begindate,lic_licensedetail.enddate", null)) || licensesObj.length == 0 || enableLegalPersonAssign && StringUtils.isEmpty((CharSequence)legalPernsonId)) {
            return curPageData;
        }
        boolean isLegalPernson = enableLegalPersonAssign && !"0".equals(legalPernsonId);
        HashMap unSyncCount = new HashMap(16);
        HashMap warnCount = new HashMap(16);
        HashMap syncCount = new HashMap(16);
        HashMap legalPernsonTotal = new HashMap(16);
        HashMap groupInfoCurrDataCenter = new HashMap(16);
        ArrayList groupIds = new ArrayList(16);
        StringBuilder sql = new StringBuilder();
        if (isLegalPernson) {
            sql.append("select fgroupid,fsyncstatus,count(1) fcount from t_lic_userlicensegroup where forgid = ");
            sql.append(legalPernsonId);
            sql.append(" group by fgroupid ,fsyncstatus");
            DB.query((DBRoute)DBRoute.base, (String)("select fgroupid,fassignednum,fusednum from T_LIC_LEGALASSIGN where forgid = " + legalPernsonId), rs -> {
                while (rs.next()) {
                    legalPernsonTotal.put(rs.getString("fgroupid"), rs.getInt("fassignednum"));
                }
                return null;
            });
        } else {
            sql.append("select fgroupid,fsyncstatus,count(1) fcount from t_lic_userlicensegroup  group by fgroupid ,fsyncstatus");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DB.query((DBRoute)DBRoute.base, (String)sql.toString(), rs -> {
            while (rs.next()) {
                String id = rs.getString("fgroupid");
                String status = rs.getString("fsyncstatus");
                int count = rs.getInt("fcount");
                Integer[] licenseCount = groupInfoCurrDataCenter.computeIfAbsent(id, k -> new Integer[3]);
                if ("1".equals(status)) {
                    licenseCount[0] = count;
                    syncCount.put(id, count);
                    continue;
                }
                if ("2".equals(status)) {
                    licenseCount[1] = count;
                    unSyncCount.put(id, count);
                    continue;
                }
                Integer wcount = (Integer)warnCount.get(id);
                if (null == wcount) {
                    licenseCount[2] = count;
                    warnCount.put(id, count);
                    continue;
                }
                Integer[] integerArray = licenseCount;
                Integer.valueOf(integerArray[2] + count);
                warnCount.put(id, count + wcount);
            }
            return null;
        });
        Map licenseGroupName = LicenseGroupUtil.getLicenseGroup(null);
        DynamicObjectCollection allLicenseDetail = null;
        for (DynamicObject licenseObj : licensesObj) {
            if (null == allLicenseDetail) {
                allLicenseDetail = (DynamicObjectCollection)licenseObj.get("lic_licensedetail");
                continue;
            }
            allLicenseDetail.addAll((Collection)((DynamicObjectCollection)licenseObj.get("lic_licensedetail")));
        }
        if (null == allLicenseDetail || allLicenseDetail.isEmpty()) {
            return curPageData;
        }
        Collator chineseComparator = Collator.getInstance(Locale.CHINESE);
        allLicenseDetail.sort((dy1, dy2) -> {
            int comparedy2;
            Date beginDate1 = dy1.getDate("begindate");
            Date endDate1 = dy1.getDate("enddate");
            Date beginDate2 = dy2.getDate("begindate");
            Date endDate2 = dy2.getDate("enddate");
            int comparedy1 = this.compareNow(beginDate1, endDate1);
            if (comparedy1 == (comparedy2 = this.compareNow(beginDate2, endDate2))) {
                String name2;
                String name1 = (String)licenseGroupName.get(dy1.getString("group.id"));
                if (StringUtils.isEmpty((CharSequence)name1)) {
                    name1 = dy1.getString("group.name");
                }
                if (StringUtils.isEmpty((CharSequence)(name2 = (String)licenseGroupName.get(dy2.getString("group.id"))))) {
                    name2 = dy2.getString("group.name");
                }
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return 1;
                }
                if (name2 == null) {
                    return -1;
                }
                return chineseComparator.compare(name1, name2);
            }
            return comparedy1 > comparedy2 ? -1 : 1;
        });
        Map licAllocateNumberByGroupIds = new HashMap(0);
        if (!LicenseCache.isCtrlAmountIgnoreTime() && !isLegalPernson) {
            DB.query((DBRoute)DBRoute.base, (String)"select b.fgroupid from t_lic_group a join t_lic_licensedetail b on a.fid  =  b.fgroupid where a.ftype = '1'", rs -> {
                while (rs.next()) {
                    groupIds.add(rs.getLong("fgroupid"));
                }
                return null;
            });
            licAllocateNumberByGroupIds = LicenseUserRelEngine.getLicAllocateNumberByGroupIds(groupIds);
        }
        boolean isNeedUpdate = false;
        this.dataCount = 0;
        for (DynamicObject licensedetail : allLicenseDetail) {
            Integer count;
            DynamicObject listRow = new DynamicObject((DynamicObjectType)dataEntityType);
            if (!this.showLeftTreeLicenseGroup(licensedetail)) continue;
            String id = licensedetail.getString("group.id");
            listRow.set("id", (Object)id);
            String name = (String)licenseGroupName.get(id);
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = licensedetail.getString("group.name");
            }
            listRow.set(GROUP_NAME, (Object)name);
            int totalcount = licensedetail.getInt("totalcount");
            int assignedcount = licensedetail.getInt("assignedcount");
            if (isLegalPernson) {
                Integer integer = (Integer)legalPernsonTotal.get(id);
                if (null == integer) continue;
                Integer count2 = (Integer)syncCount.get(id);
                assignedcount = null == count2 ? 0 : count2;
                totalcount = integer;
            }
            if (null != licAllocateNumberByGroupIds && null != (count = (Integer)licAllocateNumberByGroupIds.get(Long.parseLong(id)))) {
                assignedcount = count;
                if (count > totalcount) {
                    isNeedUpdate = true;
                    assignedcount = totalcount;
                }
            }
            listRow.set(GROUP_TOTAL, (Object)totalcount);
            listRow.set(GROUP_USED, (Object)assignedcount);
            Integer uCount = (Integer)unSyncCount.get(id);
            uCount = null == uCount ? Integer.valueOf(0) : uCount;
            listRow.set(GROUP_UNSYNC, (Object)uCount);
            Integer wCount = (Integer)warnCount.get(id);
            wCount = null == wCount ? Integer.valueOf(0) : wCount;
            listRow.set(GROUP_WARN, (Object)wCount);
            Date beginDate = licensedetail.getDate("begindate");
            Date endDate = licensedetail.getDate("enddate");
            if (null != beginDate && null != endDate) {
                Date now = TimeServiceHelper.now();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endDate);
                calendar.set(10, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                endDate = calendar.getTime();
                if (now.before(beginDate)) {
                    listRow.set(GROUP_NAME, (Object)(name + this.BEFORE_NOW));
                    greyRow.add(this.dataCount);
                    greyKeyAndDate.put(id, sdf.format(beginDate));
                } else if (now.after(endDate)) {
                    greyRow.add(this.dataCount);
                    listRow.set(GROUP_NAME, (Object)(name + this.AFTER_NOW));
                }
            }
            ++this.dataCount;
            curPageData.add((Object)listRow);
            groupInfos.put(id, listRow);
        }
        if (isNeedUpdate) {
            LicenseSyncLog licenseSyncLog = new LicenseSyncLog();
            DynamicObject[] snapshots = BusinessDataServiceHelper.load((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
            if (snapshots == null || snapshots.length == 0) {
                LicenseGroupConsumeProvider.downloadAndUpdateLic(true, licenseSyncLog);
                snapshots = BusinessDataServiceHelper.load((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
            }
            Arrays.sort(snapshots, (o1, o2) -> {
                int type1 = Integer.parseInt(o1.getString("snapshottype"));
                int type2 = Integer.parseInt(o2.getString("snapshottype"));
                return type1 - type2;
            });
            String data = snapshots[snapshots.length - 1].getString("data");
            LicenseSnapshotEngine.restoreSnap((String)data, (boolean)true);
        }
        if (null != this.view) {
            IPageCache pageCache = this.view.getPageCache();
            pageCache.put("groupInfo", SerializationUtils.toJsonString(groupInfos));
            pageCache.put("colorColumn", SerializationUtils.toJsonString(greyRow));
            pageCache.put("keyAndBeginDate", SerializationUtils.toJsonString(greyKeyAndDate));
            pageCache.put("groupInfoCurrDC", SerializationUtils.toJsonString(groupInfoCurrDataCenter));
        }
        this.getQueryResult().setDataCount(this.dataCount);
        this.getQueryResult().setCollection(curPageData);
        return curPageData;
    }

    private boolean showLeftTreeLicenseGroup(DynamicObject licensedetail) {
        String type = licensedetail.getString("group.type");
        if (!"1".equals(type)) {
            return false;
        }
        int totalCount = licensedetail.getInt("totalcount");
        return 999999 != totalCount;
    }

    private int compareNow(Date beginDate, Date endDate) {
        if (null != beginDate && null != endDate) {
            Date now = TimeServiceHelper.now();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            endDate = calendar.getTime();
            if (now.before(beginDate)) {
                return 0;
            }
            if (now.after(endDate)) {
                return -1;
            }
        }
        return 1;
    }

    private static void downloadAndUpdateLic(boolean isHighAvailabilityMode, LicenseSyncLog licenseSyncLog) {
        UpdateLicGroupUser updateLicGroupUser = new UpdateLicGroupUser();
        boolean updateLicenseResult = false;
        try {
            updateLicenseResult = updateLicGroupUser.downloadAndUpdateLicUser(true, licenseSyncLog, isHighAvailabilityMode);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (Throwable)e);
        }
        if (null != licenseSyncLog) {
            licenseSyncLog.setOperator(Long.valueOf(-10000L));
        }
        if (!updateLicenseResult) {
            logger.error("\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38");
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (String)"LicenseCache_0", (String)"bos-license-business", (Object[])new Object[0]));
        }
    }

    public int getDataCount() {
        return this.dataCount;
    }

    public int getRealCount() {
        return this.dataCount;
    }

    public boolean isEffect(Date beginDate, Date endDate) {
        if (null == beginDate || null == endDate) {
            return false;
        }
        Date now = TimeServiceHelper.now();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        endDate = calendar.getTime();
        return !now.before(beginDate) && !now.after(endDate);
    }

    public int getMaxCount() {
        return this.dataCount;
    }

    public int getMaxReturnData() {
        return this.dataCount;
    }
}

