/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.license.LicenseServiceUtil;
import kd.bos.license.bean.LicenseSyncDetailLog;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.license.util.LicenseTaskUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class LicenseUpdateService {
    private static final String SELECT_LICENSE_FIELDS = "tid,name,softwarename,prodinstcode,productno,type,activedate,expdate,industry,productversion,prodid,scenetype,lic_licensedetail.group,lic_licensedetail.totalcount,lic_licensedetail.assignedcount,lic_licensedetail.remaincount,lic_licensedetail.begindate,lic_licensedetail.enddate,licensegroupapps,licensegroupapps.bizapp,licensegroupapps.module,licensegroupapps.modulebegindate,licensegroupapps.moduleenddate";
    private static final String SELECT_USER_LIC_FIELDS = "user,group.number,syncstatus,status";
    private static final String MCTEMPORARYLICENSE = "MCTEMPORARYLICENSE";
    private static final String PROP_REMAINCOUNT = "remaincount";
    private static final String PROP_ASSIGNEDCOUNT = "assignedcount";
    private static final String PROP_TOTALCOUNT = "totalcount";
    private static final String PROP_BEGINDATE = "begindate";
    private static final String PROP_ENDDATE = "enddate";
    private static final String PROP_GROUP = "group";
    private static final String PROP_EXPDATE = "expdate";
    private static final String PROP_PROD = "prodid";
    private static final String PROP_BIZAPP = "bizapp";
    private static final String PROP_MODULE = "module";
    private String userLicenseGroupEntity = "lic_userlicensegroup";
    private String userLicenseGroupTable = "t_lic_userlicensegroup";
    private String licenseEntity = "lic_license";
    private String licenseDetailEntity = "lic_licensedetail";
    private String licenseDetailTable = "t_lic_licensedetail";
    private String licenseGroupAppsEntity = "licensegroupapps";
    private String licenseGroupAppsTable = "T_LIC_LICENSEGROUPAPPS";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_SYNC_STATUS = "syncstatus";
    private static final String LIC_GROUP = "lic_group";
    private static final String LIC_MODULE = "lic_module";
    private static final Log logger = LogFactory.getLog(LicenseUpdateService.class);
    private Map<String, Object> result;
    private Map<String, Map<String, Map<String, Object>>> group2Module2Info = new HashMap<String, Map<String, Map<String, Object>>>();
    private static final String[] presetModuleNumbers = new String[]{"DPA", "OCBMALL", "BBC", "OCBSOC", "MDR", "DMA", "OCDMA", "TRA", "KDEM", "EXP", "SAA", "OCSAA"};
    private static final Map<String, Integer> WaterMarkPriority = new HashMap<String, Integer>();

    public Map<String, Map<String, Map<String, Object>>> getGroup2Module2Info() {
        return this.group2Module2Info;
    }

    public void setGroup2Module2Info(Map<String, Map<String, Map<String, Object>>> group2Module2Info) {
        this.group2Module2Info = group2Module2Info;
    }

    public LicenseUpdateService(Map<String, Object> result) {
        result.put("exceptionGroupMsg", "");
        result.put("exceptionGroupIds", new HashSet(16));
        this.result = result;
    }

    public List<String> saveOrUpdateLicInfo(List<Map<String, Object>> contentMaps, Map<String, Long> licGroupInfo, Map<String, Object> groupAll, Map<String, Integer> groupCount, Map<String, Set<String>> groupModules) throws ParseException {
        return this.saveOrUpdateLicInfo(contentMaps, licGroupInfo, groupAll, groupCount, groupModules, LicenseUtil.isHighAvailabilityMode());
    }

    public List<String> saveOrUpdateLicInfo(List<Map<String, Object>> contentMaps, Map<String, Long> licGroupInfo, Map<String, Object> groupAll, Map<String, Integer> groupCount, Map<String, Set<String>> groupModules, boolean isTest) throws ParseException {
        return this.saveOrUpdateLicInfo(contentMaps, licGroupInfo, groupAll, groupCount, groupModules, isTest, null);
    }

    public List<String> saveOrUpdateLicInfo(List<Map<String, Object>> contentMaps, Map<String, Long> licGroupInfo, Map<String, Object> groupAll, Map<String, Integer> groupCount, Map<String, Set<String>> groupModules, boolean isTest, LicenseSyncLog licenseSyncLog) throws ParseException {
        if (isTest) {
            this.licenseEntity = "lic_license_trial";
            this.licenseDetailTable = "t_lic_licdetail_trial";
            this.licenseGroupAppsTable = "t_lic_licgroupapps_trial";
            this.userLicenseGroupEntity = "lic_userlicgroup_trial";
            this.userLicenseGroupTable = "t_lic_userlicgroup_trial";
        }
        ArrayList<String> productInstCodes = new ArrayList<String>(contentMaps.size());
        boolean isTemporaryLicense = false;
        boolean isShowWaterMark = false;
        PriorityQueue<String> sceneTypePriorityQueue = LicenseUpdateService.buildSceneTypePriorityQueue();
        DynamicObject[] licenses = BusinessDataServiceHelper.load((String)this.licenseEntity, (String)SELECT_LICENSE_FIELDS, null);
        String srcVer = "";
        String desVer = "";
        if (licenses != null && licenses.length > 0) {
            for (DynamicObject licenseObj : licenses) {
                srcVer = licenseObj.getString("productversion");
            }
        }
        Date latestUpdateDate = null;
        String latestUpdateProdinstcode = null;
        for (Map<String, Object> contentMap : contentMaps) {
            boolean showWatermark;
            Object source = contentMap.get("source");
            boolean isFromKBC = source != null && source.toString().contains("KBC");
            boolean isTemporaryLicenseCurr = MCTEMPORARYLICENSE.equals(contentMap.get("regUsers")) || LicenseUpdateService.isTrial(contentMap, isFromKBC);
            isTemporaryLicense = isTemporaryLicense || isTemporaryLicenseCurr;
            Object showWatermarkObj = contentMap.get("showWatermark");
            boolean bl = showWatermark = showWatermarkObj == null ? true : Boolean.parseBoolean(showWatermarkObj.toString());
            if (showWatermark) {
                isShowWaterMark = true;
                String tempSceneType = isTemporaryLicenseCurr ? "TEMP" : (contentMap.get("sceneType") == null ? "" : contentMap.get("sceneType").toString());
                sceneTypePriorityQueue.add(tempSceneType);
            }
            boolean isContainCriGroup = false;
            Object versionObj = contentMap.get("productVersion");
            if (versionObj != null) {
                desVer = versionObj.toString();
            }
            String productInstanceID = contentMap.get("productInstanceID").toString();
            Object moduleDetails = contentMap.get("moduleDetails");
            List moduleList = (List)JSONObject.parseObject((String)moduleDetails.toString(), List.class);
            int size = moduleList.size();
            HashSet<String> licenseDetail = new HashSet<String>(size);
            Object createDate = contentMap.get("createDate");
            Object expireDate = contentMap.get("expireDate");
            HashMap<String, Date> groupBeginDate = new HashMap<String, Date>(size);
            HashMap<String, Date> groupEndDate = new HashMap<String, Date>(size);
            for (Map moduleInfo : moduleList) {
                Object endDateObj;
                if (moduleInfo == null || moduleInfo.get("moduleName") == null) continue;
                String moduleName = moduleInfo.get("moduleName").toString();
                moduleName = StringUtils.isBlank((CharSequence)moduleName) ? "" : moduleName.trim();
                isContainCriGroup = isContainCriGroup || "G_RSRI".equals(moduleName);
                licenseDetail.add(moduleName);
                Object beginDateObj = moduleInfo.get("beginDate");
                if (beginDateObj == null) {
                    beginDateObj = createDate;
                }
                if ((endDateObj = moduleInfo.get("endDate")) == null) {
                    endDateObj = expireDate;
                }
                groupBeginDate.put(moduleName, LicenseUpdateService.parseObject2Date(beginDateObj));
                groupEndDate.put(moduleName, LicenseUpdateService.parseObject2EndDate(endDateObj));
                Object rentRange = moduleInfo.get("rentRange");
                if (rentRange == null) continue;
                Date now = TimeServiceHelper.now();
                List rentRangeList = (List)JSONObject.parseObject((String)rentRange.toString(), List.class);
                if (rentRangeList == null || rentRangeList.isEmpty()) continue;
                boolean isHit = false;
                Date hitBeginDate = null;
                for (Map rentMap : rentRangeList) {
                    beginDateObj = rentMap.get("beginDate");
                    endDateObj = rentMap.get("endDate");
                    if (beginDateObj == null || endDateObj == null) continue;
                    Date beginDate = LicenseUpdateService.parseObject2Date(beginDateObj);
                    Date endDate = LicenseUpdateService.parseObject2EndDate(endDateObj);
                    if (!beginDate.before(now) || !endDate.after(now)) continue;
                    isHit = true;
                    hitBeginDate = beginDate;
                    groupBeginDate.put(moduleName, beginDate);
                    groupEndDate.put(moduleName, endDate);
                }
                if (!isHit) {
                    Date beginDate;
                    beginDateObj = ((Map)rentRangeList.get(0)).get("beginDate");
                    endDateObj = ((Map)rentRangeList.get(0)).get("endDate");
                    if (beginDateObj == null || endDateObj == null) continue;
                    hitBeginDate = beginDate = LicenseUpdateService.parseObject2Date(beginDateObj);
                    groupBeginDate.put(moduleName, beginDate);
                    groupEndDate.put(moduleName, LicenseUpdateService.parseObject2EndDate(endDateObj));
                }
                if (rentRangeList.size() <= 1) continue;
                for (Map rentMap : rentRangeList) {
                    Object beginDateOb = rentMap.get("beginDate");
                    if (null == beginDateOb) continue;
                    Date beginDate = LicenseUpdateService.parseObject2Date(beginDateOb);
                    if (null == hitBeginDate || !hitBeginDate.before(beginDate)) continue;
                    if (null == latestUpdateDate) {
                        latestUpdateDate = beginDate;
                        latestUpdateProdinstcode = productInstanceID;
                        continue;
                    }
                    if (latestUpdateDate.before(beginDate)) continue;
                    latestUpdateDate = beginDate;
                    latestUpdateProdinstcode = productInstanceID;
                }
            }
            if (!isTest && isContainCriGroup) {
                this.putLicExpireTimeCache(contentMap);
            }
            if (licenses == null || licenses.length == 0) {
                this.insertLicense(contentMap, licGroupInfo, groupAll, groupCount, licenseDetail, groupModules, groupBeginDate, groupEndDate);
                productInstCodes.add(productInstanceID);
                continue;
            }
            boolean isFound = false;
            for (DynamicObject license : licenses) {
                String prodInstCode = license.getString("prodinstcode");
                if (null == productInstanceID || !productInstanceID.equals(prodInstCode)) continue;
                this.updatePubCloudLic(contentMap, licGroupInfo, groupAll, license, licenseDetail, groupModules, groupBeginDate, groupEndDate, groupCount);
                productInstCodes.add(productInstanceID);
                isFound = true;
            }
            if (isFound) continue;
            this.pubCloudExchangeLicenseProduct(contentMap, licGroupInfo, groupAll, groupCount, licenseDetail, groupModules, groupBeginDate, groupEndDate);
            productInstCodes.add(productInstanceID);
        }
        if (null != latestUpdateDate) {
            LicenseTaskUtil.createPlanInfoUpdateLicAndRestore(latestUpdateDate, latestUpdateProdinstcode);
        }
        logger.info("LicenseUpdateService.saveOrUpdateLicInfo:sceneTypePriorityQueue={}", (Object)sceneTypePriorityQueue.toString());
        String sceneType = sceneTypePriorityQueue.poll();
        this.updateTempLicCache(isTemporaryLicense, isShowWaterMark, isTest, sceneType);
        if (LicenseServiceUtil.isEnableLegalPersonAssign() && !isTest) {
            LicenseUpdateService.computeLegalPersonAssign(licenseSyncLog);
        }
        if (Float.parseFloat(desVer) >= 4.0f && !srcVer.equals(desVer) && !isTest) {
            this.updateUserLicenseData4V4();
        }
        return productInstCodes;
    }

    private static void computeLegalPersonAssign(LicenseSyncLog log) {
        List logs = null;
        Map allGroupIdAndName = null;
        Map allGroupIdAndNumber = null;
        if (null != log) {
            logs = log.getLogs();
            allGroupIdAndName = LicenseGroupUtil.getAllGroupIdAndName(null);
            allGroupIdAndNumber = LicenseGroupUtil.getAllGroupIdAndNumber();
        }
        try {
            DynamicObject[] licenses;
            Map licenseDetail;
            Long groupId;
            HashMap<String, Integer> exceptionCount = new HashMap<String, Integer>(16);
            HashMap usedMap = new HashMap();
            String sql = "SELECT FORGID ORGID, FGROUPID GROUPID, count(1) ucount FROM T_LIC_USERLICENSEGROUP ulg WHERE FSYNCSTATUS = '1' GROUP BY FORGID, FGROUPID";
            DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
                while (k.next()) {
                    Long legalPersonId = k.getLong("ORGID");
                    Long groupId = k.getLong("GROUPID");
                    Integer count = k.getInt("ucount");
                    usedMap.put(legalPersonId + "_" + groupId, count);
                }
                return true;
            });
            DynamicObject[] legalPersonAssign = BusinessDataServiceHelper.load((String)"lic_legalassign", (String)"group, org, assignednum, usednum", null);
            if (legalPersonAssign != null && legalPersonAssign.length > 0) {
                for (DynamicObject dynamicObject : legalPersonAssign) {
                    groupId = dynamicObject.getLong("group_id");
                    Long legalPersonId = dynamicObject.getLong("org_id");
                    int assignedNum = dynamicObject.getInt("assignednum");
                    String key = legalPersonId + "_" + groupId;
                    Integer usedNum = (Integer)usedMap.get(key);
                    if (null == usedNum) {
                        dynamicObject.set("usednum", (Object)0);
                    } else if (assignedNum < usedNum) {
                        dynamicObject.set("usednum", (Object)assignedNum);
                        exceptionCount.put(key, usedNum - assignedNum);
                        if (null != log) {
                            String opDescription = String.format(ResManager.loadKDString((String)"%1$s\u7ad9\u70b9\u6570\u4e0d\u8db3\u3002", (String)"UpdateLicGroupUser_36", (String)"bos-license-business", (Object[])new Object[0]), (String)allGroupIdAndName.get(groupId) + "(" + (String)allGroupIdAndNumber.get(groupId) + ")");
                            LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u6587\u4ef6", (String)"UpdateLicGroupUser_0", (String)"bos-license-business", (Object[])new Object[0]), (String)opDescription);
                            LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
                            licenseSyncDetailLog.setLogType("3");
                            licenseSyncDetailLog.setOperation("reduceTotal");
                            licenseSyncDetailLog.setDescription(opDescription);
                            licenseSyncDetailLog.setSuccess(false);
                            logs.add(licenseSyncDetailLog);
                        }
                    } else {
                        dynamicObject.set("usednum", (Object)usedNum);
                    }
                    usedMap.remove(key);
                }
                SaveServiceHelper.save((DynamicObject[])legalPersonAssign);
            }
            if (!usedMap.isEmpty()) {
                ArrayList<Object[]> param = new ArrayList<Object[]>(16);
                for (String str : usedMap.keySet()) {
                    String[] split = str.split("_");
                    groupId = Long.valueOf(split[1]);
                    Object[] sqlParam = new Object[]{Long.valueOf(split[0]), Long.valueOf(split[1])};
                    param.add(sqlParam);
                    if (null == log) continue;
                    String opDescription = String.format(ResManager.loadKDString((String)"%1$s\u7ad9\u70b9\u6570\u4e0d\u8db3\u3002", (String)"UpdateLicGroupUser_36", (String)"bos-license-business", (Object[])new Object[0]), (String)allGroupIdAndName.get(groupId) + "(" + (String)allGroupIdAndNumber.get(groupId) + ")");
                    LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u6587\u4ef6", (String)"UpdateLicGroupUser_0", (String)"bos-license-business", (Object[])new Object[0]), (String)opDescription);
                    LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
                    licenseSyncDetailLog.setLogType("3");
                    licenseSyncDetailLog.setOperation("reduceTotal");
                    licenseSyncDetailLog.setDescription(opDescription);
                    licenseSyncDetailLog.setSuccess(false);
                    logs.add(licenseSyncDetailLog);
                }
                if (!param.isEmpty()) {
                    sql = "UPDATE T_LIC_USERLICENSEGROUP SET FSYNCSTATUS = '3', FSTATUS = '0',fsynclogid = " + (null == log ? 0L : log.getPkId()) + " WHERE FORGID = ? AND FGROUPID = ?";
                    DB.executeBatch((DBRoute)DBRoute.base, (String)sql, param);
                }
            }
            if (!exceptionCount.isEmpty()) {
                HashSet<Long> ids = new HashSet<Long>(16);
                for (Map.Entry countMap : exceptionCount.entrySet()) {
                    Integer reCount = (Integer)countMap.getValue();
                    String key = (String)countMap.getKey();
                    if (null == reCount || reCount <= 0 || null == key) continue;
                    String[] split = key.split("_");
                    SqlBuilder selectTopSql = new SqlBuilder();
                    selectTopSql.append("select top ", new Object[0]);
                    selectTopSql.append(String.valueOf(reCount), new Object[0]);
                    selectTopSql.append(" fid from ", new Object[0]);
                    selectTopSql.append("T_LIC_USERLICENSEGROUP", new Object[0]);
                    selectTopSql.append(" where FORGID = ", new Object[0]).append(split[0], new Object[0]).append(" and ", new Object[0]);
                    selectTopSql.append("FGROUPID = ", new Object[0]).append(split[1], new Object[0]);
                    selectTopSql.append(" order by fassigntime desc ", new Object[0]);
                    DB.query((DBRoute)DBRoute.base, (SqlBuilder)selectTopSql, k -> {
                        HashSet<Long> result = new HashSet<Long>(16);
                        while (k.next()) {
                            result.add(k.getLong("fid"));
                        }
                        ids.addAll(result);
                        return result;
                    });
                    LicenseUpdateService.updateLicSyncStatus(ids, log);
                }
            }
            if (!(licenseDetail = (Map)DB.query((DBRoute)DBRoute.base, (String)(sql = "SELECT FGROUPID GROUPID, count(1) ucount FROM T_LIC_USERLICENSEGROUP ulg WHERE FSYNCSTATUS = '1' GROUP BY FGROUPID"), k -> {
                HashMap<Long, Integer> licensedetail = new HashMap<Long, Integer>(16);
                while (k.next()) {
                    Long groupId = k.getLong("GROUPID");
                    Integer count = k.getInt("ucount");
                    licensedetail.put(groupId, count);
                }
                return licensedetail;
            })).isEmpty() && (licenses = BusinessDataServiceHelper.load((String)"lic_license", (String)SELECT_LICENSE_FIELDS, null)) != null && licenses.length > 0) {
                for (DynamicObject licenseObj : licenses) {
                    DynamicObjectCollection licenseDetailCol = licenseObj.getDynamicObjectCollection("lic_licensedetail");
                    if (licenseDetailCol == null || licenseDetailCol.isEmpty()) continue;
                    for (DynamicObject licenseDetailObj : licenseDetailCol) {
                        DynamicObject group = licenseDetailObj.getDynamicObject(PROP_GROUP);
                        String groupType = group.getString("type");
                        if (!groupType.equals("1")) continue;
                        Long groupId2 = Long.valueOf(group.getPkValue().toString());
                        Integer assigned = (Integer)licenseDetail.get(groupId2);
                        if (assigned == null) {
                            assigned = 0;
                        }
                        int totalcount = licenseDetailObj.getInt(PROP_TOTALCOUNT);
                        licenseDetailObj.set(PROP_ASSIGNEDCOUNT, (Object)assigned);
                        licenseDetailObj.set(PROP_REMAINCOUNT, (Object)(totalcount - assigned));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])licenses);
            }
        }
        catch (Exception e) {
            logger.error("LicenseUpdateService.saveOrUpdateLicInfo() update t_lic_legalassign error.", (Throwable)e);
        }
    }

    private static void updateLicSyncStatus(Set<Long> exceptionIdSet, LicenseSyncLog log) {
        if (kd.bos.util.CollectionUtils.isEmpty(exceptionIdSet)) {
            return;
        }
        SqlBuilder updateSql = new SqlBuilder().append("UPDATE T_LIC_USERLICENSEGROUP SET FSYNCSTATUS = '3', FSTATUS = '0',fsynclogid = ", new Object[0]).append(null == log ? "0" : String.valueOf(log.getPkId()), new Object[0]).append(" WHERE ", new Object[0]);
        updateSql.appendIn("FID", new ArrayList<Long>(exceptionIdSet));
        DB.execute((DBRoute)DBRoute.base, (SqlBuilder)updateSql);
    }

    public static void computeLegalPersonAssign() {
        LicenseUpdateService.computeLegalPersonAssign(null);
    }

    private void updateUserLicenseData4V4() {
        String sql;
        LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u540c\u6b65\u8bb8\u53ef", (String)"LicenseUpdateService_2", (String)"bos-license-business", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6267\u884c4.0\u8bb8\u53ef\u6570\u636e\u5347\u7ea7", (String)"LicenseUpdateService_3", (String)"bos-license-business", (Object[])new Object[0]));
        try {
            sql = "DELETE FROM T_LIC_USERLICENSEGROUPBAK";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
            sql = "INSERT INTO T_LIC_USERLICENSEGROUPBAK(FID, FUSERID, FGROUPID, FSYNCSTATUS, FSTATUS, FORGID) SELECT FID, FUSERID, FGROUPID, FSYNCSTATUS, FSTATUS, FORGID FROM T_LIC_USERLICENSEGROUP ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
        }
        catch (Exception e) {
            logger.error("LicenseUpdateService.updateUserLicenseData4V4() error", (Throwable)e);
            LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u540c\u6b65\u8bb8\u53ef", (String)"LicenseUpdateService_2", (String)"bos-license-business", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6267\u884c4.0\u8bb8\u53ef\u6570\u636e\u5347\u7ea7\u524d\u7684\u6570\u636e\u5907\u4efd\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u8bb8\u53ef\u5206\u7ec4\u6570\u636e\u3002", (String)"LicenseUpdateService_4", (String)"bos-license-business", (Object[])new Object[0]));
        }
        try {
            sql = "UPDATE " + this.userLicenseGroupTable + " SET FGROUPID = 13, FSYNCSTATUS = '2', FSTATUS = '0' WHERE FGROUPID = 40 ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
            sql = "UPDATE " + this.userLicenseGroupTable + " SET FGROUPID = 401, FSYNCSTATUS = '2', FSTATUS = '0' WHERE FGROUPID IN(4, 5, 23, 104, 89, 25, 111, 116) ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
            sql = "UPDATE " + this.userLicenseGroupTable + " SET FGROUPID = 406, FSYNCSTATUS = '2', FSTATUS = '0' WHERE FGROUPID IN(34, 87, 88) ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
            sql = "UPDATE " + this.userLicenseGroupTable + " SET FGROUPID = 412, FSYNCSTATUS = '2', FSTATUS = '0' WHERE FGROUPID = 9 AND FUSERID IN (SELECT FID FROM T_SEC_USER WHERE (FUSERTYPE = '3' ) OR (FUSERTYPE LIKE '3,%') OR (FUSERTYPE LIKE '%,3') OR (FUSERTYPE LIKE '%,3,%')) ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
            sql = "DELETE FROM " + this.userLicenseGroupTable + " WHERE FID NOT IN (SELECT FID FROM (SELECT MIN(FID) FID FROM " + this.userLicenseGroupTable + " GROUP BY FUSERID, FGROUPID)T) ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
        }
        catch (Exception e) {
            logger.error("LicenseUpdateService.updateUserLicenseData4V4() error", (Throwable)e);
            LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u540c\u6b65\u8bb8\u53ef", (String)"LicenseUpdateService_2", (String)"bos-license-business", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6267\u884c4.0\u8bb8\u53ef\u6570\u636e\u5347\u7ea7\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u8bb8\u53ef\u5206\u7ec4\u6570\u636e\u3002", (String)"LicenseUpdateService_5", (String)"bos-license-business", (Object[])new Object[0]));
        }
    }

    private void updateTempLicCache(boolean isTemporaryLicense, boolean isShowWaterMark, boolean isTrial, String sceneType) {
        try {
            String type4isTemporaryLicense = LicenseCacheMrg.getType4isTemporaryLicense();
            if (isTrial) {
                type4isTemporaryLicense = LicenseCacheMrg.getType4isTemporaryLicenseTrial();
            }
            HashMap<String, String> cacheMap = new HashMap<String, String>(2);
            cacheMap.put("isTemLic", isTemporaryLicense ? "1" : "0");
            cacheMap.put("isShowWaterMark", isShowWaterMark ? "1" : "0");
            cacheMap.put("sceneType", sceneType == null ? "" : sceneType);
            LicenseCacheMrg.putCache((String)type4isTemporaryLicense, cacheMap);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4e34\u65f6\u8bb8\u53ef\u7f13\u5b58\u6807\u8bb0\u5f02\u5e38", (Throwable)e);
        }
    }

    private void pubCloudExchangeLicenseProduct(Map<String, Object> contentMap, Map<String, Long> licGroupInfo, Map<String, Object> groupAll, Map<String, Integer> groupCount, Set<String> licenseGroupDetail, Map<String, Set<String>> groupModules, Map<String, Date> groupBeginDate, Map<String, Date> groupEndDate) throws ParseException {
        DynamicObject license = this.insertLicense(contentMap, licGroupInfo, groupAll, groupCount, licenseGroupDetail, groupModules, groupBeginDate, groupEndDate);
        Map<String, Integer> userLicGroupFromDB = this.getUserLicGroupFromDB();
        DynamicObjectCollection dynamicObjectCollection = license.getDynamicObjectCollection(this.licenseDetailEntity);
        for (DynamicObject licenseDetail : dynamicObjectCollection) {
            int newTotal;
            String number = this.getLicenseGroupNumberById(licGroupInfo, licenseDetail.get(PROP_GROUP));
            if (null == number) continue;
            licenseDetail.set(PROP_BEGINDATE, (Object)groupBeginDate.get(number));
            licenseDetail.set(PROP_ENDDATE, (Object)groupEndDate.get(number));
            Integer count = userLicGroupFromDB.remove(number);
            if (null == count) continue;
            int assignedCount = count;
            if (assignedCount > (newTotal = licenseDetail.getInt(PROP_TOTALCOUNT))) {
                HashSet groupIds = (HashSet)this.result.get("exceptionGroupIds");
                Long id = licGroupInfo.get(number);
                if (null == id) continue;
                groupIds.add(((Object)id).toString());
                continue;
            }
            licenseDetail.set(PROP_ASSIGNEDCOUNT, (Object)assignedCount);
            licenseDetail.set(PROP_REMAINCOUNT, (Object)(newTotal - assignedCount));
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{license});
        this.analysisExceptionLicense();
    }

    private String getLicenseGroupNumberById(Map<String, Long> licGroupInfo, Object group) {
        Object groupId = null;
        if (group instanceof Long) {
            groupId = group;
        } else if (group instanceof DynamicObject) {
            groupId = ((DynamicObject)group).get("id");
        }
        Set<Map.Entry<String, Long>> entries = licGroupInfo.entrySet();
        for (Map.Entry<String, Long> entry : entries) {
            if (!entry.getValue().equals(groupId)) continue;
            return entry.getKey();
        }
        return null;
    }

    private Object updatePrivateCloudLic(Map<String, Object> contentMap, Map<String, Long> licGroupInfo, Map<String, Object> groupAll, Map<String, Integer> groupCount, Set<String> licenseGroupDetail, Map<String, Set<String>> groupModules, Map<String, Date> groupBeginDate, Map<String, Date> groupEndDate) throws ParseException {
        Object productInstanceID = contentMap.get("productInstanceID");
        QFilter productInsFilter = new QFilter("prodinstcode", "=", productInstanceID);
        DynamicObject[] licenses = BusinessDataServiceHelper.load((String)this.licenseEntity, (String)SELECT_LICENSE_FIELDS, (QFilter[])productInsFilter.toArray());
        if (licenses == null || licenses.length == 0) {
            this.insertLicense(contentMap, licGroupInfo, groupAll, groupCount, licenseGroupDetail, groupModules, groupBeginDate, groupEndDate);
            return productInstanceID;
        }
        DynamicObject license = licenses[0];
        this.setLicenseProperties(license, contentMap);
        boolean isTemporaryLicense = MCTEMPORARYLICENSE.equals(contentMap.get("regUsers"));
        this.updateLicAllotNumInfo(licGroupInfo, groupAll, groupCount, license, isTemporaryLicense, licenseGroupDetail, groupModules, groupBeginDate, groupEndDate);
        this.saveLicDetail(groupAll, licGroupInfo, groupCount, license, isTemporaryLicense, licenseGroupDetail, groupModules, groupBeginDate, groupEndDate);
        return productInstanceID;
    }

    private void updatePubCloudLic(Map<String, Object> contentMap, Map<String, Long> licGroupInfo, Map<String, Object> groupAll, DynamicObject license, Set<String> licenseGroupDetail, Map<String, Set<String>> groupModules, Map<String, Date> groupBeginDate, Map<String, Date> groupEndDate, Map<String, Integer> groupCount) throws ParseException {
        this.setLicenseProperties(license, contentMap);
        HashSet<String> allModuleNumbers = new HashSet<String>(16);
        for (Set<String> modules : groupModules.values()) {
            allModuleNumbers.addAll(modules);
        }
        DynamicObject[] existsModules = BusinessDataServiceHelper.load((String)LIC_MODULE, (String)"id, number", (QFilter[])new QFilter(PROP_NUMBER, "in", allModuleNumbers).toArray());
        HashMap<String, Set<String>> moduleNum2PK = new HashMap<String, Set<String>>(existsModules.length);
        this.initailizeModuleRel(moduleNum2PK);
        for (DynamicObject module : existsModules) {
            String moduleNum = module.getString(PROP_NUMBER);
            String moduleId = module.getPkValue().toString();
            moduleNum2PK.computeIfAbsent(moduleNum, k -> new HashSet()).add(moduleId);
        }
        Map<String, Integer> userLicGroupFromDB = this.getUserLicGroupFromDB();
        ArrayList<DynamicObject> needUpdateSynStatusGroupList = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection dynamicObjectCollection = license.getDynamicObjectCollection(this.licenseDetailEntity);
        Iterator iterator = dynamicObjectCollection.iterator();
        Map<String, Integer> featureAssignCount = null;
        if (MapUtils.isNotEmpty(groupAll)) {
            featureAssignCount = this.getFeatureAssignCount(groupAll.keySet());
        }
        while (iterator.hasNext()) {
            DynamicObject licenseDetail = (DynamicObject)iterator.next();
            DynamicObject group = licenseDetail.getDynamicObject(PROP_GROUP);
            if (null == group) continue;
            String number = group.getString(PROP_NUMBER);
            licenseGroupDetail.remove(number);
            Integer count = userLicGroupFromDB.remove(number);
            if (Objects.isNull(groupAll.get(number))) {
                iterator.remove();
                HashSet groupIds = (HashSet)this.result.get("exceptionGroupIds");
                groupIds.add(group.getPkValue().toString());
                continue;
            }
            Long currGroupId = licGroupInfo.get(number);
            if (Objects.isNull(currGroupId)) continue;
            this.updatePubCloudLicDetail(groupAll, needUpdateSynStatusGroupList, licenseDetail, number, count, currGroupId.toString(), groupModules, moduleNum2PK, groupBeginDate, groupEndDate, featureAssignCount);
        }
        if (CollectionUtils.isNotEmpty(needUpdateSynStatusGroupList)) {
            SaveServiceHelper.save((DynamicObject[])needUpdateSynStatusGroupList.toArray(new DynamicObject[0]));
        }
        boolean isTemporaryLicense = MCTEMPORARYLICENSE.equals(contentMap.get("regUsers"));
        this.saveLicDetail(groupAll, licGroupInfo, groupCount, license, isTemporaryLicense, licenseGroupDetail, groupModules, groupBeginDate, groupEndDate);
        this.analysisExceptionLicense();
    }

    private void updatePubCloudLicDetail(Map<String, Object> groupAll, List<DynamicObject> needUpdateSynStatusGroupList, DynamicObject licenseDetail, String number, Integer userLicGroupCount, String currGroupId, Map<String, Set<String>> groupModules, Map<String, Set<String>> moduleNum2PK, Map<String, Date> groupBeginDate, Map<String, Date> groupEndDate, Map<String, Integer> featureAssCountMap) {
        int newTotal;
        int assignedCount;
        licenseDetail.set(PROP_BEGINDATE, (Object)groupBeginDate.get(number));
        licenseDetail.set(PROP_ENDDATE, (Object)groupEndDate.get(number));
        Object synCount = groupAll.get(number);
        if (Objects.isNull(synCount)) {
            licenseDetail.set(PROP_TOTALCOUNT, (Object)0);
            licenseDetail.set(PROP_ASSIGNEDCOUNT, (Object)0);
            licenseDetail.set(PROP_REMAINCOUNT, (Object)0);
            HashSet groupIds = (HashSet)this.result.get("exceptionGroupIds");
            groupIds.add(currGroupId);
            return;
        }
        int featureAssignedCount = 0;
        if (featureAssCountMap != null) {
            Integer count = featureAssCountMap.get(number);
            featureAssignedCount = null == count ? 0 : count;
        }
        if ((assignedCount = null == userLicGroupCount ? featureAssignedCount : userLicGroupCount) > (newTotal = Integer.parseInt(synCount.toString()))) {
            HashSet groupIds = (HashSet)this.result.get("exceptionGroupIds");
            groupIds.add(currGroupId);
        }
        licenseDetail.set(PROP_TOTALCOUNT, (Object)newTotal);
        licenseDetail.set(PROP_ASSIGNEDCOUNT, (Object)(assignedCount > newTotal ? newTotal : assignedCount));
        int count = newTotal - assignedCount;
        licenseDetail.set(PROP_REMAINCOUNT, (Object)(count > 0 ? count : 0));
        DynamicObjectCollection licGroupApps = licenseDetail.getDynamicObjectCollection(this.licenseGroupAppsEntity);
        DynamicObjectType licGroupAppsType = licGroupApps.getDynamicObjectType();
        licGroupApps.clear();
        Map<String, Map<String, Map<String, Object>>> group2Module2Info = this.getGroup2Module2Info();
        Map<String, Map<String, Object>> module2Info = group2Module2Info.get(number);
        Set<String> moduleNumbers = groupModules.get(number);
        if (moduleNumbers != null && !moduleNumbers.isEmpty()) {
            for (String moduleNum : moduleNumbers) {
                Set<String> moduleIds = moduleNum2PK.get(moduleNum);
                Map<String, Object> moduleInfo = module2Info.get(moduleNum);
                if (moduleIds == null || moduleIds.isEmpty() || moduleInfo == null || module2Info.isEmpty()) continue;
                Object moduleBeginDate = moduleInfo.get(PROP_BEGINDATE) != null ? moduleInfo.get(PROP_BEGINDATE) : groupBeginDate.get(number);
                Object moduleEndDate = moduleInfo.get(PROP_ENDDATE) != null ? moduleInfo.get(PROP_ENDDATE) : groupEndDate.get(number);
                for (String moduleId : moduleIds) {
                    if (StringUtils.isBlank((CharSequence)moduleId)) continue;
                    DynamicObject licGroupAppObj = new DynamicObject(licGroupAppsType);
                    licGroupAppObj.set(PROP_MODULE, (Object)Long.valueOf(moduleId));
                    licGroupAppObj.set("modulebegindate", moduleBeginDate);
                    licGroupAppObj.set("moduleenddate", moduleEndDate);
                    licGroupApps.add((Object)licGroupAppObj);
                }
            }
        }
    }

    private boolean setUserLicGroupSynStatus(List<DynamicObject> userLicGroups, List<DynamicObject> updateList, int targetStatus) {
        if (CollectionUtils.isEmpty(userLicGroups)) {
            return false;
        }
        boolean needResetAssignedCountNum = false;
        for (DynamicObject userLicGroup : userLicGroups) {
            if (targetStatus == userLicGroup.getInt(PROP_SYNC_STATUS)) continue;
            needResetAssignedCountNum = true;
            userLicGroup.set(PROP_SYNC_STATUS, (Object)targetStatus);
            userLicGroup.set("status", (Object)(targetStatus == 1 ? "1" : "0"));
            updateList.add(userLicGroup);
        }
        return needResetAssignedCountNum;
    }

    private Map<String, Integer> getUserLicGroupFromDB() {
        Map licenseGroup = LicenseGroupUtil.getLicenseGroup((String)"2");
        Map allGroupIdAndNumber = LicenseGroupUtil.getAllGroupIdAndNumber();
        if (null == allGroupIdAndNumber || allGroupIdAndNumber.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fgroupid, count(1) fcount FROM T_LIC_USERLICENSEGROUP WHERE fsyncstatus = '1' ", new Object[0]);
        sql.append(" GROUP BY fgroupid", new Object[0]);
        DB.query((DBRoute)DBRoute.base, (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                Long groupId = rs.getLong("fgroupid");
                String groupNumber = (String)allGroupIdAndNumber.get(groupId);
                if (StringUtils.isBlank((CharSequence)groupNumber) || licenseGroup.containsKey(String.valueOf(groupId))) continue;
                int assignCount = rs.getInt("fcount");
                result.put(groupNumber, assignCount);
            }
            return null;
        });
        return result;
    }

    private void putLicExpireTimeCache(Map<String, Object> contentMap) throws ParseException {
        Object createDate = contentMap.get("licCreateDate");
        if (null == createDate || StringUtils.isBlank((CharSequence)createDate.toString())) {
            createDate = contentMap.get("createDate");
        }
        if (null == createDate) {
            return;
        }
        Date create = LicenseUpdateService.parseObject2Date(createDate);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(create);
        ((Calendar)calendar).add(2, 3);
        LicenseCacheMrg.putCache((String)LicenseCacheMrg.getType4IsCtrlAmount(), (String)"temtime", (String)String.valueOf(calendar.getTime().getTime()));
    }

    private DynamicObject insertLicense(Map<String, Object> contentMap, Map<String, Long> licGroupInfo, Map<String, Object> groupAll, Map<String, Integer> groupCount, Set<String> licenseDetail, Map<String, Set<String>> groupModules, Map<String, Date> groupBeginDate, Map<String, Date> groupEndDate) throws ParseException {
        MainEntityType licenseType = EntityMetadataCache.getDataEntityType((String)this.licenseEntity);
        DynamicObject license = new DynamicObject((DynamicObjectType)licenseType);
        Object createDate = contentMap.get("createDate");
        license.set("activedate", (Object)LicenseUpdateService.parseObject2Date(createDate));
        license.set("prodinstcode", contentMap.get("productInstanceID"));
        license.set("product", contentMap.get("productID"));
        license.set("softwarecode", contentMap.get("softwareCode"));
        this.setLicenseProperties(license, contentMap);
        Object regUsers = contentMap.get("regUsers");
        boolean isTemporaryLicense = MCTEMPORARYLICENSE.equals(regUsers);
        this.saveLicDetail(groupAll, licGroupInfo, groupCount, license, isTemporaryLicense, licenseDetail, groupModules, groupBeginDate, groupEndDate);
        return license;
    }

    private void setLicenseProperties(DynamicObject license, Map<String, Object> contentMap) throws ParseException {
        boolean isTrial;
        Object prodTagObj;
        Object expireDate = contentMap.get("expireDate");
        license.set(PROP_EXPDATE, (Object)LicenseUpdateService.parseObject2EndDate(expireDate));
        license.set("industry", contentMap.get("industry"));
        license.set("productversion", contentMap.get("productVersion"));
        license.set("productno", contentMap.get("userName"));
        Object softWareName = contentMap.get("softwareName");
        license.set("name", softWareName);
        Object tid = contentMap.get("tid");
        if (null != tid) {
            license.set("tid", tid);
        }
        String productTag = (prodTagObj = contentMap.get("productTag")) == null ? "default" : prodTagObj.toString();
        Object source = contentMap.get("source");
        boolean isFromKBC = source != null && source.toString().contains("KBC");
        boolean isTemporaryLicense = MCTEMPORARYLICENSE.equals(contentMap.get("regUsers"));
        if (isTemporaryLicense) {
            softWareName = "kingdee eas nextcloud V1.0";
        }
        if (softWareName != null) {
            DynamicObject[] prods;
            license.set("softwarename", softWareName);
            QFilter filter = new QFilter("prodnumber", "=", (Object)softWareName.toString());
            if (isFromKBC) {
                filter = new QFilter("producttag", "=", (Object)productTag);
            }
            if ((prods = BusinessDataServiceHelper.load((String)"lic_isvprod", (String)"", (QFilter[])filter.toArray())) != null && prods.length == 1) {
                license.set(PROP_PROD, prods[0].getPkValue());
            }
        }
        license.set("scenetype", (isTrial = LicenseUpdateService.isTrial(contentMap, isFromKBC)) || isTemporaryLicense ? "TEMP" : contentMap.get("sceneType"));
        license.set("type", (Object)(isTrial ? 2 : 1));
    }

    public static boolean isTrial(Map<String, Object> contentMap, boolean isFromKBC) {
        Object type;
        boolean isTrial = false;
        Object trial = contentMap.get("trial");
        if (trial != null) {
            isTrial = Boolean.parseBoolean(trial.toString());
        }
        if ((type = contentMap.get("type")) != null && !isTrial) {
            isTrial = isFromKBC ? "0".equals(String.valueOf(type)) || "2".equals(String.valueOf(type)) || "3".equals(String.valueOf(type)) : "1".equals(String.valueOf(type)) || "2".equals(String.valueOf(type));
        }
        return isTrial;
    }

    public static Date parseObject2EndDate(Object date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        try {
            Date parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date.toString());
            String returnStr = format.format(parse);
            cal.setTime(format.parse(returnStr));
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return cal.getTime();
    }

    private Map<String, Integer> getFeatureAssignCount(Collection<String> numbers) {
        HashMap<String, Integer> featureAssignMap = new HashMap<String, Integer>(16);
        if (CollectionUtils.isEmpty(numbers)) {
            return featureAssignMap;
        }
        StringBuilder numbersToSql = new StringBuilder();
        boolean first = true;
        for (String numebr : numbers) {
            if (first) {
                first = false;
                numbersToSql.append('\'').append(numebr).append('\'');
                continue;
            }
            numbersToSql.append(',').append('\'').append(numebr).append('\'');
        }
        String sql = "select fnumber, fassignedcount from t_lic_group a inner join t_lic_licensedetail b on a.fid  = b.fgroupid  where a.ftype ='2' and fnumber in ( " + numbersToSql + " )";
        DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            while (k.next()) {
                String number = k.getString("fnumber");
                Integer assignedcount = k.getInt("fassignedcount");
                featureAssignMap.put(number, assignedcount);
            }
            return true;
        });
        return featureAssignMap;
    }

    private void updateLicAllotNumInfo(Map<String, Long> licGroupInfo, Map<String, Object> groupAll, Map<String, Integer> groupCount, DynamicObject license, boolean isTemporaryLicense, Set<String> licenseGroupDetail, Map<String, Set<String>> groupModules, Map<String, Date> groupBeginDate, Map<String, Date> groupEndDate) {
        DynamicObjectCollection dynamicObjectCollection = license.getDynamicObjectCollection(this.licenseDetailEntity);
        Map<Object, Object> licToCountMap = new HashMap(16);
        Map<String, Integer> featureAssignCount = this.getFeatureAssignCount(groupAll.keySet());
        if (isTemporaryLicense && CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
            HashSet<String> numbers = new HashSet<String>(dynamicObjectCollection.size());
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                DynamicObject[] group = dynamicObject.getDynamicObject(PROP_GROUP);
                numbers.add(group.getString(PROP_NUMBER));
            }
            licToCountMap = this.getAssignCountByNumbers(numbers);
            licToCountMap.putAll(featureAssignCount);
        }
        HashSet allModuleNumbers = new HashSet(16);
        for (Set set : groupModules.values()) {
            allModuleNumbers.addAll(set);
        }
        DynamicObject[] existsModules = BusinessDataServiceHelper.load((String)LIC_MODULE, (String)"id, number", (QFilter[])new QFilter(PROP_NUMBER, "in", allModuleNumbers).toArray());
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>(existsModules.length);
        this.initailizeModuleRel(hashMap);
        for (DynamicObject module : existsModules) {
            String moduleNum = module.getString(PROP_NUMBER);
            String moduleId = module.getPkValue().toString();
            hashMap.computeIfAbsent(moduleNum, k -> new HashSet()).add(moduleId);
        }
        Iterator iterator = dynamicObjectCollection.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            DynamicObject group = dynamicObject.getDynamicObject(PROP_GROUP);
            if (group == null) {
                iterator.remove();
                continue;
            }
            String number = group.getString(PROP_NUMBER);
            if (groupAll.get(number) != null && groupCount.get(number) != null) {
                int count;
                Integer sum = Integer.valueOf(groupAll.get(number).toString());
                dynamicObject.set(PROP_TOTALCOUNT, (Object)sum);
                Integer assignCount = featureAssignCount.get(number);
                int n = count = null == assignCount ? Integer.parseInt(groupCount.get(number).toString()) : assignCount;
                if (isTemporaryLicense) {
                    count = (Integer)licToCountMap.get(number);
                }
                dynamicObject.set(PROP_ASSIGNEDCOUNT, (Object)count);
                dynamicObject.set(PROP_REMAINCOUNT, (Object)(sum - count));
                dynamicObject.set(PROP_BEGINDATE, (Object)groupBeginDate.get(number));
                dynamicObject.set(PROP_ENDDATE, (Object)groupEndDate.get(number));
                DynamicObjectCollection licGroupApps = dynamicObject.getDynamicObjectCollection(this.licenseGroupAppsEntity);
                DynamicObjectType licGroupAppsType = licGroupApps.getDynamicObjectType();
                licGroupApps.clear();
                Set<String> moduleNumbers = groupModules.get(number);
                Map<String, Map<String, Map<String, Object>>> group2Module2Info = this.getGroup2Module2Info();
                Map<String, Map<String, Object>> module2Info = group2Module2Info.get(number);
                if (moduleNumbers != null && !moduleNumbers.isEmpty() && module2Info != null && !module2Info.isEmpty()) {
                    for (String moduleNum : moduleNumbers) {
                        Set moduleIds = (Set)hashMap.get(moduleNum);
                        Map<String, Object> moduleInfo = module2Info.get(moduleNum);
                        if (moduleIds == null || moduleIds.isEmpty()) continue;
                        Object moduleBeginDate = moduleInfo.get(PROP_BEGINDATE) != null ? moduleInfo.get(PROP_BEGINDATE) : groupBeginDate.get(number);
                        Object moduleEndDate = moduleInfo.get(PROP_ENDDATE) != null ? moduleInfo.get(PROP_ENDDATE) : groupEndDate.get(number);
                        for (String moduleId : moduleIds) {
                            DynamicObject licGroupAppObj = new DynamicObject(licGroupAppsType);
                            licGroupAppObj.set(PROP_MODULE, (Object)Long.valueOf(moduleId));
                            licGroupAppObj.set("modulebegindate", moduleBeginDate);
                            licGroupAppObj.set("moduleenddate", moduleEndDate);
                            licGroupApps.add((Object)licGroupAppObj);
                        }
                    }
                }
            } else {
                dynamicObject.set(PROP_TOTALCOUNT, (Object)0);
                dynamicObject.set(PROP_ASSIGNEDCOUNT, (Object)0);
                dynamicObject.set(PROP_REMAINCOUNT, (Object)0);
                iterator.remove();
            }
            licenseGroupDetail.remove(number);
        }
    }

    private void saveLicDetail(Map<String, Object> groupAll, Map<String, Long> licGroupInfo, Map<String, Integer> groupCount, DynamicObject license, boolean isTemporaryLicense, Set<String> licenseGroupDetail, Map<String, Set<String>> groupModules, Map<String, Date> groupBeginDate, Map<String, Date> groupEndDate) {
        DynamicObjectCollection dynamicObjectCollection = license.getDynamicObjectCollection(this.licenseDetailEntity);
        DynamicObjectType licenseDetailType = dynamicObjectCollection.getDynamicObjectType();
        HashSet<String> allModuleNumbers = new HashSet<String>(16);
        for (Set<String> modules : groupModules.values()) {
            allModuleNumbers.addAll(modules);
        }
        DynamicObject[] existsModules = BusinessDataServiceHelper.load((String)LIC_MODULE, (String)"id, number", (QFilter[])new QFilter(PROP_NUMBER, "in", allModuleNumbers).toArray());
        HashMap<String, Set<String>> moduleNum2PK = new HashMap<String, Set<String>>(existsModules.length);
        this.initailizeModuleRel(moduleNum2PK);
        for (DynamicObject module : existsModules) {
            String moduleNum = module.getString(PROP_NUMBER);
            String moduleId = module.getPkValue().toString();
            moduleNum2PK.computeIfAbsent(moduleNum, k -> new HashSet()).add(moduleId);
        }
        for (String number : licenseGroupDetail) {
            Long groupId;
            DynamicObject dynamicObject = new DynamicObject(licenseDetailType);
            int sum = 0;
            if (groupAll.containsKey(number)) {
                sum = Integer.parseInt(groupAll.get(number).toString());
            }
            int count = 0;
            if (groupCount.containsKey(number)) {
                count = Integer.parseInt(groupCount.get(number).toString());
            }
            if ((groupId = licGroupInfo.get(number)) == null || licGroupInfo.get(number).equals(0L)) {
                LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef", (String)"LicenseUpdateService_6", (String)"bos-license-business", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0b\u5e8f\u65e0\u6cd5\u8bc6\u522b\u5206\u7ec4\u7f16\u7801\u4e3a %1$s \u7684\u5206\u7ec4\uff0c\u8bf7\u7ba1\u7406\u5458\u786e\u8ba4\u7a0b\u5e8f\u7248\u672c\u662f\u5426\u53ef\u7528\u3002", (String)"LicenseUpdateService_7", (String)"bos-license-business", (Object[])new Object[0]), number));
                continue;
            }
            dynamicObject.set(PROP_GROUP, (Object)licGroupInfo.get(number));
            dynamicObject.set(PROP_TOTALCOUNT, (Object)sum);
            dynamicObject.set(PROP_ASSIGNEDCOUNT, (Object)count);
            dynamicObject.set(PROP_REMAINCOUNT, (Object)(sum - count));
            dynamicObject.set(PROP_BEGINDATE, (Object)groupBeginDate.get(number));
            dynamicObject.set(PROP_ENDDATE, (Object)groupEndDate.get(number));
            DynamicObjectCollection licGroupApps = dynamicObject.getDynamicObjectCollection(this.licenseGroupAppsEntity);
            DynamicObjectType licGroupAppsType = licGroupApps.getDynamicObjectType();
            Set<String> moduleNumbers = groupModules.get(number);
            Map<String, Map<String, Map<String, Object>>> group2Module2Info = this.getGroup2Module2Info();
            Map<String, Map<String, Object>> module2Info = group2Module2Info.get(number);
            if (moduleNumbers != null && !moduleNumbers.isEmpty() && module2Info != null && !module2Info.isEmpty()) {
                for (String moduleNum : moduleNumbers) {
                    Set moduleIds = (Set)moduleNum2PK.get(moduleNum);
                    Map<String, Object> moduleInfo = module2Info.get(moduleNum);
                    if (moduleIds == null || moduleIds.isEmpty() || moduleInfo == null || moduleInfo.isEmpty()) continue;
                    Object moduleBeginDate = moduleInfo.get(PROP_BEGINDATE) != null ? moduleInfo.get(PROP_BEGINDATE) : groupBeginDate.get(number);
                    Object moduleEndDate = moduleInfo.get(PROP_ENDDATE) != null ? moduleInfo.get(PROP_ENDDATE) : groupEndDate.get(number);
                    for (String moduleId : moduleIds) {
                        if (StringUtils.isBlank((CharSequence)moduleId)) continue;
                        DynamicObject licGroupAppObj = new DynamicObject(licGroupAppsType);
                        licGroupAppObj.set(PROP_MODULE, (Object)Long.valueOf(moduleId));
                        licGroupAppObj.set("modulebegindate", moduleBeginDate);
                        licGroupAppObj.set("moduleenddate", moduleEndDate);
                        licGroupApps.add((Object)licGroupAppObj);
                    }
                }
            }
            dynamicObjectCollection.add((Object)dynamicObject);
        }
        SaveServiceHelper.save((IDataEntityType)license.getDataEntityType(), (Object[])new DynamicObject[]{license});
    }

    public static Date parseObject2Date(Object date) throws ParseException {
        SimpleDateFormat returnFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date.toString());
        String returnStr = returnFormat.format(parse);
        return returnFormat.parse(returnStr);
    }

    private Map<String, Integer> getAssignCountByNumbers(Collection<String> numbers) {
        if (CollectionUtils.isEmpty(numbers)) {
            return Collections.emptyMap();
        }
        Map allGroupIdAndNumber = LicenseGroupUtil.getAllGroupIdAndNumber();
        if (null == allGroupIdAndNumber || allGroupIdAndNumber.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> licToCountMap = new HashMap<String, Integer>(numbers.size());
        for (String number : numbers) {
            licToCountMap.put(number, 0);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fgroupid, count(1) fcount FROM T_LIC_USERLICENSEGROUP WHERE fsyncstatus = '1' AND ", new Object[0]);
        sql.appendIn("fgroupid", new ArrayList<String>(numbers));
        sql.append(" GROUP BY fgroupid", new Object[0]);
        DB.query((DBRoute)DBRoute.base, (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                String groupId = rs.getString("fgroupid");
                String groupNumber = (String)allGroupIdAndNumber.get(groupId);
                if (StringUtils.isBlank((CharSequence)groupNumber)) continue;
                int assignCount = rs.getInt("fcount");
                licToCountMap.put(groupNumber, assignCount);
            }
            return null;
        });
        return licToCountMap;
    }

    private void analysisExceptionLicense() {
        HashSet groupIds = (HashSet)this.result.get("exceptionGroupIds");
        if (CollectionUtils.isEmpty((Collection)groupIds)) {
            return;
        }
        StringBuilder exceptionGroupMsg = new StringBuilder(ResManager.loadKDString((String)"\u540c\u6b65\u8bb8\u53ef\u90e8\u5206\u5206\u7ec4\u5f02\u5e38\uff0c\u5f02\u5e38\u5206\u7ec4\u4e3a\uff1a", (String)"LicenseUpdateService_1", (String)"bos-license-business", (Object[])new Object[0]));
        for (String groupId : groupIds) {
            String name = (String)LicenseGroupUtil.getLicenseGroup((String)groupId).get(groupId);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                exceptionGroupMsg.append(name).append('\uff0c');
                continue;
            }
            exceptionGroupMsg.append("id = ").append(groupId).append('\uff0c');
        }
        exceptionGroupMsg.deleteCharAt(exceptionGroupMsg.length() - 1);
        this.result.put("exceptionGroupMsg", exceptionGroupMsg);
        this.result.put("exceptionGroupIds", new HashSet(16));
    }

    private void initailizeModuleRel(Map<String, Set<String>> moduleNum2PK) {
        DynamicObject[] modules;
        HashMap<String, String> number2ID = new HashMap<String, String>(presetModuleNumbers.length);
        for (DynamicObject module : modules = BusinessDataServiceHelper.load((String)LIC_MODULE, (String)PROP_NUMBER, (QFilter[])new QFilter[]{new QFilter(PROP_NUMBER, "in", (Object)presetModuleNumbers)})) {
            number2ID.put(module.getString(PROP_NUMBER), module.getPkValue().toString());
        }
        moduleNum2PK.computeIfAbsent("DPA", k -> new HashSet(2)).add(number2ID.get("DPA"));
        moduleNum2PK.computeIfAbsent("DPA", k -> new HashSet(2)).add(number2ID.get("OCBMALL"));
        moduleNum2PK.computeIfAbsent("BBC", k -> new HashSet(2)).add(number2ID.get("BBC"));
        moduleNum2PK.computeIfAbsent("BBC", k -> new HashSet(2)).add(number2ID.get("OCBSOC"));
        moduleNum2PK.computeIfAbsent("MDR", k -> new HashSet(2)).add(number2ID.get("MDR"));
        moduleNum2PK.computeIfAbsent("MDR", k -> new HashSet(2)).add(number2ID.get("DMA"));
        moduleNum2PK.computeIfAbsent("MDR", k -> new HashSet(2)).add(number2ID.get("OCDMA"));
        moduleNum2PK.computeIfAbsent("TRA", k -> new HashSet(2)).add(number2ID.get("KDEM"));
        moduleNum2PK.computeIfAbsent("EXP", k -> new HashSet(2)).add(number2ID.get("KDEM"));
        moduleNum2PK.computeIfAbsent("SAA", k -> new HashSet(2)).add(number2ID.get("SAA"));
        moduleNum2PK.computeIfAbsent("SAA", k -> new HashSet(2)).add(number2ID.get("OCSAA"));
    }

    public static void updateLicenseGroupModule() {
        ArrayList<Object[]> updateLicenseGroupModuleParamList = new ArrayList<Object[]>();
        Map<String, Long> allModules = LicenseUpdateService.getAllModulesFromDB();
        String licenseGroupModuleSql = "select ld.fgroupid fgroupid, lga.fdetailid fdetailid, fbizappid from t_lic_licensedetail ld inner join t_lic_licensegroupapps lga on ld.fentryid = lga.fentryid where fmoduleid is null or fmoduleid = 0";
        try (DataSet ds = DB.queryDataSet((String)LicenseUpdateService.class.getName(), (DBRoute)DBRoute.basedata, (String)licenseGroupModuleSql, (Object[])new Object[0]);){
            for (Row row : ds) {
                Long moduleId;
                Long detailID = row.getLong("fdetailid");
                String bizAppID = row.getString("fbizappid");
                String appNumber = AppMetadataCache.getAppNumberById((String)bizAppID);
                if (StringUtils.isEmpty((CharSequence)appNumber) || (moduleId = LicenseUpdateService.getModuleId(bizAppID, appNumber, allModules)) == null) continue;
                updateLicenseGroupModuleParamList.add(new Object[]{moduleId, detailID});
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (updateLicenseGroupModuleParamList != null && updateLicenseGroupModuleParamList.size() > 0) {
            String updateLicenseGroupModuleSQL = "update t_lic_licensegroupapps set fmoduleid = ? where fdetailid = ?";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateLicenseGroupModuleSQL, updateLicenseGroupModuleParamList);
        }
        ArrayList modules4Add = new ArrayList(64);
        String queryAllAppSql = "select app.fnumber fnumber, appl.fname fname from t_meta_bizapp app INNER JOIN t_meta_bizapp_l appl ON app.fid = appl.fid where fisv = 'kingdee' and fmasterid = ' ' and appl.flocaleid = 'zh_CN';";
        try (DataSet ds = DB.queryDataSet((String)LicenseUpdateService.class.getName(), (DBRoute)DBRoute.meta, (String)queryAllAppSql, (Object[])new Object[0]);){
            for (Row row : ds) {
                String number = row.getString("fnumber").toUpperCase(Locale.ENGLISH);
                String name = row.getString("fname");
                if (allModules.get(number) != null) continue;
                Long moduleId = LicenseUpdateService.generateSinglePk();
                LicenseUpdateService.insertModuleInfo2DB(moduleId, number.toUpperCase(Locale.ENGLISH), name);
                allModules.put(number, moduleId);
            }
            if (!modules4Add.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])modules4Add.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static long generateSinglePk() {
        return DB.genLongIds((String)"t_lic_module", (int)1)[0];
    }

    private static Map<String, Long> getAllModulesFromDB() {
        String sql = "select fid, fnumber from t_lic_module;";
        Map allModules = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            HashMap<String, Long> result = new HashMap<String, Long>(128);
            while (k.next()) {
                result.put(k.getString("fnumber").toUpperCase(Locale.ENGLISH), k.getLong("fid"));
            }
            return result;
        });
        return allModules;
    }

    private static Long getModuleId(String appId, String moduleNumber, Map<String, Long> allModules) {
        if (StringUtils.isBlank((CharSequence)moduleNumber) && !StringUtils.isBlank((CharSequence)(moduleNumber = AppMetadataCache.getAppNumberById((String)appId)))) {
            moduleNumber = moduleNumber.toUpperCase(Locale.ENGLISH);
        }
        if (StringUtils.isBlank((CharSequence)moduleNumber)) {
            return null;
        }
        Long moduleId = allModules.get(moduleNumber.toUpperCase(Locale.ENGLISH));
        if (moduleId == null) {
            LocaleString moduleName = null;
            AppInfo appInfo = null;
            try {
                appInfo = AppMetadataCache.getAppInfoByNumber((String)moduleNumber.toLowerCase(Locale.ENGLISH));
            }
            catch (Exception e) {
                logger.error("\u7f16\u7801\u4e3a" + moduleNumber + "\u7684\u5e94\u7528\u627e\u4e0d\u5230", (Throwable)e);
            }
            moduleName = appInfo == null ? new LocaleString(moduleNumber) : appInfo.getName();
            moduleId = LicenseUpdateService.generateSinglePk();
            LicenseUpdateService.insertModuleInfo2DB(moduleId, moduleNumber.toUpperCase(Locale.ENGLISH), moduleName.toString());
            allModules.put(moduleNumber.toUpperCase(Locale.ENGLISH), moduleId);
        }
        return moduleId;
    }

    private static void insertModuleInfo2DB(Long moduleId, String moduleNumber, String moduleName) {
        String moduleSql = String.format("INSERT INTO t_lic_module(fid, fnumber, fgroupid) VALUES (%d, '%s', 0);", moduleId, moduleNumber);
        DB.execute((DBRoute)DBRoute.base, (String)moduleSql);
        moduleSql = String.format("INSERT INTO t_lic_module_l(fpkid, fid, flocaleid, fname) VALUES ('%s', %d, 'zh_CN', '%s');", DB.genStringId((String)"t_lic_module_l"), moduleId, moduleName);
        DB.execute((DBRoute)DBRoute.base, (String)moduleSql);
    }

    public static PriorityQueue<String> buildSceneTypePriorityQueue() {
        PriorityQueue<String> priorityQueue = new PriorityQueue<String>((o1, o2) -> {
            Integer a = WaterMarkPriority.get(o1) == null ? Integer.valueOf(0) : WaterMarkPriority.get(o1);
            Integer b = WaterMarkPriority.get(o2) == null ? Integer.valueOf(0) : WaterMarkPriority.get(o2);
            return b.compareTo(a);
        });
        return priorityQueue;
    }

    static {
        WaterMarkPriority.put("DEV", 100000);
        WaterMarkPriority.put("SIT", 10000);
        WaterMarkPriority.put("UAT", 1000);
        WaterMarkPriority.put("TEMP", 100);
        WaterMarkPriority.put("PRD", 10);
    }
}

