/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.config.gray;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.license.api.LicenseConfigParseResult;
import kd.bos.license.config.RSAUtil;
import kd.bos.license.exception.InvalidSignException;
import kd.bos.license.gray.UpdateGrayBlackList;
import kd.bos.license.gray.UpdateGrayFeature;
import kd.bos.license.service.cache.LicenseGrayCache;
import kd.bos.license.util.EncryptUtil;
import kd.bos.license.util.LicenseDefauleDataUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.grayblacklist.bean.GrayAppBLInfo;
import kd.bos.metadata.devportal.grayblacklist.bean.GrayCloudBLInfo;
import kd.bos.metadata.devportal.grayblacklist.bean.GrayEntityBLInfo;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.runmode.GrayBlackListServiceHelper;
import kd.bos.util.CollectionUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class LicenseGrayConfigHelper {
    private static final Log logger = LogFactory.getLog(LicenseGrayConfigHelper.class);
    private static final String SUBELEMENT_APPBIZOBJGROUPMAPS = "featureBizObjMaps";
    private static final String APPBIZOBJGROUPMAP = "featureBizObjMap";
    private static final String MAP_FEATURE_ID = "feature";
    private static final String MAP_BIZNUM = "bizObj";
    private static final String INSTASNCE_PUBLIC_KEY = EncryptUtil.getKey((String)"LicenseGrayConfigPublicKey");

    public static Map<String, String> getLicenseGrayConfig() {
        Object licenseConfig = DispatchServiceHelper.invokeBOSService((String)"basedata", (String)"ILicenseGrayService", (String)"getLicenseGrayConfig", (Object[])new Object[0]);
        if (licenseConfig instanceof Map) {
            return (Map)licenseConfig;
        }
        logger.error("getLicenseGrayConfig error. licenseConfig not instanceof Map");
        return null;
    }

    public static Map<String, String> getLicenseGrayConfigImpl() throws Exception {
        logger.info("LicenseGrayConfigHelper getLicenseGrayConfigImpl()");
        int modelType = LicenseServiceHelper.getModeType();
        List<String> fileNames = LicenseGrayConfigHelper.getLicenseGrayControlListFileName(modelType);
        HashMap<String, String> grayLicCtrl = new HashMap<String, String>(16);
        for (String fileName : fileNames) {
            try {
                String fileContent = LicenseGrayConfigHelper.readLicenseConfig(fileName);
                LicenseGrayConfigHelper.verifySign(fileName, fileContent);
                LicenseGrayConfigHelper.getAppAndObjFromXml(fileContent.getBytes(), grayLicCtrl, fileName);
            }
            catch (Exception e) {
                if (e instanceof InvalidSignException) {
                    throw e;
                }
                logger.error("LicenseGrayConfigHelper.getLicenseGrayConfigImpl: Can't parse license configfile,please check!" + e);
            }
        }
        return grayLicCtrl;
    }

    private static void verifySign(String fileName, String fileContent) throws Exception {
        String[] Data_Sign = LicenseGrayConfigHelper.getData_SignFromData(fileContent);
        boolean verify = RSAUtil.verify((String)RSAUtil.getSHA256Checksum((String)Data_Sign[0]), (String)INSTASNCE_PUBLIC_KEY, (String)Data_Sign[1]);
        if (!verify) {
            logger.info("LicenseGrayConfigHelper.verifySign:\u7070\u5ea6\u8bb8\u53ef\u63a7\u5236\u6e05\u5355\u201c{}\u201d\u9a8c\u7b7e\u5931\u8d25\u3002", (Object)fileName);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7070\u5ea6\u8bb8\u53ef\u63a7\u5236\u6e05\u5355\u201c%s\u201d\u9a8c\u7b7e\u5931\u8d25\u3002", (String)"LicenseGrayConfigHelper_0", (String)"bos-license-business", (Object[])new Object[0]), fileName));
        }
    }

    private static String[] getData_SignFromData(String data) throws DocumentException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getBytes());
        SAXReader reader = new SAXReader();
        Document doc = reader.read((InputStream)inputStream);
        Element rootElement = doc.getRootElement();
        Element signElement = rootElement.element("sign");
        String sign = signElement.attributeValue("sign");
        Element appBizobjGroupsMapElement = rootElement.element("grayFeatureSchemes");
        List children = appBizobjGroupsMapElement.elements("grayFeatureScheme");
        StringBuilder sb = new StringBuilder();
        if (children != null && !children.isEmpty()) {
            for (Element child : children) {
                sb.append(child.attributeValue("number"));
                sb.append(child.attributeValue("name"));
                sb.append(child.attributeValue("introduction"));
                sb.append(child.attributeValue("detailurl"));
                sb.append(child.attributeValue("minversion"));
                sb.append(child.attributeValue("expiredate"));
                sb.append(child.attributeValue("comment"));
                List configElements = child.elements("configEntry");
                for (Element configElement : configElements) {
                    sb.append(configElement.attributeValue("cloudid"));
                    sb.append(configElement.attributeValue("cloudnumber"));
                    sb.append(configElement.attributeValue("cloudname"));
                    sb.append(configElement.attributeValue("appid"));
                    sb.append(configElement.attributeValue("appnumber"));
                    sb.append(configElement.attributeValue("appname"));
                    sb.append(configElement.attributeValue("entitynumber"));
                    sb.append(configElement.attributeValue("entityname"));
                    sb.append(configElement.attributeValue("controltype"));
                    sb.append(configElement.attributeValue("onsale"));
                }
            }
        }
        return new String[]{sb.toString(), sign};
    }

    private static void getAppAndObjFromXml(byte[] xml, @NotNull Map<String, String> gratLicCtrl, String fileName) throws DocumentException {
        SAXReader reader = new SAXReader();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml);
        Document doc = reader.read((InputStream)inputStream);
        Element rootElement = doc.getRootElement();
        Element appBizobjGroupsMapElement = rootElement.element("grayFeatureSchemes");
        List children = appBizobjGroupsMapElement.elements("grayFeatureScheme");
        if (children != null && !children.isEmpty()) {
            for (Element child : children) {
                String featureNum = child.attributeValue("number");
                if (StringUtils.isBlank((CharSequence)featureNum)) {
                    logger.warn("getLicenseGrayConfigImpl --warn continue. fileName : " + fileName + "feature: " + featureNum);
                    continue;
                }
                String bizObjNum = "";
                List configElements = child.elements("configEntry");
                for (Element configElement : configElements) {
                    bizObjNum = configElement.attributeValue("entitynumber");
                    if (StringUtils.isBlank((CharSequence)bizObjNum)) {
                        logger.warn("getLicenseGrayConfigImpl --warn continue. fileName : " + fileName + "feature: " + featureNum + " bizObj: " + bizObjNum);
                        continue;
                    }
                    gratLicCtrl.put(bizObjNum.trim(), featureNum.trim());
                }
            }
        }
    }

    private static List<String> getLicenseGrayControlListFileName(int modelType) {
        if (2 == modelType || 4 == modelType) {
            logger.info("LicenseGrayConfigHelper#getLicenseGrayControlListFileName:xkqj");
            return Collections.singletonList("/licenseGrayControl_galaxy.config");
        }
        return LicenseDefauleDataUtil.cosmicConstellationGrayControlFileList;
    }

    /*
     * Exception decompiling
     */
    private static String readLicenseConfig(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] EncryStringToByte(String encry) {
        try {
            return EncryptUtil.unzipString((byte[])EncryptUtil.decryptString((String)encry));
        }
        catch (Exception e) {
            logger.error("\u8bb8\u53ef\u63a7\u5236\u6e05\u5355\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static LicenseConfigParseResult parseLicenseGrayControlFile(String fileName) {
        try {
            logger.info("LicenseGrayConfigHelper.parseLicenseGrayControlFile fileName={}", (Object)fileName);
            String fileContent = LicenseGrayConfigHelper.readLicenseConfig(fileName);
            logger.info("LicenseGrayConfigHelper.parseLicenseGrayControlFile readLicenseConfig");
            LicenseGrayConfigHelper.verifySign(fileName, fileContent);
            logger.info("LicenseGrayConfigHelper.parseLicenseGrayControlFile verifySign");
            LicenseGrayCache.clearAllGrayFeatureInfo();
            logger.info("LicenseGrayConfigHelper.parseLicenseGrayControlFile clearAllGrayFeatureInfo");
            LicenseGrayConfigHelper.parseAndSaveGrayFeatureScheme(fileName, fileContent.getBytes());
        }
        catch (Exception e) {
            logger.error("LicenseGrayConfigHelper.parseLicenseGrayControlFile: Can't parse license configfile,please check!" + e);
            return LicenseConfigParseResult.fail((String)e.getMessage());
        }
        return LicenseConfigParseResult.success();
    }

    private static void parseAndSaveGrayFeatureScheme(String fileName, byte[] xml) throws DocumentException {
        logger.info("LicenseGrayConfigHelper.parseLicenseGrayControlFile parseAndSaveGrayFeatureScheme");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml);
        SAXReader reader = new SAXReader();
        Document doc = reader.read((InputStream)inputStream);
        Element rootElement = doc.getRootElement();
        Element element = rootElement.element("grayFeatureSchemes");
        List grayFeatureSchemeElements = element.elements("grayFeatureScheme");
        String insertMainTable = "insert into t_lic_grayfeaturescheme (fid,fnumber,fname,fdetailurl,fintroduction,fminversion) values(?,?,?,?,?,?)";
        String insertCloudTable = "insert into t_lic_grayfeatschecld (fid,fentryid,fcloudid,fcloudnum,fproduct,fisblack) values(?,?,?,?,?,?)";
        String insertAppTable = "insert into t_lic_grayfeatscheapp (fid,fentryid,fappid,fappnum,fproduct,fisblack) values(?,?,?,?,?,?)";
        String insertEntityTable = "insert into  t_lic_grayfeatscheobj (fid,fentryid,fappid,fappnum,fentityid,fentitynum,fproduct,fisblack,fonsale) values(?,?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> insertMainTableParams = new ArrayList<Object[]>(grayFeatureSchemeElements.size());
        ArrayList<Object[]> insertCloudTableParams = new ArrayList<Object[]>();
        ArrayList<Object[]> insertAppTableParams = new ArrayList<Object[]>();
        ArrayList<Object[]> insertEntityTableParams = new ArrayList<Object[]>();
        long[] ids = ID.genLongIds((int)grayFeatureSchemeElements.size());
        logger.info("LicenseGrayConfigHelper.parseLicenseGrayControlFile getModeType start");
        int product = LicenseGrayConfigHelper.getProductType();
        logger.info("LicenseGrayConfigHelper.parseLicenseGrayControlFile getModeType end");
        ArrayList<GrayCloudBLInfo> grayCloudInfos = new ArrayList<GrayCloudBLInfo>(3);
        HashMap<String, Object[]> cloudNumber2InsertCloudTableParam = new HashMap<String, Object[]>(16);
        HashSet<String> grayCloudNumbers = new HashSet<String>();
        ArrayList<GrayAppBLInfo> grayAppInfos = new ArrayList<GrayAppBLInfo>(3);
        HashMap<String, Object[]> appNumber2InsertAppTableParam = new HashMap<String, Object[]>(16);
        HashSet<String> grayAppNumbers = new HashSet<String>();
        ArrayList<GrayEntityBLInfo> grayEntityInfos = new ArrayList<GrayEntityBLInfo>(3);
        HashSet<String> entityNumbers = new HashSet<String>();
        Map<String, Long> existGrayFeatureNumber2ID = LicenseGrayConfigHelper.queryExistGrayFeature();
        Map<String, Long> validGrayFeatureNUmber2ID = LicenseGrayConfigHelper.queryValidGrayFeatures();
        ArrayList<Object> deleteGrayFeatureIds = new ArrayList<Object>();
        ArrayList<Object> releaseBlackFeatureIds = new ArrayList<Object>();
        logger.info("LicenseGrayConfigHelper.parseLicenseGrayControlFile forEach");
        if (grayFeatureSchemeElements != null && !grayFeatureSchemeElements.isEmpty()) {
            for (int i = 0; i < grayFeatureSchemeElements.size(); ++i) {
                long grayFeatureId = ids[i];
                Element grayFeatureSchemeElement = (Element)grayFeatureSchemeElements.get(i);
                String number = grayFeatureSchemeElement.attributeValue("number");
                if (existGrayFeatureNumber2ID.containsKey(number)) {
                    grayFeatureId = existGrayFeatureNumber2ID.get(number);
                    deleteGrayFeatureIds.add(grayFeatureId);
                    if (validGrayFeatureNUmber2ID.containsKey(number)) {
                        releaseBlackFeatureIds.add(grayFeatureId);
                    }
                }
                Object[] param = new Object[]{grayFeatureId, number, grayFeatureSchemeElement.attributeValue("name"), grayFeatureSchemeElement.attributeValue("detailurl"), grayFeatureSchemeElement.attributeValue("introduction"), grayFeatureSchemeElement.attributeValue("minversion")};
                insertMainTableParams.add(param);
                List configEntryElements = grayFeatureSchemeElement.elements("configEntry");
                long[] entryIds = ID.genLongIds((int)(configEntryElements.size() * 3));
                int useEntryId = 0;
                for (int j = 0; j < configEntryElements.size(); ++j) {
                    Object[] insertAppTableParam;
                    Object[] insertCloudTableParam;
                    Element configElement = (Element)configEntryElements.get(j);
                    String controlType = configElement.attributeValue("controltype");
                    String cloudNumber = configElement.attributeValue("cloudnumber");
                    String cloudID = configElement.attributeValue("cloudid");
                    if (!cloudNumber2InsertCloudTableParam.containsKey(cloudNumber)) {
                        insertCloudTableParam = new Object[]{grayFeatureId, entryIds[useEntryId++], configElement.attributeValue("cloudid"), cloudNumber, product, "cloud".equals(controlType) ? "1" : "0"};
                        insertCloudTableParams.add(insertCloudTableParam);
                        cloudNumber2InsertCloudTableParam.put(cloudNumber, insertCloudTableParam);
                    } else {
                        insertCloudTableParam = (Object[])cloudNumber2InsertCloudTableParam.get(cloudNumber);
                        if ("cloud".equals(controlType)) {
                            insertCloudTableParam[5] = "1";
                        }
                    }
                    if ("cloud".equals(controlType) && grayCloudNumbers.add(cloudNumber)) {
                        GrayCloudBLInfo grayCloudBLInfo = new GrayCloudBLInfo(cloudNumber, Integer.valueOf(product));
                        grayCloudBLInfo.setId(cloudID);
                        grayCloudInfos.add(grayCloudBLInfo);
                    }
                    String appNumber = configElement.attributeValue("appnumber");
                    String appID = configElement.attributeValue("appid");
                    if (!appNumber2InsertAppTableParam.containsKey(appNumber)) {
                        insertAppTableParam = new Object[]{grayFeatureId, entryIds[useEntryId++], configElement.attributeValue("appid"), configElement.attributeValue("appnumber"), product, "app".equals(controlType) ? "1" : "0"};
                        insertAppTableParams.add(insertAppTableParam);
                        appNumber2InsertAppTableParam.put(appNumber, insertAppTableParam);
                    } else {
                        insertAppTableParam = (Object[])appNumber2InsertAppTableParam.get(appNumber);
                        if ("app".equals(controlType)) {
                            insertAppTableParam[5] = "1";
                        }
                    }
                    if ("app".equals(controlType) && grayAppNumbers.add(appNumber)) {
                        GrayAppBLInfo grayAppBLInfo = new GrayAppBLInfo(appNumber, Integer.valueOf(product));
                        grayAppBLInfo.setId(appID);
                        grayAppInfos.add(grayAppBLInfo);
                    }
                    if (!entityNumbers.add(configElement.attributeValue("entitynumber"))) continue;
                    Object[] insertEntityTableParam = new Object[]{grayFeatureId, entryIds[useEntryId++], configElement.attributeValue("appid"), configElement.attributeValue("appnumber"), configElement.attributeValue("entitynumber"), configElement.attributeValue("entitynumber"), product, "entity".equals(controlType) ? "1" : "0", Boolean.parseBoolean(configElement.attributeValue("onsale")) ? "1" : "0"};
                    insertEntityTableParams.add(insertEntityTableParam);
                    if (!"entity".equals(controlType)) continue;
                    GrayEntityBLInfo grayEntityBLInfo = new GrayEntityBLInfo(configElement.attributeValue("entitynumber"), Integer.valueOf(product), configElement.attributeValue("appnumber"));
                    grayEntityBLInfo.setId(configElement.attributeValue("entitynumber"));
                    grayEntityInfos.add(grayEntityBLInfo);
                }
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                logger.info("LicenseGrayConfigHelper#parseAndSaveGrayFeatureScheme:insertMainTableParams={},insertCloudTableParams={},insertAppTableParams={},insertEntityTableParams={},grayCloudInfos={},grayAppInfos={},grayEntityInfos={},deleteGrayFeatureParams={}", new Object[]{JSONObject.toJSONString(insertMainTableParams), JSONObject.toJSONString(insertCloudTableParams), JSONObject.toJSONString(insertAppTableParams), JSONObject.toJSONString(insertEntityTableParams), JSONObject.toJSONString(grayCloudInfos), JSONObject.toJSONString(grayAppInfos), JSONObject.toJSONString(grayEntityInfos), JSONObject.toJSONString(deleteGrayFeatureIds)});
                if (deleteGrayFeatureIds.size() > 0) {
                    LicenseGrayConfigHelper.beforeSaveGrayFeature(deleteGrayFeatureIds);
                }
                if (insertMainTableParams.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertMainTable, insertMainTableParams);
                }
                if (insertCloudTableParams.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertCloudTable, insertCloudTableParams);
                }
                if (insertAppTableParams.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertAppTable, insertAppTableParams);
                }
                if (insertEntityTableParams.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertEntityTable, insertEntityTableParams);
                }
                if (grayCloudInfos.size() > 0) {
                    GrayBlackListServiceHelper.saveCloudBlackListNoCheck(grayCloudInfos);
                }
                if (grayAppInfos.size() > 0) {
                    GrayBlackListServiceHelper.saveAppBlackListNoCheck(grayAppInfos);
                }
                if (grayEntityInfos.size() > 0) {
                    GrayBlackListServiceHelper.saveEntityBlackListNoCheck(grayEntityInfos);
                }
                if (releaseBlackFeatureIds.size() > 0) {
                    LicenseGrayConfigHelper.afterSaveGrayFeature(releaseBlackFeatureIds);
                }
            }
            catch (Exception e) {
                logger.error("\u7070\u5ea6\u7279\u6027\u65b9\u6848\u89e3\u6790\u5931\u8d25\u3002", (Throwable)e);
                h.markRollback();
                throw new KDException(BosErrorCode.configParseException, new Object[]{String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u89e3\u6790\u7070\u5ea6\u7279\u6027\u65b9\u6848\u5931\u8d25\u3002", (String)"LicenseGrayConfigHelper_1", (String)"bos-license-business", (Object[])new Object[0]), fileName)});
            }
        }
    }

    private static void afterSaveGrayFeature(List<Object> releaseBlackFeatureIds) {
        if (CollectionUtils.isNotEmpty(releaseBlackFeatureIds)) {
            UpdateGrayBlackList updateGrayBlackList = new UpdateGrayBlackList();
            updateGrayBlackList.deleteBlackListByFeatureIds(releaseBlackFeatureIds);
        }
    }

    private static void beforeSaveGrayFeature(List<Object> deleteGrayFeatureIds) {
        UpdateGrayBlackList updateGrayBlackList = new UpdateGrayBlackList();
        updateGrayBlackList.deleteBlackListByFeatureIds(deleteGrayFeatureIds);
        UpdateGrayFeature updateGrayFeature = new UpdateGrayFeature();
        updateGrayFeature.deleteGrayFeatureByIds(deleteGrayFeatureIds);
    }

    private static Map<String, Long> queryExistGrayFeature() {
        HashMap<String, Long> existGrayFeatureNumber2ID = new HashMap<String, Long>(16);
        DB.query((DBRoute)DBRoute.basedata, (String)"select fid,fnumber from t_lic_grayfeaturescheme", resultSet -> {
            while (resultSet.next()) {
                existGrayFeatureNumber2ID.put(resultSet.getString("fnumber"), resultSet.getLong("fid"));
            }
            return null;
        });
        return existGrayFeatureNumber2ID;
    }

    private static Map<String, Long> queryValidGrayFeatures() {
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)"select a.fbegindate,a.fenddate,a.fstatus,b.fnumber,b.fid from t_lic_grayfeature a inner join t_lic_grayfeaturescheme b on a.fschemeid = b.fid where a.fstatus = '10';", resultSet -> {
            HashMap<String, Long> validGrayFeatures = new HashMap<String, Long>(16);
            while (resultSet.next()) {
                validGrayFeatures.put(resultSet.getString("fnumber"), resultSet.getLong("fid"));
            }
            return validGrayFeatures;
        });
    }

    private static int getProductType() {
        Object enableMultiOrg = null;
        try {
            enableMultiOrg = SystemParamServiceHelper.loadPublicParameterFromCache((String)"enablemultiorg");
        }
        catch (Exception e) {
            logger.warn("\u83b7\u53d6\u2018\u542f\u7528\u591a\u7ec4\u7ec7\u2019\u53c2\u6570\u5f02\u5e38\u3002", (Throwable)e);
        }
        if (enableMultiOrg != null) {
            return 2;
        }
        String sql = "select fprodid from t_lic_license;";
        return (Integer)DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            while (k.next()) {
                String prodID = k.getString("fprodid");
                if (!"2D3=SA5XL/93".equals(prodID) && !"2D3=SA5XL/92".equals(prodID)) continue;
                return 2;
            }
            return 1;
        });
    }
}

