/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.engine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.util.Pool;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.dlock.DLock;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.license.UpdateLicGroupUser;
import kd.bos.license.api.ILicenseService;
import kd.bos.license.api.LicenseAssignLog;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.bean.User;
import kd.bos.license.bean.UserIndex;
import kd.bos.license.engine.LicenseSnapshotEngine;
import kd.bos.license.pojo.LicUserRelBitDTO;
import kd.bos.license.service.cache.LicenseBitMapLocalCache;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.util.LicenseUtil;
import kd.bos.license.util.UserIndexUtil;
import kd.bos.license.util.UserUtil;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.HttpClientUtils;
import org.roaringbitmap.RoaringBitmap;

public class LicenseUserRelEngine {
    private static final Log logger = LogFactory.getLog(LicenseUserRelEngine.class);
    private static final String SYSTEM_TYPE = "bos-license-business";
    private static final String ENTITY_SNAPSHOT = "lic_snapshot";
    private static final String SIGN_PROP_DATA = "data";
    private static final String SIGN_PROP_SUCCESS = "success";
    private static final String SIGN_PROP_STATUS = "status";
    private static final String SIGN_PROP_DES = "description";
    private static final String SIGN_PROP_MSG = "message";
    private static final String SIGN_SCHEME_NUMBER = "LICENCE-SIGNATURE";
    private static final String FIELD_GROUP_ID = "fgroupid";
    private static final String VERSION = "VERSION";
    private static final int TIME_OUT_DAYS = 365;
    private static final String INSERT_SQL = "insert into T_LIC_GroupBitMap (fid, fgroupid, fbitmap, fsign, fcreatetime) values (?, ?, ?, ?, ?);";
    private static final String DELETE_SQL = "delete from T_LIC_GroupBitMap;";
    private static final String UPDATE_SQL = "update T_LIC_GroupBitMap set fbitmap = ?, fsign = ?, fcreatetime = ? where fgroupid = ?;";
    private static final DistributeSessionlessCache LIC_USER_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("LIC_USER_BIT_CACHE", new DistributeCacheHAPolicy());
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"LicenseUserRelEngine_POOL", (int)5);
    private static final Pool<Kryo> KRYO_POOL = new Pool<Kryo>(true, false, 20){

        protected Kryo create() {
            Kryo kryo = new Kryo();
            kryo.register(RoaringBitmap.class);
            kryo.setReferences(false);
            kryo.setRegistrationRequired(false);
            return kryo;
        }
    };

    public static Map<Long, Integer> getLicAllocateNumberByGroupIds(List<Long> groupIds) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Integer> allocateNumMap = new HashMap<Long, Integer>(groupIds.size());
        Map<Long, RoaringBitmap> licUseBitMap = LicenseCache.isCtrlAmountIgnoreTime() ? LicenseUserRelEngine.getLicRelBitFromCurrAccount(groupIds) : LicenseUserRelEngine.getLicRelBitFromAllAccount(groupIds);
        for (Map.Entry<Long, RoaringBitmap> entry : licUseBitMap.entrySet()) {
            allocateNumMap.put(entry.getKey(), entry.getValue().toArray().length);
        }
        return allocateNumMap;
    }

    public static List<Long> getUserLicFromCurrAccount(List<Long> groupIds, int userIndexes) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return Collections.emptyList();
        }
        Map<Long, RoaringBitmap> currAccountData = LicenseUserRelEngine.getLicRelBitFromCurrAccount(groupIds);
        if (CollectionUtils.isEmpty(currAccountData)) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>(groupIds.size());
        for (Map.Entry<Long, RoaringBitmap> entry : currAccountData.entrySet()) {
            RoaringBitmap bit = entry.getValue();
            if (!bit.contains(userIndexes)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public static Map<Long, List<Integer>> getLicAllocateUserByGroupIds(List<Long> groupIds) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return Collections.emptyMap();
        }
        boolean ctrlAmountIgnoreTime = LicenseCache.isCtrlAmountIgnoreTime();
        Map<Long, RoaringBitmap> licUseBitMap = null;
        licUseBitMap = ctrlAmountIgnoreTime ? LicenseUserRelEngine.getLicRelBitFromCurrAccount(groupIds) : LicenseUserRelEngine.getLicRelBitFromAllAccount(groupIds);
        HashMap<Long, List<Integer>> licUserMap = new HashMap<Long, List<Integer>>(groupIds.size());
        for (Map.Entry<Long, RoaringBitmap> entry : licUseBitMap.entrySet()) {
            RoaringBitmap bit = entry.getValue();
            List userIndexes = Arrays.stream(bit.toArray()).boxed().collect(Collectors.toList());
            licUserMap.put(entry.getKey(), userIndexes);
        }
        return licUserMap;
    }

    private static Map<Long, RoaringBitmap> getLicRelBitFromAllAccount(List<Long> groupIds) {
        HashMap clusterDataMap = new HashMap(groupIds.size());
        Map<Long, RoaringBitmap> currAccountData = LicenseUserRelEngine.getLicRelBitFromCurrAccount(groupIds);
        currAccountData.forEach((key, value) -> clusterDataMap.computeIfAbsent(key, k -> new ArrayList(16)).add(value));
        RequestContext context = RequestContext.get();
        String tenantId = context.getTenantId();
        String currAccountId = context.getAccountId();
        List centerList = AccountUtils.getAllAccounts((String)tenantId);
        for (Account account : centerList) {
            String accountId = account.getAccountId();
            if (StringUtils.isBlank((CharSequence)accountId) || accountId.equals(currAccountId)) continue;
            Map<Long, RoaringBitmap> accountData = LicenseUserRelEngine.getLicRelBitFromAccountCache(groupIds, tenantId, account);
            accountData.forEach((key, value) -> clusterDataMap.computeIfAbsent(key, k -> new ArrayList(16)).add(value));
        }
        HashMap<Long, RoaringBitmap> result = new HashMap<Long, RoaringBitmap>(groupIds.size());
        for (Map.Entry entry : clusterDataMap.entrySet()) {
            List bits = (List)entry.getValue();
            RoaringBitmap bit = (RoaringBitmap)bits.get(0);
            for (int i = 1; i < bits.size(); ++i) {
                RoaringBitmap bitmap = (RoaringBitmap)bits.get(i);
                bit.or(bitmap);
                bit.runOptimize();
            }
            result.put((Long)entry.getKey(), bit);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Long, RoaringBitmap> getLicRelBitFromAccountCache(Collection<Long> groupIds, String tenantId, Account account) {
        String type = LicenseCacheMrg.getType4UserGroupBitMap((String)account.getAccountId());
        Map<Long, RoaringBitmap> bitMap = LicenseUserRelEngine.getLicRelBitFromCache(groupIds, type, account.getAccountId());
        HashSet<Long> notExistGroupIds = new HashSet<Long>(groupIds);
        notExistGroupIds.removeAll(bitMap.keySet());
        if (notExistGroupIds.isEmpty()) {
            return bitMap;
        }
        String lockKey = LicenseUserRelEngine.getLicUnifiedLockKey(account.getAccountId());
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            Map<Long, RoaringBitmap> dbBitData = LicenseUserRelEngine.getLicRelBitMapFromDbByGroupIds(notExistGroupIds, tenantId, account);
            bitMap.putAll(LicenseUserRelEngine.compensateCache(type, notExistGroupIds, dbBitData));
        }
        finally {
            lock.unlock();
        }
        return bitMap;
    }

    private static Map<Long, RoaringBitmap> compensateCache(String type, Set<Long> notExistGroupIds, Map<Long, RoaringBitmap> dbBitData) {
        HashMap<Long, RoaringBitmap> bitMap = new HashMap<Long, RoaringBitmap>(notExistGroupIds.size());
        if (!dbBitData.isEmpty()) {
            bitMap.putAll(dbBitData);
            LicenseUserRelEngine.updateCache(dbBitData, type);
        }
        notExistGroupIds.removeAll(dbBitData.keySet());
        if (!notExistGroupIds.isEmpty()) {
            HashMap<Long, RoaringBitmap> emptyBitMap = new HashMap<Long, RoaringBitmap>(notExistGroupIds.size());
            notExistGroupIds.forEach(e -> {
                RoaringBitmap emptyBit = new RoaringBitmap();
                emptyBit.runOptimize();
                emptyBitMap.put((Long)e, emptyBit);
            });
            bitMap.putAll(emptyBitMap);
            LicenseUserRelEngine.updateCache(emptyBitMap, type);
        }
        return bitMap;
    }

    private static Map<Long, RoaringBitmap> getLicRelBitMapFromDbByGroupIds(Collection<Long> groupIds, String tenantId, Account account) {
        boolean isNeedUpdate;
        Map<Long, RoaringBitmap> groupBitMap;
        List<LicUserRelBitDTO> relBitDtoList;
        block17: {
            relBitDtoList = LicenseUserRelEngine.getLicUserRelBitDTO(groupIds, account);
            SqlBuilder builder = new SqlBuilder();
            builder.append("select fgroupid,fbitmap,fsign from T_LIC_GroupBitMap where ", new Object[0]);
            builder.appendIn(FIELD_GROUP_ID, groupIds.toArray());
            groupBitMap = null;
            isNeedUpdate = false;
            try {
                groupBitMap = LicenseUserRelEngine.verifySignAndTotal(relBitDtoList, tenantId, account.getAccountId());
            }
            catch (Exception e) {
                logger.error("\u5b58\u5728\u5206\u7ec4\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
                isNeedUpdate = true;
                if (!LicenseCache.isUpdateLicByBitMap()) break block17;
                throw e;
            }
        }
        if (isNeedUpdate) {
            LicenseSyncLog licenseSyncLog = new LicenseSyncLog();
            DynamicObject[] snapshots = BusinessDataServiceHelper.load((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
            if (snapshots == null || snapshots.length == 0) {
                LicenseUserRelEngine.downloadAndUpdateLic(true, licenseSyncLog);
                snapshots = BusinessDataServiceHelper.load((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
            }
            Arrays.sort(snapshots, (o1, o2) -> {
                int type1 = Integer.parseInt(o1.getString("snapshottype"));
                int type2 = Integer.parseInt(o2.getString("snapshottype"));
                return type1 - type2;
            });
            String data = snapshots[snapshots.length - 1].getString(SIGN_PROP_DATA);
            try (DLock dlock = DLock.createReentrant((String)"lic_snapshot_restore");){
                dlock.lock();
                if (!LicenseCache.isUpdateLicByBitMap()) {
                    LicenseSnapshotEngine.restoreSnap(data, true);
                    LIC_USER_CACHE.put(LicenseCacheMrg.getUpdateLicByBitMapType(), (Object)"DATA_LOADED");
                }
            }
            relBitDtoList = LicenseUserRelEngine.getLicUserRelBitDTO(groupIds, account);
            groupBitMap = LicenseUserRelEngine.verifySignAndTotal(relBitDtoList, tenantId, account.getAccountId());
        }
        return groupBitMap;
    }

    private static List<LicUserRelBitDTO> getLicUserRelBitDTO(Collection<Long> groupIds, Account account) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<LicUserRelBitDTO> relBitDtoList = new ArrayList<LicUserRelBitDTO>(10);
        try {
            Properties properties = AccountUtils.getTenantDBInfo((Account)account);
            conn = MCDBUtil.getConnection((Account)account, (Properties)properties);
            List collect = groupIds.stream().map(String::valueOf).collect(Collectors.toList());
            StringBuilder builder = new StringBuilder();
            builder.append("select fgroupid,fbitmap,fsign from T_LIC_GroupBitMap where fgroupid in (");
            builder.append(String.join((CharSequence)",", collect)).append(") ");
            stmt = conn.prepareStatement(builder.toString());
            rs = stmt.executeQuery();
            relBitDtoList.addAll(LicenseUserRelEngine.handleDbResultSet(rs));
        }
        catch (SQLException e) {
            try {
                logger.error("\u8de8\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw new KDBizException("deserialization bit data fail.");
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return relBitDtoList;
    }

    private static List<LicUserRelBitDTO> handleDbResultSet(ResultSet rs) throws SQLException {
        ArrayList<LicUserRelBitDTO> batchData = new ArrayList<LicUserRelBitDTO>(10);
        while (rs.next()) {
            Long groupId = rs.getLong(FIELD_GROUP_ID);
            byte[] bytes = rs.getBytes("fbitmap");
            LicUserRelBitDTO dto = new LicUserRelBitDTO(groupId, bytes, rs.getString("fsign"));
            batchData.add(dto);
        }
        return batchData;
    }

    private static Map<Long, RoaringBitmap> verifySignAndTotal(List<LicUserRelBitDTO> relBitDtoList, String tenantId, String accountId) {
        if (relBitDtoList.isEmpty()) {
            return new HashMap<Long, RoaringBitmap>(0);
        }
        HashMap<String, String> signParams = new HashMap<String, String>(16);
        for (LicUserRelBitDTO dto : relBitDtoList) {
            Long groupId = dto.getGroupId();
            dto.setBit(LicenseUserRelEngine.desRoaringBitmapByteArr(dto.getBytes(), accountId, groupId));
            String digest = Arrays.stream(dto.getBit().toArray()).mapToObj(String::valueOf).collect(Collectors.joining(""));
            signParams.put(String.valueOf(groupId), digest);
        }
        Map<Long, RoaringBitmap> relBitMap = LicenseUserRelEngine.signature(relBitDtoList, signParams, tenantId, accountId);
        for (Map.Entry<Long, RoaringBitmap> entry : relBitMap.entrySet()) {
            Long groupId = entry.getKey();
            int total = LicenseServiceHelper.getTotalNumber((Object)groupId);
            if (total >= entry.getValue().toArray().length) continue;
            KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u91cd\u5efa\u8bb8\u53ef\u7f13\u5b58\u5931\u8d25\uff0c\u6709\u7528\u6237\u8bb8\u53ef\u5206\u7ec4\u8d85\u8fc7\u6700\u5927\u8bb8\u53ef\u6570\u91cf\u3002", (String)"LicenseUserRelEngine_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\uff0c\u8bb8\u53ef\u5206\u7ec4\u3010%s\u3011\u91cd\u5efa\u8bb8\u53ef\u5206\u7ec4\u7f13\u5b58\u65f6\u4f4d\u56fe\u4e2d\u7684\u8bb8\u53ef\u7528\u6237\u8d85\u8fc7\u4e86\u8bb8\u53ef\u603b\u6570\u3002", accountId, groupId), (Throwable)e);
            throw e;
        }
        return relBitMap;
    }

    private static Map<Long, RoaringBitmap> signature(List<LicUserRelBitDTO> relBits, Map<String, String> signMap, String tenantId, String accountId) {
        HashMap<Long, RoaringBitmap> result = new HashMap<Long, RoaringBitmap>(16);
        JSONObject json = LicenseUserRelEngine.generateSignature(signMap, tenantId, accountId);
        JSONObject data = json.getJSONObject(SIGN_PROP_DATA);
        for (LicUserRelBitDTO dto : relBits) {
            String sign = data.getString(String.valueOf(dto.getGroupId()));
            if (StringUtils.isBlank((CharSequence)sign)) {
                KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u91cd\u5efa\u8bb8\u53ef\u5206\u7ec4\u7f13\u5b58\u65f6\u65e0\u6cd5\u83b7\u53d6\u7b7e\u540d\u4fe1\u606f\u3002", (String)"LicenseUserRelEngine_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\uff0c\u8bb8\u53ef\u5206\u7ec4\u3010%s\u3011\u91cd\u5efa\u8bb8\u53ef\u5206\u7ec4\u7f13\u5b58\u65f6\u65e0\u6cd5\u83b7\u53d6\u7b7e\u540d\u4fe1\u606f\u3002", accountId, dto.getGroupId()), (Throwable)e);
                throw e;
            }
            if (!sign.equals(dto.getSign())) {
                KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u6709\u8bb8\u53ef\u4fe1\u606f\u7b7e\u540d\u524d\u540e\u4e0d\u4e00\u81f4\uff0c\u9a8c\u7b7e\u5931\u8d25\u3002", (String)"LicenseUserRelEngine_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\uff0c\u8bb8\u53ef\u5206\u7ec4\u3010%s\u3011\u8bb8\u53ef\u4fe1\u606f\u7b7e\u540d\u524d\u540e\u4e0d\u4e00\u81f4\uff0c\u9a8c\u7b7e\u5931\u8d25\u3002", accountId, dto.getGroupId()), (Throwable)e);
                throw e;
            }
            result.put(dto.getGroupId(), dto.getBit());
        }
        return result;
    }

    private static void rebuildLicRelBitCache(Collection<Long> groupIds, String contextPath, String accountId, String token) {
        String value;
        String url = String.format("%skapi/v2/base/license/rebuild?accountId=%s", contextPath, accountId);
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
        params.put("groupIds", groupIds);
        try {
            HashMap<String, String> header = new HashMap<String, String>(4);
            header.put("Content-type", "application/json");
            header.put("charset", "utf-8");
            header.put("access_token", token);
            value = HttpClientUtils.postjson((String)url, header, (String)JSON.toJSONString(params), (int)10000, (int)10000);
        }
        catch (Exception e) {
            logger.error(String.format("\u91cd\u5efa\u8bb8\u53ef\u7f13\u5b58\u5931\u8d25\uff0c\u6570\u636e\u4e2d\u5fc3\u4e3a\u3010%s\u3011\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u3010%s\u3011\uff0c\u53c2\u6570\u4e3a\u3010%s\u3011.", accountId, url, JSON.toJSONString(params)), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u91cd\u5efa\u8bb8\u53ef\u7f13\u5b58\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseUserRelEngine_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u91cd\u5efa\u8bb8\u53ef\u7f13\u5b58\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseUserRelEngine_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            logger.error(String.format("\u91cd\u5efa\u8bb8\u53ef\u7f13\u5b58\u5931\u8d25\uff0c\u8de8\u6570\u636e\u4e2d\u5fc3\u91cd\u5efa\u7f13\u5b58\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a\u7a7a\uff0c\u6570\u636e\u4e2d\u5fc3\u4e3a\u3010%s\u3011\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u3010%s\u3011\uff0c\u53c2\u6570\u4e3a\u3010%s\u3011.", accountId, url, JSON.toJSONString(params)), (Throwable)e);
            throw e;
        }
        JSONObject signJson = JSON.parseObject((String)value);
        if (!signJson.getBooleanValue(SIGN_PROP_STATUS)) {
            throw new KDBizException(signJson.getString(SIGN_PROP_MSG));
        }
    }

    public static void removeCache(String key, String type) {
        LIC_USER_CACHE.put(type, VERSION, DB.genStringId((String)""), 365, TimeUnit.DAYS);
        LIC_USER_CACHE.remove(type, key);
    }

    public static Map<String, List<Integer>> getGroupIndexes(Long groupId, Account account) {
        HashMap<String, List<Integer>> result = new HashMap<String, List<Integer>>(1);
        Map<Long, RoaringBitmap> cache = LicenseUserRelEngine.getLicRelBitFromAccountCache(Collections.singleton(groupId), RequestContext.get().getTenantId(), account);
        RoaringBitmap bitmap = cache.get(groupId);
        List indexes = null == bitmap ? Collections.emptyList() : Arrays.stream(bitmap.toArray()).boxed().collect(Collectors.toList());
        Map<Long, String> signs = LicenseUserRelEngine.getLicenseGroupSign(Collections.singleton(groupId), account);
        if (signs.isEmpty()) {
            result.put(LicenseUserRelEngine.class.getName(), indexes);
        } else {
            result.put(signs.get(groupId), indexes);
        }
        return result;
    }

    private static Map<Long, String> getLicenseGroupSign(Collection<Long> groupIds, Account account) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<Long, String> signs = new HashMap<Long, String>(10);
        try {
            Properties properties = AccountUtils.getTenantDBInfo((Account)account);
            conn = MCDBUtil.getConnection((Account)account, (Properties)properties);
            List collect = groupIds.stream().map(String::valueOf).collect(Collectors.toList());
            StringBuilder builder = new StringBuilder();
            builder.append("select fgroupid,fsign from T_LIC_GroupBitMap where fgroupid in (");
            builder.append(String.join((CharSequence)",", collect)).append(") ");
            stmt = conn.prepareStatement(builder.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                signs.put(rs.getLong(FIELD_GROUP_ID), rs.getString("fsign"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error("\u8de8\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw new KDBizException("select license sign fail.");
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return signs;
    }

    private static void quickRebuildCurrAccountLocalCacheLicRelBit(Collection<Long> groupIds, List<String> groupIdStrs) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return;
        }
        ArrayList<Long> groupIdLs = new ArrayList<Long>(groupIds);
        String accountId = RequestContext.get().getAccountId();
        try (DLock lock = DLock.createReentrant((String)String.format("lic_rebuild_Local%s", accountId));){
            lock.lock();
            Map<String, RoaringBitmap> allBitMap = LicenseBitMapLocalCache.getAllBitMap();
            if (!CollectionUtils.isEmpty(allBitMap)) {
                return;
            }
            HashMap<Long, RoaringBitmap> bitMap = new HashMap<Long, RoaringBitmap>(groupIdLs.size());
            SqlBuilder builder = new SqlBuilder();
            builder.append("select fgroupid,fbitmap,fsign from T_LIC_GroupBitMap;", new Object[0]);
            List relBitDtoList = (List)DB.query((DBRoute)DBRoute.base, (SqlBuilder)builder, rs -> {
                ArrayList<LicUserRelBitDTO> batchData = new ArrayList<LicUserRelBitDTO>(10);
                while (rs.next()) {
                    Long groupId = rs.getLong(FIELD_GROUP_ID);
                    byte[] bytes = rs.getBytes("fbitmap");
                    LicUserRelBitDTO dto = new LicUserRelBitDTO(groupId, bytes, rs.getString("fsign"));
                    batchData.add(dto);
                }
                return batchData;
            });
            Map<Long, RoaringBitmap> dbBitData = LicenseUserRelEngine.getRoaringBitmapMapByLicUserRelBitDTO(relBitDtoList);
            if (!dbBitData.isEmpty()) {
                bitMap.putAll(dbBitData);
            }
            groupIdLs.removeAll(dbBitData.keySet());
            if (!groupIdLs.isEmpty()) {
                groupIdLs.forEach(e -> {
                    RoaringBitmap emptyBit = new RoaringBitmap();
                    emptyBit.runOptimize();
                    bitMap.put((Long)e, emptyBit);
                });
            }
            HashMap<String, RoaringBitmap> cacheData = new HashMap<String, RoaringBitmap>(bitMap.size());
            for (Map.Entry entry : bitMap.entrySet()) {
                cacheData.put(String.valueOf(entry.getKey()), (RoaringBitmap)entry.getValue());
            }
            LicenseBitMapLocalCache.putBitMap(cacheData);
        }
    }

    private static List<RoaringBitmap> replaceLocalCache(Map<String, String> allBitMapFromRedisCache, List<String> groupIdStrs, String redisType) {
        if (CollectionUtils.isEmpty(allBitMapFromRedisCache) || CollectionUtils.isEmpty(groupIdStrs)) {
            return Collections.emptyList();
        }
        List<Object> cacheValues = new ArrayList(16);
        try (DLock dlock = DLock.createReentrant((String)("replaceLocalCache_" + RequestContext.get().getAccountId()));){
            dlock.lock();
            String redisVersion = allBitMapFromRedisCache.get(VERSION);
            String localCacheVersion = LicenseBitMapLocalCache.getVersion();
            logger.debug("LicenseUserRelEngine " + SerializationUtils.toJsonString(allBitMapFromRedisCache));
            if (!StringUtils.equals((CharSequence)redisVersion, (CharSequence)localCacheVersion) || null == LicenseBitMapLocalCache.getAllBitMap()) {
                LicenseBitMapLocalCache.putAllBitMap(LicenseUserRelEngine.stringMapToRoaringMap(allBitMapFromRedisCache));
                if (null == redisVersion) {
                    redisVersion = DB.genStringId((String)"");
                    LIC_USER_CACHE.put(redisType, VERSION, redisVersion, 365, TimeUnit.DAYS);
                }
                LicenseBitMapLocalCache.putVersion(redisVersion);
                cacheValues.addAll(LicenseBitMapLocalCache.getBitMap(groupIdStrs));
                logger.debug("LicenseUserRelEngine replace. in " + groupIdStrs + " return " + cacheValues);
            } else {
                cacheValues = LicenseBitMapLocalCache.getBitMap(groupIdStrs);
                logger.debug("LicenseUserRelEngine no replace. in " + groupIdStrs + " return " + cacheValues);
            }
        }
        return cacheValues;
    }

    private static Map<String, RoaringBitmap> stringMapToRoaringMap(Map<String, String> allBitMap) {
        if (CollectionUtils.isEmpty(allBitMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, RoaringBitmap> result = new HashMap<String, RoaringBitmap>(allBitMap.size());
        for (Map.Entry<String, String> bitMapFromRedisCache : allBitMap.entrySet()) {
            String value = bitMapFromRedisCache.getValue();
            String groupId = bitMapFromRedisCache.getKey();
            if (VERSION.equals(groupId)) continue;
            if (StringUtils.isBlank((CharSequence)value)) {
                result.put(groupId, new RoaringBitmap());
            }
            result.put(groupId, LicenseUserRelEngine.desRoaringBitmapByteArr(value.getBytes(StandardCharsets.ISO_8859_1), RequestContext.get().getAccountId(), null));
        }
        return result;
    }

    private static List<RoaringBitmap> updateLocalBitMapCache(Collection<Long> groupIds, List<String> groupIdStrs) {
        if (CollectionUtils.isEmpty(groupIds) || CollectionUtils.isEmpty(groupIdStrs)) {
            return Collections.emptyList();
        }
        logger.debug("LicenseUserRelEngine.getCurrLicRelBitByVersionMode.quickRebuildCurrAccountLocalCacheLicRelBit.");
        LicenseUserRelEngine.quickRebuildCurrAccountLocalCacheLicRelBit(groupIds, groupIdStrs);
        logger.debug("LicenseUserRelEngine.getCurrLicRelBitByVersionMode.rebuildCurrAccountLicRelBitTask.");
        THREAD_POOL.submit(LicenseUserRelEngine.rebuildCurrAccountLicRelBitTask(new HashSet<Long>(groupIds)), RequestContext.get());
        return LicenseBitMapLocalCache.getBitMap(groupIdStrs);
    }

    public static Map<Long, RoaringBitmap> getCurrLicRelBitByVersionMode(Collection<Long> groupIds) {
        logger.debug("LicenseUserRelEngine.getCurrLicRelBitByVersionMode.");
        if (CollectionUtils.isEmpty((Collection)groupIds)) {
            groupIds = (Collection)DB.query((DBRoute)DBRoute.base, (String)"select fgroupid from t_lic_licensedetail ", rs -> {
                ArrayList<Long> allGroupIds = new ArrayList<Long>(16);
                while (rs.next()) {
                    allGroupIds.add(rs.getLong(FIELD_GROUP_ID));
                }
                return allGroupIds;
            });
        }
        String bitMapRedisType = LicenseCacheMrg.getType4UserGroupBitMap();
        String redisVersion = (String)LIC_USER_CACHE.get(bitMapRedisType, VERSION);
        String localCacheVersion = LicenseBitMapLocalCache.getVersion();
        logger.debug("LicenseUserRelEngine.getCurrLicRelBitByVersionMode. redisVersion : " + redisVersion + " localCacheVersion : " + localCacheVersion);
        HashMap<Long, RoaringBitmap> bitMap = new HashMap<Long, RoaringBitmap>(groupIds.size());
        List<String> groupIdStrs = groupIds.stream().map(String::valueOf).collect(Collectors.toList());
        List<Object> cacheValues = null;
        if (StringUtils.equals((CharSequence)redisVersion, (CharSequence)localCacheVersion)) {
            Map<String, RoaringBitmap> allBitMapFromLocalCache = LicenseBitMapLocalCache.getAllBitMap();
            if (null == allBitMapFromLocalCache) {
                logger.debug("LicenseUserRelEngine.getCurrLicRelBitByVersionMode. localCache is blank");
                Map allBitMapFromRedisCache = LIC_USER_CACHE.getAll(bitMapRedisType);
                if (CollectionUtils.isEmpty((Map)allBitMapFromRedisCache) || !LicenseUserRelEngine.checkDataIntegrity(allBitMapFromRedisCache)) {
                    logger.debug("LicenseUserRelEngine.getCurrLicRelBitByVersionMode. redisCache is blank.");
                    cacheValues = LicenseUserRelEngine.updateLocalBitMapCache(groupIds, groupIdStrs);
                } else {
                    logger.debug("LicenseUserRelEngine.getCurrLicRelBitByVersionMode.replaceLocalCache");
                    cacheValues = LicenseUserRelEngine.replaceLocalCache(allBitMapFromRedisCache, groupIdStrs, bitMapRedisType);
                }
            } else {
                cacheValues = new ArrayList(groupIdStrs.size());
                for (String string : groupIdStrs) {
                    cacheValues.add(allBitMapFromLocalCache.get(string));
                }
                logger.debug("LicenseUserRelEngine.getCurrLicRelBitByVersionMode.return loaclCache");
            }
        } else {
            Map allBitMapFromRedisCache = LIC_USER_CACHE.getAll(bitMapRedisType);
            if (CollectionUtils.isEmpty((Map)allBitMapFromRedisCache) || !LicenseUserRelEngine.checkDataIntegrity(allBitMapFromRedisCache)) {
                logger.debug("LicenseUserRelEngine.getCurrLicRelBitByVersionMode. redisCache is blank");
                Map<String, RoaringBitmap> allBitMapFromLocalCache = LicenseBitMapLocalCache.getAllBitMap();
                if (null == allBitMapFromLocalCache) {
                    logger.debug("LicenseUserRelEngine.getCurrLicRelBitByVersionMode. localCache is blank");
                    cacheValues = LicenseUserRelEngine.updateLocalBitMapCache(groupIds, groupIdStrs);
                } else {
                    logger.debug("LicenseUserRelEngine.getCurrLicRelBitByVersionMode.rebuildCurrAccountLicRelBitTask");
                    THREAD_POOL.submit(LicenseUserRelEngine.rebuildCurrAccountLicRelBitTask(new HashSet<Long>(groupIds)), RequestContext.get());
                    cacheValues = new ArrayList(groupIdStrs.size());
                    for (String groupId : groupIdStrs) {
                        cacheValues.add(allBitMapFromLocalCache.get(groupId));
                    }
                }
            } else {
                cacheValues = LicenseUserRelEngine.replaceLocalCache(allBitMapFromRedisCache, groupIdStrs, bitMapRedisType);
            }
        }
        for (int i = 0; i < groupIdStrs.size(); ++i) {
            Long groupId = Long.valueOf(groupIdStrs.get(i));
            RoaringBitmap roaringBitmap = (RoaringBitmap)cacheValues.get(i);
            if (null != roaringBitmap) {
                bitMap.put(groupId, roaringBitmap);
                continue;
            }
            bitMap.put(groupId, new RoaringBitmap());
        }
        return bitMap;
    }

    private static boolean checkDataIntegrity(Map<String, String> allBitMapFromRedisCache) {
        if (CollectionUtils.isEmpty(allBitMapFromRedisCache)) {
            return false;
        }
        Set groupIds = (Set)DB.query((DBRoute)DBRoute.base, (String)"select fgroupid from T_LIC_GroupBitMap;", (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> result = new HashSet<String>(16);
                while (rs.next()) {
                    result.add(rs.getString(LicenseUserRelEngine.FIELD_GROUP_ID));
                }
                return result;
            }
        });
        groupIds.removeAll(allBitMapFromRedisCache.keySet());
        return groupIds.isEmpty();
    }

    private static Callable<Map<Long, RoaringBitmap>> rebuildCurrAccountLicRelBitTask(Set<Long> groupIds) {
        Set groupIdLs = (Set)DB.query((DBRoute)DBRoute.base, (String)"select fgroupid from T_LIC_GroupBitMap;", (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> result = new HashSet<Long>(16);
                while (rs.next()) {
                    result.add(rs.getLong(LicenseUserRelEngine.FIELD_GROUP_ID));
                }
                return result;
            }
        });
        if (CollectionUtils.isEmpty((Collection)groupIdLs)) {
            return null;
        }
        return () -> LicenseUserRelEngine.rebuildCurrAccountLicRelBit(groupIdLs);
    }

    public static Map<Long, RoaringBitmap> getLicRelBitFromCurrAccount(Collection<Long> groupIds) {
        String type = LicenseCacheMrg.getType4UserGroupBitMap();
        Map<Long, RoaringBitmap> bitMap = LicenseUserRelEngine.getLicRelBitFromCache(groupIds, type, RequestContext.get().getAccountId());
        HashSet<Long> notExistGroupIds = new HashSet<Long>(groupIds);
        notExistGroupIds.removeAll(bitMap.keySet());
        if (notExistGroupIds.isEmpty()) {
            return bitMap;
        }
        bitMap.putAll(LicenseUserRelEngine.rebuildCurrAccountLicRelBit(notExistGroupIds));
        return bitMap;
    }

    public static Map<Long, RoaringBitmap> rebuildCurrAccountLicRelBit(Set<Long> groupIds) {
        return LicenseUserRelEngine.rebuildCurrAccountLicRelBit(groupIds, false);
    }

    public static Map<Long, RoaringBitmap> rebuildCurrAccountLicRelBit(Set<Long> groupIds, boolean isUpdating) {
        String accountId = RequestContext.get().getAccountId();
        String key = String.format("lic_rebuild_%s", accountId);
        String[] idArr = (String[])groupIds.stream().map(String::valueOf).toArray(String[]::new);
        LIC_USER_CACHE.addToSet(key, idArr);
        DLock lock = DLock.createReentrant((String)LicenseUserRelEngine.getLicUnifiedLockKey(accountId));
        lock.lock();
        try {
            String type = LicenseCacheMrg.getType4UserGroupBitMap();
            Map<Long, RoaringBitmap> bitMap = LicenseUserRelEngine.getLicRelBitFromCache(groupIds, type, accountId);
            if (groupIds.size() == bitMap.size()) {
                String version = (String)LIC_USER_CACHE.get(type, VERSION);
                if (StringUtils.isBlank((CharSequence)version)) {
                    LIC_USER_CACHE.put(type, VERSION, DB.genStringId((String)""), 365, TimeUnit.DAYS);
                }
                Map<Long, RoaringBitmap> map = bitMap;
                return map;
            }
            groupIds.removeAll(bitMap.keySet());
            HashSet<Long> needRebuildCacheGroupIds = new HashSet<Long>(groupIds);
            String[] cacheIds = LIC_USER_CACHE.getSetValues(key);
            if (null != cacheIds && cacheIds.length > 0) {
                needRebuildCacheGroupIds.addAll(Arrays.stream(cacheIds).mapToLong(Long::parseLong).boxed().collect(Collectors.toList()));
            }
            Map<Long, RoaringBitmap> dbBitData = LicenseUserRelEngine.getLicRelBitMapFromDbByGroupIds(needRebuildCacheGroupIds, false, isUpdating);
            Map<Long, RoaringBitmap> cacheMap = LicenseUserRelEngine.compensateCache(needRebuildCacheGroupIds, dbBitData);
            groupIds.forEach(e -> {
                RoaringBitmap cfr_ignored_0 = (RoaringBitmap)bitMap.put((Long)e, (RoaringBitmap)cacheMap.get(e));
            });
            if (null != cacheIds && cacheIds.length > 0) {
                LIC_USER_CACHE.removeSetValues(key, cacheIds);
            }
            LicenseCache.clearCircuitBreaker("bitMap");
            Map<Long, RoaringBitmap> map = bitMap;
            return map;
        }
        catch (Exception e2) {
            logger.error("bitMapCircuitBreaker.please check error message and updateLicense.", (Throwable)e2);
            AppLogInfo appLogInfo = new AppLogInfo();
            appLogInfo.setBizAppID("83bfebc8000037ac");
            appLogInfo.setBizObjID("lic_license");
            appLogInfo.setOpDescription(ResManager.loadKDString((String)"\u91cd\u5efa\u8bb8\u53ef\u4f4d\u56fe\u7f13\u5b58\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770bmonitor\u65e5\u5fd7\uff0c\u5173\u952e\u5b57\uff1abitMapCircuitBreaker\u3002", (String)"LicenseUserRelEngine_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            appLogInfo.setOpName(ResManager.loadKDString((String)"\u91cd\u5efa\u8bb8\u53ef\u4f4d\u56fe", (String)"LicenseUserRelEngine_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
            LicenseCacheMrg.putCache((String)LicenseCacheMrg.getLicenseCircuitBreakerType(), (String)"bitMap", (String)"DATA_LOADED");
            throw e2;
        }
        finally {
            lock.unlock();
        }
    }

    private static Map<Long, RoaringBitmap> compensateCache(Set<Long> notExistGroupIds, Map<Long, RoaringBitmap> dbBitData) {
        String type = LicenseCacheMrg.getType4UserGroupBitMap();
        HashMap<Long, RoaringBitmap> bitMap = new HashMap<Long, RoaringBitmap>(notExistGroupIds.size());
        if (!dbBitData.isEmpty()) {
            bitMap.putAll(dbBitData);
        }
        notExistGroupIds.removeAll(dbBitData.keySet());
        if (!notExistGroupIds.isEmpty()) {
            notExistGroupIds.forEach(e -> {
                RoaringBitmap emptyBit = new RoaringBitmap();
                emptyBit.runOptimize();
                bitMap.put((Long)e, emptyBit);
            });
        }
        LicenseUserRelEngine.updateCache(bitMap, type);
        return bitMap;
    }

    private static Map<Long, RoaringBitmap> getLicRelBitMapFromDbByGroupIds(Collection<Long> groupIds, boolean noVerifySignAndTotal, boolean isUpdating) {
        boolean isNeedUpdate;
        Map<Long, RoaringBitmap> groupBitMap;
        List relBitDtoList;
        SqlBuilder builder;
        block19: {
            if (CollectionUtils.isEmpty(groupIds)) {
                return new HashMap<Long, RoaringBitmap>(0);
            }
            builder = new SqlBuilder();
            builder.append("select fgroupid,fbitmap,fsign from T_LIC_GroupBitMap where", new Object[0]);
            builder.appendIn(FIELD_GROUP_ID, groupIds.toArray());
            relBitDtoList = (List)DB.query((DBRoute)DBRoute.base, (SqlBuilder)builder, rs -> {
                ArrayList<LicUserRelBitDTO> batchData = new ArrayList<LicUserRelBitDTO>(10);
                while (rs.next()) {
                    Long groupId = rs.getLong(FIELD_GROUP_ID);
                    byte[] bytes = rs.getBytes("fbitmap");
                    LicUserRelBitDTO dto = new LicUserRelBitDTO(groupId, bytes, rs.getString("fsign"));
                    batchData.add(dto);
                }
                return batchData;
            });
            if (noVerifySignAndTotal) {
                return LicenseUserRelEngine.getRoaringBitmapMapByLicUserRelBitDTO(relBitDtoList);
            }
            groupBitMap = null;
            isNeedUpdate = false;
            try {
                groupBitMap = LicenseUserRelEngine.verifySignAndTotal(relBitDtoList, isUpdating);
            }
            catch (Exception e) {
                logger.error("\u5b58\u5728\u5206\u7ec4\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
                isNeedUpdate = true;
                if (!LicenseCache.isUpdateLicByBitMap()) break block19;
                throw e;
            }
        }
        if (isNeedUpdate) {
            LicenseSyncLog licenseSyncLog = new LicenseSyncLog();
            DynamicObject[] snapshots = BusinessDataServiceHelper.load((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
            if (snapshots == null || snapshots.length == 0) {
                LicenseUserRelEngine.downloadAndUpdateLic(true, licenseSyncLog);
                snapshots = BusinessDataServiceHelper.load((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
            }
            Arrays.sort(snapshots, (o1, o2) -> {
                int type1 = Integer.parseInt(o1.getString("snapshottype"));
                int type2 = Integer.parseInt(o2.getString("snapshottype"));
                return type1 - type2;
            });
            String data = snapshots[snapshots.length - 1].getString(SIGN_PROP_DATA);
            try (DLock dlock = DLock.createReentrant((String)"lic_snapshot_restore");){
                dlock.lock();
                if (!LicenseCache.isUpdateLicByBitMap()) {
                    LicenseSnapshotEngine.restoreSnap(data, true);
                    LIC_USER_CACHE.put(LicenseCacheMrg.getUpdateLicByBitMapType(), (Object)"DATA_LOADED");
                }
            }
            relBitDtoList = (List)DB.query((DBRoute)DBRoute.base, (SqlBuilder)builder, rs -> {
                ArrayList<LicUserRelBitDTO> batchData = new ArrayList<LicUserRelBitDTO>(10);
                while (rs.next()) {
                    Long groupId = rs.getLong(FIELD_GROUP_ID);
                    byte[] bytes = rs.getBytes("fbitmap");
                    LicUserRelBitDTO dto = new LicUserRelBitDTO(groupId, bytes, rs.getString("fsign"));
                    batchData.add(dto);
                }
                return batchData;
            });
            groupBitMap = LicenseUserRelEngine.verifySignAndTotal(relBitDtoList, isUpdating);
        }
        return groupBitMap;
    }

    private static void downloadAndUpdateLic(boolean isHighAvailabilityMode, LicenseSyncLog licenseSyncLog) {
        UpdateLicGroupUser updateLicGroupUser = new UpdateLicGroupUser();
        boolean updateLicenseResult = false;
        try {
            updateLicenseResult = updateLicGroupUser.downloadAndUpdateLicUser(true, licenseSyncLog, isHighAvailabilityMode);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (Throwable)e);
        }
        if (null != licenseSyncLog) {
            licenseSyncLog.setOperator(Long.valueOf(-10000L));
        }
        if (!updateLicenseResult) {
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (String)"LicenseCache_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private static Map<Long, RoaringBitmap> getRoaringBitmapMapByLicUserRelBitDTO(List<LicUserRelBitDTO> relBitDtoList) {
        if (relBitDtoList.isEmpty()) {
            return new HashMap<Long, RoaringBitmap>(0);
        }
        HashMap<Long, RoaringBitmap> result = new HashMap<Long, RoaringBitmap>(16);
        for (LicUserRelBitDTO dto : relBitDtoList) {
            if (null == dto) continue;
            result.put(dto.getGroupId(), LicenseUserRelEngine.desRoaringBitmapByteArr(dto.getBytes(), null, null));
        }
        return result;
    }

    private static Map<Long, RoaringBitmap> verifySignAndTotal(List<LicUserRelBitDTO> relBitDtoList, boolean isUpdating) {
        if (relBitDtoList.isEmpty()) {
            return new HashMap<Long, RoaringBitmap>(0);
        }
        String accountId = RequestContext.get().getAccountId();
        HashMap<String, String> signMap = new HashMap<String, String>(relBitDtoList.size());
        for (LicUserRelBitDTO dto : relBitDtoList) {
            Long groupId = dto.getGroupId();
            dto.setBit(LicenseUserRelEngine.desRoaringBitmapByteArr(dto.getBytes(), accountId, groupId));
            String digest = Arrays.stream(dto.getBit().toArray()).mapToObj(String::valueOf).collect(Collectors.joining(""));
            signMap.put(groupId.toString(), digest);
        }
        Map<Long, RoaringBitmap> relBitMap = LicenseUserRelEngine.signature(relBitDtoList, signMap, isUpdating);
        for (Map.Entry<Long, RoaringBitmap> entry : relBitMap.entrySet()) {
            int assignCount;
            Long groupId = entry.getKey();
            int total = LicenseServiceHelper.getTotalNumber((Object)groupId);
            if (total >= (assignCount = entry.getValue().toArray().length)) continue;
            KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u91cd\u5efa\u8bb8\u53ef\u7f13\u5b58\u5931\u8d25\uff0c\u6709\u7528\u6237\u8bb8\u53ef\u5206\u7ec4\u8d85\u8fc7\u6700\u5927\u8bb8\u53ef\u6570\u91cf\u3002", (String)"LicenseUserRelEngine_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\uff0c\u8bb8\u53ef\u5206\u7ec4\u3010%s\u3011\u91cd\u5efa\u8bb8\u53ef\u5206\u7ec4\u7f13\u5b58\u65f6\u4f4d\u56fe\u4e2d\u7684\u8bb8\u53ef\u7528\u6237\u8d85\u8fc7\u4e86\u8bb8\u53ef\u603b\u6570\u3002totalCount\u3010%s\u3011\uff0cassignCount\u3010%s\u3011", accountId, groupId, total, assignCount), (Throwable)e);
            throw e;
        }
        return relBitMap;
    }

    private static Map<Long, RoaringBitmap> signature(List<LicUserRelBitDTO> relBits, Map<String, String> signMap, boolean isUpdating) {
        HashMap<Long, RoaringBitmap> result = new HashMap<Long, RoaringBitmap>(16);
        JSONObject data = LicenseUserRelEngine.generateSignature(signMap, isUpdating);
        String accountId = RequestContext.get().getAccountId();
        for (LicUserRelBitDTO dto : relBits) {
            String sign = data.getString(String.valueOf(dto.getGroupId()));
            if (StringUtils.isBlank((CharSequence)sign)) {
                KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u91cd\u5efa\u8bb8\u53ef\u5206\u7ec4\u7f13\u5b58\u65f6\u65e0\u6cd5\u83b7\u53d6\u7b7e\u540d\u4fe1\u606f\u3002", (String)"LicenseUserRelEngine_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\uff0c\u8bb8\u53ef\u5206\u7ec4\u3010%s\u3011\u91cd\u5efa\u8bb8\u53ef\u5206\u7ec4\u7f13\u5b58\u65f6\u65e0\u6cd5\u83b7\u53d6\u7b7e\u540d\u4fe1\u606f\u3002", accountId, dto.getGroupId()), (Throwable)e);
                throw e;
            }
            if (!sign.equals(dto.getSign())) {
                KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u6709\u8bb8\u53ef\u4fe1\u606f\u7b7e\u540d\u524d\u540e\u4e0d\u4e00\u81f4\uff0c\u9a8c\u7b7e\u5931\u8d25\u3002", (String)"LicenseUserRelEngine_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\uff0c\u8bb8\u53ef\u5206\u7ec4\u3010%s\u3011\u8bb8\u53ef\u4fe1\u606f\u7b7e\u540d\u524d\u540e\u4e0d\u4e00\u81f4\uff0c\u9a8c\u7b7e\u5931\u8d25\u3002", accountId, dto.getGroupId()), (Throwable)e);
                throw e;
            }
            result.put(dto.getGroupId(), dto.getBit());
        }
        LIC_USER_CACHE.removeType(LicenseCacheMrg.getUpdateLicByBitMapType());
        return result;
    }

    private static Map<Long, RoaringBitmap> getLicRelBitFromCache(Collection<Long> groupIds, String type, String accountId) {
        HashMap<Long, RoaringBitmap> bitMap = new HashMap<Long, RoaringBitmap>(groupIds.size());
        String[] keys = (String[])groupIds.stream().map(String::valueOf).toArray(String[]::new);
        List cacheValues = LIC_USER_CACHE.get(type, keys);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (StringUtils.equals((CharSequence)VERSION, (CharSequence)key)) continue;
            Long groupId = Long.valueOf(key);
            String value = (String)cacheValues.get(i);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            byte[] bytes = value.getBytes(StandardCharsets.ISO_8859_1);
            RoaringBitmap bit = LicenseUserRelEngine.desRoaringBitmapByteArr(bytes, accountId, groupId);
            bitMap.put(groupId, bit);
        }
        return bitMap;
    }

    private static void updateCache(Map<Long, RoaringBitmap> bitMap, String type) {
        HashMap<String, String> cacheData = new HashMap<String, String>(bitMap.size());
        for (Map.Entry<Long, RoaringBitmap> entry : bitMap.entrySet()) {
            byte[] bytes = LicenseUserRelEngine.serRoaringBitmap(entry.getValue());
            cacheData.put(String.valueOf(entry.getKey()), new String(bytes, StandardCharsets.ISO_8859_1));
        }
        cacheData.put(VERSION, DB.genStringId((String)""));
        LIC_USER_CACHE.put(type, cacheData, 365, TimeUnit.DAYS);
    }

    private static String getLicUnifiedLockKey(String accountId) {
        return String.format("lic_modify_%s", accountId);
    }

    public static void resetCurrAccountLicUserRelBit(Map<Long, List<Integer>> currAccountLicUserRelMap) {
        LicenseUserRelEngine.resetCurrAccountLicUserRelBit(currAccountLicUserRelMap, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCurrAccountLicUserRelBit(Map<Long, List<Integer>> currAccountLicUserRelMap, boolean isUpdating) {
        if (currAccountLicUserRelMap.isEmpty()) {
            logger.debug("LicenseUserRelEngine.resetCurrAccountLicUserRelBit. remove LicenseCacheMrg.getType4UserGroupBitMap()|LicenseCacheMrg.getCurrBitMapVersionType()");
            DB.execute((DBRoute)DBRoute.base, (String)DELETE_SQL);
            LIC_USER_CACHE.removeType(LicenseCacheMrg.getType4UserGroupBitMap());
            return;
        }
        List<LicUserRelInfo> userRelInfos = LicenseUserRelEngine.generateLicUserRelInfo(currAccountLicUserRelMap, isUpdating);
        String lockKey = LicenseUserRelEngine.getLicUnifiedLockKey(RequestContext.get().getAccountId());
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            Date now = TimeServiceHelper.now();
            ArrayList params = new ArrayList(userRelInfos.size());
            userRelInfos.forEach(e -> params.add(new Object[]{DB.genGlobalLongId(), ((LicUserRelInfo)e).groupId, ((LicUserRelInfo)e).bytes, ((LicUserRelInfo)e).sign, now}));
            try (TXHandle tx = TX.required((String)"save_or_update_lic_rel_bit_tx");){
                try {
                    DB.execute((DBRoute)DBRoute.base, (String)DELETE_SQL);
                    DB.executeBatch((DBRoute)DBRoute.base, (String)INSERT_SQL, params);
                    LIC_USER_CACHE.removeType(LicenseCacheMrg.getType4UserGroupBitMap());
                    logger.debug("LicenseUserRelEngine.resetCurrAccountLicUserRelBit. remove LicenseCacheMrg.getType4UserGroupBitMap()|LicenseCacheMrg.getCurrBitMapVersionType()");
                    LicenseUserRelEngine.rebuildCurrAccountLicRelBit(currAccountLicUserRelMap.keySet(), isUpdating);
                }
                catch (Exception e2) {
                    tx.markRollback();
                    logger.error("\u5b58\u50a8\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38", (Throwable)e2);
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u50a8\u8bb8\u53ef\u5173\u7cfb\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseUserRelEngine_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static List<LicUserRelInfo> generateLicUserRelInfo(Map<Long, List<Integer>> licUserRelMap, boolean isUpdating) {
        HashMap<String, String> signMap = new HashMap<String, String>(licUserRelMap.size());
        ArrayList<LicUserRelInfo> licUserRelInfos = new ArrayList<LicUserRelInfo>(licUserRelMap.size());
        for (Map.Entry<Long, List<Integer>> entry : licUserRelMap.entrySet()) {
            int[] userIndexes = entry.getValue().stream().mapToInt(v -> v).toArray();
            RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])userIndexes);
            bit.runOptimize();
            byte[] bytes = LicenseUserRelEngine.serRoaringBitmap(bit);
            licUserRelInfos.add(new LicUserRelInfo(entry.getKey(), bytes));
            String digest = Arrays.stream(bit.toArray()).mapToObj(String::valueOf).collect(Collectors.joining(""));
            signMap.put(String.valueOf(entry.getKey()), digest);
        }
        JSONObject data = LicenseUserRelEngine.generateSignature(signMap, isUpdating);
        for (LicUserRelInfo info : licUserRelInfos) {
            String sign = data.getString(String.valueOf(info.groupId));
            if (StringUtils.isBlank((CharSequence)sign)) {
                KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u5206\u7ec4\u52a0\u7b7e\u5931\u8d25\u3002", (String)"LicenseUserRelEngine_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\uff0c\u8bb8\u53ef\u5206\u7ec4\u3010%s\u3011\u9a8c\u7b7e\u5931\u8d25\uff1a", RequestContext.get().getAccountId(), info.groupId), (Throwable)e);
                throw e;
            }
            info.sign = sign;
        }
        return licUserRelInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLicUserGroup(Collection<Long> groupIds) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return;
        }
        List<LicUserRelInfo> userRelInfos = LicenseUserRelEngine.generateEmptyLicRelBits(groupIds, false);
        String lockKey = LicenseUserRelEngine.getLicUnifiedLockKey(RequestContext.get().getAccountId());
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            Date now = TimeServiceHelper.now();
            ArrayList params = new ArrayList(userRelInfos.size());
            userRelInfos.forEach(info -> params.add(new Object[]{((LicUserRelInfo)info).bytes, ((LicUserRelInfo)info).sign, now, ((LicUserRelInfo)info).groupId}));
            try (TXHandle tx = TX.required((String)"save_or_update_lic_rel_bit_tx");){
                try {
                    DB.executeBatch((DBRoute)DBRoute.base, (String)UPDATE_SQL, params);
                    String[] keys = (String[])groupIds.stream().map(String::valueOf).toArray(String[]::new);
                    LIC_USER_CACHE.remove(LicenseCacheMrg.getType4UserGroupBitMap(), keys);
                    LIC_USER_CACHE.put(LicenseCacheMrg.getType4UserGroupBitMap(), VERSION, DB.genStringId((String)""), 365, TimeUnit.DAYS);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("\u5b58\u50a8\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u50a8\u8bb8\u53ef\u5173\u7cfb\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseUserRelEngine_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static List<LicUserRelInfo> generateEmptyLicRelBits(Collection<Long> groupIds, boolean isUpdating) {
        HashMap<String, String> signMap = new HashMap<String, String>(groupIds.size());
        ArrayList<LicUserRelInfo> licUserRelInfos = new ArrayList<LicUserRelInfo>(groupIds.size());
        RoaringBitmap bit = new RoaringBitmap();
        bit.runOptimize();
        byte[] bytes = LicenseUserRelEngine.serRoaringBitmap(bit);
        for (Long groupId : groupIds) {
            licUserRelInfos.add(new LicUserRelInfo(groupId, bytes));
            signMap.put(String.valueOf(groupId), "");
        }
        JSONObject data = LicenseUserRelEngine.generateSignature(signMap, isUpdating);
        for (LicUserRelInfo info : licUserRelInfos) {
            String sign = data.getString(String.valueOf(info.groupId));
            if (StringUtils.isBlank((CharSequence)sign)) {
                KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u5206\u7ec4\u52a0\u7b7e\u5931\u8d25\u3002", (String)"LicenseUserRelEngine_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                logger.error(String.format("\u6e05\u9664\u8bb8\u53ef\u5206\u7ec4\u4fe1\u606f\u65f6\uff0c\u8bb8\u53ef\u5206\u7ec4\u3010%s\u3011\u52a0\u7b7e\u5931\u8d25\uff1a", info.groupId), (Throwable)e);
                throw e;
            }
            info.sign = sign;
        }
        return licUserRelInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> removeLicUserGroup(Map<Long, List<Integer>> licUserRelMap) {
        if (CollectionUtils.isEmpty(licUserRelMap)) {
            return Collections.emptyList();
        }
        String lockKey = LicenseUserRelEngine.getLicUnifiedLockKey(RequestContext.get().getAccountId());
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            Set<Long> groupIds = licUserRelMap.keySet();
            Map<Long, RoaringBitmap> relBitMap = LicenseUserRelEngine.getLicRelBitFromCurrAccount(groupIds);
            List<LicUserRelInfo> userRelInfos = LicenseUserRelEngine.serializeAndSignature(licUserRelMap, relBitMap, false, false);
            Date now = TimeServiceHelper.now();
            ArrayList<Long> successList = new ArrayList<Long>(licUserRelMap.size());
            ArrayList<Object[]> params = new ArrayList<Object[]>(licUserRelMap.size());
            Iterator<LicUserRelInfo> iterator = userRelInfos.iterator();
            while (iterator.hasNext()) {
                LicUserRelInfo relInfo = iterator.next();
                if (!StringUtils.isNotBlank((CharSequence)relInfo.sign)) continue;
                params.add(new Object[]{relInfo.bytes, relInfo.sign, now, relInfo.groupId});
                successList.add(relInfo.groupId);
                iterator.remove();
            }
            LicenseUserRelEngine.execute(licUserRelMap.keySet(), UPDATE_SQL, params);
            LicenseUserRelEngine.writeLicAssignLog(userRelInfos, licUserRelMap, now);
            ArrayList<Long> arrayList = successList;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    public static List<Long> addLicUserGroup(Map<Long, List<Integer>> licUserRelMap) {
        return LicenseUserRelEngine.addLicUserGroup(licUserRelMap, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> addLicUserGroup(Map<Long, List<Integer>> licUserRelMap, boolean isUpdating) {
        if (CollectionUtils.isEmpty(licUserRelMap)) {
            return Collections.emptyList();
        }
        String lockKey = LicenseUserRelEngine.getLicUnifiedLockKey(RequestContext.get().getAccountId());
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            Set<Long> groupIds = licUserRelMap.keySet();
            Map<Long, RoaringBitmap> relBitMap = LicenseUserRelEngine.getLicRelBitFromCurrAccount(groupIds);
            List<LicUserRelInfo> userRelInfos = LicenseUserRelEngine.serializeAndSignature(licUserRelMap, relBitMap, true, isUpdating);
            Set<Long> updateGroupIds = LicenseUserRelEngine.getGroupIdFromBitTable(groupIds);
            ArrayList<Object[]> insertParams = new ArrayList<Object[]>(licUserRelMap.size());
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>(licUserRelMap.size());
            Date now = TimeServiceHelper.now();
            ArrayList<Long> insertGroupIds = new ArrayList<Long>(10);
            ArrayList<Long> successList = new ArrayList<Long>(licUserRelMap.size());
            Iterator<LicUserRelInfo> iterator = userRelInfos.iterator();
            while (iterator.hasNext()) {
                LicUserRelInfo relInfo = iterator.next();
                if (StringUtils.isBlank((CharSequence)relInfo.sign)) continue;
                if (updateGroupIds.contains(relInfo.groupId)) {
                    updateParams.add(new Object[]{relInfo.bytes, relInfo.sign, now, relInfo.groupId});
                } else {
                    insertParams.add(new Object[]{DB.genGlobalLongId(), relInfo.groupId, relInfo.bytes, relInfo.sign, now});
                    insertGroupIds.add(relInfo.groupId);
                }
                successList.add(relInfo.groupId);
                iterator.remove();
            }
            LicenseUserRelEngine.execute(updateGroupIds, UPDATE_SQL, updateParams);
            LicenseUserRelEngine.execute(insertGroupIds, INSERT_SQL, insertParams);
            LicenseUserRelEngine.writeLicAssignLog(userRelInfos, licUserRelMap, now);
            ArrayList<Long> arrayList = successList;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    private static Set<Long> getGroupIdFromBitTable(Set<Long> groupIds) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fgroupid from T_LIC_GroupBitMap where", new Object[0]).appendIn(FIELD_GROUP_ID, groupIds.toArray());
        return (Set)DB.query((DBRoute)DBRoute.base, (SqlBuilder)builder, rs -> {
            HashSet<Long> result = new HashSet<Long>(10);
            while (rs.next()) {
                result.add(rs.getLong(FIELD_GROUP_ID));
            }
            return result;
        });
    }

    private static List<LicUserRelInfo> serializeAndSignature(Map<Long, List<Integer>> licUserRelMap, Map<Long, RoaringBitmap> relBitMap, boolean isAdd, boolean isUpdating) {
        HashMap<String, String> signMap = new HashMap<String, String>(licUserRelMap.size());
        ArrayList<LicUserRelInfo> licUserRelInfos = new ArrayList<LicUserRelInfo>(licUserRelMap.size());
        for (Map.Entry<Long, List<Integer>> entry : licUserRelMap.entrySet()) {
            int[] userIndexes = entry.getValue().stream().mapToInt(v -> v).toArray();
            Long groupId = entry.getKey();
            RoaringBitmap bitmap = relBitMap.get(groupId);
            if (isAdd) {
                bitmap.add(userIndexes);
            } else {
                RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])userIndexes);
                bit.runOptimize();
                bitmap.andNot(bit);
            }
            bitmap.runOptimize();
            byte[] bytes = LicenseUserRelEngine.serRoaringBitmap(bitmap);
            licUserRelInfos.add(new LicUserRelInfo(groupId, bytes));
            String digest = Arrays.stream(bitmap.toArray()).mapToObj(String::valueOf).collect(Collectors.joining(""));
            signMap.put(String.valueOf(groupId), digest);
        }
        JSONObject data = LicenseUserRelEngine.generateSignature(signMap, isUpdating);
        licUserRelInfos.forEach(relInfo -> ((LicUserRelInfo)relInfo).sign = data.getString(String.valueOf(((LicUserRelInfo)relInfo).groupId)));
        return licUserRelInfos;
    }

    private static JSONObject generateSignature(Map<String, String> signMap, String tenantId, String accountId) {
        JSONObject signJson = PermissionServiceHelper.generateSignature(signMap, (String)tenantId, (String)accountId);
        if (Boolean.TRUE.equals(signJson.getBoolean(SIGN_PROP_SUCCESS))) {
            if (signJson.containsKey((Object)SIGN_PROP_DATA)) {
                return signJson;
            }
            KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u7b7e\u540d\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"LicenseUserRelEngine_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\u8bb8\u53ef\u7b7e\u540d\u6570\u636eDATA\u4e0d\u5b58\u5728...", accountId), (Throwable)e);
            throw e;
        }
        String msg = signJson.getString(SIGN_PROP_DES);
        KDBizException e = StringUtils.isBlank((CharSequence)msg) ? new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u52a0\u7b7e\u529f\u80fd\u672a\u5b9e\u73b0\u3002", (String)"LicenseUserRelEngine_7", (String)SYSTEM_TYPE, (Object[])new Object[0])) : new KDBizException(msg);
        logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\u8bb8\u53ef\u52a0\u7b7e\u5931\u8d25...", accountId), (Throwable)e);
        throw e;
    }

    /*
     * Unable to fully structure code
     */
    private static JSONObject generateSignature(Map<String, String> signMap, boolean isUpdating) {
        signJson = null;
        if (isUpdating) {
            sql = "select fid from t_perm_encryptionscheme where fnumber = 'LICENCE-SIGNATURE' ";
            data = DB.queryDataSet((String)"queryLicenseScheme", (DBRoute)DBRoute.base, (String)sql);
            var5_5 = null;
            try {
                if (data == null || data.isEmpty()) ** GOTO lbl26
                schemeId = data.next().getLong("fid");
                signJson = PermissionServiceHelper.generateSignature(signMap, (long)schemeId);
            }
            catch (Throwable var6_8) {
                var5_5 = var6_8;
                throw var6_8;
            }
            finally {
                if (data != null) {
                    if (var5_5 != null) {
                        try {
                            data.close();
                        }
                        catch (Throwable var6_7) {
                            var5_5.addSuppressed(var6_7);
                        }
                    } else {
                        data.close();
                    }
                }
            }
        } else {
            signJson = PermissionServiceHelper.generateSignature(signMap, (String)"LICENCE-SIGNATURE");
        }
lbl26:
        // 3 sources

        if (null == signJson) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u52a0\u7b7e\u529f\u80fd\u672a\u5b9e\u73b0\u3002", (String)"LicenseUserRelEngine_7", (String)"bos-license-business", (Object[])new Object[0]));
        }
        accountId = RequestContext.get().getAccountId();
        if (signJson.getBooleanValue("success")) {
            data = signJson.getJSONObject("data");
            if (Objects.nonNull(data)) {
                return data;
            }
            e = new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u7b7e\u540d\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"LicenseUserRelEngine_8", (String)"bos-license-business", (Object[])new Object[0]));
            LicenseUserRelEngine.logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\u8bb8\u53ef\u7b7e\u540d\u6570\u636eDATA\u4e0d\u5b58\u5728...", new Object[]{accountId}), (Throwable)e);
            throw e;
        }
        msg = signJson.getString("description");
        e = StringUtils.isBlank((CharSequence)msg) != false ? new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u52a0\u7b7e\u529f\u80fd\u672a\u5b9e\u73b0\u3002", (String)"LicenseUserRelEngine_7", (String)"bos-license-business", (Object[])new Object[0])) : new KDBizException(msg);
        LicenseUserRelEngine.logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\u8bb8\u53ef\u52a0\u7b7e\u5931\u8d25...", new Object[]{accountId}), (Throwable)e);
        throw e;
    }

    private static void writeLicAssignLog(List<LicUserRelInfo> licUserRelInfos, Map<Long, List<Integer>> licUserRelMap, Date now) {
        if (CollectionUtils.isEmpty(licUserRelInfos)) {
            return;
        }
        ArrayList<Integer> userIndexes = new ArrayList<Integer>(10);
        licUserRelInfos.forEach(e -> userIndexes.addAll((Collection)licUserRelMap.get(((LicUserRelInfo)e).groupId)));
        Map<Integer, Long> indexIdMap = LicenseUserRelEngine.getUserIdByIndexes(userIndexes);
        Long loginUserId = RequestContext.get().getCurrUserId();
        String msg = ResManager.loadKDString((String)"\u8bb8\u53ef\u5206\u7ec4\u52a0\u7b7e\u5931\u8d25\u3002", (String)"LicenseUserRelEngine_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        ArrayList<LicenseAssignLog> licenseAssignLogs = new ArrayList<LicenseAssignLog>(16);
        ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        for (LicUserRelInfo info : licUserRelInfos) {
            List<Integer> indexes = licUserRelMap.get(info.groupId);
            if (CollectionUtils.isEmpty(indexes)) continue;
            for (Integer index : indexes) {
                licenseAssignLogs.add(new LicenseAssignLog(now, loginUserId, indexIdMap.get(index), msg, 4, 1, info.groupId, false));
            }
            if (licenseAssignLogs.size() < 10000) continue;
            service.addAssignLogs(licenseAssignLogs);
            licenseAssignLogs.clear();
        }
        if (!licenseAssignLogs.isEmpty()) {
            service.addAssignLogs(licenseAssignLogs);
        }
    }

    private static void execute(Collection<Long> groupIds, String sql, List<Object[]> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        try (TXHandle tx = TX.required((String)"save_or_update_lic_rel_bit_tx");){
            try {
                DB.executeBatch((DBRoute)DBRoute.base, (String)sql, params);
                String type = LicenseCacheMrg.getType4UserGroupBitMap();
                String[] keys = (String[])groupIds.stream().map(String::valueOf).toArray(String[]::new);
                LIC_USER_CACHE.remove(type, keys);
                LicenseUserRelEngine.rebuildCurrAccountLicRelBit(new HashSet<Long>(groupIds));
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u5b58\u50a8\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u50a8\u8bb8\u53ef\u5173\u7cfb\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseUserRelEngine_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
    }

    private static Map<Integer, Long> getUserIdByIndexes(List<Integer> userIndexes) {
        if (CollectionUtils.isEmpty(userIndexes)) {
            return Collections.emptyMap();
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid, FBitMapIndex from t_lic_userbitmapindex where", new Object[0]);
        builder.appendIn("FBitMapIndex", userIndexes.toArray());
        return (Map)DB.query((DBRoute)DBRoute.base, (SqlBuilder)builder, rs -> {
            HashMap<Integer, Long> userMap = new HashMap<Integer, Long>(16);
            while (rs.next()) {
                userMap.put(rs.getInt("FBitMapIndex"), rs.getLong("fid"));
            }
            return userMap;
        });
    }

    /*
     * Exception decompiling
     */
    public static byte[] serRoaringBitmap(RoaringBitmap bitmap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static RoaringBitmap desRoaringBitmapByteArr(byte[] bytes, String accountId, Long groupId) {
        RoaringBitmap bit;
        Kryo kryo = (Kryo)KRYO_POOL.obtain();
        try (Input input = new Input();){
            if (bytes != null) {
                input.setBuffer(bytes);
            }
            bit = (RoaringBitmap)kryo.readObjectOrNull(input, RoaringBitmap.class);
        }
        catch (Exception e) {
            logger.error("\u53cd\u5e8f\u5217\u5316RoaringBitmap\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5e8f\u5217\u5316\u7528\u6237\u8bb8\u53ef\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseUserRelEngine_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        finally {
            KRYO_POOL.free((Object)kryo);
        }
        if (null == bit) {
            KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u53cd\u5e8f\u5217\u5316\u7528\u6237\u8bb8\u53ef\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseUserRelEngine_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            logger.error(String.format("bit\u4e3anull\uff0c\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\uff0c\u8bb8\u53ef\u5206\u7ec4\u3010%s\u3011\uff0c\u53cd\u5e8f\u5217\u5316\u8bb8\u53ef\u5931\u8d25\uff1a", accountId, groupId), (Throwable)e);
            throw e;
        }
        bit.runOptimize();
        return bit;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getMaxUserBitMapIndex() {
        int maxIndex = 0;
        String tenantId = RequestContext.get().getTenantId();
        List accounts = AccountUtils.getAllAccounts((String)tenantId);
        Iterator iterator = accounts.iterator();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
            }
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                conn = MCDBUtil.getConnection((Account)account, (Properties)dataBaseProperties);
                String sql = "select MAX(fbitmapindex) bitmapindex from t_lic_userbitmapindex";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    int bitmapindex = rs.getInt("bitmapindex");
                    maxIndex = Integer.max(maxIndex, bitmapindex);
                }
            }
            catch (SQLException sqlExp) {
                try {
                    logger.error((Throwable)sqlExp);
                    throw new KDException((Throwable)sqlExp, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + sqlExp.getMessage()});
                    catch (Exception exp) {
                        logger.error((Throwable)exp);
                        throw new KDException((Throwable)exp, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + exp.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        return maxIndex;
    }

    @Deprecated
    public static Map<String, Integer> getUserBitMapIndex(List<String> characteristics) {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Integer> getUserBitMapIndex(Set<Long> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(userIds.size());
        HashSet<Long> last = new HashSet<Long>(userIds);
        HashSet<Long> userBitmapIndex4del = new HashSet<Long>(userIds.size());
        Map userIndexListBySet = UserIndexUtil.getUserIndexListBySet(userIds);
        for (UserIndex userIndex : userIndexListBySet.values()) {
            Long userId = userIndex.getUserId();
            if (!userIndex.isValidData()) {
                userBitmapIndex4del.add(userId);
                continue;
            }
            last.remove(userId);
            result.put(userId, userIndex.getIndex());
        }
        if (!userBitmapIndex4del.isEmpty()) {
            DeleteServiceHelper.delete((String)"lic_userbitmapindex", (QFilter[])new QFilter("id", "in", userBitmapIndex4del).toArray());
            userBitmapIndex4del.clear();
        }
        if (last.isEmpty()) {
            return result;
        }
        try (TXHandle h = TX.requiresNew((String)"getUserBitMapIndex");
             DLock dlock = DLock.createReentrant((String)"lic_getUserBitMapIndex");){
            dlock.lock();
            userIndexListBySet = UserIndexUtil.getUserIndexListBySet(last);
            for (UserIndex userIndex : userIndexListBySet.values()) {
                Long userId = userIndex.getUserId();
                if (!userIndex.isValidData()) {
                    userBitmapIndex4del.add(userId);
                    continue;
                }
                last.remove(userId);
                result.put(userId, userIndex.getIndex());
            }
            if (!userBitmapIndex4del.isEmpty()) {
                DeleteServiceHelper.delete((String)"lic_userbitmapindex", (QFilter[])new QFilter("id", "in", userBitmapIndex4del).toArray());
            }
            if (last.isEmpty()) {
                HashMap<Long, Integer> hashMap = result;
                return hashMap;
            }
            Set<Integer> allBitMapIndex = LicenseUserRelEngine.getAllBitMapIndex();
            String curAccountId = RequestContext.get().getAccountId();
            HashMap<Long, Integer> tempResult = new HashMap<Long, Integer>(last.size());
            List userListBySet = UserUtil.getUserListBySet(last);
            HashMap<Object, Long> characteristicIdMap = new HashMap<Object, Long>(userListBySet.size());
            Map uniqueCharacteristic = LicenseUtil.getUniqueCharacteristic();
            String fieldNum = (String)uniqueCharacteristic.get("fieldNum");
            String field = (String)uniqueCharacteristic.get("field");
            for (User user : userListBySet) {
                String characteristic = user.getFieldNumData(fieldNum);
                if (StringUtils.isBlank((CharSequence)characteristic)) continue;
                characteristicIdMap.put(characteristic, user.getUserId());
            }
            String tenantId = RequestContext.get().getTenantId();
            List accounts = AccountUtils.getAllAccounts((String)tenantId);
            for (Object account : accounts) {
                String string = account.getAccountId();
                if (string.equals(curAccountId)) continue;
                Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account);
                if (dataBaseProperties == null) {
                    logger.error(ErrorCodeUtils.getDBIntralError());
                    throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
                }
                Connection conn = null;
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    conn = MCDBUtil.getConnection((Account)account, (Properties)dataBaseProperties);
                    String sql = "select tlu.fbitmapindex fbitmapindex, tsu.fphone fphone, tsu.femail femail, tsuu.fusername fusername from t_lic_userbitmapindex tlu inner join t_sec_user tsu on tsu.fid = tlu.fid inner join t_sec_user_u tsuu on tsuu.fid = tsu.fid where tsu.fenable = '1' and tsuu.fisforbidden = '0'";
                    pstmt = conn.prepareStatement(sql);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Long userIdInCurAccount;
                        Integer temp;
                        String fieldVal = rs.getString(field);
                        int bitmapIndex = rs.getInt("fbitmapindex");
                        if (!characteristicIdMap.containsKey(fieldVal) || allBitMapIndex.contains(bitmapIndex) || (temp = (Integer)tempResult.get(userIdInCurAccount = (Long)characteristicIdMap.get(fieldVal))) != null && temp >= bitmapIndex) continue;
                        tempResult.put(userIdInCurAccount, bitmapIndex);
                        last.remove(userIdInCurAccount);
                    }
                }
                catch (Exception exp) {
                    try {
                        logger.error((Throwable)exp);
                        throw new KDException((Throwable)exp, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + exp.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            }
            if (!tempResult.isEmpty()) {
                result.putAll(tempResult);
            }
            if (!last.isEmpty()) {
                int maxUserBitMapIndex = LicenseCache.getMaxUserBitMapIndex();
                LicenseCache.IncrStepMaxUserBitMapIndex(last.size());
                for (Object e : last) {
                    result.put((Long)e, ++maxUserBitMapIndex);
                    tempResult.put((Long)e, maxUserBitMapIndex);
                }
            }
            if (!tempResult.isEmpty()) {
                ArrayList<DynamicObject> userBitmapIndexs = new ArrayList<DynamicObject>(tempResult.size());
                int orm_maxobjects = LicenseUtil.getOrmMaxObjectsCount();
                boolean bl = false;
                for (Map.Entry entry : tempResult.entrySet()) {
                    if ((n += 1) == orm_maxobjects) {
                        int n = 0;
                        SaveServiceHelper.save((DynamicObject[])userBitmapIndexs.toArray(new DynamicObject[0]));
                        userBitmapIndexs = new ArrayList(orm_maxobjects);
                    }
                    DynamicObject userbitmapindex = BusinessDataServiceHelper.newDynamicObject((String)"lic_userbitmapindex");
                    Long userId = (Long)entry.getKey();
                    Integer bitmapIndex = (Integer)entry.getValue();
                    userbitmapindex.set("id", (Object)userId);
                    userbitmapindex.set("bitmapindex", (Object)bitmapIndex);
                    userbitmapindex.set("ciphertext", (Object)Encrypters.encode((String)(userId + "_" + bitmapIndex)));
                    userBitmapIndexs.add(userbitmapindex);
                }
                SaveServiceHelper.save((DynamicObject[])userBitmapIndexs.toArray(new DynamicObject[0]));
            }
        }
        return result;
    }

    private static Set<Integer> getAllBitMapIndex() {
        return (Set)DB.query((DBRoute)DBRoute.base, (String)"select fbitmapindex from t_lic_userbitmapindex", rs -> {
            HashSet<Integer> result = new HashSet<Integer>(10240);
            while (rs.next()) {
                result.add(rs.getInt("fbitmapindex"));
            }
            return result;
        });
    }

    private static final class LicUserRelInfo {
        private Long groupId;
        private byte[] bytes;
        private String sign;

        private LicUserRelInfo(Long groupId, byte[] bytes) {
            this.groupId = groupId;
            this.bytes = bytes;
        }
    }
}

