/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.license.util.LicenseUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import org.roaringbitmap.RoaringBitmap;

public class LicenseBitMapLocalCache {
    static Log logger = LogFactory.getLog(LicenseBitMapLocalCache.class);
    private static final CacheConfigInfo info = new CacheConfigInfo();
    private static final String REGION = "LicenseBitMapLocalCache";
    private static final String VERSION_LICENSEBITMAP = "VERSION_LICENSEBITMAP";
    private static final String BITMAP = "LICENSE_BITMAP";

    public static void clear() {
        LicenseBitMapLocalCache.getLocalCache().clear();
    }

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, RequestContext.get().getAccountId(), info);
    }

    public static String getVersion() {
        return (String)LicenseBitMapLocalCache.getLocalCache().get(VERSION_LICENSEBITMAP + RequestContext.get().getAccountId());
    }

    public static void putVersion(String version) {
        if (null == version) {
            return;
        }
        LicenseBitMapLocalCache.getLocalCache().put(VERSION_LICENSEBITMAP + RequestContext.get().getAccountId(), (Object)version);
    }

    public static void putAllBitMap(Map<String, RoaringBitmap> bitMap) {
        LicenseBitMapLocalCache.getLocalCache().put(BITMAP + RequestContext.get().getAccountId(), bitMap);
    }

    public static void putBitMap(Map<String, RoaringBitmap> bitMap) {
        Map<String, RoaringBitmap> allBitMap = LicenseBitMapLocalCache.getAllBitMap();
        if (null == allBitMap) {
            allBitMap = new HashMap<String, RoaringBitmap>(16);
        }
        allBitMap.putAll(bitMap);
        LicenseBitMapLocalCache.putAllBitMap(allBitMap);
    }

    public static Map<String, RoaringBitmap> getAllBitMap() {
        return (Map)LicenseBitMapLocalCache.getLocalCache().get(BITMAP + RequestContext.get().getAccountId());
    }

    public static List<RoaringBitmap> getBitMap(List<String> groupIds) {
        Map<String, RoaringBitmap> allBitMap = LicenseBitMapLocalCache.getAllBitMap();
        if (CollectionUtils.isEmpty(allBitMap)) {
            return Collections.emptyList();
        }
        ArrayList<RoaringBitmap> result = new ArrayList<RoaringBitmap>(groupIds.size());
        for (String groupId : groupIds) {
            result.add(allBitMap.get(groupId));
        }
        return result;
    }

    static {
        info.setTimeout(LicenseUtil.getLicenseLocalCacheTimeOut());
        info.setMaxItemSize(10000);
    }
}

