/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service.cache;

import java.util.Locale;
import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.license.pojo.gray.GrayFeatScheApp;
import kd.bos.license.pojo.gray.GrayFeatScheCld;
import kd.bos.license.pojo.gray.GrayFeatScheObj;
import kd.bos.license.pojo.gray.GrayFeature;
import kd.bos.license.util.LicenseUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LicenseGrayLocalCache {
    static Log logger = LogFactory.getLog(LicenseGrayLocalCache.class);
    private static final CacheConfigInfo info = new CacheConfigInfo();
    private static final String REGION = "grayLicense";

    public static void clear() {
        LicenseGrayLocalCache.getLocalCache().clear();
    }

    private static String getLocalKey(@NotNull String key) {
        if (key.matches("[a-zA-Z]+")) {
            return key.toLowerCase(Locale.ENGLISH);
        }
        return key;
    }

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, RequestContext.get().getAccountId(), info);
    }

    public static Boolean isImportedGrayLic() {
        return (Boolean)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("licenseGrayIsImport"));
    }

    public static void setImportedGrayLic(boolean isImported) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("licenseGrayIsImport"), (Object)isImported);
    }

    public static void clearImportedGrayLicLocCache() {
        LicenseGrayLocalCache.getLocalCache().remove(new String[]{LicenseGrayLocalCache.getLocalKey("licenseGrayIsImport")});
    }

    public static Boolean isGrayLicExpiringSoon() {
        return (Boolean)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("licenseGrayExpiringSoon"));
    }

    public static void clearIsGrayLicExpiringSoonLocCache() {
        LicenseGrayLocalCache.getLocalCache().remove(new String[]{LicenseGrayLocalCache.getLocalKey("licenseGrayExpiringSoon")});
    }

    public static void setGrayLicExpiringSoon(boolean isExpiring) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("licenseGrayExpiringSoon"), (Object)isExpiring);
    }

    public static Map<String, Object> getLicenseGrayRemind() {
        return (Map)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("licenseGrayRemind"));
    }

    public static void replaceRemindGrayLic(@NotNull Map<String, Object> licenseGrayRemind) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("licenseGrayRemind"), licenseGrayRemind);
    }

    public static Map<String, GrayFeatScheCld> getGrayFeatScheCld() {
        return (Map)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("GrayFeatScheCld"));
    }

    public static void putGrayFeatScheCld(Map<String, GrayFeatScheCld> cloudId2GrayFeatScheCld) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("GrayFeatScheCld"), cloudId2GrayFeatScheCld);
    }

    public static Map<String, Map<String, String>> getAllGrayCloudLabelInfo() {
        return (Map)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("GrayCloudLabelInfo"));
    }

    public static void putAllGrayCloudLabelInfo(Map<String, Map<String, String>> cloud2GrayCloudLabelInfo) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("GrayCloudLabelInfo"), cloud2GrayCloudLabelInfo);
    }

    public static void removeAllGrayCloudInfo() {
        LicenseGrayLocalCache.getLocalCache().remove(new String[]{LicenseGrayLocalCache.getLocalKey("GrayFeatScheCld")});
        LicenseGrayLocalCache.getLocalCache().remove(new String[]{LicenseGrayLocalCache.getLocalKey("GrayCloudLabelInfo")});
    }

    public static Map<String, GrayFeatScheApp> getGrayFeatScheApp() {
        return (Map)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("GrayFeatScheApp"));
    }

    public static void putGrayFeatScheApp(Map<String, GrayFeatScheApp> appNumber2GrayFeatScheApp) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("GrayFeatScheApp"), appNumber2GrayFeatScheApp);
    }

    public static Map<String, Map<String, String>> getAllGrayAppLabelInfo() {
        return (Map)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("GrayAppLabelInfo"));
    }

    public static void putAllGrayAppLabelInfo(Map<String, Map<String, String>> appNumber2GrayAppLabelInfo) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("GrayAppLabelInfo"), appNumber2GrayAppLabelInfo);
    }

    public static void removeAllGrayAppInfo() {
        LicenseGrayLocalCache.getLocalCache().remove(new String[]{LicenseGrayLocalCache.getLocalKey("GrayFeatScheApp")});
        LicenseGrayLocalCache.getLocalCache().remove(new String[]{LicenseGrayLocalCache.getLocalKey("GrayAppLabelInfo")});
        LicenseGrayLocalCache.getLocalCache().remove(new String[]{LicenseGrayLocalCache.getLocalKey("GrayFeatureSchemeApp")});
    }

    public static Map<String, GrayFeatScheObj> getGrayFeatScheObj() {
        return (Map)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("GrayFeatScheObj"));
    }

    public static void putGrayFeatScheObj(Map<String, GrayFeatScheObj> obj2GrayFeatScheObj) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("GrayFeatScheObj"), obj2GrayFeatScheObj);
    }

    public static Map<String, Map<String, Map<String, String>>> getAllGrayObjectLabelInfo() {
        return (Map)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("GrayObjectLabelInfo"));
    }

    public static void putAllGrayObjectLabelInfo(Map<String, Map<String, Map<String, String>>> appNumber2ObjectNumber2LabelInfo) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("GrayObjectLabelInfo"), appNumber2ObjectNumber2LabelInfo);
    }

    public static void removeAllGrayObjectInfo() {
        LicenseGrayLocalCache.getLocalCache().remove(new String[]{LicenseGrayLocalCache.getLocalKey("GrayFeatScheObj")});
        LicenseGrayLocalCache.getLocalCache().remove(new String[]{LicenseGrayLocalCache.getLocalKey("GrayObjectLabelInfo")});
        LicenseGrayLocalCache.getLocalCache().remove(new String[]{LicenseGrayLocalCache.getLocalKey("GrayFeatureSchemeObj")});
    }

    public static void putGrayFeature(Map<String, GrayFeature> number2GrayFeature) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("GrayFeature"), number2GrayFeature);
    }

    public static Map<String, GrayFeature> getGrayFeature() {
        return (Map)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("GrayFeature"));
    }

    public static void removeGrayFeature() {
        LicenseGrayLocalCache.getLocalCache().remove(new String[]{LicenseGrayLocalCache.getLocalKey("GrayFeature")});
    }

    public static void putGrayFeatureSchemeApp(Map<String, GrayFeatScheApp> appNumber2GrayFeattureSchemeApp) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("GrayFeatureSchemeApp"), appNumber2GrayFeattureSchemeApp);
    }

    public static Map<String, GrayFeatScheApp> getGrayFeatureSchemeApp() {
        return (Map)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("GrayFeatureSchemeApp"));
    }

    public static Map<String, GrayFeatScheObj> getGrayFeatureSchemeObj() {
        return (Map)LicenseGrayLocalCache.getLocalCache().get(LicenseGrayLocalCache.getLocalKey("GrayFeatureSchemeObj"));
    }

    public static void putGrayFeatureSchemeObj(Map<String, GrayFeatScheObj> obj2GrayFeatureSchemeObj) {
        LicenseGrayLocalCache.getLocalCache().put(LicenseGrayLocalCache.getLocalKey("GrayFeatureSchemeObj"), obj2GrayFeatureSchemeObj);
    }

    static {
        info.setTimeout(LicenseUtil.getLicenseLocalCacheTimeOut());
        info.setMaxItemSize(10000);
    }
}

