/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.license.LocalCache.LicGroupRuntimeLocalCache;
import kd.bos.license.UpdateLicGroupUser;
import kd.bos.license.bean.LicGroupRuntime;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.bean.RangeDate;
import kd.bos.license.config.AESUtil;
import kd.bos.license.pojo.LicenseDetailSnapshot;
import kd.bos.license.pojo.LicenseGeneralSnapshot;
import kd.bos.license.pojo.LicenseSnapshot;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class LicGroupRuntimeUtil {
    private static Log logger = LogFactory.getLog(LicGroupRuntimeUtil.class);
    private static final String VERSION = "version";
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"LIC_GROUP_RUNTIME_POOL", (int)5);
    private static final String ENTITY_SNAPSHOT = "lic_snapshot";

    public static Map<String, LicGroupRuntime> getAllGroupRumtimeInfos() {
        if (LicenseCache.isCircuitBreaker("group")) {
            return Collections.emptyMap();
        }
        return LicGroupRuntimeUtil.getGroupRuntimeInfos();
    }

    public static Map<String, LicGroupRuntime> getGroupRumtimeInfosById(Collection<String> groupIds) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return Collections.emptyMap();
        }
        if (LicenseCache.isCircuitBreaker("group")) {
            return Collections.emptyMap();
        }
        Map<String, LicGroupRuntime> groupRuntimeInfos = LicGroupRuntimeUtil.getGroupRuntimeInfos();
        if (CollectionUtils.isEmpty(groupRuntimeInfos)) {
            return Collections.emptyMap();
        }
        HashMap<String, LicGroupRuntime> result = new HashMap<String, LicGroupRuntime>(groupIds.size());
        for (Map.Entry<String, LicGroupRuntime> info : groupRuntimeInfos.entrySet()) {
            String groupId = info.getKey();
            if (!groupIds.contains(groupId)) continue;
            result.put(groupId, info.getValue());
        }
        return result;
    }

    private static Map<String, LicGroupRuntime> getGroupRuntimeInfos() {
        String versionFromRedisCache = LicGroupRuntimeUtil.getVersionFromRedisCache();
        String verisonFromLocalCache = LicGroupRuntimeUtil.getVerisonFromLocalCache();
        boolean equalsVersion = StringUtils.equals((CharSequence)versionFromRedisCache, (CharSequence)verisonFromLocalCache);
        if (null == versionFromRedisCache || null == verisonFromLocalCache || !equalsVersion) {
            logger.info("LicGroupRuntimeUtil.getGroupRuntimeInfos. versionFromRedisCache : " + versionFromRedisCache + "verisonFromLocalCache : " + verisonFromLocalCache);
        }
        if (equalsVersion) {
            Map<String, LicGroupRuntime> groupRuntimeFromLocalCache = LicGroupRuntimeUtil.getGroupRuntimeFromLocalCache();
            if (null == groupRuntimeFromLocalCache) {
                logger.info("LicGroupRuntimeUtil.getGroupRuntimeInfos. local is blank.");
                Map<String, String> groupRuntimeFromRedisCache = LicGroupRuntimeUtil.getGroupRuntimeFromRedisCache();
                if (CollectionUtils.isEmpty(groupRuntimeFromRedisCache)) {
                    logger.info("LicGroupRuntimeUtil.getGroupRuntimeInfos. redis is blank.");
                    return LicGroupRuntimeUtil.reloadRedisCache(null);
                }
                return LicGroupRuntimeUtil.replaceLocalCache(groupRuntimeFromRedisCache);
            }
            return groupRuntimeFromLocalCache;
        }
        Map<String, String> groupRuntimeFromRedisCache = LicGroupRuntimeUtil.getGroupRuntimeFromRedisCache();
        if (CollectionUtils.isEmpty(groupRuntimeFromRedisCache)) {
            logger.info("LicGroupRuntimeUtil.getGroupRuntimeInfos. redis is blank.");
            Map<String, LicGroupRuntime> groupRuntimeFromLocalCache = LicGroupRuntimeUtil.getGroupRuntimeFromLocalCache();
            if (null == groupRuntimeFromLocalCache) {
                logger.info("LicGroupRuntimeUtil.getGroupRuntimeInfos. local is blank.");
                return LicGroupRuntimeUtil.reloadRedisCache(null);
            }
            logger.info("LicGroupRuntimeUtil.getGroupRuntimeInfos. reloadRedisCacheTask.");
            THREAD_POOL.submit(LicGroupRuntimeUtil.reloadRedisCacheTask(), RequestContext.get());
            return groupRuntimeFromLocalCache;
        }
        return LicGroupRuntimeUtil.replaceLocalCache(groupRuntimeFromRedisCache);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Map<String, LicGroupRuntime> reloadRedisCache(String data) {
        logger.info("LicGroupRuntimeUtil.reloadRedisCache start.");
        HashMap<String, LicGroupRuntime> result = new HashMap<String, LicGroupRuntime>(16);
        HashMap<String, String> redisResult = new HashMap<String, String>(16);
        try (DLock dlock = DLock.createReentrant((String)("reloadGroupRuntimeRedisCache" + RequestContext.get().getAccountId()));){
            dlock.lock();
            logger.debug("LicGroupRuntimeUtil.reloadRedisCache get lock.");
            String versionFromRedisCache = LicGroupRuntimeUtil.getVersionFromRedisCache();
            boolean isBlankData = StringUtils.isBlank((CharSequence)data);
            logger.debug("LicGroupRuntimeUtil.reloadRedisCache versionFromRedisCache : " + versionFromRedisCache + ",isBlankData: " + isBlankData);
            if (!StringUtils.isBlank((CharSequence)versionFromRedisCache) && isBlankData) {
                Map<String, LicGroupRuntime> map = LicGroupRuntimeUtil.getGroupRuntimeFromLocalCache();
                return map;
            }
            Map allGroupIdAndNumber = LicenseGroupUtil.getAllGroupIdAndNumber();
            if (CollectionUtils.isEmpty((Map)allGroupIdAndNumber)) {
                Map map = Collections.EMPTY_MAP;
                return map;
            }
            if (isBlankData) {
                DynamicObjectCollection snapshotDoc = QueryServiceHelper.query((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
                if (null == snapshotDoc || snapshotDoc.isEmpty()) {
                    LicenseSyncLog licenseSyncLog = new LicenseSyncLog();
                    LicGroupRuntimeUtil.downloadAndUpdateLic(true, licenseSyncLog);
                    snapshotDoc = QueryServiceHelper.query((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
                }
                snapshotDoc.sort((o1, o2) -> {
                    int type1 = Integer.parseInt(o1.getString("snapshottype"));
                    int type2 = Integer.parseInt(o2.getString("snapshottype"));
                    return type1 - type2;
                });
                data = ((DynamicObject)snapshotDoc.get(snapshotDoc.size() - 1)).getString("data");
            }
            String snapshotStr = AESUtil.decrypt((String)data);
            LicenseGeneralSnapshot snapshot = null;
            try {
                snapshot = (LicenseGeneralSnapshot)SerializationUtils.fromJsonString((String)snapshotStr, LicenseGeneralSnapshot.class);
            }
            catch (Exception e) {
                snapshot = (LicenseGeneralSnapshot)JSON.parseObject((String)snapshotStr, LicenseGeneralSnapshot.class);
            }
            if (null == snapshot) {
                throw new KDException("LicGroupRuntimeUtil.reloadRedisCache\uff1aLicenseSnapshots is Empty.");
            }
            ArrayList licenseSnapshots = snapshot.getLicenseSnapshots();
            if (licenseSnapshots == null) {
                licenseSnapshots = new ArrayList(16);
            }
            for (LicenseSnapshot licenseSnapshot : licenseSnapshots) {
                Date licActivedate = licenseSnapshot.getActivedate();
                Date licExpdate = licenseSnapshot.getExpdate();
                List detailSnapshotList = licenseSnapshot.getDetailSnapshotList();
                if (CollectionUtils.isEmpty((Collection)detailSnapshotList)) continue;
                for (LicenseDetailSnapshot licenseDetailSnapshot : detailSnapshotList) {
                    long groupId = licenseDetailSnapshot.getGroupId();
                    String groupNumber = (String)allGroupIdAndNumber.get(groupId);
                    if (StringUtils.isBlank((CharSequence)groupNumber)) continue;
                    int totalcount = licenseDetailSnapshot.getTotalcount();
                    Date groupBegindate = licenseDetailSnapshot.getBegindate();
                    Date groupEnddate = licenseDetailSnapshot.getEnddate();
                    String groupStr = String.valueOf(groupId);
                    ArrayList<RangeDate> rangeDates = new ArrayList<RangeDate>(1);
                    rangeDates.add(new RangeDate(groupBegindate, groupEnddate));
                    LicGroupRuntime licGroupRuntime = new LicGroupRuntime(Long.valueOf(groupId), groupNumber, totalcount, rangeDates, licActivedate, licExpdate);
                    redisResult.put(groupStr, SerializationUtils.toJsonString((Object)licGroupRuntime));
                    result.put(groupStr, licGroupRuntime);
                }
            }
            String version = DB.genStringId((String)"");
            redisResult.put(VERSION, version);
            LicenseCacheMrg.clearCache((String)LicenseCacheMrg.getLicGroupRuntimeType());
            LicenseCacheMrg.putCache((String)LicenseCacheMrg.getLicGroupRuntimeType(), redisResult);
            LicenseCache.clearCircuitBreaker("group");
            logger.info("LicGroupRuntimeUtil.reloadRedisCache putRedisCache end . redisResult : {}", redisResult);
        }
        catch (Exception e) {
            logger.error("LicGroupRuntimeUtil.reloadRedisCache get license failed.", (Throwable)e);
            LicenseCacheMrg.putCache((String)LicenseCacheMrg.getLicenseCircuitBreakerType(), (String)"group", (String)"DATA_LOADED");
            AppLogInfo appLogInfo = new AppLogInfo();
            appLogInfo.setBizAppID("83bfebc8000037ac");
            appLogInfo.setBizObjID("lic_license");
            appLogInfo.setOpDescription(ResManager.loadKDString((String)"\u52a0\u8f7d\u8bb8\u53ef\u5206\u7ec4\u8be6\u60c5\uff0c\u8be6\u60c5\u8bf7\u67e5\u770bmonitor\u65e5\u5fd7\uff0c\u5173\u952e\u5b57\uff1aLicGroupRuntimeUtil.reloadRedisCache\u3002", (String)"LicGroupRuntimeUtil_0", (String)"bos-license-business", (Object[])new Object[0]));
            appLogInfo.setOpName(ResManager.loadKDString((String)"\u52a0\u8f7d\u8bb8\u53ef\u5206\u7ec4\u8be6\u60c5", (String)"LicGroupRuntimeUtil_1", (String)"bos-license-business", (Object[])new Object[0]));
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
        }
        return result;
    }

    private static void downloadAndUpdateLic(boolean isHighAvailabilityMode, LicenseSyncLog licenseSyncLog) {
        UpdateLicGroupUser updateLicGroupUser = new UpdateLicGroupUser();
        boolean updateLicenseResult = false;
        try {
            updateLicenseResult = updateLicGroupUser.downloadAndUpdateLicUser(true, licenseSyncLog, isHighAvailabilityMode);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (Throwable)e);
        }
        if (null != licenseSyncLog) {
            licenseSyncLog.setOperator(Long.valueOf(-10000L));
        }
        if (!updateLicenseResult) {
            logger.error("\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38");
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (String)"LicenseCache_0", (String)"bos-license-business", (Object[])new Object[0]));
        }
    }

    private static Map<String, LicGroupRuntime> replaceLocalCache(Map<String, String> redisCacheData) {
        logger.debug("LicGroupRuntimeUtil.replaceLocalCache start. ");
        if (CollectionUtils.isEmpty(redisCacheData)) {
            return null;
        }
        HashMap<String, LicGroupRuntime> result = new HashMap<String, LicGroupRuntime>(16);
        try (DLock dlock = DLock.createReentrant((String)("replaceLocalCache_LicGroupRuntime" + RequestContext.get().getAccountId()));){
            dlock.lock();
            logger.debug("LicGroupRuntimeUtil.replaceLocalCache get lock. ");
            String versionFromRedisCache = LicGroupRuntimeUtil.getVersionFromRedisCache();
            String verisonFromLocalCache = LicGroupRuntimeUtil.getVerisonFromLocalCache();
            Map<String, LicGroupRuntime> groupRuntimeFromLocalCache = LicGroupRuntimeUtil.getGroupRuntimeFromLocalCache();
            if (StringUtils.equals((CharSequence)verisonFromLocalCache, (CharSequence)versionFromRedisCache) && !StringUtils.isBlank((CharSequence)versionFromRedisCache) && null != groupRuntimeFromLocalCache) {
                logger.debug("LicGroupRuntimeUtil.replaceLocalCache. versionFromRedisCache " + versionFromRedisCache + " verisonFromLocalCache\uff1a" + verisonFromLocalCache);
                Map<String, LicGroupRuntime> map = groupRuntimeFromLocalCache;
                return map;
            }
            logger.debug("LicGroupRuntimeUtil.replaceLocalCache. versionFromRedisCache " + versionFromRedisCache + " verisonFromLocalCache\uff1a" + verisonFromLocalCache);
            String version = null;
            for (Map.Entry<String, String> cacheData : redisCacheData.entrySet()) {
                String groupId = cacheData.getKey();
                String licGroupRuntimeJsonStr = cacheData.getValue();
                if (VERSION.equals(groupId)) {
                    version = licGroupRuntimeJsonStr;
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)licGroupRuntimeJsonStr)) continue;
                LicGroupRuntime licGroupRuntime = (LicGroupRuntime)SerializationUtils.fromJsonString((String)licGroupRuntimeJsonStr, LicGroupRuntime.class);
                result.put(String.valueOf(licGroupRuntime.getGroupId()), licGroupRuntime);
            }
            LicGroupRuntimeLocalCache.putAllLicenseGroupRunTimeInfo(result);
            if (null == version) {
                version = DB.genStringId((String)"");
                LicenseCacheMrg.putCache((String)LicenseCacheMrg.getLicGroupRuntimeType(), (String)VERSION, (String)version);
            }
            LicGroupRuntimeLocalCache.setVersion(version);
            logger.debug("LicGroupRuntimeUtil.replaceLocalCache end. version " + version);
        }
        return result;
    }

    private static Callable<Map<String, Object>> reloadRedisCacheTask() {
        return () -> {
            LicGroupRuntimeUtil.reloadRedisCache(null);
            return null;
        };
    }

    private static String getVersionFromRedisCache() {
        return LicenseCacheMrg.getCache((String)LicenseCacheMrg.getLicGroupRuntimeType(), (String)VERSION);
    }

    private static Map<String, String> getGroupRuntimeFromRedisCache() {
        return LicenseCacheMrg.getCache((String)LicenseCacheMrg.getLicGroupRuntimeType());
    }

    private static String getVerisonFromLocalCache() {
        return LicGroupRuntimeLocalCache.getVersion();
    }

    private static Map<String, LicGroupRuntime> getGroupRuntimeFromLocalCache() {
        return LicGroupRuntimeLocalCache.getAllLicGroupRunTimeInfo();
    }
}

