/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.license.LocalCache.LicModuleRuntimeLocalCache;
import kd.bos.license.UpdateLicGroupUser;
import kd.bos.license.bean.LicModuleRuntime;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.bean.RangeDate;
import kd.bos.license.config.AESUtil;
import kd.bos.license.pojo.LicenseDetailSnapshot;
import kd.bos.license.pojo.LicenseGeneralSnapshot;
import kd.bos.license.pojo.LicenseGroupAppSnapshot;
import kd.bos.license.pojo.LicenseSnapshot;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class LicModuleRuntimeUtil {
    private static Log logger = LogFactory.getLog(LicModuleRuntimeUtil.class);
    private static final String VERSION = "version";
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"LIC_MODULE_RUNTIME_POOL", (int)0, (int)1);
    private static final String ENTITY_SNAPSHOT = "lic_snapshot";

    public static Map<String, LicModuleRuntime> getAllModuleRuntimeInfos() {
        return LicModuleRuntimeUtil.getModuleRuntimeInfos();
    }

    public static Map<String, LicModuleRuntime> getModuleRuntimeInfosById(Collection<String> moduleNums) {
        if (CollectionUtils.isEmpty(moduleNums)) {
            return Collections.emptyMap();
        }
        Map<String, LicModuleRuntime> moduleRuntimeInfos = LicModuleRuntimeUtil.getModuleRuntimeInfos();
        if (CollectionUtils.isEmpty(moduleRuntimeInfos)) {
            return Collections.emptyMap();
        }
        HashMap<String, LicModuleRuntime> result = new HashMap<String, LicModuleRuntime>(moduleNums.size());
        for (Map.Entry<String, LicModuleRuntime> info : moduleRuntimeInfos.entrySet()) {
            String moduelNumber = info.getKey();
            if (!moduleNums.contains(moduelNumber)) continue;
            result.put(moduelNumber, info.getValue());
        }
        return result;
    }

    private static Map<String, LicModuleRuntime> getModuleRuntimeInfos() {
        String versionFromRedisCache = LicModuleRuntimeUtil.getVersionFromRedisCache();
        String verisonFromLocalCache = LicModuleRuntimeUtil.getVerisonFromLocalCache();
        logger.debug("LicModuleRuntimeUtil.getModuleRuntimeInfos. versionFromRedisCache : " + versionFromRedisCache + "verisonFromLocalCache : " + verisonFromLocalCache);
        if (StringUtils.equals((CharSequence)versionFromRedisCache, (CharSequence)verisonFromLocalCache)) {
            Map<String, LicModuleRuntime> moduleRuntimeFromLocalCache = LicModuleRuntimeUtil.getModuleRuntimeFromLocalCache();
            if (null == moduleRuntimeFromLocalCache) {
                logger.debug("LicModuleRuntimeUtil.getModuleRuntimeInfos. local is blank.");
                Map<String, String> moduleRuntimeFromRedisCache = LicModuleRuntimeUtil.getModuleRuntimeFromRedisCache();
                if (CollectionUtils.isEmpty(moduleRuntimeFromRedisCache)) {
                    logger.debug("LicModuleRuntimeUtil.getModuleRuntimeInfos. redis is blank.");
                    return LicModuleRuntimeUtil.reloadRedisCache(null);
                }
                return LicModuleRuntimeUtil.replaceLocalCache(moduleRuntimeFromRedisCache);
            }
            return moduleRuntimeFromLocalCache;
        }
        Map<String, String> moduleRuntimeFromRedisCache = LicModuleRuntimeUtil.getModuleRuntimeFromRedisCache();
        if (CollectionUtils.isEmpty(moduleRuntimeFromRedisCache)) {
            logger.debug("LicModuleRuntimeUtil.getModuleRuntimeInfos. redis is blank.");
            Map<String, LicModuleRuntime> moduleRuntimeFromLocalCache = LicModuleRuntimeUtil.getModuleRuntimeFromLocalCache();
            if (null == moduleRuntimeFromLocalCache) {
                logger.debug("LicModuleRuntimeUtil.getModuleRuntimeInfos. local is blank.");
                return LicModuleRuntimeUtil.reloadRedisCache(null);
            }
            logger.debug("LicModuleRuntimeUtil.getModuleRuntimeInfos.reloadRedisCacheTask.");
            THREAD_POOL.submit(LicModuleRuntimeUtil.reloadRedisCacheTask(), RequestContext.get());
            return moduleRuntimeFromLocalCache;
        }
        return LicModuleRuntimeUtil.replaceLocalCache(moduleRuntimeFromRedisCache);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Map<String, LicModuleRuntime> reloadRedisCache(String data) {
        logger.debug("LicModuleRuntimeUtil.reloadRedisCache start.");
        HashMap<String, LicModuleRuntime> result = new HashMap<String, LicModuleRuntime>(16);
        HashMap<String, String> redisResult = new HashMap<String, String>(16);
        try (DLock dlock = DLock.createReentrant((String)("reloadModuleRuntimeRedisCache" + RequestContext.get().getAccountId()));){
            DynamicObject[] load;
            dlock.lock();
            logger.debug("LicModuleRuntimeUtil.reloadRedisCache get lock.");
            String versionFromRedisCache = LicModuleRuntimeUtil.getVersionFromRedisCache();
            boolean isBlankData = StringUtils.isBlank((CharSequence)data);
            if (!StringUtils.isBlank((CharSequence)versionFromRedisCache) && isBlankData) {
                logger.debug("LicModuleRuntimeUtil.reloadRedisCache versionFromRedisCache is blank.");
                Map<String, LicModuleRuntime> map = LicModuleRuntimeUtil.getModuleRuntimeFromLocalCache();
                return map;
            }
            logger.debug("LicModuleRuntimeUtil.reloadRedisCache versionFromRedisCache : " + versionFromRedisCache);
            if (isBlankData) {
                DynamicObjectCollection snapshotDoc = QueryServiceHelper.query((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
                if (null == snapshotDoc || snapshotDoc.isEmpty()) {
                    LicenseSyncLog licenseSyncLog = new LicenseSyncLog();
                    LicModuleRuntimeUtil.downloadAndUpdateLic(licenseSyncLog);
                    snapshotDoc = QueryServiceHelper.query((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
                }
                snapshotDoc.sort((o1, o2) -> {
                    int type1 = Integer.parseInt(o1.getString("snapshottype"));
                    int type2 = Integer.parseInt(o2.getString("snapshottype"));
                    return type1 - type2;
                });
                data = ((DynamicObject)snapshotDoc.get(snapshotDoc.size() - 1)).getString("data");
            }
            String snapshotStr = AESUtil.decrypt((String)data);
            LicenseGeneralSnapshot snapshot = null;
            try {
                snapshot = (LicenseGeneralSnapshot)SerializationUtils.fromJsonString((String)snapshotStr, LicenseGeneralSnapshot.class);
            }
            catch (Exception e) {
                snapshot = (LicenseGeneralSnapshot)JSON.parseObject((String)snapshotStr, LicenseGeneralSnapshot.class);
            }
            if (null == snapshot) {
                throw new KDException("LicGroupRuntimeUtil.reloadRedisCache\uff1aLicenseSnapshots is Empty.");
            }
            ArrayList licenseSnapshots = snapshot.getLicenseSnapshots();
            if (licenseSnapshots == null) {
                licenseSnapshots = new ArrayList(16);
            }
            HashMap<String, String> appNumToModuleNum = new HashMap<String, String>(16);
            for (LicenseSnapshot licenseSnapshot : licenseSnapshots) {
                List detailSnapshotList = licenseSnapshot.getDetailSnapshotList();
                if (CollectionUtils.isEmpty((Collection)detailSnapshotList)) continue;
                for (LicenseDetailSnapshot licenseDetailSnapshot : detailSnapshotList) {
                    List appSnapshotList = licenseDetailSnapshot.getAppSnapshotList();
                    if (CollectionUtils.isEmpty((Collection)appSnapshotList)) continue;
                    for (LicenseGroupAppSnapshot licenseGroupAppSnapshot : appSnapshotList) {
                        String moduleNumber;
                        if (null == licenseGroupAppSnapshot || StringUtils.isBlank((CharSequence)(moduleNumber = licenseGroupAppSnapshot.getModule()))) continue;
                        appNumToModuleNum.put(moduleNumber.toLowerCase(Locale.ENGLISH), moduleNumber);
                        Date moduleBeginDate = licenseGroupAppSnapshot.getModuleBeginDate();
                        Date moduleEndDate = licenseGroupAppSnapshot.getModuleEndDate();
                        ArrayList<RangeDate> rangeDates = new ArrayList<RangeDate>(1);
                        rangeDates.add(new RangeDate(moduleBeginDate, moduleEndDate));
                        LicModuleRuntime licModuleRuntime = new LicModuleRuntime(moduleNumber, rangeDates);
                        result.put(moduleNumber, licModuleRuntime);
                        redisResult.put(moduleNumber, SerializationUtils.toJsonString((Object)licModuleRuntime));
                    }
                }
            }
            if (!appNumToModuleNum.isEmpty() && (load = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"number", (QFilter[])new QFilter("number", "in", appNumToModuleNum.keySet()).toArray())) != null && load.length != 0) {
                for (DynamicObject appObj : load) {
                    String appId = appObj.getPkValue().toString();
                    String number = appObj.getString("number");
                    LicModuleRuntime licModuleNumRuntime = (LicModuleRuntime)result.get(appNumToModuleNum.get(number));
                    if (null == licModuleNumRuntime) continue;
                    LicModuleRuntime licappIdRuntime = new LicModuleRuntime(appId, licModuleNumRuntime.getRangeDates());
                    result.put(appId, licappIdRuntime);
                    redisResult.put(appId, SerializationUtils.toJsonString((Object)licappIdRuntime));
                }
            }
            String version = DB.genStringId((String)"");
            redisResult.put(VERSION, version);
            LicenseCacheMrg.clearCache((String)LicenseCacheMrg.getLicModuelRuntimeType());
            LicenseCacheMrg.putCache((String)LicenseCacheMrg.getLicModuelRuntimeType(), redisResult);
            LicenseCacheMrg.clearCache((String)LicenseCacheMrg.getLicenseCircuitBreakerType(), (String)"module");
            logger.info("LicModuleRuntimeUtil.reloadRedisCache putRedisCache end . redisResult : {}", redisResult);
        }
        catch (Exception e) {
            logger.error("LicModuleRuntimeUtil.reloadRedisCache get license failed.", (Throwable)e);
            LicenseCacheMrg.putCache((String)LicenseCacheMrg.getLicenseCircuitBreakerType(), (String)"module", (String)"DATA_LOADED");
            AppLogInfo appLogInfo = new AppLogInfo();
            appLogInfo.setBizAppID("83bfebc8000037ac");
            appLogInfo.setBizObjID("lic_license");
            appLogInfo.setOpDescription(ResManager.loadKDString((String)"\u52a0\u8f7d\u6a21\u5757\u5206\u7ec4\u8be6\u60c5\uff0c\u8be6\u60c5\u8bf7\u67e5\u770bmonitor\u65e5\u5fd7\uff0c\u5173\u952e\u5b57\uff1aLicModuleRuntimeUtil.reloadRedisCache\u3002", (String)"LicModuleRuntimeUtil_0", (String)"bos-license-business", (Object[])new Object[0]));
            appLogInfo.setOpName(ResManager.loadKDString((String)"\u52a0\u8f7d\u8bb8\u53ef\u6a21\u5757\u8be6\u60c5", (String)"LicModuleRuntimeUtil_1", (String)"bos-license-business", (Object[])new Object[0]));
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
        }
        return result;
    }

    private static void downloadAndUpdateLic(LicenseSyncLog licenseSyncLog) {
        UpdateLicGroupUser updateLicGroupUser = new UpdateLicGroupUser();
        boolean updateLicenseResult = false;
        try {
            updateLicenseResult = updateLicGroupUser.downloadAndUpdateLicUser(true, licenseSyncLog, true);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (Throwable)e);
        }
        if (null != licenseSyncLog) {
            licenseSyncLog.setOperator(Long.valueOf(-10000L));
        }
        if (!updateLicenseResult) {
            logger.error("\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38");
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (String)"LicenseCache_0", (String)"bos-license-business", (Object[])new Object[0]));
        }
    }

    private static Map<String, LicModuleRuntime> replaceLocalCache(Map<String, String> redisCacheData) {
        logger.debug("LicModuleRuntimeUtil.replaceLocalCache start.");
        if (CollectionUtils.isEmpty(redisCacheData)) {
            return null;
        }
        HashMap<String, LicModuleRuntime> result = new HashMap<String, LicModuleRuntime>(16);
        try (DLock dlock = DLock.createReentrant((String)("replaceLocalCache_LicModuleRuntime" + RequestContext.get().getAccountId()));){
            dlock.lock();
            logger.debug("LicModuleRuntimeUtil.replaceLocalCache get lock.");
            String versionFromRedisCache = LicModuleRuntimeUtil.getVersionFromRedisCache();
            String verisonFromLocalCache = LicModuleRuntimeUtil.getVerisonFromLocalCache();
            Map<String, LicModuleRuntime> moduleRuntimeFromLocalCache = LicModuleRuntimeUtil.getModuleRuntimeFromLocalCache();
            if (StringUtils.equals((CharSequence)verisonFromLocalCache, (CharSequence)versionFromRedisCache) && !StringUtils.isBlank((CharSequence)versionFromRedisCache) && null != moduleRuntimeFromLocalCache) {
                logger.debug("LicModuleRuntimeUtil.replaceLocalCache verisonFromLocalCache : " + verisonFromLocalCache + " versionFromRedisCache : " + versionFromRedisCache);
                Map<String, LicModuleRuntime> map = moduleRuntimeFromLocalCache;
                return map;
            }
            logger.debug("LicModuleRuntimeUtil.replaceLocalCache verisonFromLocalCache : " + verisonFromLocalCache + " versionFromRedisCache : " + versionFromRedisCache);
            String version = null;
            for (Map.Entry<String, String> cacheData : redisCacheData.entrySet()) {
                String groupId = cacheData.getKey();
                String licGroupRuntimeJsonStr = cacheData.getValue();
                if (VERSION.equals(groupId)) {
                    version = licGroupRuntimeJsonStr;
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)licGroupRuntimeJsonStr)) continue;
                LicModuleRuntime licModuleRuntime = (LicModuleRuntime)SerializationUtils.fromJsonString((String)licGroupRuntimeJsonStr, LicModuleRuntime.class);
                result.put(String.valueOf(licModuleRuntime.getModuleNumber()), licModuleRuntime);
            }
            LicModuleRuntimeLocalCache.putAllLicenseModuleRunTimeInfo(result);
            if (null == version) {
                version = DB.genStringId((String)"");
                LicenseCacheMrg.putCache((String)LicenseCacheMrg.getLicModuelRuntimeType(), (String)VERSION, (String)version);
            }
            LicModuleRuntimeLocalCache.setVersion(version);
            logger.debug("LicModuleRuntimeUtil.replaceLocalCache putAllLicenseModuleRunTimeInfo. version : " + version);
        }
        return result;
    }

    private static Callable<Map<String, Object>> reloadRedisCacheTask() {
        return () -> {
            LicModuleRuntimeUtil.reloadRedisCache(null);
            return null;
        };
    }

    private static String getVersionFromRedisCache() {
        return LicenseCacheMrg.getCache((String)LicenseCacheMrg.getLicModuelRuntimeType(), (String)VERSION);
    }

    private static Map<String, String> getModuleRuntimeFromRedisCache() {
        return LicenseCacheMrg.getCache((String)LicenseCacheMrg.getLicModuelRuntimeType());
    }

    private static String getVerisonFromLocalCache() {
        return LicModuleRuntimeLocalCache.getVersion();
    }

    private static Map<String, LicModuleRuntime> getModuleRuntimeFromLocalCache() {
        return LicModuleRuntimeLocalCache.getAllLicModuleRunTimeInfo();
    }
}

