/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.service.cache.LicenseConfigLocalCache;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class LicenseConfigUtil {
    private static final Log logger = LogFactory.getLog(LicenseConfigUtil.class);
    private static final String CURR = "curr";
    private static final String LATEST = "latest";
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"LIC_CONFIG_POOL", (int)0, (int)1);

    public static Map<String, String> getCurrAppConfig() {
        return LicenseConfigUtil.getLicenseAppConfig(CURR);
    }

    public static Map<String, String> getLatestAppConfig() {
        return LicenseConfigUtil.getLicenseAppConfig(LATEST);
    }

    public static Map<String, String> getCurrLicenseConfig() {
        return LicenseConfigUtil.getLicenseConfig(CURR);
    }

    public static String getCurrLicenseConfig(String key) {
        return LicenseConfigUtil.getLicenseConfig(key, CURR);
    }

    public static Map<String, String> getLatestLicenseConfig() {
        return LicenseConfigUtil.getLicenseConfig(LATEST);
    }

    public static String getLatestLicenseConfig(String key) {
        return LicenseConfigUtil.getLicenseConfig(key, LATEST);
    }

    private static Map<String, String> getLicenseAppConfig(String type) {
        String localCacheVersion;
        boolean isLatestVersion = LATEST.equals(type);
        String redisType = LATEST.equals(type) ? LicenseCacheMrg.getLatestTypeLicenseGroupConfig() : LicenseCacheMrg.getType4LicenseGroupConfig();
        String redisVersion = LicenseConfigUtil.getRedisVersion(redisType);
        String string = localCacheVersion = isLatestVersion ? LicenseConfigLocalCache.getLatestAppCtrlVersion() : LicenseConfigLocalCache.getCurrAppCtrlVersion();
        if (StringUtils.equals((CharSequence)redisVersion, (CharSequence)localCacheVersion)) {
            Map<String, String> licAppConfigLocalCacheMap;
            Map<String, String> map = licAppConfigLocalCacheMap = isLatestVersion ? LicenseConfigLocalCache.getLatestAPPConfig() : LicenseConfigLocalCache.getCurrAPPConfig();
            if (CollectionUtils.isEmpty(licAppConfigLocalCacheMap)) {
                Map licCtrlConfigRedisCacheMap = LicenseCacheMrg.getCache((String)redisType);
                if (CollectionUtils.isEmpty((Map)licCtrlConfigRedisCacheMap)) {
                    boolean success = LicenseConfigUtil.quickReloadLocalCache();
                    if (success) {
                        LicenseConfigUtil.AsynchronousReloadRedisCache(redisType);
                        return isLatestVersion ? LicenseConfigLocalCache.getLatestAPPConfig() : LicenseConfigLocalCache.getCurrAPPConfig();
                    }
                    LicenseConfigUtil.reloadRedisCache(redisType);
                    return LicenseCacheMrg.getCache((String)redisType);
                }
                LicenseConfigLocalCache.putLatestCtrlConfig(licCtrlConfigRedisCacheMap);
                return licCtrlConfigRedisCacheMap;
            }
            return licAppConfigLocalCacheMap;
        }
        Map licCtrlConfigRedisCacheMap = LicenseCacheMrg.getCache((String)redisType);
        if (CollectionUtils.isEmpty((Map)licCtrlConfigRedisCacheMap)) {
            Map<String, String> licAppConfigLocalCacheMap;
            Map<String, String> map = licAppConfigLocalCacheMap = isLatestVersion ? LicenseConfigLocalCache.getLatestAPPConfig() : LicenseConfigLocalCache.getCurrAPPConfig();
            if (CollectionUtils.isEmpty(licAppConfigLocalCacheMap)) {
                boolean success = LicenseConfigUtil.quickReloadLocalCache();
                if (success) {
                    LicenseConfigUtil.AsynchronousReloadRedisCache(redisType);
                    return isLatestVersion ? LicenseConfigLocalCache.getLatestAPPConfig() : LicenseConfigLocalCache.getCurrAPPConfig();
                }
                LicenseConfigUtil.reloadRedisCache(redisType);
                return LicenseCacheMrg.getCache((String)redisType);
            }
            return licAppConfigLocalCacheMap;
        }
        try (DLock dlock = DLock.createReentrant((String)("reloadLicConfigLocalCache_" + RequestContext.get().getAccountId()));){
            dlock.lock();
            redisVersion = LicenseConfigUtil.getRedisVersion(redisType);
            String string2 = localCacheVersion = isLatestVersion ? LicenseConfigLocalCache.getLatestAppCtrlVersion() : LicenseConfigLocalCache.getCurrAppCtrlVersion();
            if (!StringUtils.equals((CharSequence)redisVersion, (CharSequence)localCacheVersion) || null == redisVersion) {
                if (isLatestVersion) {
                    LicenseConfigLocalCache.putLatestAPPConfig(licCtrlConfigRedisCacheMap);
                    if (null == redisVersion) {
                        redisVersion = DB.genStringId((String)"");
                        LicenseCacheMrg.setVersion((String)LicenseCacheMrg.getTypeLicenseConfigVersion((String)redisType), (String)redisVersion);
                    }
                    LicenseConfigLocalCache.putLatestAppCtrlVersion(redisVersion);
                } else {
                    LicenseConfigLocalCache.putCurrAPPConfig(licCtrlConfigRedisCacheMap);
                    if (null == redisVersion) {
                        redisVersion = DB.genStringId((String)"");
                        LicenseCacheMrg.setVersion((String)LicenseCacheMrg.getTypeLicenseConfigVersion((String)redisType), (String)redisVersion);
                    }
                    LicenseConfigLocalCache.putCurrAppCtrlVersion(redisVersion);
                }
            }
        }
        return isLatestVersion ? LicenseConfigLocalCache.getLatestAPPConfig() : LicenseConfigLocalCache.getCurrAPPConfig();
    }

    private static boolean quickReloadLocalCache() {
        boolean isSuccess = true;
        logger.info("LicenseConfigUtil.quickReloadLocalCache start.");
        try (DLock dlock = DLock.createReentrant((String)("reloadLicConfigLocalCache_" + RequestContext.get().getAccountId()));){
            dlock.lock();
            logger.info("LicenseConfigUtil.quickReloadLocalCache get lock.");
            HashMap<String, String> appConfig = new HashMap<String, String>(16);
            appConfig.put("DATA_LOADED", "DATA_LOADED");
            HashMap<String, String> licConfig = new HashMap<String, String>(16);
            appConfig.put("DATA_LOADED", "DATA_LOADED");
            String localCacheVersion = LicenseConfigLocalCache.getCurrCtrlVersion();
            if (!StringUtils.isBlank((CharSequence)localCacheVersion)) {
                logger.info("LicenseConfigUtil.quickReloadLocalCache get lock. localCacheVersion " + localCacheVersion);
                boolean bl = true;
                return bl;
            }
            logger.info("LicenseConfigUtil.quickReloadLocalCache get lock. localCacheVersion " + localCacheVersion);
            isSuccess = (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select a.fgroupId groupId,a.fbizappid appId,a.fbizobjectid objectId,b.fnumber moduleNum from t_lic_licensegroupctrl a left join t_lic_module b on a.fmoduleid = b.fid ", rs -> {
                boolean isExist = false;
                while (rs.next()) {
                    String groupId = rs.getString("groupId");
                    String appId = rs.getString("appId");
                    String objectId = rs.getString("objectId");
                    String moduleNum = rs.getString("moduleNum");
                    appConfig.merge(appId, groupId, (existingValue, additionalValue) -> String.join((CharSequence)";", existingValue, additionalValue));
                    licConfig.merge(appId + objectId, groupId + "_" + moduleNum, (existingValue, additionalValue) -> String.join((CharSequence)";", existingValue, additionalValue));
                    isExist = true;
                }
                return isExist;
            });
            if (isSuccess) {
                LicenseConfigLocalCache.putCurrAPPConfig(appConfig);
                LicenseConfigLocalCache.putLatestAPPConfig(appConfig);
                LicenseConfigLocalCache.putCurrCtrlConfig(licConfig);
                LicenseConfigLocalCache.putLatestCtrlConfig(licConfig);
                String versionTemp = DB.genStringId((String)"111");
                LicenseConfigLocalCache.putCurrAppCtrlVersion(versionTemp);
                LicenseConfigLocalCache.putLatestAppCtrlVersion(versionTemp);
                LicenseConfigLocalCache.putCurrCtrlVersion(versionTemp);
                LicenseConfigLocalCache.putLatestCtrlVersion(versionTemp);
                logger.info("LicenseConfigUtil.quickReloadLocalCache end. versionTemp " + versionTemp);
            }
        }
        return isSuccess;
    }

    private static void AsynchronousReloadRedisCache(String type) {
        if (LicenseCache.isCircuitBreaker("ctrl")) {
            logger.warn("License Ctrl isCircuitBreaker. return; ");
            return;
        }
        logger.info("LicenseConfigUtil.AsynchronousReloadRedisCache start.");
        THREAD_POOL.submit(LicenseConfigUtil.reloadCtrlTask(type), RequestContext.get());
    }

    private static void reloadRedisCache(String type) {
        try (DLock dlock = DLock.createReentrant((String)("LicenseGroupConfig_" + RequestContext.get().getAccountId()));){
            dlock.lock();
            String redisVersion = LicenseConfigUtil.getRedisVersion(type);
            String dataLoaded = LicenseCacheMrg.getCache((String)type, (String)"DATA_LOADED");
            if ((StringUtils.isBlank((CharSequence)redisVersion) || StringUtils.isBlank((CharSequence)dataLoaded)) && !LicenseCache.isCircuitBreaker("ctrl")) {
                LicenseCache.reloadCtrlGroup();
            }
        }
        catch (Exception e) {
            logger.error("reloadLicCtrlRedisCache error.", (Throwable)e);
            AppLogInfo appLogInfo = new AppLogInfo();
            appLogInfo.setBizAppID("83bfebc8000037ac");
            appLogInfo.setBizObjID("lic_license");
            appLogInfo.setOpDescription(ResManager.loadKDString((String)"\u52a0\u8f7d\u8bb8\u53ef\u63a7\u5236\u6e05\u5355\u51fa\u9519\uff0c\u8be6\u60c5\u8bf7\u67e5\u770bmonitor\u65e5\u5fd7\uff0c\u5173\u952e\u5b57\uff1areloadLicCtrlRedisCache\u3002", (String)"LicenseConfigUtil_0", (String)"bos-license-business", (Object[])new Object[0]));
            appLogInfo.setOpName(ResManager.loadKDString((String)"\u52a0\u8f7d\u8bb8\u53ef\u63a7\u5236\u6e05\u5355", (String)"LicenseConfigUtil_1", (String)"bos-license-business", (Object[])new Object[0]));
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
            LicenseCacheMrg.putCache((String)LicenseCacheMrg.getLicenseCircuitBreakerType(), (String)"ctrl", (String)"true");
        }
    }

    private static Map<String, String> getLicenseConfig(String type) {
        String localCacheVersion;
        boolean isLatestVersion = LATEST.equals(type);
        String redisType = isLatestVersion ? LicenseCacheMrg.getLatestTypeCtrlGroup() : LicenseCacheMrg.getType4CtrlGroup();
        String redisVersion = LicenseConfigUtil.getRedisVersion(redisType);
        String string = localCacheVersion = isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlVersion() : LicenseConfigLocalCache.getCurrCtrlVersion();
        if (StringUtils.equals((CharSequence)redisVersion, (CharSequence)localCacheVersion)) {
            Map<String, String> licCtrlConfigLocalCacheMap;
            Map<String, String> map = licCtrlConfigLocalCacheMap = isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlConfig() : LicenseConfigLocalCache.getCurrCtrlConfig();
            if (CollectionUtils.isEmpty(licCtrlConfigLocalCacheMap)) {
                Map licCtrlConfigRedisCacheMap = LicenseCacheMrg.getCache((String)redisType);
                if (CollectionUtils.isEmpty((Map)licCtrlConfigRedisCacheMap)) {
                    boolean success = LicenseConfigUtil.quickReloadLocalCache();
                    if (success) {
                        LicenseConfigUtil.AsynchronousReloadRedisCache(redisType);
                        return isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlConfig() : LicenseConfigLocalCache.getCurrCtrlConfig();
                    }
                    LicenseConfigUtil.reloadRedisCache(redisType);
                    return LicenseCacheMrg.getCache((String)redisType);
                }
                LicenseConfigLocalCache.putLatestCtrlConfig(licCtrlConfigRedisCacheMap);
                return licCtrlConfigRedisCacheMap;
            }
            return licCtrlConfigLocalCacheMap;
        }
        Map licCtrlConfigRedisCacheMap = LicenseCacheMrg.getCache((String)redisType);
        if (CollectionUtils.isEmpty((Map)licCtrlConfigRedisCacheMap)) {
            Map<String, String> licCtrlConfigLocalCacheMap;
            Map<String, String> map = licCtrlConfigLocalCacheMap = isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlConfig() : LicenseConfigLocalCache.getCurrCtrlConfig();
            if (CollectionUtils.isEmpty(licCtrlConfigLocalCacheMap)) {
                boolean success = LicenseConfigUtil.quickReloadLocalCache();
                if (success) {
                    LicenseConfigUtil.AsynchronousReloadRedisCache(redisType);
                    return isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlConfig() : LicenseConfigLocalCache.getCurrCtrlConfig();
                }
                LicenseConfigUtil.reloadRedisCache(redisType);
                return LicenseCacheMrg.getCache((String)redisType);
            }
            return licCtrlConfigLocalCacheMap;
        }
        try (DLock dlock = DLock.createReentrant((String)("reloadLicConfigLocalCache_" + RequestContext.get().getAccountId()));){
            dlock.lock();
            redisVersion = LicenseConfigUtil.getRedisVersion(redisType);
            String string2 = localCacheVersion = isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlVersion() : LicenseConfigLocalCache.getCurrCtrlVersion();
            if (!StringUtils.equals((CharSequence)redisVersion, (CharSequence)localCacheVersion) || null == redisVersion) {
                if (isLatestVersion) {
                    LicenseConfigLocalCache.putLatestCtrlConfig(licCtrlConfigRedisCacheMap);
                    if (null == redisVersion) {
                        redisVersion = DB.genStringId((String)"");
                        LicenseCacheMrg.setVersion((String)LicenseCacheMrg.getTypeLicenseConfigVersion((String)redisType), (String)redisVersion);
                    }
                    LicenseConfigLocalCache.putLatestCtrlVersion(redisVersion);
                } else {
                    LicenseConfigLocalCache.putCurrCtrlConfig(licCtrlConfigRedisCacheMap);
                    if (null == redisVersion) {
                        redisVersion = DB.genStringId((String)"");
                        LicenseCacheMrg.setVersion((String)LicenseCacheMrg.getTypeLicenseConfigVersion((String)redisType), (String)redisVersion);
                    }
                    LicenseConfigLocalCache.putCurrCtrlVersion(redisVersion);
                }
            }
        }
        return isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlConfig() : LicenseConfigLocalCache.getCurrCtrlConfig();
    }

    private static String getLicenseConfig(String key, String type) {
        boolean isLatestVersion = LATEST.equals(type);
        String redisType = LATEST.equals(type) ? LicenseCacheMrg.getLatestTypeCtrlGroup() : LicenseCacheMrg.getType4CtrlGroup();
        String redisVersion = LicenseConfigUtil.getRedisVersion(redisType);
        String localCacheVersion = isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlVersion() : LicenseConfigLocalCache.getCurrCtrlVersion();
        boolean equalsVersion = StringUtils.equals((CharSequence)redisVersion, (CharSequence)localCacheVersion);
        if (null == redisVersion || null == localCacheVersion || !equalsVersion) {
            logger.info("LicenseConfigUtil.getLicenseConfig. redisVersion : " + redisVersion + " localCacheVersion : " + localCacheVersion);
        }
        if (equalsVersion) {
            Map<String, String> licCtrlConfigLocalCacheMap;
            Map<String, String> map = licCtrlConfigLocalCacheMap = isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlConfig() : LicenseConfigLocalCache.getCurrCtrlConfig();
            if (CollectionUtils.isEmpty(licCtrlConfigLocalCacheMap)) {
                logger.info("LicenseConfigUtil.getLicenseConfig. localCache is blank.");
                String load = LicenseCacheMrg.getCache((String)redisType, (String)"DATA_LOADED");
                if (StringUtils.isBlank((CharSequence)load)) {
                    logger.info("LicenseConfigUtil.getLicenseConfig. redis is blank,quickReloadLocalCache.");
                    boolean success = LicenseConfigUtil.quickReloadLocalCache();
                    if (success) {
                        logger.info("LicenseConfigUtil.getLicenseConfig. AsynchronousReloadRedisCache.");
                        LicenseConfigUtil.AsynchronousReloadRedisCache(redisType);
                        Map<String, String> ctrlMap = isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlConfig() : LicenseConfigLocalCache.getCurrCtrlConfig();
                        logger.info("LicenseConfigUtil.getLicenseConfig. return localCache.");
                        return CollectionUtils.isEmpty(ctrlMap) ? null : ctrlMap.get(key);
                    }
                    logger.info("LicenseConfigUtil.getLicenseConfig. quickReloadLocalCache is fail,reloadRedisCache.");
                    LicenseConfigUtil.reloadRedisCache(redisType);
                    Map ctrlMap = LicenseCacheMrg.getCache((String)redisType);
                    logger.info("LicenseConfigUtil.getLicenseConfig. return redisCache.");
                    return CollectionUtils.isEmpty((Map)ctrlMap) ? null : (String)ctrlMap.get(key);
                }
                if (isLatestVersion) {
                    logger.debug("LicenseConfigUtil.getLicenseConfig. replace localCache.");
                    LicenseConfigLocalCache.putLatestCtrlConfig(LicenseCacheMrg.getCache((String)redisType));
                } else {
                    logger.debug("LicenseConfigUtil.getLicenseConfig. replace localCache.");
                    LicenseConfigLocalCache.putCurrCtrlConfig(LicenseCacheMrg.getCache((String)redisType));
                }
                logger.debug("LicenseConfigUtil.getLicenseConfig. return redisCache.");
                return LicenseCacheMrg.getCache((String)redisType, (String)key);
            }
            logger.debug("LicenseConfigUtil.getLicenseConfig. return localCache.");
            return CollectionUtils.isEmpty(licCtrlConfigLocalCacheMap) ? null : licCtrlConfigLocalCacheMap.get(key);
        }
        String load = LicenseCacheMrg.getCache((String)redisType, (String)"DATA_LOADED");
        if (StringUtils.isBlank((CharSequence)load)) {
            Map<String, String> licCtrlConfigLocalCacheMap;
            logger.info("LicenseConfigUtil.getLicenseConfig. redisCache is blank.");
            Map<String, String> map = licCtrlConfigLocalCacheMap = isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlConfig() : LicenseConfigLocalCache.getCurrCtrlConfig();
            if (CollectionUtils.isEmpty(licCtrlConfigLocalCacheMap)) {
                logger.info("LicenseConfigUtil.getLicenseConfig. localCache is blank.quickReloadLocalCache");
                boolean success = LicenseConfigUtil.quickReloadLocalCache();
                if (success) {
                    logger.info("LicenseConfigUtil.getLicenseConfig. quickReloadLocalCache. AsynchronousReloadRedisCache");
                    LicenseConfigUtil.AsynchronousReloadRedisCache(redisType);
                    Map<String, String> ctrlMap = isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlConfig() : LicenseConfigLocalCache.getCurrCtrlConfig();
                    logger.info("LicenseConfigUtil.getLicenseConfig. return localCache");
                    return CollectionUtils.isEmpty(ctrlMap) ? null : ctrlMap.get(key);
                }
                logger.info("LicenseConfigUtil.getLicenseConfig. quickReloadLocalCache fail.reloadRedisCache. ");
                LicenseConfigUtil.reloadRedisCache(redisType);
                logger.info("LicenseConfigUtil.getLicenseConfig.return redisCache");
                return LicenseCacheMrg.getCache((String)redisType, (String)key);
            }
            logger.info("LicenseConfigUtil.getLicenseConfig.return localCache");
            return CollectionUtils.isEmpty(licCtrlConfigLocalCacheMap) ? null : licCtrlConfigLocalCacheMap.get(key);
        }
        try (DLock dlock = DLock.createReentrant((String)("reloadLicConfigLocalCache_" + RequestContext.get().getAccountId()));){
            dlock.lock();
            logger.info("LicenseConfigUtil.getLicenseConfig,reloadLicConfigLocalCache");
            redisVersion = LicenseConfigUtil.getRedisVersion(redisType);
            String string = localCacheVersion = isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlVersion() : LicenseConfigLocalCache.getCurrCtrlVersion();
            if (!StringUtils.equals((CharSequence)redisVersion, (CharSequence)localCacheVersion) || null == redisVersion) {
                Map ctrlMap = LicenseCacheMrg.getCache((String)redisType);
                if (isLatestVersion) {
                    LicenseConfigLocalCache.putLatestCtrlConfig(ctrlMap);
                    if (null == redisVersion) {
                        redisVersion = DB.genStringId((String)"");
                        LicenseCacheMrg.setVersion((String)LicenseCacheMrg.getTypeLicenseConfigVersion((String)redisType), (String)redisVersion);
                    }
                    LicenseConfigLocalCache.putLatestCtrlVersion(redisVersion);
                } else {
                    LicenseConfigLocalCache.putCurrCtrlConfig(ctrlMap);
                    if (null == redisVersion) {
                        redisVersion = DB.genStringId((String)"");
                        LicenseCacheMrg.setVersion((String)LicenseCacheMrg.getTypeLicenseConfigVersion((String)redisType), (String)redisVersion);
                    }
                    LicenseConfigLocalCache.putCurrCtrlVersion(redisVersion);
                }
            }
        }
        logger.info("LicenseConfigUtil.getLicenseConfig. return localCache. redisVersion : " + redisVersion + " localCacheVersion : " + localCacheVersion);
        Map<String, String> ctrlMap = isLatestVersion ? LicenseConfigLocalCache.getLatestCtrlConfig() : LicenseConfigLocalCache.getCurrCtrlConfig();
        return CollectionUtils.isEmpty(ctrlMap) ? null : ctrlMap.get(key);
    }

    private static Callable<Map<String, Object>> reloadCtrlTask(String type) {
        return () -> {
            logger.info("LicenseConfigUtil.AsynchronousReloadRedisCache starting.");
            try (DLock dlock = DLock.createReentrant((String)("LicenseGroupConfig_" + RequestContext.get().getAccountId()));){
                dlock.lock();
                logger.info("LicenseConfigUtil.AsynchronousReloadRedisCache get lock.");
                String redisVersion = LicenseConfigUtil.getRedisVersion(type);
                String dataLoaded = LicenseCacheMrg.getCache((String)type, (String)"DATA_LOADED");
                if ((StringUtils.isBlank((CharSequence)redisVersion) || StringUtils.isBlank((CharSequence)dataLoaded)) && !LicenseCache.isCircuitBreaker("ctrl")) {
                    logger.info("LicenseConfigUtil.AsynchronousReloadRedisCache get lock. redisVersion \uff1a " + redisVersion + " dataLoaded : " + dataLoaded);
                    LicenseCache.reloadCtrlGroup();
                }
            }
            catch (Exception e) {
                logger.error("LicenseCache.getLicenseGroupCtrl error.", (Throwable)e);
            }
            return null;
        };
    }

    public static String getRedisVersion(String type) {
        return LicenseCacheMrg.getVersion((String)(type + "_VERSION"));
    }
}

