/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.license.LocalCache.LicEnvironLocalCache;
import kd.bos.license.UpdateLicGroupUser;
import kd.bos.license.bean.LicEnvironmentalInfo;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.config.AESUtil;
import kd.bos.license.pojo.LicenseGeneralSnapshot;
import kd.bos.license.pojo.LicenseSnapshot;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class LicenseEnvironmentUtil {
    private static Log logger = LogFactory.getLog(LicenseEnvironmentUtil.class);
    private static final String MODE_TYPE_K = "ModeType";
    private static final String TEM_LIC_K = "isTemLic";
    private static final String SHOW_WATER_MARK_K = "isShowWaterMark";
    private static final String SCENE_TYPE_K = "sceneType";
    private static final String SCENEDEPLOYMENT_STATUS_K_TYPE_K = "deploymentStatus";
    private static final String VERSION = "version";
    private static final String ENTITY_SNAPSHOT = "lic_snapshot";
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"LIC_ENV_POOL", (int)5);

    public static String getModeType() {
        LicEnvironmentalInfo licEnvironmentalInfo = LicenseEnvironmentUtil.getLicEnvironmentalInfoFromThreadCache();
        return null == licEnvironmentalInfo ? "3" : licEnvironmentalInfo.getModeType();
    }

    public static boolean isTemLic() {
        LicEnvironmentalInfo licEnvironmentalInfo = LicenseEnvironmentUtil.getLicEnvironmentalInfoFromThreadCache();
        return null == licEnvironmentalInfo ? false : licEnvironmentalInfo.isTemLic();
    }

    public static boolean isShowWaterMark() {
        LicEnvironmentalInfo licEnvironmentalInfo = LicenseEnvironmentUtil.getLicEnvironmentalInfoFromThreadCache();
        return null == licEnvironmentalInfo ? false : licEnvironmentalInfo.isShowWaterMark();
    }

    public static String getSceneType() {
        LicEnvironmentalInfo licEnvironmentalInfo = LicenseEnvironmentUtil.getLicEnvironmentalInfoFromThreadCache();
        return null == licEnvironmentalInfo ? "" : licEnvironmentalInfo.getSceneType();
    }

    private static LicEnvironmentalInfo getLicEnvironmentalInfoFromThreadCache() {
        RequestContext rc = RequestContext.get();
        String key = String.format("%s%s", "LicenseEnvironmentUtil#getLicEnvironmentalInfoFromThreadCache_", rc.getAccountId());
        return (LicEnvironmentalInfo)ThreadCache.get((Object)key, () -> LicenseEnvironmentUtil.getLicEnvironmentalInfo());
    }

    private static LicEnvironmentalInfo getLicEnvironmentalInfo() {
        String versionFromRedisCache = LicenseEnvironmentUtil.getVersionFromRedisCache();
        String verisonFromLocalCache = LicenseEnvironmentUtil.getVerisonFromLocalCache();
        logger.debug("LicenseEnvironmentUtil#getLicEnvironmentalInfo:versionFromRedisCache={},verisonFromLocalCache={}", (Object)versionFromRedisCache, (Object)verisonFromLocalCache);
        if (StringUtils.equals((CharSequence)versionFromRedisCache, (CharSequence)verisonFromLocalCache)) {
            LicEnvironmentalInfo environmentFromLocalCache = LicenseEnvironmentUtil.getEnvironmentFromLocalCache();
            logger.debug("LicenseEnvironmentUtil#getLicEnvironmentalInfo:environmentFromLocalCache={}", (Object)environmentFromLocalCache);
            if (null == environmentFromLocalCache) {
                Map<String, String> environmentFromRedisCache = LicenseEnvironmentUtil.getEnvironmentFromRedisCache();
                logger.debug("LicenseEnvironmentUtil#getLicEnvironmentalInfo:environmentFromRedisCache={}", environmentFromRedisCache);
                if (CollectionUtils.isEmpty(environmentFromRedisCache)) {
                    return LicenseEnvironmentUtil.reloadRedisCache(null);
                }
                return LicenseEnvironmentUtil.replaceLocalCache(environmentFromRedisCache);
            }
            return environmentFromLocalCache;
        }
        Map<String, String> environmentFromRedisCache = LicenseEnvironmentUtil.getEnvironmentFromRedisCache();
        logger.debug("LicenseEnvironmentUtil#getLicEnvironmentalInfo:environmentFromRedisCache={}", environmentFromRedisCache);
        if (CollectionUtils.isEmpty(environmentFromRedisCache)) {
            LicEnvironmentalInfo environmentFromLocalCache = LicenseEnvironmentUtil.getEnvironmentFromLocalCache();
            logger.debug("LicenseEnvironmentUtil#getLicEnvironmentalInfo:environmentFromLocalCache={}", (Object)environmentFromLocalCache);
            if (null == environmentFromLocalCache) {
                return LicenseEnvironmentUtil.reloadRedisCache(null);
            }
            THREAD_POOL.submit(LicenseEnvironmentUtil.reloadRedisCacheTask(), RequestContext.get());
            return environmentFromLocalCache;
        }
        return LicenseEnvironmentUtil.replaceLocalCache(environmentFromRedisCache);
    }

    private static Callable<Map<String, Object>> reloadRedisCacheTask() {
        return () -> {
            LicenseEnvironmentUtil.reloadRedisCache(null);
            return null;
        };
    }

    private static LicEnvironmentalInfo replaceLocalCache(Map<String, String> environmentFromRedisCache) {
        logger.info("LicenseEnvironmentUtil#replaceLocalCache:environmentFromRedisCache={}", environmentFromRedisCache);
        if (CollectionUtils.isEmpty(environmentFromRedisCache)) {
            return null;
        }
        LicEnvironmentalInfo licEnvironmentalInfo = new LicEnvironmentalInfo();
        try (DLock dlock = DLock.createReentrant((String)("replaceLocalCache_Environment" + RequestContext.get().getAccountId()));){
            dlock.lock();
            String versionFromRedisCache = LicenseEnvironmentUtil.getVersionFromRedisCache();
            LicEnvironmentalInfo environmentFromLocalCache = LicenseEnvironmentUtil.getEnvironmentFromLocalCache();
            if (StringUtils.equals((CharSequence)LicenseEnvironmentUtil.getVerisonFromLocalCache(), (CharSequence)LicenseEnvironmentUtil.getVersionFromRedisCache()) && !StringUtils.isBlank((CharSequence)versionFromRedisCache) && null != environmentFromLocalCache) {
                LicEnvironmentalInfo licEnvironmentalInfo2 = environmentFromLocalCache;
                return licEnvironmentalInfo2;
            }
            licEnvironmentalInfo.setModeType(environmentFromRedisCache.get(MODE_TYPE_K));
            licEnvironmentalInfo.setSceneType(environmentFromRedisCache.get(SCENE_TYPE_K));
            licEnvironmentalInfo.setTemLic(StringUtils.equals((CharSequence)environmentFromRedisCache.get(TEM_LIC_K), (CharSequence)"1"));
            licEnvironmentalInfo.setShowWaterMark(StringUtils.equals((CharSequence)environmentFromRedisCache.get(SHOW_WATER_MARK_K), (CharSequence)"1"));
            licEnvironmentalInfo.setDeploymentStatus(environmentFromRedisCache.get(SCENEDEPLOYMENT_STATUS_K_TYPE_K));
            LicEnvironLocalCache.setLicEnvironmentalInfo((LicEnvironmentalInfo)licEnvironmentalInfo);
            String version = environmentFromRedisCache.get(VERSION);
            if (null == version) {
                version = DB.genStringId((String)"");
                LicenseCacheMrg.putCache((String)LicenseCacheMrg.getLicEnvironmentalType(), (String)VERSION, (String)version);
            }
            LicEnvironLocalCache.setVersion((String)version);
        }
        return licEnvironmentalInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LicEnvironmentalInfo reloadRedisCache(String data) {
        boolean isTemporaryLicense = false;
        boolean isShowWaterMark = false;
        String sceneType = "";
        String modeType = "3";
        String deploymentStatus = LicenseServiceHelper.getPubTenantType();
        logger.debug("LicenseEnvironmentUtil#reloadRedisCache:data={},deploymentStatus={}", (Object)data, (Object)deploymentStatus);
        LicEnvironmentalInfo licEnvironmentalInfo = new LicEnvironmentalInfo(isTemporaryLicense, isShowWaterMark, sceneType, modeType, deploymentStatus);
        try (DLock dlock = DLock.createReentrant((String)("reloadenvironMentRedisCache" + RequestContext.get().getAccountId()));){
            dlock.lock();
            String versionFromRedisCache = LicenseEnvironmentUtil.getVersionFromRedisCache();
            boolean isBlankData = StringUtils.isBlank((CharSequence)data);
            if (!StringUtils.isBlank((CharSequence)versionFromRedisCache) && isBlankData) {
                LicEnvironmentalInfo licEnvironmentalInfo2 = LicenseEnvironmentUtil.getEnvironmentFromLocalCache();
                return licEnvironmentalInfo2;
            }
            if (isBlankData) {
                DynamicObjectCollection snapshotDoc = QueryServiceHelper.query((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
                if (null == snapshotDoc || snapshotDoc.isEmpty()) {
                    LicEnvironmentalInfo licEnvironmentalInfo3 = licEnvironmentalInfo;
                    return licEnvironmentalInfo3;
                }
                snapshotDoc.sort((o1, o2) -> {
                    int type1 = Integer.parseInt(o1.getString("snapshottype"));
                    int type2 = Integer.parseInt(o2.getString("snapshottype"));
                    return type1 - type2;
                });
                data = ((DynamicObject)snapshotDoc.get(snapshotDoc.size() - 1)).getString("data");
            }
            String snapshotStr = AESUtil.decrypt((String)data);
            LicenseGeneralSnapshot snapshot = null;
            logger.debug("LicenseEnvironmentUtil#reloadRedisCache:snapshotStr={}", (Object)snapshotStr);
            try {
                snapshot = (LicenseGeneralSnapshot)SerializationUtils.fromJsonString((String)snapshotStr, LicenseGeneralSnapshot.class);
            }
            catch (Exception e) {
                snapshot = (LicenseGeneralSnapshot)JSON.parseObject((String)snapshotStr, LicenseGeneralSnapshot.class);
            }
            if (null == snapshot) {
                throw new KDException("LicEnvironmentUtil.reloadRedisCache\uff1aLicenseSnapshots is Empty.");
            }
            isTemporaryLicense = snapshot.isTempLic();
            licEnvironmentalInfo.setTemLic(isTemporaryLicense);
            licEnvironmentalInfo.setShowWaterMark(snapshot.isShowWaterMark());
            sceneType = StringUtils.isBlank((CharSequence)snapshot.getSceneType()) && isTemporaryLicense ? "TEMP" : snapshot.getSceneType();
            licEnvironmentalInfo.setSceneType(sceneType);
            List licenseSnapshots = snapshot.getLicenseSnapshots();
            if (licenseSnapshots == null || licenseSnapshots.isEmpty()) {
                HashMap<String, String> envirment = new HashMap<String, String>(5);
                envirment.put(TEM_LIC_K, licEnvironmentalInfo.isTemLic() ? "1" : "0");
                envirment.put(MODE_TYPE_K, licEnvironmentalInfo.getModeType());
                envirment.put(SHOW_WATER_MARK_K, licEnvironmentalInfo.isShowWaterMark() ? "1" : "0");
                envirment.put(SCENE_TYPE_K, licEnvironmentalInfo.getSceneType() == null ? "" : sceneType);
                envirment.put(SCENEDEPLOYMENT_STATUS_K_TYPE_K, licEnvironmentalInfo.getDeploymentStatus());
                envirment.put(VERSION, DB.genStringId((String)""));
                LicenseCacheMrg.clearCache((String)LicenseCacheMrg.getLicEnvironmentalType());
                LicenseCacheMrg.putCache((String)LicenseCacheMrg.getLicEnvironmentalType(), envirment);
                LicEnvironmentalInfo licEnvironmentalInfo4 = licEnvironmentalInfo;
                return licEnvironmentalInfo4;
            }
            HashMap<String, String> licIsvprodMap = new HashMap<String, String>(16);
            Map licIsvprod = BusinessDataServiceHelper.loadFromCache((String)"lic_isvprod", (String)"id,producttag", null);
            if (null != licIsvprod && !licIsvprod.isEmpty()) {
                for (DynamicObject dynamicObject : licIsvprod.values()) {
                    licIsvprodMap.put(dynamicObject.getString("id"), dynamicObject.getString("producttag"));
                }
            }
            for (LicenseSnapshot licenseSnapshot : licenseSnapshots) {
                String prodid = licenseSnapshot.getProdid();
                String productTag = (String)licIsvprodMap.get(prodid);
                if ("SBOM-2022-1005".equals(productTag)) {
                    modeType = "2";
                    logger.info("\u661f\u7a7a\u65d7\u8230\u7248\u3002");
                    continue;
                }
                if (!"PN-05-2021-0006".equals(productTag) && !"PN-05-2023-0310".equals(productTag)) continue;
                modeType = "4";
                logger.info("\u65b0\u7248\u661f\u7a7a\u65d7\u8230\u7248\u3002");
            }
            licEnvironmentalInfo.setModeType(modeType);
            logger.debug("LicenseEnvironmentUtil#reloadRedisCache:modeType={}", (Object)modeType);
            HashMap<String, String> envirment = new HashMap<String, String>(5);
            envirment.put(TEM_LIC_K, licEnvironmentalInfo.isTemLic() ? "1" : "0");
            envirment.put(SHOW_WATER_MARK_K, licEnvironmentalInfo.isShowWaterMark() ? "1" : "0");
            envirment.put(SCENE_TYPE_K, licEnvironmentalInfo.getSceneType() == null ? "" : sceneType);
            envirment.put(MODE_TYPE_K, licEnvironmentalInfo.getModeType());
            envirment.put(VERSION, DB.genStringId((String)""));
            LicenseCacheMrg.clearCache((String)LicenseCacheMrg.getLicEnvironmentalType());
            LicenseCacheMrg.putCache((String)LicenseCacheMrg.getLicEnvironmentalType(), envirment);
        }
        catch (Exception e) {
            logger.error("LicEnvironmentalInfo.reloadRedisCache get license failed.", (Throwable)e);
        }
        RequestContext rc = RequestContext.get();
        String key = String.format("%s%s", "LicenseEnvironmentUtil#getLicEnvironmentalInfoFromThreadCache_", rc.getAccountId());
        ThreadCache.put((Object)key, (Object)licEnvironmentalInfo);
        return licEnvironmentalInfo;
    }

    private static void downloadAndUpdateLic(boolean isHighAvailabilityMode, LicenseSyncLog licenseSyncLog) {
        UpdateLicGroupUser updateLicGroupUser = new UpdateLicGroupUser();
        boolean updateLicenseResult = false;
        try {
            updateLicenseResult = updateLicGroupUser.downloadAndUpdateLicUser(true, licenseSyncLog, isHighAvailabilityMode);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (Throwable)e);
        }
        if (null != licenseSyncLog) {
            licenseSyncLog.setOperator(Long.valueOf(-10000L));
        }
        if (!updateLicenseResult) {
            logger.error("\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38");
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (String)"LicenseCache_0", (String)"bos-license-business", (Object[])new Object[0]));
        }
    }

    private static String getVersionFromRedisCache() {
        return LicenseCacheMrg.getCache((String)LicenseCacheMrg.getLicEnvironmentalType(), (String)VERSION);
    }

    private static Map<String, String> getEnvironmentFromRedisCache() {
        return LicenseCacheMrg.getCache((String)LicenseCacheMrg.getLicEnvironmentalType());
    }

    private static String getVerisonFromLocalCache() {
        return LicEnvironLocalCache.getVersion();
    }

    private static LicEnvironmentalInfo getEnvironmentFromLocalCache() {
        return LicEnvironLocalCache.getLicEnvironmentalInfo();
    }
}

