/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.LocalCache;

import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.license.bean.gray.GrayFeatureScheme;
import kd.bos.license.util.LicenseUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GrayFeatureLocalCache {
    static Log logger = LogFactory.getLog(GrayFeatureLocalCache.class);
    private static final CacheConfigInfo info = new CacheConfigInfo();
    private static final String REGION = "grayLicenseFeatureInfo";
    public static final String LOAD = "isloaded";
    private static final String ALL_GRAYFEATUREINFO_KEY = "allgrayfeatureinfo";

    public static void clear() {
        GrayFeatureLocalCache.getLocalCache().clear();
    }

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, RequestContext.get().getAccountId(), info);
    }

    public static Map<String, GrayFeatureScheme> getAllGrayFeatureInfo() {
        return (Map)GrayFeatureLocalCache.getLocalCache().get(ALL_GRAYFEATUREINFO_KEY);
    }

    public static void putAllGrayFeatureInfo(@NotNull Map<String, GrayFeatureScheme> grayFeatureInfos) {
        GrayFeatureLocalCache.getLocalCache().put(ALL_GRAYFEATUREINFO_KEY, grayFeatureInfos);
    }

    static {
        info.setTimeout(LicenseUtil.getLicenseLocalCacheTimeOut());
        info.setMaxItemSize(10000);
    }
}

