/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.HugeInConfig4DB;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.HttpClientUtils;

public class LicenseUtil {
    public static final String FILED_NUM = "fieldNum";
    public static final String FIELD = "field";
    private static final Log logger = LogFactory.getLog(LicenseUtil.class);

    public static boolean isHighAvailabilityMode() {
        return true;
    }

    public static boolean isHighAvailabilityModeFromThreadCache() {
        return true;
    }

    public static Map<String, String> getUniqueCharacteristic() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String tenantId = RequestContext.get().getTenantId();
        String property = System.getProperty(tenantId + "_license.uniquecharacteristic");
        if (property == null) {
            map.put(FILED_NUM, "username");
            map.put(FIELD, "fusername");
            return map;
        }
        switch (property) {
            case "email": {
                map.put(FILED_NUM, "email");
                map.put(FIELD, "femail");
                break;
            }
            case "phone": {
                map.put(FILED_NUM, "phone");
                map.put(FIELD, "fphone");
                break;
            }
            default: {
                map.put(FILED_NUM, "username");
                map.put(FIELD, "fusername");
            }
        }
        return map;
    }

    public static boolean isEnableAutoUpdateLicense() {
        boolean isEnableAutoUpdateLicense = true;
        String tenantId = RequestContext.get().getTenantId();
        if ("false".equals(System.getProperty(tenantId + "_license.autoupdatelicense"))) {
            isEnableAutoUpdateLicense = false;
        }
        return isEnableAutoUpdateLicense;
    }

    private static boolean isEnableSysParam(String sysParamKey) {
        Object isEnable = LicenseUtil.getParameterFromCache(sysParamKey);
        return isEnable != null && Boolean.parseBoolean(isEnable.toString());
    }

    private static Object getParameterFromCache(String key) {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
        appParam.setActBookId(Long.valueOf(0L));
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return paramMap == null ? null : paramMap.get(key);
    }

    public static boolean isEnableLegalPersonAssign() {
        return LicenseUtil.isEnableSysParam("legal_person_assign");
    }

    public static String getAccessToken4LicApi(String domainUrl, String tenantId, String accountId) throws Exception {
        String accessToken = "";
        try {
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("Content-type", "application/json");
            HashMap<String, String> body = new HashMap<String, String>(8);
            body.put("appId", "cosmic");
            body.put("appSecret", "Cosmic@#$123456789");
            body.put("tenantid", tenantId);
            body.put("accountId", accountId);
            body.put("language", "zh_CN");
            String responceStr = HttpClientUtils.postjson((String)(domainUrl + "api/getAppToken.do"), header, (String)JSON.toJSONString(body));
            Map responce = (Map)JSON.parseObject((String)responceStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            Map data = (Map)responce.get("data");
            String appToken = (String)data.get("app_token");
            body.put("user", "administrator");
            body.put("usertype", "UserName");
            body.put("apptoken", appToken);
            body.remove("appId");
            body.remove("appSecret");
            responceStr = HttpClientUtils.postjson((String)(domainUrl + "api/login.do"), header, (String)JSON.toJSONString(body));
            responce = (Map)JSON.parseObject((String)responceStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            data = (Map)responce.get("data");
            accessToken = (String)data.get("access_token");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6token\u5f02\u5e38\u3002", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38\u3002", (String)"LicenseUtil_0", (String)"bos-license-common", (Object[])new Object[0])), new Object[0]);
        }
        return accessToken;
    }

    public static String removeAllRegUsers(String licenseData) {
        if (!StringUtils.isBlank((CharSequence)licenseData)) {
            try {
                String patternStr = "\"regUsers\":\"\\{([\\s\\S]*?)\\}\"";
                Pattern pattern = Pattern.compile(patternStr);
                Matcher matcher = pattern.matcher(licenseData);
                licenseData = matcher.replaceAll("\"regUsers\":\"{}\"");
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u8bb8\u53ef\u63a7\u5236\u6e05\u5355\u51fa\u9519", (Throwable)e);
            }
        }
        return String.valueOf(licenseData);
    }

    public static int getOrmMaxObjectsCount() {
        int max = 1000000;
        try {
            max = Integer.parseInt(System.getProperty("orm_maxobjects", "1000000").trim());
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5b9e\u4f53\u4fdd\u5b58\u6700\u5927\u6570\u91cf\u53c2\u6570\u5931\u8d25\uff0c\u9ed8\u8ba41000000", (Throwable)e);
        }
        return max;
    }

    public static int getInMaxSize() {
        return HugeInConfig4DB.inMaxSize();
    }

    public static int getMaxMQPulishCount() {
        int limit = 52428821;
        try {
            limit = Integer.parseInt(System.getProperty("mq.message.payload", "52428800")) + 21;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6 mq.message.payload \u53c2\u6570\u5f02\u5e38\uff0c\u9ed8\u8ba4\u503c 52428821");
        }
        return limit;
    }

    public static int differentDays(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return -1;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 == year2) {
            int count = day2 - day1;
            return count >= 0 ? count : -1;
        }
        if (year2 > year1) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if ((i % 4 != 0 || i % 100 == 0) && i % 400 != 0) {
                    timeDistance += 365;
                    continue;
                }
                timeDistance += 366;
            }
            return timeDistance + (day2 - day1);
        }
        return -1;
    }

    public static boolean validDate(Date start, Date end, Date target) {
        if (start == null || end == null || target == null) {
            return false;
        }
        return start.before(target) && end.after(target);
    }

    public static Date getDateEndTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDateStartTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getCosmicVersion() {
        String sql = "select fid, fproductnumber, fversion, fupgradetime from t_bas_industry_version where fproductnumber = 'cosmic_bos';";
        String currVersion = "";
        try {
            currVersion = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, resultSet -> {
                while (resultSet.next()) {
                    if (!"cosmic_bos".equals(resultSet.getString("fproductnumber"))) continue;
                    return resultSet.getString("fversion");
                }
                return "";
            });
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u53d1\u5e03\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)e);
        }
        return currVersion;
    }

    public static boolean compareVersion(String version1, String version2) {
        if (StringUtils.isBlank((CharSequence)version1) || StringUtils.isBlank((CharSequence)version2)) {
            return false;
        }
        int n1 = version1.length();
        int n2 = version2.length();
        int i = 0;
        for (int j = 0; i < n1 || j < n2; ++i, ++j) {
            long v1 = 0L;
            long v2 = 0L;
            while (i < n1 && version1.charAt(i) != '.') {
                v1 = v1 * 10L + (long)(version1.charAt(i) - 48);
                ++i;
            }
            while (j < n2 && version2.charAt(j) != '.') {
                v2 = v2 * 10L + (long)(version2.charAt(j) - 48);
                ++j;
            }
            if (v1 > v2) {
                return true;
            }
            if (v1 >= v2) continue;
            return false;
        }
        return false;
    }

    public static boolean showCheckLogForm() {
        boolean showCheckLogForm = true;
        String tenantId = RequestContext.get().getTenantId();
        if ("false".equals(System.getProperty(tenantId + "_license.showchecklogform"))) {
            showCheckLogForm = false;
        }
        return showCheckLogForm;
    }

    public static int getLicenseLocalCacheTimeOut() {
        String timeOut = null;
        try {
            timeOut = System.getProperty("license.lctimeout", "31536000");
            return Integer.parseInt(timeOut);
        }
        catch (Exception e) {
            logger.error("getLicenseLocalCacheTimeOut error. lctimeout = " + timeOut, (Throwable)e);
            return 31536000;
        }
    }
}

