/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.action.api.operation;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.action.api.operation.upper.AbstractEntryApiOperation;
import kd.bos.openapi.action.util.DataMappingResult;
import kd.bos.openapi.action.util.DataMappingUtil;
import kd.bos.openapi.action.util.OpenApiSaveResultUtil;
import kd.bos.openapi.api.SaveApiService;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.openapi.api.params.ApiSaveParam;
import kd.bos.openapi.api.params.SaveParam;
import kd.bos.openapi.api.result.ApiSaveResult;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.base.model.ApiRequestModel;
import kd.bos.openapi.base.model.BaseApiParamModel;
import kd.bos.openapi.base.util.DynamicPropertyUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;
import org.apache.commons.codec.digest.DigestUtils;

public class ApiSave
extends AbstractEntryApiOperation<Void, ApiSaveResult> {
    private static final Log LOG = LogFactory.getLog(ApiSave.class);
    public static final int MAX_ENTITY_SIZE = 1000;

    public ApiSave(OpenApiRequest<Map<String, Object>> request) {
        super(request);
    }

    @Override
    public void validator() {
        super.validator();
        if (this.operations.getSave() == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"%s \u4e1a\u52a1\u5bf9\u8c61\u672a\u914d\u7f6e\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"ApiSave_2", (String)"bos-open-action", (Object[])new Object[]{this.api.getFormId()}), new Object[0]);
        }
        Integer maxEntitySize = this.api.getMaxEntrySize();
        if (maxEntitySize != 0 && this.countEntitySize() > maxEntitySize) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"%1$s \u5206\u5f55\u6570\u91cf\u8d85\u8fc7%2$s(\u6700\u5927\u9650\u5236\u6761\u6570)\u3002", (String)"ApiSave_1", (String)"bos-open-action", (Object[])new Object[0]), this.api.getFormId(), maxEntitySize), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiServiceData<ApiSaveResult> invoke(Void aVoid) {
        String inputPara;
        DataMappingResult mappingResult = DataMappingUtil.mapping((List)((List)this.dataPair.getValue()), (List)this.api.getRequestList(), (boolean)false);
        if (!mappingResult.isSuccess()) {
            ApiSaveResult errorResult = OpenApiSaveResultUtil.convent((List)((List)mappingResult.getError()), (String)this.api.getFormId());
            errorResult.setFailCount((long)((List)this.dataPair.getValue()).size());
            return ApiServiceData.of((boolean)false, (OpenApiResponse)new OpenApiResponse((Object)errorResult, null), (long)0L, (Throwable)new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, errorResult.fetchFirstErrorMessage(), new Object[0]));
        }
        List dataList = (List)mappingResult.getData();
        ApiSaveParam param = new ApiSaveParam(this.request);
        param.setFormId(this.api.getFormId());
        param.setDataList(dataList);
        param.setKeyMap(ApiSave.getJudgeKey(this.api.getRequestList()));
        param.setPlugins(this.getApiPlugin());
        param.setPluginOriginTypeMap(this.getPluginOriginTypeMap());
        if (StringUtil.isNotEmpty((String)this.api.getSaveParam())) {
            param.setSaveParam((SaveParam)JSON.parseObject((String)this.api.getSaveParam(), SaveParam.class));
        }
        if (StringUtil.isEmpty((String)(inputPara = OpenApiContext.getInputParameter()))) {
            inputPara = JsonUtil.toStringBySortField((Object)param.getDataList());
        }
        String hashKey = DigestUtils.sha256Hex((String)inputPara);
        String lockKey = RequestContext.get().getAccountId() + "_ChkRepSave_" + this.request.getServiceApiData().getApiId() + "_" + hashKey;
        DLock lock = DLock.create((String)lockKey, (String)("OpenApi.Save.CheckRepeatReq-" + this.request.getHttpRequestUrl() + "_" + hashKey));
        try {
            if (lock.tryLock(5000L)) {
                ApiServiceData apiServiceData = (ApiServiceData)DispatchApiServiceHelper.invokeApiService((String)SaveApiService.class.getSimpleName(), (Object[])new Object[]{param});
                return apiServiceData;
            }
            ApiServiceData apiServiceData = ApiServiceData.ofFalse((String)ApiErrorCode.Data_Repeat_Execute.getStatusCode(), (String)ApiErrorCode.Data_Repeat_Execute.toString(), (OpenApiResponse)new OpenApiResponse(), (long)0L);
            return apiServiceData;
        }
        finally {
            lock.unlock();
        }
    }

    public static Map<String, List<String>> getJudgeKey(List<ApiRequestModel> requestModels) {
        Map pidChildProp = requestModels.stream().filter(ApiRequestModel::isUniqueKey).collect(Collectors.groupingBy(BaseApiParamModel::getPid, Collectors.mapping(BaseApiParamModel::getPropName, Collectors.toSet())));
        Map pidPropName = requestModels.stream().filter(it -> pidChildProp.containsKey(it.getId())).collect(Collectors.toMap(BaseApiParamModel::getId, Function.identity()));
        HashMap<String, List<String>> judgeMap = new HashMap<String, List<String>>(16);
        for (Map.Entry entry : pidChildProp.entrySet()) {
            String keyMap;
            ApiRequestModel model = (ApiRequestModel)pidPropName.get(entry.getKey());
            if (model == null) {
                keyMap = "$";
            } else {
                if (!DynamicPropertyUtil.isEntry((String)model.getDataModel())) {
                    throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u5bf9\u8c61\u5c5e\u6027 %1$s \u4e0d\u80fd\u4f5c\u4e3a\u5019\u9009\u952e\uff0c\u539f\u56e0\uff1a\u5c5e\u6027 %2$s \u4e0d\u662f\u51c6\u5206\u5f55\u3002", (String)"ApiSave_0", (String)"bos-open-action", (Object[])new Object[0]), entry.getValue().toString(), model.getPropName()), new Object[0]);
                }
                keyMap = model.getPropName();
            }
            List list = judgeMap.computeIfAbsent(keyMap, k -> new ArrayList());
            for (String fullChildProp : entry.getValue()) {
                String childProp = "$".equals(keyMap) ? fullChildProp : fullChildProp.substring(keyMap.length() + 1);
                list.add(childProp);
            }
        }
        return judgeMap;
    }

    private int countEntitySize() {
        int total = 0;
        List entriesNames = this.api.getRequestList().stream().filter(it -> it.getLevel() == 1 && it.getParamType().equals("Entries")).map(it -> it.getParamName()).collect(Collectors.toList());
        List dataList = (List)this.dataPair.getValue();
        for (Map entry : dataList) {
            for (String entriesName : entriesNames) {
                if (entry.get(entriesName) instanceof Map) {
                    Map map = (Map)entry.get(entriesName);
                    total += map.size();
                    continue;
                }
                List entities = (List)entry.get(entriesName);
                if (entities == null) continue;
                total += entities.size();
            }
        }
        return total;
    }
}

