/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.action.api.operation.upper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.Operations;
import kd.bos.form.FormMetadataCache;
import kd.bos.openapi.action.api.operation.upper.AbstractApiOperation;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.base.model.ApiRequestModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;

public abstract class AbstractEntryApiOperation<BIN, IN>
extends AbstractApiOperation<BIN, IN> {
    private static final String BOS_OPEN_ACTION = "bos-open-action";
    protected Operations operations = this.initOperations();
    protected String filterStr;

    public AbstractEntryApiOperation(OpenApiRequest<Map<String, Object>> request) {
        super(request);
    }

    public void validator() {
        super.validator();
        String op = this.api.getOperation();
        if (ApiOperationType.SAVE.getOp().equalsIgnoreCase(op) || ApiOperationType.APPENDENTRYROWS.getOp().equalsIgnoreCase(op) || ApiOperationType.DELETEENTRYROWS.getOp().equalsIgnoreCase(op)) {
            return;
        }
        this.conditionCheck();
    }

    private void conditionCheck() {
        List requestList = this.api.getRequestList();
        if (CollectionUtil.isEmpty((Collection)requestList)) {
            return;
        }
        for (ApiRequestModel model : requestList) {
            boolean isAllNull;
            if (((Boolean)this.dataPair.getKey()).booleanValue()) {
                return;
            }
            List mapList = (List)this.dataPair.getValue();
            Map map = CollectionUtil.isEmpty((Collection)mapList) ? Collections.emptyMap() : (Map)mapList.get(0);
            Object value = map.get(model.getParamName());
            if (value instanceof List && model.isMustInput()) {
                isAllNull = true;
                for (Object v : (List)value) {
                    if (v instanceof String && !StringUtil.isNotEmpty((String)((String)v))) continue;
                    isAllNull = false;
                    break;
                }
                if (isAllNull) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u53c2\u6570\u3010%s\u3011\u5fc5\u586b\u3002", (String)"AbstractEntryApiOperation_0", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), model.getParamName()), new Object[0]);
                }
            }
            if (value == null && model.isMustInput()) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u53c2\u6570\u3010%s\u3011\u5fc5\u586b\u3002", (String)"AbstractEntryApiOperation_0", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), model.getParamName()), new Object[0]);
            }
            if ("*".equals(value)) {
                return;
            }
            if (value instanceof String && model.isMustInput() && StringUtil.isEmpty((String)((String)value))) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u53c2\u6570\u3010%s\u3011\u5fc5\u586b\u3002", (String)"AbstractEntryApiOperation_0", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), model.getParamName()), new Object[0]);
            }
            if (value instanceof String[] && model.isMustInput()) {
                isAllNull = true;
                for (String v : (String[])value) {
                    if (v instanceof String && !StringUtil.isNotEmpty((String)v)) continue;
                    isAllNull = false;
                    break;
                }
                if (isAllNull) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u53c2\u6570\u3010%s\u3011\u5fc5\u586b\u3002", (String)"AbstractEntryApiOperation_0", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), model.getParamName()), new Object[0]);
                }
            }
            DataType dataType = DataType.getByType((String)model.getParamType());
            try {
                dataType.validator(value);
            }
            catch (Exception e) {
                throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u53c2\u6570\u3010%1$s\u3011\u7684\u7c7b\u578b\u4e3a %2$s\uff0c\u800c\u4f20\u5165\u503c\u4e0d\u80fd\u8f6c\u6362\u4e3a\u8be5\u7c7b\u578b\u3002", (String)"AbstractEntryApiOperation_1", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), model.getParamName(), model.getParamType()), new Object[0]);
            }
        }
    }

    private Operations initOperations() {
        String entityTypeId = FormMetadataCache.getFormConfig((String)this.api.getFormId()).getEntityTypeId();
        return EntityMetadataCache.getDataEntityOperations((String)entityTypeId);
    }

    protected boolean hasOp(String op) {
        Map mapOp = EntityMetadataCache.getDataEntityOperate((String)this.api.getFormId(), (String)op);
        return !CollectionUtil.isEmpty((Map)mapOp);
    }

    protected List<String> getApiPlugin() {
        return this.api.getApiPlugin();
    }

    protected Map<String, Integer> getPluginOriginTypeMap() {
        return this.api.getPluginOriginTypeMap();
    }
}

