/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.api;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import kd.bos.config.client.util.StringUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.kcf.ServiceContext;
import kd.bos.kcf.ServiceType;
import kd.bos.kcf.message.HttpMethod;
import kd.bos.kcf.message.KRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.spi.OpenApiDataService;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.utils.IdempotencyUtil;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.api.ApiServiceLogHelper;
import kd.bos.web.api.OpenApiExceptionUtils;
import kd.bos.web.api.OpenApiLocalCache;
import kd.bos.web.api.OpenApiUtils;

public class CustomApiServiceType
extends ServiceType {
    private static final Log logger = LogFactory.getLog(CustomApiServiceType.class);
    private static final String BOS_WEBACTIONS = "bos-webactions";
    private static final String APPID = "appId";
    private static Set<String> ISIGNORELOG = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ServiceContext ctx) {
        long timeST = System.currentTimeMillis();
        AtomicReference apiserviceId = new AtomicReference();
        try {
            IdempotencyUtil.doIdempotency((HttpServletRequest)ctx.getRequest().getRequest(), (OpenApiData)ctx.getOpenApiData(), () -> {
                this.checkClientIP();
                String servicename = (String)ctx.getEnvVar("servicename");
                apiserviceId.set(OpenApiUtils.getApiserviceIdforCus((String)servicename));
                OpenApiUtils.checkACL((String)((String)apiserviceId.get()));
                String appId = (String)ctx.getEnvVar(APPID);
                if (!ISIGNORELOG.contains(servicename)) {
                    ApiServiceLogHelper.writeLog((String)appId, (String)servicename, (String)"CustomApi");
                }
                if (OpenApiUtils.checkHMApiforCus((String)servicename, (String)ctx.getRequest().getMethod().toString())) {
                    ctx.getResponse().fail(ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u201c\u8bf7\u6c42\u65b9\u5f0f\u201d\u4e0e\u8bbe\u7f6e\u7684\u4e0d\u5339\u914d\u3002", (String)"ApiServiceType_5", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
                    return null;
                }
                String failMessage = "";
                Boolean checkAppIsTrue = (Boolean)DispatchServiceHelper.invokeBOSService((String)"ApiService", (String)"checkAppByAppNumber", (Object[])new Object[]{appId});
                Boolean checkUserIsTrue = (Boolean)DispatchServiceHelper.invokeBOSService((String)"ApiService", (String)"checkApiUserIsTrue", (Object[])new Object[]{servicename});
                if (!checkUserIsTrue.booleanValue()) {
                    failMessage = ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u6b64\u63a5\u53e3\u8bbf\u95ee\u6743\u9650", (String)"CustomApiServiceType_0", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
                } else if (StringUtils.isNull((String)appId)) {
                    failMessage = ResManager.loadKDString((String)"\u8bf7\u6c42\u6d88\u606f\u4e2d\uff0c\u5fc5\u987b\u5305\u542bappid\u7684\u53c2\u6570\uff0c\u800c\u4e14\u4e0d\u80fd\u4e3a\u7a7a", (String)"CustomApiServiceType_1", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
                } else if (!checkAppIsTrue.booleanValue()) {
                    failMessage = String.format(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u6240\u5728\u5e94\u7528%S\u5df2\u88ab\u7981\u6b62\u8bbf\u95ee", (String)"CustomApiServiceType_2", (String)BOS_WEBACTIONS, (Object[])new Object[0]), appId);
                }
                if (!failMessage.isEmpty()) {
                    ctx.getResponse().fail(failMessage);
                } else {
                    Map map;
                    String svc = (String)ctx.getEnvVar("servicename");
                    String data = SerializationUtils.toJsonString(this.buildApiContext(ctx));
                    String ret = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"OperationWebApi", (String)"callCustomService", (Object[])new Object[]{appId, svc, data});
                    ApiServiceLogHelper.writeApiLogInfoApiResult((Object)ret);
                    if (StringUtils.isNotEmpty((String)ret) && !ret.startsWith("[") && (map = (Map)SerializationUtils.fromJsonString((String)ret, Map.class)) != null && map.get("httpStatus") != null) {
                        ctx.getResponse().setStatusCode(Integer.parseInt(String.valueOf(map.get("httpStatus"))));
                    }
                    ctx.getResponse().append(ret);
                }
                return null;
            });
        }
        catch (KDException e) {
            OpenApiExceptionUtils.dealThrowable((KDException)e, (ServiceContext)ctx);
        }
        catch (Exception ne) {
            String errorMessage = OpenApiExceptionUtils.getErrorMsg((Throwable)ne);
            ctx.getResponse().fail(errorMessage);
            logger.error(errorMessage, (Throwable)ne);
        }
        finally {
            int timeCost = (int)(System.currentTimeMillis() - timeST);
            ApiServiceLogHelper.writeApiLog((ServiceContext)ctx, (OpenApiData)OpenApiLocalCache.getOpenApiData((String)((String)apiserviceId.get())), (int)timeCost);
        }
    }

    private void checkClientIP() {
        OpenApiDataService openApiDataService = OpenApiDataServiceFactory.getOpenApiDataService();
        openApiDataService.checkClientIP();
    }

    private Map<String, Object> buildApiContext(ServiceContext ctx) {
        HashMap<String, Object> apiCtx = new HashMap<String, Object>();
        String data = ctx.getRequest().getReader().readBody();
        if (ctx.getRequest().getMethod() == HttpMethod.Get) {
            if (data != null && !"".equals(data)) {
                apiCtx.put("data", this.parseJsonByType(data, "queryString Map", Map.class));
            } else {
                apiCtx.put("data", ctx.getRequest().getReader().read());
            }
        } else {
            ApiServiceLogHelper.LogInfo((String)data);
            if (data != null && !"".equals(data)) {
                String contentType = ctx.getRequest() != null && ctx.getRequest().getRequest() != null ? ctx.getRequest().getRequest().getHeader("Content-Type") : "";
                boolean isJson = contentType != null ? contentType.contains("application/json") : false;
                String checkJsonHeader = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api1_checkjsonheader", "false");
                if ("true".equals(checkJsonHeader) && isJson || this.isJSONValid(data)) {
                    if (StringUtils.isNotEmpty((String)data) && data.startsWith("[")) {
                        apiCtx.put("data", this.parseJsonByType(data, "List", List.class));
                    } else {
                        apiCtx.put("data", this.parseJsonByType(data, "Map", Map.class));
                    }
                } else {
                    HashMap<String, String> req = new HashMap<String, String>();
                    req.put("request", data);
                    apiCtx.put("data", req);
                }
            }
        }
        String appId = this.getRequestHeader(ctx.getRequest(), APPID);
        if (StringUtils.isNotEmpty((String)appId)) {
            apiCtx.put(APPID, appId);
        }
        Map<String, String> headers = this.getRequestHeaders(ctx.getRequest().getRequest());
        apiCtx.put("requestHeaders", headers);
        String Cookie = this.getRequestHeader(ctx.getRequest(), "Cookie");
        if (StringUtils.isNotEmpty((String)Cookie)) {
            apiCtx.put("Cookie", Cookie);
        }
        apiCtx.put("queryString", ctx.getRequest().getParameters());
        apiCtx.put("requestURL", ctx.getRequest().getRelativeUrl());
        return apiCtx;
    }

    private <T> T parseJsonByType(String data, String tag, Class<T> type) {
        String tenantId;
        String JSON_CLASS = "openapi.v1.jsonClass";
        String JACKSON = "jackson";
        boolean isJackson = true;
        String string = tenantId = RequestContext.get() == null ? "" : RequestContext.get().getTenantId();
        if (StringUtil.isNotEmpty((String)tenantId)) {
            isJackson = JACKSON.equals(McConfigUtil.getPropertyByTenantWithDefault((String)tenantId, (String)JSON_CLASS, (String)JACKSON));
        }
        try {
            return (T)(isJackson ? SerializationUtils.fromJsonString((String)data, type) : JSON.parseObject((String)data, type));
        }
        catch (Exception var11) {
            int maxLength = 1500;
            String strMessage = "OperationWebApi-JSON data is invalid, error:" + var11.getMessage() + ",jsonData:" + (data.length() > maxLength ? data.substring(0, maxLength) : data);
            logger.error(strMessage, (Throwable)var11);
            throw new OpenApiException((Throwable)var11, ApiErrorCode.HTTP_BAD_REQUEST, strMessage, new Object[0]);
        }
    }

    private boolean isJSONValid(String data) {
        try {
            if (StringUtils.isNotEmpty((String)data) && data.startsWith("[")) {
                this.parseJsonByType(data, "List", List.class);
            } else {
                this.parseJsonByType(data, "Map", Map.class);
            }
            return true;
        }
        catch (Exception var3) {
            return false;
        }
    }

    private Map<String, String> getRequestHeaders(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        Enumeration headerNams = request.getHeaderNames();
        while (headerNams.hasMoreElements()) {
            String key = (String)headerNams.nextElement();
            String value = request.getHeader(key);
            map.put(key, value);
        }
        return map;
    }

    public void meta(ServiceContext ctx) {
        ctx.getResponse().success((Object)"meta");
    }

    private String getRequestHeader(KRequest request, String header) {
        String result = null;
        try {
            Class<?> krequest = Class.forName("kd.bos.kcf.message.KRequest");
            Method method = krequest.getDeclaredMethod("getHeader", String.class);
            ReflectionUtils.makeAccessible((Method)method);
            Object obj = method.invoke((Object)request, header);
            result = String.valueOf(obj);
            if (StringUtils.isNotEmpty((String)result) && result.endsWith(";")) {
                result = result.replace(result.charAt(result.length() - 1) + "", "");
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return result;
    }

    static {
        ISIGNORELOG.add("getRobertHome");
    }
}

