/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.isc.util.script.core.Reference;
import kd.bos.openapi.api.plugin.ApiDeserializerPlugin;
import kd.bos.openapi.api.plugin.ApiSerializerPlugin;
import kd.bos.openapi.base.model.ApiFilterModel;
import kd.bos.openapi.base.model.ApiRequestModel;
import kd.bos.openapi.base.model.ApiResourceModel;
import kd.bos.openapi.base.model.ApiResponseModel;
import kd.bos.openapi.base.model.BaseApiParamModel;
import kd.bos.openapi.base.script.OpenApiScript;
import kd.bos.openapi.base.script.OpenApiScriptUtil;
import kd.bos.openapi.base.script.resource.ResourceCategory;
import kd.bos.openapi.base.util.CompareTypeUtil;
import kd.bos.openapi.base.util.DynamicPropertyUtil;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.common.constant.ApiDefType;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.constant.HttpMethod;
import kd.bos.openapi.common.constant.PluginType;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.PluginInfo;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.common.util.PluginUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class ApiModel {
    private static final String BOS_OPEN_BASE = "bos-open-base";
    private static final String OPENAPI_APILIST = "openapi_apilist";
    private String formId;
    private String operation;
    private String operationType;
    private final HttpMethod httpMethod;
    private String orderBy;
    private final Set<String> selectSet;
    private final List<ApiRequestModel> requestList;
    private final Set<String> reqMulValParams;
    private final List<ApiResponseModel> responseList;
    private final DynamicObject api;
    private final long id;
    private final String number;
    private final String name;
    private final ILocaleString nameML;
    private final String appId;
    private final String appRealId;
    private String cloudId;
    private final String url;
    private final ApiServiceType apiServiceType;
    private String bizObject;
    private boolean isDyObjResult;
    private boolean isSerializeDefaultValue = false;
    private Set<String> querySelect;
    private String saveParam;
    private String className;
    private String methodName;
    private final String namespace;
    private final String wsInputParam;
    private final String wsOutputParam;
    private final ApiDefType apiDefType;
    private String plugintype;
    private boolean isOutParaWithoutStatus;
    private boolean isDesensitize;
    private OpenApiScript apiScript;
    private List<ApiResourceModel> resourceList;
    private Map<String, String> defaultHeaders;
    private static final Set<String> ignoreDefaultHeaders = new HashSet<String>(10);
    private String wsMethodName;
    private boolean orgAuthorFilter = false;
    private final List<String> apiPlugin;
    private Integer maxEntrySize;
    private final boolean checkRepeatReq;
    private String apiDeserializerPlugin;
    private String apiSerializerPlugin;
    private Map<String, Integer> pluginOriginTypeMap = new HashMap<String, Integer>(4);
    private boolean isMuliLang;
    private boolean isAsync;
    private String inDigestTemplate;
    private String outDigestTemplate;

    public boolean isDesensitize() {
        return this.isDesensitize;
    }

    public void setDesensitize(boolean desensitize) {
        this.isDesensitize = desensitize;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean async) {
        this.isAsync = async;
    }

    public String getWsMethodName() {
        return this.wsMethodName;
    }

    public ApiModel(DynamicObject api) {
        if (api == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"api \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApiModel_0", (String)BOS_OPEN_BASE, (Object[])new Object[0]), new Object[0]);
        }
        this.api = api;
        this.apiServiceType = ApiServiceType.get((int)api.getInt("apiservicetype"));
        this.httpMethod = HttpMethod.fromCode((String)api.getString("httpmethod"));
        this.requestList = this.initRequestModel();
        this.reqMulValParams = this.initReqMulValParams();
        this.responseList = this.initResponseModel();
        this.selectSet = this.initSelect();
        this.url = api.getString("urlformat");
        this.isAsync = api.getBoolean("isasync");
        this.id = api.getLong("id");
        this.number = api.getString("number");
        this.name = api.getString("name");
        this.nameML = api.getLocaleString("name");
        this.appId = api.getString("appid.number");
        this.appRealId = api.getString("appid.id");
        DynamicObject dynamicObject = api.getDynamicObject("appid.bizcloud");
        if (dynamicObject != null) {
            this.cloudId = dynamicObject.getString("number");
        }
        this.namespace = api.getString("namespace");
        this.wsInputParam = api.getString("wsinputparam");
        this.wsOutputParam = api.getString("wsoutputparam");
        this.apiDefType = ApiDefType.getApiDefType((String)api.getString("apideftype"));
        this.isOutParaWithoutStatus = api.getBoolean("isoutparawithoutstatus");
        Object maxEntrySizeStr = this.getValueFromExtEntry("maxsaveentrysize");
        this.maxEntrySize = DataUtil.i((Object)maxEntrySizeStr);
        this.checkRepeatReq = api.getBoolean("check_repeat_req");
        this.apiPlugin = this.initApiPlugin();
        this.inDigestTemplate = api.getString("indigesttemplate");
        this.outDigestTemplate = api.getString("outdigesttemplate");
        if (ApiServiceType.OPERATION == this.apiServiceType) {
            Object value;
            this.querySelect = this.initQuerySelect();
            this.formId = api.getString("bizobject_id");
            this.operation = api.getString("operation");
            if (StringUtil.isEmpty((String)this.operation)) {
                throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApiModel_1", (String)ResSystemType.ACTION.getType(), (Object[])new Object[0]), new Object[0]);
            }
            this.orderBy = this.initOrderBy();
            if (StringUtil.isEmpty((String)this.orderBy)) {
                this.orderBy = "id asc";
            }
            this.bizObject = api.getDynamicObject("bizobject") != null ? api.getDynamicObject("bizobject").getString("number") : null;
            this.saveParam = api.getString("saveoperation");
            if (ApiOperationType.QUERY.getOp().equalsIgnoreCase(this.operation)) {
                this.orgAuthorFilter = api.getBoolean("org_author_filter");
                this.isDyObjResult = api.getBoolean("isdyobjresult");
            }
            this.isDesensitize = api.getBoolean("isdesensitize");
            if (!(ApiOperationType.QUERY.getOp().equalsIgnoreCase(this.operation) || ApiOperationType.DELETEENTRYROWS.getOp().equalsIgnoreCase(this.operation) || ApiOperationType.APPENDENTRYROWS.getOp().equalsIgnoreCase(this.operation))) {
                Map opMap = EntityMetadataCache.getDataEntityOperate((String)this.formId, (String)this.operation);
                this.operationType = (String)opMap.get("type");
            }
            this.isMuliLang = (value = this.getValueFromExtEntry("ismulilang")) != null ? Boolean.parseBoolean(value.toString()) : false;
            Object isserializedefaultvalue = this.getValueFromExtEntry("isserializedefaultvalue");
            this.isSerializeDefaultValue = isserializedefaultvalue != null ? Boolean.parseBoolean(isserializedefaultvalue.toString()) : false;
        } else if (ApiServiceType.CUSTOM == this.apiServiceType || ApiServiceType.CUSTSERVLET == this.apiServiceType) {
            this.className = api.getString("classname");
            this.methodName = api.getString("methodname");
            this.wsMethodName = api.getString("wsmethodname");
            this.plugintype = api.getString("plugintype");
        } else if (ApiServiceType.SCRIPT == this.apiServiceType) {
            this.resourceList = this.initResourceModel();
            this.apiScript = this.initApiScript();
        }
        Map<String, String> headerdefaultvalues = ApiModel.getHeaderdefaultvalues(api);
        this.defaultHeaders = headerdefaultvalues;
    }

    private static Map<String, String> getHeaderdefaultvalues(DynamicObject api) {
        DynamicObjectCollection headerentryentity = (DynamicObjectCollection)api.get("headerentryentity");
        if (null == headerentryentity || headerentryentity.isEmpty()) {
            return null;
        }
        HashMap<String, String> headerdefaultvalues = new HashMap<String, String>();
        headerentryentity.forEach(c -> {
            String headname = c.getString("headername");
            if (ignoreDefaultHeaders.contains(headname)) {
                return;
            }
            String headDefaultName = c.getString("headerdefaultvalue");
            if (StringUtil.isNotEmpty((String)headDefaultName)) {
                headerdefaultvalues.put(headname, headDefaultName);
            }
        });
        return headerdefaultvalues;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public DynamicObject getApi() {
        return this.api;
    }

    public String getFormId() {
        return this.formId;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public void setDefaultHeaders(Map<String, String> headers) {
        this.defaultHeaders = headers;
    }

    public String getInDigestTemplate() {
        return this.inDigestTemplate;
    }

    public void setInDigestTemplate(String inDigestTemplate) {
        this.inDigestTemplate = inDigestTemplate;
    }

    public String getOutDigestTemplate() {
        return this.outDigestTemplate;
    }

    public void setOutDigestTemplate(String outDigestTemplate) {
        this.outDigestTemplate = outDigestTemplate;
    }

    public List<ApiRequestModel> getRequestList() {
        return this.requestList;
    }

    public List<ApiResponseModel> getResponseList() {
        return this.responseList;
    }

    public List<ApiFilterModel> getFilterList() {
        List<ApiFilterModel> filterList = (List<ApiFilterModel>)LocalCacheUtil.getCacheByKey((String)"kd.bos.openapi.base.model.ApiFilterModel", (String)this.url);
        if (filterList != null) {
            return filterList;
        }
        filterList = this.initFilter();
        LocalCacheUtil.setCacheByKey((String)"kd.bos.openapi.base.model.ApiFilterModel", (String)this.url, filterList);
        return filterList;
    }

    public long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public ILocaleString getNameML() {
        return this.nameML;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppRealId() {
        return this.appRealId;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public String getUrl() {
        return this.url;
    }

    public ApiServiceType getApiServiceType() {
        return this.apiServiceType;
    }

    public String getBizObject() {
        return this.bizObject;
    }

    public boolean isDyObjResult() {
        return this.isDyObjResult;
    }

    public boolean isSerializeDefaultValue() {
        return this.isSerializeDefaultValue;
    }

    public boolean isOutParaWithoutStatus() {
        return this.isOutParaWithoutStatus;
    }

    public Set<String> getSelectSet() {
        return this.selectSet;
    }

    private HttpMethod initHttpMethod() {
        int method = this.api.getInt("httpmethod");
        if (HttpMethod.GET.ordinal() == method) {
            return HttpMethod.GET;
        }
        if (HttpMethod.POST.ordinal() == method) {
            return HttpMethod.POST;
        }
        throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u9519\u8bef\u7684\u8bf7\u6c42\u65b9\u5f0f\uff1a%d\u3002", (String)"ApiModel_1", (String)BOS_OPEN_BASE, (Object[])new Object[0]), new Object[]{method});
    }

    private String initOrderBy() {
        StringBuilder orderBy = new StringBuilder();
        DynamicObjectCollection orderEntry = this.api.getDynamicObjectCollection("orderby_entry");
        for (DynamicObject object : orderEntry) {
            orderBy.append(orderBy.length() == 0 ? "" : ",");
            orderBy.append(object.getString("order_field")).append(' ').append(object.getString("order_mode"));
        }
        return orderBy.toString();
    }

    private List<ApiRequestModel> initRequestModel() {
        DynamicObjectCollection collection = this.api.getDynamicObjectCollection("bodyentryentity");
        ArrayList<ApiRequestModel> list = new ArrayList<ApiRequestModel>(collection.size());
        for (DynamicObject entry : collection) {
            list.add(new ApiRequestModel(entry, this.apiServiceType));
        }
        return list;
    }

    private Set<String> initReqMulValParams() {
        Map mulValPidMap = this.apiServiceType == ApiServiceType.OPERATION ? this.requestList.stream().filter(it -> DataType.ENTRIES.type().equals(it.getParamType()) || DataType.isArray((String)it.getParamType())).collect(Collectors.groupingBy(BaseApiParamModel::getPid, Collectors.mapping(BaseApiParamModel::getParamName, Collectors.toSet()))) : this.requestList.stream().filter(BaseApiParamModel::isMulValue).collect(Collectors.groupingBy(BaseApiParamModel::getPid, Collectors.mapping(BaseApiParamModel::getParamName, Collectors.toSet())));
        if (CollectionUtil.isEmpty(mulValPidMap)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(16);
        Map<Long, ApiRequestModel> idMap = this.requestList.stream().collect(Collectors.toMap(BaseApiParamModel::getId, Function.identity()));
        for (Map.Entry entry : mulValPidMap.entrySet()) {
            Long pid = entry.getKey();
            Set paramNames = entry.getValue();
            if (pid == 0L) {
                result.addAll(paramNames);
                continue;
            }
            for (String paramName : paramNames) {
                result.add(this.getParentParamName(pid, idMap) + paramName);
            }
        }
        return result;
    }

    public String getParentParamName(Long pid, Map<Long, ApiRequestModel> idMap) {
        if (pid == 0L) {
            return "";
        }
        ApiRequestModel model = idMap.get(pid);
        if (model == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570ID\u503c\u4e3a[ %d ]\u7684\u5c5e\u6027\u672a\u627e\u5230\u4e0a\u7ea7\uff0c\u8bf7\u68c0\u67e5API\u914d\u7f6e\u662f\u5426\u6b63\u5e38\u3002", (String)"ApiModel_2", (String)BOS_OPEN_BASE, (Object[])new Object[0]), pid));
        }
        String fullParentParamName = model.getParamName() + ".";
        String parent = this.getParentParamName(model.getPid(), idMap);
        if (!StringUtil.isEmpty((String)parent)) {
            fullParentParamName = parent + fullParentParamName;
        }
        return fullParentParamName;
    }

    private List<ApiResponseModel> initResponseModel() {
        DynamicObjectCollection collection = this.api.getDynamicObjectCollection("respentryentity");
        ArrayList<ApiResponseModel> list = new ArrayList<ApiResponseModel>(collection.size());
        for (DynamicObject entry : collection) {
            list.add(new ApiResponseModel(entry, this.apiServiceType));
        }
        return list;
    }

    private List<ApiFilterModel> initFilter() {
        DynamicObjectCollection filterEntry = this.api.getDynamicObjectCollection("filter_entity");
        ArrayList<ApiFilterModel> rows = new ArrayList<ApiFilterModel>(filterEntry.size());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.formId);
        for (DynamicObject entry : filterEntry) {
            ApiFilterModel row = new ApiFilterModel();
            row.setEntityNumber(this.formId);
            row.setLeftBracket(entry.getString("filter_left_bracket"));
            String filterColumn = entry.getString("filter_column");
            row.setFieldName(filterColumn);
            CompareTypeEnum typeEnum = CompareTypeEnum.valueOf((String)entry.getString("filter_compare"));
            row.setCompareType(CompareTypeUtil.getCompareType((CompareTypeEnum)typeEnum, (FilterField)FilterField.create((MainEntityType)entityType, (String)filterColumn)));
            row.setFilterValue(entry.getString("filter_value"));
            row.setRightBracket(entry.getString("filter_right_bracket"));
            row.setLogic(entry.getString("filter_link"));
            String filterConstant = entry.getString("filter_constant");
            if (StringUtil.isNotEmpty((String)filterConstant)) {
                try {
                    row.setConstantValue(JsonUtil.parseJson((String)filterConstant));
                }
                catch (Exception e) {
                    throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5 %s \u7684\u6bd4\u8f83\u5e38\u91cf\u503c\u89e3\u6790\u5931\u8d25\u3002", (String)"ApiModel_3", (String)BOS_OPEN_BASE, (Object[])new Object[0]), filterColumn), new Object[0]);
                }
            }
            rows.add(row);
        }
        return rows;
    }

    private Set<String> initQuerySelect() {
        Set mbId = this.getResponseList().stream().filter(it -> DynamicPropertyUtil.isMb((String)it.getDataModel())).map(it -> new Pair((Object)it.getId(), (Object)it.getPropName())).collect(Collectors.toSet());
        Set<String> selectSet = this.getResponseList().stream().filter(it -> !DynamicPropertyUtil.isComBoFieldTitle((String)it.getDataModel())).map(it -> {
            Optional<Pair> mb = mbId.stream().filter(p -> ((Long)p.getKey()).equals(it.getPid())).findFirst();
            if (it.getPropName().contains(".") && mb.isPresent()) {
                int lastIndexOf = ((String)mb.get().getValue()).length();
                return it.getPropName().substring(0, lastIndexOf) + "." + "fbasedataid" + it.getPropName().substring(lastIndexOf);
            }
            return it.getPropName();
        }).collect(Collectors.toSet());
        selectSet.addAll(mbId.stream().map(it -> (String)it.getValue() + "." + "id").collect(Collectors.toSet()));
        return selectSet;
    }

    public Set<String> getQuerySelect() {
        return this.querySelect;
    }

    public String getSaveParam() {
        return this.saveParam;
    }

    private Set<String> initSelect() {
        DynamicObjectCollection respCollection = this.api.getDynamicObjectCollection("respentryentity");
        LinkedHashSet<String> set = new LinkedHashSet<String>(respCollection.size());
        HashSet<Pair> mbSet = new HashSet<Pair>();
        HashSet<Pair> pidSubEntrySet = new HashSet<Pair>();
        for (DynamicObject resp : respCollection) {
            Optional<String> pp;
            if (StringUtil.isEmpty((String)resp.getString("respparamname"))) continue;
            String respObjPropName = "";
            if (ApiServiceType.CUSTOM != this.apiServiceType && ApiServiceType.CUSTSERVLET != this.apiServiceType) {
                respObjPropName = resp.getString("respobjpropname");
            }
            Optional<String> subEntryProp = pidSubEntrySet.stream().filter(it -> it.getKey().equals(resp.get("pid"))).map(Pair::getValue).findFirst();
            Optional<String> mbProp = mbSet.stream().filter(it -> it.getKey().equals(resp.get("pid"))).map(Pair::getValue).findFirst();
            String respDataModel = resp.getString("resp_data_model");
            if (DynamicPropertyUtil.isMb((String)respDataModel)) {
                mbSet.add(new Pair(resp.get("id"), (Object)respObjPropName));
                set.add(respObjPropName);
                set.add(respObjPropName + "." + "id");
                set.add(respObjPropName + "." + "fbasedataid");
                continue;
            }
            if (DynamicPropertyUtil.isEntry((String)respDataModel)) {
                set.add(respObjPropName);
                set.add(respObjPropName + "." + "id");
                if (!SubEntryProp.class.getSimpleName().equals(respDataModel) && !LinkEntryProp.class.getSimpleName().equals(respDataModel)) continue;
                pidSubEntrySet.add(new Pair(resp.get("id"), (Object)respObjPropName));
                String sub = respObjPropName.substring(respObjPropName.lastIndexOf(46) + 1);
                set.add(sub);
                set.add(sub + "." + "id");
                continue;
            }
            set.add(respObjPropName);
            if (subEntryProp.isPresent()) {
                set.add(respObjPropName.substring(subEntryProp.get().lastIndexOf(46) + 1));
                continue;
            }
            if (!mbProp.isPresent()) continue;
            int lastIndexOf = mbProp.get().length();
            String parentName = respObjPropName.substring(0, lastIndexOf);
            String leafName = respObjPropName.substring(lastIndexOf + 1);
            set.add(parentName);
            set.add(parentName + "." + "fbasedataid");
            set.add(parentName + "." + "fbasedataid" + "." + leafName);
            Optional<DynamicObject> parent = respCollection.stream().filter(it -> it.get("id").equals(resp.get("pid"))).findFirst();
            if (!parent.isPresent() || !(pp = pidSubEntrySet.stream().filter(it -> it.getKey().equals(((DynamicObject)parent.get()).get("pid"))).map(Pair::getValue).findFirst()).isPresent()) continue;
            parentName = parentName.substring(pp.get().indexOf(46) + 1);
            set.add(parentName + "." + "fbasedataid");
            set.add(parentName + "." + "fbasedataid" + "." + leafName);
        }
        return set;
    }

    private Object getValueFromExtEntry(String key) {
        DynamicObjectCollection extEntity = this.api.getDynamicObjectCollection("extentity");
        if (CollectionUtils.isEmpty((Collection)extEntity)) {
            return null;
        }
        Object value = null;
        for (DynamicObject obj : extEntity) {
            if (!key.equals(obj.getString("ext_key"))) continue;
            value = obj.get("ext_value");
            break;
        }
        return value;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getWsInputParam() {
        return this.wsInputParam;
    }

    public String getWsOutputParam() {
        return this.wsOutputParam;
    }

    public ApiDefType getApiDefType() {
        return this.apiDefType;
    }

    public OpenApiScript getInScript() {
        return null;
    }

    public OpenApiScript getOutScript() {
        return null;
    }

    public OpenApiScript getApiScript() {
        return this.apiScript;
    }

    private OpenApiScript getScript(String scriptTag) {
        String script = this.api.getString(scriptTag);
        if (StringUtil.isEmpty((String)script)) {
            return null;
        }
        OpenApiScript apiScript = OpenApiScript.compile((String)script);
        if (OpenApiScriptUtil.isEmptyScript((OpenApiScript)apiScript)) {
            return null;
        }
        return apiScript;
    }

    private OpenApiScript initApiScript() {
        String script = this.api.getString("prescript_tag");
        HashMap<String, Object> ctx = new HashMap<String, Object>(16);
        for (ApiResourceModel apiResourceModel : this.resourceList) {
            ctx.put(apiResourceModel.getResAlias(), ResourceCategory.valueOf((String)apiResourceModel.getResCategory()).createResource(apiResourceModel.getResRef(), apiResourceModel.getResAlias()));
        }
        for (ApiRequestModel apiRequestModel : this.requestList) {
            ctx.put(apiRequestModel.getParamName(), Reference.create((String)apiRequestModel.getParamName()));
        }
        for (ApiResponseModel apiResponseModel : this.responseList) {
            ctx.put(apiResponseModel.getParamName(), Reference.create((String)apiResponseModel.getParamName()));
        }
        OpenApiScript apiScript = OpenApiScript.compile((String)script, ctx);
        if (OpenApiScriptUtil.isEmptyScript((OpenApiScript)apiScript)) {
            return null;
        }
        return apiScript;
    }

    private List<ApiResourceModel> initResourceModel() {
        DynamicObjectCollection collection = this.api.getDynamicObjectCollection("resourceentity");
        ArrayList<ApiResourceModel> list = new ArrayList<ApiResourceModel>(collection.size());
        for (DynamicObject entry : collection) {
            list.add(new ApiResourceModel(entry));
        }
        return list;
    }

    public Set<String> getReqMulValParams() {
        return this.reqMulValParams;
    }

    public boolean isOrgAuthorFilter() {
        return this.orgAuthorFilter;
    }

    private List<String> initApiPlugin() {
        Object hiddenPlugin = this.getValueFromExtEntry("hiddenplugin");
        String pluginInfoStr = DataUtil.s((Object)hiddenPlugin);
        if (StringUtil.isEmpty((String)pluginInfoStr)) {
            return Collections.emptyList();
        }
        List pluginDescriptions = PluginUtil.getPluginInfo((String)pluginInfoStr);
        ArrayList<String> plugins = new ArrayList<String>(pluginDescriptions.size());
        for (PluginInfo pluginDes : pluginDescriptions) {
            Integer originType;
            if (pluginDes == null) continue;
            String className = pluginDes.getClassName();
            if (pluginDes.getTypes().contains(PluginType.ApiPlugin)) {
                plugins.add(className);
            }
            if (pluginDes.getTypes().contains(PluginType.ApiSerializerPlugin)) {
                if (this.apiSerializerPlugin != null) {
                    throw new UnsupportedOperationException("only supported one plugin implement " + ApiSerializerPlugin.class.getSimpleName());
                }
                this.apiSerializerPlugin = className;
            }
            if (pluginDes.getTypes().contains(PluginType.ApiDeserializerPlugin)) {
                if (this.apiDeserializerPlugin != null) {
                    throw new UnsupportedOperationException("only supported one plugin implement " + ApiDeserializerPlugin.class.getSimpleName());
                }
                this.apiDeserializerPlugin = className;
            }
            if ((originType = pluginDes.getOriginType()) == null) continue;
            this.pluginOriginTypeMap.put(className, originType);
        }
        return plugins;
    }

    public List<String> getApiPlugin() {
        return this.apiPlugin;
    }

    public Integer getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public boolean isCheckRepeatReq() {
        return this.checkRepeatReq;
    }

    public String getApiDeserializerPlugin() {
        return this.apiDeserializerPlugin;
    }

    public String getApiSerializerPlugin() {
        return this.apiSerializerPlugin;
    }

    public boolean isMuliLang() {
        return this.isMuliLang;
    }

    public void setMuliLang(boolean muliLang) {
        this.isMuliLang = muliLang;
    }

    public String getPlugintype() {
        return this.plugintype;
    }

    public void setPlugintype(String plugintype) {
        this.plugintype = plugintype;
    }

    public Map<String, Integer> getPluginOriginTypeMap() {
        return this.pluginOriginTypeMap;
    }

    public void setPluginOriginTypeMap(Map<String, Integer> pluginOriginTypeMap) {
        this.pluginOriginTypeMap = pluginOriginTypeMap;
    }

    static {
        ignoreDefaultHeaders.add("accessToken");
        ignoreDefaultHeaders.add("Idempotency-Key");
    }
}

