/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service;

import com.alibaba.fastjson.JSONException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.ApiService;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.openapi.api.params.ApiParam;
import kd.bos.openapi.api.plugin.upper.ApiPlugin;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.base.custom.cache.CustomApiCacheUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.script.ProjectInitializerManager;
import kd.sdk.kingscript.host.ScriptProxyFactory;

public abstract class AbstractApiService<P extends ApiParam<?, ? extends ApiPlugin>, R>
implements ApiService<P, R> {
    private static final Log LOG = LogFactory.getLog(AbstractApiService.class);

    public ApiServiceData<R> execute(P param) {
        if (McConfigUtil.needWriteLogDetail()) {
            LOG.info("API_SERVICE:InstanceId:{}, TraceId:{}, API:{}", new Object[]{Instance.getInstanceId(), RequestContext.get().getTraceId(), param.getRequest().getServiceApiData().getUrl()});
        }
        ServiceApiContext preServiceApiContext = ServiceApiContext.getContext();
        ServiceApiContext serviceApiContext = new ServiceApiContext(param.getRequest(), new OpenApiResponse());
        ServiceApiContext.set((ServiceApiContext)serviceApiContext);
        try {
            ApiServiceData result = this.doExecute((ApiParam)param);
            result.setPluginInstanceId(Instance.getInstanceId());
            ApiServiceData apiServiceData = result;
            return apiServiceData;
        }
        catch (JSONException ex) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ex.getMessage(), new Object[0]);
        }
        finally {
            ServiceApiContext.close();
            if (preServiceApiContext != null) {
                ServiceApiContext.set((ServiceApiContext)preServiceApiContext);
            }
        }
    }

    public <Plugin> List<Plugin> getPlugin(P param) {
        List plugins = param.getPlugins();
        ArrayList<Object> res = new ArrayList<Object>(4);
        Map pluginOriginTypeMap = param.getPluginOriginTypeMap();
        for (String plugin : plugins) {
            Integer type = (Integer)pluginOriginTypeMap.get(plugin);
            if (type != null && 4 == type) {
                res.add(ScriptProxyFactory.createPluginProxy((String)plugin, ProjectInitializerManager::getEngineAutoDebug));
                continue;
            }
            res.add(CustomApiCacheUtil.getOrRegisterSingletonInstance((String)plugin));
        }
        return res;
    }
}

