/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.custom;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.api.CustomApiService;
import kd.bos.openapi.api.params.ApiCustomParam;
import kd.bos.openapi.api.plugin.ApiDeserializerPlugin;
import kd.bos.openapi.api.plugin.ApiSerializerPlugin;
import kd.bos.openapi.api.plugin.upper.ApiPlugin;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.base.custom.cache.CustomApiCacheUtil;
import kd.bos.openapi.base.custom.info.CustomApiInfo;
import kd.bos.openapi.base.custom.info.CustomApiParam;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.service.AbstractApiService;
import kd.bos.openapi.service.custom.CustomApiParseUtil;
import kd.bos.openapi.service.custom.SpringUtil;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.script.ProjectInitializerManager;
import kd.sdk.kingscript.host.ScriptProxyFactory;

public class CustomApiServiceImpl
extends AbstractApiService<ApiCustomParam, Object>
implements CustomApiService {
    public ApiServiceData<Object> doExecute(ApiCustomParam param) {
        return SpringUtil.invoke((ApiCustomParam)param);
    }

    public static CustomApiInfo getCustomApiInfo(String className, String methodName) {
        return CustomApiParseUtil.getCustomApiInfo((String)className, (String)methodName);
    }

    public static Set<String> getMethodNames(String className) {
        return CustomApiParseUtil.getMethodNames((String)className);
    }

    public static List<CustomApiParam> getRequest(String className, String methodName) {
        return CustomApiParseUtil.getRequest((String)className, (String)methodName);
    }

    public static List<CustomApiParam> getResponse(String className, String methodName) {
        return CustomApiParseUtil.getResponse((String)className, (String)methodName);
    }

    public Object getInstance(String className) {
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        Class pluginClass = CustomApiCacheUtil.getOrRegister((String)className);
        return CustomApiCacheUtil.getOrRegisterSingletonInstance((Class)pluginClass);
    }

    public Object getPluginInstance(String className) {
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        Class pluginClass = CustomApiCacheUtil.getOrRegister((String)className);
        if (!(ApiPlugin.class.isAssignableFrom(pluginClass) || ApiDeserializerPlugin.class.isAssignableFrom(pluginClass) || ApiSerializerPlugin.class.isAssignableFrom(pluginClass))) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"%1$s\u63d2\u4ef6\u5fc5\u987b\u5b9e\u73b0 ApiXXXPlugin \u6216 ApiSerializerPlugin \u6216 ApiDeserializerPlugin \u63a5\u53e3\u3002", (String)"AbstractSaveService_15", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[0]), new Object[]{pluginClass.getName()});
        }
        return CustomApiCacheUtil.getOrRegisterSingletonInstance((Class)pluginClass);
    }

    public Class<?> getClass(String className) {
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        return CustomApiCacheUtil.getOrRegister((String)className);
    }

    public Object invokePlugin(String className, String methodName, Object ... params) {
        return this.invokePlugin(className, methodName, null, params);
    }

    public Object invokePlugin(String className, String methodName, Integer pluginOriginType, Object ... params) {
        Object instance = pluginOriginType != null && 4 == pluginOriginType ? ScriptProxyFactory.createPluginProxy((String)className, ProjectInitializerManager::getEngineAutoDebug) : CustomApiCacheUtil.getOrRegisterSingletonInstance((String)className);
        LinkedHashMap methodMap = Arrays.stream(ReflectionUtils.getAllDeclaredMethods(instance.getClass())).filter(it -> it.getName().equals(methodName) && it.getParameterCount() == (params == null ? 0 : params.length)).collect(Collectors.groupingBy(Method::getDeclaringClass, LinkedHashMap::new, Collectors.toList()));
        if (methodMap.isEmpty()) {
            throw new OpenApiException(ApiErrorCode.PLUGIN_ERROR, className + "#" + methodName + " not found.", new Object[0]);
        }
        List methods = (List)methodMap.entrySet().iterator().next().getValue();
        if (methods.size() != 1) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u7c7b %1$s \u4e2d\u627e\u5230\u591a\u4e2a\u540c\u540d\u65b9\u6cd5 %2$s", (String)"CustomApiParseUtil_16", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[0]), new Object[]{instance.getClass().getName(), methodName});
        }
        Method method = (Method)methods.get(0);
        Object[] args = params == null ? new Object[]{} : params;
        return ReflectionUtils.invokeMethod((Method)method, (Object)instance, (Object[])args);
    }

    public Map<Class<?>, Boolean> getApiPluginResult(String operation, String className) {
        return this.getApiPluginResult(operation, className, null);
    }

    public Map<Class<?>, Boolean> getApiPluginResult(String operation, String className, Integer pluginType) {
        Class<?> aClass;
        if (pluginType != null && 4 == pluginType) {
            Object pluginProxy = ScriptProxyFactory.createPluginProxy((String)className, ProjectInitializerManager::getEngineAutoDebug);
            aClass = pluginProxy.getClass();
        } else {
            aClass = this.getClass(className);
        }
        HashMap result = new HashMap(16);
        if (StringUtil.isNotEmpty((String)operation)) {
            ApiOperationType curOpt = ApiOperationType.getTypeByOp((String)operation);
            Class pluginClass = curOpt.getPluginClass();
            result.put(pluginClass, pluginClass.isAssignableFrom(aClass));
        }
        result.put(ApiSerializerPlugin.class, ApiSerializerPlugin.class.isAssignableFrom(aClass));
        result.put(ApiDeserializerPlugin.class, ApiDeserializerPlugin.class.isAssignableFrom(aClass));
        return result;
    }

    public static Boolean isHasApiControllerAnnotation(String className) {
        Class cls = CustomApiCacheUtil.getOrRegister((String)className);
        ApiController apiController = cls.getAnnotation(ApiController.class);
        return apiController != null;
    }
}

