/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.context;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.api.model.ServiceApiData;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.ApiUriModel;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.result.OpenApiFile;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.HttpParameterUtil;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.openapi.common.util.ParamCaseInsensitiveUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.util.XmlJsonUtil;
import kd.bos.openapi.common.wsdl.SoapUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.mock.MockHttpServletRequest;
import kd.bos.openapi.kcf.utils.ApiPluginRpcHelper;
import kd.bos.openapi.kcf.utils.ApiStreamUtil;
import kd.bos.openapi.kcf.utils.ApiUtil;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class ParameterHelper {
    private static final String MAX_BODY_SIZE_KEY = "OpenApi.MaxBodySize";
    private static final String MAX_OUTBODY_SIZE_KEY = "OpenApi.MaxOutBodySize";
    private static final int MAX_BODY_SIZE = 0x1E00000;

    public static Map<String, Object> getRequestParameter() {
        try {
            boolean includeDataNode;
            if (OpenApiContext.getRequest() instanceof MockHttpServletRequest) {
                return ((MockHttpServletRequest)OpenApiContext.getRequest()).getData();
            }
            Map<String, Object> requestData = null;
            Object requestParaData = OpenApiContext.contextMap().get("Request.Arg0");
            if (requestParaData instanceof String) {
                requestData = new HashMap<String, Object>(1);
                requestData.put("data", requestParaData);
            } else {
                requestData = (HashMap<String, Object>)requestParaData;
            }
            boolean bl = includeDataNode = OpenApiContext.getOpenApiData().getApiServiceType() == ApiServiceType.OPERATION;
            if (requestData != null && !includeDataNode) {
                requestData.putAll(ParameterHelper.getPathVariableValues());
            }
            if (requestData == null) {
                Map<String, String> pathVariableValues = ParameterHelper.getPathVariableValues();
                for (Map.Entry<String, String> entry : pathVariableValues.entrySet()) {
                    OpenApiContext.setData((String)entry.getKey(), (Object)entry.getValue());
                }
                requestData = includeDataNode ? ParameterHelper.getQueryParameter(OpenApiContext.contextMap()) : ParameterHelper.getQueryParaWithoutDataNode(OpenApiContext.contextMap());
            }
            return requestData;
        }
        catch (Exception ex) {
            throw new OpenApiException((Throwable)ex, ApiErrorCode.HTTP_BAD_REQUEST, "An error occurred while getting the request parameters: " + ex.getMessage(), new Object[0]);
        }
    }

    public static void processParameter() {
        try {
            String headerLang;
            HttpServletRequest request = OpenApiContext.getRequest();
            if (OpenApiContext.getRequest() instanceof MockHttpServletRequest) {
                return;
            }
            request.setCharacterEncoding(ApiStreamUtil.getAcceptCharset().displayName());
            String string = headerLang = request == null ? "" : OpenApiContext.getRequestHeader((String)"Accept-Language");
            if (StringUtil.isNotEmpty((String)headerLang)) {
                RequestContext.get().setLang(Lang.from((String)headerLang));
            }
            if (ApiDataUtil.isPathVarUrl((HttpServletRequest)request)) {
                ParameterHelper.getPathVarContent(request);
            }
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                ParameterHelper.getMultipartContent(request);
            } else if (ParameterHelper.isCommmonParameter(request)) {
                ParameterHelper.getFormContent(request);
            } else {
                ParameterHelper.getInputStreamContent(request);
            }
        }
        catch (OpenApiException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OpenApiException((Throwable)ex, ApiErrorCode.HTTP_BAD_REQUEST, "An error occurred while getting the request parameters: " + ex.getMessage(), new Object[0]);
        }
    }

    private static Map<String, String> getPathVariableValues() {
        ApiUriModel apiUriModel = OpenApiContext.getOpenApiData().getApiUriModel();
        if (apiUriModel == null || !apiUriModel.isPathVariable()) {
            return Collections.emptyMap();
        }
        return apiUriModel.getMatchValues(OpenApiContext.getContext().getUrl());
    }

    public static void getPathVarContent(HttpServletRequest request) {
        Map map;
        String pathStr = ApiDataUtil.getPathVarString((HttpServletRequest)request);
        if (!StringUtil.isEmpty((String)pathStr) && (map = ApiDataUtil.getPathVarMap((String)pathStr)) != null) {
            for (Map.Entry entry : map.entrySet()) {
                OpenApiContext.addParameter((String)((String)entry.getKey()), entry.getValue());
            }
        }
    }

    public static void getFormContent(HttpServletRequest request) throws Exception {
        Enumeration paramNames = request.getParameterNames();
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            OpenApiContext.setInputParameter((String)request.getQueryString());
        }
        while (paramNames.hasMoreElements()) {
            String fieldName = (String)paramNames.nextElement();
            Object[] fieldValues = request.getParameterValues(fieldName);
            if (CollectionUtil.isEmpty((Object[])fieldValues)) continue;
            if (fieldValues.length == 1) {
                Object fieldValue = fieldValues[0];
                OpenApiContext.addParameter((String)fieldName, (Object)fieldValue);
                continue;
            }
            OpenApiContext.addParameter((String)fieldName, (Object)fieldValues);
        }
        return;
    }

    public static void getInputStreamContent(HttpServletRequest request) throws Exception {
        String str;
        StringBuilder sb = new StringBuilder();
        ServletInputStream is = request.getInputStream();
        InputStreamReader isr = new InputStreamReader((InputStream)is, ApiStreamUtil.getAcceptCharset());
        BufferedReader br = new BufferedReader(isr);
        while ((str = br.readLine()) != null) {
            sb.append(str);
            sb.append("\r\n");
        }
        String data = sb.toString();
        ParameterHelper.validateParameterLength(data.getBytes().length, true);
        OpenApiContext.setInputParameter((String)data);
        Object paraValue = ParameterHelper.getXMLJsonData(data);
        if (paraValue != null) {
            OpenApiContext.addParameter((String)"Request.Arg0", (Object)paraValue);
        }
    }

    public static void getMultipartContent(HttpServletRequest request) throws Exception {
        DiskFileItemFactory diskFilefactoy = new DiskFileItemFactory();
        ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)diskFilefactoy);
        List list = sfu.parseRequest(request);
        for (FileItem fileItem : list) {
            fileItem.getFieldName();
            if (fileItem.isFormField()) {
                String charset = request.getCharacterEncoding();
                String value = charset != null ? fileItem.getString(charset) : fileItem.getString();
                OpenApiContext.addParameter((String)fileItem.getFieldName(), (Object)value);
                continue;
            }
            if (!StringUtil.isNotEmpty((String)fileItem.getName())) continue;
            byte[] fileData = ApiStreamUtil.getBytesByFileItem((FileItem)fileItem);
            OpenApiFile fileInfo = new OpenApiFile(fileItem.getName(), fileItem.getContentType(), false, fileData);
            OpenApiContext.setData((String)fileItem.getFieldName(), (Object)fileInfo);
        }
    }

    public static boolean isCommmonParameter(HttpServletRequest request) {
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            return true;
        }
        return ParameterHelper.getHeader(request, "Content-Type").startsWith("application/x-www-form-urlencoded");
    }

    private static String getHeader(HttpServletRequest request, String key) {
        if (request == null) {
            return "";
        }
        String value = OpenApiContext.getRequestHeader((String)key);
        return value == null ? "" : value;
    }

    public static Map<String, Object> getQueryParaWithoutDataNode(Map<String, Object> requestData) {
        HashMap<String, Object> para = new HashMap<String, Object>(requestData.size());
        for (Map.Entry<String, Object> entry : requestData.entrySet()) {
            para.put(entry.getKey(), entry.getValue());
        }
        return para;
    }

    public static Map<String, Object> getQueryParameter(Map<String, Object> requestData) {
        HashMap<String, Object> para = new HashMap<String, Object>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        para.put("data", data);
        for (Map.Entry<String, Object> entry : requestData.entrySet()) {
            if (entry.getKey().equals("pageNo")) {
                para.put("pageNo", DataUtil.i((Object)entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("pageSize")) {
                para.put("pageSize", DataUtil.i((Object)entry.getValue()));
                continue;
            }
            data.put(entry.getKey(), entry.getValue());
        }
        return para;
    }

    public static Map<String, String> getHttpHeaders(HttpServletRequest request) {
        if (request == null) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> headers = new HashMap<String, String>(8);
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                headers.put(headerName, request.getHeader(headerName));
            }
        }
        return headers;
    }

    public static Map<String, String> getHttpHeadersCaseInsensitive(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(16);
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String value = request.getHeader(headerName);
                if (ParamCaseInsensitiveUtil.isCaseInsensitiveKey((String)headerName.toLowerCase(Locale.getDefault()))) {
                    headerName = headerName.toLowerCase(Locale.getDefault());
                }
                headers.put(headerName, value);
            }
        }
        return headers;
    }

    public static void setResponseHeaders(HttpServletResponse response, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                response.setHeader(header.getKey(), header.getValue());
            }
        }
    }

    public static OpenApiRequest<Map<String, Object>> getOpenApiRequest() {
        Map<String, Object> reqData = ParameterHelper.getRequestParameter();
        String requestUrl = OpenApiContext.getRequest().getRequestURL().toString();
        String httpMethod = OpenApiContext.getRequest().getMethod();
        Map queryStringMap = HttpParameterUtil.getQueryStringMap((String)OpenApiContext.getRequest().getQueryString());
        Map reqHeaders = OpenApiContext.getRequestHeaders();
        OpenApiData openApiData = OpenApiContext.getOpenApiData();
        ServiceApiData serviceApiData = ApiUtil.getServiceApiData((OpenApiData)openApiData);
        OpenApiRequest openApiRequest = new OpenApiRequest(requestUrl, queryStringMap, serviceApiData, reqData, reqHeaders, httpMethod);
        return openApiRequest;
    }

    private static Object getXMLJsonData(String objValue) {
        Object result = null;
        try {
            String contentType = OpenApiContext.getRequest() == null ? "" : OpenApiContext.getRequestHeader((String)"Content-Type");
            String deserializerPlugin = null;
            Integer pluginOriginType = null;
            OpenApiData openApiData = OpenApiContext.getOpenApiData();
            if (openApiData != null) {
                deserializerPlugin = openApiData.getDeserializerPlugin();
                pluginOriginType = (Integer)openApiData.getPluginOriginTypeMap().get(deserializerPlugin);
            }
            if (deserializerPlugin != null) {
                result = ApiPluginRpcHelper.deserializer(openApiData.getAppId(), deserializerPlugin, pluginOriginType, objValue, contentType);
            } else if (StringUtil.isEmpty((String)contentType)) {
                result = OpenJsonUtil.fromJson((String)objValue);
            } else if (ApiUtil.isContentType((String)"application/json", (String)contentType)) {
                result = OpenJsonUtil.fromJson((String)objValue);
            } else if (ApiUtil.isContentType((String)"application/xml", (String)contentType) || ApiUtil.isContentType((String)"text/xml", (String)contentType) && !SoapUtil.isSoapBody((String)objValue)) {
                result = XmlJsonUtil.documentToJSONObject((String)objValue, ParameterHelper.getReqMultiValueParams(), (boolean)false);
                ParameterHelper.setReponseAcceptType("application/xml");
            } else if (ApiUtil.isContentType((String)"text/xml", (String)contentType) || ApiUtil.isContentType((String)"application/soap+xml", (String)contentType)) {
                String xml = objValue;
                result = SoapUtil.readSoapToJson((String)xml, ParameterHelper.getReqMultiValueParams());
            } else {
                result = objValue;
            }
        }
        catch (Exception ex) {
            throw new OpenApiException((Throwable)ex, ApiErrorCode.HTTP_BAD_REQUEST, "JSON/XML data is invalid - " + ex.getMessage(), new Object[0]);
        }
        return result;
    }

    private static void setReponseAcceptType(String acceptType) {
        HttpServletResponse reponse = OpenApiContext.getResponse();
        if (reponse != null) {
            reponse.setHeader("Accept", acceptType);
        }
    }

    private static Set<String> getReqMultiValueParams() {
        if (OpenApiContext.getOpenApiData() != null) {
            String url = OpenApiContext.getOpenApiData().getUrl();
            Set multiParas = OpenApiDataServiceFactory.getOpenApiDataService().getReqMulValParams(url);
            return multiParas;
        }
        return null;
    }

    public static void validateParameterLength(long length, boolean isInputParameter) {
        String bodyKey = isInputParameter ? MAX_BODY_SIZE_KEY : MAX_OUTBODY_SIZE_KEY;
        String maxSizeStr = McConfigUtil.getPropertyByCurrTenant((String)bodyKey, (String)String.valueOf(0x1E00000));
        long maxSize = DataUtil.l((Object)maxSizeStr);
        if (length >= maxSize) {
            String paraTypeTips = isInputParameter ? "Request Entity Too Large." : "Response Entity Too Large.";
            String msg = String.format(paraTypeTips + " The maximum allowed body length is %s bytes, but the current body size is %s bytes.", maxSize, length);
            throw new OpenApiException(ApiErrorCode.HTTP_BODY_TOO_LARGE, msg, new Object[0]);
        }
    }
}

