/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.openapi.base.acl.ApilAclManager;
import kd.bos.openapi.base.custom.CustomApiUtil;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.ApiStatus;
import kd.bos.openapi.common.constant.AsyncTypeEnum;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.resource.MulLangUtil;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.util.ApiPluginUtil;
import kd.bos.openapi.form.util.FormOpener;
import kd.bos.openapi.form.util.OpenApiTestUtil;
import kd.bos.openapi.form.util.PathvariablePluginUtil;
import kd.bos.openapi.form.util.TreeNodeUtil;
import kd.bos.openapi.form.util.WsdlExportUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OpenApiScriptApiFormPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
TreeNodeClickListener,
CellClickListener {
    private static final String ISV_KINGDEE = "kingdee";
    private static final String BODYTAB = "bodytab";
    private static final String KEY_URLFORMAT = "urlformat";
    private static final String KEY_PLUGIN = "plugin";
    private static final String KEY_CUSTOM_SORT = "customsort";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_APISERVICETYPE = "apiservicetype";
    private static final String KEY_APPID = "appid";
    private static final String KEY_HEADER_ENTRY = "headerentryentity";
    private static final String HTTPMETHOD = "httpmethod";
    public static final String BODYENTRYENTITY = "bodyentryentity";
    public static final String TABAP = "tabap";
    public static final String GET_PROP_FROM_OBJ = "getPropFromObj";
    private static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String PID = "pid";
    public static final String ID = "id";
    public static final String BODYPREVIEW = "bodypreview";
    public static final String JSONIMPORT_BODY = "jsonimport_body";
    public static final String JSONIMPORT_RESP = "jsonimport_resp";
    public static final String RESPENTRYENTITY = "respentryentity";
    public static final String RESOURCEENTITY = "resourceentity";
    public static final String RESPPREVIEW = "resppreview";
    public static final String FILTER_COLUMN = "filter_column";
    public static final String PARAMNAME = "paramname";
    public static final String BODY_LEVEL = "body_level";
    public static final String REQMULVALUE = "is_req_mul_value";
    public static final String RESPMULVALUE = "is_resp_mul_value";
    public static final String RESPPARAMNAME = "respparamname";
    public static final String RESP_LEVEL = "resp_level";
    private static final String HEADERNAME = "headername";
    public static final String IS_BODY_CUSTOM = "is_body_custom";
    public static final String PARAMTYPE = "paramtype";
    public static final String RESPPARAMTYPE = "respparamtype";
    public static final String EXAMPLE = "example";
    public static final String RESPEXAMPLE = "respexample";
    public static final String BODYPARAMDES = "bodyparamdes";
    public static final String RESPDES = "respdes";
    public static final String MUST = "must";
    public static final String RESPPARAMMUST = "respparammust";
    private static final String STATUS = "status";
    private static final String[] urlformatArr = new String[]{"/v2", "", "/{appId}", "/{servicename}"};
    private static final String NAMESPACE = "namespace";
    public static final String INPUTPARAM = "wsinputparam";
    public static final String OUTPUTPARAM = "wsoutputparam";
    public static final String PRESCRIPT_TAG = "prescript_tag";
    public static final String POSSCRIPT_TAG = "posscript_tag";
    public static final String PRE_SCRIPT_CODE = "pre_script_code";
    public static final String POS_SCRIPT_CODE = "pos_script_code";
    private static final String PRE_TREE_VIEW = "pretreeview";
    public static final String OPENAPI_SCRIPT = "openapi_script";
    public static final String OPENAPI_SCRIPTAPI = "openapi_scriptapi";
    public static final String ADDCHILDENTRY = "addchildentry";
    public static final String SCRIPT_CODE_TAG = "script_code_tag";
    public static final String SCRIPTHELPER = "scripthelper";
    public static final String OPENAPI_SCRIPT_HELPER = "openapi_script_helper";
    private static final String BTN_TESTAPI = "testapi";
    private static final String PARAM_TYPE = "type";
    private static final String KEY_ISMUL = "isMul";
    private static final String KEY_RES_ALIAS = "res_alias";
    private static final String KEY_RES_REF = "res_ref";
    private static final String WEBSERVICE_LAB = "webserviceflex";
    private static final String KEY_ISVID = "isvid";
    private static final String OP_INSERTENTRY = "insertentry";
    private static final String KEY_ADDRESPCHILDENTRY = "addrespchildentry";
    private static final String RES_ALIAS_RU = "^[a-zA-Z][a-zA-Z0-9_]*$";
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";
    private static final String PLUGIN_MATCH = "\\[.+\\]";
    private static final String GEN_WSDL = "genwsdl";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_PLUGIN, FILTER_COLUMN, "indigesttemplate", "outdigesttemplate"});
        TreeView preTree = (TreeView)this.getView().getControl(PRE_TREE_VIEW);
        preTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        ItemClassEdit edit = (ItemClassEdit)this.getControl(KEY_RES_REF);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid bodyEntries = (EntryGrid)this.getView().getControl(BODYENTRYENTITY);
        bodyEntries.addCellClickListener((CellClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BaseShowParameter showParameter = (BaseShowParameter)e.getFormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u811a\u672cAPI", (String)"OpenApiScriptApiFormPlugin_25", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object apiServiceType = formShowParameter.getCustomParam(KEY_APISERVICETYPE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_apiauthorize"});
        String isvId = ISVServiceHelper.getISVInfo().getId();
        this.getModel().setValue(KEY_ISVID, (Object)isvId);
        if (StringUtils.isBlank((Object)apiServiceType)) {
            apiServiceType = "3";
        }
        if (StringUtils.isNotBlank((Object)apiServiceType)) {
            this.getModel().setValue(KEY_APISERVICETYPE, apiServiceType);
            String urlformat = "";
            CharSequence[] urlArr = (String[])urlformatArr.clone();
            if ((ApiServiceType.SCRIPT.ordinal() + "").equals(apiServiceType)) {
                String groupId;
                String isasync = (String)formShowParameter.getCustomParam("isasync");
                if (StringUtil.isNotEmpty((String)isasync) && "true".equals(isasync)) {
                    this.getModel().setValue("isasync", (Object)AsyncTypeEnum.ASYNC.getValue());
                    urlArr[0] = (String)urlArr[0] + "/async";
                }
                if (!ISV_KINGDEE.equals(isvId)) {
                    urlArr[1] = "/" + isvId;
                }
                urlformat = String.join((CharSequence)"", urlArr);
                this.getModel().setValue(KEY_URLFORMAT, (Object)urlformat);
                Map creMap = formShowParameter.getCustomParams();
                Object paramAppid = creMap.get(KEY_APPID);
                if (StringUtils.isNotBlank((Object)creMap) && paramAppid != null) {
                    this.getModel().setValue(KEY_APPID, paramAppid);
                    this.updateUrlFormat();
                    Object paramCusid = creMap.get("cusid");
                    if (paramCusid != null) {
                        this.getModel().setValue(KEY_CUSTOM_SORT, paramCusid);
                    }
                }
                if (creMap.size() > 0 && creMap.get("groupId") != null && !"customgroup-sys".equals(groupId = creMap.get("groupId").toString()) && StringUtil.isNotEmpty((String)groupId)) {
                    DynamicObject group = BusinessDataServiceHelper.loadSingle((String)"open_customgroup", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)groupId)});
                    this.getModel().setValue("group", (Object)group);
                }
            }
        }
        Tab tabap = (Tab)this.getView().getControl(TABAP);
        tabap.activeTab(BODYTAB);
        this.buildTwoScriptTree();
        ApiPluginUtil.buildHeader(this.getModel());
        this.getModel().setValue("cosmicver", (Object)ApiPluginUtil.getCosmicVer());
        this.getView().getPageCache().put("isNew", "true");
        this.getView().setVisible(Boolean.FALSE, new String[]{"hiddenplugin"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pvurlformat"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"number", KEY_APPID});
        Tab tabap = (Tab)this.getView().getControl(TABAP);
        tabap.activeTab(BODYTAB);
        this.setScriptCode();
        this.buildTwoScriptTree();
        ApiPluginUtil.preSetHeader(this.getModel());
        this.getView().setVisible(Boolean.FALSE, new String[]{"forbidden"});
        ApiPluginUtil.beforeLoadGetExtEntry(this.getModel(), OPENAPI_SCRIPTAPI);
        this.getView().setVisible(Boolean.FALSE, new String[]{"hiddenplugin"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pvurlformat"});
    }

    public void afterCopyData(EventObject e) {
        String isvId = ISVServiceHelper.getISVInfo().getId();
        this.getModel().setValue(KEY_ISVID, (Object)isvId);
        this.buildTwoScriptTree();
        this.setScriptCode();
        this.getView().getPageCache().put("isNew", "true");
        this.getView().setVisible(Boolean.FALSE, new String[]{"hiddenplugin"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pvurlformat"});
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String isasync = (String)showParameter.getCustomParam("isasync");
        ApiPluginUtil.updateAsyncUrlFlag(isasync, this.getModel());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String type = (String)showParameter.getCustomParam(KEY_APISERVICETYPE);
        if (StringUtils.isEmpty((CharSequence)type)) {
            type = this.getModel().getValue(KEY_APISERVICETYPE).toString();
        }
        if (null != this.getModel().getValue(HTTPMETHOD)) {
            String httpmethod = this.getModel().getValue(HTTPMETHOD).toString();
            if (httpmethod.equals("0")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{WEBSERVICE_LAB, ADDCHILDENTRY});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{WEBSERVICE_LAB, ADDCHILDENTRY});
            }
        }
        this.initParamType(PARAMTYPE, DataType.getScriptDataType());
        ApiPluginUtil.bodyOrQueryTabVisible(this.getView());
        this.initParamType(PARAMTYPE, DataType.getScriptDataType());
        this.initParamType(RESPPARAMTYPE, DataType.getScriptDataType());
        if ("prod".equals(System.getProperty("env.type"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_TESTAPI});
        }
        ApiPluginUtil.setFullUrlformat(this.getModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) throws KDException {
        super.beforeDoOperation(args);
        try {
            if (args.getSource() instanceof AbstractOperate) {
                AbstractOperate operate = (AbstractOperate)args.getSource();
                String operateKey = operate.getOperateKey();
                if ("save".equals(operateKey)) {
                    if (!"true".equals(this.getView().getPageCache().get("isSaveIgnoreIsvId"))) {
                        ApiPluginUtil.checkIsKingdee(this.getModel());
                    }
                    this.saveApiOperation(args);
                    this.matchesAllName();
                    this.setScriptInHiddenParam();
                    ApiPluginUtil.checkCycleRef(args, this.getModel(), this.getView());
                    String ver = this.getModel().getValue("cosmicver") == null ? "" : this.getModel().getValue("cosmicver").toString();
                    ApiPluginUtil.matchCosmicVer(ver, this.getView());
                    String pluginInfoStr = (String)this.getModel().getValue(KEY_PLUGIN);
                    String appId = this.getAppId();
                    ApiPluginUtil.checkPlugin(appId, "", pluginInfoStr, args, this.getView(), this.getModel());
                    PathvariablePluginUtil.handlePvUrlformat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)OPENAPI_SCRIPTAPI);
                    ApiPluginUtil.beforeSaveSetExtEntry(this.getModel(), OPENAPI_SCRIPTAPI);
                } else if ("close".equals(operateKey)) {
                    this.getModel().setDataChanged(false);
                } else if (OP_INSERTENTRY.equals(operateKey)) {
                    TreeEntryGrid body = (TreeEntryGrid)this.getControl(BODYENTRYENTITY);
                    for (int i : body.getSelectRows()) {
                        Object type = this.getModel().getValue(PARAMTYPE, i);
                        if (null != type && type.equals(DataType.STRUCT.type())) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u4e3a\u2018Struct\u2019", (String)"OpenApiScriptApiFormPlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                } else if (KEY_ADDRESPCHILDENTRY.equals(operateKey)) {
                    TreeEntryGrid resp = (TreeEntryGrid)this.getControl(RESPENTRYENTITY);
                    for (int i : resp.getSelectRows()) {
                        Object type = this.getModel().getValue(RESPPARAMTYPE, i);
                        if (null != type && type.equals(DataType.STRUCT.type())) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u4e3a\u2018Struct\u2019", (String)"OpenApiScriptApiFormPlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                } else if (GEN_WSDL.equals(operateKey)) {
                    WsdlExportUtil.checkWebserviceInfo((String)((String)this.getModel().getValue(NAMESPACE)), (String)((String)this.getModel().getValue(INPUTPARAM)), (String)((String)this.getModel().getValue(OUTPUTPARAM)));
                }
            }
        }
        catch (KDException e) {
            args.setCancel(true);
            this.getView().showErrorNotification(e.getMessage());
        }
        catch (Exception e) {
            args.setCancel(true);
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        try {
            if (BODYPREVIEW.equals(opKey)) {
                this.paramPreview(BODYENTRYENTITY);
            } else if (RESPPREVIEW.equals(opKey)) {
                this.paramPreview(RESPENTRYENTITY);
            } else if ("close".equals(opKey)) {
                if ("0".equals(this.getModel().getDataEntity().getPkValue().toString())) {
                    this.getView().returnDataToParent((Object)"norefresh");
                }
            } else if ("save".equals(opKey) && args.getOperationResult().isSuccess()) {
                String url = (String)this.getModel().getValue(KEY_URLFORMAT);
                ApilAclManager.removeApiAclModel((String)url);
                this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
                this.getView().getPageCache().put("isNew", "false");
                ApiPluginUtil.setFullUrlformat(this.getModel());
            } else if (JSONIMPORT_BODY.equals(opKey)) {
                HashMap<String, Integer> params = new HashMap<String, Integer>();
                params.put("rows", this.getModel().getEntryEntity(BODYENTRYENTITY).size());
                FormOpener.showForm((AbstractFormPlugin)this, (String)"openapi_import_json", null, params, (String)"bodyJson");
            } else if (JSONIMPORT_RESP.equals(opKey)) {
                HashMap<String, Integer> params = new HashMap<String, Integer>();
                params.put("rows", this.getModel().getEntryEntity(RESPENTRYENTITY).size());
                FormOpener.showForm((AbstractFormPlugin)this, (String)"openapi_import_json", null, params, (String)"respJson");
            } else if ("forbidden".equals(opKey) && args.getOperationResult().isSuccess()) {
                String url = (String)this.getModel().getValue(KEY_URLFORMAT);
                ApilAclManager.removeApiAclModel((String)url);
            } else if ("publish".equals(opKey) && args.getOperationResult().isSuccess()) {
                String url = (String)this.getModel().getValue(KEY_URLFORMAT);
                ApilAclManager.removeApiAclModel((String)url);
            } else if (GEN_WSDL.equals(opKey)) {
                String urlformat = (String)this.getModel().getValue(KEY_URLFORMAT);
                urlformat = PathvariablePluginUtil.replaceUrlPathVariableToExample((IDataModel)this.getModel(), (String)urlformat);
                String url = RequestContext.get().getClientFullContextPath() + "kapi" + urlformat + "?wsdl";
                WsdlExportUtil.exportWsdl((IFormView)this.getView(), (String)url, (String)RequestContext.get().getGlobalSessionId(), (String)((String)this.getModel().getValue("number")));
            } else if ("upbodyentry".equals(opKey) || "downbodyentry".equals(opKey)) {
                this.updateUrlFormat();
            }
        }
        catch (KDException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if (entryName.equals(BODYENTRYENTITY) || entryName.equals(RESPENTRYENTITY)) {
            DynamicObject pRow = this.getModel().getEntryRowEntity(entryName, e.getRowDataEntities()[0].getRowIndex());
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(entryName);
            int level = 1;
            for (DynamicObject row : entrys) {
                if (!row.getPkValue().equals(pRow.get(PID))) continue;
                level = entryName.equals(BODYENTRYENTITY) ? row.getInt(BODY_LEVEL) + 1 : row.getInt(RESP_LEVEL) + 1;
                break;
            }
            this.getModel().setValue(entryName.equals(BODYENTRYENTITY) ? BODY_LEVEL : RESP_LEVEL, (Object)level, e.getRowDataEntities()[0].getRowIndex());
        }
    }

    private void paramPreview(String entryKey) {
        String httpMethod = (String)this.getModel().getValue(HTTPMETHOD);
        String inputParam = (String)this.getModel().getValue(INPUTPARAM);
        String outputParam = (String)this.getModel().getValue(OUTPUTPARAM);
        String nameSpace = (String)this.getModel().getValue(NAMESPACE);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(entryKey);
        String jsonStr = null;
        Object resultObj = CustomApiUtil.getCustomParams((String)entryKey, (DynamicObjectCollection)dynamicObjects);
        jsonStr = JsonUtil.format((Object)resultObj);
        param.put("preData", jsonStr);
        if (entryKey.equalsIgnoreCase(RESPENTRYENTITY)) {
            OpenApiResult result = new OpenApiResult();
            result.setData(resultObj);
            result.setErrorCode("0");
            result.setMessage("");
            param.put("preData", JsonUtil.format((Object)result));
        }
        boolean isBody = "0".equals(httpMethod) && entryKey.equalsIgnoreCase(BODYENTRYENTITY) ? Boolean.TRUE : Boolean.FALSE;
        param.put("isGetMethod", isBody);
        param.put("preUrl", this.getModel().getValue(KEY_URLFORMAT));
        param.put("apiServiceType", ApiServiceType.CUSTOM.getOperation());
        param.put("previewType", entryKey);
        param.put(INPUTPARAM, inputParam);
        param.put(OUTPUTPARAM, outputParam);
        param.put(NAMESPACE, nameSpace);
        FormOpener.showForm((AbstractFormPlugin)this, (String)"openapi_struct_preview", (String)ResManager.loadKDString((String)"\u6570\u636e\u9884\u89c8", (String)"OpenApiScriptApiFormPlugin_19", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), param, null);
    }

    private void openTestApiForm() {
        String httpMethod = (String)this.getModel().getValue(HTTPMETHOD);
        String inputParam = (String)this.getModel().getValue(INPUTPARAM);
        String outputParam = (String)this.getModel().getValue(OUTPUTPARAM);
        String nameSpace = (String)this.getModel().getValue(NAMESPACE);
        String jsonStr = null;
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(BODYENTRYENTITY);
        Object resultObj = CustomApiUtil.getCustomParams((String)BODYENTRYENTITY, (DynamicObjectCollection)dynamicObjects);
        jsonStr = JsonUtil.format((Object)resultObj);
        HashMap<String, Object> param = new HashMap<String, Object>(6);
        param.put("preData", jsonStr);
        param.put("isGetMethod", "0".equals(httpMethod) ? Boolean.TRUE : Boolean.FALSE);
        param.put("preUrl", this.getModel().getValue(KEY_URLFORMAT));
        param.put("apiServiceType", ApiServiceType.CUSTOM.getOperation());
        param.put(INPUTPARAM, inputParam);
        param.put(OUTPUTPARAM, outputParam);
        param.put(NAMESPACE, nameSpace);
        FormOpener.showApiTestForm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"API\u6d4b\u8bd5", (String)"OpenApiScriptApiFormPlugin_20", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), param, null);
    }

    private Object setDefaultValue(String dateType, Object obj) {
        if (obj != null) {
            return obj;
        }
        return JSON.toJSONString((Object)DataType.getDefaultValue((String)dateType), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object object = event.getReturnData();
        if (event.getActionId().equals("openapi_testapi_l")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_test"});
        }
        if (object == null) {
            return;
        }
        try {
            Map reMap = (Map)object;
            String actionId = event.getActionId();
            if (event.getActionId().equals("bodyJson")) {
                this.getModel().deleteEntryData(BODYENTRYENTITY);
                this.transMapToBodyRows(reMap, 0L, 0);
            } else if ("pluginRegister".equals(actionId)) {
                if (!reMap.isEmpty()) {
                    List pluginList = (List)reMap.get("value");
                    this.getModel().setValue(KEY_PLUGIN, (Object)SerializationUtils.toJsonString((Object)pluginList));
                }
            } else if ("indigesttemplate".equals(actionId) || "outdigesttemplate".equals(actionId)) {
                String script_text = (String)reMap.get("script_text");
                this.getModel().setValue(actionId, (Object)script_text);
            } else {
                this.getModel().deleteEntryData(RESPENTRYENTITY);
                this.transMapToRespRows(reMap, 0L, 0);
            }
        }
        catch (OpenApiException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("apitest")) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                OpenApiTestUtil util = new OpenApiTestUtil();
                util.createUnittestApp();
                this.openTestApiForm();
            }
        } else if (evt.getCallBackId().equals("update_api") && evt.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("save", OperateOption.create());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals(BTN_TESTAPI)) {
            this.openTestApiForm();
        } else if (evt.getItemKey().equals("callbackurl")) {
            ApiPluginUtil.callbackUrl((AbstractFormPlugin)this);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (KEY_PLUGIN.equals(control.getKey())) {
            String bizAppId;
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ide_plugins");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pluginRegister"));
            String plugins = (String)this.getModel().getValue(KEY_PLUGIN);
            DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APPID);
            if (StringUtils.isNotBlank((Object)app) && StringUtils.isNotBlank((CharSequence)(bizAppId = app.getString(ID)))) {
                formShowParameter.setCustomParam("bizappid", (Object)bizAppId);
                formShowParameter.setCustomParam("scriptfiltertype", (Object)"webapi");
            }
            if (this.isUseNewVersionPlugin() && StringUtils.isNotBlank((CharSequence)plugins)) {
                formShowParameter.setCustomParam("value", SerializationUtils.fromJsonString((String)plugins, List.class));
            }
            formShowParameter.setCustomParam("engineType", (Object)"1");
            this.getView().showForm(formShowParameter);
        } else if ("indigesttemplate".equals(control.getKey()) || "outdigesttemplate".equals(control.getKey())) {
            ApiPluginUtil.digestLogFormShow(control.getKey(), this.getModel(), this.getView(), this.getPluginName());
        }
    }

    private boolean isUseNewVersionPlugin() {
        String pluginInfoStr = (String)this.getModel().getValue(KEY_PLUGIN);
        return StringUtils.isBlank((CharSequence)pluginInfoStr) || pluginInfoStr.matches(PLUGIN_MATCH);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (ApiPluginUtil.isSaveIgnoreIsvId(propName).booleanValue()) {
            if (!"false".equals(this.getView().getPageCache().get("isSaveIgnoreIsvId"))) {
                this.getView().getPageCache().put("isSaveIgnoreIsvId", "true");
            }
        } else {
            this.getView().getPageCache().put("isSaveIgnoreIsvId", "false");
        }
        if (KEY_APPID.equals(propName)) {
            this.updateUrlFormat();
        } else if ("number".equals(propName)) {
            if (ApiPluginUtil.validateNumberAndUrlFormat(null, (AbstractFormPlugin)this)) {
                this.updateUrlFormat();
            }
        } else if (HTTPMETHOD.equals(propName)) {
            if (null != this.getModel().getValue(HTTPMETHOD)) {
                String httpmethod = this.getModel().getValue(HTTPMETHOD).toString();
                if (httpmethod.equals("0")) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{WEBSERVICE_LAB, ADDCHILDENTRY});
                    this.getModel().deleteEntryData(BODYENTRYENTITY);
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{WEBSERVICE_LAB, ADDCHILDENTRY});
                }
            }
            this.initParamType(PARAMTYPE, DataType.getScriptDataType());
            ApiPluginUtil.bodyOrQueryTabVisible(this.getView());
            this.updateUrlFormat();
        } else if (PARAMTYPE.equals(propName) || RESPPARAMTYPE.equals(propName)) {
            ChangeData changeData = e.getChangeSet()[0];
            String type = DataUtil.s((Object)changeData.getNewValue());
            if (StringUtils.isNotEmpty((CharSequence)type)) {
                this.getModel().setValue(PARAMTYPE.equals(propName) ? EXAMPLE : RESPEXAMPLE, this.setDefaultValue(type, null));
            }
        } else if (EXAMPLE.equals(propName) || RESPEXAMPLE.equals(propName)) {
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = DataUtil.s((Object)changeData.getNewValue());
            if (kd.bos.util.StringUtils.isEmpty((String)newValue)) {
                return;
            }
            String dataTypeName = EXAMPLE.equals(propName) ? PARAMTYPE : RESPPARAMTYPE;
            String dataType = changeData.getDataEntity().getString(dataTypeName);
            if (StringUtils.isNotEmpty((CharSequence)dataType)) {
                DataType type = DataType.getByType((String)dataType);
                try {
                    ApiPluginUtil.validatorMutiLang(changeData, propName, type);
                }
                catch (Exception exception) {
                    String str = JSON.toJSONString((Object)type.defaultValue(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
                    this.getModel().setValue(propName, null, changeData.getRowIndex());
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002%s", (String)"OpenApiScriptApiFormPlugin_3", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), str));
                }
            }
        } else if (PARAMNAME.equals(propName)) {
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = DataUtil.s((Object)changeData.getNewValue());
            int rowIndex = this.getModel().getEntryCurrentRowIndex(BODYENTRYENTITY);
            if (null != newValue) {
                this.checkRepName(BODYENTRYENTITY, PARAMNAME, newValue, rowIndex);
                this.matchesName(newValue);
            }
        } else if (RESPPARAMNAME.equals(propName)) {
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = DataUtil.s((Object)changeData.getNewValue());
            int rowIndex = this.getModel().getEntryCurrentRowIndex(RESPENTRYENTITY);
            if (null != newValue) {
                this.checkRepName(RESPENTRYENTITY, RESPPARAMNAME, newValue, rowIndex);
                this.matchesName(newValue);
            }
        } else if (KEY_RES_REF.equals(propName)) {
            if (null != this.getModel().getValue(KEY_RES_REF)) {
                DynamicObject ref = (DynamicObject)this.getModel().getValue(KEY_RES_REF);
                this.getModel().setValue(KEY_RES_ALIAS, (Object)ref.getString("number").replace('/', '_'));
            } else {
                this.getModel().setValue(KEY_RES_ALIAS, (Object)"");
            }
        } else if (KEY_RES_ALIAS.equals(propName)) {
            String res_alias = (String)this.getModel().getValue(KEY_RES_ALIAS);
            if (StringUtils.isNotBlank((CharSequence)res_alias) && !res_alias.matches(RES_ALIAS_RU)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u522b\u540d\u201d\u4e0d\u7b26\u5408\u89c4\u5219\uff08\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff09\u3002", (String)"OpenApiScriptApiFormPlugin_4", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex(RESOURCEENTITY);
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = DataUtil.s((Object)changeData.getNewValue());
            if (null != newValue) {
                this.checkRecName(RESOURCEENTITY, KEY_RES_ALIAS, newValue, rowIndex);
            }
        } else if (HEADERNAME.equals(propName)) {
            String newVar = DataUtil.s((Object)e.getChangeSet()[0].getNewValue());
            ApiPluginUtil.dealHeaderWhenChanged(this.getModel(), this.getView(), newVar);
        } else if ("cosmicver".equals(propName)) {
            try {
                ApiPluginUtil.matchCosmicVer(DataUtil.s((Object)e.getChangeSet()[0].getNewValue()), this.getView());
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
        } else if ("ispathvariable".equals(propName)) {
            if (((Boolean)this.getModel().getValue("ispathvariable")).booleanValue()) {
                try {
                    PathvariablePluginUtil.checkPvButInvalid((IDataModel)this.getModel());
                }
                catch (Exception exception) {
                    this.getView().showTipNotification(exception.getMessage());
                }
            }
            this.updateUrlFormat();
        } else if ("headerdefaultvalue".equals(propName)) {
            ApiPluginUtil.validatorHeaders(this.getModel(), this.getView());
        }
    }

    private void initParamType(String controlName, EnumSet<DataType> excludes) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(controlName);
        EnumSet dataTypes = DataType.getScriptDataType();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(dataTypes.size());
        String httpmethod = this.getModel().getValue(HTTPMETHOD).toString();
        for (DataType dataType : dataTypes) {
            if (httpmethod.equals("0") && controlName.equals(PARAMTYPE)) {
                if (dataType.type().equals(DataType.STRUCT.type())) continue;
                if (dataType.type().equals(DataType.ANY.type())) continue;
            }
            ComboItem item = new ComboItem();
            item.setValue(dataType.type());
            item.setCaption(new LocaleString(dataType.type()));
            items.add(item);
        }
        combo.setComboItems(items);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if (BTN_TESTAPI.equals(key)) {
            Long pk = (Long)this.getModel().getDataEntity().getPkValue();
            if (pk <= 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58API\u3002", (String)"OpenApiScriptApiFormPlugin_5", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
            String enable = this.getModel().getDataEntity().getString(STATUS);
            if (ApiStatus.DISABLE.getCode().equals(enable)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u72b6\u6001\u65e0\u6cd5\u6d4b\u8bd5\u3002", (String)"OpenApiScriptApiFormPlugin_6", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
            ApiPluginUtil.createTest3rdApp(evt, this);
        } else if ("bar_save".equals(key)) {
            ApiPluginUtil.confirmBeforeSave(this.getView(), evt);
        }
    }

    private void updateUrlFormat() {
        String isvId = ISVServiceHelper.getISVInfo().getId();
        CharSequence[] urlFormatClone = (String[])urlformatArr.clone();
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
        String appId = null;
        if (bizApp != null) {
            appId = bizApp.getString("number");
        }
        String isasync = (String)this.getModel().getValue("isasync");
        if (AsyncTypeEnum.ASYNC.getValue().equals(isasync)) {
            urlFormatClone[0] = urlFormatClone[0] + "/async";
        }
        String serviceName = (String)this.getModel().getValue("number");
        String modelIsvid = this.getModel().getValue(KEY_ISVID).toString();
        if (StringUtil.isEmpty((String)isvId) && StringUtil.isEmpty((String)modelIsvid) || StringUtil.isNotEmpty((String)isvId) && StringUtil.isEmpty((String)modelIsvid)) {
            if (!ISV_KINGDEE.equalsIgnoreCase(isvId)) {
                urlFormatClone[1] = "/" + isvId;
            }
        } else if ((StringUtil.isEmpty((String)isvId) && StringUtil.isNotEmpty((String)modelIsvid) || StringUtil.isNotEmpty((String)isvId) && StringUtil.isNotEmpty((String)modelIsvid)) && !ISV_KINGDEE.equalsIgnoreCase(modelIsvid)) {
            urlFormatClone[1] = "/" + modelIsvid;
        }
        if (StringUtil.isNotEmpty((String)appId)) {
            urlFormatClone[2] = "/" + appId;
        }
        if (StringUtil.isNotEmpty((String)serviceName)) {
            urlFormatClone[3] = "/" + serviceName;
        }
        String urlFormat = PathvariablePluginUtil.splicePathVariable((String)String.join((CharSequence)"", urlFormatClone), (IDataModel)this.getModel());
        this.getModel().setValue(KEY_URLFORMAT, (Object)urlFormat);
    }

    private void saveApiOperation(BeforeDoOperationEventArgs evt) {
        ApiPluginUtil.validateNumberAndUrlFormat(evt, (AbstractFormPlugin)this);
    }

    private void setScriptInHiddenParam() {
        CodeEdit preEdit = (CodeEdit)this.getView().getControl(PRE_SCRIPT_CODE);
        String preCode = preEdit.getText();
        if (preCode != null) {
            this.getModel().setValue(PRESCRIPT_TAG, (Object)preCode);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        if (arg0.getProperty().getName().equals(KEY_RES_REF)) {
            List refIds;
            DynamicObjectCollection resources;
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            QFilter qFilter = new QFilter(STATUS, "!=", (Object)"D").and(new QFilter("version", "=", (Object)"2"));
            Object pk = this.getModel().getDataEntity().getPkValue();
            if (null != pk && (Long)pk > 0L) {
                QFilter qFilter1 = new QFilter(ID, "!=", pk);
                qFilter = qFilter.and(qFilter1);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)OPENAPI_SCRIPTAPI, (String)ID, (QFilter[])new QFilter("resourceentity.res_ref.Id", "=", pk).toArray());
                if (collection.size() > 0) {
                    List ids = collection.stream().map(it -> it.getLong(ID)).collect(Collectors.toList());
                    qFilter.and(new QFilter(ID, "not in", ids));
                }
            }
            if ((resources = this.getModel().getEntryEntity(RESOURCEENTITY)).size() > 0 && CollectionUtil.isNotEmpty(refIds = resources.stream().map(it -> it.getLong("res_ref.Id")).filter(it -> !it.equals(0L)).collect(Collectors.toList()))) {
                qFilter.and(new QFilter("Id", "not in", refIds));
            }
            if (showParameter.getBillFormId().equals(ApiServiceType.OPERATION.getEntityName())) {
                qFilter.and(new QFilter(KEY_APISERVICETYPE, "=", (Object)"0"));
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            } else {
                showParameter.setFormId("bos_listf7");
                if (showParameter.getBillFormId().equals(ApiServiceType.SCRIPT.getEntityName())) {
                    qFilter.and(new QFilter(KEY_APISERVICETYPE, "=", (Object)"3"));
                } else if (showParameter.getBillFormId().equals(ApiServiceType.CUSTOM.getEntityName())) {
                    qFilter.and(new QFilter(KEY_APISERVICETYPE, "=", (Object)"2"));
                }
                showParameter.setBillFormId(ApiServiceType.OPERATION.getEntityName());
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                if (arg0.getSourceMethod().equals("click")) {
                    arg0.setCancel(true);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String parentFormId = "";
        if (null != this.getView().getParentView()) {
            parentFormId = this.getView().getParentView().getFormShowParameter().getFormId();
        }
        if (parentFormId.equals("openapi_apilist_tmp")) {
            if ("0".equals(this.getModel().getDataEntity().getPkValue().toString())) {
                this.getView().returnDataToParent((Object)"norefresh");
            } else {
                this.getView().returnDataToParent((Object)"refresh");
            }
        }
        e.setCheckDataChange(false);
    }

    private void setScriptCode() {
        CodeEdit preEdit = (CodeEdit)this.getView().getControl(PRE_SCRIPT_CODE);
        Object preCode = this.getModel().getValue(PRESCRIPT_TAG);
        if (preCode != null) {
            preEdit.setText(preCode.toString());
        }
    }

    private void buildScriptTree(TreeView tv, DynamicObjectCollection collection) {
        tv.deleteAllNodes();
        TreeNode root = TreeNodeUtil.buildScriptSortTree();
        Map allScript = TreeNodeUtil.getAllScript((DynamicObjectCollection)collection);
        TreeNodeUtil.addScriptIntoTree((TreeNode)root, (Map)allScript);
        tv.addNode(root);
        this.getView().updateView();
    }

    public void treeNodeClick(TreeNodeEvent e) {
        Control control = (Control)e.getSource();
        if (null != e.getNodeId() && !"".equals(e.getNodeId().toString()) && e.getNodeId().toString().contains("leaf")) {
            String id = e.getNodeId().toString().replace("leaf_", "");
            QFilter[] qFilters = QFilterUtil.builder().put(ID, "=", (Object)Long.valueOf(id)).build();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)OPENAPI_SCRIPT, (String)"Id,script_code_tag", (QFilter[])qFilters);
            if (control.getKey().equals(PRE_TREE_VIEW)) {
                String code;
                CodeEdit preEdit = (CodeEdit)this.getView().getControl(PRE_SCRIPT_CODE);
                String value = this.getModel().getValue(PRESCRIPT_TAG) != null ? this.getModel().getValue(PRESCRIPT_TAG).toString() : "";
                String string = code = preEdit.getText() == null ? value : preEdit.getText();
                if (!"".equals(code)) {
                    code = code + "\n";
                }
                preEdit.setText(code + dynamicObject.getString(SCRIPT_CODE_TAG));
            }
        }
    }

    private void buildTwoScriptTree() {
        TreeView tv1 = (TreeView)this.getView().getControl(PRE_TREE_VIEW);
        DynamicObjectCollection collection = TreeNodeUtil.getAllScript();
        this.buildScriptTree(tv1, collection);
    }

    private void transMapToBodyRows(Map<String, Object> reMap, long pid, int level) {
        for (Map.Entry<String, Object> entry : reMap.entrySet()) {
            DynamicObjectType type = this.getModel().getEntryEntity(BODYENTRYENTITY).getDynamicObjectType();
            DynamicObject row = new DynamicObject(type);
            if (pid > 0L) {
                row.set(PID, (Object)pid);
            }
            row.set(PARAMNAME, (Object)entry.getKey());
            row.set(BODYPARAMDES, (Object)entry.getKey());
            boolean isGet = this.getModel().getValue(HTTPMETHOD).equals("0");
            Map<String, Object> tra = this.transValueToType(entry.getValue(), isGet);
            if (tra.get(PARAM_TYPE).equals(DataType.STRUCT.type())) {
                row.set(EXAMPLE, (Object)"-");
            } else if (tra.get(PARAM_TYPE).equals(DataType.STRING.type())) {
                row.set(EXAMPLE, (Object)("\"" + entry.getValue() + "\""));
            } else {
                row.set(EXAMPLE, entry.getValue());
            }
            row.set(PARAMTYPE, tra.get(PARAM_TYPE));
            int rowIndex = this.getModel().createNewEntryRow(BODYENTRYENTITY, row);
            this.getModel().setValue(REQMULVALUE, tra.get(KEY_ISMUL), rowIndex);
            this.getModel().setValue(BODY_LEVEL, (Object)(level + 1), rowIndex);
            LocaleString bodyParamdes = MulLangUtil.getLocaleStringBySingle((String)entry.getKey());
            if (tra.get(PARAM_TYPE).equals(DataType.STRUCT.type())) {
                LocaleString localeStringExample = new LocaleString();
                localeStringExample.setLocaleValue("-");
                this.getModel().setValue(EXAMPLE, (Object)localeStringExample, rowIndex);
            } else {
                LocaleString example = MulLangUtil.getLocaleStringBySingle((String)JacksonUtil.writeValueAsString((Object)entry.getValue()));
                this.getModel().setValue(EXAMPLE, (Object)example, rowIndex);
            }
            this.getModel().setValue(BODYPARAMDES, (Object)bodyParamdes, rowIndex);
            if (!tra.get(PARAM_TYPE).equals(DataType.STRUCT.type())) continue;
            if (entry.getValue() instanceof List) {
                this.transMapToBodyRows((Map)((List)entry.getValue()).get(0), (Long)row.getPkValue(), row.getInt(BODY_LEVEL));
                continue;
            }
            this.transMapToBodyRows((Map)entry.getValue(), (Long)row.getPkValue(), row.getInt(BODY_LEVEL));
        }
    }

    private void transMapToRespRows(Map<String, Object> reMap, long pid, int level) {
        for (Map.Entry<String, Object> entry : reMap.entrySet()) {
            DynamicObjectType type = this.getModel().getEntryEntity(RESPENTRYENTITY).getDynamicObjectType();
            DynamicObject row = new DynamicObject(type);
            if (pid > 0L) {
                row.set(PID, (Object)pid);
            }
            row.set(RESPPARAMNAME, (Object)entry.getKey());
            row.set(RESPDES, (Object)entry.getKey());
            Map<String, Object> tra = this.transValueToType(entry.getValue(), false);
            if (tra.get(PARAM_TYPE).equals(DataType.STRUCT.type())) {
                row.set(RESPEXAMPLE, (Object)"{}");
            } else if (tra.get(PARAM_TYPE).equals(DataType.STRING.type())) {
                row.set(RESPEXAMPLE, (Object)("\"" + entry.getValue() + "\""));
            } else {
                row.set(RESPEXAMPLE, entry.getValue());
            }
            row.set(RESPPARAMTYPE, tra.get(PARAM_TYPE));
            int rowIndex = this.getModel().createNewEntryRow(RESPENTRYENTITY, row);
            this.getModel().setValue(RESPMULVALUE, tra.get(KEY_ISMUL), rowIndex);
            this.getModel().setValue(RESP_LEVEL, (Object)(level + 1), rowIndex);
            LocaleString respdes = MulLangUtil.getLocaleStringBySingle((String)entry.getKey());
            if (tra.get(PARAM_TYPE).equals(DataType.STRUCT.type())) {
                LocaleString localeStringExample = new LocaleString();
                localeStringExample.setLocaleValue("-");
                this.getModel().setValue(RESPEXAMPLE, (Object)localeStringExample, rowIndex);
            } else {
                LocaleString example = MulLangUtil.getLocaleStringBySingle((String)JacksonUtil.writeValueAsString((Object)entry.getValue()));
                this.getModel().setValue(RESPEXAMPLE, (Object)example, rowIndex);
            }
            this.getModel().setValue(RESPDES, (Object)respdes, rowIndex);
            if (!tra.get(PARAM_TYPE).equals(DataType.STRUCT.type())) continue;
            if (entry.getValue() instanceof List) {
                this.transMapToRespRows((Map)((List)entry.getValue()).get(0), (Long)row.getPkValue(), row.getInt(RESP_LEVEL));
                continue;
            }
            this.transMapToRespRows((Map)entry.getValue(), (Long)row.getPkValue(), row.getInt(RESP_LEVEL));
        }
    }

    private Map<String, Object> transValueToType(Object value, boolean child) {
        HashMap<String, Object> re = new HashMap<String, Object>(2);
        if (value instanceof String) {
            if (value.equals("false") || value.equals("true")) {
                re.put(PARAM_TYPE, DataType.BOOLEAN.type());
                re.put(KEY_ISMUL, false);
                return re;
            }
            re.put(PARAM_TYPE, DataType.STRING.type());
            re.put(KEY_ISMUL, false);
            return re;
        }
        if (value instanceof Integer) {
            re.put(PARAM_TYPE, DataType.INTEGER.type());
            re.put(KEY_ISMUL, false);
            return re;
        }
        if (value instanceof Boolean) {
            re.put(PARAM_TYPE, DataType.BOOLEAN.type());
            re.put(KEY_ISMUL, false);
            return re;
        }
        if (value instanceof Map) {
            if (child) {
                throw new KDBizException(ResManager.loadKDString((String)"GET\u8bf7\u6c42\u4e0d\u5141\u8bb8\u6709\u5b50\u884c\u3002", (String)"OpenApiScriptApiFormPlugin_10", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
            re.put(PARAM_TYPE, DataType.STRUCT.type());
            re.put(KEY_ISMUL, false);
            return re;
        }
        if (value instanceof List) {
            if (((List)value).size() <= 0) {
                re.put(PARAM_TYPE, DataType.ANY.type());
            } else {
                Map<String, Object> vl = this.transValueToType(((List)value).get(0), child);
                re.put(PARAM_TYPE, vl.get(PARAM_TYPE));
            }
            re.put(KEY_ISMUL, true);
            return re;
        }
        re.put(PARAM_TYPE, DataType.ANY.type());
        re.put(KEY_ISMUL, false);
        return re;
    }

    private void checkRepName(String entryKey, String filedKey, String value, int rowIndex) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entryKey);
        for (int i = 0; i < collection.size(); ++i) {
            if (rowIndex == i || null == value || !((DynamicObject)collection.get(i)).getString(filedKey).equals(value) || !this.getModel().getEntryRowEntity(entryKey, rowIndex).getString(PID).equals(((DynamicObject)collection.get(i)).getString(PID))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91cd\u590d\u53c2\u6570\u540d\u79f0 \u884c\u53f7:%s,\u8bf7\u4fee\u6539\u3002", (String)"OpenApiScriptApiFormPlugin_11", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), ((DynamicObject)collection.get(i)).getInt("seq")));
            this.getModel().setValue(filedKey, null, rowIndex);
            break;
        }
    }

    private void checkRecName(String entryKey, String filedKey, String value, int rowIndex) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entryKey);
        for (int i = 0; i < collection.size(); ++i) {
            if (rowIndex == i || null == value || !((DynamicObject)collection.get(i)).getString(filedKey).equals(value)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91cd\u590d\u522b\u540d \u884c\u53f7:%s,\u8bf7\u4fee\u6539\u3002", (String)"OpenApiScriptApiFormPlugin_23", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), ((DynamicObject)collection.get(i)).getInt("seq")));
            this.getModel().setValue(filedKey, null, rowIndex);
            break;
        }
    }

    private void matchesName(String name) {
        if (StringUtils.isNotBlank((CharSequence)name) && !name.matches(RES_ALIAS_RU)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u7b26\u5408\u89c4\u5219\uff08\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff09\u3002", (String)"OpenApiScriptApiFormPlugin_12", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), name));
        }
    }

    private void matchesAllName() {
        DynamicObjectCollection bodys = this.getModel().getEntryEntity(BODYENTRYENTITY);
        for (Object body : bodys) {
            if (body.getString(PARAMNAME).matches(RES_ALIAS_RU)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u8bf7\u6c42\u4f53\u5355\u636e\u4f53\u201d\u7b2c\u201c%s\u201d\u884c\uff0c\u201c\u53c2\u6570\u540d\u79f0\u201d\u53ea\u80fd\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3002", (String)"Open", (String)"bos-form-business", (Object[])new Object[0]), body.getInt("seq")));
        }
        DynamicObjectCollection resps = this.getModel().getEntryEntity(RESPENTRYENTITY);
        for (DynamicObject resp : resps) {
            if (resp.getString(RESPPARAMNAME).matches(RES_ALIAS_RU)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u8fd4\u56de\u53c2\u6570\u5355\u636e\u4f53\u201d\u7b2c\u201c%s\u201d\u884c\uff0c\u201c\u53c2\u6570\u540d\u79f0\u201d\u53ea\u80fd\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3002", (String)"Open", (String)"bos-form-business", (Object[])new Object[0]), resp.getInt("seq")));
        }
        DynamicObjectCollection resos = this.getModel().getEntryEntity(RESOURCEENTITY);
        for (DynamicObject reso : resos) {
            if (reso.getString(KEY_RES_ALIAS).matches(RES_ALIAS_RU)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u5f15\u7528\u8d44\u6e90\u5355\u636e\u4f53\u201d\u7b2c\u201c%s\u201d\u884c\uff0c\u201c\u522b\u540d\u201d\u53ea\u80fd\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3002", (String)"Open", (String)"bos-form-business", (Object[])new Object[0]), reso.getInt("seq")));
        }
    }

    private String getAppId() {
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
        if (bizApp == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u5e94\u7528!", (String)"OpenApiScriptApiFormPlugin_24", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), new Object[0]);
        }
        return bizApp.getString("number");
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (BODYENTRYENTITY.equals(name)) {
            this.updateUrlFormat();
        }
    }
}

