/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.extension.ConcurrentHashSet;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.SuperUserCache;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.AdminUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BatchCheckPermCache {
    private static Log logger = LogFactory.getLog(BatchCheckPermCache.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"BatchCheckPermCache_CachedThreadPool", (int)8);
    private static final String ADMINTYPE_SUPERADMIN = "10";
    private static final String SPLIT = "_";
    public static final String BILLFORMVIEW = "1";
    public static final String LISTFORMVIEW = "2";

    public static String buildCacheKey(boolean isList, long userId, long dimId, long assistDimId, String appId, String formNum) {
        String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        PermissionControlType permissionControlType = FormHelper.getPermissionControlType(entityNum);
        String dimension = permissionControlType.getDimension();
        if (isList || dimId == 0L && assistDimId == 0L || "DIM_NULL".equals(dimension) || StringUtils.isEmpty((String)dimension)) {
            return userId + SPLIT + appId + SPLIT + formNum;
        }
        if ("DIM_ORG".equals(dimension)) {
            String dimOrgViewType = PermCommonUtil.getPermOrgFuncId(entityNum, BILLFORMVIEW);
            String assistDimOrgViewType = PermCommonUtil.getPermOrgFuncId(entityNum, LISTFORMVIEW);
            if (!OrgUnitServiceHelper.checkOrgFunction((Long)dimId, (String)dimOrgViewType)) {
                dimId = 0L;
            }
            if (!OrgUnitServiceHelper.checkOrgFunction((Long)assistDimId, (String)assistDimOrgViewType)) {
                assistDimId = 0L;
            }
        }
        return userId + SPLIT + appId + SPLIT + formNum + SPLIT + dimId + SPLIT + assistDimId;
    }

    public static Map<String, Boolean> getMultiPermItemInfos(long pUserId, String pAppId, String pFormNum) {
        String key = String.format("%s%s%s%s%s", "getMultiPermItemInfos_", RequestContext.get().getAccountId(), pUserId, pAppId, pFormNum);
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, Map<String, Boolean>> map = new HashMap<String, Map<String, Boolean>>(8);
            Map<String, Boolean> multiPermItemInfosNoThreadCache = BatchCheckPermCache.getMultiPermItemInfosNoThreadCache(pUserId, pAppId, pFormNum);
            if (null == multiPermItemInfosNoThreadCache) {
                return map;
            }
            map.put("multiPermItemInfosNoThreadCache", multiPermItemInfosNoThreadCache);
            return map;
        });
        return (Map)threadCacheMap.get("multiPermItemInfosNoThreadCache");
    }

    private static Map<String, Boolean> getMultiPermItemInfosNoThreadCache(long pUserId, String pAppId, String pFormNum) {
        String entityNum = "";
        try {
            entityNum = FormMetadataCache.getFormConfig((String)pFormNum).getEntityTypeId();
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return new HashMap<String, Boolean>(8);
        }
        String realAppId = "";
        try {
            realAppId = PermCommonUtil.getAppIdFromSuspectedAppNum(pAppId);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return new HashMap<String, Boolean>(8);
        }
        String checkPermAppId = PermCommonUtil.getCheckPermAppId(realAppId, entityNum);
        Map<Object, Object> result = new HashMap(8);
        String cacheType = CacheMrg.getType4UserHasPermItems();
        String cacheKey = BatchCheckPermCache.buildCacheKey(true, pUserId, 0L, 0L, checkPermAppId, entityNum);
        if (cacheKey.contains("_0_0")) {
            HashSet permItemIds = new HashSet(EntityMetadataCache.getPermissionItems((String)entityNum));
            for (String permItemId : permItemIds) {
                result.put(permItemId, Boolean.FALSE);
            }
            logger.warn("neither dim nor assistDim own the correct orgViewType. So it doesn't have perm :" + result.keySet());
            return result;
        }
        String cache = CacheMrg.getCache(cacheType, cacheKey);
        if (StringUtils.isNotEmpty((String)cache)) {
            result = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        } else {
            result = BatchCheckPermCache.loadFromDB4UserHasPermItems(true, pUserId, 0L, 0L, checkPermAppId, pFormNum);
            CacheMrg.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(result));
        }
        return result;
    }

    public static Map<String, Boolean> checkMultiPermItemInfos(long pUserId, String pFormNum, Set<String> pPermItems) {
        return BatchCheckPermCache.checkMultiPermItemInfos(pUserId, pFormNum, pPermItems, true);
    }

    public static Map<String, Boolean> checkMultiPermItemInfos(long pUserId, String pFormNum, Set<String> pPermItems, boolean pNeedCheckMenuApp) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(8);
        if (pPermItems == null || pPermItems.isEmpty()) {
            return result;
        }
        String entityNum = "";
        try {
            entityNum = FormMetadataCache.getFormConfig((String)pFormNum).getEntityTypeId();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            for (String permItemId : pPermItems) {
                result.put(permItemId, Boolean.FALSE);
            }
            return result;
        }
        List<String> allCheckPermAppIdList = PermCommonUtil.getAllCheckPermAppIds(entityNum);
        HashSet<String> allCheckPermAppIds = new HashSet<String>(allCheckPermAppIdList);
        if (pNeedCheckMenuApp) {
            Map allAppMenus = AppMetadataCache.getAllAppMenus();
            List appMenuInfoList = allAppMenus.values().stream().flatMap(x -> x.stream()).collect(Collectors.toList()).stream().filter(x -> Objects.equals(pFormNum, x.getFormId())).collect(Collectors.toList());
            HashSet<String> menuAppIds = new HashSet<String>(8);
            if (null != appMenuInfoList && !appMenuInfoList.isEmpty()) {
                Set appNumSet = appMenuInfoList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getAppId())).map(x -> x.getAppId()).collect(Collectors.toSet());
                for (String appNum : appNumSet) {
                    AppInfo appInfo = AppHelper.getMetaAppInfo((String)appNum);
                    if (null == appInfo) continue;
                    menuAppIds.add(appInfo.getId());
                }
            }
            allCheckPermAppIds.addAll(menuAppIds);
        }
        HashMap<String, Boolean> hasSetPermItemFlag = new HashMap<String, Boolean>(32);
        for (String permItemId : pPermItems) {
            result.put(permItemId, Boolean.TRUE);
            hasSetPermItemFlag.put(permItemId, Boolean.FALSE);
        }
        for (String checkPermAppId : allCheckPermAppIds) {
            Map<String, Boolean> multiResult = BatchCheckPermCache.getMultiPermItemInfos(pUserId, checkPermAppId, entityNum);
            if (multiResult == null) {
                try {
                    logger.warn("BatchCheckPermCache.checkMultiPermItemInfos return null:" + "pUserId:" + pUserId + ", checkPermAppId:" + checkPermAppId + ", entityNum: " + entityNum);
                }
                catch (Exception e) {
                    logger.warn((Throwable)e);
                }
                continue;
            }
            for (Map.Entry<String, Boolean> entry : multiResult.entrySet()) {
                String tempPermItemId = entry.getKey();
                Boolean hasPermFlag = entry.getValue();
                if (!pPermItems.contains(tempPermItemId)) continue;
                Boolean hasSetFlag = (Boolean)hasSetPermItemFlag.get(tempPermItemId);
                if (Boolean.TRUE.equals(hasPermFlag)) {
                    result.put(tempPermItemId, Boolean.TRUE);
                    hasSetPermItemFlag.put(tempPermItemId, Boolean.TRUE);
                    continue;
                }
                if (!Boolean.FALSE.equals(hasSetFlag)) continue;
                result.put(tempPermItemId, hasPermFlag);
                hasSetPermItemFlag.put(tempPermItemId, Boolean.TRUE);
            }
        }
        return result;
    }

    public static Map<String, Boolean> checkMultiPermItemInfos(long pUserId, String pAppId, String pFormNum, Set<String> pPermItems) {
        boolean emptyCheckPermResult;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(8);
        if (pPermItems == null || pPermItems.isEmpty()) {
            return result;
        }
        Map<String, Boolean> multiResult = BatchCheckPermCache.getMultiPermItemInfos(pUserId, pAppId, pFormNum);
        boolean bl = emptyCheckPermResult = multiResult == null || multiResult.isEmpty();
        if (emptyCheckPermResult) {
            multiResult = new HashMap<String, Boolean>(8);
        }
        for (String permItemId : pPermItems) {
            if (emptyCheckPermResult) {
                result.put(permItemId, Boolean.FALSE);
                continue;
            }
            result.put(permItemId, Boolean.TRUE);
        }
        Iterator<Map.Entry<String, Boolean>> iterator = multiResult.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Boolean> entry = iterator.next();
            String tempPermItemId = entry.getKey();
            if (pPermItems.contains(tempPermItemId)) continue;
            iterator.remove();
        }
        result.putAll(multiResult);
        return result;
    }

    @Deprecated
    public static Map<String, Boolean> getCache4UserHasPermItems(boolean isList, long userId, long dimId, long assistDimId, String appId, String formNum) {
        Map extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet(1));
        HashMap<String, Object> extAppAndOrgnlAppRelParamMap = new HashMap<String, Object>(8);
        extAppAndOrgnlAppRelParamMap.put("entityNumList", Lists.newArrayList((Object[])new String[]{formNum}));
        extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        Map<String, String> entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("entOriAppIdMap", entOriAppIdMap);
        paramMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        return BatchCheckPermCache.getCache4UserHasPermItems(isList, userId, dimId, assistDimId, appId, formNum, paramMap);
    }

    public static Map<String, Boolean> getCache4UserHasPermItems(boolean isList, long userId, long dimId, long assistDimId, String appId, String formNum, Map<String, Object> paramMap) {
        boolean enableNoPermBtnHide = PermCommonUtil.isEnableNoPermBtnHide();
        if (!enableNoPermBtnHide) {
            return new HashMap<String, Boolean>(8);
        }
        String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        String realAppId = PermCommonUtil.getAppIdFromSuspectedAppNum(appId);
        String checkPermAppId = PermCommonUtil.getCheckPermAppId(realAppId, entityNum, paramMap);
        Map<Object, Object> result = new HashMap(8);
        String cacheType = CacheMrg.getType4UserHasPermItems();
        String cacheKey = BatchCheckPermCache.buildCacheKey(isList, userId, dimId, assistDimId, checkPermAppId, entityNum);
        if (cacheKey.contains("_0_0")) {
            HashSet permItemIds = new HashSet(EntityMetadataCache.getPermissionItems((String)entityNum));
            for (String permItemId : permItemIds) {
                result.put(permItemId, Boolean.FALSE);
            }
            logger.warn("neither dim nor assistDim own the correct orgViewType. So it doesn't have perm :" + result.keySet());
            return result;
        }
        String cache = CacheMrg.getCache(cacheType, cacheKey);
        if (StringUtils.isNotEmpty((String)cache)) {
            result = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        } else {
            result = BatchCheckPermCache.loadFromDB4UserHasPermItems(isList, userId, dimId, assistDimId, checkPermAppId, formNum);
            CacheMrg.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(result));
        }
        return result;
    }

    public static Map<String, Boolean> getCache4UserHasPermBtns(boolean isList, long userId, long dimId, long assistDimId, String appId, String formNum) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(8);
        return result;
    }

    private static Map<String, Boolean> loadFromDB4UserHasPermItems(boolean isList, long userId, long dimId, long assistDimId, String appId, String formNum) {
        Map<String, Boolean> result = null;
        result = BatchCheckPermCache.getHasPermItems(userId, appId, formNum);
        return result;
    }

    public static void putCache(String cacheType, String cacheKey, Map<String, Boolean> value) {
        String jsonString = SerializationUtils.toJsonString(value);
        CacheMrg.putCache(cacheType, cacheKey, jsonString);
    }

    private static Map<String, Boolean> preCheckPerm(long userId, String appId, String entityNum, Set<String> permItemIds) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(8);
        PermissionControlType permControl = FormHelper.getPermissionControlType(entityNum);
        if (!permControl.isControlFunction() || CollectionUtils.isEmpty(permItemIds)) {
            logger.debug("entity: " + entityNum + " needn't check permission or it doesn't bind any permission item.");
            for (String permItemId : permItemIds) {
                result.put(permItemId, Boolean.TRUE);
            }
            return result;
        }
        if (SuperUserCache.isSuperUser((long)userId) || PermCommonUtil.checkPermInAllUserApp(appId, entityNum)) {
            for (String permItemId : permItemIds) {
                result.put(permItemId, Boolean.TRUE);
            }
            logger.debug("user: " + userId + " is superUser or current entity: " + entityNum + " is in allUserApp.");
            return result;
        }
        if (PermCommonUtil.isCosmicUser(userId) && (entityNum.equals("perm_admintype") || entityNum.equals("perm_adminscheme"))) {
            for (String permItemId : permItemIds) {
                result.put(permItemId, Boolean.TRUE);
            }
            return result;
        }
        return null;
    }

    private static void preCheckAdminPerm(long adminId, String appId, String entityNum, Set<String> permItems, Map<String, Boolean> result, StringBuilder infoMessage) {
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        service.checkAdminPermItems(Long.valueOf(adminId), appId, entityNum, permItems, result);
        for (String permItemId : permItems) {
            result.put(permItemId, Boolean.FALSE);
        }
        String info = "user: " + adminId + " is admin and has current entity's all permission.";
        infoMessage.append(info).append("\r\n");
    }

    private static Map<String, Boolean> getHasPermItems(final long userId, String appId, String formNum) {
        if (StringUtils.isEmpty((String)formNum)) {
            logger.warn("formNum is null.");
            return null;
        }
        if (userId == 0L) {
            logger.warn("userId is null or userId is 0.");
            return null;
        }
        if (StringUtils.isEmpty((String)appId)) {
            logger.warn("appId is null.");
            return null;
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(8);
        final String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        HashSet<String> permItems = new HashSet<String>(EntityMetadataCache.getPermissionItems((String)entityNum));
        final String checkPermAppId = PermCommonUtil.getCheckPermAppId(appId, entityNum);
        Map<String, Boolean> preCheckMap = BatchCheckPermCache.preCheckPerm(userId, checkPermAppId, entityNum, permItems);
        if (preCheckMap != null) {
            return preCheckMap;
        }
        StringBuilder infoMessage = new StringBuilder();
        if (PermissionServiceHelper.isAdminUser((long)userId) && PermCommonUtil.needCheckAdminPerm(checkPermAppId, entityNum)) {
            BatchCheckPermCache.preCheckAdminPerm(userId, checkPermAppId, entityNum, permItems, result, infoMessage);
            if (PermissionServiceHelper.isAdminUser((long)userId, (String)ADMINTYPE_SUPERADMIN) && !AdminUtil.isAllowAdminBizOperate()) {
                int size = permItems.size();
                HashSet hasAdminPermIds = new HashSet(8);
                HashSet<String> hasNotAdminPermIds = new HashSet<String>(size);
                permItems.removeIf(permItemId -> {
                    for (Map.Entry entry : result.entrySet()) {
                        Boolean hasPerm;
                        String curPermItemId = (String)entry.getKey();
                        if (StringUtils.isEmpty((String)curPermItemId) || !Boolean.TRUE.equals(hasPerm = (Boolean)entry.getValue()) || !curPermItemId.equals(permItemId)) continue;
                        hasAdminPermIds.add(permItemId);
                        return true;
                    }
                    return false;
                });
                for (String permItemId2 : permItems) {
                    result.put(permItemId2, Boolean.FALSE);
                    hasNotAdminPermIds.add(permItemId2);
                }
                String info = "user: " + userId + "is superAdmin and doesn't allow to operate biz. hasAdminPerm: " + ((Object)hasAdminPermIds).toString() + " doesn't have adminPerm: " + ((Object)hasNotAdminPermIds).toString();
                infoMessage.append(info).append("\r\n");
                logger.warn(infoMessage.toString());
                return result;
            }
        }
        if (permItems.isEmpty()) {
            logger.warn(infoMessage.toString());
            return result;
        }
        final boolean isSingleBizRole = PermCommonUtil.isEnableSingleBizRole();
        String bizRoleId = null;
        if (isSingleBizRole && "".equals(bizRoleId = UserBizRoleCache.getSelBizRole((Long)userId))) {
            for (String permItemId3 : permItems) {
                result.put(permItemId3, Boolean.FALSE);
            }
            String info = "single bizrole is enable and user: " + userId + " doesn't have any default bizrole.";
            infoMessage.append(info).append("\r\n");
            logger.warn(infoMessage.toString());
            return result;
        }
        final String finalBizRoleId = bizRoleId;
        final boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        ConcurrentHashSet forbidPermItemIdSet = new ConcurrentHashSet(8);
        ConcurrentHashSet assignedPermItemIdSet = new ConcurrentHashSet(8);
        final Object[] params = new Object[]{userId, checkPermAppId, entityNum};
        final Object[] params2 = new Object[]{userId, checkPermAppId, entityNum, userId, checkPermAppId, entityNum};
        Future directDisPerm = null;
        if (!isSingleBizRole) {
            Callable<Void> queryDirectDisPerm = new Callable<Void>((Set)forbidPermItemIdSet, userId, infoMessage){
                final /* synthetic */ Set val$forbidPermItemIdSet;
                final /* synthetic */ long val$userId;
                final /* synthetic */ StringBuilder val$infoMessage;
                {
                    this.val$forbidPermItemIdSet = set;
                    this.val$userId = l;
                    this.val$infoMessage = stringBuilder;
                }

                @Override
                public Void call() throws Exception {
                    StringBuilder sql = new StringBuilder();
                    sql.append("select dp.fpermitemid as permitem ").append("from t_perm_disfunperm dp ").append("where dp.fuserid = ? and dp.fbizappid = ? and dp.fentitytypeid = ? ");
                    DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, r -> {
                        HashSet<String> list = new HashSet<String>(8);
                        while (r.next()) {
                            list.add(r.getString("permitem"));
                        }
                        this.val$forbidPermItemIdSet.addAll(list);
                        String info = "user: " + this.val$userId + " has disPerm in directDisPerm: " + list;
                        this.val$infoMessage.append(info).append("\r\n");
                        return Boolean.TRUE;
                    });
                    return null;
                }
            };
            directDisPerm = pool.submit((Callable)queryDirectDisPerm);
        }
        Callable<Void> queryBizRoleDisPerm = new Callable<Void>((Set)forbidPermItemIdSet, userId, infoMessage){
            final /* synthetic */ Set val$forbidPermItemIdSet;
            final /* synthetic */ long val$userId;
            final /* synthetic */ StringBuilder val$infoMessage;
            {
                this.val$forbidPermItemIdSet = set;
                this.val$userId = l;
                this.val$infoMessage = stringBuilder;
            }

            @Override
            public Void call() throws Exception {
                StringBuilder sql = new StringBuilder();
                sql.append("select bdp.fpermitemid as permitem ").append("from t_perm_bizroledisperm bdp ").append("join t_perm_userbizrole ub on bdp.fid = ub.fbizroleid ").append("where ub.fuserid = ? and bdp.fbizappid = ? and bdp.fentitytypeid = ? ");
                if (isSingleBizRole) {
                    sql.append(" and ub.fbizroleid = ").append(finalBizRoleId);
                }
                if (enableValidateTime) {
                    sql.append(" and (now() between ub.fstarttime and ub.fendtime or (ub.fstarttime is null and  ub.fendtime is null) or ").append(" (now() >= ub.fstarttime and ub.fendtime is null) or (ub.fstarttime is null and now() <=  ub.fendtime )) ");
                }
                sql.append(" union select bdp.fpermitemid as permitem ").append("from t_perm_bizroledisperm bdp ").append("join t_perm_usrgrpbizrole ugb on (bdp.fid = ugb.fbizroleid) ").append("join t_sec_usergroupstaff ugs on (ugs.fusergroupid=ugb.fusrgrpid) ").append("where ugs.fuserid = ? and bdp.fbizappid = ? and bdp.fentitytypeid = ? ");
                if (isSingleBizRole) {
                    sql.append(" and ugb.fbizroleid = ").append(finalBizRoleId);
                }
                DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params2, r -> {
                    HashSet<String> list = new HashSet<String>(8);
                    while (r.next()) {
                        list.add(r.getString("permitem"));
                    }
                    this.val$forbidPermItemIdSet.addAll(list);
                    String info = "user: " + this.val$userId + " has disPerm in bizroleDisPerm: " + list;
                    this.val$infoMessage.append(info).append("\r\n");
                    return Boolean.TRUE;
                });
                return null;
            }
        };
        Future bizRoleDisPerm = pool.submit((Callable)queryBizRoleDisPerm);
        try {
            if (!isSingleBizRole) {
                directDisPerm.get();
            }
            bizRoleDisPerm.get();
        }
        catch (Exception e) {
            logger.warn("PreOpenPagePermission: " + e.getMessage());
        }
        Sets.SetView excludeForbidSet = Sets.difference(permItems, (Set)forbidPermItemIdSet);
        Future directPerm = null;
        Future rolePerm = null;
        if (!isSingleBizRole) {
            Callable<Void> queryDirectPerm = new Callable<Void>((Set)assignedPermItemIdSet, userId, infoMessage){
                final /* synthetic */ Set val$assignedPermItemIdSet;
                final /* synthetic */ long val$userId;
                final /* synthetic */ StringBuilder val$infoMessage;
                {
                    this.val$assignedPermItemIdSet = set;
                    this.val$userId = l;
                    this.val$infoMessage = stringBuilder;
                }

                @Override
                public Void call() throws Exception {
                    StringBuilder sql = new StringBuilder();
                    sql.append("select fpermitemid as permitem");
                    sql.append(" from t_perm_userpermdetail");
                    sql.append(" where fuserid = ? and fbizappid = ? and fentitytypeid = ? and fdimid > 0 ");
                    DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, r -> {
                        HashSet<String> list = new HashSet<String>(8);
                        while (r.next()) {
                            list.add(r.getString("permitem"));
                        }
                        this.val$assignedPermItemIdSet.addAll(list);
                        String info = "user: " + this.val$userId + " has perm in directPerm: " + list;
                        this.val$infoMessage.append(info).append("\r\n");
                        return Boolean.TRUE;
                    });
                    return null;
                }
            };
            directPerm = pool.submit((Callable)queryDirectPerm);
            Callable<Void> queryRolePerm = new Callable<Void>((Set)assignedPermItemIdSet, infoMessage){
                final /* synthetic */ Set val$assignedPermItemIdSet;
                final /* synthetic */ StringBuilder val$infoMessage;
                {
                    this.val$assignedPermItemIdSet = set;
                    this.val$infoMessage = stringBuilder;
                }

                @Override
                public Void call() throws Exception {
                    HashMap<String, Object> commParam = new HashMap<String, Object>(8);
                    commParam.put("queryType", "getPermItemIdSet");
                    commParam.put("userId", userId);
                    commParam.put("appId", checkPermAppId);
                    commParam.put("entityNum", entityNum);
                    commParam.put("enable", BatchCheckPermCache.BILLFORMVIEW);
                    commParam.put("selectTSecUserGroupStaff", BatchCheckPermCache.BILLFORMVIEW);
                    commParam.put("selectTPermRolePermDetail", BatchCheckPermCache.BILLFORMVIEW);
                    commParam.put("selectTPermRole", BatchCheckPermCache.BILLFORMVIEW);
                    Map<String, Object> commRoleInfoMap = PermRoleHelper.getCommRoleInfoMap(commParam);
                    if (CollectionUtils.isEmpty(commRoleInfoMap)) {
                        return null;
                    }
                    Set comPermItemIdSet = (Set)commRoleInfoMap.get("permItemIdSet");
                    if (CollectionUtils.isEmpty((Collection)comPermItemIdSet)) {
                        return null;
                    }
                    this.val$assignedPermItemIdSet.addAll(comPermItemIdSet);
                    String info = "user: " + userId + " has perm in rolePerm: " + comPermItemIdSet;
                    this.val$infoMessage.append(info).append("\r\n");
                    return null;
                }
            };
            rolePerm = pool.submit((Callable)queryRolePerm);
        }
        Callable<Void> queryBizroleFuncPerm = new Callable<Void>((Set)assignedPermItemIdSet, userId, infoMessage){
            final /* synthetic */ Set val$assignedPermItemIdSet;
            final /* synthetic */ long val$userId;
            final /* synthetic */ StringBuilder val$infoMessage;
            {
                this.val$assignedPermItemIdSet = set;
                this.val$userId = l;
                this.val$infoMessage = stringBuilder;
            }

            @Override
            public Void call() throws Exception {
                StringBuilder sql = new StringBuilder();
                sql.append("select bp.fpermitemid as permitem ").append("from t_perm_userbizrole ub ").append("join t_perm_bizroleperm bp on bp.fid = ub.fbizroleid ").append("where ub.fuserid = ? and bp.fbizappid = ? and bp.fentitytypeid = ? ");
                if (isSingleBizRole) {
                    sql.append(" and ub.fbizroleid = ").append(finalBizRoleId);
                }
                if (enableValidateTime) {
                    sql.append(" and (now() between ub.fstarttime and ub.fendtime or (ub.fstarttime is null and  ub.fendtime is null) or ").append(" (now() >= ub.fstarttime and ub.fendtime is null) or (ub.fstarttime is null and now() <=  ub.fendtime )) ");
                }
                sql.append(" union select bp.fpermitemid as permitem ").append("from t_perm_bizroleperm bp ").append("join t_perm_usrgrpbizrole ugb on (bp.fid = ugb.fbizroleid) ").append("join t_sec_usergroupstaff ugs on (ugs.fusergroupid=ugb.fusrgrpid) ").append("where ugs.fuserid = ? and bp.fbizappid = ? and bp.fentitytypeid = ? ");
                if (isSingleBizRole) {
                    sql.append(" and ugb.fbizroleid = ").append(finalBizRoleId);
                }
                DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params2, r -> {
                    HashSet<String> list = new HashSet<String>(8);
                    while (r.next()) {
                        list.add(r.getString("permitem"));
                    }
                    this.val$assignedPermItemIdSet.addAll(list);
                    String info = "user: " + this.val$userId + " has perm in bizroleFuncPerm: " + list;
                    this.val$infoMessage.append(info).append("\r\n");
                    return Boolean.TRUE;
                });
                return null;
            }
        };
        Future bizRoleFuncPerm = pool.submit((Callable)queryBizroleFuncPerm);
        Callable<Void> queryBizroleHasRolePerm = new Callable<Void>((Set)assignedPermItemIdSet, userId, infoMessage){
            final /* synthetic */ Set val$assignedPermItemIdSet;
            final /* synthetic */ long val$userId;
            final /* synthetic */ StringBuilder val$infoMessage;
            {
                this.val$assignedPermItemIdSet = set;
                this.val$userId = l;
                this.val$infoMessage = stringBuilder;
            }

            @Override
            public Void call() throws Exception {
                StringBuilder sql = new StringBuilder();
                sql.append("select rpd.fpermitemid as permitem ").append("from t_perm_userbizrole ub ").append("join t_perm_bizrolecomrole bc on bc.fid = ub.fbizroleid ").append("join t_perm_role r on bc.froleid = r.fid ").append("join t_perm_rolepermdetial rpd on rpd.froleid = r.fid ").append("where r.fenable = '1' ").append("and ub.fuserid = ? and rpd.fbizappid = ? and rpd.fentitytypeid = ? ");
                if (isSingleBizRole) {
                    sql.append(" and ub.fbizroleid = ").append(finalBizRoleId);
                }
                if (enableValidateTime) {
                    sql.append(" and (now() between ub.fstarttime and ub.fendtime or (ub.fstarttime is null and  ub.fendtime is null) or ").append(" (now() >= ub.fstarttime and ub.fendtime is null) or (ub.fstarttime is null and now() <=  ub.fendtime )) ");
                }
                sql.append(" union select rpd.fpermitemid as permitem ").append("from t_perm_bizrolecomrole bc ").append("join t_perm_usrgrpbizrole ugb on bc.fid = ugb.fbizroleid ").append("join t_sec_usergroupstaff ugs on (ugs.fusergroupid=ugb.fusrgrpid) ").append("join t_perm_role r on bc.froleid = r.fid ").append("join t_perm_rolepermdetial rpd on rpd.froleid = r.fid ").append("where r.fenable = '1' ").append("and ugs.fuserid = ? and rpd.fbizappid = ? and rpd.fentitytypeid = ? ");
                if (isSingleBizRole) {
                    sql.append(" and ugb.fbizroleid = ").append(finalBizRoleId);
                }
                DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params2, r -> {
                    HashSet<String> list = new HashSet<String>(8);
                    while (r.next()) {
                        list.add(r.getString("permitem"));
                    }
                    this.val$assignedPermItemIdSet.addAll(list);
                    String info = "user: " + this.val$userId + " has perm in bizRoleHasRolePerm: " + list;
                    this.val$infoMessage.append(info).append("\r\n");
                    return Boolean.TRUE;
                });
                return null;
            }
        };
        Future bizRoleHasRolePerm = pool.submit((Callable)queryBizroleHasRolePerm);
        try {
            if (!isSingleBizRole) {
                rolePerm.get();
                directPerm.get();
            }
            bizRoleFuncPerm.get();
            bizRoleHasRolePerm.get();
        }
        catch (Exception e) {
            logger.warn("PreOpenPagePermission: " + e.getMessage());
        }
        Sets.SetView excludeForbidAndAssignedSet = Sets.difference((Set)excludeForbidSet, (Set)assignedPermItemIdSet);
        for (String permItemId4 : assignedPermItemIdSet) {
            result.put(permItemId4, Boolean.TRUE);
        }
        for (String permItemId4 : forbidPermItemIdSet) {
            if (result.containsKey(permItemId4)) continue;
            result.put(permItemId4, Boolean.FALSE);
        }
        for (String permItemId4 : excludeForbidAndAssignedSet) {
            result.put(permItemId4, Boolean.FALSE);
        }
        if (null != excludeForbidAndAssignedSet && !excludeForbidAndAssignedSet.isEmpty()) {
            String info = "these permitems which have not been assigned are now seen to be NOperm: " + excludeForbidAndAssignedSet;
            infoMessage.append(info).append("\r\n");
        }
        logger.debug(infoMessage.toString());
        return result;
    }
}

