/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.extplugin.PluginCall;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.permission.api.ext.IPermCacheExt;
import kd.bos.permission.cache.util.PermLocalCacheUtil;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.sdk.annotation.SdkInternal;

public class CacheMrg {
    private static final String BS_PERM_REGION = "PERMISSION";
    private static DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("PERMISSION", new DistributeCacheHAPolicy(true, true));
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Perm_CacheMrg_Pool", (int)2);
    @SdkInternal
    public static final int expireTime = 86400;
    private static final String BS_PERM = "BS_PERM_";
    @SdkInternal
    public static final String DATA_PERM_OBJ = "BS_PERM_DATA_PERM_OBJ";
    @SdkInternal
    public static final String DATA_RULE_OBJ = "BS_PERM_DATA_RULE_OBJ";
    @SdkInternal
    public static final String DATA_PERM = "BS_PERM_DATA_PERM";
    @SdkInternal
    public static final String DATA_RULE = "BS_PERM_DATA_RULE";
    @SdkInternal
    public static final String FIELD_PERM_OBJ = "BS_PERM_FIELD_PERM_OBJ";
    @SdkInternal
    public static final String FIELD_PERM = "BS_PERM_FIELD_PERM";
    @SdkInternal
    public static final String OPERATION_RULE_OBJ = "BS_PERM_OPERATION_RULE_OBJ";
    @SdkInternal
    public static final String OPERATION_RULE = "BS_PERM_OPERATION_RULE";
    @SdkInternal
    public static final String ROLE = "BS_PERM_ROLE";
    @SdkInternal
    public static final String ROLE_PERM = "BS_PERM_ROLE_PERM";
    @SdkInternal
    public static final String COMMROLE_FUNPERM_SERVICE = "BS_PERM_COMMROLE_FUNPERM_SERVICE";
    @SdkInternal
    public static final String BIZROLE_FUNPERM_SERVICE = "BS_PERM_BIZROLE_FUNPERM_SERVICE";
    @SdkInternal
    public static final String USERDIRECT_FUNPERM_SERVICE = "BS_PERM_USERDIRECT_FUNPERM_SERVICE";
    @SdkInternal
    public static final String USER = "BS_PERM_USER";
    @SdkInternal
    public static final String USER_PERM = "BS_PERM_USER_PERM";
    @SdkInternal
    public static final String USER_ROLE = "BS_PERM_USER_ROLE";
    @SdkInternal
    public static final String USER_ROLE_DIM = "BS_PERM_USER_ROLE_DIM";
    @SdkInternal
    public static final String EDITING_PERM_USERID = "BS_PERM_EDITING_PERM_USERID";
    @SdkInternal
    public static final String USRGRP_ROLE_DIM = "BS_PERM_USRGRP_ROLE_DIM";
    @SdkInternal
    public static final String DIS_FUN_PERM = "BS_PERM_DIS_FUN_PERM";
    @SdkInternal
    public static final String USER_DIRECT_FUN_PERM = "BS_PERM_USER_DIRECT_FUN_PERM";
    @SdkInternal
    public static final String USER_DIRECT_DISFUN_PERM = "BS_PERM_USER_DIRECT_DISFUN_PERM";
    @SdkInternal
    public static final String USER_APP = "BS_PERM_USER_APP";
    @SdkInternal
    public static final String USER_MENU = "BS_PERM_USER_MENU";
    @SdkInternal
    public static final String USABLE_ENTITIES = "BS_PERM_USABLE_ENTITIES";
    @SdkInternal
    public static final String GETAPPIDBYFORMNUM = "BS_PERM_GETAPPIDBYFORMNUM";
    @SdkInternal
    public static final String GETEXTAPPANDORGNLAPPREL = "BS_PERM_GETEXTAPPANDORGNLAPPREL";
    @SdkInternal
    public static final String GETPERMCONTROLTYPE = "BS_PERM_getPermControlType";
    @SdkInternal
    public static final String USER_OWN_BUSIROLEIDS = "BS_PERM_USER_OWN_BUSIROLEIDS";
    @SdkInternal
    public static final String USER_OWN_COMMROLEIDS = "BS_PERM_USER_OWN_COMMROLEIDS";
    @SdkInternal
    public static final String USER_OWN_JUSTCOMMROLEIDS = "BS_PERM_USER_OWN_JUSTCOMMROLEIDS";
    @SdkInternal
    public static final String ADMIN_CHARGE_USERS = "BS_PERM_ADMIN_CHARGE_USERS";
    @SdkInternal
    public static final String SUPERUSER = "BS_PERM_SUPERUSER";
    @SdkInternal
    public static final String ADMIN = "BS_PERM_ADMIN";
    @SdkInternal
    public static final String ADMIN_OLD = "BS_PERM_ADMIN_OLD";
    @SdkInternal
    public static final String ADMIN_GROUP = "BS_PERM_ADMIN_GROUP";
    @SdkInternal
    public static final String HAS_ENABLE_OLDADMIN = "BS_PERM_HAS_ENABLE_OLDADMIN";
    @SdkInternal
    public static final String HASPERMDIMOBJ = "BS_PERM_HASPERMDIMOBJ";
    @SdkInternal
    public static final String CUSTOMPERMSERV = "BS_PERM_CUSTOM_PERMSERV";
    @SdkInternal
    public static final String CUSTOM_DATARULE = "BS_PERM_CUSTOM_DATARULE";
    @SdkInternal
    public static final String DATA_LOADED = "PERM_DATA_LOADED";
    @SdkInternal
    public static final String USER_BIZROLE_SEL = "BS_PERM_USER_BIZROLE_SEL";
    @SdkInternal
    public static final String USER_BIZROLE_DEF = "BS_PERM_USER_BIZROLE_DEF";
    @SdkInternal
    public static final String USER_MAYCHANGE_LOGIN_ORG = "BS_PERM_USER_MAYCHANGE_LOGIN_ORG";
    @SdkInternal
    public static final String APP_USER = "BS_PERM_APP_USER";
    @SdkInternal
    public static final String ADMIN_CHARGE_ORGS = "BS_PERM_ADMIN_CHARGE_ORGS";
    @SdkInternal
    public static final String USER_HASPERMITEMS = "BS_PERM_USER_HASPERMITEMS";
    @SdkInternal
    public static final String USER_HASPERMBTNS = "BS_PERM_USER_HASPERMBTNS";
    @SdkInternal
    public static final String EXTRA_APPCHECKPERM = "BS_PERM_EXTRA_APPCHECKPERM";
    @SdkInternal
    public static final String LOCALCACHEKEY_GETAPPIDBYFORMNUM = "BS_PERM_LOCALCACHEKEY_GETAPPIDBYFORMNUM";
    @SdkInternal
    public static final String LOCALCACHEKEY_GETEXTAPPANDORGNLAPPREL = "BS_PERM_LOCALCACHEKEY_GETEXTAPPANDORGNLAPPREL";
    @SdkInternal
    public static final String LOCALCACHEKEY_GETENTORIDS = "BS_PERM_LOCALCACHEKEY_GETENTORIDS";
    @SdkInternal
    public static final String LOCALCACHEKEY_GETPERMCONTROLTYPE = "BS_PERM_GETPERMCONTROLTYPE";
    private static Log logger = LogFactory.getLog(CacheMrg.class);
    private static String[] clearDataEntityArr = new String[]{"perm_admin", "perm_adminscheme", "perm_busirole", "perm_dataperm", "perm_datarule", "perm_datarules", "perm_disfunperm", "perm_fieldperm", "perm_operationrule", "perm_director", "perm_operationruleobj", "perm_exceptrole", "perm_exceptuser", "perm_exceptusrgrp", "perm_ctrltype", "perm_role", "perm_roledataperm", "perm_roledatarules", "perm_rolefieldperm", "perm_roleperm", "perm_superuser", "perm_userdataperm", "perm_userdatarules", "perm_userfieldperm", "perm_userperm", "perm_userrole", "perm_custompermserv", "perm_userdefbizrole", "perm_bizrole", "perm_admingroup", "bos_user", "bos_usergroupstaff", "perm_alluserappent", "perm_userbizrole", "perm_olddataruleenable"};

    private static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e3a\u7a7a\u3002", (String)"CacheMrg_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        }
        return acctId;
    }

    private static List<String> getExtendCacheTypeList() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IPermCacheExt.class, (String)"kd.bos.permission.api.ext.IPermCacheExt", null);
            PluginCall call = p -> {
                List tempCacheTypes;
                ArrayList tempResult = new ArrayList();
                if (p != null && (tempCacheTypes = p.registerCacheTypeList()) != null && !tempCacheTypes.isEmpty()) {
                    tempResult.addAll(tempCacheTypes);
                }
                return tempResult;
            };
            List pluginResults = pluginProxy.callReplaceIfPresent(call);
            if (pluginResults != null && !pluginResults.isEmpty()) {
                for (List pluginResultList : pluginResults) {
                    if (pluginResultList == null || pluginResultList.isEmpty()) continue;
                    result.addAll(pluginResultList);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return result;
    }

    private static List<String> getExtendMetaDataList() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IPermCacheExt.class, (String)"kd.bos.permission.api.ext.IPermCacheExt", null);
            PluginCall call = p -> {
                List extMetaDataList;
                ArrayList tempResult = new ArrayList();
                if (p != null && (extMetaDataList = p.registerMetaDataList()) != null && !extMetaDataList.isEmpty()) {
                    tempResult.addAll(extMetaDataList);
                }
                return tempResult;
            };
            List pluginResults = pluginProxy.callReplaceIfPresent(call);
            if (pluginResults != null && !pluginResults.isEmpty()) {
                for (List pluginResultList : pluginResults) {
                    if (pluginResultList == null || pluginResultList.isEmpty()) continue;
                    result.addAll(pluginResultList);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return result;
    }

    @SdkInternal
    public static String getType4CommRoleFunPermService() {
        return "BS_PERM_COMMROLE_FUNPERM_SERVICE_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4BizRoleFunPermService() {
        return "BS_PERM_BIZROLE_FUNPERM_SERVICE_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserDirectFunPermService() {
        return "BS_PERM_USERDIRECT_FUNPERM_SERVICE_" + CacheMrg.getAcctId();
    }

    public static String getType4DataPermObj() {
        return "BS_PERM_DATA_PERM_OBJ_" + CacheMrg.getAcctId();
    }

    public static String getType4DataRuleObj() {
        return "BS_PERM_DATA_RULE_OBJ_" + CacheMrg.getAcctId();
    }

    public static String getType4DataRule() {
        return "BS_PERM_DATA_RULE_" + CacheMrg.getAcctId();
    }

    public static String getType4DataPerm() {
        return "BS_PERM_DATA_PERM_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4FieldPermObj() {
        return "BS_PERM_FIELD_PERM_OBJ_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4FieldPerm() {
        return "BS_PERM_FIELD_PERM_" + CacheMrg.getAcctId();
    }

    public static String getType4OperationRuleObj() {
        return "BS_PERM_OPERATION_RULE_OBJ_" + CacheMrg.getAcctId();
    }

    public static String getType4OperationRule() {
        return "BS_PERM_OPERATION_RULE_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4Role() {
        return "BS_PERM_ROLE_" + CacheMrg.getAcctId();
    }

    public static String getType4RolePerm() {
        return "BS_PERM_ROLE_PERM_" + CacheMrg.getAcctId();
    }

    public static String getType4User() {
        return "BS_PERM_USER_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserPerm() {
        return "BS_PERM_USER_PERM_" + CacheMrg.getAcctId();
    }

    public static String getType4UserRole() {
        return "BS_PERM_USER_ROLE_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserRoleDim() {
        return "BS_PERM_USER_ROLE_DIM_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4EditingPermUserId() {
        return "BS_PERM_EDITING_PERM_USERID_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UsrGrpRoleDim() {
        return "BS_PERM_USRGRP_ROLE_DIM_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4SuperUser() {
        return "BS_PERM_SUPERUSER_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4AdminUser() {
        return "BS_PERM_ADMIN_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4AdminUserOld() {
        return "BS_PERM_ADMIN_OLD_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4AdminGroupUser() {
        return "BS_PERM_ADMIN_GROUP_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4HasEnableOldAdmin() {
        return "BS_PERM_HAS_ENABLE_OLDADMIN_" + CacheMrg.getAcctId();
    }

    public static String getHasPermDimObjs() {
        return "BS_PERM_HASPERMDIMOBJ_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getCustomPermServ() {
        return "BS_PERM_CUSTOM_PERMSERV_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4CustomDataRule() {
        return "BS_PERM_CUSTOM_DATARULE_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4DisFunPerm() {
        return "BS_PERM_DIS_FUN_PERM_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserDirectFunPerm() {
        return "BS_PERM_USER_DIRECT_FUN_PERM_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserDirectDisFunPerm() {
        return "BS_PERM_USER_DIRECT_DISFUN_PERM_" + CacheMrg.getAcctId();
    }

    public static String getType4UserApp() {
        return "BS_PERM_USER_APP_" + CacheMrg.getAcctId();
    }

    public static String getType4UserMenu() {
        return "BS_PERM_USER_MENU_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UsableEntities() {
        return "BS_PERM_USABLE_ENTITIES_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4GetAppIdByFormNum() {
        return "BS_PERM_GETAPPIDBYFORMNUM_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4GetExtAppAndOrgnlAppRel() {
        return "BS_PERM_GETEXTAPPANDORGNLAPPREL_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4GetPermControlType() {
        return "BS_PERM_getPermControlType_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserOwnBusiRoleIds() {
        return "BS_PERM_USER_OWN_BUSIROLEIDS_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserOwnCommRoleIds() {
        return "BS_PERM_USER_OWN_COMMROLEIDS_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserOwnJustCommRoleIds() {
        return "BS_PERM_USER_OWN_JUSTCOMMROLEIDS_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getTypeAdminChargeUsers() {
        return "BS_PERM_ADMIN_CHARGE_USERS_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserBizRoleSel() {
        return "BS_PERM_USER_BIZROLE_SEL_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserBizRoleDef() {
        return "BS_PERM_USER_BIZROLE_DEF_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserMayChangeLoginOrg() {
        return "BS_PERM_USER_MAYCHANGE_LOGIN_ORG_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserHasPermItems() {
        return "BS_PERM_USER_HASPERMITEMS_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4UserHasPermBtns() {
        return "BS_PERM_USER_HASPERMBTNS_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4AppUser() {
        return "BS_PERM_APP_USER_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4AdminChargeOrgs() {
        return "BS_PERM_ADMIN_CHARGE_ORGS_" + CacheMrg.getAcctId();
    }

    @SdkInternal
    public static String getType4ExtraAppCheckPerm() {
        return CacheMrg.getType(EXTRA_APPCHECKPERM);
    }

    @SdkInternal
    public static String getType(String typeKey) {
        return typeKey + "_" + CacheMrg.getAcctId();
    }

    private static String[] getClearDataEntityArr() {
        String[] result = clearDataEntityArr;
        List<String> extendMetaDataList = CacheMrg.getExtendMetaDataList();
        if (extendMetaDataList != null && !extendMetaDataList.isEmpty()) {
            List<String> orgnlClearList = Arrays.asList(clearDataEntityArr);
            orgnlClearList.addAll(extendMetaDataList);
            result = orgnlClearList.toArray(new String[orgnlClearList.size()]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllCache() {
        StringBuilder info = new StringBuilder();
        info.append("[clearAllCache]has cleaned redis type = \n ");
        try {
            Map<String, String> cacheTypeMap = CacheMrg.getAllCacheTypes();
            int i = 1;
            for (Map.Entry<String, String> entry : cacheTypeMap.entrySet()) {
                info.append(i++).append(".[").append(entry.getKey()).append("] \n");
            }
            CacheMrg.clearCache(cacheTypeMap.keySet().toArray(new String[0]));
            info.append("has cleaned. \r\n");
            int length = CacheMrg.getClearDataEntityArr().length;
            int half = length / 2;
            CountDownLatch countDownLatch = new CountDownLatch(length);
            AtomicInteger atomicInteger = new AtomicInteger(1);
            CacheMrg.asyncClearDataEntityCache(0, half, countDownLatch, atomicInteger);
            CacheMrg.asyncClearDataEntityCache(half + 1, length, countDownLatch, atomicInteger);
        }
        catch (Exception e) {
            logger.warn("[clearAllCache]\u6e05\u7a7a\u6743\u9650\u7f13\u5b58\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a{} ", (Object)e.getMessage(), (Object)e);
        }
        finally {
            logger.debug(info.toString());
        }
    }

    public static Map<String, String> getAllCacheTypes() {
        TreeMap<String, String> cacheTypeMap = new TreeMap<String, String>();
        cacheTypeMap.put(CacheMrg.getType4CommRoleFunPermService(), ResManager.loadKDString((String)"\u7528\u6237\u7684\u901a\u7528\u89d2\u8272\u9274\u6743\u65b9\u6cd5\u7ed3\u679c", (String)"CacheMrg_1", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4BizRoleFunPermService(), ResManager.loadKDString((String)"\u7528\u6237\u7684\u4e1a\u52a1\u89d2\u8272\u9274\u6743\u65b9\u6cd5\u7ed3\u679c", (String)"CacheMrg_2", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserDirectFunPermService(), ResManager.loadKDString((String)"\u7528\u6237\u7684\u76f4\u63a5\u6388\u6743\u9274\u6743\u65b9\u6cd5\u7ed3\u679c", (String)"CacheMrg_3", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4DataPermObj(), ResManager.loadKDString((String)"\u6388\u6743\u5bf9\u8c61\u5206\u914d\u7684\u6570\u636e\u6743\u9650", (String)"CacheMrg_4", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4DataRuleObj(), ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5206\u914d\u7684\u6570\u636e\u89c4\u5219", (String)"CacheMrg_5", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4DataRule(), ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219", (String)"CacheMrg_6", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4DataPerm(), ResManager.loadKDString((String)"\u6570\u636e\u6743\u9650", (String)"CacheMrg_7", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4FieldPerm(), ResManager.loadKDString((String)"\u5b57\u6bb5\u6743\u9650", (String)"CacheMrg_8", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4FieldPermObj(), ResManager.loadKDString((String)"\u6388\u6743\u5bf9\u8c61\u5206\u914d\u7684\u5b57\u6bb5\u6743\u9650", (String)"CacheMrg_9", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4OperationRuleObj(), ResManager.loadKDString((String)"\u64cd\u4f5c\u89c4\u5219\u5206\u914d\u7684\u4e1a\u52a1\u5bf9\u8c61", (String)"CacheMrg_10", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4OperationRule(), ResManager.loadKDString((String)"\u64cd\u4f5c\u89c4\u5219", (String)"CacheMrg_11", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4Role(), ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272", (String)"CacheMrg_12", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4RolePerm(), ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u6743\u9650", (String)"CacheMrg_13", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4User(), ResManager.loadKDString((String)"\u7528\u6237", (String)"CacheMrg_14", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserPerm(), ResManager.loadKDString((String)"\u7528\u6237\u6743\u9650", (String)"CacheMrg_15", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserRole(), ResManager.loadKDString((String)"\u7528\u6237\u89d2\u8272", (String)"CacheMrg_16", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4SuperUser(), ResManager.loadKDString((String)"\u5168\u529f\u80fd\u7528\u6237", (String)"CacheMrg_17", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4AdminUser(), ResManager.loadKDString((String)"\u7ba1\u7406\u5458", (String)"CacheMrg_18", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4DisFunPerm(), ResManager.loadKDString((String)"\u7981\u7528\u6743\u9650", (String)"CacheMrg_19", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserApp(), ResManager.loadKDString((String)"\u7528\u6237\u6709\u6743\u7684\u5e94\u7528", (String)"CacheMrg_20", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserMenu(), ResManager.loadKDString((String)"\u7528\u6237\u6709\u6743\u7684\u83dc\u5355", (String)"CacheMrg_21", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UsableEntities(), ResManager.loadKDString((String)"\u7528\u6237\u6709\u6743\u4f7f\u7528\u7684\u5b9e\u4f53", (String)"CacheMrg_22", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4GetAppIdByFormNum(), ResManager.loadKDString((String)"\u6839\u636e\u8868\u5355\u83b7\u53d6\u5e94\u7528ID", (String)"CacheMrg_23", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4GetExtAppAndOrgnlAppRel(), ResManager.loadKDString((String)"\u5e94\u7528ID-\u539f\u751f\u5e94\u7528ID", (String)"CacheMrg_24", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4GetPermControlType(), ResManager.loadKDString((String)"\u5b9e\u4f53\u8868\u5355\u6743\u9650\u63a7\u5236\u7c7b\u578b", (String)"CacheMrg_25", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserOwnBusiRoleIds(), ResManager.loadKDString((String)"\u7528\u6237\u62e5\u6709\u7684\u4e1a\u52a1\u89d2\u8272ID", (String)"CacheMrg_26", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserOwnCommRoleIds(), ResManager.loadKDString((String)"\u7528\u6237\u62e5\u6709\u7684\u901a\u7528\u89d2\u8272ID(\u901a\u7528\u89d2\u8272+\u4e1a\u52a1\u89d2\u8272\u4e2d\u7684\u901a\u7528\u89d2\u8272)", (String)"CacheMrg_27", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserOwnJustCommRoleIds(), ResManager.loadKDString((String)"\u7528\u6237\u62e5\u6709\u7684\u901a\u7528\u89d2\u8272ID\uff08\u53ea\u5305\u542b\u901a\u7528\u89d2\u8272-\u7528\u6237\u3001\u901a\u7528\u89d2\u8272-\u7528\u6237\u7ec4-\u7528\u6237\u7684\u5173\u7cfb\u4e2d\u5173\u8054\u7684\u5df2\u542f\u7528\u7684\u901a\u7528\u89d2\u8272\uff0c\u4e0d\u5305\u542b\u4e1a\u52a1\u89d2\u8272\uff09", (String)"CacheMrg_28", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getTypeAdminChargeUsers(), ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u4e0b\u7684\u7528\u6237", (String)"CacheMrg_29", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getHasPermDimObjs(), ResManager.loadKDString((String)"\u6709\u6743\u9650\u7684\u9694\u79bb\u7ef4\u5ea6\u7f13\u5b58", (String)"CacheMrg_30", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getCustomPermServ(), ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6743\u9650\u670d\u52a1", (String)"CacheMrg_31", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserBizRoleSel(), ResManager.loadKDString((String)"\u7528\u6237\u5f53\u524d\u9009\u4e2d\u7684\u4e1a\u52a1\u89d2\u8272", (String)"CacheMrg_32", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserBizRoleDef(), ResManager.loadKDString((String)"\u7528\u6237\u9ed8\u8ba4\u9009\u4e2d\u7684\u4e1a\u52a1\u89d2\u8272", (String)"CacheMrg_33", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserMayChangeLoginOrg(), ResManager.loadKDString((String)"\u6807\u8bb0\u7528\u6237\u53ef\u80fd\u9700\u8981\u66f4\u65b0\u4e00\u4e0b\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u4ee5\u53ca\u9ed8\u8ba4\u767b\u5f55\u7ec4\u7ec7", (String)"CacheMrg_34", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4CustomDataRule(), ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6570\u636e\u89c4\u5219", (String)"CacheMrg_35", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4AdminGroupUser(), ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5206\u7ec4", (String)"CacheMrg_36", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4AdminUserOld(), ResManager.loadKDString((String)"\u65e7\u7ba1\u7406\u5458", (String)"CacheMrg_37", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserHasPermBtns(), ResManager.loadKDString((String)"\u7528\u6237\u6709\u6743\u7684\u6309\u94ae\u7684\u96c6\u5408", (String)"CacheMrg_38", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UserHasPermItems(), ResManager.loadKDString((String)"\u7528\u6237\u6709\u6743\u7684\u6743\u9650\u9879\u7684\u96c6\u5408", (String)"CacheMrg_39", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4AppUser(), ResManager.loadKDString((String)"APP\u5206\u914d\u4e86\u4f7f\u7528\u6743\u7684\u7528\u6237", (String)"CacheMrg_40", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4AdminChargeOrgs(), ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u4e1a\u52a1\u5355\u5143\u7ba1\u8f96\u8303\u56f4", (String)"CacheMrg_41", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4UsrGrpRoleDim(), ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u89d2\u8272\u9694\u79bb\u7ef4\u5ea6", (String)"CacheMrg_42", (String)"bos-permission-cache", (Object[])new Object[0]));
        cacheTypeMap.put(CacheMrg.getType4ExtraAppCheckPerm(), ResManager.loadKDString((String)"\u989d\u5916\u8ffd\u52a0\u7684\u5e94\u7528\u9a8c\u6743\u4fe1\u606f\u8bb0\u5f55", (String)"CacheMrg_43", (String)"bos-permission-cache", (Object[])new Object[0]));
        List<String> extendCacheTypeList = CacheMrg.getExtendCacheTypeList();
        extendCacheTypeList.forEach(cacheType -> cacheTypeMap.put((String)cacheType, ResManager.loadKDString((String)"\u901a\u8fc7\u4e1a\u52a1\u6269\u5c55\u70b9\u83b7\u53d6\u6ce8\u518c\u8fdb\u6765\u7684\u7f13\u5b58", (String)"CacheMrg_44", (String)"bos-permission-cache", (Object[])new Object[0])));
        return cacheTypeMap;
    }

    @SdkInternal
    public static void clearType4EditingPermUserId() {
        String type4EditingPermUserId = CacheMrg.getType4EditingPermUserId();
        CacheMrg.clearCache(type4EditingPermUserId);
    }

    @SdkInternal
    public static void clearAllLocalCache() {
        StringBuilder info = new StringBuilder();
        try {
            String langStr = RequestContext.get().getLang().name();
            PermLocalCacheUtil.removeLocalCacheByKey((String[])new String[]{LOCALCACHEKEY_GETAPPIDBYFORMNUM, LOCALCACHEKEY_GETEXTAPPANDORGNLAPPREL, "BS_PERM_LOCALCACHEKEY_GETENTORIDS_" + langStr, LOCALCACHEKEY_GETPERMCONTROLTYPE});
        }
        catch (Exception e) {
            logger.warn("CacheMrg.clearAllLocalCache error", (Throwable)e);
        }
        finally {
            logger.debug(info.toString());
        }
    }

    private static void asyncClearDataEntityCache(int startIndex, int endIndex, CountDownLatch countDownLatch, AtomicInteger index) {
        pool.execute(() -> {
            StringBuilder info = new StringBuilder("DataEntityCache.entityNum = \r\n");
            String[] clearArr = CacheMrg.getClearDataEntityArr();
            for (int i = startIndex; i < endIndex; ++i) {
                String entityNum = clearArr[i];
                CacheMrg.clearDataEntityCache(entityNum);
                info.append(index.getAndIncrement()).append(".[").append(entityNum).append("] \r\n");
                countDownLatch.countDown();
            }
            logger.debug(info.toString());
        });
    }

    public static void clearHasEnableOldAdmin() {
        String key = String.format("%s%s", "clearHasEnableOldAdmin_", RequestContext.get().getAccountId());
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            CacheMrg.clearHasEnableOldAdminPri();
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("clearHasEnableOldAdmin_", "1");
            return map;
        });
        String clearHasEnableOldAdmin = (String)threadCacheMap.get("clearHasEnableOldAdmin_");
        if (!"1".equals(clearHasEnableOldAdmin)) {
            CacheMrg.clearHasEnableOldAdminPri();
            return;
        }
    }

    private static void clearHasEnableOldAdminPri() {
        try {
            String cleanType = CacheMrg.getType4HasEnableOldAdmin();
            ArrayList<String> delKey = new ArrayList<String>(1);
            delKey.add(cleanType);
            CacheMrg.clearCache(delKey.toArray(new String[0]));
            String sql = "select FID from T_META_FORMDESIGN where FNUMBER = 'perm_oldadminenable'";
            ResultSetHandler<Void> action = new ResultSetHandler<Void>(){

                public Void handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        CacheMrg.clearDataEntityCache("perm_oldadminenable");
                    }
                    return null;
                }
            };
            DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action);
        }
        catch (Exception e) {
            logger.warn("[clearHasEnableOldAdmin]\u6e05\u7a7a\u542f\u7528\u7ba1\u7406\u5458\u72b6\u6001\u6807\u8bc6, \u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    @SdkInternal
    public static void clearDataEntityCache(String pEntityNum) {
        try {
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)EntityMetadataCache.getDataEntityType((String)pEntityNum));
            cacheManager.removeByDt();
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    public static void clearCache(String[] arrKeys) {
        try {
            CACHE.remove(arrKeys);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    public static void clearCache(String type) {
        try {
            CACHE.removeType(type);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    public static void clearCache(String type, String key) {
        try {
            CACHE.remove(type, key);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    public static void clearCache(String type, String[] arrkeys) {
        try {
            CACHE.remove(type, arrkeys);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    @SdkInternal
    public static void clearCacheByPrekey(String type, String prefixkey) {
        String[] arrKey;
        List<String> keyList = CacheMrg.getCacheKeyListByPrefixKey(type, prefixkey);
        if (keyList != null && !keyList.isEmpty() && (arrKey = keyList.toArray(new String[0])) != null && arrKey.length > 0) {
            CacheMrg.clearCache(type, arrKey);
        }
    }

    @SdkInternal
    public static Map<String, String> getMapByType(String type) {
        HashMap kvs = null;
        try {
            kvs = CACHE.getAll(type);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            kvs = new HashMap(0);
        }
        return kvs;
    }

    public static void clearCacheWithPrefix(String type, String keyPrefix) {
        Map<String, String> kvs = CacheMrg.getMapByType(type);
        ArrayList<String> list = new ArrayList<String>();
        if (kvs != null && !kvs.isEmpty()) {
            for (String key : kvs.keySet()) {
                if (!key.startsWith(keyPrefix)) continue;
                list.add(key);
            }
            if (!list.isEmpty()) {
                CacheMrg.clearCache(type, list.toArray(new String[list.size()]));
            }
        }
    }

    @SdkInternal
    public static String getCache(String type, String key) {
        try {
            return (String)CACHE.get(type, key);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return null;
        }
    }

    @SdkInternal
    public static List<String> getCacheKeyListByPrefixKey(String type, String prefixKey) {
        try {
            return CACHE.getKeysWithPrefix(type, prefixKey);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return new ArrayList<String>(0);
        }
    }

    @SdkInternal
    public static void putCache(String type, String key, String value) {
        try {
            CACHE.put(type, key, value, 86400);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    @SdkInternal
    public static void putCache(String type, Map<String, String> values) {
        try {
            CACHE.put(type, values, 86400);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    @SdkInternal
    public static void putCache(String type, String key, String value, int pExpireTime) {
        try {
            CACHE.put(type, key, value, pExpireTime);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    @SdkInternal
    public static void putCache(String type, Map<String, String> values, int pExpireTime) {
        try {
            CACHE.put(type, values, pExpireTime);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    @SdkInternal
    public static Map<String, String> getCache(String type) {
        try {
            return CacheMrg.getMapByType(type);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return new HashMap<String, String>(0);
        }
    }

    @SdkInternal
    public static void loaded(String type, String key) {
        try {
            CACHE.put(type, key, (Object)DATA_LOADED);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    @SdkInternal
    public static boolean isData(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return !value.equals(DATA_LOADED);
    }

    @SdkInternal
    public static boolean isLoaded(String value) {
        return value != null && value.length() != 0;
    }

    @SdkInternal
    public static boolean isNotLoaded(String value) {
        return !CacheMrg.isLoaded(value);
    }

    @SdkInternal
    public static void expireAfter(String type, int seconds) {
        try {
            CACHE.expireAfter(type, seconds);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    @SdkInternal
    public static int getExpireTime() {
        return 86400;
    }
}

