/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.model.perm.DimNewDrPrPerm;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DimNewDrPrPermHelper {
    private static Log log = LogFactory.getLog(DimNewDrPrPermHelper.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_DimNewDrPrPermHelper_Pool", (int)1);

    public static Map<String, Set<DimNewDrPrPerm>> getUserIdDimNewDrPrPermSetMap(Map<String, Object> paraMap) {
        Set userIdSet = (Set)paraMap.get("userIdSet");
        if (null == userIdSet || userIdSet.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Map allDrDetailMap = (Map)paraMap.get("allDrDetailMap");
        String userIdSetStr = String.join((CharSequence)",", userIdSet);
        StringBuilder sb = new StringBuilder();
        sb.append(" select fid, fuserid, fappid, fentitynum, fpropkey, fpropentnum, fdataruleid, fdimid, fisincludesub, fdimtype ");
        sb.append(" from t_perm_userdatarule_prop ");
        sb.append(" where fuserid in (").append(userIdSetStr).append(") ");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static Map<String, Object> compareMutiThread(Set<DimNewDrPrPerm> prePropList, Set<DimNewDrPrPerm> afterPropList) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("delDrPr", new LinkedList());
        map.put("addDrPr", new LinkedList());
        map.put("updateDrPr", new LinkedList());
        try {
            HashMap<String, Set> dimTypeDimIdSetMap = new HashMap<String, Set>(8);
            for (DimNewDrPrPerm one : prePropList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            for (DimNewDrPrPerm one : afterPropList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            if (null == dimTypeDimIdSetMap || dimTypeDimIdSetMap.isEmpty()) {
                return map;
            }
            List del = (List)map.get("delDrPr");
            List add = (List)map.get("addDrPr");
            List update = (List)map.get("updateDrPr");
            for (Map.Entry dimTypeDimIdSet : dimTypeDimIdSetMap.entrySet()) {
                Set preDimIdSet = (Set)dimTypeDimIdSet.getValue();
                int size = preDimIdSet.size();
                int m = SqlUtil.getBatchCount((Integer)2, (int)size);
                CountDownLatch countDownLatch = new CountDownLatch(m);
                ArrayList<Future> futureList = new ArrayList<Future>(m);
                List listAvg = ListUtil.averageAssign(new ArrayList(preDimIdSet), m);
                for (int i = 0; i < listAvg.size(); ++i) {
                    List dimIds = listAvg.get(i);
                    List<DimNewDrPrPerm> oneThreadPreList = prePropList.stream().filter(x -> dimIds.contains(x.getDimId())).collect(Collectors.toList());
                    List<DimNewDrPrPerm> oneThreadAfterList = afterPropList.stream().filter(x -> dimIds.contains(x.getDimId())).collect(Collectors.toList());
                    futureList.add(pool.submit(DimNewDrPrPermHelper.diff(oneThreadPreList, oneThreadAfterList, countDownLatch)));
                }
                countDownLatch.await();
                if (CollectionUtils.isEmpty(futureList)) continue;
                for (Future future : futureList) {
                    try {
                        Map futureMap = (Map)future.get();
                        List futureDel = (List)futureMap.get("del");
                        List futureAdd = (List)futureMap.get("add");
                        List futureUpdate = (List)futureMap.get("update");
                        del.addAll(futureDel);
                        add.addAll(futureAdd);
                        update.addAll(futureUpdate);
                    }
                    catch (Exception e) {
                        log.warn("DimNewDrPrPermHelper.compareMutiThread --> error, prePropList:{}, afterPropList:{}", new Object[]{prePropList, afterPropList, e});
                        return map;
                    }
                }
            }
            return map;
        }
        catch (Exception e) {
            log.warn("DimNewDrPrPermHelper.compareMutiThread --> error, prePropList:{}, afterPropList:{}", new Object[]{prePropList, afterPropList, e});
            return map;
        }
    }

    private static Callable<Map<String, List<DimNewDrPrPerm>>> diff(List<DimNewDrPrPerm> preList, List<DimNewDrPrPerm> afterList, CountDownLatch countDownLatch) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static Map<String, List<DimNewDrPrPerm>> compare(List<DimNewDrPrPerm> lddppreList, List<DimNewDrPrPerm> lddpafterList) {
        HashMap<String, List<DimNewDrPrPerm>> map = new HashMap<String, List<DimNewDrPrPerm>>(3);
        List<DimNewDrPrPerm> delList_ = ListUtil.removeAll(lddppreList, lddpafterList);
        CopyOnWriteArrayList<DimNewDrPrPerm> delList = new CopyOnWriteArrayList<DimNewDrPrPerm>(delList_);
        List<DimNewDrPrPerm> addList_ = ListUtil.removeAll(lddpafterList, lddppreList);
        CopyOnWriteArrayList<DimNewDrPrPerm> addList = new CopyOnWriteArrayList<DimNewDrPrPerm>(addList_);
        ArrayList updateList = new ArrayList(8);
        delList.stream().forEach(x -> {
            Optional<DimNewDrPrPerm> first = addList.stream().filter(y -> Objects.equals(x.getCloudId(), y.getCloudId()) && Objects.equals(x.getAppId(), y.getAppId()) && Objects.equals(x.getEntityId(), y.getEntityId()) && Objects.equals(x.getPropKey(), y.getPropKey()) && Objects.equals(x.getPropEntNum(), y.getPropEntNum()) && Objects.equals(x.getDimType(), y.getDimType()) && Objects.equals(x.getDimId(), y.getDimId()) && Objects.equals(x.getIncludesuborg(), y.getIncludesuborg())).findFirst();
            if (first.isPresent()) {
                DimNewDrPrPerm lddp = (DimNewDrPrPerm)addList.get(0);
                lddp.setPreDataRuleId(x.getDataRuleId());
                lddp.setPreDataRuleName(x.getDataRuleName());
                lddp.setAfterDataRuleId(lddp.getDataRuleId());
                lddp.setAfterDataRuleName(lddp.getDataRuleName());
                lddp.setDataChangeType(EnumsDataChangeType.UPDATE);
                lddp.setDataChangeTypeDesc(ConstantsHelper.getUpdate());
                lddp.setOpDesc(ConstantsHelper.getUpdate() + ConstantsHelper.getDataRule());
                updateList.add(lddp);
                delList.remove(x);
                addList.remove(lddp);
            }
        });
        delList.stream().forEach(lddp -> {
            lddp.setPreDataRuleId(lddp.getDataRuleId());
            lddp.setPreDataRuleName(lddp.getDataRuleName());
            lddp.setAfterDataRuleId(Long.valueOf(0L));
            lddp.setAfterDataRuleName(" ");
            lddp.setDataChangeType(EnumsDataChangeType.DEL);
            lddp.setDataChangeTypeDesc(ConstantsHelper.getDel());
            lddp.setOpDesc(ConstantsHelper.getDel() + ConstantsHelper.getDataRule());
        });
        addList.stream().forEach(lddp -> {
            lddp.setPreDataRuleId(Long.valueOf(0L));
            lddp.setPreDataRuleName(" ");
            lddp.setAfterDataRuleId(lddp.getDataRuleId());
            lddp.setAfterDataRuleName(lddp.getDataRuleName());
            lddp.setDataChangeType(EnumsDataChangeType.ADD);
            lddp.setDataChangeTypeDesc(ConstantsHelper.getAdd());
            lddp.setOpDesc(ConstantsHelper.getAdd() + ConstantsHelper.getDataRule());
        });
        map.put("del", delList);
        map.put("add", addList);
        map.put("update", updateList);
        return map;
    }

    @SdkInternal
    @Deprecated
    public static void saveLogDiff2DB(List<DimNewDrPrPerm> diffList, Long fid, String langStr, Map<String, DynamicObject> allCloudMap, Map<String, String> allAppIdNameMap, Map<String, String> entityNameMap, Map<String, String> allPermItemMap, String includeDesc, String notIncludeDesc) {
        DimNewDrPrPermHelper.saveLogDiff2DB(diffList, fid, langStr, null);
    }

    @SdkInternal
    @Deprecated
    public static void saveLogDiff2DB(List<DimNewDrPrPerm> diffList, Long fid, String langStr, Map<String, Object> paraMap) {
        DimNewDrPrPermHelper.saveLogDiff2DB(diffList, fid, langStr, paraMap, null);
    }

    public static void saveLogDiff2DB(List<DimNewDrPrPerm> diffList, Long fid, String langStr, Map<String, Object> paraMap, Set<String> influenceEntNumSet) {
        HashMap<String, List> dimTypeRecordMap = new HashMap<String, List>(8);
        HashSet<String> appIdSet = new HashSet<String>(8);
        HashSet<String> entNumSet = new HashSet<String>(8);
        for (DimNewDrPrPerm one : diffList) {
            dimTypeRecordMap.computeIfAbsent(one.getDimType(), k -> new ArrayList(10)).add(one);
            appIdSet.add(one.getAppId());
            entNumSet.add(one.getEntityId());
            entNumSet.add(one.getPropEntNum());
        }
        if (null == dimTypeRecordMap || dimTypeRecordMap.isEmpty()) {
            return;
        }
        if (null == paraMap) {
            paraMap = new HashMap<String, Object>(8);
            paraMap.put("includeDesc", ConstantsHelper.getInclude());
            paraMap.put("notIncludeDesc", ConstantsHelper.getNotInclude());
            paraMap.put("entPermCtrlTypeMap", IsoDimHelper.getEntPermCtrlTypeMap(null));
        }
        Map entPermCtrlTypeMap = (Map)paraMap.get("entPermCtrlTypeMap");
        String includeDesc = (String)paraMap.get("includeDesc");
        String notIncludeDesc = (String)paraMap.get("notIncludeDesc");
        Map appIdCloudMap = AppHelper.getCloudMap(new ArrayList(appIdSet));
        Map allAppIdNameMap = AppHelper.getAllAppIdNameMap(appIdSet);
        HashMap<String, Object> ent_paraMap = new HashMap<String, Object>(8);
        ent_paraMap.put("paramEntNumSet", entNumSet);
        Map<String, Entity> entNumEntMap = FormHelper.getEntNumEntMap(ent_paraMap);
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append("t_perm_log_diff_dimnewdrp");
        sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, fprop_key, fprop_name, fprop_entnum, fprop_entname, fdim_id, fdim_number, fdim_name, finclude_suborg, finclude_suborg_desc, fdimtype, fdimtypedesc, fpre_data_ruleid, fpre_data_rulename, fafter_data_ruleid, fafter_data_rulename, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int size = diffList.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        LocalDateTime curTime = LocalDateTime.now();
        Object[] obj = null;
        String cloudId = "";
        String cloudName = "";
        String dimNumber = "";
        String dimName = "";
        String dimTypeDesc = "";
        int i = 0;
        HashMap<String, Map<String, Object>> hasLoadMap = new HashMap<String, Map<String, Object>>(8);
        for (Map.Entry dimTypeRecord : dimTypeRecordMap.entrySet()) {
            String dimType = (String)dimTypeRecord.getKey();
            List recordList = (List)dimTypeRecord.getValue();
            if (StringUtils.isEmpty((String)dimType) || null == recordList || recordList.isEmpty()) continue;
            Set dimIdSet = recordList.stream().map(DimNewDrPrPerm::getDimId).collect(Collectors.toSet());
            Map dimMap = IsoDimHelper.getDimMap(new ArrayList(dimIdSet), (String)dimType);
            for (DimNewDrPrPerm one : recordList) {
                String includesuborg;
                String appId = StrUtil.nullAbleStr(one.getAppId());
                DynamicObject cloudObj = (DynamicObject)appIdCloudMap.get(appId);
                if (null != cloudObj) {
                    cloudId = cloudObj.getString("bizcloud.id");
                    cloudName = cloudObj.getString("bizcloud.name");
                }
                String appName = StrUtil.nullAbleStr((String)allAppIdNameMap.get(appId));
                String entityNumber = StrUtil.nullAbleStr(one.getEntityId());
                Entity entity = entNumEntMap.get(entityNumber);
                String entityName = null == entity ? "" : entity.getEntityName();
                String propKey = StrUtil.nullAbleStr(one.getPropKey());
                String propName = FormHelper.getEntityFieldNameMultiEnt(hasLoadMap, entityNumber, propKey);
                String propEntNum = StrUtil.nullAbleStr(one.getPropEntNum());
                Entity propEnt = entNumEntMap.get(propEntNum);
                String propEntName = null == propEnt ? "" : propEnt.getEntityName();
                Long dimId = one.getDimId();
                Dim dim = (Dim)dimMap.get(dimId);
                if (null != dim) {
                    dimNumber = dim.getDimNumber();
                    dimName = dim.getDimName();
                }
                String includesuborgDesc = StringUtils.isEmpty((String)(includesuborg = StrUtil.nullAbleStr(one.getIncludesuborg()))) ? "" : ("1".equals(includesuborg) ? includeDesc : notIncludeDesc);
                String preDataRuleName = StrUtil.nullAbleStr(one.getPreDataRuleName());
                String afterDataRuleName = StrUtil.nullAbleStr(one.getAfterDataRuleName());
                String opDesc = StrUtil.nullAbleStr(one.getOpDesc());
                PermCtrlType permCtrlType = (PermCtrlType)entPermCtrlTypeMap.get(dimType);
                dimTypeDesc = null == permCtrlType ? " " : permCtrlType.getName();
                obj = new Object[]{ids[i], fid, cloudId, cloudName, appId, appName, entityNumber, entityName, propKey, propName, propEntNum, propEntName, dimId, dimNumber, dimName, includesuborg, includesuborgDesc, dimType, dimTypeDesc, one.getPreDataRuleId(), preDataRuleName, one.getAfterDataRuleId(), afterDataRuleName, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
                if (null != influenceEntNumSet) {
                    influenceEntNumSet.add(entityNumber);
                }
                ++i;
            }
        }
        SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

