/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.query.ChoiceFieldPageCustomQuery;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.perm.Entity;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class FormHelper {
    private static Log log = LogFactory.getLog(FormHelper.class);

    @SdkInternal
    public static Map<String, String> getExtEntIdAndOriEntIdMap(Set<String> entIdSet) {
        StringBuilder sql = new StringBuilder("select fid, fmasterid from t_meta_entitydesign where 1=1 ");
        if (null != entIdSet && !entIdSet.isEmpty()) {
            String entIdSetStr = String.join((CharSequence)"','", entIdSet);
            sql.append(" and fid in ('").append(entIdSetStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            HashMap<String, String> result = new HashMap<String, String>(100);
            while (rs.next()) {
                String id = rs.getString("fid");
                String masterid = rs.getString("fmasterid");
                if (StringUtils.isEmpty((String)masterid)) {
                    result.put(id, id);
                    continue;
                }
                result.put(id, masterid);
            }
            return result;
        });
    }

    @SdkInternal
    public static Map<String, String> getExtEntIdAndOriEntNumMap() {
        Map<String, String> extEntIdAndOriEntIdMap = FormHelper.getExtEntIdAndOriEntIdMap(new HashSet<String>(1));
        if (null == extEntIdAndOriEntIdMap || extEntIdAndOriEntIdMap.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        Set<String> oriEntIdSet = extEntIdAndOriEntIdMap.values().stream().collect(Collectors.toSet());
        if (null == oriEntIdSet || oriEntIdSet.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        Map<String, String> entIdNumMap = FormHelper.getEntIdNumMap(oriEntIdSet);
        HashMap<String, String> map = new HashMap<String, String>(8);
        for (Map.Entry<String, String> extEntIdAndOriEntId : extEntIdAndOriEntIdMap.entrySet()) {
            String entId = extEntIdAndOriEntId.getKey();
            String oriEntId = extEntIdAndOriEntId.getValue();
            String oriEntNum = entIdNumMap.get(oriEntId);
            if (StringUtils.isEmpty((String)oriEntNum)) continue;
            map.put(entId, oriEntNum);
        }
        return map;
    }

    @SdkInternal
    private static Map<String, String> getEntIdNumMap(Set<String> entIdSet) {
        StringBuilder sql = new StringBuilder("select fid, fnumber from t_meta_entitydesign where 1=1 ");
        if (null != entIdSet && !entIdSet.isEmpty()) {
            String entIdSetStr = String.join((CharSequence)"','", entIdSet);
            sql.append(" and fid in ('").append(entIdSetStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            HashMap<String, String> result = new HashMap<String, String>(100);
            while (rs.next()) {
                String id = rs.getString("fid");
                String fnumber = rs.getString("fnumber");
                result.put(id, fnumber);
            }
            return result;
        });
    }

    @SdkInternal
    public static Map<String, Object> getAllFields(String entityIdentity) {
        try {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityIdentity);
            Map allFields = met.getAllFields();
            HashMap<String, Map> subEntFieldsInfo = new HashMap<String, Map>();
            if (met instanceof QueryEntityType) {
                QueryEntityType qet = (QueryEntityType)met;
                List subEntTypeList = qet.getAllJoinEntityType();
                for (MainEntityType subMet : subEntTypeList) {
                    String subEntNum = subMet.getName();
                    Map allSubEntFields = subMet.getAllFields();
                    subEntFieldsInfo.put(subEntNum, allSubEntFields);
                }
            }
            if (CollectionUtils.isEmpty((Map)allFields) && CollectionUtils.isEmpty(subEntFieldsInfo)) {
                return new HashMap<String, Object>(1);
            }
            resultMap.put("allFields", allFields);
            resultMap.put("subEntFieldsInfo", subEntFieldsInfo);
            return resultMap;
        }
        catch (Exception e) {
            log.warn("FormHelper.getAllFields error, entityIdentity:{}", (Object)entityIdentity, (Object)e);
            return new HashMap<String, Object>(1);
        }
    }

    @SdkInternal
    public static String getFiledName(String propKey, Map<String, Object> allFieldsMap) {
        Map allFields = (Map)allFieldsMap.get("allFields");
        Map subEntFieldsInfo = (Map)allFieldsMap.get("subEntFieldsInfo");
        String bdPropName = "";
        if (allFields == null) {
            return bdPropName;
        }
        IDataEntityProperty idep = (IDataEntityProperty)allFields.get(propKey);
        if (idep == null) {
            String[] propKeys = propKey.split("\\.");
            if (propKeys == null || propKeys.length < 2) {
                return bdPropName;
            }
            Map subEntFieldInfo = (Map)subEntFieldsInfo.get(propKeys[0]);
            if (subEntFieldInfo == null) {
                return bdPropName;
            }
            IDataEntityProperty subFieldIdep = (IDataEntityProperty)subEntFieldInfo.get(propKeys[1]);
            if (subFieldIdep == null) {
                return bdPropName;
            }
            return subFieldIdep.getDisplayName().getLocaleValue();
        }
        bdPropName = idep.getDisplayName().getLocaleValue();
        return bdPropName;
    }

    @SdkInternal
    public static String getEntityFieldName(Map<String, Map<String, Object>> hasLoadMap, String entityIdentity, String fieldName) {
        Map<String, Object> allFieldsMap = hasLoadMap.get(entityIdentity);
        if (CollectionUtils.isEmpty(allFieldsMap)) {
            allFieldsMap = FormHelper.getAllFields(entityIdentity);
            hasLoadMap.put(entityIdentity, allFieldsMap);
        }
        return FormHelper.getFiledName(fieldName, allFieldsMap);
    }

    public static Map<String, String> getAllEntityNameMap(String langStr) {
        HashMap<String, String> map = new HashMap<String, String>(256);
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        try (DataSet entDataSet = FormHelper.getEntityDataSet(paraMap);){
            while (entDataSet.hasNext()) {
                Row row = entDataSet.next();
                String oriEntNum = row.getString("oriEntNum");
                String entName = row.getString("entName");
                map.put(oriEntNum, StringUtils.isEmpty((String)entName) ? oriEntNum : entName);
            }
        }
        return map;
    }

    @SdkInternal
    public static Map<String, String> getEntityNameMap(List<String> entityNumList, String langStr) {
        if (CollectionUtils.isEmpty(entityNumList)) {
            return FormHelper.getAllEntityNameMap(langStr);
        }
        String entityNumStr = String.join((CharSequence)"','", entityNumList);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fid, a.fname, a.flocaleid ");
        sb.append(" from t_meta_formdesign c ");
        sb.append(" inner join t_meta_mainentityinfo b on c.fentityid  = b.fdentityid ");
        sb.append(" inner join t_meta_mainentityinfo_l a on a.fid  = b.fid ");
        sb.append(" where c.fnumber in ('").append(entityNumStr).append("')");
        sb.append(" and a.flocaleid in('zh_CN','").append(langStr).append("')");
        int size = entityNumList.size();
        ArrayList list = new ArrayList(size);
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), null, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
        Map<String, String> zhCNMap = list.stream().filter(x -> "zh_CN".equals(x[1])).collect(Collectors.toMap(x -> (String)x[0], x -> (String)x[2]));
        Map<String, String> langMap = list.stream().filter(x -> langStr.equals(x[1])).collect(Collectors.toMap(x -> (String)x[0], x -> (String)x[2]));
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (Object[] obj : list) {
            String fid = (String)obj[0];
            String str = (String)map.get(fid);
            if (!StringUtils.isEmpty((String)str)) continue;
            String langName = langMap.get(fid);
            if (StringUtils.isNotEmpty((String)langName)) {
                map.put(fid, langName);
                continue;
            }
            String zhName = zhCNMap.get(fid);
            if (StringUtils.isNotEmpty((String)zhName)) {
                map.put(fid, zhName);
                continue;
            }
            map.put(fid, "noName");
        }
        return map;
    }

    @SdkInternal
    public static Map<String, Object> getAllFieldsMultiEnt(String entityIdentity) {
        MainEntityType met;
        try {
            met = EntityMetadataCache.getDataEntityType((String)entityIdentity);
        }
        catch (Exception e) {
            log.warn("FormHelper.getEntityFieldNameMultiEnt error, meta info maybe exception");
            return new HashMap<String, Object>(1);
        }
        try {
            List fieldInfoList = new ChoiceFieldPageCustomQuery().parseProperty((IDataEntityType)met);
            HashMap<String, Object> resultMap = new HashMap<String, Object>(fieldInfoList.size());
            for (Map map : fieldInfoList) {
                resultMap.put((String)map.get("field_id"), map.get("field_name"));
            }
            return resultMap;
        }
        catch (Exception e) {
            log.warn("FormHelper.getAllFieldsMultiEnt error, entityIdentity:{}", (Object)entityIdentity, (Object)e);
            return new HashMap<String, Object>(1);
        }
    }

    @SdkInternal
    public static String getEntityFieldNameMultiEnt(Map<String, Map<String, Object>> hasLoadMap, String entityIdentity, String fieldId) {
        Map<String, Object> allFieldsMap = hasLoadMap.get(entityIdentity);
        if (CollectionUtils.isEmpty(allFieldsMap)) {
            allFieldsMap = FormHelper.getAllFieldsMultiEnt(entityIdentity);
            hasLoadMap.put(entityIdentity, allFieldsMap);
        }
        return String.valueOf(allFieldsMap.get(fieldId));
    }

    @SdkInternal
    public static String getFormName(String formIdentity) {
        try {
            if (StringUtils.isEmpty((String)formIdentity)) {
                return ResManager.loadKDString((String)"\u7a7a\u8868\u5355", (String)"FormHelper_0", (String)"bos-permission-cache", (Object[])new Object[0]);
            }
            DynamicObject form = BusinessDataServiceHelper.loadSingleFromCache((Object)formIdentity, (String)"bos_entityobject_cache", (String)"id,name");
            if (null == form) {
                return ResManager.loadKDString((String)"\u8868\u5355\u540d\u4e0d\u5b58\u5728", (String)"FormHelper_1", (String)"bos-permission-cache", (Object[])new Object[0]);
            }
            return form.getLocaleString("name").getLocaleValue();
        }
        catch (Exception e) {
            log.warn("FormHelper.getFormName, \u83b7\u53d6\u8868\u5355\u540d \u5f02\u5e38!", (Throwable)e);
            return "";
        }
    }

    @SdkInternal
    public static Object getEntPriKeyV(String entityNum, Set<Object> priKeyVSet) {
        try {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNum);
            ISimpleProperty primaryKey = met.getPrimaryKey();
            if (primaryKey instanceof LongProp) {
                return priKeyVSet.stream().map(x -> Long.valueOf(String.valueOf(x))).collect(Collectors.toSet());
            }
        }
        catch (Exception e) {
            log.warn("FormHelper.getEntPriKeyV, \u83b7\u53d6\u67d0\u4e2a\u8868\u5355\u4e3b\u952e\u7c7b\u578b\u5bf9\u5e94\u7684\u503c, \u5f02\u5e38!", (Throwable)e);
        }
        return priKeyVSet;
    }

    @SdkInternal
    public static boolean isBaseData(String entityNum, String fieldkey) {
        try {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNum);
            IDataEntityProperty grpreffieldProp = met.findProperty(fieldkey);
            return grpreffieldProp instanceof BasedataProp;
        }
        catch (Exception e) {
            log.warn("FormHelper.isBaseData, \u83b7\u53d6\u67d0\u4e2a\u8868\u5355\u4e3b\u952e\u7c7b\u578b\u5bf9\u5e94\u7684\u503c, \u5f02\u5e38!", (Throwable)e);
            return false;
        }
    }

    @SdkInternal
    public static String getFLFieldKey(String entityNum, String fieldFlag) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNum);
        IDataEntityProperty grpreffieldProp = met.findProperty(fieldFlag);
        IDataEntityType parent = grpreffieldProp.getParent();
        if (parent instanceof EntryType) {
            fieldFlag = parent.getName() + "." + fieldFlag;
        }
        return fieldFlag;
    }

    @SdkInternal
    public static Map<String, Set<String>> getEntAppMap() {
        String algoKeyPrefix = PermItemHelper.class.getName() + ".getEntAppMap.";
        List<String> allUserAppIds = PermCommonUtil.getAllUserAppIds();
        List<String> allUserAppAndExtIds = PermCommonUtil.getExtAppByAppId(allUserAppIds);
        String allUserAppIdSqlStr = PermCommonUtil.getInSqlExprByStrParam(allUserAppAndExtIds);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        try (DataSet appIdEntIdDS = DB.queryDataSet((String)PermItemHelper.class.getName(), (DBRoute)DBRoute.meta, (String)"SELECT fbizappid burf_appid, fformid burf_formid FROM t_meta_bizunitrelform");
             DataSet appIdEntIdOnlyAllUserAppDS = appIdEntIdDS.copy().filter("burf_appid in (" + allUserAppIdSqlStr + ")");
             DataSet appIdEntIdNoAllUserAppDS = appIdEntIdDS.filter("burf_appid not in ( " + allUserAppIdSqlStr + ")");
             DataSet entNumPublishAppIdDS = DB.queryDataSet((String)(algoKeyPrefix + "bizObjAppDS"), (DBRoute)DBRoute.permission, (String)"SELECT fbizappid entapp_appid, fbizobjid entapp_entnum FROM t_perm_bizobjapp");
             DataSet entNumPubAppIdOnlyAllUserAppDS = entNumPublishAppIdDS.copy().filter("entapp_appid in (" + allUserAppIdSqlStr + ")");
             DataSet entNumPubAppIdNoAllUserAppDS = entNumPublishAppIdDS.filter("entapp_appid not in (" + allUserAppIdSqlStr + ")");
             DataSet allUserAppIdEntNumDS = DB.queryDataSet((String)(algoKeyPrefix + "allUserAppEntDS"), (DBRoute)DBRoute.permission, (String)"SELECT fappid entapp_appid, fentitynum entapp_entnum FROM t_perm_alluserappent");
             DataSet entityDesignDS = DB.queryDataSet((String)(algoKeyPrefix + "entityDesignDS"), (DBRoute)DBRoute.meta, (String)"select fid ent_id, fnumber ent_num from t_meta_entitydesign ");
             DataSet allUserAppIdEntIdDS = allUserAppIdEntNumDS.join(entityDesignDS.copy()).on("entapp_entnum", "ent_num").select(new String[]{"entapp_appid", "ent_id"}).finish();
             DataSet appIdEntIdOnlyAllUserAppDS2 = appIdEntIdOnlyAllUserAppDS.join(allUserAppIdEntIdDS.copy()).on("burf_formid", "ent_id").select(new String[]{"burf_appid", "ent_id"}).finish();
             DataSet entIdPubAppIdOnlyAllUserAppDS = entNumPubAppIdOnlyAllUserAppDS.join(entityDesignDS.copy()).on("entapp_entnum", "ent_num").select(new String[]{"entapp_appid", "ent_id"}).finish();
             DataSet entIdPubAppIdNoAllUserAppDS = entNumPubAppIdNoAllUserAppDS.join(entityDesignDS).on("entapp_entnum", "ent_num").select(new String[]{"entapp_appid", "ent_id"}).finish();
             DataSet entIdPubAppIdOnlyAllUserAppDS2 = entIdPubAppIdOnlyAllUserAppDS.join(allUserAppIdEntIdDS).on("ent_id", "ent_id").on("entapp_appid", "entapp_appid").select(new String[]{"entapp_appid", "ent_id"}).finish();
             DataSet appEntDS = appIdEntIdNoAllUserAppDS.union(entIdPubAppIdNoAllUserAppDS).union(appIdEntIdOnlyAllUserAppDS2).union(entIdPubAppIdOnlyAllUserAppDS2);
             DataSet funcPermDS = DB.queryDataSet((String)(algoKeyPrefix + "funcPermDS"), (DBRoute)DBRoute.permission, (String)"select distinct funcperm.FDENTITYTYPEID funcperm_entid from t_perm_functionperm funcperm ");
             DataSet dataSet = appEntDS.join(funcPermDS).on("burf_formid", "funcperm_entid").select(new String[]{"burf_appid"}, new String[]{"funcperm_entid"}).finish();){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String appId = row.getString("burf_appid");
                String entId = row.getString("funcperm_entid");
                map.computeIfAbsent(entId, k -> new HashSet(8)).add(appId);
            }
        }
        return map;
    }

    @SdkInternal
    public static Map<String, Map<String, Object>> getEntDesignInfo(Map<String, Object> paraMap) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(256);
        HashMap<String, String> infoMap = null;
        try (DataSet entDataSet = FormHelper.getEntityDataSet(paraMap);){
            while (entDataSet.hasNext()) {
                Row row = entDataSet.next();
                String oriEntId = row.getString("oriEntId");
                String oriEntNum = row.getString("oriEntNum");
                String entName = row.getString("entName");
                String modeltype = row.getString("modeltype");
                infoMap = new HashMap<String, String>();
                infoMap.put("id", oriEntId);
                infoMap.put("number", oriEntNum);
                infoMap.put("name", StringUtils.isEmpty((String)entName) ? oriEntNum : entName);
                infoMap.put("modeltype", modeltype);
                map.put(oriEntId, infoMap);
            }
        }
        return map;
    }

    @SdkInternal
    public static Map<String, Map<String, Object>> getEntDesignInfoWithNumKey(Map<String, Object> paraMap) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(256);
        HashMap<String, String> infoMap = null;
        try (DataSet entDataSet = FormHelper.getEntityDataSet(paraMap);){
            while (entDataSet.hasNext()) {
                Row row = entDataSet.next();
                String oriEntId = row.getString("oriEntId");
                String oriEntNum = row.getString("oriEntNum");
                String entName = row.getString("entName");
                String modeltype = row.getString("modeltype");
                infoMap = new HashMap<String, String>();
                infoMap.put("id", oriEntId);
                infoMap.put("number", oriEntNum);
                infoMap.put("name", StringUtils.isEmpty((String)entName) ? oriEntNum : entName);
                infoMap.put("modeltype", modeltype);
                map.put(oriEntNum, infoMap);
            }
        }
        return map;
    }

    @Deprecated
    public static Map<String, String> getAppIdByFormNum(List<String> entityNumList) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("entityNumList", entityNumList);
        Map extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet(1));
        paraMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        return FormHelper.getAppIdByFormNum(paraMap);
    }

    public static Map<String, String> getAppIdByFormNum(Map<String, Object> paraMap) {
        long start = System.currentTimeMillis();
        HashMap<String, String> resultMap = new HashMap<String, String>(8);
        try {
            Object formNumListObj;
            if (null == paraMap) {
                paraMap = new HashMap<String, Object>(8);
            }
            if (null == (formNumListObj = paraMap.get("entityNumList"))) {
                return resultMap;
            }
            ArrayList formNumList = (ArrayList)formNumListObj;
            if (null == formNumList || formNumList.isEmpty()) {
                return resultMap;
            }
            formNumList = new ArrayList(new LinkedHashSet(formNumList));
            Map<String, String> perm_formEntityNumMap = null == paraMap.get("perm_formEntityNumMap") ? new HashMap(0) : (Map)paraMap.get("perm_formEntityNumMap");
            Map<Object, Object> formEntNumMap = new HashMap(0);
            HashSet formNumSet = new HashSet(formNumList);
            Sets.SetView difference = Sets.difference(formNumSet, perm_formEntityNumMap.keySet());
            if (null != difference && !difference.isEmpty()) {
                formEntNumMap = FormHelper.getFormEntNumMap((Set<String>)difference);
            }
            String[] entityNumbers = new String[formNumList.size()];
            for (int i = 0; i < formNumList.size(); ++i) {
                String formId = (String)formNumList.get(i);
                String entityTypeId = (String)perm_formEntityNumMap.get(formId);
                if (null == entityTypeId) {
                    entityTypeId = (String)formEntNumMap.get(formId);
                    perm_formEntityNumMap.put(formId, entityTypeId);
                }
                entityNumbers[i] = StringUtils.isEmpty((String)entityTypeId) ? formId : entityTypeId;
            }
            Object[] bizAppNumbers = EntityMetadataCache.getBizAppNumbers((String[])entityNumbers);
            log.debug("\n{}-\u8017\u65f6\uff0c{}ms, bizAppNumbers:{}", new Object[]{"getAppIdByFormNum_bizAppNumbers_info", System.currentTimeMillis() - start, Arrays.toString(bizAppNumbers)});
            Map allAppInfo = AppMetadataCache.getAllAppInfo();
            HashSet<String> needMoreQueryEntNumSet = new HashSet<String>(8);
            for (int i = 0; i < entityNumbers.length; ++i) {
                String entNum = entityNumbers[i];
                Object appNumber = bizAppNumbers[i];
                if (StringUtils.isNotEmpty((String)appNumber) && null != allAppInfo.get(appNumber) && StringUtils.isNotEmpty((String)((AppInfo)allAppInfo.get(appNumber)).getId())) {
                    resultMap.put(entNum, ((AppInfo)allAppInfo.get(appNumber)).getId());
                    continue;
                }
                needMoreQueryEntNumSet.add(entNum);
            }
            if (null == needMoreQueryEntNumSet || needMoreQueryEntNumSet.isEmpty()) {
                return resultMap;
            }
            paraMap.put("needMoreQueryEntNumSet", needMoreQueryEntNumSet);
            Map<String, String> elseMap = FormHelper.getAppIdByFormNumPri(paraMap);
            resultMap.putAll(elseMap);
            return resultMap;
        }
        catch (Exception e) {
            log.warn("FormHelper.getAppIdByFormNum error", (Throwable)e);
            return resultMap;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SdkInternal
    public static Map<String, String> getAppIdByFormNumPri(Map<String, Object> paraMap) {
        Set needMoreQueryEntNumSet;
        String inStr;
        HashMap<String, String> resultMap = new HashMap<String, String>(8);
        ArrayList paramList = new ArrayList(10);
        StringBuilder sb = new StringBuilder();
        sb.append("select fid, fbizappid from t_meta_mainentityinfo where 1=1 ");
        Object needMoreQueryEntNumSetObj = paraMap.get("needMoreQueryEntNumSet");
        if (null != needMoreQueryEntNumSetObj && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam((needMoreQueryEntNumSet = (Set)needMoreQueryEntNumSetObj).stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and fid in (").append(inStr).append(") ");
        }
        try (DataSet ds = DB.queryDataSet((String)"FormHelper.getAppIdByFormNumPri", (DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()])).distinct();){
            Object extAppOrgnlAppMapObj;
            if (null == paraMap) {
                paraMap = new HashMap<String, Object>(8);
            }
            if (null == (extAppOrgnlAppMapObj = paraMap.get("extAppOrgnlAppMap"))) {
                paraMap.put("extAppOrgnlAppMap", AppHelper.getExtAppAndOrgnlAppRel(new HashSet(1)));
            }
            Map extAppOrgnlAppMap = (Map)paraMap.get("extAppOrgnlAppMap");
            while (ds.hasNext()) {
                Row row = ds.next();
                resultMap.put(row.getString("fid"), (String)extAppOrgnlAppMap.get(row.getString("fbizappid")));
            }
            HashMap<String, String> hashMap = resultMap;
            return hashMap;
        }
        catch (Exception e) {
            return resultMap;
        }
    }

    public static Map<String, String> getFormEntNumMap(Set<String> pFormNumSet) {
        Map allFormMeta;
        HashMap<String, String> results = new HashMap<String, String>(8);
        QFilter[] filterArr = null;
        if (pFormNumSet != null && !pFormNumSet.isEmpty()) {
            filterArr = new QFilter[]{new QFilter("number", "in", pFormNumSet)};
        }
        if ((allFormMeta = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"number, basedatafield", filterArr)) == null) {
            return results;
        }
        for (DynamicObject dObj : allFormMeta.values()) {
            String entNum;
            DynamicObject entObj;
            String formNum;
            if (dObj == null || StringUtils.isEmpty((String)(formNum = dObj.getString("number"))) || (entObj = dObj.getDynamicObject("basedatafield")) == null || StringUtils.isEmpty((String)(entNum = entObj.getString("number")))) continue;
            results.put(formNum, entNum);
        }
        return results;
    }

    @SdkInternal
    public static Map<String, String> getEntityNumByFormNum(List<String> formNumList) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fnumber, b.fid");
        sb.append(" from t_meta_formdesign a");
        sb.append(" left join t_meta_mainentityinfo b on a.fentityid = b.fdentityid");
        if (!CollectionUtils.isEmpty(formNumList)) {
            String formNumStr = String.join((CharSequence)"','", formNumList);
            sb.append(" where a.fnumber in('").append(formNumStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), null, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    @SdkInternal
    public static Map<String, String> getAllEntNumAndNameRuntimeMap() {
        HashMap<String, String> allEntNumAndNameMap = new HashMap<String, String>(8);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (String)"name", null);
        for (Map.Entry entry : loadFromCache.entrySet()) {
            String entNum = (String)entry.getKey();
            DynamicObject dObj = (DynamicObject)entry.getValue();
            if (dObj == null) continue;
            String entName = dObj.getString("name");
            allEntNumAndNameMap.put(entNum, entName);
        }
        return allEntNumAndNameMap;
    }

    @SdkInternal
    public static String getRuntimeFormName(String formNum) {
        String name = "";
        try {
            String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
            name = FormMetadataCache.getFormConfig((String)entityNum).getCaption().getLocaleValue();
        }
        catch (Exception e) {
            log.warn("FormHelper.getRuntimeFormName error, formNum:{}", (Object)formNum, (Object)e);
            name = formNum;
        }
        return name;
    }

    @SdkInternal
    public static DataSet getEntOriDS(Map<String, Object> paraMap) {
        List<Object[]> list = FormHelper.getEntOriObjList(null);
        return FormHelper.getEntOriDSPrivate(list);
    }

    @SdkInternal
    private static DataSet getEntOriDSPrivate(List<Object[]> list) {
        Algo algo = Algo.create((String)"FormHelper.getEntOriDSPrivate.algo");
        ArrayList<Field> permFields = new ArrayList<Field>(16);
        permFields.add(new Field("oriEntId", (DataType)DataType.StringType));
        permFields.add(new Field("oriEntNum", (DataType)DataType.StringType));
        permFields.add(new Field("entName", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(permFields.toArray(new Field[0]));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (Object[] objArr : list) {
            if (objArr.length >= 3 && null == objArr[2] && StringUtils.isEmpty((String)((String)objArr[2])) && null != objArr[1] && StringUtils.isNotEmpty((String)((String)objArr[1]))) {
                String entNum = (String)objArr[1];
                objArr[2] = FormHelper.getRuntimeFormName(entNum);
            }
            builder.append(objArr);
        }
        return builder.build();
    }

    @SdkInternal
    public static Map<String, Entity> getEntNumEntMap(Map<String, Object> paraMap) {
        HashMap<String, Entity> map = new HashMap<String, Entity>(8);
        List<Object[]> list = FormHelper.getEntOriObjList(paraMap);
        Entity one = null;
        for (Object[] objArr : list) {
            one = new Entity();
            Object idObj = objArr[0];
            Object numberObj = objArr[1];
            Object nameObj = objArr[2];
            if (null == idObj || null == numberObj) continue;
            String entityId = String.valueOf(idObj);
            String entityNumber = String.valueOf(numberObj);
            String entityName = null == nameObj ? "" : String.valueOf(nameObj);
            one.setEntityId(entityId);
            one.setEntityNumber(entityNumber);
            one.setEntityName(entityName);
            if (StringUtils.isEmpty((String)entityName) && StringUtils.isNotEmpty((String)entityNumber)) {
                one.setEntityName(FormHelper.getRuntimeFormName(entityNumber));
            }
            map.put(entityNumber, one);
        }
        return map;
    }

    @SdkInternal
    private static List<Object[]> getEntOriObjList(Map<String, Object> paraMap) {
        String inStr;
        String inStr2;
        if (null == paraMap) {
            paraMap = new HashMap<String, Object>(0);
        }
        Set paramEntNumSet = null;
        Object paramEntNumSetObj = paraMap.get("paramEntNumSet");
        if (null != paramEntNumSetObj) {
            paramEntNumSet = (Set)paramEntNumSetObj;
        }
        Set modelTypeSet = null;
        Object modelTypeSetObj = paraMap.get("modelTypeSet");
        if (null != modelTypeSetObj) {
            modelTypeSet = (Set)modelTypeSetObj;
        }
        Set templateSet = null;
        Object templateSetObj = paraMap.get("templateSet");
        if (null != templateSetObj) {
            templateSet = (Set)templateSetObj;
        }
        Set typeSet = null;
        Object typeSetObj = paraMap.get("typeSet");
        if (null != typeSetObj) {
            typeSet = (Set)typeSetObj;
        }
        ArrayList<String> paramList = new ArrayList<String>(6);
        final HashMap oriEntIdNumMap = new HashMap(100);
        final HashMap oriEntIdNameMap = new HashMap(100);
        String langStr = RequestContext.get().getLang().name();
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fmasterid, a.fnumber, b.fname ");
        sb.append(" from t_meta_entitydesign a ");
        sb.append(" left join t_meta_entitydesign_l b on a.fid = b.fid and b.flocaleid = ? ");
        paramList.add(langStr);
        sb.append(" where 1=1 ");
        if (null != paramEntNumSet && !paramEntNumSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr2 = SqlUtil.wrapInParam(paramEntNumSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and a.fnumber in (").append(inStr2).append(") ");
        }
        if (null != modelTypeSet && !modelTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr2 = SqlUtil.wrapInParam(modelTypeSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and a.fmodeltype in (").append(inStr2).append(") ");
        }
        if (null != templateSet && !templateSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr2 = SqlUtil.wrapInParam(templateSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and a.fistemplate in (").append(inStr2).append(") ");
        }
        if (null != typeSet && !typeSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr2 = SqlUtil.wrapInParam(typeSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and a.ftype in (").append(inStr2).append(") ");
        }
        sb.append(" order by a.finheritpath, a.fcreatedate ");
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String id = rs.getString("fid");
                    String masterId = rs.getString("fmasterid");
                    String number = rs.getString("fnumber");
                    String name = rs.getString("fname");
                    name = StringUtils.isEmpty((String)name) ? number : name;
                    String oriEntId = "";
                    oriEntId = StringUtils.isEmpty((String)masterId) ? id : masterId;
                    if (StringUtils.isEmpty((String)oriEntId)) continue;
                    String oriNum = (String)oriEntIdNumMap.get(oriEntId);
                    if (StringUtils.isEmpty((String)oriNum)) {
                        oriEntIdNumMap.put(oriEntId, number);
                    }
                    oriEntIdNameMap.put(oriEntId, name);
                }
                return null;
            }
        });
        if (null == oriEntIdNumMap || oriEntIdNumMap.isEmpty()) {
            return new ArrayList<Object[]>(0);
        }
        Set queryEntNumSet = oriEntIdNumMap.values().stream().collect(Collectors.toSet());
        if (null == queryEntNumSet || queryEntNumSet.isEmpty()) {
            return new ArrayList<Object[]>(0);
        }
        sb.setLength(0);
        paramList.clear();
        sb.append("SELECT a.fid, b.fname ");
        sb.append(" from t_meta_mainentityinfo a ");
        sb.append(" left JOIN t_meta_mainentityinfo_l b on (a.fid = b.fid and b.flocaleid = ?) ");
        paramList.add(langStr);
        sb.append(" where 1=1 ");
        if (null != queryEntNumSet && !queryEntNumSet.isEmpty() && null != paramEntNumSet && !paramEntNumSet.isEmpty() && queryEntNumSet.size() <= 1000 && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam(queryEntNumSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and a.fid in (").append(inStr).append(") ");
        }
        final HashMap oriEntNumRuntimeNameMap = new HashMap(100);
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String entNum = rs.getString("fid");
                    String runtimeEntName = rs.getString("fname");
                    oriEntNumRuntimeNameMap.put(entNum, runtimeEntName);
                }
                return null;
            }
        });
        ArrayList<Object[]> list = new ArrayList<Object[]>(oriEntIdNumMap.size());
        for (Map.Entry oriEntIdNum : oriEntIdNumMap.entrySet()) {
            String oriEntId = (String)oriEntIdNum.getKey();
            String num = (String)oriEntIdNum.getValue();
            String runtimeName = (String)oriEntNumRuntimeNameMap.get(num);
            String designName = (String)oriEntIdNameMap.get(oriEntId);
            list.add(new Object[]{oriEntId, num, StringUtils.isEmpty((String)runtimeName) ? designName : runtimeName});
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    @SdkInternal
    private static DataSet getEntityDataSet(Map<String, Object> paraMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SdkInternal
    private static DataSet getPermBizObjAppDataSet(Map<String, Object> paraMap) {
        paraMap = null == paraMap ? new HashMap(1) : paraMap;
        Set entNumNotInSet = null == paraMap.get("entNumNotInSet") ? new HashSet(1) : (Set)paraMap.get("entNumNotInSet");
        boolean entNumNotInSetIsNotEmpty = null != entNumNotInSet && !entNumNotInSet.isEmpty();
        StringBuilder sb = new StringBuilder();
        sb.append("select fbizappid, fbizobjid from t_perm_bizobjapp where 1=1 ");
        if (entNumNotInSetIsNotEmpty) {
            String entNumNotInSetStr = String.join((CharSequence)"','", entNumNotInSet);
            sb.append(" and fbizobjid not in ('").append(entNumNotInSetStr).append("')");
        }
        return DB.queryDataSet((String)(FormHelper.class.getName() + ".getPermBizObjAppDataSet"), (DBRoute)DBRoute.basedata, (String)sb.toString());
    }

    /*
     * Exception decompiling
     */
    @SdkInternal
    private static DataSet queryBizUnitRelFormDataSet(Map<String, Object> paraMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SdkInternal
    public static DataSet getFormIdOriMapDataSet(Map<String, Object> paraMap) {
        paraMap = null == paraMap ? new HashMap(1) : paraMap;
        Set entNumNotInSet = null == paraMap.get("entNumNotInSet") ? new HashSet(1) : (Set)paraMap.get("entNumNotInSet");
        boolean entNumNotInSetIsNotEmpty = null != entNumNotInSet && !entNumNotInSet.isEmpty();
        StringBuilder sb = new StringBuilder();
        sb.append("select fid, fmasterid from t_meta_entitydesign where 1=1");
        if (entNumNotInSetIsNotEmpty) {
            String entNumNotInSetStr = String.join((CharSequence)"','", entNumNotInSet);
            sb.append(" and fnumber not in ('").append(entNumNotInSetStr).append("')");
        }
        try (DataSet ds = DB.queryDataSet((String)FormHelper.class.getName(), (DBRoute)DBRoute.meta, (String)sb.toString());){
            Algo algo = Algo.create((String)"FormHelper.getFormIdOriMapDataSet");
            ArrayList<Field> permFields = new ArrayList<Field>(2);
            permFields.add(new Field("entId", (DataType)DataType.StringType));
            permFields.add(new Field("oriEntId", (DataType)DataType.StringType));
            RowMeta rowMeta = new RowMeta(permFields.toArray(new Field[0]));
            DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
            while (ds.hasNext()) {
                Row row = ds.next();
                String entId = row.getString("fid");
                String fmasterid = row.getString("fmasterid");
                builder.append(new Object[]{entId, StringUtils.isEmpty((String)fmasterid) || " ".equals(fmasterid) ? entId : fmasterid});
            }
            DataSet dataSet = builder.build();
            return dataSet;
        }
    }

    /*
     * Exception decompiling
     */
    @SdkInternal
    public static DataSet getEntDataSet(Map<String, Object> paraMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 14 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SdkInternal
    public static Map<String, String> getEntNumModelTypeMap(Set<String> entNumSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("select fnumber, fmodeltype");
        sb.append(" from t_meta_formdesign ");
        if (!CollectionUtils.isEmpty(entNumSet)) {
            String entNumSetStr = String.join((CharSequence)"','", entNumSet);
            sb.append(" where fnumber in('").append(entNumSetStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> resultMap = new HashMap<String, String>(256);
                while (rs.next()) {
                    String formNum = rs.getString("fnumber");
                    String fmodeltype = rs.getString("fmodeltype");
                    resultMap.put(formNum, fmodeltype);
                }
                return resultMap;
            }
        });
    }

    @SdkInternal
    public static Set<String> getDistinctModelTypeSet() {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct fmodeltype");
        sb.append(" from t_meta_formdesign ");
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> resultSet = new HashSet<String>(8);
                while (rs.next()) {
                    String fmodeltype = rs.getString("fmodeltype");
                    if (StringUtils.isEmpty((String)fmodeltype)) continue;
                    resultSet.add(fmodeltype);
                }
                return resultSet;
            }
        });
    }

    @SdkInternal
    public static Map<String, Map<String, Set<String>>> getEntityItemClassFieldMap(Set<String> entityNumSet) {
        HashMap<String, Map<String, Set<String>>> map = new HashMap<String, Map<String, Set<String>>>(8);
        try {
            if (null == entityNumSet || entityNumSet.isEmpty()) {
                return map;
            }
            HashMap<String, Set> innerMap = null;
            for (String entNum : entityNumSet) {
                long start1 = System.currentTimeMillis();
                innerMap = new HashMap<String, Set>(8);
                map.put(entNum, innerMap);
                String idByNumber = MetadataDao.getIdByNumber((String)entNum, (MetaCategory)MetaCategory.Entity);
                if (StringUtils.isEmpty((String)idByNumber)) {
                    return map;
                }
                AbstractMetadata abstractMetadata = MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Entity);
                if (null == abstractMetadata) {
                    return map;
                }
                EntityMetadata entityMetadata = (EntityMetadata)abstractMetadata;
                if (null == entityMetadata) {
                    return map;
                }
                List entitys = entityMetadata.getEntitys();
                if (null == entitys || entitys.isEmpty()) {
                    return map;
                }
                for (kd.bos.metadata.entity.Entity entity : entitys) {
                    List items = entity.getItems();
                    if (CollectionUtils.isEmpty((Collection)items)) continue;
                    for (EntityItem item : items) {
                        String aClassName;
                        Class<?> aClass;
                        String key;
                        if (item instanceof EntryEntity || StringUtils.isEmpty((String)(key = item.getKey())) || null == (aClass = item.getClass()) || StringUtils.isEmpty((String)aClass.getName()) || PermHelperConst.HIDE_CONTROL_FIELDTYPE_SET.contains(aClassName = aClass.getName())) continue;
                        innerMap.computeIfAbsent(aClassName, k -> new HashSet(8)).add(key);
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn("FormHelper.getEntityItemClassFieldMap error", (Throwable)e);
        }
        return map;
    }

    @SdkInternal
    public static Map<String, Entity> getEntityInfoMap(Set<String> entNumSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fnumber, b.fname");
        sb.append(" from t_meta_entitydesign a ");
        sb.append(" inner join t_meta_entitydesign_l b on a.fid = b.fid and b.flocaleid = ? ");
        sb.append(" where 1=1 ");
        if (!CollectionUtils.isEmpty(entNumSet)) {
            String entNumSetStr = String.join((CharSequence)"','", entNumSet);
            sb.append(" and a.fnumber in('").append(entNumSetStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{RequestContext.get().getLang().name()}, (ResultSetHandler)new ResultSetHandler<Map<String, Entity>>(){

            public Map<String, Entity> handle(ResultSet rs) throws Exception {
                HashMap<String, Entity> resultMap = new HashMap<String, Entity>(8);
                Entity entity = null;
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    String fnumber = rs.getString("fnumber");
                    String fname = rs.getString("fname");
                    entity = new Entity();
                    entity.setEntityId(fid);
                    entity.setEntityNumber(fnumber);
                    entity.setEntityName(fname);
                    resultMap.put(fnumber, entity);
                }
                return resultMap;
            }
        });
    }

    @SdkInternal
    public static List<String> getInheritedEntity(String orlEntityNum, boolean containOrl) {
        ArrayList<String> result = new ArrayList<String>(10);
        if (StringUtils.isEmpty((String)orlEntityNum)) {
            return result;
        }
        if (containOrl) {
            result.add(orlEntityNum);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fnumber from t_meta_entitydesign ");
        sb.append(" where fparentid in(");
        sb.append("     select fid from t_meta_entitydesign where fnumber = ? ");
        sb.append(" ) ");
        result.addAll((Collection)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{orlEntityNum}, rs -> {
            ArrayList<String> res = new ArrayList<String>(10);
            while (rs.next()) {
                res.add(rs.getString("fnumber"));
            }
            return res;
        }));
        return result;
    }

    @SdkInternal
    public static Set<String> getAllOriAppNum() {
        StringBuilder sb = new StringBuilder();
        sb.append("select fnumber from t_meta_entitydesign where ftype = '0' ");
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> set = new HashSet<String>(8);
                while (rs.next()) {
                    set.add(rs.getString("fnumber"));
                }
                return set;
            }
        });
    }

    @SdkInternal
    public static Set<String> getIgnoreRefEntNumSet(String[] ignoreRefEntNums) {
        if (null == ignoreRefEntNums || Objects.equals(0, ignoreRefEntNums.length)) {
            return new HashSet<String>(1);
        }
        final Set<String> ignorerefentityNumSet = Arrays.stream(ignoreRefEntNums).collect(Collectors.toSet());
        StringBuilder sb = new StringBuilder();
        sb.append("select fnumber from t_meta_entitydesign ");
        sb.append(" where fparentid in(");
        sb.append("     select fid from t_meta_entitydesign where fnumber in('").append(String.join((CharSequence)"','", ignorerefentityNumSet)).append("')");
        sb.append(" ) ");
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    ignorerefentityNumSet.add(rs.getString("fnumber"));
                }
                return null;
            }
        });
        return ignorerefentityNumSet;
    }

    @SdkInternal
    public static Map<String, Set<Entity>> getEntMap(Set<String> idOrNumberOrNameSet, String keyType) {
        HashMap<String, Set<Entity>> map = new HashMap<String, Set<Entity>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("id", keyType)) {
            qFilterList.add(new QFilter("id", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("number", keyType)) {
            qFilterList.add(new QFilter("number", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("name", keyType)) {
            qFilterList.add(new QFilter("name", "in", idOrNumberOrNameSet));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"FormHelper.getEntMap", (String)"bos_entityobject", (String)"id, number, name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            Entity one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new Entity();
                String id = row.getString("id");
                String number = row.getString("number");
                String name = row.getString("name");
                one.setEntityId(id);
                one.setEntityNumber(number);
                one.setEntityName(name);
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(String.valueOf(id), k -> new HashSet()).add(one);
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(name, k -> new HashSet()).add(one);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(number, k -> new HashSet()).add(one);
            }
        }
        return map;
    }

    @SdkInternal
    public static PermissionControlType getPermissionControlType(String entityNum) {
        String threadCacheKey = String.format("%s%s%s", "getPermissionControlType_", RequestContext.get().getAccountId(), entityNum);
        Map threadCacheMap = (Map)ThreadCache.get((Object)threadCacheKey, () -> {
            HashMap<String, PermissionControlType> map = new HashMap<String, PermissionControlType>(8);
            PermissionControlType permissionControlType = EntityMetadataCache.getPermissionControlType((String)entityNum);
            if (null == permissionControlType) {
                permissionControlType = new PermissionControlType();
                permissionControlType.setEmptyObject(true);
                map.put("permissionControlType", permissionControlType);
                return map;
            }
            map.put("permissionControlType", permissionControlType);
            return map;
        });
        return (PermissionControlType)threadCacheMap.get("permissionControlType");
    }

    public static Map<String, Set<String>> getEntPermItemIdSetMap(Set<String> entNumSet) {
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>(10);
        if (null != entNumSet && !entNumSet.isEmpty()) {
            qfilterList.add(new QFilter("entitytype", "in", entNumSet));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"FormHelper.getEntPermItemIdSetMap", (String)"perm_functionperm", (String)"entitytype, permitem", (QFilter[])qfilterList.toArray(new QFilter[qfilterList.size()]), (String)"");){
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(8);
            while (ds.hasNext()) {
                Row row = ds.next();
                result.computeIfAbsent(row.getString("entitytype"), k -> new HashSet(8)).add(row.getString("permitem"));
            }
            HashMap<String, Set<String>> hashMap = result;
            return hashMap;
        }
    }

    public static DataSet getEntDsOfDesign(String searchText, boolean isShowNum, boolean canSearchByName, String isTemplate, Set<String> modelTypeSet, Set<String> modelTypeNotInSet, String fType, Set<String> entNumSet) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (StringUtils.isNotEmpty((String)searchText)) {
            QFilter qfilter = null;
            if (canSearchByName) {
                qfilter = new QFilter("name", "like", (Object)("%" + searchText + "%"));
            }
            if (isShowNum) {
                if (null == qfilter) {
                    qfilter = new QFilter("number", "like", (Object)("%" + searchText + "%"));
                } else {
                    qfilter.or(new QFilter("number", "like", (Object)("%" + searchText + "%")));
                }
            }
            qFilterList.add(qfilter);
        }
        if (StringUtils.isNotEmpty((String)isTemplate)) {
            qFilterList.add(new QFilter("istemplate", "=", (Object)isTemplate));
        }
        if (null != modelTypeSet && !modelTypeSet.isEmpty()) {
            qFilterList.add(new QFilter("modeltype", "in", modelTypeSet));
        }
        if (null != modelTypeNotInSet && !modelTypeNotInSet.isEmpty()) {
            qFilterList.add(new QFilter("modeltype", "not in", modelTypeNotInSet));
        }
        if (StringUtils.isNotEmpty((String)fType)) {
            qFilterList.add(new QFilter("type", "=", (Object)fType));
        }
        if (null != entNumSet && !entNumSet.isEmpty()) {
            qFilterList.add(new QFilter("number", "in", entNumSet));
        }
        return QueryServiceHelper.queryDataSet((String)"FormHelper.getEntDsOfDesign", (String)"bos_devpn_entitymeta", (String)"id as designEntId, number as designEntNum, name as designEntName", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");
    }

    public static DataSet getEntDsOfRuntime(String searchText, boolean isShowNum) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (StringUtils.isNotEmpty((String)searchText)) {
            QFilter qfilter = new QFilter("name", "like", (Object)("%" + searchText + "%"));
            if (isShowNum) {
                qfilter.or(new QFilter("number", "like", (Object)("%" + searchText + "%")));
            }
            qFilterList.add(qfilter);
        }
        return QueryServiceHelper.queryDataSet((String)"FormHelper.getEntRuntimeDs", (String)"bos_entityobject", (String)"id as runtimeEntId, number as runtimeEntNum, name as runtimeEntName", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getEntNumNameMapOfRuntime(String searchText, boolean isShowNum, DataSet ds) {
        HashMap<String, String> hashMap;
        try {
            if (null == ds) {
                ds = FormHelper.getEntDsOfRuntime(searchText, isShowNum);
            }
            HashMap<String, String> result = new HashMap<String, String>(8);
            while (ds.hasNext()) {
                Row row = ds.next();
                result.put(row.getString("runtimeEntId"), row.getString("runtimeEntName"));
            }
            hashMap = result;
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet(ds);
            throw throwable;
        }
        PermCommonUtil.closeDataSet(ds);
        return hashMap;
    }
}

