/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.annotation.SdkInternal;

public class ListUtil {
    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(n);
        int remaider = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remaider > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remaider;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }

    @SdkInternal
    public static <T> List<T> removeAll(List<T> source, List<T> destination) {
        if (null == source || source.isEmpty()) {
            source = new ArrayList<T>();
        }
        if (null == destination || destination.isEmpty()) {
            destination = new ArrayList<T>();
        }
        Sets.SetView diffSet = Sets.difference(new HashSet<T>(source), new HashSet<T>(destination));
        LinkedList result = new LinkedList();
        for (Object t : diffSet) {
            result.add(t);
        }
        return result;
    }

    @SdkInternal
    public static String getSqlList(Collection<?> array) {
        if (CollectionUtils.isEmpty(array)) {
            return "";
        }
        boolean first = true;
        StringBuilder sqlList = new StringBuilder();
        for (Object one : array) {
            if (first) {
                first = false;
                sqlList.append('\'').append(one).append('\'');
                continue;
            }
            sqlList.append(',').append('\'').append(one).append('\'');
        }
        return sqlList.toString();
    }

    @SdkInternal
    public static List<Object[]> listListObj2ListObjArr(List<List<Object>> paramList) {
        ArrayList<Object[]> list = new ArrayList<Object[]>(10);
        Object[] obj = null;
        for (int i = 0; i < paramList.size(); ++i) {
            List<Object> one = paramList.get(i);
            if (null == one || one.isEmpty()) continue;
            int size = one.size();
            obj = new Object[size];
            for (int j = 0; j < size; ++j) {
                Object innerOne = one.get(j);
                if (!(innerOne instanceof List)) {
                    obj[j] = innerOne;
                    continue;
                }
                if (null == innerOne) {
                    obj[j] = null;
                    continue;
                }
                List objects = (List)innerOne;
                if (0 == objects.size()) {
                    obj[j] = null;
                    continue;
                }
                Object kk = objects.get(0);
                if (kk instanceof Integer) {
                    obj[j] = ListUtil.convertListToArray(objects, Integer.class);
                    continue;
                }
                if (kk instanceof Long) {
                    obj[j] = ListUtil.convertListToArray(objects, Long.class);
                    continue;
                }
                if (!(kk instanceof String)) continue;
                obj[j] = ListUtil.convertListToArray(objects, String.class);
            }
            list.add(obj);
        }
        return list;
    }

    private static <T> T[] convertListToArray(List<Object> list, Class<T> componentType) {
        ArrayList<T> typedList = new ArrayList<T>();
        for (Object obj : list) {
            if (!componentType.isInstance(obj)) continue;
            typedList.add(componentType.cast(obj));
        }
        return typedList.toArray((Object[])Array.newInstance(componentType, 0));
    }

    public static <E> HashSet<E> newHashSet(E ... elements) {
        return Sets.newHashSet((Object[])elements);
    }

    @SdkInternal
    public static <T> Set<T> intersection(Set<T> source, Set<T> destination) {
        if (null == source || source.isEmpty()) {
            source = new HashSet<T>(0);
        }
        if (null == destination || destination.isEmpty()) {
            destination = new HashSet<T>(0);
        }
        return Sets.intersection(source, destination);
    }
}

