/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.codec.binary.Base64;

@SdkInternal
public class StrUtil {
    private static final Log log = LogFactory.getLog(StrUtil.class);

    public static String nullAbleStr(String str) {
        return Optional.ofNullable(str).orElse("");
    }

    public static String compress(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.warn("StrUtil.compress error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (Exception e) {
                    log.warn("StrUtil.compress gzip close error", (Throwable)e);
                }
            }
        }
        return new String(Base64.encodeBase64((byte[])out.toByteArray()), StandardCharsets.UTF_8);
    }

    public static String uncompress(String compressedStr) {
        if (compressedStr == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = null;
        GZIPInputStream ginzip = null;
        byte[] compressed = null;
        String decompressed = null;
        try {
            compressed = Base64.decodeBase64((String)compressedStr);
            in = new ByteArrayInputStream(compressed);
            ginzip = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = ginzip.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            decompressed = out.toString();
        }
        catch (Exception e) {
            log.warn("StrUtil.uncompress error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
        finally {
            if (ginzip != null) {
                try {
                    ginzip.close();
                }
                catch (Exception e) {
                    log.warn("StrUtil.uncompress ginzip close error", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.warn("StrUtil.uncompress in close error", (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.warn("StrUtil.uncompress out close error", (Throwable)e);
                }
            }
        }
        return decompressed;
    }

    public static boolean matchV(String fieldV, String cp, Object value) {
        String vv;
        if (null == fieldV) {
            fieldV = "";
        }
        if (StringUtils.isNotEmpty((String)cp) && "ftlike".equals(cp) && null != value) {
            return fieldV.contains((CharSequence)value);
        }
        if (StringUtils.isNotEmpty((String)cp) && "like".equals(cp) && null != value && (vv = String.valueOf(value)).startsWith("%") && vv.endsWith("%")) {
            value = vv.replace("%", "");
            return fieldV.contains((CharSequence)value);
        }
        if (StringUtils.isNotEmpty((String)cp) && "not like".equals(cp) && null != value) {
            return !fieldV.contains(((String)value).substring(1, ((String)value).length() - 1));
        }
        if (StringUtils.isNotEmpty((String)cp) && "like".equals(cp) && null != value) {
            int startStrLen;
            String valueStr = String.valueOf(value);
            int likeIndex = valueStr.indexOf("%");
            if (0 == likeIndex) {
                int endStrLen;
                String endStr = valueStr.substring(1, valueStr.length());
                int fieldVLen = fieldV.length();
                if (fieldVLen < (endStrLen = endStr.length())) {
                    return false;
                }
                String fieldVEndStr = fieldV.substring(fieldVLen - endStrLen, fieldVLen);
                return fieldVEndStr.equals(endStr);
            }
            String startStr = ((String)value).substring(0, valueStr.length() - 1);
            int fieldVLen = fieldV.length();
            if (fieldVLen < (startStrLen = startStr.length())) {
                return false;
            }
            String fieldVStartStr = fieldV.substring(0, startStrLen);
            return fieldVStartStr.equals(startStr);
        }
        if (StringUtils.isNotEmpty((String)cp) && "=".equals(cp) && null != value && value instanceof QEmptyValue) {
            return StringUtils.isEmpty((String)fieldV);
        }
        if (StringUtils.isNotEmpty((String)cp) && "is not null".equals(cp)) {
            return StringUtils.isNotEmpty((String)fieldV);
        }
        if (StringUtils.isNotEmpty((String)cp) && "=".equals(cp) && null != value) {
            return fieldV.equals(value);
        }
        if (StringUtils.isNotEmpty((String)cp) && "!=".equals(cp) && null != value) {
            return !fieldV.equals(value);
        }
        return false;
    }

    public static StringBuilder wrapNumericTips(Set<String> set, int num) {
        int size = set.size();
        StringBuilder numberSetStr = new StringBuilder();
        if (num >= size) {
            numberSetStr.append(String.join((CharSequence)"\u3001", set));
        } else {
            set = set.stream().limit(num).collect(Collectors.toSet());
            numberSetStr.append(String.join((CharSequence)"\u3001", set));
            numberSetStr.append("......");
        }
        return numberSetStr;
    }

    public static String fast2JsonString(Object obj) {
        return JSON.toJSONString((Object)obj);
    }
}

