/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.del.userbusirole;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.permission.api.UserScopeResultImpl;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.service.AbstractPermissionServiceImpl;
import kd.bos.permission.util.PermissionServiceImplFactory;
import kd.bos.servicehelper.QueryServiceHelper;

public class UserBusiRoleDelValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(UserBusiRoleDelValidator.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void validate() {
        HashMap<Long, ExtendedDataEntity> extDataEntityMap = new HashMap<Long, ExtendedDataEntity>(8);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            Long billPkId;
            Object billPkIdObj;
            if (null == extendedDataEntity || null == (billPkIdObj = extendedDataEntity.getBillPkId()) || StringUtils.isEmpty((Object)(billPkId = (Long)billPkIdObj))) continue;
            extDataEntityMap.put(billPkId, extendedDataEntity);
        }
        try {
            this.delPermCheck(extDataEntityMap);
        }
        catch (Exception e) {
            log.error("UserBusiRoleDelValidator.validate error.", (Throwable)e);
            throw new KDBizException("UserBusiRoleDelValidator.validate error.");
        }
    }

    private void delPermCheck(Map<Long, ExtendedDataEntity> extDataEntityMap) throws Exception {
        HashSet<Long> billPkIdSet = new HashSet<Long>(extDataEntityMap.keySet());
        if (null != billPkIdSet && !billPkIdSet.isEmpty()) {
            HashMap<String, Long> billPkIdUserIdMap = new HashMap<String, Long>(8);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UserBusiRoleDelValidator.delPermCheck", (String)"perm_userbizrole", (String)"id,user_id", (QFilter[])new QFilter[]{new QFilter("id", "in", billPkIdSet)}, (String)"");){
                while (ds.hasNext()) {
                    Long userId;
                    String billPkId;
                    Object billPkIdObj;
                    Row row = ds.next();
                    Long id = row.getLong("id");
                    ExtendedDataEntity extendedDataEntity = extDataEntityMap.get(id);
                    if (null == extendedDataEntity || null == (billPkIdObj = extendedDataEntity.getBillPkId()) || StringUtils.isEmpty((Object)(billPkId = String.valueOf(billPkIdObj))) || null == (userId = row.getLong("user_id")) || Objects.equals(0L, userId)) continue;
                    billPkIdUserIdMap.put(billPkId, userId);
                }
            }
            long currUserId = RequestContext.get().getCurrUserId();
            Map<String, String> variables = this.getOptionVariables();
            String permPkRowNumMapStr = variables.get("permPkRowNumMap");
            HashMap<String, Integer> permPkRowNumMap = StringUtils.isEmpty((Object)permPkRowNumMapStr) ? new HashMap<String, Integer>(0) : (Map)new ObjectMapper().readValue(permPkRowNumMapStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            String adminChargeUser_allUserStr = variables.get("adminChargeUser_allUser");
            String adminChargeUser_userIDsStr = variables.get("adminChargeUser_userIDs");
            this.checkUserRange(billPkIdUserIdMap, currUserId, permPkRowNumMap, adminChargeUser_allUserStr, adminChargeUser_userIDsStr);
        }
    }

    private void checkUserRange(Map<String, Long> billPkIdUserIdMap, long currUserId, Map<String, Integer> permPkRowNumMap, String adminChargeUser_allUserStr, String adminChargeUser_userIDsStr) throws Exception {
        if (null == billPkIdUserIdMap || billPkIdUserIdMap.isEmpty()) {
            return;
        }
        UserScopeResult adminChargeUser = null;
        if (StringUtils.isEmpty((Object)adminChargeUser_allUserStr) && StringUtils.isEmpty((Object)adminChargeUser_userIDsStr)) {
            adminChargeUser = UserBusiRoleDelValidator.getPermissionService().getAdminChargeUser(Long.valueOf(currUserId), false);
        } else {
            boolean allUser = !StringUtils.isEmpty((Object)adminChargeUser_allUserStr) && !Objects.equals("0", adminChargeUser_allUserStr);
            ArrayList userIDs = StringUtils.isEmpty((Object)adminChargeUser_userIDsStr) ? new ArrayList(0) : (List)new ObjectMapper().readValue(adminChargeUser_userIDsStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            adminChargeUser = new UserScopeResultImpl(allUser, userIDs);
        }
        if (adminChargeUser.isAllUser()) {
            return;
        }
        List chargeUserList = adminChargeUser.getUserIDs();
        Set want2DelUserIdSet = billPkIdUserIdMap.values().stream().collect(Collectors.toSet());
        Sets.SetView noPerm2DelUserIdSet = Sets.difference(want2DelUserIdSet, new HashSet(chargeUserList));
        if (null == noPerm2DelUserIdSet || noPerm2DelUserIdSet.isEmpty()) {
            return;
        }
        Map userInfoMap = UserHelper.getUserInfoMapByIds((Set)noPerm2DelUserIdSet, (String)RequestContext.get().getLang().name());
        for (ExtendedDataEntity value : this.dataEntities) {
            String billPkId;
            Long userId;
            User user;
            if (null == value || null == value.getBillPkId() || StringUtils.isEmpty((Object)String.valueOf(value.getBillPkId())) || null == (user = (User)userInfoMap.get(userId = billPkIdUserIdMap.get(billPkId = String.valueOf(value.getBillPkId())))) || !noPerm2DelUserIdSet.contains((Object)userId)) continue;
            value.setBillNo(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c", (String)"UserRoleDelValidator_4", (String)"bos-permission-opplugin", (Object[])new Object[0]), null == permPkRowNumMap.get(billPkId) ? 0 : permPkRowNumMap.get(billPkId) + 1));
            this.addErrorMessage(value, String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u4eba\u5458\u201c%1$s\u201d\u4e0d\u5728\u7ba1\u7406\u5458\u201c\u884c\u653f\u7ec4\u7ec7\u7ba1\u8f96\u8303\u56f4\u201d\u6216\u201c\u4f8b\u5916\u4eba\u5458\u201d\u5185\u3002", (String)"UserRoleDelValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), null == user ? "" : user.getFtruename()));
        }
    }

    private static AbstractPermissionServiceImpl getPermissionService() {
        return (AbstractPermissionServiceImpl)PermissionServiceImplFactory.getImpl(null);
    }
}

