/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.del.userdirect;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.helper.PermLogHelper;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.afterdel.UserDirectPermAfterDelReq;
import kd.bos.permission.model.perm.req.user.GetUserFuncDimReq;
import kd.bos.permission.model.perm.user.UserFuncDim;
import kd.bos.permission.opplugin.validator.del.userdirect.UserDirectPermDetailDelValidator;
import kd.bos.permission.service.UserDirectPermService;
import kd.bos.util.StringUtils;

public class UserDirectPermDetailDelOP
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(UserDirectPermDetailDelOP.class);
    private static final String[] PERM_IGNOREREFENTITYIDS = new String[]{"perm_userpermdetail"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Set ignorerefentityNumSet = FormHelper.getIgnoreRefEntNumSet((String[])PERM_IGNOREREFENTITYIDS);
        this.getOption().setVariableValue("ignorerefentityids", String.join((CharSequence)",", ignorerefentityNumSet));
        e.getValidators().add(new UserDirectPermDetailDelValidator());
    }

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            super.beginOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            Set<String> mainIdSet = Arrays.stream(dataEntities).map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
            Map<String, String> variables = this.getOptionVariables();
            String delUserFuncDimMapStr = variables.get("delUserFuncDimMap");
            if (StringUtils.isEmpty((String)delUserFuncDimMapStr)) {
                GetUserFuncDimReq req = new GetUserFuncDimReq();
                req.setReturnType(Integer.valueOf(2));
                req.setMainIdSet(mainIdSet);
                Map userFuncDimMap = UserDirectPermService.getUserFuncDimMap((GetUserFuncDimReq)req);
                this.getOption().setVariableValue("delUserFuncDimMap", StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)userFuncDimMap)));
            }
            Set<String> upfidSet = UserDirectPermDetailDelOP.getUpfidSet(mainIdSet);
            this.getOption().setVariableValue("upfidSet", SerializationUtils.toJsonString(upfidSet));
        }
        catch (Exception ex) {
            log.error("UserDirectPermDelOP.beginOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%1$s", (String)"RoleDelOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            super.endOperationTransaction(e);
            DynamicObject[] dataEntities = e.getDataEntities();
            if (null == dataEntities || Objects.equals(0, dataEntities.length)) {
                return;
            }
            Map<String, String> variables = this.getOptionVariables();
            String delUserFuncDimMapStr = variables.get("delUserFuncDimMap");
            HashMap delUserFuncDimMap = StringUtils.isEmpty((String)delUserFuncDimMapStr) ? new HashMap(1) : (Map)new ObjectMapper().readValue(StrUtil.uncompress((String)delUserFuncDimMapStr), (TypeReference)new TypeReference<Map<String, UserFuncDim>>(){});
            Set mainIdSet = Arrays.stream(dataEntities).map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
            Iterator it = delUserFuncDimMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (mainIdSet.contains(entry.getKey())) continue;
                it.remove();
            }
            if (CollectionUtils.isEmpty(delUserFuncDimMap)) {
                return;
            }
            String upfidSetStr = variables.get("upfidSet");
            HashSet<String> upfidSet = StringUtils.isEmpty((String)upfidSetStr) ? new HashSet<String>(1) : (Set)new ObjectMapper().readValue(upfidSetStr, (TypeReference)new TypeReference<Set<String>>(){});
            this.delUserperm(upfidSet);
            HashMap<Long, Set> delUserUFDMap = new HashMap<Long, Set>(8);
            for (Map.Entry delUserFuncDim : delUserFuncDimMap.entrySet()) {
                UserFuncDim value = (UserFuncDim)delUserFuncDim.getValue();
                if (null == value) continue;
                delUserUFDMap.computeIfAbsent(value.getUserId(), k -> new HashSet(8)).add(value);
            }
            String defaultFormNum = dataEntities[0].getDynamicObjectType().getName();
            PermLogReq permLogReq = PermLogHelper.wrapOperPermLogReq(variables, (String)defaultFormNum, (String)"userdirectlist_del", (String)"delete", (String)ConstantsHelper.getDel(), (String)"UserDirectPermDetailDelOP.endOperationTransaction");
            if (null != permLogReq) {
                String currbizappNum = StringUtils.isEmpty((String)variables.get("currbizappid")) ? "secm" : variables.get("currbizappid");
                permLogReq.setAppId(AppHelper.getCurAppId((String)defaultFormNum, (String)currbizappNum));
            }
            UserDirectPermAfterDelReq delReq = (UserDirectPermAfterDelReq)PermBuilder.of(UserDirectPermAfterDelReq::new).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(UserDirectPermAfterDelReq::setDelUserUFDMap, delUserUFDMap).build();
            UserDirectPermDetailDelOP.getUserDirectPermService().afterDel((PermOperationReq)delReq);
        }
        catch (Exception ex) {
            log.error("UserDirectPermDelOP.endOperationTransaction error.", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%1$s", (String)"RoleDelOP_0", (String)"bos-permission-opplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    private void delUserperm(Set<String> upfidSet) {
        if (null == upfidSet || upfidSet.isEmpty()) {
            return;
        }
        Map<String, Long> upfidMap = UserDirectPermDetailDelOP.getUpfidMap(upfidSet);
        HashSet<String> needDelUpIdSet = new HashSet<String>(8);
        for (String upfid : upfidSet) {
            Long count = upfidMap.get(upfid);
            if (null != count && !Objects.equals(0L, count)) continue;
            needDelUpIdSet.add(upfid);
        }
        if (null != needDelUpIdSet && !needDelUpIdSet.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("delete from t_perm_userperm ");
            sb.append(" where 1=1 ");
            ArrayList paramList = new ArrayList(10);
            String inStr = SqlUtil.wrapInParam(needDelUpIdSet.stream().map(x -> x).collect(Collectors.toSet()), paramList);
            if (StringUtils.isNotEmpty((String)inStr)) {
                sb.append(" and fid in (").append(inStr).append(") ");
            }
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(paramList.toArray(new Object[paramList.size()])));
        }
    }

    private static Map<String, Long> getUpfidMap(Set<String> upfidSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("select fid, count(fentryid) num ");
        sb.append(" from t_perm_userpermdetail ");
        sb.append(" where 1=1 ");
        ArrayList paramList = new ArrayList(10);
        String inStr = SqlUtil.wrapInParam(upfidSet.stream().map(x -> x).collect(Collectors.toSet()), paramList);
        if (StringUtils.isNotEmpty((String)inStr)) {
            sb.append(" and fid in (").append(inStr).append(") ");
        }
        sb.append(" group by fid ");
        final HashMap<String, Long> upfidMap = new HashMap<String, Long>(8);
        DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(paramList.toArray(new Object[paramList.size()])), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String upFid = rs.getString("fid");
                    Long num = rs.getLong("num");
                    upfidMap.put(upFid, num);
                }
                return null;
            }
        });
        return upfidMap;
    }

    private static Set<String> getUpfidSet(Set<String> mainIdSet) {
        if (null == mainIdSet || mainIdSet.isEmpty()) {
            return new HashSet<String>(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fid ");
        sb.append(" from t_perm_userpermdetail ");
        sb.append(" where 1=1 ");
        ArrayList paramList = new ArrayList(10);
        String inStr = SqlUtil.wrapInParam(mainIdSet.stream().map(x -> x).collect(Collectors.toSet()), paramList);
        if (StringUtils.isNotEmpty((String)inStr)) {
            sb.append(" and fentryid in (").append(inStr).append(") ");
        }
        final HashSet<String> upfidSet = new HashSet<String>(8);
        DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(paramList.toArray(new Object[paramList.size()])), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    upfidSet.add(rs.getString("fid"));
                }
                return null;
            }
        });
        return upfidSet;
    }

    private static UserDirectPermService getUserDirectPermService() {
        return (UserDirectPermService)PermServiceFactory.getService((String)"UserDirectPermService");
    }
}

