/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.opplugin.validator.save.userdirect;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.EnumsYesNo;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.model.perm.App;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.imp.UserDirectPermImportBean;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermUserReq;
import kd.bos.permission.model.perm.req.permitem.GetPlainPermItemListReq;
import kd.bos.permission.model.perm.req.user.GetUserFuncDimReq;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermUserResp;
import kd.bos.permission.service.UserDirectPermService;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.util.CollectionUtils;

public class UserDirectPermDetailSaveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(UserDirectPermDetailSaveValidator.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    /*
     * WARNING - void declaration
     */
    public void validate() {
        try {
            void var39_68;
            void var38_58;
            void var33_45;
            Map<String, String> variables = this.getOptionVariables();
            String skipCheckAdminDataRange = variables.get("skipCheckAdminDataRange");
            if ("true".equals(skipCheckAdminDataRange)) {
                return;
            }
            String need_execute_perm_validator = this.getOptionVariables().get("NEED_EXECUTE_PERM_VALIDATOR");
            if (!Objects.equals("1", need_execute_perm_validator)) {
                return;
            }
            String batchimport = variables.get("batchimport");
            if (Objects.equals("true", batchimport)) {
                return;
            }
            if (null == this.dataEntities || 0 == this.dataEntities.length) {
                return;
            }
            HashSet<String> userIdSet = new HashSet<String>(8);
            HashSet<String> appIdSet = new HashSet<String>(8);
            HashSet<String> entNumSet = new HashSet<String>(8);
            HashSet<String> permItemIdSet = new HashSet<String>(8);
            HashMap<String, Set> dimTypeSmallDimIdSetMap = new HashMap<String, Set>(8);
            ArrayList<ExtendedDataEntity> list = new ArrayList<ExtendedDataEntity>(10);
            for (ExtendedDataEntity extendedData : this.dataEntities) {
                Object userIdObj = extendedData.getValue("user_id");
                if (null == userIdObj) {
                    String info = ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectPermDetailSaveValidator_0", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedData, info);
                    continue;
                }
                Object appIdObj = extendedData.getValue("bizapp_id");
                if (null == appIdObj) {
                    String info = ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectPermDetailSaveValidator_1", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedData, info);
                    continue;
                }
                Iterator entNumObj = extendedData.getValue("entitytype_id");
                if (null == entNumObj) {
                    String info = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectPermDetailSaveValidator_2", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedData, info);
                    continue;
                }
                Object permItemIdObj = extendedData.getValue("permitem_id");
                if (null == permItemIdObj) {
                    String info = ResManager.loadKDString((String)"\u6743\u9650\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectPermDetailSaveValidator_3", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedData, info);
                    continue;
                }
                Object dimTypeObj = extendedData.getValue("dimtype");
                if (null == dimTypeObj) {
                    String info = ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectPermDetailSaveValidator_4", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedData, info);
                    continue;
                }
                Object dimIdObj = extendedData.getValue("dimid_id");
                if (null == dimIdObj) {
                    String info = ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectPermDetailSaveValidator_5", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedData, info);
                    continue;
                }
                userIdSet.add(String.valueOf((Long)userIdObj));
                appIdSet.add((String)appIdObj);
                entNumSet.add((String)((Object)entNumObj));
                permItemIdSet.add((String)permItemIdObj);
                dimTypeSmallDimIdSetMap.computeIfAbsent((String)dimTypeObj, k -> new HashSet(8)).add(String.valueOf((Long)dimIdObj));
                list.add(extendedData);
            }
            HashMap<String, Map> dimTypeDimIdNumMap = new HashMap<String, Map>(8);
            for (Map.Entry dimTypeSmallDimIdSet : dimTypeSmallDimIdSetMap.entrySet()) {
                Map dimIdDimSetMap;
                String dimTypeSmall = (String)dimTypeSmallDimIdSet.getKey();
                Set dimIdSet = (Set)dimTypeSmallDimIdSet.getValue();
                if (kd.bos.util.StringUtils.isEmpty((String)dimTypeSmall) || CollectionUtils.isEmpty((Collection)dimIdSet) || null == (dimIdDimSetMap = IsoDimHelper.getDimSetMap((Set)dimIdSet, (String)"id", (String)dimTypeSmall)) || dimIdDimSetMap.isEmpty()) continue;
                for (Map.Entry dimIdDimSet : dimIdDimSetMap.entrySet()) {
                    String dimId = (String)dimIdDimSet.getKey();
                    Set value = (Set)dimIdDimSet.getValue();
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)dimId) || null == value || value.isEmpty()) continue;
                    for (Dim dim : value) {
                        dimTypeDimIdNumMap.computeIfAbsent(dimTypeSmall, k -> new HashMap(8)).put(String.valueOf(dim.getDimId()), dim.getDimNumber());
                    }
                }
            }
            String permCtrlTypeMapStr = variables.get("permCtrlTypeMap");
            Map permCtrlTypeMap = StringUtils.isEmpty((Object)permCtrlTypeMapStr) ? IsoDimHelper.getEntPermCtrlTypeMap(null) : (Map)new ObjectMapper().readValue(permCtrlTypeMapStr, (TypeReference)new TypeReference<HashMap<String, PermCtrlType>>(){});
            permCtrlTypeMap = null == permCtrlTypeMap ? new HashMap(0) : permCtrlTypeMap;
            Map userMap = UserHelper.getUserMap(userIdSet, (String)"id");
            Map appMap = AppHelper.getAppMap(appIdSet, (String)"id");
            Map entMap = FormHelper.getEntMap(entNumSet, (String)"number");
            Map permItemMap = PermItemHelper.getPermItemMap(permItemIdSet, (String)"id");
            HashSet<String> userNumSet = new HashSet<String>(8);
            HashSet<String> appNumSet = new HashSet<String>(8);
            entNumSet.clear();
            HashSet<String> permItemNumSet = new HashSet<String>(8);
            ArrayList<UserDirectPermImportBean> importBeanList = new ArrayList<UserDirectPermImportBean>(this.dataEntities.length);
            HashMap<String, ExtendedDataEntity> uniqueExtendedDataEntityMap = new HashMap<String, ExtendedDataEntity>(8);
            UserDirectPermImportBean importBean = null;
            for (ExtendedDataEntity extendedData : list) {
                String userId = String.valueOf((Long)extendedData.getValue("user_id"));
                Set users = (Set)userMap.get(userId);
                if (null == users) {
                    String info = ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"UserDirectPermDetailSaveValidator_6", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedData, info);
                    continue;
                }
                String appId = (String)extendedData.getValue("bizapp_id");
                Set apps = (Set)appMap.get(appId);
                if (null == apps) {
                    String info = ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u5b58\u5728\u3002", (String)"UserDirectPermDetailSaveValidator_7", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedData, info);
                    continue;
                }
                String entNum = (String)extendedData.getValue("entitytype_id");
                Set ents = (Set)entMap.get(entNum);
                if (null == ents) {
                    String info = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"UserDirectPermDetailSaveValidator_8", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedData, info);
                    continue;
                }
                String permItemId = (String)extendedData.getValue("permitem_id");
                Set set = (Set)permItemMap.get(permItemId);
                if (null == set) {
                    String info = ResManager.loadKDString((String)"\u6743\u9650\u9879\u4e0d\u5b58\u5728\u3002", (String)"UserDirectPermDetailSaveValidator_9", (String)"bos-permission-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedData, info);
                    continue;
                }
                importBean = new UserDirectPermImportBean();
                User user = (User)users.stream().findFirst().get();
                String userNum = user.getFnumber();
                userNumSet.add(userNum);
                App app = (App)apps.stream().findFirst().get();
                String appNumber = app.getAppNumber();
                appNumSet.add(appNumber);
                Entity entity = (Entity)ents.stream().findFirst().get();
                String string = entity.getEntityNumber();
                entNumSet.add(string);
                PermItem permItem = (PermItem)set.stream().findFirst().get();
                String permItemNumber = permItem.getPermItemNumber();
                permItemNumSet.add(permItemNumber);
                importBean.setAppNumber(appNumber);
                importBean.setEntityNumber(string);
                importBean.setPermItemNumber(permItemNumber);
                importBean.setUserNumber(userNum);
                String dimTypeSmall = (String)extendedData.getValue("dimtype");
                importBean.setDimType(dimTypeSmall);
                PermCtrlType permCtrlType = (PermCtrlType)permCtrlTypeMap.get(dimTypeSmall);
                if (null != permCtrlType) {
                    importBean.setDimTypeBig(permCtrlType.getNumber());
                }
                Long dimId = (Long)extendedData.getValue("dimid_id");
                Map dimIdNumMap = null == dimTypeDimIdNumMap.get(dimTypeSmall) ? new HashMap(0) : (Map)dimTypeDimIdNumMap.get(dimTypeSmall);
                String dimNum = null == dimIdNumMap.get(String.valueOf(dimId)) ? "" : (String)dimIdNumMap.get(String.valueOf(dimId));
                importBean.setDimNum(dimNum);
                Boolean includesuborg = null == extendedData.getValue("includesub") ? Boolean.FALSE : (Boolean)extendedData.getValue("includesub");
                importBean.setIncludeSub(includesuborg);
                String busiUniqueKey = userId + "_" + appId + "_" + entNum + "_" + (String)permItemId + "_" + (String)dimTypeSmall + "_" + dimId;
                importBean.setNumber(busiUniqueKey);
                importBeanList.add(importBean);
                uniqueExtendedDataEntityMap.put(busiUniqueKey, extendedData);
            }
            HashMap<String, Map> dimTypeDimNumDimMap = new HashMap<String, Map>(0);
            HashMap<String, GetHasPermPermCtrlObjResp> dimTypeAdminHasPermPermCtrlObjMap = new HashMap<String, GetHasPermPermCtrlObjResp>(0);
            HashMap<String, Map> dimTypeDimNumExistMap = new HashMap<String, Map>(0);
            HashMap<String, GetHasPermUserResp> dimTypeAdminHasPermUserMap = new HashMap<String, GetHasPermUserResp>(0);
            HashSet dimIdSet = null;
            long currUserId = RequestContext.get().getCurrUserId();
            if (null != dimTypeSmallDimIdSetMap && !dimTypeSmallDimIdSetMap.isEmpty()) {
                int size = dimTypeSmallDimIdSetMap.size();
                dimTypeDimNumDimMap = new HashMap(size);
                dimTypeAdminHasPermPermCtrlObjMap = new HashMap(size);
                dimTypeDimNumExistMap = new HashMap(size);
                dimTypeAdminHasPermUserMap = new HashMap(size);
                dimIdSet = new HashSet(8);
                for (Map.Entry entry : dimTypeSmallDimIdSetMap.entrySet()) {
                    String dimTypeSmall = (String)entry.getKey();
                    Set dimIdStrSet = (Set)entry.getValue();
                    if (kd.bos.util.StringUtils.isEmpty((String)dimTypeSmall) || CollectionUtils.isEmpty((Collection)dimIdStrSet)) continue;
                    HashSet<String> dimNumSet = new HashSet<String>(8);
                    Map dimIdDimSetMap = IsoDimHelper.getDimSetMap((Set)dimIdStrSet, (String)"id", (String)dimTypeSmall);
                    for (Map.Entry entry2 : dimIdDimSetMap.entrySet()) {
                        String dimId = (String)entry2.getKey();
                        Set value = (Set)entry2.getValue();
                        if (!kd.bos.util.StringUtils.isNotEmpty((String)dimId) || null == value || value.isEmpty()) continue;
                        for (Dim dim : value) {
                            dimTypeDimNumDimMap.computeIfAbsent(dimTypeSmall, k -> new HashMap(8)).computeIfAbsent(dim.getDimNumber(), k -> new HashSet(8)).add(dim);
                            dimNumSet.add(dim.getDimNumber());
                        }
                    }
                    Set set = dimIdDimSetMap.values().stream().flatMap(Collection::stream).map(Dim::getDimId).collect(Collectors.toSet());
                    GetHasPermPermCtrlObjResp getHasPermPermCtrlObjResp = PermCtrlTypeService.getAdminHasPermPermCtrlObj((GetHasPermPermCtrlObjReq)new GetHasPermPermCtrlObjReq(dimTypeSmall, Long.valueOf(currUserId), set, dimNumSet));
                    dimTypeAdminHasPermPermCtrlObjMap.put(dimTypeSmall, getHasPermPermCtrlObjResp);
                    Map dimNumExistMap = PermVerifyUtil.getExistMapByNum((String)dimTypeSmall, dimNumSet);
                    dimTypeDimNumExistMap.put(dimTypeSmall, dimNumExistMap);
                    GetHasPermUserResp adminHasPermUser = PermCtrlTypeService.getAdminHasPermUser((GetHasPermUserReq)new GetHasPermUserReq(dimTypeSmall, Long.valueOf(currUserId), null, userNumSet));
                    dimTypeAdminHasPermUserMap.put(dimTypeSmall, adminHasPermUser);
                    dimIdSet.addAll(set);
                }
            }
            HashMap<String, Object> importCheckParamMap = new HashMap<String, Object>(8);
            importCheckParamMap.put("dimTypeDimNumDimMap", dimTypeDimNumDimMap);
            importCheckParamMap.put("dimTypeAdminHasPermPermCtrlObjMap", dimTypeAdminHasPermPermCtrlObjMap);
            importCheckParamMap.put("dimTypeDimNumExistMap", dimTypeDimNumExistMap);
            importCheckParamMap.put("dimTypeAdminHasPermUserMap", dimTypeAdminHasPermUserMap);
            Map userFuncDimMap = UserDirectPermService.getUserFuncDimMap((GetUserFuncDimReq)new GetUserFuncDimReq(Integer.valueOf(1), null, userIdSet.stream().map(Long::valueOf).collect(Collectors.toSet()), null, appIdSet, null, entNumSet, permItemIdSet, permItemNumSet, dimTypeDimNumDimMap.keySet(), dimIdSet, null));
            importCheckParamMap.put("userFuncDimMap", userFuncDimMap);
            Object var33_43 = null;
            if (CollectionUtils.isNotEmpty(appNumSet)) {
                Map map = AppHelper.getAppMap(appNumSet, (String)"number");
            }
            importCheckParamMap.put("appMap", var33_45);
            Map numEntSetMap = null;
            HashMap<String, String> formCtrlTypeMap = null;
            if (CollectionUtils.isNotEmpty(entNumSet)) {
                numEntSetMap = FormHelper.getEntMap(entNumSet, (String)"number");
                Map permControlTypeMap = PermCommonUtil.getPermControlType(entNumSet);
                if (null != permControlTypeMap && !permControlTypeMap.isEmpty()) {
                    formCtrlTypeMap = new HashMap<String, String>(permControlTypeMap.size());
                    for (Map.Entry entry : permControlTypeMap.entrySet()) {
                        String dimension;
                        boolean emptyObject;
                        boolean controlFunction;
                        String string = (String)entry.getKey();
                        PermissionControlType value = (PermissionControlType)entry.getValue();
                        if (kd.bos.util.StringUtils.isEmpty((String)string) || null == value || !(controlFunction = value.isControlFunction()) || (emptyObject = value.isEmptyObject()) || kd.bos.util.StringUtils.isEmpty((String)(dimension = value.getDimension()))) continue;
                        formCtrlTypeMap.put(string, dimension);
                    }
                }
            }
            importCheckParamMap.put("entMap", numEntSetMap);
            importCheckParamMap.put("formCtrlTypeMap", formCtrlTypeMap);
            Map numPermItemMap = null;
            Map permItemExistMap = null;
            if (CollectionUtils.isNotEmpty(permItemNumSet)) {
                numPermItemMap = PermItemHelper.getPermItemMap(permItemNumSet, (String)"number");
            }
            if (CollectionUtils.isNotEmpty(permItemIdSet)) {
                permItemExistMap = PermItemHelper.getPermItemMap(permItemIdSet);
            }
            importCheckParamMap.put("permItemMap", numPermItemMap);
            importCheckParamMap.put("permItemExistMap", permItemExistMap);
            HashMap hashMap = new HashMap(1);
            HashMap hashMap2 = new HashMap(1);
            if (CollectionUtils.isNotEmpty(userNumSet)) {
                Map map = UserHelper.getUserMap(userNumSet, (String)"number");
                Map map2 = PermVerifyUtil.getExistMapByNum((String)"bos_user", userNumSet);
            }
            importCheckParamMap.put("userNumMap", var38_58);
            importCheckParamMap.put("userNumExistMap", var39_68);
            String yesNoMapStr = variables.get("yesNoMap");
            Map enumsYesNoMap = kd.bos.util.StringUtils.isEmpty((String)yesNoMapStr) ? EnumsYesNo.getMap() : (Map)new ObjectMapper().readValue(yesNoMapStr, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            importCheckParamMap.put("yesNoMap", enumsYesNoMap);
            String bigPermCtrlTypeMapStr = variables.get("bigPermCtrlTypeMap");
            Map bigPermCtrlTypeMap = kd.bos.util.StringUtils.isEmpty((String)bigPermCtrlTypeMapStr) ? IsoDimHelper.getBigPermCtrlTypeMap(null) : (Map)new ObjectMapper().readValue(bigPermCtrlTypeMapStr, (TypeReference)new TypeReference<HashMap<String, PermCtrlType>>(){});
            bigPermCtrlTypeMap = null == bigPermCtrlTypeMap ? new HashMap(0) : bigPermCtrlTypeMap;
            importCheckParamMap.put("bigPermCtrlTypeMap", bigPermCtrlTypeMap);
            HashSet plainPermItemSet = null;
            String plainPermItemSetStr = variables.get("plainPermItemSet");
            if (kd.bos.util.StringUtils.isEmpty((String)plainPermItemSetStr)) {
                GetPlainPermItemListReq getPlainPermItemListReq = new GetPlainPermItemListReq();
                getPlainPermItemListReq.setDimType("DIM_ORG");
                getPlainPermItemListReq.setReturnByField(true);
                getPlainPermItemListReq.setReturnFieldSet((Set)ListUtil.newHashSet((Object[])new String[]{"appNumber", "entityNumber", "permItemNumber"}));
                List plainPermItemList = PermItemHelper.getPlainPermItemList((GetPlainPermItemListReq)getPlainPermItemListReq);
                plainPermItemSet = new HashSet(plainPermItemList);
            } else {
                plainPermItemSet = (HashSet)new ObjectMapper().readValue(plainPermItemSetStr, (TypeReference)new TypeReference<HashSet<PermItem>>(){});
            }
            plainPermItemSet = null == plainPermItemSet ? new HashSet(0) : plainPermItemSet;
            importCheckParamMap.put("plainPermItemSet", plainPermItemSet);
            HashMap<String, Set> appNumEntNumSetMap = new HashMap<String, Set>(8);
            HashMap<String, Set> entNumPermItemNumSetMap = new HashMap<String, Set>(8);
            for (PermItem permItem : plainPermItemSet) {
                appNumEntNumSetMap.computeIfAbsent(permItem.getAppNumber(), k -> new HashSet(8)).add(permItem.getEntityNumber());
                entNumPermItemNumSetMap.computeIfAbsent(permItem.getEntityNumber(), k -> new HashSet(8)).add(permItem.getPermItemNumber());
            }
            importCheckParamMap.put("appNumEntNumSetMap", appNumEntNumSetMap);
            importCheckParamMap.put("entNumPermItemNumSetMap", entNumPermItemNumSetMap);
            String adminChargeAppSetStr = variables.get("adminChargeAppSet");
            HashSet adminChargeAppSet = kd.bos.util.StringUtils.isEmpty((String)adminChargeAppSetStr) ? new HashSet(AdminPermCache.getAdminChargeApps((Long)currUserId, null)) : (Set)new ObjectMapper().readValue(adminChargeAppSetStr, (TypeReference)new TypeReference<HashSet<String>>(){});
            adminChargeAppSet = null == adminChargeAppSet ? new HashSet(0) : adminChargeAppSet;
            importCheckParamMap.put("adminChargeAppSet", adminChargeAppSet);
            Map allAppInfo = AppMetadataCache.getAllAppInfo();
            importCheckParamMap.put("allAppInfo", allAppInfo);
            String allPermItemNumberIdMapStr = variables.get("allPermItemNumberIdMap");
            Map allPermItemNumberIdMap = kd.bos.util.StringUtils.isEmpty((String)allPermItemNumberIdMapStr) ? PermItemHelper.getAllPermItemNumberIdMap() : (Map)new ObjectMapper().readValue(allPermItemNumberIdMapStr, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            allPermItemNumberIdMap = null == allPermItemNumberIdMap ? new HashMap(0) : allPermItemNumberIdMap;
            importCheckParamMap.put("allPermItemNumberIdMap", allPermItemNumberIdMap);
            PermBeforeSaveCheckReq req = new PermBeforeSaveCheckReq();
            req.setEnumsImportType(EnumsImportType.NEW);
            req.setKeyFieldList(new ArrayList(0));
            req.setNeedCheckBeanList(importBeanList);
            req.setCheckNeedParamMap(importCheckParamMap);
            UserDirectPermService service = (UserDirectPermService)PermServiceFactory.getService((String)"UserDirectPermService");
            PermCheckResp resp = service.beforeSaveCheck(req);
            Map numFailedErrorMap = resp.getNumFailedErrorMap();
            if (null != numFailedErrorMap && !numFailedErrorMap.isEmpty()) {
                for (Map.Entry numFailedError : numFailedErrorMap.entrySet()) {
                    String key = (String)numFailedError.getKey();
                    List value = (List)numFailedError.getValue();
                    ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)uniqueExtendedDataEntityMap.get(key);
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)key) || null == value || value.isEmpty() || null == extendedDataEntity) continue;
                    for (String errorMsg : value) {
                        this.addErrorMessage(extendedDataEntity, errorMsg);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("UserDirectPermDetailSaveValidator_validate_error.", (Throwable)e);
            throw new KDBizException("UserDirectPermDetailSaveValidator_validate_error.");
        }
    }
}

