/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.log.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermMessage;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.log.model.common.DimPermItem;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class LogDimFunc
extends DimPermItem
implements Serializable {
    private static final long serialVersionUID = 329906770577674420L;
    private static final Log log = LogFactory.getLog(LogDimFunc.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_LogDimFunc_Pool", (int)4);
    @ApiParam(value="\u7528\u6237id::LogDimFunc_1::bos-permission-log")
    private @ApiParam(value="\u7528\u6237id::LogDimFunc_1::bos-permission-log") Long userId;
    @ApiParam(value="\u59d3\u540d::LogDimFunc_2::bos-permission-log")
    private @ApiParam(value="\u59d3\u540d::LogDimFunc_2::bos-permission-log") String trueName;
    @ApiParam(value="\u5de5\u53f7::LogDimFunc_3::bos-permission-log")
    private @ApiParam(value="\u5de5\u53f7::LogDimFunc_3::bos-permission-log") String userNumber;
    @ApiParam(value="\u7528\u6237\u540d::LogDimFunc_4::bos-permission-log")
    private @ApiParam(value="\u7528\u6237\u540d::LogDimFunc_4::bos-permission-log") String userName;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogDimFunc that = (LogDimFunc)o;
        return Objects.equals(this.userId, that.userId) && Objects.equals(this.userNumber, that.userNumber);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userId, this.userNumber);
    }

    public static Map<String, Object> logCompareMutiThread(List<LogDimFunc> preList, List<LogDimFunc> afterList) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("del", new LinkedList());
        map.put("add", new LinkedList());
        try {
            HashMap<String, Set> dimTypeDimIdSetMap = new HashMap<String, Set>(8);
            for (LogDimFunc one : preList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            for (LogDimFunc one : afterList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            if (null == dimTypeDimIdSetMap || dimTypeDimIdSetMap.isEmpty()) {
                return map;
            }
            List del = (List)map.get("del");
            List add = (List)map.get("add");
            for (Map.Entry dimTypeDimIdSet : dimTypeDimIdSetMap.entrySet()) {
                Set dimIdSet = (Set)dimTypeDimIdSet.getValue();
                Iterator iterator = dimIdSet.iterator();
                int i = 0;
                int oneThreadDeal = 1;
                ArrayList<Long> list = new ArrayList<Long>(oneThreadDeal);
                ArrayList<Future> futureList = new ArrayList<Future>(dimIdSet.size());
                while (iterator.hasNext()) {
                    Long dimId = (Long)iterator.next();
                    list.add(dimId);
                    if (i % oneThreadDeal != 0) {
                        ArrayList<Long> oneThreadList = list;
                        List<LogDimFunc> oneThreadPreList = preList.stream().filter(ldf -> oneThreadList.contains(ldf.getDimId())).collect(Collectors.toList());
                        List<LogDimFunc> oneThreadAfterList = afterList.stream().filter(ldf -> oneThreadList.contains(ldf.getDimId())).collect(Collectors.toList());
                        futureList.add(pool.submit(LogDimFunc.diff(oneThreadPreList, oneThreadAfterList)));
                        list.clear();
                    }
                    ++i;
                }
                if (!CollectionUtils.isEmpty(list)) {
                    ArrayList<Long> oneThreadList = list;
                    List<LogDimFunc> oneThreadPreList = preList.stream().filter(ldd -> oneThreadList.contains(ldd.getDimId())).collect(Collectors.toList());
                    List<LogDimFunc> oneThreadAfterList = afterList.stream().filter(ldd -> oneThreadList.contains(ldd.getDimId())).collect(Collectors.toList());
                    futureList.add(pool.submit(LogDimFunc.diff(oneThreadPreList, oneThreadAfterList)));
                }
                if (CollectionUtils.isEmpty(futureList)) continue;
                for (Future future : futureList) {
                    try {
                        Map futureMap = (Map)future.get();
                        List futureDel = (List)futureMap.get("del");
                        List futureAdd = (List)futureMap.get("add");
                        del.addAll(futureDel);
                        add.addAll(futureAdd);
                    }
                    catch (Exception e) {
                        log.error("LogDimFunc.logCompareMutiThread --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, e});
                        throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
                    }
                }
            }
            Long elementBytes = PermMessage.getListEleOccupyBytes(CollectionUtils.isEmpty((Collection)del) ? null : del.get(0), CollectionUtils.isEmpty((Collection)add) ? null : add.get(0), null);
            map.put("ELEMENTBYTES", elementBytes);
            map.put("ELEMENTCOUNT", del.size() + add.size());
            return map;
        }
        catch (Exception e) {
            log.error("LogDimFunc.logCompareMutiThread --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, e});
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private static Callable<Map<String, List<LogDimFunc>>> diff(final List<LogDimFunc> preList, final List<LogDimFunc> afterList) {
        return new Callable<Map<String, List<LogDimFunc>>>(){

            @Override
            public Map<String, List<LogDimFunc>> call() throws Exception {
                try {
                    return LogDimFunc.logCompare(preList, afterList);
                }
                catch (Exception ex) {
                    log.error("LogDimFunc.diff --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, ex});
                    throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
                }
            }
        };
    }

    public static Map<String, List<LogDimFunc>> logCompare(List<LogDimFunc> preList, List<LogDimFunc> afterList) {
        HashMap<String, List<LogDimFunc>> map = new HashMap<String, List<LogDimFunc>>(2);
        List delList = ListUtil.removeAll(preList, afterList);
        List addList = ListUtil.removeAll(afterList, preList);
        String dimFuncDelDesc = ConstantsHelper.getDel();
        EnumsDataChangeType delDFC = EnumsDataChangeType.DEL;
        String funcPermDesc = ConstantsHelper.getFuncPerm();
        String delOpDesc = dimFuncDelDesc + funcPermDesc;
        delList.stream().forEach(ldf -> {
            ldf.setOpDesc(delOpDesc);
            ldf.setDataChangeType(delDFC);
            ldf.setDataChangeTypeDesc(dimFuncDelDesc);
        });
        String dimFuncAddDesc = ConstantsHelper.getAdd();
        EnumsDataChangeType addDFC = EnumsDataChangeType.ADD;
        String addOpDesc = dimFuncAddDesc + funcPermDesc;
        addList.stream().forEach(ldf -> {
            ldf.setOpDesc(addOpDesc);
            ldf.setDataChangeType(addDFC);
            ldf.setDataChangeTypeDesc(dimFuncAddDesc);
        });
        map.put("del", delList);
        map.put("add", addList);
        return map;
    }

    @Deprecated
    @SdkInternal
    public static void save2DB(List<LogDimFunc> diffList, Long fid) {
        LogDimFunc.save2DB(diffList, fid, null);
    }

    @Deprecated
    @SdkInternal
    public static void save2DB(List<LogDimFunc> diffList, Long fid, Map<String, Object> paraMap) {
        LogDimFunc.save2DB(diffList, fid, paraMap, null);
    }

    public static void save2DB(List<LogDimFunc> diffList, Long fid, Map<String, Object> paraMap, Set<String> influenceEntNumSet) {
        HashMap<String, List> dimTypeRecordMap = new HashMap<String, List>(8);
        HashSet<Long> userIdSet = new HashSet<Long>(8);
        HashSet<String> appIdSet = new HashSet<String>(8);
        HashSet<String> entNumSet = new HashSet<String>(8);
        HashSet<String> permItemIdSet = new HashSet<String>(8);
        for (LogDimFunc logDimFunc : diffList) {
            userIdSet.add(logDimFunc.getUserId());
            dimTypeRecordMap.computeIfAbsent(logDimFunc.getDimType(), k -> new ArrayList(10)).add(logDimFunc);
            appIdSet.add(logDimFunc.getAppId());
            entNumSet.add(logDimFunc.getEntityId());
            permItemIdSet.add(logDimFunc.getPermItemId());
        }
        if (null == dimTypeRecordMap || dimTypeRecordMap.isEmpty()) {
            return;
        }
        if (null == paraMap) {
            paraMap = new HashMap<String, Object>(8);
            paraMap.put("includeDesc", ConstantsHelper.getInclude());
            paraMap.put("notIncludeDesc", ConstantsHelper.getNotInclude());
            paraMap.put("entPermCtrlTypeMap", IsoDimHelper.getEntPermCtrlTypeMap(null));
        }
        Map entPermCtrlTypeMap = (Map)paraMap.get("entPermCtrlTypeMap");
        String includeDesc = (String)paraMap.get("includeDesc");
        String notIncludeDesc = (String)paraMap.get("notIncludeDesc");
        Map userInfoMap = UserHelper.getUserInfoMapByIds(userIdSet, null);
        Map appIdCloudMap = AppHelper.getCloudMap(new ArrayList(appIdSet));
        Map allAppIdNameMap = AppHelper.getAllAppIdNameMap(appIdSet);
        HashMap<String, HashSet<String>> ent_paraMap = new HashMap<String, HashSet<String>>(8);
        ent_paraMap.put("paramEntNumSet", entNumSet);
        Map entNumEntMap = FormHelper.getEntNumEntMap(ent_paraMap);
        Map permItemMap = PermItemHelper.getPermItemMap(permItemIdSet);
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append("t_perm_log_diff_dimfunc");
        sb.append("(fid, fperm_logid, fuser_id, fuser_name, fuser_number, fuser_username, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, fperm_item_id, fperm_item_name, fdim_id, fdim_number, fdim_name, finclude_suborg, finclude_suborg_desc, fdimtype, fdimtypedesc, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int size = diffList.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        LocalDateTime curTime = LocalDateTime.now();
        Object[] obj = null;
        String cloudId = "";
        String cloudName = "";
        String appName = "";
        String entityName = "";
        String permItemName = "";
        String includesuborgDesc = "";
        String dimTypeDesc = "";
        String dimName = "";
        String dimNumber = "";
        String trueName = "";
        String userNumber = "";
        String userName = "";
        int i = 0;
        for (Map.Entry dimTypeRecord : dimTypeRecordMap.entrySet()) {
            String dimType = (String)dimTypeRecord.getKey();
            List recordList = (List)dimTypeRecord.getValue();
            if (StringUtils.isEmpty((String)dimType) || null == recordList || recordList.isEmpty()) continue;
            Set dimIdSet = recordList.stream().map(DimPermItem::getDimId).collect(Collectors.toSet());
            Map dimMap = IsoDimHelper.getDimMap(new ArrayList(dimIdSet), (String)dimType);
            for (LogDimFunc one : recordList) {
                Long userIdOne;
                User user;
                String appId = one.getAppId();
                String entityId = one.getEntityId();
                String permItemId = one.getPermItemId();
                DynamicObject cloudObj = (DynamicObject)appIdCloudMap.get(appId);
                if (null != cloudObj) {
                    cloudId = cloudObj.getString("bizcloud.id");
                    cloudName = cloudObj.getString("bizcloud.name");
                }
                appName = StrUtil.nullAbleStr((String)((String)allAppIdNameMap.get(appId)));
                Entity entity = (Entity)entNumEntMap.get(entityId);
                entityName = null == entity ? "" : entity.getEntityName();
                PermItem permItem = (PermItem)permItemMap.get(permItemId);
                permItemName = null == permItem ? "" : permItem.getPermItemName();
                String includesuborg = one.getIncludesuborg();
                includesuborgDesc = StringUtils.isEmpty((String)includesuborg) ? "" : ("1".equals(includesuborg) ? includeDesc : notIncludeDesc);
                PermCtrlType permCtrlType = (PermCtrlType)entPermCtrlTypeMap.get(dimType);
                dimTypeDesc = null == permCtrlType ? " " : permCtrlType.getName();
                Long dimId = one.getDimId();
                Dim dim = (Dim)dimMap.get(dimId);
                if (null != dim) {
                    dimName = dim.getDimName();
                    dimNumber = dim.getDimNumber();
                }
                if (null != (user = (User)userInfoMap.get(userIdOne = one.getUserId()))) {
                    trueName = StrUtil.nullAbleStr((String)user.getFtruename());
                    userNumber = StrUtil.nullAbleStr((String)user.getFnumber());
                    userName = StrUtil.nullAbleStr((String)user.getFusername());
                }
                String nullAbleAppId = StrUtil.nullAbleStr((String)appId);
                entityId = StrUtil.nullAbleStr((String)entityId);
                obj = new Object[]{ids[i], fid, userIdOne, trueName, userNumber, userName, StrUtil.nullAbleStr((String)cloudId), StrUtil.nullAbleStr((String)cloudName), nullAbleAppId, StrUtil.nullAbleStr((String)appName), entityId, StrUtil.nullAbleStr((String)entityName), StrUtil.nullAbleStr((String)permItemId), StrUtil.nullAbleStr((String)permItemName), dimId, StrUtil.nullAbleStr((String)dimNumber), StrUtil.nullAbleStr((String)dimName), StrUtil.nullAbleStr((String)includesuborg), StrUtil.nullAbleStr((String)includesuborgDesc), StrUtil.nullAbleStr((String)one.getDimType()), StrUtil.nullAbleStr((String)dimTypeDesc), StrUtil.nullAbleStr((String)one.getOpDesc()), curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
                if (null != influenceEntNumSet) {
                    influenceEntNumSet.add(entityId);
                }
                ++i;
            }
        }
        SqlUtil.syncInsert(paramList, (String)sb.toString(), (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.log, (boolean)true);
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getTrueName() {
        return this.trueName;
    }

    public void setTrueName(String trueName) {
        this.trueName = trueName;
    }

    public String getUserNumber() {
        return this.userNumber;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

