/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.validation.groups.Default;
import joptsimple.internal.Strings;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.api.group.Add;
import kd.bos.permission.api.group.PermLog;
import kd.bos.permission.api.group.Update;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.DataRuleCache;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ComRoleGroupHelper;
import kd.bos.permission.cache.helper.DrHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.OrgUserHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLogUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.AssignModEnum;
import kd.bos.permission.enums.ComRoleContentEnum;
import kd.bos.permission.enums.EnumsEnable;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.EnumsUseScope;
import kd.bos.permission.enums.EnumsYesNo;
import kd.bos.permission.enums.OperationTypeEnum;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.model.DataRulesInfo;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.permission.model.perm.ComRoleAdminGrp;
import kd.bos.permission.model.perm.ComRoleFieldPermScheme;
import kd.bos.permission.model.perm.ComRoleGroup;
import kd.bos.permission.model.perm.DimUser;
import kd.bos.permission.model.perm.FieldPerm;
import kd.bos.permission.model.perm.FieldPermScheme;
import kd.bos.permission.model.perm.NewDrPerm;
import kd.bos.permission.model.perm.NewDrPrPerm;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.PermPageReq;
import kd.bos.permission.model.perm.comrole.ComRoleFuncPerm;
import kd.bos.permission.model.perm.imp.ComRoleImportBean;
import kd.bos.permission.model.perm.req.ComRoleAddOrUpdateReq;
import kd.bos.permission.model.perm.req.ComRoleDelReq;
import kd.bos.permission.model.perm.req.ComRoleEnableChangeReq;
import kd.bos.permission.model.perm.req.GetComRoleAssignedDimUserReq;
import kd.bos.permission.model.perm.req.GetComRoleListReq;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.bat.afterdel.ComRoleAfterDelReq;
import kd.bos.permission.model.perm.req.bat.aftersave.ComRoleAfterSaveReq;
import kd.bos.permission.model.perm.req.comrole.get.ComRoleOperationReq;
import kd.bos.permission.model.perm.req.permitem.GetPlainPermItemListReq;
import kd.bos.permission.model.perm.resp.GetComRoleAssignedDimUserResp;
import kd.bos.permission.model.perm.resp.GetComRoleListResp;
import kd.bos.permission.model.perm.resp.GetComRolePageListResp;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.CommonService;
import kd.bos.permission.util.PermFilterUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class ComRoleService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(ComRoleService.class);
    private static final String SYSTERM_TYPE = "bos-mservice-permission";

    public static Map<String, Set<ComRole>> getAdminGroupRoleRangeMap(Set<String> idOrNumberOrNameSet, String keyType) {
        HashMap<String, Set<ComRole>> map = new HashMap<String, Set<ComRole>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("id", keyType)) {
            qFilterList.add(new QFilter("id", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("number", keyType)) {
            qFilterList.add(new QFilter("number", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("name", keyType)) {
            qFilterList.add(new QFilter("name", "in", idOrNumberOrNameSet));
        }
        HashMap<String, Object> roleParamMap = new HashMap<String, Object>(8);
        roleParamMap.put("dimType", "");
        roleParamMap.put("filterAppNumsStr", "");
        roleParamMap.put("roleIdField", "id");
        QFilter roleFilter = PermFilterUtil.getComRoleQfilter(roleParamMap);
        qFilterList.add(roleFilter);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ComRoleService.getAdminGroupRoleRangeMap", (String)"perm_role", (String)"id, number, name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            ComRole one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new ComRole();
                String id = row.getString("id");
                String number = row.getString("number");
                String name = row.getString("name");
                one.setId(id);
                one.setNumber(number);
                one.setName(name);
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(id, k -> new HashSet()).add(one);
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(name, k -> new HashSet()).add(one);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(number, k -> new HashSet()).add(one);
            }
        }
        return map;
    }

    public PermResult add(ComRoleAddOrUpdateReq req) {
        super.checkPerm("perm_role", "47156aff000000ac", (Object)req);
        super.commonValidate((Object)req, new Class[]{Add.class});
        List comRoleList = req.getComRoleList();
        for (int i = 0; i < comRoleList.size(); ++i) {
            ComRole comRole = (ComRole)comRoleList.get(i);
            String id = comRole.getId();
            if (!StringUtils.isNotEmpty((String)id)) continue;
            throw new RuntimeException("comRoleList[" + i + "]." + ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u65b0\u589e\u89d2\u8272\u3002", (String)"ComRoleService_0", (String)SYSTERM_TYPE, (Object[])new Object[0]) + ";");
        }
        return this.addOrUpdateComRole(req);
    }

    private Map<String, Object> addOrUpdateComRoleWrapDBParam(ComRole comRole, Map<String, Object> paraMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(32);
        DynamicObject roleDyn = ComRoleService.wrapPermRoleDyn(comRole);
        resultMap.put("roleDyn", roleDyn);
        String roleId = roleDyn.getString("id");
        Set changeRangeSet = comRole.getChangeRangeSet();
        if (changeRangeSet.contains(ComRoleContentEnum.FUNC.getType())) {
            Map funcPermSetDBMap = (Map)paraMap.get("funcPermSetDBMap");
            Set funcPerms = comRole.getFuncPermSet();
            Set funcPermSet = null == funcPerms || funcPerms.isEmpty() ? new HashSet(1) : funcPerms;
            ArrayList paramFuncPermList = new ArrayList(funcPermSet);
            Set permItems = (Set)funcPermSetDBMap.get(roleId);
            Set DBFuncPermSet = null == permItems || permItems.isEmpty() ? new HashSet(1) : permItems;
            ArrayList DBFuncPermList = new ArrayList(DBFuncPermSet);
            List addFunPermList = ListUtil.removeAll(paramFuncPermList, DBFuncPermList);
            List delFunPermList = ListUtil.removeAll(DBFuncPermList, paramFuncPermList);
            Map rolePermMap = (Map)paraMap.get("rolePermMap");
            Map<String, Object> map = ComRoleService.getFunPermDBOperParamMap(roleId, addFunPermList, delFunPermList, null, rolePermMap);
            for (Map.Entry<String, Object> funPermDBOperParam : map.entrySet()) {
                resultMap.put(funPermDBOperParam.getKey(), funPermDBOperParam.getValue());
            }
            resultMap.put("addFunPermList", addFunPermList);
            resultMap.put("delFunPermList", delFunPermList);
        }
        if (changeRangeSet.contains(ComRoleContentEnum.FIELD.getType())) {
            Map fieldPermSetDBMap = (Map)paraMap.get("fieldPermSetDBMap");
            Set fieldPermSet = null == comRole.getFieldPermSet() || comRole.getFieldPermSet().isEmpty() ? new HashSet(1) : comRole.getFieldPermSet();
            List<Object> paramFieldPermList = new ArrayList(fieldPermSet);
            HashSet DBFieldPermSet = null == fieldPermSetDBMap.get(roleId) || ((Set)fieldPermSetDBMap.get(roleId)).isEmpty() ? new HashSet(1) : (Set)fieldPermSetDBMap.get(roleId);
            List<Object> DBFieldPermList = new ArrayList(DBFieldPermSet);
            paramFieldPermList = paramFieldPermList.stream().filter(x -> !x.getControlMode().equals("0")).collect(Collectors.toList());
            DBFieldPermList = DBFieldPermList.stream().filter(x -> !x.getControlMode().equals("0")).collect(Collectors.toList());
            List addFieldPermList = ListUtil.removeAll(paramFieldPermList, DBFieldPermList);
            List delFieldPermList = ListUtil.removeAll(DBFieldPermList, paramFieldPermList);
            Map roleFieldPermMap = (Map)paraMap.get("roleFieldPermMap");
            Map<String, Object> fieldPermDBOperParamMap = ComRoleService.getFieldPermDBOperParamMap(roleId, addFieldPermList, delFieldPermList, roleFieldPermMap);
            for (Map.Entry entry : fieldPermDBOperParamMap.entrySet()) {
                resultMap.put((String)entry.getKey(), entry.getValue());
            }
            resultMap.put("addFieldPermList", addFieldPermList);
            resultMap.put("delFieldPermList", delFieldPermList);
        }
        if (changeRangeSet.contains(ComRoleContentEnum.NEWDR.getType())) {
            boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
            Map newDrPermSetDBMap = (Map)paraMap.get("newDrPermSetDBMap");
            Set newDrPermSet = null == comRole.getNewDrPermSet() || comRole.getNewDrPermSet().isEmpty() ? new HashSet(1) : comRole.getNewDrPermSet();
            ArrayList paramNewDrPermList = new ArrayList(newDrPermSet);
            HashSet DBNewDrPermSet = null == newDrPermSetDBMap.get(roleId) || ((Set)newDrPermSetDBMap.get(roleId)).isEmpty() ? new HashSet(1) : (Set)newDrPermSetDBMap.get(roleId);
            ArrayList DBNewDrPermList = new ArrayList(DBNewDrPermSet);
            List addNewDrPermList = ListUtil.removeAll(paramNewDrPermList, DBNewDrPermList);
            List delNewDrPermList = ListUtil.removeAll(DBNewDrPermList, paramNewDrPermList);
            Map roleDrMap = (Map)paraMap.get("roleDrMap");
            Map<String, Object> newDrDBOperParamMap = this.getNewDrDBOperParamMap(roleId, addNewDrPermList, delNewDrPermList, roleDrMap);
            resultMap.put("addNewDrPermList", addNewDrPermList);
            resultMap.put("delNewDrPermList", delNewDrPermList);
            long l = RequestContext.get().getCurrUserId();
            Date now = new Date();
            if (hasEnableRoleDataRuleNewModel) {
                String permItemId;
                String entNum;
                String appId;
                ArrayList<Object[]> t_perm_roledatarule_insertParamList = new ArrayList<Object[]>(8);
                for (Object newDrPerm : addNewDrPermList) {
                    Long pkId = DB.genLongId((String)"t_perm_roledatarule");
                    appId = newDrPerm.getAppId();
                    entNum = newDrPerm.getEntityNumber();
                    permItemId = newDrPerm.getPermItemId();
                    Long dataRuleId = newDrPerm.getDataRuleId();
                    t_perm_roledatarule_insertParamList.add(new Object[]{pkId, roleId, appId, entNum, permItemId, dataRuleId, l, now});
                }
                resultMap.put("t_perm_roledatarule_insertParamList", t_perm_roledatarule_insertParamList);
                ArrayList<Object[]> t_perm_roledatarule_delParamList = new ArrayList<Object[]>(8);
                for (NewDrPerm delDrPerm : delNewDrPermList) {
                    appId = delDrPerm.getAppId();
                    entNum = delDrPerm.getEntityNumber();
                    permItemId = delDrPerm.getPermItemId();
                    t_perm_roledatarule_delParamList.add(new Object[]{roleId, appId, entNum, permItemId});
                }
                resultMap.put("t_perm_roledatarule_delParamList", t_perm_roledatarule_delParamList);
            }
            Map newDrPrPermSetDBMap = null == paraMap.get("newDrPrPermSetDBMap") ? new HashMap(0) : (Map)paraMap.get("newDrPrPermSetDBMap");
            Set newDrPrPermSet = null == comRole.getNewDrPrPermSet() || comRole.getNewDrPrPermSet().isEmpty() ? new HashSet(1) : comRole.getNewDrPrPermSet();
            ArrayList paramNewDrPrPermList = new ArrayList(newDrPrPermSet);
            HashSet DBNewDrPrPermSet = null == newDrPrPermSetDBMap.get(roleId) || ((Set)newDrPrPermSetDBMap.get(roleId)).isEmpty() ? new HashSet(1) : (Set)newDrPrPermSetDBMap.get(roleId);
            ArrayList DBNewDrPrPermList = new ArrayList(DBNewDrPrPermSet);
            List addNewDrPrPermList = ListUtil.removeAll(paramNewDrPrPermList, DBNewDrPrPermList);
            List delNewDrPrPermList = ListUtil.removeAll(DBNewDrPrPermList, paramNewDrPrPermList);
            Map<Object, Object> roleDrPrMap = null == paraMap.get("roleDrPrMap") ? new HashMap(0) : (Map)paraMap.get("roleDrPrMap");
            Map<String, Object> newDrPrDBOperParamMap = this.getNewDrPrDBOperParamMap(roleId, addNewDrPrPermList, delNewDrPrPermList, roleDrPrMap);
            if (hasEnableRoleDataRuleNewModel) {
                String propKey;
                String entNum;
                String appId;
                ArrayList<Object[]> t_perm_roledatarule_prop_insertParamList = new ArrayList<Object[]>(8);
                for (NewDrPrPerm newDrPrPerm : addNewDrPrPermList) {
                    Long pkId = DB.genLongId((String)"t_perm_roledatarule_prop");
                    appId = newDrPrPerm.getAppId();
                    entNum = newDrPrPerm.getEntityNumber();
                    propKey = newDrPrPerm.getPropKey();
                    String propEntNum = newDrPrPerm.getPropEntNum();
                    Long dataRuleId = newDrPrPerm.getDataRuleId();
                    t_perm_roledatarule_prop_insertParamList.add(new Object[]{pkId, roleId, appId, entNum, propKey, propEntNum, dataRuleId, l, now});
                }
                resultMap.put("t_perm_roledatarule_prop_insertParamList", t_perm_roledatarule_prop_insertParamList);
                ArrayList<Object[]> t_perm_roledatarule_prop_delParamList = new ArrayList<Object[]>(8);
                for (NewDrPrPerm delDrPrPerm : delNewDrPrPermList) {
                    appId = delDrPrPerm.getAppId();
                    entNum = delDrPrPerm.getEntityNumber();
                    propKey = delDrPrPerm.getPropKey();
                    t_perm_roledatarule_prop_delParamList.add(new Object[]{roleId, appId, entNum, propKey});
                }
                resultMap.put("t_perm_roledatarule_prop_delParamList", t_perm_roledatarule_prop_delParamList);
            } else {
                roleDrPrMap = this.avoidRepeatCreate(newDrDBOperParamMap, roleDrPrMap);
                this.collectDrDBParam(newDrDBOperParamMap, newDrPrDBOperParamMap, resultMap);
            }
            resultMap.put("addNewDrPrPermList", addNewDrPrPermList);
            resultMap.put("delNewDrPrPermList", delNewDrPrPermList);
        }
        if (changeRangeSet.contains(ComRoleContentEnum.ADMINGROUP.getType())) {
            Map comRoleAdminGrpSetDBMap = (Map)paraMap.get("comRoleAdminGrpSetDBMap");
            Set comRoleAdminGrpSet = null == comRole.getComRoleAdminGrpSet() || comRole.getComRoleAdminGrpSet().isEmpty() ? new HashSet(1) : comRole.getComRoleAdminGrpSet();
            ArrayList paramComRoleAdminGrpList = new ArrayList(comRoleAdminGrpSet);
            HashSet DBcomRoleAdminGrpSet = null == comRoleAdminGrpSetDBMap.get(roleId) || ((Set)comRoleAdminGrpSetDBMap.get(roleId)).isEmpty() ? new HashSet(1) : (Set)comRoleAdminGrpSetDBMap.get(roleId);
            ArrayList DBComRoleAdminGrpList = new ArrayList(DBcomRoleAdminGrpSet);
            List addComRoleAdminGrpList = ListUtil.removeAll(paramComRoleAdminGrpList, DBComRoleAdminGrpList);
            List delComRoleAdminGrpList = ListUtil.removeAll(DBComRoleAdminGrpList, paramComRoleAdminGrpList);
            Map adminGrpMap = (Map)paraMap.get("adminGrpMap");
            Map<String, Object> adminGrpParamMap = this.getAdminGrpDBOperParamMap(roleId, addComRoleAdminGrpList, delComRoleAdminGrpList, adminGrpMap);
            for (Map.Entry<String, Object> entry : adminGrpParamMap.entrySet()) {
                resultMap.put(entry.getKey(), entry.getValue());
            }
            resultMap.put("addComRoleAdminGrpList", addComRoleAdminGrpList);
            resultMap.put("delComRoleAdminGrpList", delComRoleAdminGrpList);
        }
        return resultMap;
    }

    @Deprecated
    private void collectDrDBParam(Map<String, Object> newDrDBOperParamMap, Map<String, Object> newDrPrDBOperParamMap, Map<String, Object> resultMap) {
        for (Map.Entry<String, Object> newDrDBOperParam : newDrDBOperParamMap.entrySet()) {
            String key1 = newDrDBOperParam.getKey();
            Object value1 = newDrDBOperParam.getValue();
            for (Map.Entry<String, Object> newDrPrDBOperParam : newDrPrDBOperParamMap.entrySet()) {
                List value2List;
                List value1List;
                String key2 = newDrPrDBOperParam.getKey();
                Object value2 = newDrPrDBOperParam.getValue();
                if ("t_perm_datarule_insertParamList".equals(key1) && key1.equals(key2)) {
                    value1List = (List)value1;
                    value2List = (List)value2;
                    value1List.addAll(value2List);
                    resultMap.put("t_perm_datarule_insertParamList", value1List);
                    continue;
                }
                if ("t_perm_dataruleL_insertParamList".equals(key1) && key1.equals(key2)) {
                    value1List = (List)value1;
                    value2List = (List)value2;
                    value1List.addAll(value2List);
                    resultMap.put("t_perm_dataruleL_insertParamList", value1List);
                    continue;
                }
                if ("t_perm_datarules_insertParamList".equals(key1) && key1.equals(key2)) {
                    value1List = (List)value1;
                    value2List = (List)value2;
                    value1List.addAll(value2List);
                    resultMap.put("t_perm_datarules_insertParamList", value1List);
                    continue;
                }
                if ("t_perm_datarulesL_insertParamList".equals(key1) && key1.equals(key2)) {
                    value1List = (List)value1;
                    value2List = (List)value2;
                    value1List.addAll(value2List);
                    resultMap.put("t_perm_datarulesL_insertParamList", value1List);
                    continue;
                }
                if ("t_perm_datarules_entry_insertParamList".equals(key1) && key1.equals(key2)) {
                    value1List = (List)value1;
                    value2List = (List)value2;
                    value1List.addAll(value2List);
                    resultMap.put("t_perm_datarules_entry_insertParamList", value1List);
                    continue;
                }
                if ("t_perm_roledatarules_insertParamList".equals(key1) && key1.equals(key2)) {
                    value1List = (List)value1;
                    value2List = (List)value2;
                    value1List.addAll(value2List);
                    resultMap.put("t_perm_roledatarules_insertParamList", value1List);
                    continue;
                }
                if ("newDrChangeAppIdEntNumSet".equals(key1) && key1.equals(key2)) {
                    Set value1Set = (Set)value1;
                    Set value2Set = (Set)value2;
                    value1Set.addAll(value2Set);
                    resultMap.put("newDrChangeAppIdEntNumSet", value1Set);
                    continue;
                }
                if ("t_perm_datarule_prop_insertParamList".equals(key2)) {
                    resultMap.put("t_perm_datarule_prop_insertParamList", value2);
                    continue;
                }
                if (!"t_perm_datarule_prop_delEntryIdSet".equals(key2)) continue;
                resultMap.put("t_perm_datarule_prop_delEntryIdSet", value2);
            }
            if ("t_perm_datarule_entry_insertParamList".equals(key1)) {
                resultMap.put("t_perm_datarule_entry_insertParamList", value1);
                continue;
            }
            if (!"t_perm_datarule_entry_delEntryIdSet".equals(key1)) continue;
            resultMap.put("t_perm_datarule_entry_delEntryIdSet", value1);
        }
    }

    private Map<String, Object> getAdminGrpDBOperParamMap(String roleId, List<ComRoleAdminGrp> addComRoleAdminGrpList, List<ComRoleAdminGrp> delComRoleAdminGrpList, Map<String, Object> adminGrpMap) {
        String modifiable;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        ArrayList<Object[]> t_perm_admingrouprole_insertParamList = new ArrayList<Object[]>(8);
        HashSet t_perm_admingrouprole_delFIdSet = new HashSet(8);
        resultMap.put("t_perm_admingrouprole_insertParamList", t_perm_admingrouprole_insertParamList);
        resultMap.put("t_perm_admingrouprole_delFIdSet", t_perm_admingrouprole_delFIdSet);
        if (null != addComRoleAdminGrpList && !addComRoleAdminGrpList.isEmpty()) {
            long[] newFids = DB.genLongIds((String)"t_perm_admingrouprole", (int)addComRoleAdminGrpList.size());
            for (int i = 0; i < addComRoleAdminGrpList.size(); ++i) {
                ComRoleAdminGrp adminGrp = addComRoleAdminGrpList.get(i);
                modifiable = adminGrp.isModifiable() ? "1" : "0";
                t_perm_admingrouprole_insertParamList.add(new Object[]{newFids[i], Long.valueOf(adminGrp.getAdminGroupId()), roleId, modifiable});
            }
        }
        if (null != delComRoleAdminGrpList && !delComRoleAdminGrpList.isEmpty()) {
            for (ComRoleAdminGrp adminGrp : delComRoleAdminGrpList) {
                Map roleAdminGrpFidMap = null == adminGrpMap.get("roleAdminGrpFidMap") ? new HashMap(0) : (Map)adminGrpMap.get("roleAdminGrpFidMap");
                String string = modifiable = adminGrp.isModifiable() ? "1" : "0";
                Set fidSet = (Set)roleAdminGrpFidMap.get(adminGrp.getRoleId() + "|" + adminGrp.getAdminGroupId() + "|" + modifiable);
                if (null == fidSet || fidSet.isEmpty()) continue;
                t_perm_admingrouprole_delFIdSet.addAll(fidSet);
            }
        }
        return resultMap;
    }

    @Deprecated
    private Map<String, Object> avoidRepeatCreate(Map<String, Object> newDrDBOperParamMap, Map<String, Object> roleDrPrMap) {
        Map dataRule0FidMap = null == newDrDBOperParamMap.get("dataRule0FidMap") ? new HashMap(0) : (Map)newDrDBOperParamMap.get("dataRule0FidMap");
        Map dataRuleL0FpkidMap = null == newDrDBOperParamMap.get("dataRuleL0FpkidMap") ? new HashMap(0) : (Map)newDrDBOperParamMap.get("dataRuleL0FpkidMap");
        Map dataRulesFidMap = null == newDrDBOperParamMap.get("dataRulesFidMap") ? new HashMap(0) : (Map)newDrDBOperParamMap.get("dataRulesFidMap");
        Map dataRulesLPkidMap = null == newDrDBOperParamMap.get("dataRulesLPkidMap") ? new HashMap(0) : (Map)newDrDBOperParamMap.get("dataRulesLPkidMap");
        Map dataRulesEntryEntryidMap = null == newDrDBOperParamMap.get("dataRulesEntryEntryidMap") ? new HashMap(0) : (Map)newDrDBOperParamMap.get("dataRulesEntryEntryidMap");
        Map roleDataRulesFidMap = null == newDrDBOperParamMap.get("roleDataRulesFidMap") ? new HashMap(0) : (Map)newDrDBOperParamMap.get("roleDataRulesFidMap");
        Map dataRule0FidMap2 = null == newDrDBOperParamMap.get("dataRule0FidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRule0FidMap");
        Map dataRuleL0FpkidMap2 = null == newDrDBOperParamMap.get("dataRuleL0FpkidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRuleL0FpkidMap");
        Map dataRulesFidMap2 = null == newDrDBOperParamMap.get("dataRulesFidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRulesFidMap");
        Map dataRulesLPkidMap2 = null == newDrDBOperParamMap.get("dataRulesLPkidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRulesLPkidMap");
        Map dataRulesEntryEntryidMap2 = null == newDrDBOperParamMap.get("dataRulesEntryEntryidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRulesEntryEntryidMap");
        Map roleDataRulesFidMap2 = null == newDrDBOperParamMap.get("roleDataRulesFidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("roleDataRulesFidMap");
        Map dataRulePropFentryIdMap = null == newDrDBOperParamMap.get("dataRulePropFentryIdMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRulePropFentryIdMap");
        newDrDBOperParamMap.put("dataRulePropFentryIdMap", dataRulePropFentryIdMap);
        for (Map.Entry dataRule0Fid : dataRule0FidMap.entrySet()) {
            for (Map.Entry dataRule0Fid2 : dataRule0FidMap2.entrySet()) {
                if (!((String)dataRule0Fid.getKey()).equals(dataRule0Fid2.getKey())) continue;
                ((Set)dataRule0Fid.getValue()).addAll((Collection)dataRule0Fid2.getValue());
                dataRule0FidMap.put(dataRule0Fid.getKey(), dataRule0Fid.getValue());
            }
        }
        for (Map.Entry dataRuleL0Fpkid : dataRuleL0FpkidMap.entrySet()) {
            for (Map.Entry dataRuleL0Fpkid2 : dataRuleL0FpkidMap2.entrySet()) {
                if (!((String)dataRuleL0Fpkid.getKey()).equals(dataRuleL0Fpkid2.getKey())) continue;
                ((Set)dataRuleL0Fpkid.getValue()).addAll((Collection)dataRuleL0Fpkid2.getValue());
                dataRuleL0FpkidMap.put(dataRuleL0Fpkid.getKey(), dataRuleL0Fpkid2.getValue());
            }
        }
        for (Map.Entry dataRulesFid : dataRulesFidMap.entrySet()) {
            for (Map.Entry dataRulesFid2 : dataRulesFidMap2.entrySet()) {
                if (!((String)dataRulesFid.getKey()).equals(dataRulesFid2.getKey())) continue;
                ((Set)dataRulesFid.getValue()).addAll((Collection)dataRulesFid2.getValue());
                dataRulesFidMap.put(dataRulesFid.getKey(), dataRulesFid2.getValue());
            }
        }
        for (Map.Entry dataRulesLPkid : dataRulesLPkidMap.entrySet()) {
            for (Map.Entry dataRulesLPkid2 : dataRulesLPkidMap2.entrySet()) {
                if (!((String)dataRulesLPkid.getKey()).equals(dataRulesLPkid2.getKey())) continue;
                ((Set)dataRulesLPkid.getValue()).addAll((Collection)dataRulesLPkid2.getValue());
                dataRulesLPkidMap.put(dataRulesLPkid.getKey(), dataRulesLPkid2.getValue());
            }
        }
        for (Map.Entry dataRulesEntryEntryid : dataRulesEntryEntryidMap.entrySet()) {
            for (Map.Entry dataRulesEntryEntryid2 : dataRulesEntryEntryidMap2.entrySet()) {
                if (!((String)dataRulesEntryEntryid.getKey()).equals(dataRulesEntryEntryid2.getKey())) continue;
                ((Set)dataRulesEntryEntryid.getValue()).addAll((Collection)dataRulesEntryEntryid2.getValue());
                dataRulesEntryEntryidMap.put(dataRulesEntryEntryid.getKey(), dataRulesEntryEntryid2.getValue());
            }
        }
        for (Map.Entry roleDataRulesFid : roleDataRulesFidMap.entrySet()) {
            for (Map.Entry roleDataRulesFid2 : roleDataRulesFidMap2.entrySet()) {
                if (!((String)roleDataRulesFid.getKey()).equals(roleDataRulesFid2.getKey())) continue;
                ((Set)roleDataRulesFid.getValue()).addAll((Collection)roleDataRulesFid2.getValue());
                roleDataRulesFidMap.put(roleDataRulesFid.getKey(), roleDataRulesFid2.getValue());
            }
        }
        newDrDBOperParamMap.put("dataRule0FidMap", dataRule0FidMap);
        newDrDBOperParamMap.put("dataRuleL0FpkidMap", dataRuleL0FpkidMap);
        newDrDBOperParamMap.put("dataRulesFidMap", dataRulesFidMap);
        newDrDBOperParamMap.put("dataRulesLPkidMap", dataRulesLPkidMap);
        newDrDBOperParamMap.put("dataRulesEntryEntryidMap", dataRulesEntryEntryidMap);
        newDrDBOperParamMap.put("roleDataRulesFidMap", roleDataRulesFidMap);
        return newDrDBOperParamMap;
    }

    private Map<String, Object> getNewDrPrDBOperParamMap(String roleId, List<NewDrPrPerm> addNewDrPrPermList, List<NewDrPrPerm> delNewDrPrPermList, Map<String, Object> roleDrPrMap) {
        HashMap<String, Object> resultMap;
        block21: {
            HashMap roleDataRulesFidMap;
            Date curTime;
            long currUserId;
            block20: {
                String entityNumber;
                String appId;
                resultMap = new HashMap<String, Object>(8);
                currUserId = RequestContext.get().getCurrUserId();
                curTime = new Date();
                boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
                if (!hasEnableRoleDataRuleNewModel) break block20;
                String langStr = RequestContext.get().getLang().name();
                HashSet<String> newDrChangeAppIdEntNumSet = new HashSet<String>(8);
                resultMap.put("newDrChangeAppIdEntNumSet", newDrChangeAppIdEntNumSet);
                if (null != addNewDrPrPermList && !addNewDrPrPermList.isEmpty()) {
                    for (NewDrPrPerm newDrPrPerm : addNewDrPrPermList) {
                        appId = newDrPrPerm.getAppId();
                        entityNumber = newDrPrPerm.getEntityNumber();
                        newDrChangeAppIdEntNumSet.add(appId + "|" + entityNumber);
                    }
                }
                if (null == delNewDrPrPermList || delNewDrPrPermList.isEmpty()) break block21;
                for (NewDrPrPerm newDrPrPerm : delNewDrPrPermList) {
                    appId = newDrPrPerm.getAppId();
                    entityNumber = newDrPrPerm.getEntityNumber();
                    newDrChangeAppIdEntNumSet.add(appId + "|" + entityNumber);
                }
                break block21;
            }
            String langStr = RequestContext.get().getLang().name();
            ArrayList<Object[]> t_perm_datarule_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_datarule_insertParamList", t_perm_datarule_insertParamList);
            ArrayList<Object[]> t_perm_dataruleL_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_dataruleL_insertParamList", t_perm_dataruleL_insertParamList);
            ArrayList<Object[]> t_perm_datarule_prop_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_datarule_prop_insertParamList", t_perm_datarule_prop_insertParamList);
            ArrayList<Object[]> t_perm_datarules_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_datarules_insertParamList", t_perm_datarules_insertParamList);
            ArrayList<Object[]> t_perm_datarulesL_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_datarulesL_insertParamList", t_perm_datarulesL_insertParamList);
            ArrayList<Object[]> t_perm_datarules_entry_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_datarules_entry_insertParamList", t_perm_datarules_entry_insertParamList);
            ArrayList<Object[]> t_perm_roledatarules_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_roledatarules_insertParamList", t_perm_roledatarules_insertParamList);
            HashSet t_perm_datarule_prop_delEntryIdSet = new HashSet(8);
            resultMap.put("t_perm_datarule_prop_delEntryIdSet", t_perm_datarule_prop_delEntryIdSet);
            HashSet<String> newDrChangeAppIdEntNumSet = new HashSet<String>(8);
            resultMap.put("newDrChangeAppIdEntNumSet", newDrChangeAppIdEntNumSet);
            HashMap dataRule0FidMap = null == roleDrPrMap || null == roleDrPrMap.get("dataRule0FidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRule0FidMap");
            HashMap dataRuleL0FpkidMap = null == roleDrPrMap || null == roleDrPrMap.get("dataRuleL0FpkidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRuleL0FpkidMap");
            HashMap dataRulePropFentryIdMap = null == roleDrPrMap || null == roleDrPrMap.get("dataRulePropFentryIdMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRulePropFentryIdMap");
            HashMap dataRulesFidMap = null == roleDrPrMap || null == roleDrPrMap.get("dataRulesFidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRulesFidMap");
            HashMap dataRulesLPkidMap = null == roleDrPrMap || null == roleDrPrMap.get("dataRulesLPkidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRulesLPkidMap");
            HashMap dataRulesEntryEntryidMap = null == roleDrPrMap || null == roleDrPrMap.get("dataRulesEntryEntryidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("dataRulesEntryEntryidMap");
            Map<String, HashSet<Object>> map = roleDataRulesFidMap = null == roleDrPrMap || null == roleDrPrMap.get("roleDataRulesFidMap") ? new HashMap(0) : (Map)roleDrPrMap.get("roleDataRulesFidMap");
            if (null != addNewDrPrPermList && !addNewDrPrPermList.isEmpty()) {
                HashSet<String> roleDataRulesFidSet;
                HashSet<String> dataRulesFidSet;
                HashMap<String, Set> roleAppEntDataRuleIdMap = new HashMap<String, Set>(8);
                for (NewDrPrPerm newDrPrPerm : addNewDrPrPermList) {
                    HashSet<String> dataRule0FidSet;
                    String appId = newDrPrPerm.getAppId();
                    String string = newDrPrPerm.getEntityNumber();
                    newDrChangeAppIdEntNumSet.add(appId + "|" + string);
                    String propKey = newDrPrPerm.getPropKey();
                    String propEntNum = newDrPrPerm.getPropEntNum();
                    Long dataRuleId = newDrPrPerm.getDataRuleId();
                    String roleAppEntKey = roleId + "|" + appId + "|" + string;
                    Set<String> set = dataRule0FidSet = null == dataRule0FidMap || null == dataRule0FidMap.get(roleAppEntKey) ? new HashSet<String>(0) : (Set)dataRule0FidMap.get(roleAppEntKey);
                    if (dataRule0FidSet.isEmpty()) {
                        HashSet<String> dataRuleL0FpkidSet;
                        long t_perm_datarule_fid = ComRoleService.genLongIdByTable("t_perm_datarule");
                        String fnumber = string + "@" + appId + "_" + roleId + "_" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                        t_perm_datarule_insertParamList.add(new Object[]{t_perm_datarule_fid, 0L, fnumber, appId, string, Character.valueOf(' '), Character.valueOf('0'), curTime, currUserId, curTime, currUserId, Character.valueOf('C'), Character.valueOf('1'), Character.valueOf(' '), null, fnumber, Character.valueOf(' '), Character.valueOf(' ')});
                        roleAppEntDataRuleIdMap.computeIfAbsent(roleId, k -> new HashSet()).add(appId + "|" + string + "|" + t_perm_datarule_fid);
                        dataRule0FidSet.add(String.valueOf(t_perm_datarule_fid));
                        dataRule0FidMap.put(roleAppEntKey, dataRule0FidSet);
                        Set<String> set2 = dataRuleL0FpkidSet = null == dataRuleL0FpkidMap || null == dataRuleL0FpkidMap.get(roleAppEntKey + "|" + langStr) ? new HashSet<String>(0) : (Set)dataRuleL0FpkidMap.get(roleAppEntKey + "|" + langStr);
                        if (dataRuleL0FpkidSet.isEmpty()) {
                            String t_perm_datarule_l_pkid = ComRoleService.genStringIdByTable("t_perm_datarule_l");
                            t_perm_dataruleL_insertParamList.add(new Object[]{t_perm_datarule_fid, langStr, fnumber, Character.valueOf(' '), t_perm_datarule_l_pkid});
                            dataRuleL0FpkidSet.add(t_perm_datarule_l_pkid);
                            dataRuleL0FpkidMap.put(roleAppEntKey + "|" + langStr, dataRuleL0FpkidSet);
                        }
                        if (dataRuleL0FpkidSet.size() > 1) {
                            throw new RuntimeException("a role has more than one t_perm_datarule0L record.");
                        }
                    }
                    if (dataRule0FidSet.size() > 1) {
                        throw new RuntimeException("a role has more than one t_perm_datarule0 record.");
                    }
                    String t_perm_datarule_fid = (String)dataRule0FidSet.stream().findFirst().get();
                    String kk = roleAppEntKey + "|" + propKey + "|" + propEntNum + "|" + dataRuleId;
                    Set<String> dataRulePropFentryIdSet = null == dataRulePropFentryIdMap || null == dataRulePropFentryIdMap.get(kk) ? new HashSet<String>(0) : (Set)dataRulePropFentryIdMap.get(kk);
                    if (!dataRulePropFentryIdSet.isEmpty()) continue;
                    Long t_perm_datarule_prop_fentryId = ComRoleService.genLongIdByTable("t_perm_datarule_prop");
                    t_perm_datarule_prop_insertParamList.add(new Object[]{Long.valueOf(t_perm_datarule_fid), t_perm_datarule_prop_fentryId, propKey, dataRuleId, propEntNum, 0L});
                    dataRulePropFentryIdSet.add(String.valueOf(t_perm_datarule_prop_fentryId));
                    dataRulePropFentryIdMap.put(roleAppEntKey + "|" + propKey + "|" + propEntNum + "|" + dataRuleId, dataRulePropFentryIdSet);
                }
                Set<String> set = dataRulesFidSet = null == dataRulesFidMap || null == dataRulesFidMap.get(roleId) ? new HashSet<String>(0) : (Set)dataRulesFidMap.get(roleId);
                if (dataRulesFidSet.isEmpty()) {
                    HashSet<String> dataRulesLPkidSet;
                    String dateStr = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                    String fnumber = roleId + "_" + dateStr;
                    long l = ComRoleService.genLongIdByTable("t_perm_datarules");
                    t_perm_datarules_insertParamList.add(new Object[]{l, 0L, fnumber, Character.valueOf('C'), Character.valueOf('1'), curTime, currUserId, curTime, currUserId, fnumber, 0L});
                    dataRulesFidSet.add(String.valueOf(l));
                    dataRulesFidMap.put(roleId, dataRulesFidSet);
                    String kk = roleId + "|" + langStr;
                    Set<String> set3 = dataRulesLPkidSet = null == dataRulesLPkidMap || null == dataRulesLPkidMap.get(kk) ? new HashSet<String>(0) : (Set)dataRulesLPkidMap.get(kk);
                    if (dataRulesLPkidSet.isEmpty()) {
                        String t_perm_datarules_l_pkid = ComRoleService.genStringIdByTable("t_perm_datarules_l");
                        t_perm_datarulesL_insertParamList.add(new Object[]{l, langStr, fnumber, t_perm_datarules_l_pkid});
                        dataRulesLPkidSet.add(t_perm_datarules_l_pkid);
                        dataRulesLPkidMap.put(roleId + "|" + langStr, dataRulesLPkidSet);
                    }
                    if (dataRulesLPkidSet.size() > 1) {
                        throw new RuntimeException("a role has more than one t_perm_datarulesL record.");
                    }
                }
                if (dataRulesFidSet.size() > 1) {
                    throw new RuntimeException("a role has more than one t_perm_datarules record.");
                }
                String t_perm_datarulesFid = (String)dataRulesFidSet.stream().findFirst().get();
                if (null != roleAppEntDataRuleIdMap && !roleAppEntDataRuleIdMap.isEmpty()) {
                    for (Map.Entry entry : roleAppEntDataRuleIdMap.entrySet()) {
                        String key = (String)entry.getKey();
                        Set value = (Set)entry.getValue();
                        for (String str : value) {
                            String[] split = str.split("\\|");
                            if (null == split || 0 == split.length || 3 != split.length) {
                                throw new RuntimeException("roleId:[" + roleId + "] addNewDrPermList data valid.");
                            }
                            String kk = key + "|" + split;
                            Set<String> dataRulesEntryEntryidSet = null == dataRulesEntryEntryidMap || null == dataRulesEntryEntryidMap.get(kk) ? new HashSet<String>(0) : (Set)dataRulesEntryEntryidMap.get(kk);
                            if (!dataRulesEntryEntryidSet.isEmpty()) continue;
                            long t_perm_datarules_entry_fentryid = ComRoleService.genLongIdByTable("t_perm_datarules_entry");
                            t_perm_datarules_entry_insertParamList.add(new Object[]{t_perm_datarules_entry_fentryid, Long.valueOf(t_perm_datarulesFid), 0L, split[0], split[1], Long.valueOf(split[2])});
                            dataRulesEntryEntryidSet.add(String.valueOf(t_perm_datarules_entry_fentryid));
                            dataRulesEntryEntryidMap.put(key + "|" + split, dataRulesEntryEntryidSet);
                        }
                    }
                }
                Set<String> set4 = roleDataRulesFidSet = null == roleDataRulesFidMap || null == roleDataRulesFidMap.get(roleId) ? new HashSet<String>(0) : (Set)roleDataRulesFidMap.get(roleId);
                if (roleDataRulesFidSet.isEmpty()) {
                    long l = ComRoleService.genLongIdByTable("t_perm_roledatarules");
                    t_perm_roledatarules_insertParamList.add(new Object[]{l, Long.valueOf(t_perm_datarulesFid), roleId, curTime, currUserId, curTime, currUserId});
                    roleDataRulesFidSet.add(String.valueOf(l));
                    roleDataRulesFidMap.put(roleId, roleDataRulesFidSet);
                }
            }
            if (null != delNewDrPrPermList && !delNewDrPrPermList.isEmpty()) {
                for (NewDrPrPerm newDrPrPerm : delNewDrPrPermList) {
                    String appId = newDrPrPerm.getAppId();
                    String entityNumber = newDrPrPerm.getEntityNumber();
                    newDrChangeAppIdEntNumSet.add(appId + "|" + entityNumber);
                    Set set = (Set)dataRulePropFentryIdMap.get(roleId + "|" + appId + "|" + entityNumber + "|" + newDrPrPerm.getPropKey() + "|" + newDrPrPerm.getPropEntNum() + "|" + newDrPrPerm.getDataRuleId());
                    if (null == set || set.isEmpty()) continue;
                    t_perm_datarule_prop_delEntryIdSet.addAll(set);
                }
            }
        }
        return resultMap;
    }

    private static String genStringIdByTable(String tableName) {
        return DB.genStringId((String)tableName);
    }

    private static long genLongIdByTable(String tableName) {
        return DB.genLongId((String)tableName);
    }

    private Map<String, Object> getNewDrDBOperParamMap(String roleId, List<NewDrPerm> addNewDrPermList, List<NewDrPerm> delNewDrPermList, Map<String, Object> roleDrMap) {
        HashMap<String, Object> resultMap;
        block21: {
            HashSet<String> newDrChangeAppIdEntNumSet;
            Date curTime;
            long currUserId;
            block20: {
                String entityNumber;
                String appId;
                resultMap = new HashMap<String, Object>(16);
                currUserId = RequestContext.get().getCurrUserId();
                curTime = new Date();
                newDrChangeAppIdEntNumSet = new HashSet<String>(8);
                resultMap.put("newDrChangeAppIdEntNumSet", newDrChangeAppIdEntNumSet);
                boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
                if (!hasEnableRoleDataRuleNewModel) break block20;
                if (null != addNewDrPermList && !addNewDrPermList.isEmpty()) {
                    for (NewDrPerm newDrPerm : addNewDrPermList) {
                        appId = newDrPerm.getAppId();
                        entityNumber = newDrPerm.getEntityNumber();
                        newDrChangeAppIdEntNumSet.add(appId + "|" + entityNumber);
                    }
                }
                if (null == delNewDrPermList || delNewDrPermList.isEmpty()) break block21;
                for (NewDrPerm newDrPerm : delNewDrPermList) {
                    appId = newDrPerm.getAppId();
                    entityNumber = newDrPerm.getEntityNumber();
                    newDrChangeAppIdEntNumSet.add(appId + "|" + entityNumber);
                }
                break block21;
            }
            String langStr = RequestContext.get().getLang().name();
            ArrayList<Object[]> t_perm_datarule_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_datarule_insertParamList", t_perm_datarule_insertParamList);
            ArrayList<Object[]> t_perm_dataruleL_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_dataruleL_insertParamList", t_perm_dataruleL_insertParamList);
            ArrayList<Object[]> t_perm_datarule_entry_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_datarule_entry_insertParamList", t_perm_datarule_entry_insertParamList);
            ArrayList<Object[]> t_perm_datarules_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_datarules_insertParamList", t_perm_datarules_insertParamList);
            ArrayList<Object[]> t_perm_datarulesL_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_datarulesL_insertParamList", t_perm_datarulesL_insertParamList);
            ArrayList<Object[]> t_perm_datarules_entry_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_datarules_entry_insertParamList", t_perm_datarules_entry_insertParamList);
            ArrayList<Object[]> t_perm_roledatarules_insertParamList = new ArrayList<Object[]>(8);
            resultMap.put("t_perm_roledatarules_insertParamList", t_perm_roledatarules_insertParamList);
            HashSet t_perm_datarule_entry_delEntryIdSet = new HashSet(8);
            resultMap.put("t_perm_datarule_entry_delEntryIdSet", t_perm_datarule_entry_delEntryIdSet);
            HashMap dataRule0FidMap = null == roleDrMap || null == roleDrMap.get("dataRule0FidMap") ? new HashMap(0) : (Map)roleDrMap.get("dataRule0FidMap");
            HashMap dataRuleL0FpkidMap = null == roleDrMap || null == roleDrMap.get("dataRuleL0FpkidMap") ? new HashMap(0) : (Map)roleDrMap.get("dataRuleL0FpkidMap");
            HashMap dataRuleEntryFentryIdMap = null == roleDrMap || null == roleDrMap.get("dataRuleEntryFentryIdMap") ? new HashMap(0) : (Map)roleDrMap.get("dataRuleEntryFentryIdMap");
            HashMap dataRulesFidMap = null == roleDrMap || null == roleDrMap.get("dataRulesFidMap") ? new HashMap(0) : (Map)roleDrMap.get("dataRulesFidMap");
            HashMap dataRulesLPkidMap = null == roleDrMap || null == roleDrMap.get("dataRulesLPkidMap") ? new HashMap(0) : (Map)roleDrMap.get("dataRulesLPkidMap");
            HashMap dataRulesEntryEntryidMap = null == roleDrMap || null == roleDrMap.get("dataRulesEntryEntryidMap") ? new HashMap(0) : (Map)roleDrMap.get("dataRulesEntryEntryidMap");
            HashMap roleDataRulesFidMap = null == roleDrMap || null == roleDrMap.get("roleDataRulesFidMap") ? new HashMap(0) : (Map)roleDrMap.get("roleDataRulesFidMap");
            resultMap.put("dataRule0FidMap", dataRule0FidMap);
            resultMap.put("dataRuleL0FpkidMap", dataRuleL0FpkidMap);
            resultMap.put("dataRulesFidMap", dataRulesFidMap);
            resultMap.put("dataRulesLPkidMap", dataRulesLPkidMap);
            resultMap.put("dataRulesEntryEntryidMap", dataRulesEntryEntryidMap);
            resultMap.put("roleDataRulesFidMap", roleDataRulesFidMap);
            if (null != addNewDrPermList && !addNewDrPermList.isEmpty()) {
                HashSet<String> roleDataRulesFidSet;
                HashSet<String> dataRulesFidSet;
                HashMap<String, Set> roleAppEntDataRuleIdMap = new HashMap<String, Set>(8);
                for (NewDrPerm newDrPerm : addNewDrPermList) {
                    HashSet<String> dataRule0FidSet;
                    String appId = newDrPerm.getAppId();
                    String string = newDrPerm.getEntityNumber();
                    newDrChangeAppIdEntNumSet.add(appId + "|" + string);
                    String permItemId = newDrPerm.getPermItemId();
                    Long dataRuleId = newDrPerm.getDataRuleId();
                    String roleAppEntKey = roleId + "|" + appId + "|" + string;
                    Set<String> set = dataRule0FidSet = null == dataRule0FidMap || null == dataRule0FidMap.get(roleAppEntKey) ? new HashSet<String>(0) : (Set)dataRule0FidMap.get(roleAppEntKey);
                    if (dataRule0FidSet.isEmpty()) {
                        HashSet<String> dataRuleL0FpkidSet;
                        long t_perm_datarule_fid = ComRoleService.genLongIdByTable("t_perm_datarule");
                        String fnumber = string + "@" + appId + "_" + roleId + "_" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                        t_perm_datarule_insertParamList.add(new Object[]{t_perm_datarule_fid, 0L, fnumber, appId, string, Character.valueOf(' '), Character.valueOf('0'), curTime, currUserId, curTime, currUserId, Character.valueOf('C'), Character.valueOf('1'), Character.valueOf(' '), null, fnumber, Character.valueOf(' '), Character.valueOf(' ')});
                        roleAppEntDataRuleIdMap.computeIfAbsent(roleId, k -> new HashSet()).add(appId + "|" + string + "|" + t_perm_datarule_fid);
                        dataRule0FidSet.add(String.valueOf(t_perm_datarule_fid));
                        dataRule0FidMap.put(roleAppEntKey, dataRule0FidSet);
                        Set<String> set2 = dataRuleL0FpkidSet = null == dataRuleL0FpkidMap || null == dataRuleL0FpkidMap.get(roleAppEntKey + "|" + langStr) ? new HashSet<String>(0) : (Set)dataRuleL0FpkidMap.get(roleAppEntKey + "|" + langStr);
                        if (dataRuleL0FpkidSet.isEmpty()) {
                            String t_perm_datarule_l_pkid = ComRoleService.genStringIdByTable("t_perm_datarule_l");
                            t_perm_dataruleL_insertParamList.add(new Object[]{t_perm_datarule_fid, langStr, fnumber, Character.valueOf(' '), t_perm_datarule_l_pkid});
                            dataRuleL0FpkidSet.add(t_perm_datarule_l_pkid);
                            dataRuleL0FpkidMap.put(roleAppEntKey + "|" + langStr, dataRuleL0FpkidSet);
                        }
                        if (dataRuleL0FpkidSet.size() > 1) {
                            throw new RuntimeException("a role has more than one t_perm_datarule0L record.");
                        }
                    }
                    if (dataRule0FidSet.size() > 1) {
                        throw new RuntimeException("a role has more than one t_perm_datarule0 record.");
                    }
                    String t_perm_datarule_fid = (String)dataRule0FidSet.stream().findFirst().get();
                    Set<String> dataRuleEntryFentryIdSet = null == dataRuleEntryFentryIdMap || null == dataRuleEntryFentryIdMap.get(roleAppEntKey + "|" + permItemId + "|" + dataRuleId) ? new HashSet<String>(0) : (Set)dataRuleEntryFentryIdMap.get(roleAppEntKey + "|" + permItemId + "|" + dataRuleId);
                    if (!dataRuleEntryFentryIdSet.isEmpty()) continue;
                    Long t_perm_datarule_entry_fentryId = ComRoleService.genLongIdByTable("t_perm_datarule_entry");
                    t_perm_datarule_entry_insertParamList.add(new Object[]{t_perm_datarule_entry_fentryId, Long.valueOf(t_perm_datarule_fid), 0L, permItemId, Character.valueOf(' '), Character.valueOf(' '), dataRuleId});
                    dataRuleEntryFentryIdSet.add(String.valueOf(t_perm_datarule_entry_fentryId));
                    dataRuleEntryFentryIdMap.put(roleAppEntKey + "|" + permItemId + "|" + dataRuleId, dataRuleEntryFentryIdSet);
                }
                Set<String> set = dataRulesFidSet = null == dataRulesFidMap || null == dataRulesFidMap.get(roleId) ? new HashSet<String>(0) : (Set)dataRulesFidMap.get(roleId);
                if (dataRulesFidSet.isEmpty()) {
                    HashSet<String> dataRulesLPkidSet;
                    String dateStr = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                    String fnumber = roleId + "_" + dateStr;
                    long l = ComRoleService.genLongIdByTable("t_perm_datarules");
                    t_perm_datarules_insertParamList.add(new Object[]{l, 0L, fnumber, Character.valueOf('C'), Character.valueOf('1'), curTime, currUserId, curTime, currUserId, fnumber, 0L});
                    dataRulesFidSet.add(String.valueOf(l));
                    dataRulesFidMap.put(roleId, dataRulesFidSet);
                    Set<String> set3 = dataRulesLPkidSet = null == dataRulesLPkidMap || null == dataRulesLPkidMap.get(roleId + "|" + langStr) ? new HashSet<String>(0) : (Set)dataRulesLPkidMap.get(roleId + "|" + langStr);
                    if (dataRulesLPkidSet.isEmpty()) {
                        String t_perm_datarules_l_pkid = ComRoleService.genStringIdByTable("t_perm_datarules_l");
                        t_perm_datarulesL_insertParamList.add(new Object[]{l, langStr, fnumber, t_perm_datarules_l_pkid});
                        dataRulesLPkidSet.add(t_perm_datarules_l_pkid);
                        dataRulesLPkidMap.put(roleId + "|" + langStr, dataRulesLPkidSet);
                    }
                    if (dataRulesLPkidSet.size() > 1) {
                        throw new RuntimeException("a role has more than one t_perm_datarulesL record.");
                    }
                }
                if (dataRulesFidSet.size() > 1) {
                    throw new RuntimeException("a role has more than one t_perm_datarules record.");
                }
                String t_perm_datarulesFid = (String)dataRulesFidSet.stream().findFirst().get();
                if (null != roleAppEntDataRuleIdMap && !roleAppEntDataRuleIdMap.isEmpty()) {
                    for (Map.Entry entry : roleAppEntDataRuleIdMap.entrySet()) {
                        String key = (String)entry.getKey();
                        Set value = (Set)entry.getValue();
                        for (String str : value) {
                            String[] split = str.split("\\|");
                            if (null == split || 0 == split.length || 3 != split.length) {
                                throw new RuntimeException("roleId:[" + roleId + "] addNewDrPermList data valid.");
                            }
                            String kk = key + "|" + split;
                            Set<String> dataRulesEntryEntryidSet = null == dataRulesEntryEntryidMap || null == dataRulesEntryEntryidMap.get(kk) ? new HashSet<String>(0) : (Set)dataRulesEntryEntryidMap.get(kk);
                            if (!dataRulesEntryEntryidSet.isEmpty()) continue;
                            long t_perm_datarules_entry_fentryid = ComRoleService.genLongIdByTable("t_perm_datarules_entry");
                            t_perm_datarules_entry_insertParamList.add(new Object[]{t_perm_datarules_entry_fentryid, Long.valueOf(t_perm_datarulesFid), 0L, split[0], split[1], Long.valueOf(split[2])});
                            dataRulesEntryEntryidSet.add(String.valueOf(t_perm_datarules_entry_fentryid));
                            dataRulesEntryEntryidMap.put(key + "|" + split, dataRulesEntryEntryidSet);
                        }
                    }
                }
                Set<String> set4 = roleDataRulesFidSet = null == roleDataRulesFidMap || null == roleDataRulesFidMap.get(roleId) ? new HashSet<String>(0) : (Set)roleDataRulesFidMap.get(roleId);
                if (roleDataRulesFidSet.isEmpty()) {
                    long l = ComRoleService.genLongIdByTable("t_perm_roledatarules");
                    t_perm_roledatarules_insertParamList.add(new Object[]{l, Long.valueOf(t_perm_datarulesFid), roleId, curTime, currUserId, curTime, currUserId});
                    roleDataRulesFidSet.add(String.valueOf(l));
                    roleDataRulesFidMap.put(roleId, roleDataRulesFidSet);
                }
            }
            if (null != delNewDrPermList && !delNewDrPermList.isEmpty()) {
                for (NewDrPerm newDrPerm : delNewDrPermList) {
                    String appId = newDrPerm.getAppId();
                    String entityNumber = newDrPerm.getEntityNumber();
                    newDrChangeAppIdEntNumSet.add(appId + "|" + entityNumber);
                    Set set = (Set)dataRuleEntryFentryIdMap.get(roleId + "|" + appId + "|" + entityNumber + "|" + newDrPerm.getPermItemId() + "|" + newDrPerm.getDataRuleId());
                    if (null == set || set.isEmpty()) continue;
                    t_perm_datarule_entry_delEntryIdSet.addAll(set);
                }
            }
        }
        return resultMap;
    }

    private static Map<String, Object> getFieldPermDBOperParamMap(String roleId, List<FieldPerm> addFieldPermList, List<FieldPerm> delFieldPermList, Map<String, Object> roleFieldPermMap) {
        HashSet roleFieldPermFidSet;
        HashSet fieldPermFidSet;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        ArrayList<Object[]> t_perm_fieldperm_insertParamList = new ArrayList<Object[]>(8);
        ArrayList<Object[]> t_perm_rolefieldperm_insertParamList = new ArrayList<Object[]>(8);
        ArrayList<Object[]> t_perm_fieldpermdetail_insertParamList = new ArrayList<Object[]>(8);
        resultMap.put("t_perm_fieldperm_insertParamList", t_perm_fieldperm_insertParamList);
        resultMap.put("t_perm_rolefieldperm_insertParamList", t_perm_rolefieldperm_insertParamList);
        resultMap.put("t_perm_fieldpermdetail_insertParamList", t_perm_fieldpermdetail_insertParamList);
        HashSet t_perm_fieldperm_delFIdSet = new HashSet(8);
        HashSet t_perm_rolefieldperm_delFIdSet = new HashSet(8);
        HashSet t_perm_fieldpermdetail_delEntryIdSet = new HashSet(8);
        resultMap.put("t_perm_fieldperm_delFIdSet", t_perm_fieldperm_delFIdSet);
        resultMap.put("t_perm_rolefieldperm_delFIdSet", t_perm_rolefieldperm_delFIdSet);
        resultMap.put("t_perm_fieldpermdetail_delEntryIdSet", t_perm_fieldpermdetail_delEntryIdSet);
        HashMap roleFieldPermFidMap = null == roleFieldPermMap || null == roleFieldPermMap.get("roleFieldPermFidMap") ? new HashMap(0) : (Map)roleFieldPermMap.get("roleFieldPermFidMap");
        HashMap fieldPermFidMap = null == roleFieldPermMap || null == roleFieldPermMap.get("fieldPermFidMap") ? new HashMap(0) : (Map)roleFieldPermMap.get("fieldPermFidMap");
        HashMap<String, Set> roleIdFieldPermDetailEntryIdMap = null == roleFieldPermMap || null == roleFieldPermMap.get("roleIdFieldPermDetailEntryIdMap") ? new HashMap<String, Set>(0) : (Map)roleFieldPermMap.get("roleIdFieldPermDetailEntryIdMap");
        HashMap fieldPermDetailEntryIdMap = null == roleFieldPermMap || null == roleFieldPermMap.get("fieldPermDetailEntryIdMap") ? new HashMap(0) : (Map)roleFieldPermMap.get("fieldPermDetailEntryIdMap");
        String fieldPermId = "";
        Set set = fieldPermFidSet = null == fieldPermFidMap || null == fieldPermFidMap.get(roleId) ? new HashSet(0) : (Set)fieldPermFidMap.get(roleId);
        if (null == fieldPermFidSet || fieldPermFidSet.isEmpty()) {
            fieldPermId = ComRoleService.genStringIdByTable("t_perm_fieldperm");
            t_perm_fieldperm_insertParamList.add(new Object[]{fieldPermId, ComRoleService.genStringIdByTable("t_perm_fieldperm")});
        } else {
            if (fieldPermFidSet.size() > 1) {
                throw new RuntimeException("roleId:[" + roleId + "] has more than one fieldperm record.");
            }
            fieldPermId = (String)fieldPermFidSet.stream().findFirst().get();
        }
        Set set2 = roleFieldPermFidSet = null == roleFieldPermFidMap || null == roleFieldPermFidMap.get(roleId) ? new HashSet(0) : (Set)roleFieldPermFidMap.get(roleId);
        if (null == roleFieldPermFidSet || roleFieldPermFidSet.isEmpty()) {
            t_perm_rolefieldperm_insertParamList.add(new Object[]{ComRoleService.genStringIdByTable("t_perm_rolefieldperm"), roleId, fieldPermId});
        } else if (roleFieldPermFidSet.size() > 1) {
            throw new RuntimeException("roleId:[" + roleId + "] has more than one rolefieldperm record.");
        }
        if (null != addFieldPermList && !addFieldPermList.isEmpty()) {
            String[] newDetailFentryIds = DB.genStringIds((String)"t_perm_fieldpermdetail", (int)addFieldPermList.size());
            for (int i = 0; i < addFieldPermList.size(); ++i) {
                FieldPerm fieldPerm = addFieldPermList.get(i);
                Object newDetailFentryId = newDetailFentryIds[i];
                t_perm_fieldpermdetail_insertParamList.add(new Object[]{newDetailFentryId, fieldPermId, 0L, fieldPerm.getEntityNumber(), fieldPerm.getFieldName(), fieldPerm.getControlMode(), fieldPerm.getAppId()});
                roleIdFieldPermDetailEntryIdMap.computeIfAbsent(roleId, k -> new HashSet(8)).add(newDetailFentryId);
            }
        }
        if (null != delFieldPermList && !delFieldPermList.isEmpty()) {
            for (FieldPerm fieldPerm : delFieldPermList) {
                Set fentyridSet = (Set)fieldPermDetailEntryIdMap.get(roleId + "|" + fieldPerm.getAppId() + "|" + fieldPerm.getEntityNumber() + "|" + fieldPerm.getFieldName());
                if (null == fentyridSet || fentyridSet.isEmpty()) continue;
                t_perm_fieldpermdetail_delEntryIdSet.addAll(fentyridSet);
            }
            Set allFentryId = null == roleIdFieldPermDetailEntryIdMap || null == roleIdFieldPermDetailEntryIdMap.get(roleId) ? new HashSet(0) : (Set)roleIdFieldPermDetailEntryIdMap.get(roleId);
            Sets.SetView difference = Sets.difference(allFentryId, t_perm_fieldpermdetail_delEntryIdSet);
            if (null == difference || difference.isEmpty()) {
                if (null != fieldPermFidMap.get(roleId)) {
                    t_perm_fieldperm_delFIdSet.addAll((Collection)fieldPermFidMap.get(roleId));
                }
                if (null != roleFieldPermFidMap.get(roleId)) {
                    t_perm_rolefieldperm_delFIdSet.addAll((Collection)roleFieldPermFidMap.get(roleId));
                }
            }
        }
        return resultMap;
    }

    private static Map<String, Object> getFunPermDBOperParamMap(String roleId, List<PermItem> addFunPermList, List<PermItem> delFunPermList, List<ComRoleFuncPerm> updateComRoleFuncPerm, Map<String, Object> rolePermMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        ArrayList<Object[]> t_perm_roleperm_insertParamList = new ArrayList<Object[]>(8);
        ArrayList<Object[]> t_perm_rolepermdetial_insertParamList = new ArrayList<Object[]>(8);
        ArrayList<Object[]> t_perm_rolepermdetial_updateParamList = new ArrayList<Object[]>(8);
        HashSet t_perm_rolepermdetial_delEntryIdSet = new HashSet(8);
        HashSet t_perm_roleperm_delFidSet = new HashSet(8);
        resultMap.put("t_perm_roleperm_insertParamList", t_perm_roleperm_insertParamList);
        resultMap.put("t_perm_rolepermdetial_insertParamList", t_perm_rolepermdetial_insertParamList);
        resultMap.put("t_perm_rolepermdetial_updateParamList", t_perm_rolepermdetial_updateParamList);
        resultMap.put("t_perm_rolepermdetial_delEntryIdSet", t_perm_rolepermdetial_delEntryIdSet);
        resultMap.put("t_perm_roleperm_delFidSet", t_perm_roleperm_delFidSet);
        HashSet<String> funcPermChangeAppIdEntNumSet = new HashSet<String>(8);
        resultMap.put("funcPermChangeAppIdEntNumSet", funcPermChangeAppIdEntNumSet);
        if (!(null != addFunPermList && !addFunPermList.isEmpty() || null != updateComRoleFuncPerm && !updateComRoleFuncPerm.isEmpty() || null != delFunPermList && !delFunPermList.isEmpty())) {
            return resultMap;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date curTime = new Date();
        HashMap roleRolePermFidMap = null == rolePermMap || null == rolePermMap.get("roleRolePermFidMap") ? new HashMap(0) : (Map)rolePermMap.get("roleRolePermFidMap");
        HashMap roleRolePermDetailFentryidMap = null == rolePermMap || null == rolePermMap.get("roleRolePermDetailFentryidMap") ? new HashMap(0) : (Map)rolePermMap.get("roleRolePermDetailFentryidMap");
        HashMap<String, Set> roleIdFentryIdMap = null == rolePermMap || null == rolePermMap.get("roleIdFentryIdMap") ? new HashMap<String, Set>(0) : (Map)rolePermMap.get("roleIdFentryIdMap");
        HashSet<String> rolePermIdSet = null == roleRolePermFidMap || null == roleRolePermFidMap.get(roleId) ? new HashSet<String>(0) : (Set)roleRolePermFidMap.get(roleId);
        rolePermIdSet.removeIf(x -> null == x);
        String rpId = "";
        if (null == rolePermIdSet || rolePermIdSet.isEmpty()) {
            rpId = ComRoleService.genStringIdByTable("t_perm_roleperm");
            t_perm_roleperm_insertParamList.add(new Object[]{rpId, roleId, curTime, currUserId, curTime, currUserId});
        } else {
            if (rolePermIdSet.size() > 1) {
                throw new RuntimeException("roleId:[" + roleId + "] has more than one roleperm record.");
            }
            rpId = (String)rolePermIdSet.stream().findFirst().get();
        }
        if (null != addFunPermList && !addFunPermList.isEmpty()) {
            String[] newRpdFentryIds = DB.genStringIds((String)"t_perm_rolepermdetial", (int)addFunPermList.size());
            for (int i = 0; i < addFunPermList.size(); ++i) {
                PermItem permItem = addFunPermList.get(i);
                String appId = permItem.getAppId();
                String entityNumber = permItem.getEntityNumber();
                funcPermChangeAppIdEntNumSet.add(appId + "|" + entityNumber);
                Object newRpdFentryId = newRpdFentryIds[i];
                t_perm_rolepermdetial_insertParamList.add(new Object[]{rpId, newRpdFentryId, 0, " ", permItem.getPermItemId(), " ", entityNumber, appId, roleId});
                roleIdFentryIdMap.computeIfAbsent(roleId, k -> new HashSet(8)).add(newRpdFentryId);
            }
        }
        if (null != updateComRoleFuncPerm && !updateComRoleFuncPerm.isEmpty()) {
            for (ComRoleFuncPerm comRoleFuncPerm : updateComRoleFuncPerm) {
                t_perm_rolepermdetial_updateParamList.add(new Object[]{comRoleFuncPerm.getAppId(), comRoleFuncPerm.getEntityNumber(), comRoleFuncPerm.getPermItemId(), comRoleFuncPerm.getRoleId(), comRoleFuncPerm.getEntryId()});
            }
        }
        if (null != delFunPermList && !delFunPermList.isEmpty()) {
            for (PermItem permItem : delFunPermList) {
                Set fentyridSet = (Set)roleRolePermDetailFentryidMap.get(roleId + "|" + permItem.getAppId() + "|" + permItem.getEntityNumber() + "|" + permItem.getPermItemId());
                if (null == fentyridSet || fentyridSet.isEmpty()) continue;
                t_perm_rolepermdetial_delEntryIdSet.addAll(fentyridSet);
            }
            Set allFentryId = null == roleIdFentryIdMap.get(roleId) ? new HashSet(0) : (Set)roleIdFentryIdMap.get(roleId);
            Sets.SetView difference = Sets.difference(allFentryId, t_perm_rolepermdetial_delEntryIdSet);
            if ((null == difference || difference.isEmpty()) && null != roleRolePermFidMap.get(roleId)) {
                t_perm_roleperm_delFidSet.addAll((Collection)roleRolePermFidMap.get(roleId));
            }
        }
        return resultMap;
    }

    private static DynamicObject wrapPermRoleDyn(ComRole comRole) {
        String useScope;
        String createAdminGrp;
        String dimTypeId;
        String name;
        String remark;
        Boolean isSystem;
        String groupId;
        Boolean enable;
        String modifierId;
        Date createTime;
        String creatorId;
        String bizDomainId;
        String number;
        DynamicObject roleDyn = null;
        String comRoleId = comRole.getId();
        if (StringUtils.isEmpty((String)comRoleId)) {
            roleDyn = BusinessDataServiceHelper.newDynamicObject((String)"perm_role");
            roleDyn.set("id", (Object)ComRoleService.genStringIdByTable("t_perm_role"));
        } else {
            roleDyn = BusinessDataServiceHelper.loadSingle((Object)comRoleId, (String)"perm_role");
        }
        Set changeRangeSet = comRole.getChangeRangeSet();
        if (!changeRangeSet.contains(ComRoleContentEnum.BASE.getType())) {
            return roleDyn;
        }
        String type = comRole.getType();
        if (StringUtils.isNotEmpty((String)type)) {
            roleDyn.set("roletype", (Object)type);
        }
        if (StringUtils.isNotEmpty((String)(number = comRole.getNumber()))) {
            roleDyn.set("number", (Object)number);
        }
        if (StringUtils.isNotEmpty((String)(bizDomainId = comRole.getBizDomainId()))) {
            roleDyn.set("bizdomain", (Object)bizDomainId);
        }
        if (StringUtils.isNotEmpty((String)(creatorId = comRole.getCreatorId()))) {
            roleDyn.set("creator", (Object)creatorId);
        }
        if (null != (createTime = comRole.getCreateTime())) {
            roleDyn.set("createtime", (Object)createTime);
        }
        if (StringUtils.isNotEmpty((String)(modifierId = comRole.getModifierId()))) {
            roleDyn.set("modifier", (Object)modifierId);
        } else {
            roleDyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
        Date modifyTime = comRole.getModifyTime();
        if (null != modifyTime) {
            roleDyn.set("modifytime", (Object)modifyTime);
        } else {
            roleDyn.set("modifytime", (Object)new Date());
        }
        String status = comRole.getStatus();
        if (StringUtils.isNotEmpty((String)status)) {
            roleDyn.set("status", (Object)status);
        }
        if (null != (enable = comRole.isEnable())) {
            roleDyn.set("enable", (Object)(enable != false ? "1" : "0"));
        }
        if (StringUtils.isNotEmpty((String)(groupId = comRole.getGroupId()))) {
            roleDyn.set("group", (Object)groupId);
        }
        if (null != (isSystem = comRole.isSystem())) {
            roleDyn.set("issystem", (Object)(isSystem != false ? "1" : "0"));
        }
        if (StringUtils.isNotEmpty((String)(remark = comRole.getRemark()))) {
            roleDyn.set("remark", (Object)new LocaleString(Lang.get().toString(), remark));
        }
        if (StringUtils.isNotEmpty((String)(name = comRole.getName()))) {
            roleDyn.set("name", (Object)new LocaleString(Lang.get().toString(), name));
        }
        if (StringUtils.isNotEmpty((String)(dimTypeId = comRole.getDimTypeId()))) {
            roleDyn.set("dimtypeid", (Object)dimTypeId);
        }
        if (StringUtils.isNotEmpty((String)(createAdminGrp = comRole.getCreateAdminGrp()))) {
            roleDyn.set("createadmingrp", (Object)createAdminGrp);
        }
        if (StringUtils.isNotEmpty((String)(useScope = comRole.getUseScope()))) {
            roleDyn.set("usescope", (Object)useScope);
        }
        return roleDyn;
    }

    private static void addOrUpdateComRoleCheck(StringBuilder msg, ComRole comRole, Map<String, Object> paraMap) {
        Set comRoleAdminGrpSet;
        String useScope;
        Set fieldPermSet;
        String appId;
        Set funcPermSet;
        Set changeRangeSet;
        Map comRoleBaseMap = (Map)paraMap.get("comRoleBaseMap");
        Map allRoleNumOrNameIdSetMap = (Map)paraMap.get("allRoleNumOrNameIdSetMap");
        Map roleNumberIdSetMap = (Map)allRoleNumOrNameIdSetMap.get("roleNumberIdSetMap");
        Map roleNameIdSetMap = (Map)allRoleNumOrNameIdSetMap.get("roleNameIdSetMap");
        Set allUserTypeSet = (Set)paraMap.get("allUserTypeSet");
        Set appIdSet = (Set)paraMap.get("appIdSet");
        Set entNumSet = (Set)paraMap.get("entNumSet");
        Set permItemIdSet = (Set)paraMap.get("permItemIdSet");
        Set allDrDetailFidSet = (Set)paraMap.get("allDrDetailFidSet");
        Set allAdminGrpIdSet = (Set)paraMap.get("allAdminGrpIdSet");
        String id = comRole.getId();
        if (StringUtils.isNotEmpty((String)id)) {
            ComRole cr = (ComRole)comRoleBaseMap.get(id);
            if (null != cr && cr.isSystem().booleanValue()) {
                msg.append(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u201c\u901a\u7528\u89d2\u8272\u201d\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ComRoleService_1", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                throw new RuntimeException(msg.toString());
            }
            ComRoleService.checkCanModifyRole(new ArrayList<String>(Collections.singletonList(id)));
        }
        if ((changeRangeSet = comRole.getChangeRangeSet()).contains(ComRoleContentEnum.BASE.getType())) {
            Iterator userType;
            Set roleNameIdSet;
            String name;
            Set roleNumberIdSet;
            String number = comRole.getNumber();
            if (StringUtils.isNotEmpty((String)number) && null != (roleNumberIdSet = (Set)roleNumberIdSetMap.get(number)) && !roleNumberIdSet.isEmpty()) {
                if (StringUtils.isNotEmpty((String)id)) {
                    roleNumberIdSet.remove(id);
                }
                if (null != roleNumberIdSet && !roleNumberIdSet.isEmpty()) {
                    msg.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"ComRoleService_2", (String)SYSTERM_TYPE, (Object[])new Object[0])).append(";");
                    throw new RuntimeException(msg.toString());
                }
            }
            if (StringUtils.isNotEmpty((String)(name = comRole.getName())) && null != (roleNameIdSet = (Set)roleNameIdSetMap.get(name)) && !roleNameIdSet.isEmpty()) {
                if (StringUtils.isNotEmpty((String)id)) {
                    roleNameIdSet.remove(id);
                }
                if (null != roleNameIdSet && !roleNameIdSet.isEmpty()) {
                    msg.append(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\u3002", (String)"ComRoleService_3", (String)SYSTERM_TYPE, (Object[])new Object[0])).append(";");
                    throw new RuntimeException(msg.toString());
                }
            }
            if (StringUtils.isNotEmpty((String)((Object)(userType = comRole.getType())))) {
                String[] userTypeSplit = ((String)((Object)userType)).split(",");
                if (userTypeSplit.length > 5) {
                    msg.append(ResManager.loadKDString((String)"\u201c\u9002\u7528\u7528\u6237\u7c7b\u578b\u201d\u957f\u5ea6\u8fc7\u957f\uff0c\u5efa\u8bae\u52fe\u9009\u4e0d\u8d85\u8fc75\u9879\u3002", (String)"ComRoleService_4", (String)SYSTERM_TYPE, (Object[])new Object[0])).append(";");
                    throw new RuntimeException(msg.toString());
                }
                for (String userTypeOne : userTypeSplit) {
                    if (StringUtils.isEmpty((String)userTypeOne) || allUserTypeSet.contains(userTypeOne)) continue;
                    msg.append("type[").append(userTypeOne).append("] invalid;");
                    throw new RuntimeException(msg.toString());
                }
            }
        }
        if (changeRangeSet.contains(ComRoleContentEnum.FUNC.getType()) && null != (funcPermSet = comRole.getFuncPermSet()) && !funcPermSet.isEmpty()) {
            int funcPermSetIndex = 0;
            for (PermItem item : funcPermSet) {
                appId = item.getAppId();
                if (StringUtils.isEmpty((String)appId)) {
                    msg.append("funcPermSet[").append(funcPermSetIndex).append("].").append("appId is empty;");
                    throw new RuntimeException(msg.toString());
                }
                if (!appIdSet.contains(appId)) {
                    msg.append("funcPermSet[").append(funcPermSetIndex).append("].").append("appId[").append(appId).append("] is not exists;");
                    throw new RuntimeException(msg.toString());
                }
                String entityNumber = item.getEntityNumber();
                if (StringUtils.isEmpty((String)entityNumber)) {
                    msg.append("funcPermSet[").append(funcPermSetIndex).append("].").append("entityNumber is empty;");
                    throw new RuntimeException(msg.toString());
                }
                if (!entNumSet.contains(entityNumber)) {
                    msg.append("funcPermSet[").append(funcPermSetIndex).append("].").append("entityNumber[").append(entityNumber).append("] is not exists;");
                    throw new RuntimeException(msg.toString());
                }
                String permItemId = item.getPermItemId();
                if (StringUtils.isEmpty((String)permItemId)) {
                    msg.append("funcPermSet[").append(funcPermSetIndex).append("].").append("permItemId is empty;");
                    throw new RuntimeException(msg.toString());
                }
                if (!permItemIdSet.contains(permItemId)) {
                    msg.append("funcPermSet[").append(funcPermSetIndex).append("].").append("permItemId[").append(permItemId).append("] is not exists;");
                    throw new RuntimeException(msg.toString());
                }
                ++funcPermSetIndex;
            }
        }
        if (changeRangeSet.contains(ComRoleContentEnum.FIELD.getType()) && null != (fieldPermSet = comRole.getFieldPermSet()) && !fieldPermSet.isEmpty()) {
            int fieldPermSetIndex = 0;
            for (FieldPerm fieldPerm : fieldPermSet) {
                appId = fieldPerm.getAppId();
                if (StringUtils.isEmpty((String)appId)) {
                    msg.append("fieldPermSet[").append(fieldPermSetIndex).append("].").append("appId is empty;");
                    throw new RuntimeException(msg.toString());
                }
                if (!appIdSet.contains(appId)) {
                    msg.append("fieldPermSet[").append(fieldPermSetIndex).append("].").append("appId[").append(appId).append("] is not exists;");
                    throw new RuntimeException(msg.toString());
                }
                String entityNumber = fieldPerm.getEntityNumber();
                if (StringUtils.isEmpty((String)entityNumber)) {
                    msg.append("fieldPermSet[").append(fieldPermSetIndex).append("].").append("entityNumber is empty;");
                    throw new RuntimeException(msg.toString());
                }
                if (!entNumSet.contains(entityNumber)) {
                    msg.append("fieldPermSet[").append(fieldPermSetIndex).append("].").append("entityNumber[").append(entityNumber).append("] is not exists;");
                    throw new RuntimeException(msg.toString());
                }
                ++fieldPermSetIndex;
            }
        }
        if (changeRangeSet.contains(ComRoleContentEnum.NEWDR.getType())) {
            Set newDrPrPermSet;
            Set newDrPermSet = comRole.getNewDrPermSet();
            if (null != newDrPermSet && !newDrPermSet.isEmpty()) {
                int newDrPermIndex = 0;
                for (NewDrPerm newDrPerm : newDrPermSet) {
                    appId = newDrPerm.getAppId();
                    if (StringUtils.isEmpty((String)appId)) {
                        msg.append("newDrPermSet[").append(newDrPermIndex).append("].").append("appId is empty;");
                        throw new RuntimeException(msg.toString());
                    }
                    if (!appIdSet.contains(appId)) {
                        msg.append("newDrPermSet[").append(newDrPermIndex).append("].").append("appId[").append(appId).append("] is not exists;");
                        throw new RuntimeException(msg.toString());
                    }
                    String entityNumber = newDrPerm.getEntityNumber();
                    if (StringUtils.isEmpty((String)entityNumber)) {
                        msg.append("newDrPermSet[").append(newDrPermIndex).append("].").append("entityNumber is empty;");
                        throw new RuntimeException(msg.toString());
                    }
                    if (!entNumSet.contains(entityNumber)) {
                        msg.append("newDrPermSet[").append(newDrPermIndex).append("].").append("entityNumber[").append(entityNumber).append("] is not exists;");
                        throw new RuntimeException(msg.toString());
                    }
                    String permItemId = newDrPerm.getPermItemId();
                    if (StringUtils.isEmpty((String)permItemId)) {
                        msg.append("newDrPermSet[").append(newDrPermIndex).append("].").append("permItemId is empty;");
                        throw new RuntimeException(msg.toString());
                    }
                    if (!permItemIdSet.contains(permItemId)) {
                        msg.append("newDrPermSet[").append(newDrPermIndex).append("].").append("permItemId[").append(permItemId).append("] is not exists;");
                        throw new RuntimeException(msg.toString());
                    }
                    Long dataRuleId = newDrPerm.getDataRuleId();
                    if (null == dataRuleId || 0L == dataRuleId) {
                        msg.append("newDrPermSet[").append(newDrPermIndex).append("].").append("dataRuleId is empty;");
                        throw new RuntimeException(msg.toString());
                    }
                    if (!allDrDetailFidSet.contains(dataRuleId)) {
                        msg.append("newDrPermSet[").append(newDrPermIndex).append("].").append("dataRuleId[").append(dataRuleId).append("] is not exists;");
                        throw new RuntimeException(msg.toString());
                    }
                    ++newDrPermIndex;
                }
            }
            if (null != (newDrPrPermSet = comRole.getNewDrPrPermSet()) && !newDrPrPermSet.isEmpty()) {
                int newDrPrPermIndex = 0;
                for (NewDrPrPerm newDrPrPerm : newDrPrPermSet) {
                    Long dataRuleId = newDrPrPerm.getDataRuleId();
                    if (null == dataRuleId || 0L == dataRuleId) {
                        msg.append("newDrPrPermSet[").append(newDrPrPermIndex).append("].").append("dataRuleId is empty;");
                        throw new RuntimeException(msg.toString());
                    }
                    if (!allDrDetailFidSet.contains(dataRuleId)) {
                        msg.append("newDrPrPermSet[").append(newDrPrPermIndex).append("].").append("dataRuleId[").append(dataRuleId).append("] is not exists;");
                        throw new RuntimeException(msg.toString());
                    }
                    ++newDrPrPermIndex;
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(useScope = comRole.getUseScope()))) {
            if (!("0".equals(useScope) || "1".equals(useScope) || "2".equals(useScope))) {
                msg.append("useScope[").append(useScope).append("].").append("invalid;");
                throw new RuntimeException(msg.toString());
            }
            Set comRoleAdminGrpSet2 = comRole.getComRoleAdminGrpSet();
            if ("1".equals(useScope) && (null == comRoleAdminGrpSet2 || comRoleAdminGrpSet2.isEmpty())) {
                msg.append(ResManager.loadKDString((String)"\u201c\u516c\u5f00\u72b6\u6001\u201d\u4e3a\u201c\u5206\u914d\u201d\u65f6\uff0c\u9700\u7ef4\u62a4\u201c\u516c\u5f00\u8303\u56f4\u201d\u3002", (String)"ComRoleService_5", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                throw new RuntimeException(msg.toString());
            }
        }
        if (changeRangeSet.contains(ComRoleContentEnum.ADMINGROUP.getType()) && null != (comRoleAdminGrpSet = comRole.getComRoleAdminGrpSet()) && !comRoleAdminGrpSet.isEmpty()) {
            ComRole cr;
            if (StringUtils.isEmpty((String)useScope) && null != (cr = (ComRole)comRoleBaseMap.get(id)) && !"1".equals(cr.getUseScope())) {
                msg.append(ResManager.loadKDString((String)"\u201c\u516c\u5f00\u72b6\u6001\u201d\u4e3a\u201c\u5206\u914d\u201d\u65f6\uff0c\u624d\u9700\u8981\u7ef4\u62a4\u201c\u516c\u5f00\u8303\u56f4\u201d\u3002", (String)"ComRoleService_6", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                throw new RuntimeException(msg.toString());
            }
            int comRoleAdminGrpIndex = 0;
            for (ComRoleAdminGrp adminGrp : comRoleAdminGrpSet) {
                String adminGroupId = adminGrp.getAdminGroupId();
                if (StringUtils.isEmpty((String)adminGroupId)) {
                    msg.append("comRoleAdminGrpSet[").append(comRoleAdminGrpIndex).append("].").append("dataRuleId is empty;");
                    throw new RuntimeException(msg.toString());
                }
                if (!allAdminGrpIdSet.contains(Long.valueOf(adminGroupId))) {
                    msg.append("comRoleAdminGrpSet[").append(comRoleAdminGrpIndex).append("].").append("adminGroupId[").append(adminGroupId).append("] is not exists;");
                    throw new RuntimeException(msg.toString());
                }
                ++comRoleAdminGrpIndex;
            }
        }
    }

    private Map<String, Object> getParaMap(List<ComRole> comRoleList) {
        HashSet<String> dimTypeIdSet = new HashSet<String>(8);
        HashSet<String> roleIdSet = new HashSet<String>(comRoleList.size());
        for (ComRole comRole : comRoleList) {
            dimTypeIdSet.add(comRole.getDimTypeId());
            roleIdSet.add(comRole.getId());
        }
        if (dimTypeIdSet.size() > 1) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u8bf7\u4fdd\u6301\u201c\u6743\u9650\u63a7\u5236\u7c7b\u578b\u201d\u4e00\u81f4\u3002", (String)"ComRoleService_7", (String)SYSTERM_TYPE, (Object[])new Object[0]) + ";");
        }
        Set changeRangeSet = comRoleList.get(0).getChangeRangeSet();
        HashMap<String, Object> myParaMap = new HashMap<String, Object>(8);
        if (changeRangeSet.contains(ComRoleContentEnum.FUNC.getType())) {
            Map rolePermMap = PermRoleHelper.queryRolePermMap(roleIdSet);
            myParaMap.put("rolePermMap", rolePermMap);
            Map funcPermSetDBMap = PermRoleHelper.getFuncPermSetMap(roleIdSet, (Map)rolePermMap);
            myParaMap.put("funcPermSetDBMap", funcPermSetDBMap);
        }
        if (changeRangeSet.contains(ComRoleContentEnum.FIELD.getType())) {
            Map roleFieldPermMap = PermRoleHelper.queryRoleFieldPermMap(roleIdSet);
            myParaMap.put("roleFieldPermMap", roleFieldPermMap);
            Map fieldPermSetDBMap = PermRoleHelper.getFieldPermSetMap(roleIdSet, (Map)roleFieldPermMap);
            myParaMap.put("fieldPermSetDBMap", fieldPermSetDBMap);
        }
        if (changeRangeSet.contains(ComRoleContentEnum.NEWDR.getType())) {
            Map roleDrMap = PermRoleHelper.queryRoleDrMap(roleIdSet);
            myParaMap.put("roleDrMap", roleDrMap);
            Map newDrPermSetDBMap = PermRoleHelper.getNewDrPermSetMap(roleIdSet, (Map)roleDrMap);
            myParaMap.put("newDrPermSetDBMap", newDrPermSetDBMap);
            Map roleDrPrMap = PermRoleHelper.queryRoleDrPrMap(roleIdSet);
            myParaMap.put("roleDrPrMap", roleDrPrMap);
            Map newDrPrPermSetDBMap = PermRoleHelper.getNewDrPrPermSetMap(roleIdSet, (Map)roleDrPrMap);
            myParaMap.put("newDrPrPermSetDBMap", newDrPrPermSetDBMap);
        }
        if (changeRangeSet.contains(ComRoleContentEnum.ADMINGROUP.getType())) {
            Map adminGrpMap = PermRoleHelper.queryAdmGrpMap(roleIdSet);
            myParaMap.put("adminGrpMap", adminGrpMap);
            Map comRoleAdminGrpSetDBMap = PermRoleHelper.getComRoleAdminGrpSetMap(roleIdSet, (Map)adminGrpMap);
            myParaMap.put("comRoleAdminGrpSetDBMap", comRoleAdminGrpSetDBMap);
        }
        Map comRoleBaseMap = PermRoleHelper.getComRoleBaseMap(roleIdSet, null);
        myParaMap.put("comRoleBaseMap", comRoleBaseMap);
        Map allRoleNumOrNameIdSetMap = PermRoleHelper.getAllRoleNumOrNameIdSetMap();
        myParaMap.put("allRoleNumOrNameIdSetMap", allRoleNumOrNameIdSetMap);
        List allUserTypeList = UserServiceHelper.getAllUserType((boolean)false);
        Set allUserTypeSet = allUserTypeList.stream().map(String::valueOf).collect(Collectors.toSet());
        myParaMap.put("allUserTypeSet", allUserTypeSet);
        GetPlainPermItemListReq req = new GetPlainPermItemListReq();
        req.setDimType(comRoleList.get(0).getDimTypeId());
        List plainPermItemList = PermItemHelper.getPlainPermItemList((GetPlainPermItemListReq)req);
        HashSet<String> appIdSet = new HashSet<String>(32);
        HashSet<String> entNumSet = new HashSet<String>(128);
        HashSet<String> permItemIdSet = new HashSet<String>(128);
        for (PermItem permItem : plainPermItemList) {
            appIdSet.add(permItem.getAppId());
            entNumSet.add(permItem.getEntityNumber());
            permItemIdSet.add(permItem.getPermItemId());
        }
        myParaMap.put("appIdSet", appIdSet);
        myParaMap.put("entNumSet", entNumSet);
        myParaMap.put("permItemIdSet", permItemIdSet);
        Set allDrDetailFidSet = DrHelper.getAllDrDetailFidSet();
        myParaMap.put("allDrDetailFidSet", allDrDetailFidSet);
        Set allAdminGrpIdSet = AdminGroupHelper.getAllAdminGrpIdSet();
        myParaMap.put("allAdminGrpIdSet", allAdminGrpIdSet);
        return myParaMap;
    }

    public PermResult update(ComRoleAddOrUpdateReq req) {
        super.checkPerm("perm_role", "4715a0df000000ac", (Object)req);
        super.commonValidate((Object)req, new Class[]{Update.class, PermLog.class});
        return this.addOrUpdateComRole(req);
    }

    private PermResult addOrUpdateComRole(ComRoleAddOrUpdateReq req) {
        Throwable comRole;
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        StringBuilder msg = new StringBuilder();
        msg.append(methodName).append(".");
        List comRoleList = req.getComRoleList();
        Map<String, Object> paraMap = this.getParaMap(comRoleList);
        Map<String, Object> DBParamMap = null;
        int size = comRoleList.size();
        ArrayList<DynamicObject> roleDynList = new ArrayList<DynamicObject>(size);
        ArrayList t_perm_roleperm_insertParamList = new ArrayList(8);
        ArrayList t_perm_rolepermdetial_insertParamList = new ArrayList(8);
        ArrayList t_perm_rolepermdetial_updateParamList = new ArrayList(10);
        HashSet t_perm_rolepermdetial_delEntryIdSet = new HashSet(8);
        HashSet t_perm_roleperm_delFidSet = new HashSet(8);
        ArrayList t_perm_fieldperm_insertParamList = new ArrayList(8);
        ArrayList t_perm_rolefieldperm_insertParamList = new ArrayList(8);
        ArrayList t_perm_fieldpermdetail_insertParamList = new ArrayList(8);
        HashSet t_perm_fieldperm_delFIdSet = new HashSet(8);
        HashSet t_perm_rolefieldperm_delFIdSet = new HashSet(8);
        HashSet t_perm_fieldpermdetail_delEntryIdSet = new HashSet(8);
        ArrayList t_perm_datarule_insertParamList = new ArrayList(8);
        ArrayList t_perm_dataruleL_insertParamList = new ArrayList(8);
        ArrayList t_perm_datarule_entry_insertParamList = new ArrayList(8);
        ArrayList t_perm_datarule_prop_insertParamList = new ArrayList(8);
        ArrayList t_perm_datarules_insertParamList = new ArrayList(8);
        ArrayList t_perm_datarulesL_insertParamList = new ArrayList(8);
        ArrayList t_perm_datarules_entry_insertParamList = new ArrayList(8);
        ArrayList t_perm_roledatarules_insertParamList = new ArrayList(8);
        HashSet t_perm_datarule_entry_delEntryIdSet = new HashSet(8);
        HashSet t_perm_datarule_prop_delEntryIdSet = new HashSet(8);
        ArrayList t_perm_roledatarule_insertParamList = new ArrayList(8);
        ArrayList t_perm_roledatarule_delParamList = new ArrayList(8);
        ArrayList t_perm_roledatarule_prop_insertParamList = new ArrayList(8);
        ArrayList t_perm_roledatarule_prop_delParamList = new ArrayList(8);
        ArrayList t_perm_admingrouprole_insertParamList = new ArrayList(8);
        HashSet t_perm_admingrouprole_delFIdSet = new HashSet(8);
        HashMap<String, List> addFunPermMap = new HashMap<String, List>(8);
        HashMap<String, List> delFunPermMap = new HashMap<String, List>(8);
        HashMap<String, List> addFieldPermMap = new HashMap<String, List>(8);
        HashMap<String, List> delFieldPermMap = new HashMap<String, List>(8);
        HashMap<String, List> addNewDrPermMap = new HashMap<String, List>(8);
        HashMap<String, List> delNewDrPermMap = new HashMap<String, List>(8);
        HashMap<String, List> addNewDrPrPermMap = new HashMap<String, List>(8);
        HashMap<String, List> delNewDrPrPermMap = new HashMap<String, List>(8);
        HashMap<String, List> addComRoleAdminGrpMap = new HashMap<String, List>(8);
        HashMap<String, List> delComRoleAdminGrpMap = new HashMap<String, List>(8);
        HashSet<String> roleIdSet = new HashSet<String>(size);
        HashMap<String, Set<String>> newDrChangeAppIdEntNumSetMap = new HashMap<String, Set<String>>(size);
        HashMap<String, Set<String>> funcPermChangeAppIdEntNumSetMap = new HashMap<String, Set<String>>(size);
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        for (int i = 0; i < size; ++i) {
            msg.append("comRoleList[").append(i).append("].");
            comRole = (ComRole)comRoleList.get(i);
            ComRoleService.addOrUpdateComRoleCheck(msg, (ComRole)comRole, paraMap);
            DBParamMap = this.addOrUpdateComRoleWrapDBParam((ComRole)comRole, paraMap);
            DynamicObject roleDyn = (DynamicObject)DBParamMap.get("roleDyn");
            roleDynList.add(roleDyn);
            String roleId = roleDyn.getString("id");
            roleIdSet.add(roleId);
            Set changeRangeSet = comRole.getChangeRangeSet();
            if (changeRangeSet.contains(ComRoleContentEnum.FUNC.getType())) {
                t_perm_roleperm_insertParamList.addAll((List)DBParamMap.get("t_perm_roleperm_insertParamList"));
                t_perm_rolepermdetial_insertParamList.addAll((List)DBParamMap.get("t_perm_rolepermdetial_insertParamList"));
                t_perm_rolepermdetial_updateParamList.addAll((List)DBParamMap.get("t_perm_rolepermdetial_updateParamList"));
                t_perm_rolepermdetial_delEntryIdSet.addAll((Set)DBParamMap.get("t_perm_rolepermdetial_delEntryIdSet"));
                t_perm_roleperm_delFidSet.addAll((Set)DBParamMap.get("t_perm_roleperm_delFidSet"));
                addFunPermMap.put(roleId, (List)DBParamMap.get("addFunPermList"));
                delFunPermMap.put(roleId, (List)DBParamMap.get("delFunPermList"));
                Set funcPermChangeAppIdEntNumSet = (Set)DBParamMap.get("funcPermChangeAppIdEntNumSet");
                funcPermChangeAppIdEntNumSetMap.put(roleId, funcPermChangeAppIdEntNumSet);
            }
            if (changeRangeSet.contains(ComRoleContentEnum.FIELD.getType())) {
                t_perm_fieldperm_insertParamList.addAll((List)DBParamMap.get("t_perm_fieldperm_insertParamList"));
                t_perm_rolefieldperm_insertParamList.addAll((List)DBParamMap.get("t_perm_rolefieldperm_insertParamList"));
                t_perm_fieldpermdetail_insertParamList.addAll((List)DBParamMap.get("t_perm_fieldpermdetail_insertParamList"));
                t_perm_fieldperm_delFIdSet.addAll((Set)DBParamMap.get("t_perm_fieldperm_delFIdSet"));
                t_perm_rolefieldperm_delFIdSet.addAll((Set)DBParamMap.get("t_perm_rolefieldperm_delFIdSet"));
                t_perm_fieldpermdetail_delEntryIdSet.addAll((Set)DBParamMap.get("t_perm_fieldpermdetail_delEntryIdSet"));
                addFieldPermMap.put(roleId, (List)DBParamMap.get("addFieldPermList"));
                delFieldPermMap.put(roleId, (List)DBParamMap.get("delFieldPermList"));
            }
            if (changeRangeSet.contains(ComRoleContentEnum.NEWDR.getType())) {
                if (hasEnableRoleDataRuleNewModel) {
                    t_perm_roledatarule_insertParamList.addAll((List)DBParamMap.get("t_perm_roledatarule_insertParamList"));
                    t_perm_roledatarule_delParamList.addAll((List)DBParamMap.get("t_perm_roledatarule_delParamList"));
                    t_perm_roledatarule_prop_insertParamList.addAll((List)DBParamMap.get("t_perm_roledatarule_prop_insertParamList"));
                    t_perm_roledatarule_prop_delParamList.addAll((List)DBParamMap.get("t_perm_roledatarule_prop_delParamList"));
                } else {
                    t_perm_datarule_insertParamList.addAll((List)DBParamMap.get("t_perm_datarule_insertParamList"));
                    t_perm_dataruleL_insertParamList.addAll((List)DBParamMap.get("t_perm_dataruleL_insertParamList"));
                    t_perm_datarule_entry_insertParamList.addAll((List)DBParamMap.get("t_perm_datarule_entry_insertParamList"));
                    t_perm_datarule_prop_insertParamList.addAll((List)DBParamMap.get("t_perm_datarule_prop_insertParamList"));
                    t_perm_datarules_insertParamList.addAll((List)DBParamMap.get("t_perm_datarules_insertParamList"));
                    t_perm_datarulesL_insertParamList.addAll((List)DBParamMap.get("t_perm_datarulesL_insertParamList"));
                    t_perm_datarules_entry_insertParamList.addAll((List)DBParamMap.get("t_perm_datarules_entry_insertParamList"));
                    t_perm_roledatarules_insertParamList.addAll((List)DBParamMap.get("t_perm_roledatarules_insertParamList"));
                    t_perm_datarule_entry_delEntryIdSet.addAll((Set)DBParamMap.get("t_perm_datarule_entry_delEntryIdSet"));
                    t_perm_datarule_prop_delEntryIdSet.addAll((Set)DBParamMap.get("t_perm_datarule_prop_delEntryIdSet"));
                }
                addNewDrPermMap.put(roleId, (List)DBParamMap.get("addNewDrPermList"));
                delNewDrPermMap.put(roleId, (List)DBParamMap.get("delNewDrPermList"));
                addNewDrPrPermMap.put(roleId, (List)DBParamMap.get("addNewDrPrPermList"));
                delNewDrPrPermMap.put(roleId, (List)DBParamMap.get("delNewDrPrPermList"));
                Set newDrChangeAppIdEntNumSet = (Set)DBParamMap.get("newDrChangeAppIdEntNumSet");
                newDrChangeAppIdEntNumSetMap.put(roleId, newDrChangeAppIdEntNumSet);
            }
            if (!changeRangeSet.contains(ComRoleContentEnum.ADMINGROUP.getType())) continue;
            t_perm_admingrouprole_insertParamList.addAll((List)DBParamMap.get("t_perm_admingrouprole_insertParamList"));
            t_perm_admingrouprole_delFIdSet.addAll((Set)DBParamMap.get("t_perm_admingrouprole_delFIdSet"));
            addComRoleAdminGrpMap.put(roleId, (List)DBParamMap.get("addComRoleAdminGrpList"));
            delComRoleAdminGrpMap.put(roleId, (List)DBParamMap.get("delComRoleAdminGrpList"));
        }
        comRole = null;
        try (TXHandle txHandle = TX.required();){
            try {
                if (null != roleDynList && !roleDynList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])roleDynList.toArray(new DynamicObject[0]));
                }
                PermRoleHelper.funcPerm2DB(t_perm_roleperm_insertParamList, t_perm_rolepermdetial_insertParamList, t_perm_rolepermdetial_updateParamList, t_perm_rolepermdetial_delEntryIdSet, t_perm_roleperm_delFidSet);
                PermRoleHelper.fieldPerm2DB(t_perm_fieldperm_insertParamList, t_perm_rolefieldperm_insertParamList, t_perm_fieldpermdetail_insertParamList, t_perm_fieldperm_delFIdSet, t_perm_rolefieldperm_delFIdSet, t_perm_fieldpermdetail_delEntryIdSet);
                if (hasEnableRoleDataRuleNewModel) {
                    PermRoleHelper.DR_NewModel2DB(t_perm_roledatarule_insertParamList, t_perm_roledatarule_prop_insertParamList, t_perm_roledatarule_delParamList, t_perm_roledatarule_prop_delParamList);
                } else {
                    PermRoleHelper.DR2DB(t_perm_datarule_insertParamList, t_perm_dataruleL_insertParamList, t_perm_datarule_entry_insertParamList, t_perm_datarule_prop_insertParamList, t_perm_datarules_insertParamList, t_perm_datarulesL_insertParamList, t_perm_datarules_entry_insertParamList, t_perm_roledatarules_insertParamList, t_perm_datarule_entry_delEntryIdSet, t_perm_datarule_prop_delEntryIdSet);
                }
                PermRoleHelper.adminGrp2DB(t_perm_admingrouprole_insertParamList, t_perm_admingrouprole_delFIdSet);
                CacheMrg.clearAllCache();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.warn("ComRoleService.{} error", (Object)methodName, (Object)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
        catch (Throwable throwable) {
            comRole = throwable;
            throw throwable;
        }
        Map roleUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap(roleIdSet);
        ComRoleService.toLic(roleIdSet, funcPermChangeAppIdEntNumSetMap, roleUserIdSetMap);
        ComRoleService.clearDomainCache(roleIdSet, newDrChangeAppIdEntNumSetMap, roleUserIdSetMap);
        HashMap<String, Object> sign2PermLogParaMap = new HashMap<String, Object>(8);
        sign2PermLogParaMap.put("permLogReq", req.getPermLogReq());
        sign2PermLogParaMap.put("roleIdSet", roleIdSet);
        sign2PermLogParaMap.put("addFunPermMap", addFunPermMap);
        sign2PermLogParaMap.put("delFunPermMap", delFunPermMap);
        sign2PermLogParaMap.put("addFieldPermMap", addFieldPermMap);
        sign2PermLogParaMap.put("delFieldPermMap", delFieldPermMap);
        sign2PermLogParaMap.put("addNewDrPermMap", addNewDrPermMap);
        sign2PermLogParaMap.put("delNewDrPermMap", delNewDrPermMap);
        sign2PermLogParaMap.put("addNewDrPrPermMap", addNewDrPrPermMap);
        sign2PermLogParaMap.put("delNewDrPrPermMap", delNewDrPrPermMap);
        sign2PermLogParaMap.put("addComRoleAdminGrpMap", addComRoleAdminGrpMap);
        sign2PermLogParaMap.put("delComRoleAdminGrpMap", delComRoleAdminGrpMap);
        sign2PermLogParaMap.put("dealChild", Boolean.TRUE);
        this.sign2PermLog(sign2PermLogParaMap, roleUserIdSetMap);
        return PermResult.ok(roleIdSet);
    }

    private static void toLic(Set<String> roleIdSet, Map<String, Set<String>> funcPermChangeAppIdEntNumSetMap, Map<String, Set<Long>> roleUserIdSetMap) {
        for (String roleId : roleIdSet) {
            Set<String> funcPermChangeAppIdEntNumSet;
            Set<Long> userIdSet = roleUserIdSetMap.get(roleId);
            if (null == userIdSet || userIdSet.isEmpty() || null == (funcPermChangeAppIdEntNumSet = funcPermChangeAppIdEntNumSetMap.get(roleId)) || funcPermChangeAppIdEntNumSet.isEmpty()) continue;
            HashMap<String, List> appIdEntNumMap = new HashMap<String, List>(funcPermChangeAppIdEntNumSet.size());
            for (String appIdEntNum : funcPermChangeAppIdEntNumSet) {
                String[] split = appIdEntNum.split("\\|", 2);
                String appId = split[0];
                String entNum = split[1];
                appIdEntNumMap.computeIfAbsent(appId, k -> new ArrayList()).add(entNum);
            }
            LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList<Long>(userIdSet), appIdEntNumMap);
        }
    }

    private void sign2PermLog(Map<String, Object> sign2PermLogParaMap, Map<String, Set<Long>> roleUserIdSetMap) {
        Set roleIdSet = (Set)sign2PermLogParaMap.get("roleIdSet");
        try {
            PermLogReq permLogReq = (PermLogReq)sign2PermLogParaMap.get("permLogReq");
            if (null == roleIdSet || roleIdSet.isEmpty()) {
                return;
            }
            ArrayList list = new ArrayList(roleIdSet.size());
            Boolean dealChild = (Boolean)sign2PermLogParaMap.get("dealChild");
            ObjectMapper objectMapper = null;
            for (String roleId : roleIdSet) {
                Set<Long> value;
                permLogReq.check(false);
                HashMap<String, Object> diffMap = new HashMap<String, Object>(4);
                diffMap.put("langStr", RequestContext.get().getLang().name());
                if (dealChild.booleanValue()) {
                    Map addFunPermMap = null == sign2PermLogParaMap.get("addFunPermMap") ? new HashMap(0) : (Map)sign2PermLogParaMap.get("addFunPermMap");
                    Map delFunPermMap = null == sign2PermLogParaMap.get("delFunPermMap") ? new HashMap(0) : (Map)sign2PermLogParaMap.get("delFunPermMap");
                    Map addFieldPermMap = null == sign2PermLogParaMap.get("addFieldPermMap") ? new HashMap(0) : (Map)sign2PermLogParaMap.get("addFieldPermMap");
                    Map delFieldPermMap = null == sign2PermLogParaMap.get("delFieldPermMap") ? new HashMap(0) : (Map)sign2PermLogParaMap.get("delFieldPermMap");
                    Map addNewDrPermMap = null == sign2PermLogParaMap.get("addNewDrPermMap") ? new HashMap(0) : (Map)sign2PermLogParaMap.get("addNewDrPermMap");
                    Map delNewDrPermMap = null == sign2PermLogParaMap.get("delNewDrPermMap") ? new HashMap(0) : (Map)sign2PermLogParaMap.get("delNewDrPermMap");
                    Map addNewDrPrPermMap = null == sign2PermLogParaMap.get("addNewDrPrPermMap") ? new HashMap(0) : (Map)sign2PermLogParaMap.get("addNewDrPrPermMap");
                    Map delNewDrPrPermMap = null == sign2PermLogParaMap.get("delNewDrPrPermMap") ? new HashMap(0) : (Map)sign2PermLogParaMap.get("delNewDrPrPermMap");
                    Map addComRoleAdminGrpMap = null == sign2PermLogParaMap.get("addComRoleAdminGrpMap") ? new HashMap(0) : (Map)sign2PermLogParaMap.get("addComRoleAdminGrpMap");
                    Map delComRoleAdminGrpMap = null == sign2PermLogParaMap.get("delComRoleAdminGrpMap") ? new HashMap(0) : (Map)sign2PermLogParaMap.get("delComRoleAdminGrpMap");
                    diffMap.put("delPermItem", null == delFunPermMap.get(roleId) ? new ArrayList(0) : delFunPermMap.get(roleId));
                    diffMap.put("addPermItem", null == addFunPermMap.get(roleId) ? new ArrayList(0) : addFunPermMap.get(roleId));
                    diffMap.put("delFieldPerm", null == delFieldPermMap.get(roleId) ? new ArrayList(0) : delFieldPermMap.get(roleId));
                    diffMap.put("addFieldPerm", null == addFieldPermMap.get(roleId) ? new ArrayList(0) : addFieldPermMap.get(roleId));
                    this.setDrDiff(diffMap, null == addNewDrPermMap.get(roleId) ? new ArrayList(0) : (List)addNewDrPermMap.get(roleId), null == delNewDrPermMap.get(roleId) ? new ArrayList(0) : (List)delNewDrPermMap.get(roleId));
                    this.setDrPrDiff(diffMap, null == addNewDrPrPermMap.get(roleId) ? new ArrayList(0) : (List)addNewDrPrPermMap.get(roleId), null == delNewDrPrPermMap.get(roleId) ? new ArrayList(0) : (List)delNewDrPrPermMap.get(roleId));
                    diffMap.put("delComRoleAdminGrp", null == delComRoleAdminGrpMap.get(roleId) ? new ArrayList(0) : delComRoleAdminGrpMap.get(roleId));
                    diffMap.put("addComRoleAdminGrp", null == addComRoleAdminGrpMap.get(roleId) ? new ArrayList(0) : addComRoleAdminGrpMap.get(roleId));
                }
                HashSet roleUserIdSet = null == (value = roleUserIdSetMap.get(roleId)) || value.isEmpty() ? new HashSet(1) : value.stream().map(String::valueOf).collect(Collectors.toSet());
                diffMap.put("influenUserIdSet", roleUserIdSet);
                String formNum = permLogReq.getFormIdentity();
                String appId = BizAppServiceHelp.getAppIdByFormNum((String)formNum);
                String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
                HashMap<String, Object> map = new HashMap<String, Object>(20);
                map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
                map.put("busi_from", permLogReq.getBusiFrom());
                map.put("busi_type", permLogReq.getBusiType());
                map.put("cloud_id", cloudId);
                map.put("app_id", appId);
                map.put("form_identity", formNum);
                map.put("op", permLogReq.getOp());
                map.put("opbtn", permLogReq.getOpbtn());
                map.put("interface_method", permLogReq.getInterfaceMethod());
                map.put("op_item_id", permLogReq.getOpItemId());
                map.put("op_item_number", permLogReq.getOpItemNumber());
                map.put("op_item_name", permLogReq.getOpItemName());
                objectMapper = new ObjectMapper();
                map.put("diff_content", StrUtil.compress((String)objectMapper.writeValueAsString(diffMap)));
                map.put("oper_id", RequestContext.get().getCurrUserId());
                map.put("oper_org_id", RequestContext.get().getOrgId());
                map.put("oper_time", permLogReq.getOperTime());
                map.put("client_type", permLogReq.getClientType());
                map.put("client_ip", permLogReq.getClientIp());
                map.put("client_name", permLogReq.getClientType());
                list.add(map);
            }
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("ComRoleService.sign2PermLog error, roleIdSet:{}", (Object)roleIdSet, (Object)e);
        }
    }

    private void setDrPrDiff(Map<String, Object> diffMap, List<NewDrPrPerm> addList_, List<NewDrPrPerm> delList_) {
        CopyOnWriteArrayList<NewDrPrPerm> delList = new CopyOnWriteArrayList<NewDrPrPerm>(delList_);
        CopyOnWriteArrayList<NewDrPrPerm> addList = new CopyOnWriteArrayList<NewDrPrPerm>(addList_);
        ArrayList updateList = new ArrayList(8);
        delList.stream().forEach(x -> {
            Optional<NewDrPrPerm> first = addList.stream().filter(y -> y.getAppId().equals(x.getAppId()) && y.getEntityNumber().equals(x.getEntityNumber()) && y.getPropKey().equals(x.getPropKey()) && y.getPropEntNum().equals(x.getPropEntNum())).findFirst();
            if (first.isPresent()) {
                NewDrPrPerm ldrp = (NewDrPrPerm)addList.get(0);
                ldrp.setDataRuleName(String.valueOf(x.getDataRuleId()));
                updateList.add(ldrp);
                delList.remove(x);
                addList.remove(ldrp);
            }
        });
        delList.stream().forEach(ldrp -> {
            Long dataRuleId = ldrp.getDataRuleId();
            ldrp.setDataRuleId(Long.valueOf(0L));
            ldrp.setDataRuleName(String.valueOf(dataRuleId));
        });
        addList.stream().forEach(ldrp -> ldrp.setDataRuleName("0"));
        diffMap.put("delNewDrPrPerm", delList);
        diffMap.put("addNewDrPrPerm", addList);
        diffMap.put("updateNewDrPrPerm", updateList);
    }

    private void setDrDiff(Map<String, Object> diffMap, List<NewDrPerm> addList_, List<NewDrPerm> delList_) {
        CopyOnWriteArrayList<NewDrPerm> delList = new CopyOnWriteArrayList<NewDrPerm>(delList_);
        CopyOnWriteArrayList<NewDrPerm> addList = new CopyOnWriteArrayList<NewDrPerm>(addList_);
        ArrayList updateList = new ArrayList(8);
        delList.stream().forEach(x -> {
            Optional<NewDrPerm> first = addList.stream().filter(y -> y.getAppId().equals(x.getAppId()) && y.getEntityNumber().equals(x.getEntityNumber()) && y.getPermItemId().equals(x.getPermItemId())).findFirst();
            if (first.isPresent()) {
                NewDrPerm ldr = (NewDrPerm)addList.get(0);
                ldr.setDataRuleName(String.valueOf(x.getDataRuleId()));
                updateList.add(ldr);
                delList.remove(x);
                addList.remove(ldr);
            }
        });
        delList.stream().forEach(ldr -> {
            Long dataRuleId = ldr.getDataRuleId();
            ldr.setDataRuleId(Long.valueOf(0L));
            ldr.setDataRuleName(String.valueOf(dataRuleId));
        });
        addList.stream().forEach(ldr -> ldr.setDataRuleName("0"));
        diffMap.put("delNewDrPerm", delList);
        diffMap.put("addNewDrPerm", addList);
        diffMap.put("updateNewDrPerm", updateList);
    }

    private static void clearDomainCache(Set<String> roleIdSet, Map<String, Set<String>> newDrChangeAppIdEntNumSetMap, Map<String, Set<Long>> roleUserIdSetMap) {
        if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
            HashSet<Long> allInfluUserIdSet = new HashSet<Long>(8);
            for (String roleId : roleIdSet) {
                Set<Long> userIdSet = roleUserIdSetMap.get(roleId);
                if (null == userIdSet || userIdSet.isEmpty()) continue;
                allInfluUserIdSet.addAll(userIdSet);
                Set<String> newDrChangeAppIdEntNumSet = newDrChangeAppIdEntNumSetMap.get(roleId);
                if (null == newDrChangeAppIdEntNumSet || newDrChangeAppIdEntNumSet.isEmpty()) continue;
                List collect = newDrChangeAppIdEntNumSet.stream().map(x -> {
                    String[] split = x.split("\\|", 2);
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    map.put(split[0], split[1]);
                    return map;
                }).collect(Collectors.toList());
                try {
                    FormConfigFactory.cancelShowFormDataRights(new ArrayList<Long>(userIdSet), collect);
                }
                catch (Exception e) {
                    log.warn("[clearDynamicCache]\u8c03\u7528cancelShowFormDataRights\u5f02\u5e38", (Throwable)e);
                }
            }
            try {
                if (!CollectionUtils.isEmpty(allInfluUserIdSet)) {
                    FormConfigFactory.cancelShowFormRights(new ArrayList(allInfluUserIdSet));
                }
            }
            catch (Exception e) {
                log.warn("[cancelShowFormRights]", (Throwable)e);
            }
        }
    }

    private static void delComRoleCheck(StringBuilder msg, Set<String> roleIdSet) {
        Map comRoleBaseMap = PermRoleHelper.getComRoleBaseMap(roleIdSet, null);
        for (Map.Entry comRoleBase : comRoleBaseMap.entrySet()) {
            ComRole comRole = (ComRole)comRoleBase.getValue();
            Boolean bl = comRole.isSystem();
            if (bl.booleanValue()) {
                msg.append("roleId[").append((String)comRoleBase.getKey()).append("].");
                msg.append(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u201c\u901a\u7528\u89d2\u8272\u201d\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ComRoleService_8", (String)SYSTERM_TYPE, (Object[])new Object[0])).append(";");
                throw new RuntimeException(msg.toString());
            }
            Boolean bl2 = comRole.isEnable();
            if (null == bl2 || bl2.booleanValue()) continue;
            msg.append("roleId[").append((String)comRoleBase.getKey()).append("].");
            msg.append(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c\u7981\u7528\u201d\u72b6\u6001\u7684\u901a\u7528\u89d2\u8272\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ComRoleService_9", (String)SYSTERM_TYPE, (Object[])new Object[0])).append(";");
            throw new RuntimeException(msg.toString());
        }
        Map comRoleIdBizRoleNumMap = PermBusiRoleHelper.getComRoleIdBizRoleNumMap(roleIdSet);
        for (Map.Entry entry : comRoleIdBizRoleNumMap.entrySet()) {
            Set set = (Set)entry.getValue();
            if (null == set || set.isEmpty()) continue;
            msg.append("roleId[").append((String)entry.getKey()).append("].");
            msg.append(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\u3002\u8be5\u901a\u7528\u89d2\u8272\u88ab\u4e1a\u52a1\u89d2\u8272\uff08\u7f16\u7801\uff1a%s\uff09\u6240\u5f15\u7528\u3002", (String)"ComRoleService_10", (String)SYSTERM_TYPE, (Object[])new Object[]{set.toString().replaceAll("\\[", "").replaceAll("\\]", "")})).append(";");
            throw new RuntimeException(msg.toString());
        }
        Map comRoleIdAssignedUTrueNameMap = PermRoleHelper.getComRoleIdAssignedUTrueNameListMap(roleIdSet, (Integer)4, (String)"u.fid asc");
        for (Map.Entry entry : comRoleIdAssignedUTrueNameMap.entrySet()) {
            List list = (List)entry.getValue();
            if (null == list || list.isEmpty()) continue;
            String key = (String)entry.getKey();
            if (list.size() > 3) {
                int count = list.size();
                Iterator iterator = list.iterator();
                StringBuilder names = new StringBuilder();
                for (int i = 0; i < 3; ++i) {
                    names.append((String)iterator.next());
                    if (i == 2) continue;
                    names.append(',');
                }
                msg.append("roleId[").append(key).append("].");
                msg.append(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\u3002\u8be5\u901a\u7528\u89d2\u8272\u5df2\u5206\u914d\u7ed9\u201c%1$s\u201d\u7b49%2$s\u4e2a\u7528\u6237\u3002", (String)"ComRoleService_11", (String)SYSTERM_TYPE, (Object[])new Object[0]), names.toString(), count)).append(";");
                throw new RuntimeException(msg.toString());
            }
            msg.append("roleId[").append(key).append("].");
            msg.append(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\u3002\u901a\u7528\u89d2\u8272\u5df2\u5206\u914d\u7ed9\u7528\u6237\u201c%s\u201d\u3002", (String)"ComRoleService_12", (String)SYSTERM_TYPE, (Object[])new Object[0]), list.toString().replaceAll("\\[", "").replaceAll("\\]", ""))).append(";");
            throw new RuntimeException(msg.toString());
        }
        Map map = PermRoleHelper.getComRoleIdAssignedUgNameListMap(roleIdSet);
        for (Map.Entry entry : map.entrySet()) {
            List value = (List)entry.getValue();
            if (null == value || value.isEmpty()) continue;
            String key = (String)entry.getKey();
            if (value.size() > 3) {
                int count = value.size();
                Iterator iterator = value.iterator();
                StringBuilder names = new StringBuilder();
                for (int i = 0; i < 3; ++i) {
                    names.append((String)iterator.next());
                    if (i == 2) continue;
                    names.append(',');
                }
                msg.append("roleId[").append(key).append("].");
                msg.append(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\u3002\u8be5\u901a\u7528\u89d2\u8272\u5df2\u5206\u914d\u7ed9\u201c%1$s\u201d\u7b49%2$s\u4e2a\u7528\u6237\u7ec4\u3002", (String)"ComRoleService_13", (String)SYSTERM_TYPE, (Object[])new Object[0]), names.toString(), count)).append(";");
                throw new RuntimeException(msg.toString());
            }
            msg.append("roleId[").append(key).append("].");
            msg.append(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\u3002\u8be5\u901a\u7528\u89d2\u8272\u5df2\u5206\u914d\u7ed9\u7528\u6237\u7ec4:\u201c%s\u201d\u3002", (String)"ComRoleService_14", (String)SYSTERM_TYPE, (Object[])new Object[0]), value.toString().replaceAll("\\[", "").replaceAll("\\]", ""))).append(";");
            throw new RuntimeException(msg.toString());
        }
        Map map2 = PermRoleHelper.queryAdmGrpMap(roleIdSet);
        Map map3 = (Map)map2.get("roleIdAdminGrpMap");
        for (Map.Entry roleIdAdminGrp : map3.entrySet()) {
            Set value = (Set)roleIdAdminGrp.getValue();
            if (null == value || value.isEmpty()) continue;
            msg.append("roleId[").append((String)roleIdAdminGrp.getKey()).append("].");
            msg.append(ResManager.loadKDString((String)"\u8be5\u901a\u7528\u89d2\u8272\u5df2\u7ecf\u914d\u7f6e\u201c\u516c\u5f00\u8303\u56f4\u201d\u3002", (String)"ComRoleService_15", (String)SYSTERM_TYPE, (Object[])new Object[0])).append(";");
            throw new RuntimeException(msg.toString());
        }
        ComRoleService.checkCanModifyRole(new ArrayList<String>(roleIdSet));
    }

    private static void checkCanModifyRole(List<String> roleIdList) {
        Map canModifyMap = AdminGroupService.canModifyRole((Long)RequestContext.get().getCurrUserId(), roleIdList);
        for (Map.Entry entry : canModifyMap.entrySet()) {
            String comRoleId = (String)entry.getKey();
            Boolean canModify = (Boolean)entry.getValue();
            if (Boolean.TRUE.equals(canModify)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("roleId[").append(comRoleId).append("].");
            sb.append(ResManager.loadKDString((String)"\u5f53\u524d\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u4fee\u6539\u8be5\u901a\u7528\u89d2\u8272\u3002", (String)"ComRoleService_16", (String)SYSTERM_TYPE, (Object[])new Object[]{comRoleId})).append(";");
            throw new RuntimeException(sb.toString());
        }
    }

    public PermResult del(ComRoleDelReq req) {
        super.checkPerm("perm_role", "4715e1f1000000ac", (Object)req);
        super.commonValidate((Object)req, new Class[]{Default.class, PermLog.class});
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        StringBuilder msg = new StringBuilder();
        msg.append(methodName).append(".");
        Set roleIdSet = req.getRoleIdSet();
        ComRoleService.delComRoleCheck(msg, roleIdSet);
        try (TXHandle txHandle = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"perm_roleperm", (QFilter[])new QFilter[]{new QFilter("roleid", "in", (Object)roleIdSet)});
                DynamicObject[] arrRoleFieldPerm = BusinessDataServiceHelper.load((String)"perm_rolefieldperm", (String)"fieldperm.id", (QFilter[])new QFilter[]{new QFilter("role", "in", (Object)roleIdSet)});
                ArrayList<String> forDelFieldPermId = new ArrayList<String>();
                if (null != arrRoleFieldPerm) {
                    for (DynamicObject dObj : arrRoleFieldPerm) {
                        String fieldPermId = dObj.getString("fieldperm.id");
                        forDelFieldPermId.add(fieldPermId);
                    }
                }
                if (forDelFieldPermId != null && forDelFieldPermId.size() > 0) {
                    DeleteServiceHelper.delete((String)"perm_fieldperm", (QFilter[])new QFilter[]{new QFilter("id", "in", forDelFieldPermId)});
                }
                DeleteServiceHelper.delete((String)"perm_rolefieldperm", (QFilter[])new QFilter[]{new QFilter("role", "in", (Object)roleIdSet)});
                DynamicObject[] arrRoleDataPerm = BusinessDataServiceHelper.load((String)"perm_roledataperm", (String)"datapermid.id", (QFilter[])new QFilter[]{new QFilter("role", "in", (Object)roleIdSet)});
                ArrayList<String> forDelDataPermId = new ArrayList<String>();
                if (arrRoleDataPerm != null) {
                    for (DynamicObject dObj : arrRoleDataPerm) {
                        String dataPermId = dObj.getString("datapermid.id");
                        forDelDataPermId.add(dataPermId);
                    }
                }
                if (forDelDataPermId != null && forDelDataPermId.size() > 0) {
                    DeleteServiceHelper.delete((String)"perm_dataperm", (QFilter[])new QFilter[]{new QFilter("id", "in", forDelDataPermId)});
                }
                DeleteServiceHelper.delete((String)"perm_roledataperm", (QFilter[])new QFilter[]{new QFilter("role", "in", (Object)roleIdSet)});
                DrHelper.delByComRoleIdSet((Set)roleIdSet);
                DeleteServiceHelper.delete((String)"perm_role", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)roleIdSet)});
                CacheMrg.clearAllCache();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.warn("ComRoleService.{} error", (Object)methodName, (Object)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
        Map roleUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap((Set)roleIdSet);
        HashMap<String, Object> sign2PermLogParaMap = new HashMap<String, Object>(8);
        sign2PermLogParaMap.put("permLogReq", req.getPermLogReq());
        sign2PermLogParaMap.put("roleIdSet", roleIdSet);
        sign2PermLogParaMap.put("addFunPermMap", null);
        sign2PermLogParaMap.put("delFunPermMap", null);
        sign2PermLogParaMap.put("addFieldPermMap", null);
        sign2PermLogParaMap.put("delFieldPermMap", null);
        sign2PermLogParaMap.put("addNewDrPermMap", null);
        sign2PermLogParaMap.put("delNewDrPermMap", null);
        sign2PermLogParaMap.put("addNewDrPrPermMap", null);
        sign2PermLogParaMap.put("delNewDrPrPermMap", null);
        sign2PermLogParaMap.put("addComRoleAdminGrpMap", null);
        sign2PermLogParaMap.put("delComRoleAdminGrpMap", null);
        sign2PermLogParaMap.put("dealChild", Boolean.FALSE);
        this.sign2PermLog(sign2PermLogParaMap, roleUserIdSetMap);
        return PermResult.ok();
    }

    public PermResult enableChange(ComRoleEnableChangeReq req) {
        super.checkPerm("perm_role", req.isEnable() ? "4730fc5d000000ac" : "47160c2b000000ac", (Object)req);
        super.commonValidate((Object)req, new Class[]{Default.class, PermLog.class});
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        Set roleIdSet = req.getRoleIdSet();
        ComRoleService.checkCanModifyRole(new ArrayList<String>(roleIdSet));
        try (TXHandle txHandle = TX.required();){
            try {
                PermRoleHelper.enableChange((ComRoleEnableChangeReq)req);
                CacheMrg.clearAllCache();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.warn("ComRoleService.{} error", (Object)methodName, (Object)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
        Map roleUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap((Set)roleIdSet);
        HashMap<String, Object> sign2PermLogParaMap = new HashMap<String, Object>(8);
        sign2PermLogParaMap.put("permLogReq", req.getPermLogReq());
        sign2PermLogParaMap.put("roleIdSet", roleIdSet);
        sign2PermLogParaMap.put("addFunPermMap", null);
        sign2PermLogParaMap.put("delFunPermMap", null);
        sign2PermLogParaMap.put("addFieldPermMap", null);
        sign2PermLogParaMap.put("delFieldPermMap", null);
        sign2PermLogParaMap.put("addNewDrPermMap", null);
        sign2PermLogParaMap.put("delNewDrPermMap", null);
        sign2PermLogParaMap.put("addNewDrPrPermMap", null);
        sign2PermLogParaMap.put("delNewDrPrPermMap", null);
        sign2PermLogParaMap.put("addComRoleAdminGrpMap", null);
        sign2PermLogParaMap.put("delComRoleAdminGrpMap", null);
        sign2PermLogParaMap.put("dealChild", Boolean.FALSE);
        this.sign2PermLog(sign2PermLogParaMap, roleUserIdSetMap);
        return PermResult.ok();
    }

    public GetComRolePageListResp getPageList(GetComRoleListReq req, PermPageReq pageReq) {
        super.checkPerm("perm_role", "47150e89000000ac", (Object)req);
        super.commonValidate((Object)req, new Class[]{Default.class});
        super.commonValidate((Object)pageReq, new Class[]{Default.class});
        List list = PermRoleHelper.getList((GetComRoleListReq)req);
        int pageNo = pageReq.getPageNo();
        int pageSize = pageReq.getPageSize();
        List pageRows = list.stream().skip((pageNo - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        GetComRolePageListResp resp = new GetComRolePageListResp();
        resp.setRows(pageRows);
        resp.setPageNo(pageNo);
        resp.setPageSize(pageSize);
        resp.setTotalCount((long)list.size());
        return resp;
    }

    public GetComRoleListResp getList(GetComRoleListReq req) {
        super.checkPerm("perm_role", "47150e89000000ac", (Object)req);
        super.commonValidate((Object)req, new Class[]{Default.class});
        List list = PermRoleHelper.getList((GetComRoleListReq)req);
        GetComRoleListResp resp = new GetComRoleListResp();
        resp.setList(list);
        return resp;
    }

    public GetComRoleAssignedDimUserResp getAssignedDimUser(GetComRoleAssignedDimUserReq req) {
        super.checkPerm("perm_role", "80513208000000ac", (Object)req);
        super.commonValidate((Object)req, new Class[]{Default.class});
        List list = OrgUserHelper.getByRoleAndDim((String)req.getRoleId(), null, null, null, (String)req.getDimType());
        List dimUserList = list.stream().map(x -> {
            DimUser dimUser = new DimUser();
            dimUser.setDimType(x.getFdimtype());
            dimUser.setDimId(x.getForgid());
            String fisincludesuborg = x.getFisincludesuborg();
            dimUser.setIncludeSub(StringUtils.isEmpty((String)fisincludesuborg.trim()) || "0".equals(fisincludesuborg) ? Boolean.FALSE : Boolean.TRUE);
            dimUser.setStartTime(x.getFstarttime());
            dimUser.setEndTime(x.getFendtime());
            dimUser.setUserId(x.getFuserid());
            return dimUser;
        }).collect(Collectors.toList());
        GetComRoleAssignedDimUserResp resp = new GetComRoleAssignedDimUserResp();
        resp.setDimUserList(dimUserList);
        return resp;
    }

    public PermCheckResp beforeSaveCheck(PermBeforeSaveCheckReq req) {
        if (null == req) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        Map needCheckBeanMap = req.getNeedCheckBeanMap();
        if (null == needCheckBeanMap || needCheckBeanMap.isEmpty()) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        if (null == checkNeedParamMap) {
            req.setCheckNeedParamMap(new HashMap(1));
        }
        boolean pass = true;
        HashMap<Integer, ComRoleImportBean> passedMap = new HashMap<Integer, ComRoleImportBean>(10);
        LinkedHashMap<Integer, List<String>> failedErrorMap = new LinkedHashMap<Integer, List<String>>(8);
        LinkedHashMap<String, List<String>> numFailedErrorMap = new LinkedHashMap<String, List<String>>(8);
        boolean failFast = req.isFailFast();
        ComRoleService.fullOperationTypeEnum(req);
        for (Map.Entry one : needCheckBeanMap.entrySet()) {
            ComRoleImportBean willSaveBean = (ComRoleImportBean)one.getValue();
            try {
                boolean oneSuccess = this.doBeforeSaveCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
                if (!oneSuccess && failFast) {
                    pass = false;
                    break;
                }
                if (oneSuccess || failFast) continue;
                pass = false;
            }
            catch (Throwable throwable) {
                log.warn(throwable);
                throw throwable;
            }
        }
        super.beforeSaveCheckExt(req);
        return new PermCheckResp(pass, passedMap, failedErrorMap, numFailedErrorMap);
    }

    private static void fullOperationTypeEnum(PermBeforeSaveCheckReq req) {
        Map needCheckBeanMap = req.getNeedCheckBeanMap();
        if (null == needCheckBeanMap || needCheckBeanMap.isEmpty()) {
            return;
        }
        HashMap checkNeedParamMap = req.getCheckNeedParamMap();
        if (null == checkNeedParamMap) {
            checkNeedParamMap = new HashMap(8);
            req.setCheckNeedParamMap(checkNeedParamMap);
        }
        EnumsImportType enumsImportType = req.getEnumsImportType();
        for (Map.Entry one : needCheckBeanMap.entrySet()) {
            ComRoleImportBean value = (ComRoleImportBean)one.getValue();
            if (null == value) continue;
            if (EnumsImportType.NEW == enumsImportType) {
                value.setOperationTypeEnum(OperationTypeEnum.ADD);
                continue;
            }
            if (EnumsImportType.OVERRIDE == enumsImportType) {
                value.setOperationTypeEnum(OperationTypeEnum.UPDATE);
                continue;
            }
            if (EnumsImportType.OVERRIDENEW != enumsImportType) continue;
            String number = value.getNumber();
            if (StringUtils.isEmpty((String)number)) {
                value.setOperationTypeEnum(OperationTypeEnum.ADD);
                continue;
            }
            Map roleNumberComRoleMap = null == checkNeedParamMap.get("roleNumberComRoleMap") ? PermRoleHelper.getRoleIdOrNumOrNameComRoleMap((Set)Sets.newHashSet((Object[])new String[]{value.getNumber()}), (String)"number") : (Map)checkNeedParamMap.get("roleNumberComRoleMap");
            Set comRoles = (Set)roleNumberComRoleMap.get(number);
            if (null == comRoles || comRoles.isEmpty()) {
                value.setOperationTypeEnum(OperationTypeEnum.ADD);
                continue;
            }
            value.setOperationTypeEnum(OperationTypeEnum.UPDATE);
        }
    }

    private boolean doBeforeSaveCheck(PermBeforeSaveCheckReq req, ComRoleImportBean willSaveBean, Map<Integer, ComRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        boolean checkResult = this.importCommonCheck(req, willSaveBean, failedErrorMap, numFailedErrorMap);
        boolean failFast = req.isFailFast();
        if (failFast) {
            return checkResult;
        }
        OperationTypeEnum operationTypeEnum = willSaveBean.getOperationTypeEnum();
        switch (operationTypeEnum) {
            case ADD: {
                checkResult = this.newImportCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap, checkResult);
                break;
            }
            case UPDATE: {
                checkResult = this.overrideImportCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap, checkResult);
                break;
            }
        }
        return checkResult;
    }

    private boolean overrideImportCheck(PermBeforeSaveCheckReq req, ComRoleImportBean willSaveBean, Map<Integer, ComRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap, boolean commonCheckResult) {
        List funcPermList;
        boolean checkResult = true;
        boolean failFast = req.isFailFast();
        int roleLineNum = willSaveBean.getLineNum();
        String roleNum = willSaveBean.getNumber();
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        List keyFieldList = req.getKeyFieldList();
        if (null == keyFieldList || keyFieldList.isEmpty()) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u66f4\u65b0\u5bfc\u5165\u5339\u914d\u5b57\u6bb5\u4e0b\u62c9\u5217\u8868\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ComRoleService_17", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return commonCheckResult && checkResult;
            }
        } else {
            if (keyFieldList.contains("number") && StringUtils.isEmpty((String)roleNum)) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u66f4\u65b0\u5df2\u6709\u6570\u636e\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ComRoleService_18", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                checkResult = false;
                if (failFast) {
                    return commonCheckResult && checkResult;
                }
            }
            if (keyFieldList.contains("number") && StringUtils.isNotEmpty((String)roleNum)) {
                Map roleNumCanModifyRoleMap;
                Boolean can;
                Map roleNumberComRoleMap = null == checkNeedParamMap.get("roleNumberComRoleMap") ? PermRoleHelper.getRoleIdOrNumOrNameComRoleMap(null, (String)"number") : (Map)checkNeedParamMap.get("roleNumberComRoleMap");
                Set comRoleSet = (Set)roleNumberComRoleMap.get(roleNum);
                if (null == comRoleSet || comRoleSet.isEmpty()) {
                    this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"BusiRoleService_16", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleNum));
                    checkResult = false;
                    if (failFast) {
                        return commonCheckResult && checkResult;
                    }
                }
                if (!(can = (Boolean)(roleNumCanModifyRoleMap = null == checkNeedParamMap.get("roleNumCanModifyRoleMap") ? AdminGroupService.canModifyRole((Long)RequestContext.get().getCurrUserId(), (Set)Sets.newHashSet((Object[])new String[]{roleNum})) : (Map)checkNeedParamMap.get("roleNumCanModifyRoleMap")).get(roleNum)).booleanValue()) {
                    this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"ComRoleService_20", (String)SYSTERM_TYPE, (Object[])new Object[0]), roleNum));
                    checkResult = false;
                    if (failFast) {
                        return commonCheckResult && checkResult;
                    }
                }
            }
        }
        String useScope = willSaveBean.getUseScope();
        List comRoleAdminGrpList = willSaveBean.getComRoleAdminGrpList();
        if (EnumsUseScope.ASSIGN.getType().equals(useScope) && null != comRoleAdminGrpList && !comRoleAdminGrpList.isEmpty()) {
            Map roleNumAdmGrpSetMap = null == checkNeedParamMap.get("roleNumAdmGrpSetMap") ? PermRoleHelper.getAdmGrpSetMap((Set)Sets.newHashSet((Object[])new String[]{roleNum}), (String)"number") : (Map)checkNeedParamMap.get("roleNumAdmGrpSetMap");
            Set admGrpSet = (Set)roleNumAdmGrpSetMap.get(roleNum);
            for (ComRoleAdminGrp comRoleAdminGrp : comRoleAdminGrpList) {
                Set admGrpEntryIdSet;
                int lineNum = comRoleAdminGrp.getLineNum();
                String entryId = comRoleAdminGrp.getEntryId();
                if (StringUtils.isEmpty((String)entryId)) {
                    ComRoleAdminGrp first;
                    if (null == admGrpSet || admGrpSet.isEmpty() || null == (first = (ComRoleAdminGrp)admGrpSet.stream().filter(x -> Objects.equals(comRoleAdminGrp.getRoleNumber(), x.getRoleNumber()) && Objects.equals(comRoleAdminGrp.getAdminGroupNumber(), x.getAdminGroupNumber())).findFirst().orElse(null))) continue;
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u516c\u5f00\u8303\u56f4\u7684\u7ba1\u7406\u5458\u7ec4\uff0c\u65e0\u6cd5\u8ffd\u52a0\u3002", (String)"ComRoleService_21", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                    checkResult = false;
                    if (!failFast) continue;
                    return commonCheckResult && checkResult;
                }
                if (null == admGrpSet || admGrpSet.isEmpty() || (admGrpEntryIdSet = admGrpSet.stream().map(ComRoleAdminGrp::getEntryId).collect(Collectors.toSet())).contains(entryId)) continue;
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6b64\u89d2\u8272\u6ca1\u6709\u8be5\u7ba1\u7406\u5458\u7ec4\uff0c\u65e0\u6cd5\u66f4\u65b0\u6570\u636e\u3002", (String)"ComRoleService_22", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                checkResult = false;
                if (!failFast) continue;
                return commonCheckResult && checkResult;
            }
        }
        if (null != (funcPermList = willSaveBean.getFuncPermList()) && !funcPermList.isEmpty()) {
            Map roleNumPermSetMap = null == checkNeedParamMap.get("roleNumPermSetMap") ? PermRoleHelper.getRolePermSetMap((Set)Sets.newHashSet((Object[])new String[]{roleNum}), (String)"number") : (Map)checkNeedParamMap.get("roleNumPermSetMap");
            Set roleFuncPermSet = (Set)roleNumPermSetMap.get(roleNum);
            for (ComRoleFuncPerm comRoleFuncPerm : funcPermList) {
                Set permEntryIdSet;
                if (null == comRoleFuncPerm) continue;
                int lineNum = comRoleFuncPerm.getLineNum();
                String entryId = comRoleFuncPerm.getEntryId();
                if (StringUtils.isEmpty((String)entryId)) {
                    ComRoleFuncPerm first;
                    if (null == roleFuncPermSet || roleFuncPermSet.isEmpty() || null == (first = (ComRoleFuncPerm)roleFuncPermSet.stream().filter(x -> Objects.equals(comRoleFuncPerm.getRoleNumber(), x.getRoleNumber()) && Objects.equals(comRoleFuncPerm.getAppNumber(), x.getAppNumber()) && Objects.equals(comRoleFuncPerm.getEntityNumber(), x.getEntityNumber()) && Objects.equals(comRoleFuncPerm.getPermItemNumber(), x.getPermItemNumber())).findFirst().orElse(null))) continue;
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u529f\u80fd\u6743\u9650\uff0c\u65e0\u6cd5\u8ffd\u52a0\u3002", (String)"ComRoleService_24", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                    checkResult = false;
                    if (!failFast) continue;
                    return commonCheckResult && checkResult;
                }
                if (null == roleFuncPermSet || roleFuncPermSet.isEmpty() || (permEntryIdSet = roleFuncPermSet.stream().map(ComRoleFuncPerm::getEntryId).collect(Collectors.toSet())).contains(entryId)) continue;
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6b64\u89d2\u8272\u6ca1\u6709\u8be5\u529f\u80fd\u6743\u9650\uff0c\u65e0\u6cd5\u66f4\u65b0\u6570\u636e\u3002", (String)"ComRoleService_25", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                checkResult = false;
                if (!failFast) continue;
                return commonCheckResult && checkResult;
            }
        }
        if (commonCheckResult && checkResult) {
            passedMap.put(roleLineNum, willSaveBean);
        }
        return commonCheckResult && checkResult;
    }

    private boolean newImportCheck(PermBeforeSaveCheckReq req, ComRoleImportBean willSaveBean, Map<Integer, ComRoleImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap, boolean commonCheckResult) {
        Set curCreateAdminGrpNameSet;
        Sets.SetView validAdmGrpNameSet;
        String[] split;
        Map roleNameComRoleMap;
        Map roleNumberComRoleMap;
        String currentLangRoleName;
        boolean checkResult = true;
        boolean failFast = req.isFailFast();
        int roleLineNum = willSaveBean.getLineNum();
        String roleNum = willSaveBean.getNumber();
        String name = willSaveBean.getName();
        if (StringUtils.isEmpty((String)(roleNum + name))) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6dfb\u52a0\u65b0\u6570\u636e\u65f6\uff0c\u7f16\u7801\u3001\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ComRoleService_27", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)(currentLangRoleName = willSaveBean.getName()))) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5f53\u524d\u8bed\u8a00\u4e0b\u672a\u8bbe\u7f6e\u89d2\u8272\u540d\u79f0\u3002", (String)"ComRoleService_28", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return commonCheckResult && checkResult;
            }
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        String currentNumber = willSaveBean.getNumber();
        Map map = roleNumberComRoleMap = null == checkNeedParamMap.get("roleNumberComRoleMap") ? PermRoleHelper.getRoleIdOrNumOrNameComRoleMap((Set)Sets.newHashSet((Object[])new String[]{currentNumber}), (String)"number") : (Map)checkNeedParamMap.get("roleNumberComRoleMap");
        if (roleNumberComRoleMap.containsKey(currentNumber)) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u5bfc\u5165\u3002", (String)"ComRoleService_29", (String)SYSTERM_TYPE, (Object[])new Object[0]), currentNumber));
            checkResult = false;
            if (failFast) {
                return commonCheckResult && checkResult;
            }
        }
        Map map2 = roleNameComRoleMap = null == checkNeedParamMap.get("roleNameComRoleMap") ? PermRoleHelper.getRoleIdOrNumOrNameComRoleMap((Set)Sets.newHashSet((Object[])new String[]{currentLangRoleName}), (String)"name") : (Map)checkNeedParamMap.get("roleNameComRoleMap");
        if (roleNameComRoleMap.containsKey(currentLangRoleName)) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u540d\u79f0\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u5bfc\u5165\u3002", (String)"ComRoleService_30", (String)SYSTERM_TYPE, (Object[])new Object[0]), currentLangRoleName));
            checkResult = false;
            if (failFast) {
                return commonCheckResult && checkResult;
            }
        }
        Map admGrpMapOfUser = null == checkNeedParamMap.get("admGrpMapOfUser") ? AdminGroupHelper.getAdmGrpMap((Long)RequestContext.get().getCurrUserId(), (String)"name") : (Map)checkNeedParamMap.get("admGrpMapOfUser");
        Set curAdminGrpNameSet = admGrpMapOfUser.keySet();
        String createAdminGrpName = willSaveBean.getCreateAdminGrpName();
        if (StringUtils.isNotEmpty((String)createAdminGrpName) && null != (split = createAdminGrpName.split(",")) && split.length > 0 && (null == (validAdmGrpNameSet = Sets.intersection(curCreateAdminGrpNameSet = Arrays.stream(split).collect(Collectors.toSet()), curAdminGrpNameSet)) || validAdmGrpNameSet.isEmpty())) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5728\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u201c%1$s\u201d\u5185\u3002", (String)"ComRoleService_35", (String)SYSTERM_TYPE, (Object[])new Object[0]), Strings.join(curCreateAdminGrpNameSet, (String)"\u3001")));
            checkResult = false;
            if (failFast) {
                return commonCheckResult && checkResult;
            }
        }
        if (commonCheckResult && checkResult) {
            passedMap.put(roleLineNum, willSaveBean);
        }
        return commonCheckResult && checkResult;
    }

    private boolean importCommonCheck(PermBeforeSaveCheckReq req, ComRoleImportBean willSaveBean, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        List funcPermList;
        String dimTypeNumBig;
        String groupNum;
        String enable;
        String useScope;
        String[] split;
        String[] split2;
        String id;
        boolean checkResult = true;
        boolean failFast = req.isFailFast();
        int roleLineNum = willSaveBean.getLineNum();
        String roleNum = willSaveBean.getNumber();
        OperationTypeEnum operationTypeEnum = willSaveBean.getOperationTypeEnum();
        if (null == operationTypeEnum) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u3002", (String)"ComRoleService_31", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isNotEmpty((String)(id = willSaveBean.getId())) && id.length() > 18) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5185\u7801\u8d85\u8fc718\u4f4d\uff0c\u5efa\u8bae\u4f7f\u7528\u65b0\u6a21\u677f\u5bfc\u5165\u6570\u636e\u3002", (String)"ComRoleService_56", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        String bizDomainNumber = willSaveBean.getBizDomainNumber();
        if (StringUtils.isNotEmpty((String)bizDomainNumber)) {
            AppInfo appInfo = null;
            appInfo = null == checkNeedParamMap.get("allAppInfo") ? AppMetadataCache.getAppInfo((String)bizDomainNumber) : (AppInfo)((Map)checkNeedParamMap.get("allAppInfo")).get(bizDomainNumber);
            if (null == appInfo) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_33", (String)SYSTERM_TYPE, (Object[])new Object[0]), bizDomainNumber));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            } else {
                willSaveBean.setBizDomainId(appInfo.getId());
            }
        }
        boolean checkedUserType = false;
        String userTypeName = willSaveBean.getUserTypeName();
        if (StringUtils.isNotEmpty((String)userTypeName) && null != (split2 = userTypeName.split(",")) && split2.length > 0) {
            if (split2.length > 5) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u201c\u9002\u7528\u7528\u6237\u7c7b\u578b\u201d\u957f\u5ea6\u8fc7\u957f\uff0c\u5efa\u8bae\u52fe\u9009\u4e0d\u8d85\u8fc75\u9879\u3002", (String)"ComRoleService_4", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                checkResult = false;
                checkedUserType = true;
                if (failFast) {
                    return checkResult;
                }
            }
            Map bosUserTypeMap = null == checkNeedParamMap.get("bosUserTypeMap") ? PermCommonUtil.getBosUserTypeMap() : (Map)checkNeedParamMap.get("bosUserTypeMap");
            HashSet bosUserTypeNameSet = new HashSet(bosUserTypeMap.values());
            Set curUserTypeNameSet = Arrays.stream(split2).collect(Collectors.toSet());
            Sets.SetView notInUserTypeName = Sets.difference(curUserTypeNameSet, bosUserTypeNameSet);
            if (null != notInUserTypeName && !notInUserTypeName.isEmpty()) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u9002\u7528\u7528\u6237\u7c7b\u578b\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_34", (String)SYSTERM_TYPE, (Object[])new Object[0]), Strings.join((Iterable)notInUserTypeName, (String)"\u3001")));
                checkResult = false;
                checkedUserType = true;
                if (failFast) {
                    return checkResult;
                }
            } else {
                HashSet curValidUserTypeIdSet = new HashSet(8);
                Sets.SetView curValidUserTypeNameSet = Sets.intersection(curUserTypeNameSet, bosUserTypeNameSet);
                if (null != curValidUserTypeNameSet && !curValidUserTypeNameSet.isEmpty()) {
                    for (Map.Entry bosUserType : bosUserTypeMap.entrySet()) {
                        if (!curValidUserTypeNameSet.contains(bosUserType.getValue())) continue;
                        curValidUserTypeIdSet.add(bosUserType.getKey());
                    }
                    willSaveBean.setUserType(String.join((CharSequence)",", curValidUserTypeIdSet.stream().map(String::valueOf).collect(Collectors.toSet())));
                    checkedUserType = true;
                }
            }
        }
        String userTypeStr = willSaveBean.getUserType();
        if (!checkedUserType && StringUtils.isNotEmpty((String)userTypeStr) && null != (split = userTypeStr.split(",")) && split.length > 0) {
            Set<String> collect = Arrays.stream(split).filter(x -> StringUtils.isNotEmpty((String)x)).collect(Collectors.toSet());
            if ((split = collect.toArray(new String[0])).length > 5) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u201c\u9002\u7528\u7528\u6237\u7c7b\u578b\u201d\u957f\u5ea6\u8fc7\u957f\uff0c\u5efa\u8bae\u52fe\u9009\u4e0d\u8d85\u8fc75\u9879\u3002", (String)"ComRoleService_4", (String)SYSTERM_TYPE, (Object[])new Object[0]));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            }
            Map bosUserTypeMap = null == checkNeedParamMap.get("bosUserTypeMap") ? PermCommonUtil.getBosUserTypeMap() : (Map)checkNeedParamMap.get("bosUserTypeMap");
            HashSet bosUserTypeIdSet = new HashSet(bosUserTypeMap.keySet());
            Set curUserTypeIdSet = Arrays.stream(split).map(x -> Long.valueOf(x)).collect(Collectors.toSet());
            Sets.SetView notInUserTypeId = Sets.difference(curUserTypeIdSet, bosUserTypeIdSet);
            if (null != notInUserTypeId && !notInUserTypeId.isEmpty()) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u9002\u7528\u7528\u6237\u7c7b\u578b\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_34", (String)SYSTERM_TYPE, (Object[])new Object[0]), Strings.join((Iterable)notInUserTypeId.stream().map(String::valueOf).collect(Collectors.toSet()), (String)"\u3001")));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            } else {
                Sets.SetView curValidUserTypeIdSet = Sets.intersection(curUserTypeIdSet, bosUserTypeIdSet);
                if (null != curValidUserTypeIdSet && !curValidUserTypeIdSet.isEmpty()) {
                    willSaveBean.setUserType(String.join((CharSequence)",", curValidUserTypeIdSet.stream().map(String::valueOf).collect(Collectors.toSet())));
                }
            }
        }
        Map admGrpMapOfUser = null == checkNeedParamMap.get("admGrpMapOfUser") ? AdminGroupHelper.getAdmGrpMap((Long)RequestContext.get().getCurrUserId(), (String)"name") : (Map)checkNeedParamMap.get("admGrpMapOfUser");
        Set curAdminGrpNameSet = admGrpMapOfUser.keySet();
        String createAdminGrpName = willSaveBean.getCreateAdminGrpName();
        if (StringUtils.isNotEmpty((String)createAdminGrpName)) {
            String[] split3 = createAdminGrpName.split(",");
            if (null != split3 && split3.length > 0) {
                Map createAdminGrpMap;
                Set validAdmGroup;
                Sets.SetView inValidAdmGroup;
                Set curCreateAdminGrpNameSet = Arrays.stream(split3).collect(Collectors.toSet());
                Sets.SetView validAdmGrpNameSet = Sets.intersection(curCreateAdminGrpNameSet, curAdminGrpNameSet);
                if (null != validAdmGrpNameSet && !validAdmGrpNameSet.isEmpty()) {
                    AdmGroup smallestAdmGrp = AdminGroupHelper.getNumSmallest((Set)validAdmGrpNameSet);
                    if (null == smallestAdmGrp) {
                        this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u6700\u5c0f\u7684\u7ba1\u7406\u5458\u7ec4\uff1a%1$s\u3002", (String)"ComRoleService_36", (String)SYSTERM_TYPE, (Object[])new Object[0]), Strings.join((Iterable)validAdmGrpNameSet, (String)"\u3001")));
                        checkResult = false;
                        if (failFast) {
                            return checkResult;
                        }
                    } else {
                        willSaveBean.setCreateAdminGrp(String.valueOf(smallestAdmGrp.getId()));
                    }
                }
                if (null != (inValidAdmGroup = Sets.difference(curCreateAdminGrpNameSet, validAdmGroup = (createAdminGrpMap = null == checkNeedParamMap.get("createAdminGrpMap") ? AdminGroupHelper.getAdminGrpMap(null, (String)"name") : (Map)checkNeedParamMap.get("createAdminGrpMap")).keySet())) && !inValidAdmGroup.isEmpty()) {
                    this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_37", (String)SYSTERM_TYPE, (Object[])new Object[0]), Strings.join((Iterable)inValidAdmGroup, (String)"\u3001")));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
            }
        } else {
            AdmGroup smallestAdmGrp = AdminGroupHelper.getNumSmallest(curAdminGrpNameSet);
            if (null == smallestAdmGrp) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u6700\u5c0f\u7684\u7ba1\u7406\u5458\u7ec4\uff1a%1$s\u3002", (String)"ComRoleService_36", (String)SYSTERM_TYPE, (Object[])new Object[0]), Strings.join(curAdminGrpNameSet, (String)"\u3001")));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            } else {
                willSaveBean.setCreateAdminGrp(String.valueOf(smallestAdmGrp.getId()));
            }
        }
        if (StringUtils.isNotEmpty((String)(useScope = willSaveBean.getUseScope()))) {
            Map useScopeMap;
            Map map = useScopeMap = null == checkNeedParamMap.get("useScopeMap") ? EnumsUseScope.getMap() : (Map)checkNeedParamMap.get("useScopeMap");
            if (!useScopeMap.containsKey(useScope)) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u516c\u5f00\u72b6\u6001\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_38", (String)SYSTERM_TYPE, (Object[])new Object[0]), useScope));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            } else {
                willSaveBean.setUseScope(useScope);
            }
        }
        if (StringUtils.isNotEmpty((String)(enable = willSaveBean.getEnable()))) {
            Map enableMap;
            Map map = enableMap = null == checkNeedParamMap.get("enableMap") ? EnumsEnable.getMap() : (Map)checkNeedParamMap.get("enableMap");
            if (!enableMap.containsKey(enable)) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_39", (String)SYSTERM_TYPE, (Object[])new Object[0]), enable));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            } else {
                willSaveBean.setEnable(enable);
            }
        }
        if (StringUtils.isNotEmpty((String)(groupNum = willSaveBean.getGroupNum()))) {
            Map roleGroupMap = null == checkNeedParamMap.get("roleGroupMap") ? ComRoleGroupHelper.getNumberGroupMap((Set)Sets.newHashSet((Object[])new String[]{groupNum})) : (Map)checkNeedParamMap.get("roleGroupMap");
            Set comRoleGroups = (Set)roleGroupMap.get(groupNum);
            if (null == comRoleGroups || comRoleGroups.isEmpty()) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u5206\u7ec4\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_40", (String)SYSTERM_TYPE, (Object[])new Object[0]), groupNum));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            } else {
                ComRoleGroup first = comRoleGroups.stream().findFirst().orElse(null);
                if (null != first) {
                    willSaveBean.setGroupId(first.getId());
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(dimTypeNumBig = willSaveBean.getDimTypeId()))) {
            Map bigPermCtrlTypeMap = null == checkNeedParamMap.get("bigPermCtrlTypeMap") ? IsoDimHelper.getBigPermCtrlTypeMap((PermCtrlTypeReq)new PermCtrlTypeReq(null, null, null, null, null)) : (Map)checkNeedParamMap.get("bigPermCtrlTypeMap");
            PermCtrlType bigPermCtrlType = (PermCtrlType)bigPermCtrlTypeMap.get(dimTypeNumBig);
            if (null == bigPermCtrlType) {
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u7c7b\u578b\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_41", (String)SYSTERM_TYPE, (Object[])new Object[0]), dimTypeNumBig));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            } else {
                willSaveBean.setDimTypeId(dimTypeNumBig);
            }
        }
        List comRoleAdminGrpList = willSaveBean.getComRoleAdminGrpList();
        if (Objects.equals(EnumsUseScope.ASSIGN.getType(), useScope) && null != comRoleAdminGrpList && !comRoleAdminGrpList.isEmpty()) {
            for (ComRoleAdminGrp comRoleAdminGrp : comRoleAdminGrpList) {
                boolean rolemodifiable;
                String rolemodifiableStr;
                Map rolemodifiableMap;
                int lineNum = comRoleAdminGrp.getLineNum();
                String adminGroupNumber = comRoleAdminGrp.getAdminGroupNumber();
                if (StringUtils.isNotEmpty((String)adminGroupNumber)) {
                    Map numAdmGroupMap;
                    Map map = numAdmGroupMap = null == checkNeedParamMap.get("numAdmGroupMap") ? AdminGroupHelper.getAdminGrpMap((Set)Sets.newHashSet((Object[])new String[]{adminGroupNumber}), (String)"number") : (Map)checkNeedParamMap.get("numAdmGroupMap");
                    if (!numAdmGroupMap.containsKey(adminGroupNumber)) {
                        this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_42", (String)SYSTERM_TYPE, (Object[])new Object[0]), adminGroupNumber));
                        checkResult = false;
                        if (failFast) {
                            return checkResult;
                        }
                    } else {
                        String createAdminGrp = willSaveBean.getCreateAdminGrp();
                        Map admGrpF7Map = null == checkNeedParamMap.get("admGrpF7Map") ? AdminGroupHelper.getAdmGrpF7Map((String)"number", null) : (Map)checkNeedParamMap.get("admGrpF7Map");
                        Set admGroups = (Set)admGrpF7Map.get(adminGroupNumber);
                        if (null == admGroups || admGroups.isEmpty()) {
                            this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5206\u7ec4\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7528\u6237\u7684\u7ba1\u7406\u5458\u7ec4\u8303\u56f4\u5185\u3002", (String)"ComRoleService_43", (String)SYSTERM_TYPE, (Object[])new Object[0]), adminGroupNumber));
                            checkResult = false;
                            if (failFast) {
                                return checkResult;
                            }
                        }
                    }
                }
                if ((rolemodifiableMap = null == checkNeedParamMap.get("rolemodifiableMap") ? EnumsYesNo.getMap() : (Map)checkNeedParamMap.get("rolemodifiableMap")).containsKey(rolemodifiableStr = (rolemodifiable = comRoleAdminGrp.isModifiable()) ? "1" : "0")) continue;
                this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4fee\u6539\u901a\u7528\u89d2\u8272\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_44", (String)SYSTERM_TYPE, (Object[])new Object[0]), rolemodifiableStr));
                checkResult = false;
                if (!failFast) continue;
                return checkResult;
            }
        }
        if (Objects.equals(EnumsUseScope.ASSIGN.getType(), useScope) && (null == comRoleAdminGrpList || comRoleAdminGrpList.isEmpty())) {
            this.wrapFaildMsg(roleLineNum, roleNum, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u201c\u516c\u5f00\u72b6\u6001\u201d\u4e3a\u201c\u5206\u914d\u201d\u65f6\uff0c\u9700\u7ef4\u62a4\u201c\u516c\u5f00\u8303\u56f4\u201d\u3002", (String)"ComRoleService_5", (String)SYSTERM_TYPE, (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (null != (funcPermList = willSaveBean.getFuncPermList()) && !funcPermList.isEmpty()) {
            Map appNumExistMap = null == checkNeedParamMap.get("appNumExistMap") ? PermVerifyUtil.getExistMapByNum((String)"bos_devportal_bizapp", null) : (Map)checkNeedParamMap.get("appNumExistMap");
            Map entNumExistMap = null == checkNeedParamMap.get("entNumExistMap") ? PermVerifyUtil.getExistMapByNum((String)"bos_entityobject", null) : (Map)checkNeedParamMap.get("entNumExistMap");
            Map permItemNumExistMap = null == checkNeedParamMap.get("permItemNumExistMap") ? PermVerifyUtil.getExistMapByNum((String)"perm_permitem", null) : (Map)checkNeedParamMap.get("permItemNumExistMap");
            Set collect = funcPermList.stream().map(PermItem::getPermItemId).collect(Collectors.toSet());
            Map permItemExistMap = null == checkNeedParamMap.get("permItemExistMap") ? PermItemHelper.getPermItemMap(collect) : (Map)checkNeedParamMap.get("permItemExistMap");
            HashSet plainPermItemSet = null;
            HashMap<String, Set> appNumEntNumSetMap = null;
            HashMap<String, Set> entNumPermItemNumSetMap = null;
            if (null == checkNeedParamMap.get("plainPermItemSet")) {
                GetPlainPermItemListReq getPlainPermItemListReq = new GetPlainPermItemListReq();
                getPlainPermItemListReq.setDimType("DIM_ORG");
                getPlainPermItemListReq.setReturnByField(true);
                getPlainPermItemListReq.setReturnFieldSet((Set)Sets.newHashSet((Object[])new String[]{"appNumber", "entityNumber", "permItemNumber"}));
                List plainPermItemList = PermItemHelper.getPlainPermItemList((GetPlainPermItemListReq)getPlainPermItemListReq);
                plainPermItemSet = new HashSet(plainPermItemList);
                appNumEntNumSetMap = new HashMap<String, Set>(8);
                entNumPermItemNumSetMap = new HashMap<String, Set>(8);
                for (PermItem permItem : plainPermItemSet) {
                    appNumEntNumSetMap.computeIfAbsent(permItem.getAppNumber(), k -> new HashSet(8)).add(permItem.getEntityNumber());
                    entNumPermItemNumSetMap.computeIfAbsent(permItem.getEntityNumber(), k -> new HashSet(8)).add(permItem.getPermItemNumber());
                }
            } else {
                plainPermItemSet = (HashSet)checkNeedParamMap.get("plainPermItemSet");
                appNumEntNumSetMap = (HashMap<String, Set>)checkNeedParamMap.get("appNumEntNumSetMap");
                entNumPermItemNumSetMap = (HashMap<String, Set>)checkNeedParamMap.get("entNumPermItemNumSetMap");
            }
            PermItem curPermItem = null;
            for (ComRoleFuncPerm comRoleFuncPerm : funcPermList) {
                Set adminChargeAppSet;
                Set entNumSet;
                String permItemId;
                String permItemNumber;
                String entityNumber;
                if (null == comRoleFuncPerm) continue;
                int lineNum = comRoleFuncPerm.getLineNum();
                curPermItem = new PermItem();
                String appNumber = comRoleFuncPerm.getAppNumber();
                if (null == appNumExistMap.get(appNumber) || !((Boolean)appNumExistMap.get(appNumber)).booleanValue()) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_33", (String)SYSTERM_TYPE, (Object[])new Object[0]), appNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (null == entNumExistMap.get(entityNumber = comRoleFuncPerm.getEntityNumber()) || !((Boolean)entNumExistMap.get(entityNumber)).booleanValue()) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_45", (String)SYSTERM_TYPE, (Object[])new Object[0]), entityNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (StringUtils.isNotEmpty((String)(permItemNumber = comRoleFuncPerm.getPermItemNumber())) && (null == permItemNumExistMap.get(permItemNumber) || !((Boolean)permItemNumExistMap.get(permItemNumber)).booleanValue())) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u9879\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_46", (String)SYSTERM_TYPE, (Object[])new Object[0]), permItemNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (StringUtils.isNotEmpty((String)(permItemId = comRoleFuncPerm.getPermItemId())) && null == permItemExistMap.get(permItemId)) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u9879id\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_59", (String)SYSTERM_TYPE, (Object[])new Object[0]), permItemId));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                if (null != (entNumSet = (Set)appNumEntNumSetMap.get(appNumber)) && !entNumSet.contains(entityNumber)) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleService_47", (String)SYSTERM_TYPE, (Object[])new Object[0]), appNumber, entityNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                Set permItemSet = (Set)entNumPermItemNumSetMap.get(entityNumber);
                if (StringUtils.isNotEmpty((String)permItemNumber) && null != permItemSet && !permItemSet.contains(permItemNumber)) {
                    this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u6743\u9650\u9879\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleService_48", (String)SYSTERM_TYPE, (Object[])new Object[0]), entityNumber, permItemNumber));
                    checkResult = false;
                    if (failFast) {
                        return checkResult;
                    }
                }
                curPermItem.setAppNumber(appNumber);
                curPermItem.setEntityNumber(entityNumber);
                curPermItem.setPermItemNumber(permItemNumber);
                AppInfo appInfo = null;
                appInfo = null == checkNeedParamMap.get("allAppInfo") ? AppMetadataCache.getAppInfo((String)appNumber) : (AppInfo)((Map)checkNeedParamMap.get("allAppInfo")).get(appNumber);
                Set set = adminChargeAppSet = null == checkNeedParamMap.get("adminChargeAppSet") ? new HashSet(AdminPermCache.getAdminChargeApps((Long)RequestContext.get().getCurrUserId(), null)) : (Set)checkNeedParamMap.get("adminChargeAppSet");
                if (null != appInfo && adminChargeAppSet.contains(appInfo.getId())) continue;
                this.wrapFaildMsg(lineNum, roleNum, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7528\u6237\u7684\u7ba1\u7406\u5458\u5206\u7ec4\u7684\u5e94\u7528\u8303\u56f4\u5185\u3002", (String)"ComRoleService_49", (String)SYSTERM_TYPE, (Object[])new Object[0]), appNumber));
                checkResult = false;
                if (!failFast) continue;
                return checkResult;
            }
        }
        return checkResult;
    }

    public PermResult save(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        DynamicObject[] dataEntities = req.getDataEntities();
        OperateOption option = req.getOption();
        if (null != dataEntities && dataEntities.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        }
        super.saveExt(req);
        return PermResult.ok();
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        ComRoleAfterSaveReq req = (ComRoleAfterSaveReq)reqOri;
        Set roleIdSet = req.getMainIdSet();
        try {
            if (null != roleIdSet && !roleIdSet.isEmpty()) {
                HashMap<String, Map<String, Object>> roleIdSaveDiffMap = new HashMap<String, Map<String, Object>>(8);
                HashMap<String, Object> preDataMap = new HashMap<String, Object>(8);
                PermResult funPermResult = ComRoleService.saveFuncPerm(req);
                if (!funPermResult.isOk()) {
                    throw new KDBizException(funPermResult.getMsg());
                }
                PermResult fpsResult = ComRoleService.saveFps(req);
                if (!fpsResult.isOk()) {
                    throw new KDBizException(fpsResult.getMsg());
                }
                PermResult fieldPermResult = ComRoleService.saveFieldPerm(req);
                if (!fieldPermResult.isOk()) {
                    throw new KDBizException(fieldPermResult.getMsg());
                }
                PermResult drResult = ComRoleService.saveDr(req);
                if (!drResult.isOk()) {
                    throw new KDBizException(drResult.getMsg());
                }
                PermResult admGrpResult = ComRoleService.saveRoleAdmGrp(req);
                if (!admGrpResult.isOk()) {
                    throw new KDBizException(admGrpResult.getMsg());
                }
                CacheMrg.clearAllCache();
                String preDataMapStr = req.getPreDataMapStr();
                if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                    String uncompress = StrUtil.uncompress((String)preDataMapStr);
                    preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, Map.class));
                }
                Map afterDataMap = PermRoleLogHelper.commRoleEventImage((Set)roleIdSet, (boolean)true, (boolean)true);
                Map roleUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap((Set)roleIdSet);
                for (String roleId : roleIdSet) {
                    Set roleUserIdSet = (Set)roleUserIdSetMap.get(roleId);
                    this.cancelShowFormOfSave(roleIdSaveDiffMap, preDataMap, afterDataMap, roleId, roleUserIdSet);
                }
                PermLogReq permLogReq = req.getPermLogReq();
                this.saveOrDelPermLog(permLogReq, roleIdSet, roleIdSaveDiffMap, preDataMap);
            }
            super.afterMainEntitySaveExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("ComRoleService.afterMainEntitySave error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    private void cancelShowFormOfSave(Map<String, Map<String, Object>> roleIdSaveDiffMap, Map<String, Object> preDataMap, Map<String, Object> afterDataMap, String roleId, Set<Long> roleUserIdSet) {
        try {
            Map<String, Object> saveDiffMap = this.getSaveDiffMap(roleId, preDataMap, afterDataMap);
            roleIdSaveDiffMap.put(roleId, saveDiffMap);
            if (!PermCommonUtil.isEnableAuthorityChangeNotice()) {
                return;
            }
            if (null == roleUserIdSet || CollectionUtils.isEmpty(roleUserIdSet)) {
                return;
            }
            List delPermItem = (List)saveDiffMap.get("delPermItem");
            List updatePermItem = (List)saveDiffMap.get("updatePermItem");
            if (null != delPermItem && !delPermItem.isEmpty() || null != updatePermItem && !updatePermItem.isEmpty()) {
                PermCommonUtil.cancelShowForm(new ArrayList<Long>(roleUserIdSet), null, (boolean)false);
            }
            List delNewDrPerm = (List)saveDiffMap.get("delNewDrPerm");
            List addNewDrPerm = (List)saveDiffMap.get("addNewDrPerm");
            List updateNewDrPerm = (List)saveDiffMap.get("updateNewDrPerm");
            List delNewDrPrPerm = (List)saveDiffMap.get("delNewDrPrPerm");
            List addNewDrPrPerm = (List)saveDiffMap.get("addNewDrPrPerm");
            List updateNewDrPrPerm = (List)saveDiffMap.get("updateNewDrPrPerm");
            HashSet newDRAppEntityAllSet = new HashSet(16);
            if (!CollectionUtils.isEmpty((Collection)delNewDrPerm)) {
                newDRAppEntityAllSet.addAll(delNewDrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityNumber()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)addNewDrPerm)) {
                newDRAppEntityAllSet.addAll(addNewDrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityNumber()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)updateNewDrPerm)) {
                newDRAppEntityAllSet.addAll(updateNewDrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityNumber()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)delNewDrPrPerm)) {
                newDRAppEntityAllSet.addAll(delNewDrPrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityNumber()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)addNewDrPrPerm)) {
                newDRAppEntityAllSet.addAll(addNewDrPrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityNumber()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)updateNewDrPrPerm)) {
                newDRAppEntityAllSet.addAll(updateNewDrPrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityNumber()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty(newDRAppEntityAllSet)) {
                List newDRAppEntityList = newDRAppEntityAllSet.stream().map(x -> {
                    String[] split = x.split("\\|", 2);
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    map.put(split[0], split[1]);
                    return map;
                }).collect(Collectors.toList());
                PermCommonUtil.cancelShowForm(new ArrayList<Long>(roleUserIdSet), newDRAppEntityList, (boolean)false);
            }
        }
        catch (Exception e) {
            log.warn("ComRoleService.cancelShowFormOfSave error", (Throwable)e);
        }
    }

    public void saveOrDelPermLog(PermLogReq permLogReq, Set<String> roleIdSet, Map<String, Map<String, Object>> roleIdSaveDiffMap, Map<String, Object> preDataMap) {
        if (!PermCommonUtil.isEnablePermLog()) {
            return;
        }
        if (null == permLogReq || null == roleIdSet || roleIdSet.isEmpty() || null == roleIdSaveDiffMap || roleIdSaveDiffMap.isEmpty()) {
            return;
        }
        try {
            Map roleINameComRoleMap = PermRoleHelper.getRoleIdOrNumOrNameComRoleMap(roleIdSet, (String)"id");
            int size = roleIdSet.size();
            ArrayList list = new ArrayList(size);
            for (String roleId : roleIdSet) {
                Map<String, Object> roleIdSaveDiff;
                boolean del = permLogReq.getBusiType().contains("_del");
                Set comRoles = (Set)roleINameComRoleMap.get(roleId);
                if (!del && (null == comRoles || comRoles.isEmpty()) || null == (roleIdSaveDiff = roleIdSaveDiffMap.get(roleId)) || roleIdSaveDiff.isEmpty()) continue;
                String opItemId = roleId;
                String opItemName = "";
                String opItemNumber = "";
                if (del) {
                    Map preData = (Map)preDataMap.get(opItemId);
                    if (null != preData && !preData.isEmpty()) {
                        ComRole baseInfoDB_pre;
                        ObjectMapper baseInfoMapper = new ObjectMapper();
                        ComRole comRole = baseInfoDB_pre = null == preData.get("baseInfoDB") ? new ComRole() : (ComRole)baseInfoMapper.readValue(baseInfoMapper.writeValueAsString(preData.get("baseInfoDB")), ComRole.class);
                        if (null != baseInfoDB_pre) {
                            opItemName = baseInfoDB_pre.getName();
                            opItemNumber = baseInfoDB_pre.getNumber();
                        }
                    }
                } else {
                    Optional first = comRoles.stream().findFirst();
                    ComRole comRole = (ComRole)first.get();
                    if (null == comRole) continue;
                    opItemName = comRole.getName();
                    opItemNumber = comRole.getNumber();
                }
                HashMap<String, Object> map = new HashMap<String, Object>(20);
                map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
                map.put("busi_from", permLogReq.getBusiFrom());
                map.put("busi_type", permLogReq.getBusiType());
                map.put("cloud_id", permLogReq.getCloudId());
                map.put("app_id", permLogReq.getAppId());
                map.put("form_identity", permLogReq.getFormIdentity());
                map.put("op", permLogReq.getOp());
                map.put("opbtn", permLogReq.getOpbtn());
                map.put("interface_method", permLogReq.getInterfaceMethod());
                map.put("op_item_id", opItemId);
                map.put("op_item_number", opItemNumber);
                map.put("op_item_name", opItemName);
                map.put("pre_data", permLogReq.getPreData());
                map.put("after_data", permLogReq.getAfterData());
                String saveDiffStr = StrUtil.compress((String)new ObjectMapper().writeValueAsString(roleIdSaveDiff));
                map.put("diff_content", saveDiffStr);
                map.put("oper_id", RequestContext.get().getCurrUserId());
                map.put("oper_org_id", RequestContext.get().getOrgId());
                map.put("oper_time", permLogReq.getOperTime());
                map.put("client_type", permLogReq.getClientType());
                map.put("client_ip", permLogReq.getClientIp());
                map.put("client_name", permLogReq.getClientType());
                list.add(map);
            }
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("ComRoleService.saveOrDelPermLog error, roleIdSet:{}", (Object)JSON.toJSONString(roleIdSet), (Object)e);
        }
    }

    public Map<String, Object> getSaveDiffMap(String opItemId, Map<String, Object> preDataMap, Map<String, Object> sucAfterDataMap) {
        try {
            Map preData = (Map)preDataMap.get(opItemId);
            ComRole baseInfoDB_pre = new ComRole();
            HashSet funcPermSetDB_pre = new HashSet(1);
            HashSet fieldPermSetDB_pre = new HashSet(1);
            HashSet fpsSetDB_pre = new HashSet(1);
            HashSet newDrPermSetDB_pre = new HashSet(1);
            HashSet newDrPrPermSetDB_pre = new HashSet(1);
            HashSet comRoleAdminGrpSetDB_pre = new HashSet(1);
            if (null != preData && !preData.isEmpty()) {
                ObjectMapper baseInfoMapper = new ObjectMapper();
                baseInfoDB_pre = null == preData.get("baseInfoDB") ? baseInfoDB_pre : (ComRole)baseInfoMapper.readValue(baseInfoMapper.writeValueAsString(preData.get("baseInfoDB")), ComRole.class);
                ObjectMapper funcPermMapper = new ObjectMapper();
                funcPermSetDB_pre = null == preData.get("funcPermSetDB") ? funcPermSetDB_pre : (Set)funcPermMapper.readValue(funcPermMapper.writeValueAsString(preData.get("funcPermSetDB")), funcPermMapper.getTypeFactory().constructParametricType(Set.class, new Class[]{ComRoleFuncPerm.class}));
                ObjectMapper fieldPermMapper = new ObjectMapper();
                fieldPermSetDB_pre = null == preData.get("fieldPermSetDB") ? fieldPermSetDB_pre : (Set)fieldPermMapper.readValue(fieldPermMapper.writeValueAsString(preData.get("fieldPermSetDB")), fieldPermMapper.getTypeFactory().constructParametricType(Set.class, new Class[]{FieldPerm.class}));
                ObjectMapper fpsMapper = new ObjectMapper();
                fpsSetDB_pre = null == preData.get("fpsSetDB") ? fpsSetDB_pre : (Set)fpsMapper.readValue(fpsMapper.writeValueAsString(preData.get("fpsSetDB")), fpsMapper.getTypeFactory().constructParametricType(Set.class, new Class[]{FieldPermScheme.class}));
                ObjectMapper newDrPermMapper = new ObjectMapper();
                newDrPermSetDB_pre = null == preData.get("newDrPermSetDB") ? newDrPermSetDB_pre : (Set)newDrPermMapper.readValue(newDrPermMapper.writeValueAsString(preData.get("newDrPermSetDB")), newDrPermMapper.getTypeFactory().constructParametricType(Set.class, new Class[]{NewDrPerm.class}));
                ObjectMapper newDrPrPermMapper = new ObjectMapper();
                newDrPrPermSetDB_pre = null == preData.get("newDrPrPermSetDB") ? newDrPrPermSetDB_pre : (Set)newDrPrPermMapper.readValue(newDrPrPermMapper.writeValueAsString(preData.get("newDrPrPermSetDB")), newDrPrPermMapper.getTypeFactory().constructParametricType(Set.class, new Class[]{NewDrPrPerm.class}));
                ObjectMapper comRoleAdminGrpMapper = new ObjectMapper();
                comRoleAdminGrpSetDB_pre = null == preData.get("comRoleAdminGrpSetDB") ? comRoleAdminGrpSetDB_pre : (Set)comRoleAdminGrpMapper.readValue(comRoleAdminGrpMapper.writeValueAsString(preData.get("comRoleAdminGrpSetDB")), comRoleAdminGrpMapper.getTypeFactory().constructParametricType(Set.class, new Class[]{ComRoleAdminGrp.class}));
            }
            Map sucAfterData = (Map)sucAfterDataMap.get(opItemId);
            ComRole baseInfoDB_after = new ComRole();
            Set funcPermSetDB_after = new HashSet(1);
            Set fieldPermSetDB_after = new HashSet(1);
            Set fpsSetDB_after = new HashSet(1);
            Set newDrPermSetDB_after = new HashSet(1);
            Set newDrPrPermSetDB_after = new HashSet(1);
            Set comRoleAdminGrpSetDB_after = new HashSet(1);
            Set roleUserIdSet_after = new HashSet(1);
            if (null != sucAfterData && !sucAfterData.isEmpty()) {
                baseInfoDB_after = (ComRole)sucAfterData.get("baseInfoDB");
                funcPermSetDB_after = (Set)sucAfterData.get("funcPermSetDB");
                funcPermSetDB_after = null == funcPermSetDB_after || funcPermSetDB_after.isEmpty() ? new HashSet(1) : funcPermSetDB_after;
                fieldPermSetDB_after = (Set)sucAfterData.get("fieldPermSetDB");
                fieldPermSetDB_after = null == fieldPermSetDB_after || fieldPermSetDB_after.isEmpty() ? new HashSet(1) : fieldPermSetDB_after;
                fpsSetDB_after = (Set)sucAfterData.get("fpsSetDB");
                fpsSetDB_after = null == fpsSetDB_after || fpsSetDB_after.isEmpty() ? new HashSet(1) : fpsSetDB_after;
                newDrPermSetDB_after = (Set)sucAfterData.get("newDrPermSetDB");
                newDrPermSetDB_after = null == newDrPermSetDB_after || newDrPermSetDB_after.isEmpty() ? new HashSet(1) : newDrPermSetDB_after;
                newDrPrPermSetDB_after = (Set)sucAfterData.get("newDrPrPermSetDB");
                newDrPrPermSetDB_after = null == newDrPrPermSetDB_after || newDrPrPermSetDB_after.isEmpty() ? new HashSet(1) : newDrPrPermSetDB_after;
                comRoleAdminGrpSetDB_after = (Set)sucAfterData.get("comRoleAdminGrpSetDB");
                comRoleAdminGrpSetDB_after = null == comRoleAdminGrpSetDB_after || comRoleAdminGrpSetDB_after.isEmpty() ? new HashSet(1) : comRoleAdminGrpSetDB_after;
                roleUserIdSet_after = (Set)sucAfterData.get("roleUserIdSet");
                roleUserIdSet_after = null == roleUserIdSet_after || roleUserIdSet_after.isEmpty() ? new HashSet(1) : roleUserIdSet_after;
            }
            List delPermItem = ListUtil.removeAll(new ArrayList(funcPermSetDB_pre), new ArrayList(funcPermSetDB_after));
            List addPermItem = ListUtil.removeAll(new ArrayList(funcPermSetDB_after), new ArrayList(funcPermSetDB_pre));
            ArrayList updatePermItem = new ArrayList(10);
            List delFieldPerm = ListUtil.removeAll(new ArrayList(fieldPermSetDB_pre), new ArrayList(fieldPermSetDB_after));
            List addFieldPerm = ListUtil.removeAll(new ArrayList(fieldPermSetDB_after), new ArrayList(fieldPermSetDB_pre));
            List delFpsPerm = ListUtil.removeAll(new ArrayList(fpsSetDB_pre), new ArrayList(fpsSetDB_after));
            List addFpsPerm = ListUtil.removeAll(new ArrayList(fpsSetDB_after), new ArrayList(fpsSetDB_pre));
            Map newDrPermCompareMap = DrHelper.compareNewDrPerm(newDrPermSetDB_pre, newDrPermSetDB_after);
            Map newDrPrPermCompareMap = DrHelper.compareNewDrPrPerm(newDrPrPermSetDB_pre, newDrPrPermSetDB_after);
            List delComRoleAdminGrp = ListUtil.removeAll(new ArrayList(comRoleAdminGrpSetDB_pre), new ArrayList(comRoleAdminGrpSetDB_after));
            List addComRoleAdminGrp = ListUtil.removeAll(new ArrayList(comRoleAdminGrpSetDB_after), new ArrayList(comRoleAdminGrpSetDB_pre));
            ArrayList updateComRoleAdminGrp = new ArrayList(10);
            HashMap<String, Object> diffMap = new HashMap<String, Object>(16);
            diffMap.put("baseInfoDB_pre", baseInfoDB_pre);
            diffMap.put("baseInfoDB_after", baseInfoDB_after);
            diffMap.put("delPermItem", delPermItem);
            diffMap.put("addPermItem", addPermItem);
            diffMap.put("updatePermItem", updatePermItem);
            diffMap.put("delFieldPerm", delFieldPerm);
            diffMap.put("addFieldPerm", addFieldPerm);
            diffMap.put("delFpsPerm", delFpsPerm);
            diffMap.put("addFpsPerm", addFpsPerm);
            diffMap.put("delNewDrPerm", newDrPermCompareMap.get("delList"));
            diffMap.put("addNewDrPerm", newDrPermCompareMap.get("addList"));
            diffMap.put("updateNewDrPerm", newDrPermCompareMap.get("updateList"));
            diffMap.put("delNewDrPrPerm", newDrPrPermCompareMap.get("delList"));
            diffMap.put("addNewDrPrPerm", newDrPrPermCompareMap.get("addList"));
            diffMap.put("updateNewDrPrPerm", newDrPrPermCompareMap.get("updateList"));
            diffMap.put("delComRoleAdminGrp", delComRoleAdminGrp);
            diffMap.put("addComRoleAdminGrp", addComRoleAdminGrp);
            diffMap.put("updateComRoleAdminGrp", updateComRoleAdminGrp);
            diffMap.put("influenUserIdSet", roleUserIdSet_after);
            diffMap.put("langStr", RequestContext.get().getLang().name());
            return diffMap;
        }
        catch (Exception e) {
            log.warn("ComRoleService.getSaveDiffMap error.", (Throwable)e);
            return new HashMap<String, Object>(0);
        }
    }

    private static PermResult saveRoleAdmGrp(ComRoleAfterSaveReq req) {
        try {
            ArrayList<DynamicObject> roleAdminGrpList = new ArrayList<DynamicObject>(8);
            Set willDelAdmGroupRoleIdSet = req.getWillDelAdmGroupRoleIdSet();
            Map willAddAdmGrpMap = req.getWillAddAdmGrpMap();
            if (null != willAddAdmGrpMap && !willAddAdmGrpMap.isEmpty()) {
                Set roleIdSet = willAddAdmGrpMap.keySet();
                Map roleIdAdmGrpSetMap = PermRoleHelper.getAdmGrpSetMap(roleIdSet, (String)"id");
                Map beforeDynMap = BusinessDataServiceHelper.loadFromCache((String)"perm_admingrouprole", (String)"id, role, admingroup, modifiable", (QFilter[])new QFilter[]{new QFilter("role", "in", roleIdSet)});
                for (Map.Entry roleAdmGrp : willAddAdmGrpMap.entrySet()) {
                    String roleId = (String)roleAdmGrp.getKey();
                    Set value = (Set)roleAdmGrp.getValue();
                    if (StringUtils.isEmpty((String)roleId) || null == value || value.isEmpty()) continue;
                    DynamicObject dyn = null;
                    for (ComRoleAdminGrp roleAdminGrp : value) {
                        String entryId = roleAdminGrp.getEntryId();
                        if (StringUtils.isEmpty((String)entryId)) {
                            ComRoleAdminGrp first;
                            Set admGrpSet = (Set)roleIdAdmGrpSetMap.get(roleId);
                            if (null != admGrpSet && !admGrpSet.isEmpty() && null != (first = (ComRoleAdminGrp)admGrpSet.stream().filter(x -> Objects.equals(roleAdminGrp.getRoleId(), x.getRoleId()) && Objects.equals(roleAdminGrp.getAdminGroupId(), x.getAdminGroupId()) && Objects.equals(roleAdminGrp.isModifiable(), x.isModifiable())).findFirst().orElse(null))) continue;
                            dyn = BusinessDataServiceHelper.newDynamicObject((String)"perm_admingrouprole");
                            roleAdminGrpList.add(dyn);
                        } else {
                            DynamicObject ori = (DynamicObject)beforeDynMap.get(Long.valueOf(entryId));
                            if (null == ori) {
                                dyn = BusinessDataServiceHelper.newDynamicObject((String)"perm_admingrouprole");
                                roleAdminGrpList.add(dyn);
                            } else {
                                if (null != willDelAdmGroupRoleIdSet && !willDelAdmGroupRoleIdSet.isEmpty()) {
                                    dyn = BusinessDataServiceHelper.newDynamicObject((String)"perm_admingrouprole");
                                    dyn.set("id", (Object)ori.getLong("id"));
                                } else {
                                    dyn = ori;
                                }
                                roleAdminGrpList.add(dyn);
                            }
                        }
                        dyn.set("role", (Object)roleId);
                        dyn.set("admingroup", (Object)roleAdminGrp.getAdminGroupId());
                        dyn.set("modifiable", (Object)roleAdminGrp.isModifiable());
                    }
                }
            }
            try (TXHandle h = TX.required();){
                try {
                    if (null != willDelAdmGroupRoleIdSet && !willDelAdmGroupRoleIdSet.isEmpty()) {
                        DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)new SqlBuilder().append("delete from t_perm_admingrouprole", new Object[0]).appendIn(" where froleid", willDelAdmGroupRoleIdSet.toArray()));
                    }
                    if (null != roleAdminGrpList && !roleAdminGrpList.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])roleAdminGrpList.toArray(new DynamicObject[roleAdminGrpList.size()]));
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                    log.warn("ComRoleService.saveRoleAdmGrp transaction error.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.warn("ComRoleService.saveRoleAdmGrp error.", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
        return PermResult.ok();
    }

    private static PermResult saveDr(ComRoleAfterSaveReq req) {
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        if (!hasEnableRoleDataRuleNewModel) {
            return ComRoleService.saveDrInOldMdl(req);
        }
        try {
            Map map;
            Map map2;
            Map willAddDrPermMap;
            Map willDelDrPermMap = req.getWillDelDrPermMap();
            if (willDelDrPermMap != null && !willDelDrPermMap.isEmpty()) {
                for (Map.Entry entry : willDelDrPermMap.entrySet()) {
                    String string = (String)entry.getKey();
                    List list = (List)entry.getValue();
                    if (StringUtils.isEmpty((String)string) || list == null || list.isEmpty()) continue;
                    StringBuilder sbProcessInfo = new StringBuilder();
                    PermResult tempRes = DataRuleCache.roleAssignDataRule((String)string, (List)list, (AssignModEnum)AssignModEnum.ASSIGNMODE_CANCEL);
                    if (tempRes.isOk()) continue;
                    log.warn("\u6570\u636e\u89c4\u5219\u4fdd\u5b58\u5931\u8d25\uff1a" + tempRes.getMsg());
                }
            }
            if ((willAddDrPermMap = req.getWillAddDrPermMap()) != null && !willAddDrPermMap.isEmpty()) {
                for (Map.Entry entry : willAddDrPermMap.entrySet()) {
                    String string = (String)entry.getKey();
                    List drPermList = (List)entry.getValue();
                    if (StringUtils.isEmpty((String)string) || drPermList == null || drPermList.isEmpty()) continue;
                    StringBuilder sbProcessInfo = new StringBuilder();
                    PermResult tempRes = DataRuleCache.roleAssignDataRule((String)string, (List)drPermList, (AssignModEnum)AssignModEnum.ASSIGNMODE_INCREMENT);
                    if (tempRes.isOk()) continue;
                    log.warn("\u6570\u636e\u89c4\u5219\u4fdd\u5b58\u5931\u8d25\uff1a" + tempRes.getMsg());
                }
            }
            if ((map2 = req.getWillDelDrPrMap()) != null && !map2.isEmpty()) {
                for (Map.Entry entry : map2.entrySet()) {
                    String roleId = (String)entry.getKey();
                    List drPermList = (List)entry.getValue();
                    if (StringUtils.isEmpty((String)roleId) || drPermList == null || drPermList.isEmpty()) continue;
                    StringBuilder sbProcessInfo = new StringBuilder();
                    PermResult tempRes = DataRuleCache.roleAssignDataRuleProp((String)roleId, (List)drPermList, (AssignModEnum)AssignModEnum.ASSIGNMODE_CANCEL);
                    if (tempRes.isOk()) continue;
                    log.warn("\u6570\u636e\u89c4\u5219\u4fdd\u5b58\u5931\u8d25\uff1a" + tempRes.getMsg());
                }
            }
            if ((map = req.getWillAddDrPrMap()) != null && !map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    String roleId = (String)entry.getKey();
                    List drPermList = (List)entry.getValue();
                    if (StringUtils.isEmpty((String)roleId) || drPermList == null || drPermList.isEmpty()) continue;
                    StringBuilder sbProcessInfo = new StringBuilder();
                    PermResult tempRes = DataRuleCache.roleAssignDataRuleProp((String)roleId, (List)drPermList, (AssignModEnum)AssignModEnum.ASSIGNMODE_INCREMENT);
                    if (tempRes.isOk()) continue;
                    log.warn("\u6570\u636e\u89c4\u5219\u4fdd\u5b58\u5931\u8d25\uff1a" + tempRes.getMsg());
                }
            }
        }
        catch (Exception e) {
            log.warn("ComRoleService.saveDr error.", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
        return PermResult.ok();
    }

    private static PermResult saveDrInOldMdl(ComRoleAfterSaveReq req) {
        try {
            Map willAddDrMap;
            Map willDelDrMap = req.getWillDelDrMap();
            if (null != willDelDrMap && !willDelDrMap.isEmpty()) {
                for (Map.Entry willDelDr : willDelDrMap.entrySet()) {
                    String roleId = (String)willDelDr.getKey();
                    DataRulesInfo value = (DataRulesInfo)willDelDr.getValue();
                    if (StringUtils.isEmpty((String)roleId) || null == value) continue;
                    StringBuilder sbProcessInfo = new StringBuilder();
                    boolean result = PermissionServiceHelper.roleAssignDataRules((String)roleId, (DataRulesInfo)value, (String)AssignModEnum.ASSIGNMODE_CANCEL.getCode(), (StringBuilder)sbProcessInfo);
                    if (result) continue;
                    log.warn("\u6570\u636e\u89c4\u5219\u4fdd\u5b58\u5931\u8d25\uff1a" + sbProcessInfo);
                }
            }
            if (null != (willAddDrMap = req.getWillAddDrMap()) && !willAddDrMap.isEmpty()) {
                for (Map.Entry willAddDr : willAddDrMap.entrySet()) {
                    String roleId = (String)willAddDr.getKey();
                    DataRulesInfo value = (DataRulesInfo)willAddDr.getValue();
                    if (StringUtils.isEmpty((String)roleId) || null == value) continue;
                    StringBuilder sbProcessInfo = new StringBuilder();
                    boolean result = PermissionServiceHelper.roleAssignDataRules((String)roleId, (DataRulesInfo)value, (String)AssignModEnum.ASSIGNMODE_INCREMENT.getCode(), (StringBuilder)sbProcessInfo);
                    if (result) continue;
                    log.warn("\u6570\u636e\u89c4\u5219\u4fdd\u5b58\u5931\u8d25\uff1a" + sbProcessInfo);
                }
            }
        }
        catch (Exception e) {
            log.warn("ComRoleService.saveDr error.", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
        return PermResult.ok();
    }

    private static PermResult saveFieldPerm(ComRoleAfterSaveReq req) {
        try {
            ArrayList t_perm_fieldperm_insertParamList = new ArrayList(8);
            ArrayList t_perm_rolefieldperm_insertParamList = new ArrayList(8);
            ArrayList t_perm_fieldpermdetail_insertParamList = new ArrayList(8);
            HashSet t_perm_fieldperm_delFIdSet = new HashSet(8);
            HashSet t_perm_rolefieldperm_delFIdSet = new HashSet(8);
            HashSet t_perm_fieldpermdetail_delEntryIdSet = new HashSet(8);
            Set roleIdSet = req.getMainIdSet();
            Map roleFieldPermMap = PermRoleHelper.queryRoleFieldPermMap((Set)roleIdSet);
            Map willAddRoleFieldPermMap = CollectionUtils.isEmpty((Map)req.getWillAddRoleFieldPermMap()) ? new HashMap(0) : req.getWillAddRoleFieldPermMap();
            Map willDelRoleFieldPermMap = CollectionUtils.isEmpty((Map)req.getWillDelRoleFieldPermMap()) ? new HashMap(0) : req.getWillDelRoleFieldPermMap();
            for (String roleId : roleIdSet) {
                Set addRoleFieldPermList = CollectionUtils.isEmpty((Collection)((Collection)willAddRoleFieldPermMap.get(roleId))) ? new HashSet(0) : (Set)willAddRoleFieldPermMap.get(roleId);
                List<FieldPerm> addFieldPermList = addRoleFieldPermList.stream().filter(x -> !x.getControlMode().equals("0")).map(x -> {
                    FieldPerm fieldPerm = new FieldPerm();
                    fieldPerm.setFieldName(x.getFieldName());
                    fieldPerm.setControlMode(x.getControlMode());
                    fieldPerm.setEntityNumber(x.getEntityNumber());
                    fieldPerm.setAppId(x.getAppId());
                    return fieldPerm;
                }).collect(Collectors.toList());
                Set delRoleFieldPermList = CollectionUtils.isEmpty((Collection)((Collection)willDelRoleFieldPermMap.get(roleId))) ? new HashSet(0) : (Set)willDelRoleFieldPermMap.get(roleId);
                List<FieldPerm> delFieldPermList = delRoleFieldPermList.stream().filter(x -> !x.getControlMode().equals("0")).map(x -> {
                    FieldPerm fieldPerm = new FieldPerm();
                    fieldPerm.setFieldName(x.getFieldName());
                    fieldPerm.setControlMode(x.getControlMode());
                    fieldPerm.setEntityNumber(x.getEntityNumber());
                    fieldPerm.setAppId(x.getAppId());
                    return fieldPerm;
                }).collect(Collectors.toList());
                Map<String, Object> fieldPermDBOperParamMap = ComRoleService.getFieldPermDBOperParamMap(roleId, addFieldPermList, delFieldPermList, roleFieldPermMap);
                t_perm_fieldperm_insertParamList.addAll((List)fieldPermDBOperParamMap.get("t_perm_fieldperm_insertParamList"));
                t_perm_rolefieldperm_insertParamList.addAll((List)fieldPermDBOperParamMap.get("t_perm_rolefieldperm_insertParamList"));
                t_perm_fieldpermdetail_insertParamList.addAll((List)fieldPermDBOperParamMap.get("t_perm_fieldpermdetail_insertParamList"));
                t_perm_fieldperm_delFIdSet.addAll((Set)fieldPermDBOperParamMap.get("t_perm_fieldperm_delFIdSet"));
                t_perm_rolefieldperm_delFIdSet.addAll((Set)fieldPermDBOperParamMap.get("t_perm_rolefieldperm_delFIdSet"));
                t_perm_fieldpermdetail_delEntryIdSet.addAll((Set)fieldPermDBOperParamMap.get("t_perm_fieldpermdetail_delEntryIdSet"));
            }
            try (TXHandle h = TX.required();){
                try {
                    PermRoleHelper.fieldPerm2DB(t_perm_fieldperm_insertParamList, t_perm_rolefieldperm_insertParamList, t_perm_fieldpermdetail_insertParamList, t_perm_fieldperm_delFIdSet, t_perm_rolefieldperm_delFIdSet, t_perm_fieldpermdetail_delEntryIdSet);
                }
                catch (Exception e) {
                    h.markRollback();
                    log.warn("ComRoleService.saveFieldPerm transaction error.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.warn("ComRoleService.saveFieldPerm error.", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
        return PermResult.ok();
    }

    private static PermResult saveFps(ComRoleAfterSaveReq req) {
        try {
            Map willAddFpsMap;
            ArrayList<Object[]> delFpsParamsList = new ArrayList<Object[]>(8);
            ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(8);
            Map willDelFpsMap = req.getWillDelFpsMap();
            if (null != willDelFpsMap && !willDelFpsMap.isEmpty()) {
                for (Map.Entry willDelFps : willDelFpsMap.entrySet()) {
                    String key = (String)willDelFps.getKey();
                    Set set = (Set)willDelFps.getValue();
                    if (StringUtils.isEmpty((String)key) || null == set || set.isEmpty()) continue;
                    for (ComRoleFieldPermScheme one : set) {
                        delFpsParamsList.add(new Object[]{key, one.getAppId(), one.getEntityNumber(), one.getId()});
                    }
                }
            }
            if (null != (willAddFpsMap = req.getWillAddFpsMap()) && !willAddFpsMap.isEmpty()) {
                DynamicObject dyn = null;
                for (Map.Entry throwable : willAddFpsMap.entrySet()) {
                    String key = (String)throwable.getKey();
                    Set value = (Set)throwable.getValue();
                    if (StringUtils.isEmpty((String)key) || null == value || value.isEmpty()) continue;
                    for (ComRoleFieldPermScheme one : value) {
                        dyn = BusinessDataServiceHelper.newDynamicObject((String)"perm_rolefieldscheme");
                        dyn.set("role", (Object)one.getRoleId());
                        dyn.set("fps", (Object)one.getId());
                        dyn.set("app", (Object)one.getAppId());
                        dyn.set("ent", (Object)one.getEntityNumber());
                        dynList.add(dyn);
                    }
                }
            }
            TXHandle h = TX.required();
            Object object = null;
            try {
                try {
                    if (!CollectionUtils.isEmpty(delFpsParamsList)) {
                        StringBuilder throwable = new StringBuilder();
                        throwable.append("delete from t_perm_rolefieldscheme where froleid = ? and fappid = ? and fentnum = ? and ffieldpermschemeid = ? ");
                        DB.executeBatch((DBRoute)DBRoute.permission, (String)throwable.toString(), delFpsParamsList);
                    }
                    if (!CollectionUtils.isEmpty(dynList)) {
                        SaveServiceHelper.save((DynamicObject[])dynList.toArray(new DynamicObject[dynList.size()]));
                    }
                }
                catch (Exception exception) {
                    h.markRollback();
                    log.warn("ComRoleService.saveFps transaction error.", (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (h != null) {
                    if (object != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn("ComRoleService.saveFps error.", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
        return PermResult.ok();
    }

    private static PermResult saveFuncPerm(ComRoleAfterSaveReq req) {
        try {
            ArrayList t_perm_roleperm_insertParamList = new ArrayList(10);
            ArrayList t_perm_rolepermdetial_insertParamList = new ArrayList(10);
            ArrayList t_perm_rolepermdetial_updateParamList = new ArrayList(10);
            HashSet t_perm_rolepermdetial_delEntryIdSet = new HashSet(8);
            HashSet t_perm_roleperm_delFidSet = new HashSet(8);
            Set roleIdSet = req.getMainIdSet();
            Map rolePermMap = PermRoleHelper.queryRolePermMap((Set)roleIdSet);
            HashMap<String, Set<String>> funcPermChangeAppIdEntNumSetMap = new HashMap<String, Set<String>>(8);
            Map willAddFuncPermMap = CollectionUtils.isEmpty((Map)req.getWillAddFuncPermMap()) ? new HashMap(0) : req.getWillAddFuncPermMap();
            Map willDelFuncPermMap = CollectionUtils.isEmpty((Map)req.getWillDelFuncPermMap()) ? new HashMap(0) : req.getWillDelFuncPermMap();
            for (String roleId : roleIdSet) {
                ArrayList<ComRoleFuncPerm> updateComRoleFuncPerm = new ArrayList<ComRoleFuncPerm>(10);
                Set willAddFuncPermSet = CollectionUtils.isEmpty((Collection)((Collection)willAddFuncPermMap.get(roleId))) ? new HashSet(0) : (Set)willAddFuncPermMap.get(roleId);
                Iterator iterator = willAddFuncPermSet.iterator();
                while (iterator.hasNext()) {
                    ComRoleFuncPerm one = (ComRoleFuncPerm)iterator.next();
                    String entryId = one.getEntryId();
                    if (!StringUtils.isNotEmpty((String)entryId)) continue;
                    updateComRoleFuncPerm.add(one);
                    iterator.remove();
                }
                List<PermItem> addFunPermList = willAddFuncPermSet.stream().map(x -> {
                    PermItem one = new PermItem();
                    one.setAppId(x.getAppId());
                    one.setEntityNumber(x.getEntityNumber());
                    one.setPermItemId(x.getPermItemId());
                    return one;
                }).collect(Collectors.toList());
                Set willDelFuncPermSet = CollectionUtils.isEmpty((Collection)((Collection)willDelFuncPermMap.get(roleId))) ? new HashSet(0) : (Set)willDelFuncPermMap.get(roleId);
                List<PermItem> delFunPermList = willDelFuncPermSet.stream().map(x -> {
                    PermItem one = new PermItem();
                    one.setAppId(x.getAppId());
                    one.setEntityNumber(x.getEntityNumber());
                    one.setPermItemId(x.getPermItemId());
                    return one;
                }).collect(Collectors.toList());
                Map<String, Object> funPermDBOperParamMap = ComRoleService.getFunPermDBOperParamMap(roleId, addFunPermList, delFunPermList, updateComRoleFuncPerm, rolePermMap);
                t_perm_roleperm_insertParamList.addAll((List)funPermDBOperParamMap.get("t_perm_roleperm_insertParamList"));
                t_perm_rolepermdetial_insertParamList.addAll((List)funPermDBOperParamMap.get("t_perm_rolepermdetial_insertParamList"));
                t_perm_rolepermdetial_updateParamList.addAll((List)funPermDBOperParamMap.get("t_perm_rolepermdetial_updateParamList"));
                t_perm_rolepermdetial_delEntryIdSet.addAll((Set)funPermDBOperParamMap.get("t_perm_rolepermdetial_delEntryIdSet"));
                t_perm_roleperm_delFidSet.addAll((Set)funPermDBOperParamMap.get("t_perm_roleperm_delFidSet"));
                Set funcPermChangeAppIdEntNumSet = (Set)funPermDBOperParamMap.get("funcPermChangeAppIdEntNumSet");
                funcPermChangeAppIdEntNumSetMap.put(roleId, funcPermChangeAppIdEntNumSet);
            }
            try (TXHandle h = TX.required();){
                try {
                    PermRoleHelper.funcPerm2DB(t_perm_roleperm_insertParamList, t_perm_rolepermdetial_insertParamList, t_perm_rolepermdetial_updateParamList, t_perm_rolepermdetial_delEntryIdSet, t_perm_roleperm_delFidSet);
                    Map enableUserIdMap = PermRoleHelper.getEnableUserIdMap((Set)roleIdSet);
                    ComRoleService.toLic(roleIdSet, funcPermChangeAppIdEntNumSetMap, enableUserIdMap);
                }
                catch (Exception e) {
                    h.markRollback();
                    log.warn("ComRoleService.saveFuncPerm transaction error.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.warn("ComRoleService.saveFuncPerm error.", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
        return PermResult.ok();
    }

    public PermResult del(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        Object[] ids = null == req.getMainIdSet() ? new Object[]{} : req.getMainIdSet().toArray();
        OperateOption option = req.getOption();
        if (null != ids && ids.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        }
        super.delExt(req);
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            ComRoleAfterDelReq req = (ComRoleAfterDelReq)reqOri;
            Set roleIdSet = req.getMainIdSet();
            if (null != roleIdSet && !roleIdSet.isEmpty()) {
                ComRoleService.delRoleRelationData(roleIdSet, req);
                HashMap<String, Map<String, Object>> roleIdSaveDiffMap = new HashMap<String, Map<String, Object>>(8);
                HashMap<String, Object> preDataMap = new HashMap<String, Object>(8);
                String preDataMapStr = req.getPreDataMapStr();
                if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                    String uncompress = StrUtil.uncompress((String)preDataMapStr);
                    preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, Map.class));
                }
                Map afterDataMap = PermRoleLogHelper.commRoleEventImage((Set)roleIdSet, (boolean)true, (boolean)true);
                Map roleUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap((Set)roleIdSet);
                for (String roleId : roleIdSet) {
                    Map<String, Object> saveDiffMap = this.getSaveDiffMap(roleId, preDataMap, afterDataMap);
                    roleIdSaveDiffMap.put(roleId, saveDiffMap);
                    Set roleUserIdSet = (Set)roleUserIdSetMap.get(roleId);
                    this.cancelShowFormOfSave(roleIdSaveDiffMap, preDataMap, afterDataMap, roleId, roleUserIdSet);
                }
                if (PermCommonUtil.isEnablePermLog()) {
                    PermLogReq permLogReq = req.getPermLogReq();
                    this.saveOrDelPermLog(permLogReq, roleIdSet, roleIdSaveDiffMap, preDataMap);
                }
            }
            super.afterDelExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("ComRoleService.afterDel error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    private static void delRoleRelationData(Set<String> roleIdSet, ComRoleAfterDelReq req) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"perm_roleperm", (QFilter[])new QFilter[]{new QFilter("roleid", "in", roleIdSet)});
                DynamicObject[] arrRoleFieldPerm = BusinessDataServiceHelper.load((String)"perm_rolefieldperm", (String)"fieldperm.id", (QFilter[])new QFilter[]{new QFilter("role", "in", roleIdSet)});
                ArrayList<String> forDelFieldPermId = new ArrayList<String>(10);
                if (arrRoleFieldPerm != null) {
                    for (DynamicObject dObj : arrRoleFieldPerm) {
                        String fieldPermId = dObj.getString("fieldperm.id");
                        forDelFieldPermId.add(fieldPermId);
                    }
                }
                if (forDelFieldPermId != null && forDelFieldPermId.size() > 0) {
                    DeleteServiceHelper.delete((String)"perm_fieldperm", (QFilter[])new QFilter[]{new QFilter("id", "in", forDelFieldPermId)});
                }
                DeleteServiceHelper.delete((String)"perm_rolefieldperm", (QFilter[])new QFilter[]{new QFilter("role", "in", roleIdSet)});
                Object[] roleIdArr = roleIdSet.stream().toArray();
                SqlBuilder rolefpsSql = new SqlBuilder();
                rolefpsSql.append("delete from t_perm_rolefieldscheme ", new Object[0]);
                rolefpsSql.appendIn(" where froleid ", roleIdArr);
                DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)rolefpsSql);
                SqlBuilder roleAdmgrpSql = new SqlBuilder();
                roleAdmgrpSql.append("delete from t_perm_admingrouprole ", new Object[0]);
                roleAdmgrpSql.appendIn(" where froleid ", roleIdArr);
                DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)roleAdmgrpSql);
                DynamicObject[] arrRoleDataPerm = BusinessDataServiceHelper.load((String)"perm_roledataperm", (String)"datapermid.id", (QFilter[])new QFilter[]{new QFilter("role", "in", roleIdSet)});
                ArrayList<String> forDelDataPermId = new ArrayList<String>();
                if (arrRoleDataPerm != null) {
                    for (DynamicObject dObj : arrRoleDataPerm) {
                        String dataPermId = dObj.getString("datapermid.id");
                        forDelDataPermId.add(dataPermId);
                    }
                }
                if (forDelDataPermId != null && forDelDataPermId.size() > 0) {
                    DeleteServiceHelper.delete((String)"perm_dataperm", (QFilter[])new QFilter[]{new QFilter("id", "in", forDelDataPermId)});
                }
                DeleteServiceHelper.delete((String)"perm_roledataperm", (QFilter[])new QFilter[]{new QFilter("role", "in", roleIdSet)});
                DrHelper.delByComRoleIdSet(roleIdSet);
                SqlBuilder roleUserSql = new SqlBuilder();
                roleUserSql.append("delete from t_perm_userrole ", new Object[0]);
                roleUserSql.appendIn(" where froleid ", roleIdArr);
                DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)roleUserSql);
                SqlBuilder roleUsrgrpSql = new SqlBuilder();
                roleUsrgrpSql.append("delete from t_perm_usrgrprole ", new Object[0]);
                roleUsrgrpSql.appendIn(" where froleid ", roleIdArr);
                DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)roleUsrgrpSql);
                SqlBuilder roleBizroleSql = new SqlBuilder();
                roleBizroleSql.append("delete from t_perm_bizrolecomrole ", new Object[0]);
                roleBizroleSql.appendIn(" where froleid ", roleIdArr);
                DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)roleBizroleSql);
                DeleteServiceHelper.delete((String)"perm_role", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIdSet)});
                CacheMrg.clearAllCache();
            }
            catch (Exception e) {
                log.warn("ComRoleService.delRoleRelationData error\uff0c roleIdSet\uff1a{}", (Object)e, (Object)JSON.toJSONString(roleIdSet));
                h.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    @SdkInternal
    public static void saveOrDel(ComRoleOperationReq comRoleOperationReq) {
        boolean isClearAllCache;
        ComRoleService.saveOrDel2PermLog(comRoleOperationReq);
        boolean bl = isClearAllCache = StringUtils.isEmpty((String)comRoleOperationReq.getNeedClearAllCache()) || Objects.equals("1", comRoleOperationReq.getNeedClearAllCache());
        if (isClearAllCache) {
            CacheMrg.clearAllCache();
        }
        Set roleIdSet = comRoleOperationReq.getMainIdSet();
        boolean isPermChangeNotice = StringUtils.isEmpty((String)comRoleOperationReq.getPermChangeNotice()) || Objects.equals("1", comRoleOperationReq.getPermChangeNotice());
        Map roleUserIdSetMap = isPermChangeNotice ? PermRoleHelper.getRoleUserIdSetMap((Set)roleIdSet) : null;
        Map diffContentMap = comRoleOperationReq.getDiffContentMap();
        for (String roleId : roleIdSet) {
            if (!isPermChangeNotice) continue;
            Set roleUserIdSet = (Set)roleUserIdSetMap.get(roleId);
            ComRoleService.permChangeNotice(diffContentMap, roleId, roleUserIdSet);
        }
    }

    private static void permChangeNotice(Map<String, Map<String, Object>> diffContentMap, String roleId, Set<Long> roleUserIdSet) {
        try {
            if (!PermCommonUtil.isEnableAuthorityChangeNotice()) {
                return;
            }
            if (null == roleUserIdSet || CollectionUtils.isEmpty(roleUserIdSet)) {
                return;
            }
            Map<Object, Object> saveDiffMap = null == diffContentMap.get(roleId) ? new HashMap(0) : diffContentMap.get(roleId);
            List delNewDrPerm = (List)saveDiffMap.get("delNewDrPerm");
            List addNewDrPerm = (List)saveDiffMap.get("addNewDrPerm");
            List updateNewDrPerm = (List)saveDiffMap.get("updateNewDrPerm");
            List delNewDrPrPerm = (List)saveDiffMap.get("delNewDrPrPerm");
            List addNewDrPrPerm = (List)saveDiffMap.get("addNewDrPrPerm");
            List updateNewDrPrPerm = (List)saveDiffMap.get("updateNewDrPrPerm");
            HashSet newDRAppEntityAllSet = new HashSet(16);
            if (!CollectionUtils.isEmpty((Collection)delNewDrPerm)) {
                newDRAppEntityAllSet.addAll(delNewDrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityId()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)addNewDrPerm)) {
                newDRAppEntityAllSet.addAll(addNewDrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityId()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)updateNewDrPerm)) {
                newDRAppEntityAllSet.addAll(updateNewDrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityId()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)delNewDrPrPerm)) {
                newDRAppEntityAllSet.addAll(delNewDrPrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityId()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)addNewDrPrPerm)) {
                newDRAppEntityAllSet.addAll(addNewDrPrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityId()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)updateNewDrPrPerm)) {
                newDRAppEntityAllSet.addAll(updateNewDrPrPerm.stream().map(rule -> rule.getAppId() + "|" + rule.getEntityId()).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty(newDRAppEntityAllSet)) {
                List newDRAppEntityList = newDRAppEntityAllSet.stream().map(x -> {
                    String[] split = x.split("\\|", 2);
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    map.put(split[0], split[1]);
                    return map;
                }).collect(Collectors.toList());
                PermCommonUtil.cancelShowForm(new ArrayList<Long>(roleUserIdSet), newDRAppEntityList, (boolean)false);
            }
        }
        catch (Exception e) {
            log.warn("ComRoleService.permChangeNotice error", (Throwable)e);
        }
    }

    private static void saveOrDel2PermLog(ComRoleOperationReq comRoleOperationReq) {
        PermLogReq permLogReq = comRoleOperationReq.getPermLogReq();
        if (!PermCommonUtil.isEnablePermLog() || null == permLogReq) {
            return;
        }
        Map diffContentMap = comRoleOperationReq.getDiffContentMap();
        Set roleIdSet = comRoleOperationReq.getMainIdSet();
        Set set = roleIdSet = null == roleIdSet || roleIdSet.isEmpty() ? diffContentMap.keySet() : roleIdSet;
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return;
        }
        try {
            boolean del = permLogReq.getBusiType().contains("_del");
            Map preComRoleBaseMap = comRoleOperationReq.getPreComRoleBaseMap();
            preComRoleBaseMap = null == preComRoleBaseMap ? new HashMap(0) : preComRoleBaseMap;
            Map afterComRoleBaseMap = PermRoleHelper.getComRoleBaseMap((Set)roleIdSet, null);
            Map influenUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap((Set)roleIdSet);
            int size = roleIdSet.size();
            ArrayList list = new ArrayList(size);
            for (String roleId : roleIdSet) {
                HashMap<String, Object> comRoleIdSaveDiff;
                boolean existDiff;
                ComRole comRole;
                ComRole preComRole = (ComRole)preComRoleBaseMap.get(roleId);
                ComRole afterComRole = (ComRole)afterComRoleBaseMap.get(roleId);
                ComRole comRole2 = comRole = null == afterComRole ? preComRole : afterComRole;
                if (!del && null == comRole || !(existDiff = ComRoleService.existDiff(comRoleIdSaveDiff = null == diffContentMap.get(roleId) ? new HashMap(8) : (Map)diffContentMap.get(roleId), preComRole, afterComRole))) continue;
                String opItemId = roleId;
                String opItemName = "";
                String opItemNumber = "";
                if (null == comRole) continue;
                opItemName = comRole.getName();
                opItemNumber = comRole.getNumber();
                Set influenUserIdSet = null == influenUserIdSetMap.get(roleId) ? new HashSet(0) : (Set)influenUserIdSetMap.get(roleId);
                comRoleIdSaveDiff.put("influenUserIdSet", influenUserIdSet);
                comRoleIdSaveDiff.put("langStr", RequestContext.get().getLang().name());
                comRoleIdSaveDiff.put("baseInfoDB_pre", null != preComRole ? preComRole : new ComRole());
                comRoleIdSaveDiff.put("baseInfoDB_after", null != afterComRole ? afterComRole : new ComRole());
                HashMap<String, Object> map = new HashMap<String, Object>(20);
                map.put("number", permLogReq.getPermNumberSelfGen() != false ? permLogReq.getPermNumber() : PermLogUtil.getPermLogFnumber());
                map.put("busi_from", permLogReq.getBusiFrom());
                map.put("busi_type", permLogReq.getBusiType());
                map.put("cloud_id", permLogReq.getCloudId());
                map.put("app_id", permLogReq.getAppId());
                map.put("form_identity", permLogReq.getFormIdentity());
                map.put("op", permLogReq.getOp());
                map.put("opbtn", permLogReq.getOpbtn());
                map.put("interface_method", permLogReq.getInterfaceMethod());
                map.put("op_item_id", opItemId);
                map.put("op_item_number", opItemNumber);
                map.put("op_item_name", opItemName);
                map.put("pre_data", permLogReq.getPreData());
                map.put("after_data", permLogReq.getAfterData());
                String saveDiffStr = StrUtil.compress((String)new ObjectMapper().writeValueAsString(comRoleIdSaveDiff));
                map.put("diff_content", saveDiffStr);
                map.put("oper_id", RequestContext.get().getCurrUserId());
                map.put("oper_org_id", RequestContext.get().getOrgId());
                map.put("oper_time", permLogReq.getOperTime());
                map.put("client_type", permLogReq.getClientType());
                map.put("client_ip", permLogReq.getClientIp());
                map.put("client_name", permLogReq.getClientType());
                list.add(map);
            }
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("ComRoleService.saveOrDel2PermLog error, mainIdSet:{}", (Object)JSON.toJSONString((Object)roleIdSet), (Object)e);
        }
    }

    private static boolean existDiff(Map<String, Object> comRoleIdSaveDiff, ComRole preComRole, ComRole afterComRole) {
        Set addComRoleAdminGrp;
        preComRole = null != preComRole ? preComRole : new ComRole();
        ComRole comRole = afterComRole = null != afterComRole ? afterComRole : new ComRole();
        if (!preComRole.equals((Object)afterComRole)) {
            return true;
        }
        if (null == comRoleIdSaveDiff || comRoleIdSaveDiff.isEmpty()) {
            return false;
        }
        Set delPermItem = null == comRoleIdSaveDiff.get("delPermItem") ? null : (Set)comRoleIdSaveDiff.get("delPermItem");
        Set addPermItem = null == comRoleIdSaveDiff.get("addPermItem") ? null : (Set)comRoleIdSaveDiff.get("addPermItem");
        Set delFieldPerm = null == comRoleIdSaveDiff.get("delFieldPerm") ? null : (Set)comRoleIdSaveDiff.get("delFieldPerm");
        Set addFieldPerm = null == comRoleIdSaveDiff.get("addFieldPerm") ? null : (Set)comRoleIdSaveDiff.get("addFieldPerm");
        Set delFpsPerm = null == comRoleIdSaveDiff.get("delFpsPerm") ? null : (Set)comRoleIdSaveDiff.get("delFpsPerm");
        Set addFpsPerm = null == comRoleIdSaveDiff.get("addFpsPerm") ? null : (Set)comRoleIdSaveDiff.get("addFpsPerm");
        Set delNewDrPerm = null == comRoleIdSaveDiff.get("delNewDrPerm") ? null : (Set)comRoleIdSaveDiff.get("delNewDrPerm");
        Set addNewDrPerm = null == comRoleIdSaveDiff.get("addNewDrPerm") ? null : (Set)comRoleIdSaveDiff.get("addNewDrPerm");
        Set delNewDrPrPerm = null == comRoleIdSaveDiff.get("delNewDrPrPerm") ? null : (Set)comRoleIdSaveDiff.get("delNewDrPrPerm");
        Set addNewDrPrPerm = null == comRoleIdSaveDiff.get("addNewDrPrPerm") ? null : (Set)comRoleIdSaveDiff.get("addNewDrPrPerm");
        Set delComRoleAdminGrp = null == comRoleIdSaveDiff.get("delComRoleAdminGrp") ? null : (Set)comRoleIdSaveDiff.get("delComRoleAdminGrp");
        Set set = addComRoleAdminGrp = null == comRoleIdSaveDiff.get("addComRoleAdminGrp") ? null : (Set)comRoleIdSaveDiff.get("addComRoleAdminGrp");
        return !CollectionUtils.isEmpty((Collection)delPermItem) || !CollectionUtils.isEmpty((Collection)addPermItem) || !CollectionUtils.isEmpty((Collection)delFieldPerm) || !CollectionUtils.isEmpty((Collection)addFieldPerm) || !CollectionUtils.isEmpty((Collection)delFpsPerm) || !CollectionUtils.isEmpty((Collection)addFpsPerm) || !CollectionUtils.isEmpty((Collection)delNewDrPerm) || !CollectionUtils.isEmpty((Collection)addNewDrPerm) || !CollectionUtils.isEmpty((Collection)delNewDrPrPerm) || !CollectionUtils.isEmpty((Collection)addNewDrPrPerm) || !CollectionUtils.isEmpty((Collection)delComRoleAdminGrp) || !CollectionUtils.isEmpty((Collection)addComRoleAdminGrp);
    }
}

