/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.api.group.Query;
import kd.bos.permission.api.group.Update;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.DirectAuthorizeHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.query.ChoiceFieldPageCustomQuery;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLogUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.EnumsYesNo;
import kd.bos.permission.enums.OperationTypeEnum;
import kd.bos.permission.log.model.LogDimField;
import kd.bos.permission.log.model.LogDimFunc;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.App;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.DimNewDrPerm;
import kd.bos.permission.model.perm.DimNewDrPrPerm;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.FieldPerm;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.UserFieldPerm;
import kd.bos.permission.model.perm.UserFieldPermScheme;
import kd.bos.permission.model.perm.UserFuncPerm;
import kd.bos.permission.model.perm.imp.UserDirectPermImportBean;
import kd.bos.permission.model.perm.req.DimFuncPermReq;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.UserDirectPermReq;
import kd.bos.permission.model.perm.req.UserPermCopyReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.bat.PermCheckReq;
import kd.bos.permission.model.perm.req.bat.afterdel.UserDirectPermAfterDelReq;
import kd.bos.permission.model.perm.req.bat.aftersave.UserDirectPermAfterSaveReq;
import kd.bos.permission.model.perm.req.common.GetBaseDataDynMapReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermUserReq;
import kd.bos.permission.model.perm.req.permitem.GetPlainPermItemListReq;
import kd.bos.permission.model.perm.req.user.GetUserFuncDimReq;
import kd.bos.permission.model.perm.req.user.UserDirectAssignPermReq;
import kd.bos.permission.model.perm.req.user.UserDirectAssignReq;
import kd.bos.permission.model.perm.resp.GetUserAllPermResp;
import kd.bos.permission.model.perm.resp.GetUserFieldPermResp;
import kd.bos.permission.model.perm.resp.GetUserFuncPermResp;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.model.perm.resp.common.GetBaseDataDynMapResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermUserResp;
import kd.bos.permission.model.perm.user.PermUser;
import kd.bos.permission.model.perm.user.UserDrDim;
import kd.bos.permission.model.perm.user.UserDrPrDim;
import kd.bos.permission.model.perm.user.UserFieldPermDim;
import kd.bos.permission.model.perm.user.UserFuncDim;
import kd.bos.permission.service.AbstractPermissionServiceImpl;
import kd.bos.permission.service.CommonService;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.permission.util.PermissionServiceImplFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;

public class UserDirectPermService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(UserDirectPermService.class);

    public GetUserFuncPermResp getUserFunctionPerm(UserDirectPermReq req) {
        super.checkPerm("bos_usergroup_user", "47150e89000000ac", (Object)req);
        this.validateReq(req, new Class[0]);
        Map userFunctionPerm = DirectAuthorizeHelper.getUserFunctionPerm((UserDirectPermReq)req);
        List<UserFuncPerm> userFuncPerm = this.getProcessedData(req, userFunctionPerm);
        return new GetUserFuncPermResp(userFuncPerm);
    }

    public GetUserFuncPermResp getUserDisFunctionPerm(UserDirectPermReq req) {
        super.checkPerm("bos_usergroup_user", "47150e89000000ac", (Object)req);
        this.validateReq(req, new Class[0]);
        Map userDisFunctionPerm = DirectAuthorizeHelper.getUserDisFunctionPerm((UserDirectPermReq)req);
        List<UserFuncPerm> userDisFuncPerm = this.getProcessedData(req, userDisFunctionPerm);
        return new GetUserFuncPermResp(userDisFuncPerm);
    }

    private List<UserFuncPerm> getProcessedData(UserDirectPermReq req, Map<String, Set<String>> data) {
        ArrayList<UserFuncPerm> list;
        Long userId = req.getUserId();
        if (CollectionUtils.isEmpty(data)) {
            list = new ArrayList<UserFuncPerm>(16);
        } else {
            list = new ArrayList(data.size());
            Map allAppIdNameMap = AppHelper.getAllAppIdNameMap();
            Map allEntityNameMap = FormHelper.getAllEntityNameMap((String)RequestContext.get().getLang().name());
            Map allPermItemInfoMap = PermItemHelper.getAllPermItemInfoMap();
            for (Map.Entry<String, Set<String>> entry : data.entrySet()) {
                String[] dimInfo = entry.getKey().split("\\|");
                UserFuncPerm userFuncPerm = new UserFuncPerm();
                userFuncPerm.setUserId(userId);
                userFuncPerm.setDimId(Long.valueOf(Long.parseLong(dimInfo[0])));
                userFuncPerm.setIncludeSub(Boolean.valueOf(dimInfo[1].equals("1")));
                Set<String> value = entry.getValue();
                LinkedHashSet<PermItem> funcPermSet = new LinkedHashSet<PermItem>(value.size());
                userFuncPerm.setFuncPermSet(funcPermSet);
                for (String perm : value) {
                    String[] permInfo = perm.split("\\|");
                    String appId = permInfo[0];
                    String appName = (String)allAppIdNameMap.get(appId);
                    String entityNum = permInfo[1];
                    String entityName = (String)allEntityNameMap.get(entityNum);
                    String permItemId = permInfo[2];
                    Map permItemInfo = (Map)allPermItemInfoMap.get(permItemId);
                    String permItemName = (String)permItemInfo.get("name");
                    String permItemNumber = (String)permItemInfo.get("number");
                    PermItem permItem = new PermItem();
                    permItem.setAppId(appId);
                    permItem.setAppName(appName);
                    permItem.setEntityNumber(entityNum);
                    permItem.setEntityName(entityName);
                    permItem.setPermItemId(permItemId);
                    permItem.setPermItemName(permItemName);
                    permItem.setPermItemNumber(permItemNumber);
                    funcPermSet.add(permItem);
                }
                list.add(userFuncPerm);
            }
        }
        return list;
    }

    public GetUserFieldPermResp getUserFieldPerm(UserDirectPermReq req) {
        ArrayList<UserFieldPerm> list;
        super.checkPerm("bos_usergroup_user", "47150e89000000ac", (Object)req);
        this.validateReq(req, new Class[0]);
        Long userId = req.getUserId();
        Map userFieldPerms = DirectAuthorizeHelper.getUserFieldPerm((UserDirectPermReq)req);
        if (CollectionUtils.isEmpty((Map)userFieldPerms)) {
            list = new ArrayList<UserFieldPerm>(16);
        } else {
            list = new ArrayList(userFieldPerms.size());
            Map allAppIdNameMap = AppHelper.getAllAppIdNameMap();
            Map allEntityNameMap = FormHelper.getAllEntityNameMap((String)RequestContext.get().getLang().name());
            for (Map.Entry entry : userFieldPerms.entrySet()) {
                String[] dimInfo = ((String)entry.getKey()).split("\\|");
                UserFieldPerm userFieldPerm = new UserFieldPerm();
                userFieldPerm.setUserId(userId);
                userFieldPerm.setDimId(Long.valueOf(Long.parseLong(dimInfo[0])));
                userFieldPerm.setIncludeSub(Boolean.valueOf(dimInfo[1].equals("1")));
                Map appEntityMap = (Map)entry.getValue();
                HashSet<FieldPerm> fieldPermSet = new HashSet<FieldPerm>(100);
                userFieldPerm.setFieldPermSet(fieldPermSet);
                for (Map.Entry appEntity : appEntityMap.entrySet()) {
                    String appKey = (String)appEntity.getKey();
                    String[] appEntityInfo = appKey.split("\\|");
                    String appId = appEntityInfo[0];
                    String entityNum = appEntityInfo[1];
                    String appName = (String)allAppIdNameMap.get(appId);
                    String entityName = (String)allEntityNameMap.get(entityNum);
                    MainEntityType mainEntityType = null;
                    try {
                        mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
                    }
                    catch (Exception e) {
                        log.warn("UserDirectPermService.getUserFieldPerm getDataEntityType error, entityNum:{}", (Object)entityNum);
                        continue;
                    }
                    List fieldNameInfo = new ChoiceFieldPageCustomQuery().parseProperty((IDataEntityType)mainEntityType);
                    HashMap fieldNameMap = new HashMap(fieldNameInfo.size());
                    for (Map fieldNameDetail : fieldNameInfo) {
                        fieldNameMap.put(fieldNameDetail.get("field_id"), fieldNameDetail.get("field_name"));
                    }
                    Set fieldPermValue = (Set)appEntity.getValue();
                    for (String value : fieldPermValue) {
                        String[] field = value.split("\\|");
                        String fieldName = field[0];
                        String mode = field[1];
                        String fieldComment = (String)fieldNameMap.get(fieldName);
                        String modeDesc = mode.equals("10") ? ResManager.loadKDString((String)"\u7981\u6b62\u67e5\u770b", (String)"UserDirectPermService_0", (String)"bos-mservice-permission", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u6b62\u7f16\u8f91", (String)"UserDirectPermService_1", (String)"bos-mservice-permission", (Object[])new Object[0]);
                        FieldPerm fieldPerm = new FieldPerm();
                        fieldPerm.setAppId(appId);
                        fieldPerm.setAppName(appName);
                        fieldPerm.setEntityNumber(entityNum);
                        fieldPerm.setEntityName(entityName);
                        fieldPerm.setFieldName(fieldName);
                        fieldPerm.setFieldComment(fieldComment);
                        fieldPerm.setControlMode(mode);
                        fieldPerm.setControlModeDesc(modeDesc);
                        fieldPermSet.add(fieldPerm);
                    }
                }
                list.add(userFieldPerm);
            }
        }
        return new GetUserFieldPermResp(list);
    }

    public GetUserAllPermResp getUserAllPerm(UserDirectPermReq req) {
        super.checkPerm("bos_usergroup_user", "47150e89000000ac", (Object)req);
        this.validateReq(req, Query.class);
        GetUserFuncPermResp userFunctionPerm = this.getUserFunctionPerm(req);
        GetUserFuncPermResp userDisFunctionPerm = this.getUserDisFunctionPerm(req);
        GetUserFieldPermResp userFieldPerm = this.getUserFieldPerm(req);
        ArrayList drPerms = new ArrayList(10);
        ArrayList drPrPerms = new ArrayList(10);
        return new GetUserAllPermResp(userFunctionPerm.getFuncPerms(), userDisFunctionPerm.getFuncPerms(), userFieldPerm.getFieldPerms(), drPerms, drPrPerms);
    }

    public PermResult copyUserPerm(UserPermCopyReq req) {
        super.checkPerm("bos_usergroup_user", "47150e89000000ac", (Object)req);
        super.commonValidate((Object)req, new Class[]{Update.class});
        Long sourceUserId = req.getSourceUserId();
        List targetUserIds = req.getTargetUserIds();
        if (CollectionUtils.isEmpty((Collection)targetUserIds)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u76ee\u6807\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectPermService_2", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        if (targetUserIds.size() > 10) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u76ee\u6807\u7528\u6237\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc710\u3002", (String)"UserDirectPermService_3", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        long currUserId = RequestContext.get().getCurrUserId();
        UserScopeResult result = ((AbstractPermissionServiceImpl)PermissionServiceImplFactory.getImpl(null)).getAdminChargeUser(currUserId, false);
        if (!result.isAllUser()) {
            List changeUsers = result.getUserIDs();
            if (!changeUsers.contains(sourceUserId)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u4e0d\u5728\u60a8\u7684\u4eba\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserDirectPermService_4", (String)"bos-mservice-permission", (Object[])new Object[0]));
            }
            boolean includeTargetUser = true;
            ArrayList<String> userIds = new ArrayList<String>(10);
            for (Long targetUserId : targetUserIds) {
                if (changeUsers.contains(targetUserId)) continue;
                includeTargetUser = false;
                userIds.add(targetUserId + "");
            }
            if (!includeTargetUser) {
                String idStr = String.join((CharSequence)",", userIds);
                throw new RuntimeException(ResManager.loadKDString((String)"\u76ee\u6807\u7528\u6237\u201c%s\u201d\u4e0d\u5728\u60a8\u7684\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserDirectPermService_5", (String)"bos-mservice-permission", (Object[])new Object[]{idStr}));
            }
        }
        if (!(req.copyUserPerm() || req.copyDisFuncPerm() || req.copyRole() || req.copyBizRole())) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u6743\u9650\u3002", (String)"UserDirectPermService_6", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        return DirectAuthorizeHelper.copyUserPerm((UserPermCopyReq)req);
    }

    private void validateReq(UserDirectPermReq req, Class<?> ... groups) {
        super.commonValidate((Object)req, (Class[])groups);
        Long userId = req.getUserId();
        long currUserId = RequestContext.get().getCurrUserId();
        UserScopeResult result = ((AbstractPermissionServiceImpl)PermissionServiceImplFactory.getImpl(null)).getAdminChargeUser(currUserId, false);
        if (!result.isAllUser() && !result.getUserIDs().contains(userId)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u4e0d\u5728\u60a8\u7684\u4eba\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserDirectPermService_4", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
    }

    public PermCheckResp beforeSaveCheck(PermBeforeSaveCheckReq req) {
        if (null == req) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        List needCheckBeanList = req.getNeedCheckBeanList();
        if (CollectionUtils.isEmpty((Collection)needCheckBeanList)) {
            return new PermCheckResp(false, new HashMap(1), new HashMap(1), new HashMap(1));
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        if (null == checkNeedParamMap) {
            req.setCheckNeedParamMap(new HashMap(1));
        }
        boolean pass = true;
        HashMap<Integer, UserDirectPermImportBean> passedMap = new HashMap<Integer, UserDirectPermImportBean>(10);
        LinkedHashMap<Integer, List<String>> failedErrorMap = new LinkedHashMap<Integer, List<String>>(8);
        LinkedHashMap<String, List<String>> numFailedErrorMap = new LinkedHashMap<String, List<String>>(8);
        boolean failFast = req.isFailFast();
        OperationTypeEnum operationTypeEnum = null;
        EnumsImportType enumsImportType = req.getEnumsImportType();
        if (EnumsImportType.NEW != enumsImportType) {
            throw new KDBizException("unsurpport importType.");
        }
        operationTypeEnum = OperationTypeEnum.ADD;
        for (UserDirectPermImportBean willSaveBean : needCheckBeanList) {
            if (null == willSaveBean) continue;
            willSaveBean.setOperationTypeEnum(operationTypeEnum);
            try {
                boolean oneSuccess = this.doBeforeSaveCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
                if (!oneSuccess && failFast) {
                    pass = false;
                    break;
                }
                if (oneSuccess || failFast) continue;
                pass = false;
            }
            catch (Throwable throwable) {
                log.warn(throwable);
                throw throwable;
            }
        }
        PermCheckResp permCheckResp = new PermCheckResp(pass, passedMap, failedErrorMap, numFailedErrorMap);
        super.beforeSaveCheckExt(req);
        return permCheckResp;
    }

    private boolean doBeforeSaveCheck(PermBeforeSaveCheckReq req, UserDirectPermImportBean willSaveBean, Map<Integer, UserDirectPermImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        boolean checkResult = this.importCommonCheck(req, willSaveBean, passedMap, failedErrorMap, numFailedErrorMap);
        boolean failFast = req.isFailFast();
        if (failFast) {
            return checkResult;
        }
        return checkResult;
    }

    private boolean importCommonCheck(PermBeforeSaveCheckReq req, UserDirectPermImportBean willSaveBean, Map<Integer, UserDirectPermImportBean> passedMap, Map<Integer, List<String>> failedErrorMap, Map<String, List<String>> numFailedErrorMap) {
        Set entNumSet;
        Set adminChargeAppSet;
        Boolean includeSub;
        Set hasPermDimSet;
        Dim dim;
        Map dimNumExistMap;
        Map dimTypeAdminHasPermPermCtrlObjMap;
        String dimNum;
        Set userSet;
        PermUser permUser;
        Map userNumExistMap;
        boolean checkResult = true;
        boolean failFast = req.isFailFast();
        int lineNum = willSaveBean.getLineNum();
        String busiUniqueStr = willSaveBean.getNumber();
        OperationTypeEnum operationTypeEnum = willSaveBean.getOperationTypeEnum();
        if (null == operationTypeEnum) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u3002", (String)"ComRoleService_31", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map checkNeedParamMap = req.getCheckNeedParamMap();
        long currUserId = RequestContext.get().getCurrUserId();
        String userNumber = willSaveBean.getUserNumber();
        if (StringUtils.isEmpty((String)userNumber.trim())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u7528\u6237\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_22", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map map = userNumExistMap = null == checkNeedParamMap.get("userNumExistMap") ? PermVerifyUtil.getExistMapByNum((String)"bos_user", (Set)Sets.newHashSet((Object[])new String[]{userNumber})) : (Map)checkNeedParamMap.get("userNumExistMap");
        if (null == userNumExistMap.get(userNumber) || !((Boolean)userNumExistMap.get(userNumber)).booleanValue()) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_12", (String)"bos-mservice-permission", (Object[])new Object[0]), userNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        String dimType = willSaveBean.getDimType();
        GetHasPermUserResp hasPermUser = null;
        if (null == checkNeedParamMap.get("dimTypeAdminHasPermUserMap")) {
            hasPermUser = PermCtrlTypeService.getAdminHasPermUser((GetHasPermUserReq)new GetHasPermUserReq(dimType, Long.valueOf(currUserId), null, (Set)Sets.newHashSet((Object[])new String[]{userNumber})));
        } else {
            Map dimTypeAdminHasPermUserMap = (Map)checkNeedParamMap.get("dimTypeAdminHasPermUserMap");
            GetHasPermUserResp getHasPermUserResp = hasPermUser = CollectionUtils.isEmpty((Map)dimTypeAdminHasPermUserMap) ? null : (GetHasPermUserResp)dimTypeAdminHasPermUserMap.get(dimType);
        }
        if (null != hasPermUser && !hasPermUser.isHasAllUser() && null == (permUser = (PermUser)(userSet = hasPermUser.getUserSet()).stream().filter(x -> Objects.equals(userNumber, x.getUserNumber())).findFirst().orElse(null))) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u884c\u653f\u7ec4\u7ec7\u8303\u56f4\u5185\u6216\u4f8b\u5916\u4eba\u5458\u8303\u56f4\u5185\u3002", (String)"UserRoleService_13", (String)"bos-mservice-permission", (Object[])new Object[0]), userNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)(dimNum = willSaveBean.getDimNum()).trim())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_21", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        GetHasPermPermCtrlObjResp hasPermDimResult = null;
        hasPermDimResult = null == checkNeedParamMap.get("dimTypeAdminHasPermPermCtrlObjMap") ? PermCtrlTypeService.getAdminHasPermPermCtrlObj((GetHasPermPermCtrlObjReq)new GetHasPermPermCtrlObjReq(dimType, Long.valueOf(currUserId), null, (Set)Sets.newHashSet((Object[])new String[]{dimNum}))) : (CollectionUtils.isEmpty((Map)(dimTypeAdminHasPermPermCtrlObjMap = (Map)checkNeedParamMap.get("dimTypeAdminHasPermPermCtrlObjMap"))) ? null : (GetHasPermPermCtrlObjResp)dimTypeAdminHasPermPermCtrlObjMap.get(dimType));
        String dimTypeNumBig = willSaveBean.getDimTypeBig();
        if (StringUtils.isNotEmpty((String)dimTypeNumBig)) {
            Map permCtrlTypeNumMap = null == checkNeedParamMap.get("bigPermCtrlTypeMap") ? IsoDimHelper.getBigPermCtrlTypeMap((PermCtrlTypeReq)new PermCtrlTypeReq(null, null, null, null, null)) : (Map)checkNeedParamMap.get("bigPermCtrlTypeMap");
            PermCtrlType bigPermCtrlType = (PermCtrlType)permCtrlTypeNumMap.get(dimTypeNumBig);
            if (null == bigPermCtrlType) {
                this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u7c7b\u578b\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_41", (String)"bos-mservice-permission", (Object[])new Object[0]), dimTypeNumBig));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            }
        } else if (StringUtils.isEmpty((String)dimTypeNumBig.trim())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_20", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        HashMap<String, Map> dimTypeDimNumExistMap = null;
        if (null == checkNeedParamMap.get("dimTypeDimNumExistMap")) {
            dimNumExistMap = PermVerifyUtil.getExistMapByNum((String)dimType, (Set)Sets.newHashSet((Object[])new String[]{dimNum}));
            dimTypeDimNumExistMap = new HashMap<String, Map>(8);
            dimTypeDimNumExistMap.put(dimType, dimNumExistMap);
        } else {
            dimTypeDimNumExistMap = (HashMap<String, Map>)checkNeedParamMap.get("dimTypeDimNumExistMap");
        }
        if (!(CollectionUtils.isEmpty((Map)dimTypeDimNumExistMap) || CollectionUtils.isEmpty((Map)((Map)dimTypeDimNumExistMap.get(dimType))) || null != (dimNumExistMap = (Map)dimTypeDimNumExistMap.get(dimType)).get(dimNum) && ((Boolean)dimNumExistMap.get(dimNum)).booleanValue())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_10", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (CollectionUtils.isEmpty((Map)dimTypeDimNumExistMap) || CollectionUtils.isEmpty((Map)((Map)dimTypeDimNumExistMap.get(dimType)))) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_10", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (null != hasPermDimResult && !hasPermDimResult.isHasAllDimPerm() && null == (dim = (Dim)(hasPermDimSet = hasPermDimResult.getHasPermDimSet()).stream().filter(x -> Objects.equals(dimNum, x.getDimNumber())).findFirst().orElse(null))) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserRoleService_11", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isEmpty((String)dimType) && null == hasPermDimResult) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5185\u3002", (String)"UserRoleService_11", (String)"bos-mservice-permission", (Object[])new Object[0]), dimNum));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (null == (includeSub = willSaveBean.getIncludeSub())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3a\u662f\u6216\u5426\u3002", (String)"UserRoleService_17", (String)"bos-mservice-permission", (Object[])new Object[0]));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        String appNumber = willSaveBean.getAppNumber();
        Map appMap = null == checkNeedParamMap.get("appMap") ? AppHelper.getAppMap((Set)Sets.newHashSet((Object[])new String[]{appNumber}), (String)"number") : (Map)checkNeedParamMap.get("appMap");
        String entityNumber = willSaveBean.getEntityNumber();
        Map entMap = null == checkNeedParamMap.get("entMap") ? FormHelper.getEntMap((Set)Sets.newHashSet((Object[])new String[]{entityNumber}), (String)"number") : (Map)checkNeedParamMap.get("entMap");
        String permItemNumber = willSaveBean.getPermItemNumber();
        Map permItemMap = null == checkNeedParamMap.get("permItemMap") ? PermItemHelper.getPermItemMap((Set)Sets.newHashSet((Object[])new String[]{permItemNumber}), (String)"number") : (Map)checkNeedParamMap.get("permItemMap");
        String permItemId = willSaveBean.getPermItemId();
        Map permItemExistMap = null == checkNeedParamMap.get("permItemExistMap") ? PermItemHelper.getPermItemMap((Set)Sets.newHashSet((Object[])new String[]{permItemId})) : (Map)checkNeedParamMap.get("permItemExistMap");
        HashSet plainPermItemSet = null;
        HashMap<String, Set> appNumEntNumSetMap = null;
        HashMap<String, Set> entNumPermItemNumSetMap = null;
        if (null == checkNeedParamMap.get("plainPermItemSet")) {
            GetPlainPermItemListReq getPlainPermItemListReq = new GetPlainPermItemListReq();
            getPlainPermItemListReq.setDimType("DIM_ORG");
            getPlainPermItemListReq.setReturnByField(true);
            getPlainPermItemListReq.setReturnFieldSet((Set)Sets.newHashSet((Object[])new String[]{"appNumber", "entityNumber", "permItemNumber"}));
            List plainPermItemList = PermItemHelper.getPlainPermItemList((GetPlainPermItemListReq)getPlainPermItemListReq);
            plainPermItemSet = new HashSet(plainPermItemList);
            appNumEntNumSetMap = new HashMap<String, Set>(8);
            entNumPermItemNumSetMap = new HashMap<String, Set>(8);
            for (PermItem permItem : plainPermItemSet) {
                appNumEntNumSetMap.computeIfAbsent(permItem.getAppNumber(), k -> new HashSet(8)).add(permItem.getEntityNumber());
                entNumPermItemNumSetMap.computeIfAbsent(permItem.getEntityNumber(), k -> new HashSet(8)).add(permItem.getPermItemNumber());
            }
        } else {
            plainPermItemSet = (HashSet)checkNeedParamMap.get("plainPermItemSet");
            appNumEntNumSetMap = (HashMap<String, Set>)checkNeedParamMap.get("appNumEntNumSetMap");
            entNumPermItemNumSetMap = (HashMap<String, Set>)checkNeedParamMap.get("entNumPermItemNumSetMap");
        }
        if (null == appMap || null == appMap.get(appNumber) || ((Set)appMap.get(appNumber)).isEmpty()) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_33", (String)"bos-mservice-permission", (Object[])new Object[0]), appNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        AppInfo appInfo = null;
        appInfo = null == checkNeedParamMap.get("allAppInfo") ? AppMetadataCache.getAppInfo((String)appNumber) : (AppInfo)((Map)checkNeedParamMap.get("allAppInfo")).get(appNumber);
        Set set = adminChargeAppSet = null == checkNeedParamMap.get("adminChargeAppSet") ? new HashSet(AdminPermCache.getAdminChargeApps((Long)RequestContext.get().getCurrUserId(), null)) : (Set)checkNeedParamMap.get("adminChargeAppSet");
        if (null == appInfo || !adminChargeAppSet.contains(appInfo.getId())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5728\u5f53\u524d\u7528\u6237\u7684\u7ba1\u7406\u5458\u5206\u7ec4\u7684\u5e94\u7528\u8303\u56f4\u5185\u3002", (String)"ComRoleService_49", (String)"bos-mservice-permission", (Object[])new Object[0]), appNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (null == entMap || null == entMap.get(entityNumber) || ((Set)entMap.get(entityNumber)).isEmpty()) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_45", (String)"bos-mservice-permission", (Object[])new Object[0]), entityNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isNotEmpty((String)dimTypeNumBig)) {
            String formPermCtrlType = "";
            if (null == checkNeedParamMap.get("formCtrlTypeMap")) {
                PermissionControlType permissionControlType = FormHelper.getPermissionControlType((String)entityNumber);
                boolean controlFunction = permissionControlType.isControlFunction();
                boolean emptyObject = permissionControlType.isEmptyObject();
                String dimension = permissionControlType.getDimension();
                if (controlFunction && !emptyObject && StringUtils.isNotEmpty((String)dimension)) {
                    formPermCtrlType = dimension;
                }
            } else {
                Map formCtrlTypeMap = (Map)checkNeedParamMap.get("formCtrlTypeMap");
                formPermCtrlType = (String)formCtrlTypeMap.get(entityNumber);
            }
            if (StringUtils.isNotEmpty((String)formPermCtrlType) && !Objects.equals("DIM_NULL", formPermCtrlType) && !Objects.equals(dimTypeNumBig, formPermCtrlType)) {
                this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u201d%1$s\u201c\u7684\u6743\u9650\u63a7\u5236\u7c7b\u578b\u201d%2$s\u201c\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u7684\u6743\u9650\u63a7\u5236\u7c7b\u578b\u5e94\u8be5\u662f\u201d%3$s\u201c\u3002", (String)"UserDirectPermService_7", (String)"bos-mservice-permission", (Object[])new Object[0]), entityNumber, dimTypeNumBig, formPermCtrlType));
                checkResult = false;
                if (failFast) {
                    return checkResult;
                }
            }
        }
        if (null != (entNumSet = (Set)appNumEntNumSetMap.get(appNumber)) && !entNumSet.contains(entityNumber)) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleService_47", (String)"bos-mservice-permission", (Object[])new Object[0]), appNumber, entityNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isNotEmpty((String)permItemNumber) && (null == permItemMap || null == permItemMap.get(permItemNumber) || ((Set)permItemMap.get(permItemNumber)).isEmpty())) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u9879\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_46", (String)"bos-mservice-permission", (Object[])new Object[0]), permItemNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Set permItemSet = (Set)entNumPermItemNumSetMap.get(entityNumber);
        if (StringUtils.isNotEmpty((String)permItemNumber) && null != permItemSet && !permItemSet.contains(permItemNumber)) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201c%1$s\u201d\u4e0b\u65e0\u6743\u9650\u9879\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"ComRoleService_48", (String)"bos-mservice-permission", (Object[])new Object[0]), entityNumber, permItemNumber));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        if (StringUtils.isNotEmpty((String)permItemId) && null == permItemExistMap.get(permItemId)) {
            this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, String.format(ResManager.loadKDString((String)"\u6743\u9650\u9879id\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ComRoleService_59", (String)"bos-mservice-permission", (Object[])new Object[0]), permItemId));
            checkResult = false;
            if (failFast) {
                return checkResult;
            }
        }
        Map<String, UserFuncDim> userFuncDimMap = null;
        if (null == checkNeedParamMap.get("userFuncDimMap")) {
            HashMap<String, HashSet> dimTypeDimNumSetMap = new HashMap<String, HashSet>(8);
            dimTypeDimNumSetMap.put(dimType, Sets.newHashSet((Object[])new String[]{dimNum}));
            userFuncDimMap = UserDirectPermService.getUserFuncDimMap(new GetUserFuncDimReq(Integer.valueOf(1), null, null, (Set)Sets.newHashSet((Object[])new String[]{userNumber}), null, (Set)Sets.newHashSet((Object[])new String[]{appNumber}), (Set)Sets.newHashSet((Object[])new String[]{entityNumber}), null, (Set)Sets.newHashSet((Object[])new String[]{permItemNumber}), null, null, dimTypeDimNumSetMap));
        } else {
            userFuncDimMap = (Map<String, UserFuncDim>)checkNeedParamMap.get("userFuncDimMap");
        }
        if (StringUtils.isNotEmpty((String)userNumber)) {
            HashSet dimIdSet;
            Map userNumMap = null == checkNeedParamMap.get("userNumMap") ? UserHelper.getUserMap((Set)Sets.newHashSet((Object[])new String[]{userNumber}), (String)"number") : (Map)checkNeedParamMap.get("userNumMap");
            Set users = (Set)userNumMap.get(userNumber);
            Map<String, Map> dimTypeDimNumDimMap = null;
            if (null == checkNeedParamMap.get("dimTypeDimNumDimMap")) {
                dimTypeDimNumDimMap = new HashMap(8);
                Map dimNumDimSetMap = IsoDimHelper.getDimSetMap((Set)Sets.newHashSet((Object[])new String[]{dimNum}), (String)"number", (String)dimType);
                dimTypeDimNumDimMap.put(dimType, dimNumDimSetMap);
            } else {
                dimTypeDimNumDimMap = (Map)checkNeedParamMap.get("dimTypeDimNumDimMap");
            }
            Map dimNumDimMap = (Map)dimTypeDimNumDimMap.get(dimType);
            Set<Object> set2 = dimIdSet = null == dimNumDimMap ? new HashSet(1) : dimNumDimMap.values().stream().flatMap(x -> x.stream()).map(Dim::getDimId).collect(Collectors.toSet());
            if (!(CollectionUtils.isEmpty((Collection)users) || CollectionUtils.isEmpty(dimIdSet) || null == appMap || appMap.isEmpty() || null == appMap.get(appNumber) || ((Set)appMap.get(appNumber)).isEmpty() || null == entMap || entMap.isEmpty() || null == entMap.get(entityNumber) || ((Set)entMap.get(entityNumber)).isEmpty() || null == permItemMap || permItemMap.isEmpty() || null == permItemMap.get(permItemNumber) || ((Set)permItemMap.get(permItemNumber)).isEmpty())) {
                Set apps = (Set)appMap.get(appNumber);
                Set ents = (Set)entMap.get(entityNumber);
                Set permItems = (Set)permItemMap.get(permItemNumber);
                for (User user : users) {
                    for (App app : apps) {
                        for (Entity ent : ents) {
                            for (PermItem permItem : permItems) {
                                for (Long dimId : dimIdSet) {
                                    String key = user.getFid() + "|" + app.getAppId() + "|" + ent.getEntityNumber() + "|" + permItem.getPermItemId() + "|" + dimType + "|" + dimId;
                                    if (!userFuncDimMap.containsKey(key)) continue;
                                    this.wrapFaildMsg(lineNum, busiUniqueStr, failedErrorMap, numFailedErrorMap, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728\u3002", (String)"UserRoleService_18", (String)"bos-mservice-permission", (Object[])new Object[0]));
                                    checkResult = false;
                                    if (!failFast) continue;
                                    return checkResult;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (checkResult) {
            passedMap.put(lineNum, willSaveBean);
        }
        return checkResult;
    }

    public static Map<String, UserFuncDim> getUserFuncDimMap(GetUserFuncDimReq req) {
        HashMap<String, UserFuncDim> map = new HashMap<String, UserFuncDim>(8);
        List<QFilter> filterList = UserDirectPermService.getFilter(req);
        Integer returnType = req.getReturnType();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserDirectPermService.getUserFuncDimMap", (String)"perm_userpermdetail", (String)"id, user, bizapp, entitytype, permitem, dimtype, dimid, includesub", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            StringBuilder sb = null;
            UserFuncDim one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                one = new UserFuncDim();
                Long userId = row.getLong("user");
                String appId = row.getString("bizapp");
                String entNum = row.getString("entitytype");
                String permitemId = row.getString("permitem");
                String dimType = row.getString("dimtype");
                Long dimId = row.getLong("dimid");
                one.setId(row.getString("id"));
                one.setUserId(userId);
                one.setAppId(appId);
                one.setEntityNumber(entNum);
                one.setPermItemId(permitemId);
                one.setDimType(dimType);
                one.setDimId(dimId);
                one.setIncludeSub(row.getBoolean("includesub"));
                if (Objects.equals(1, returnType)) {
                    sb = new StringBuilder().append(userId).append("|").append(appId).append("|").append(entNum).append("|").append(permitemId).append("|").append(dimType).append("|").append(dimId);
                    map.put(sb.toString(), one);
                    continue;
                }
                if (!Objects.equals(2, returnType)) continue;
                map.put(row.getString("id"), one);
            }
        }
        return map;
    }

    public static Set<String> getDimTypeSet(GetUserFuncDimReq req) {
        HashSet<String> result = new HashSet<String>(8);
        List<QFilter> filterList = UserDirectPermService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserDirectPermService.getDimTypeSet", (String)"perm_userpermdetail", (String)"dimtype", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                result.add(row.getString("dimtype"));
            }
        }
        return result;
    }

    private static List<QFilter> getFilter(GetUserFuncDimReq req) {
        Map dimTypeDimNumSetMap;
        Set dimIdSet;
        Set dimTypeSet;
        Map permItemMap;
        Set collect;
        Set permItemNumSet;
        Set permItemIdSet;
        Set entNumSet;
        Map appMap;
        Set collect2;
        Set appNumSet;
        Set appIdSet;
        Map userMap;
        Set collect3;
        Set userNumberSet;
        Set userIdSet;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set mainIdSet = req.getMainIdSet();
        if (!CollectionUtils.isEmpty((Collection)mainIdSet)) {
            filterList.add(new QFilter("id", "in", (Object)mainIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(userIdSet = req.getUserIdSet()))) {
            filterList.add(new QFilter("user", "in", (Object)userIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(userNumberSet = req.getUserNumberSet())) && !CollectionUtils.isEmpty(collect3 = (userMap = UserHelper.getUserMap((Set)userNumberSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(User::getFid).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("user", "in", collect3));
        }
        if (!CollectionUtils.isEmpty((Collection)(appIdSet = req.getAppIdSet()))) {
            filterList.add(new QFilter("bizapp", "in", (Object)appIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(appNumSet = req.getAppNumSet())) && !CollectionUtils.isEmpty(collect2 = (appMap = AppHelper.getAppMap((Set)appNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(App::getAppId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("bizapp", "in", collect2));
        }
        if (!CollectionUtils.isEmpty((Collection)(entNumSet = req.getEntNumSet()))) {
            filterList.add(new QFilter("entitytype", "in", (Object)entNumSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(permItemIdSet = req.getPermItemIdSet()))) {
            filterList.add(new QFilter("permitem", "in", (Object)permItemIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(permItemNumSet = req.getPermItemNumSet())) && !CollectionUtils.isEmpty(collect = (permItemMap = PermItemHelper.getPermItemMap((Set)permItemNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(PermItem::getPermItemId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("permitem", "in", collect));
        }
        if (!CollectionUtils.isEmpty((Collection)(dimTypeSet = req.getDimTypeSet()))) {
            filterList.add(new QFilter("dimtype", "in", (Object)dimTypeSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(dimIdSet = req.getDimIdSet()))) {
            filterList.add(new QFilter("dimid", "in", (Object)dimIdSet));
        }
        if (null != (dimTypeDimNumSetMap = req.getDimTypeDimNumSetMap()) && !dimTypeDimNumSetMap.isEmpty()) {
            HashSet<String> innerDimTypeSet = new HashSet<String>(8);
            HashSet innerDimIdSet = new HashSet(8);
            for (Map.Entry dimTypeDimNumSet : dimTypeDimNumSetMap.entrySet()) {
                String dimType = (String)dimTypeDimNumSet.getKey();
                Set dimNumberSet = (Set)dimTypeDimNumSet.getValue();
                if (StringUtils.isEmpty((String)dimType) || CollectionUtils.isEmpty((Collection)dimNumberSet)) continue;
                Map dimNumDimSetMap = IsoDimHelper.getDimSetMap((Set)dimNumberSet, (String)"number", (String)dimType);
                Set collect4 = dimNumDimSetMap.values().stream().flatMap(x -> x.stream()).map(Dim::getDimId).collect(Collectors.toSet());
                innerDimTypeSet.add(dimType);
                innerDimIdSet.addAll(collect4);
            }
            if (!CollectionUtils.isEmpty(innerDimTypeSet)) {
                filterList.add(new QFilter("dimtype", "in", innerDimTypeSet));
            }
            if (!CollectionUtils.isEmpty(innerDimIdSet)) {
                filterList.add(new QFilter("dimid", "in", innerDimIdSet));
            }
        }
        return filterList;
    }

    public PermResult save(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        DynamicObject[] dataEntities = req.getDataEntities();
        OperateOption option = req.getOption();
        if (null != dataEntities && dataEntities.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        }
        super.saveExt(req);
        return PermResult.ok();
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            Set addUDRPRUserIdSet;
            Map addUDRPRMap;
            Set addUDRUserIdSet;
            Map addUDRMap;
            Set addUFPSUserIdSet;
            Map addUFPSMap;
            Set addUFPDUserIdSet;
            Map addUFPDMap;
            Set addUserUFDUserIdSet;
            HashSet<String> userIdSet = new HashSet<String>(8);
            UserDirectPermAfterSaveReq req = (UserDirectPermAfterSaveReq)reqOri;
            Map addUserUFDMap = req.getAddUserUFDMap();
            if (null != addUserUFDMap && !addUserUFDMap.isEmpty() && null != (addUserUFDUserIdSet = addUserUFDMap.keySet().stream().map(String::valueOf).collect(Collectors.toSet())) && !addUserUFDUserIdSet.isEmpty()) {
                userIdSet.addAll(addUserUFDUserIdSet);
            }
            if (null != (addUFPDMap = req.getAddUFPDMap()) && !addUFPDMap.isEmpty() && null != (addUFPDUserIdSet = addUFPDMap.keySet().stream().map(String::valueOf).collect(Collectors.toSet())) && !addUFPDUserIdSet.isEmpty()) {
                userIdSet.addAll(addUFPDUserIdSet);
            }
            if (null != (addUFPSMap = req.getAddUFPSMap()) && !addUFPSMap.isEmpty() && null != (addUFPSUserIdSet = addUFPSMap.keySet().stream().map(String::valueOf).collect(Collectors.toSet())) && !addUFPSUserIdSet.isEmpty()) {
                userIdSet.addAll(addUFPSUserIdSet);
            }
            if (null != (addUDRMap = req.getAddUDRMap()) && !addUDRMap.isEmpty() && null != (addUDRUserIdSet = addUDRMap.keySet().stream().map(String::valueOf).collect(Collectors.toSet())) && !addUDRUserIdSet.isEmpty()) {
                userIdSet.addAll(addUDRUserIdSet);
            }
            if (null != (addUDRPRMap = req.getAddUDRPRMap()) && !addUDRPRMap.isEmpty() && null != (addUDRPRUserIdSet = addUDRPRMap.keySet().stream().map(String::valueOf).collect(Collectors.toSet())) && !addUDRPRUserIdSet.isEmpty()) {
                userIdSet.addAll(addUDRPRUserIdSet);
            }
            Map<String, Map<String, Object>> diffDimFuncMap = UserDirectPermService.getDiffDimFuncMap(addUserUFDMap, null, null, userIdSet);
            Map<String, Map<String, Object>> diffDimFieldMap = UserDirectPermService.getDiffDimFieldMap(addUFPDMap, null, null, userIdSet);
            Map<String, Map<String, Object>> diffDimFpsMap = UserDirectPermService.getDiffDimFpsMap(addUFPSMap, null, null, userIdSet);
            Map<String, Map<String, Object>> diffDimDrMap = UserDirectPermService.getDiffDimDrMap(addUDRMap, null, null, userIdSet);
            Map<String, Map<String, Object>> diffDimDrPrMap = UserDirectPermService.getDiffDimDrPrMap(addUDRPRMap, null, null, userIdSet);
            Map<String, Map<String, Object>> userDiffDrAndPrMap = this.getUserDiffDrAndPrMap(diffDimDrMap, diffDimDrPrMap);
            CacheMrg.clearAllCache();
            PermCommonUtil.cancelShowForm(null == addUserUFDMap ? new ArrayList(0) : new ArrayList(addUserUFDMap.keySet()), null, (boolean)false);
            this.userFuncPermRelateChange2PermLog(diffDimFuncMap, diffDimFieldMap, diffDimFpsMap, userDiffDrAndPrMap, reqOri.getPermLogReq());
            super.afterMainEntitySaveExt((PermOperationReq)req);
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UserDirectPermService.afterMainEntitySave error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private Map<String, Map<String, Object>> getUserDiffDrAndPrMap(Map<String, Map<String, Object>> diffDimDrMap, Map<String, Map<String, Object>> diffDimDrPrMap) {
        Map<String, Object> value;
        String userId;
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(8);
        for (Map.Entry<String, Map<String, Object>> one : diffDimDrMap.entrySet()) {
            userId = one.getKey();
            value = one.getValue();
            result.computeIfAbsent(userId, k -> new HashMap(8)).put("newDrMap", value);
        }
        for (Map.Entry<String, Map<String, Object>> one : diffDimDrPrMap.entrySet()) {
            userId = one.getKey();
            value = one.getValue();
            result.computeIfAbsent(userId, k -> new HashMap(8)).put("newDrPrMap", value);
        }
        return result;
    }

    public PermCheckResp beforeDelCheck(PermCheckReq req) {
        PermCheckResp permCheckResp = super.beforeDelCheck(req);
        super.beforeDelCheckExt(req);
        return permCheckResp;
    }

    public PermResult del(PermOperationReq req) {
        String operationKey = req.getOperationKey();
        String entityNumber = req.getCurFormNum();
        Object[] ids = null == req.getMainIdSet() ? new Object[]{} : req.getMainIdSet().toArray();
        OperateOption option = req.getOption();
        if (null != ids && ids.length > 0) {
            OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        }
        super.delExt(req);
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            UserDirectPermAfterDelReq req = (UserDirectPermAfterDelReq)reqOri;
            Map delUserUFDMap = req.getDelUserUFDMap();
            if (null == delUserUFDMap || delUserUFDMap.isEmpty()) {
                return PermResult.ok();
            }
            Set<String> userIdSet = delUserUFDMap.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
            if (null == userIdSet || userIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<String, Map<String, Object>> diffDimFuncMap = UserDirectPermService.getDiffDimFuncMap(null, delUserUFDMap, null, userIdSet);
            CacheMrg.clearAllCache();
            PermCommonUtil.cancelShowForm(new ArrayList(delUserUFDMap.keySet()), null, (boolean)false);
            this.userFuncPermRelateChange2PermLog(diffDimFuncMap, null, null, null, reqOri.getPermLogReq());
            super.afterDelExt((PermOperationReq)req);
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UserDirectPermService.afterDel error.", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private void userFuncPermRelateChange2PermLog(Map<String, Map<String, Object>> userDiffDimFuncMap, Map<String, Map<String, Object>> userDiffDimFieldMap, Map<String, Map<String, Object>> userDiffDimFpsMap, Map<String, Map<String, Object>> userDiffDrAndPrMap, PermLogReq permLogReq) {
        try {
            if (!PermCommonUtil.isEnablePermLog() || null == permLogReq) {
                return;
            }
            userDiffDimFuncMap = null == userDiffDimFuncMap ? new HashMap(0) : userDiffDimFuncMap;
            userDiffDimFieldMap = null == userDiffDimFieldMap ? new HashMap(0) : userDiffDimFieldMap;
            userDiffDimFpsMap = null == userDiffDimFpsMap ? new HashMap(0) : userDiffDimFpsMap;
            HashMap hashMap = userDiffDrAndPrMap = null == userDiffDrAndPrMap ? new HashMap(0) : userDiffDrAndPrMap;
            if (CollectionUtils.isEmpty(userDiffDimFuncMap) && CollectionUtils.isEmpty(userDiffDimFieldMap) && CollectionUtils.isEmpty(userDiffDimFpsMap) && CollectionUtils.isEmpty(userDiffDrAndPrMap)) {
                return;
            }
            HashSet allUserIdSet = new HashSet(8);
            allUserIdSet.addAll(null == userDiffDimFuncMap.keySet() ? new HashSet(0) : userDiffDimFuncMap.keySet());
            allUserIdSet.addAll(null == userDiffDimFieldMap.keySet() ? new HashSet(0) : userDiffDimFieldMap.keySet());
            allUserIdSet.addAll(null == userDiffDimFpsMap.keySet() ? new HashSet(0) : userDiffDimFpsMap.keySet());
            allUserIdSet.addAll(null == userDiffDrAndPrMap.keySet() ? new HashSet(0) : userDiffDrAndPrMap.keySet());
            if (null == allUserIdSet || allUserIdSet.isEmpty()) {
                return;
            }
            Map userInfoMap = UserHelper.getUserInfoMapByIds(allUserIdSet.stream().map(Long::valueOf).collect(Collectors.toSet()), null);
            permLogReq.check(false);
            String[] permLogFnumbers = PermLogUtil.getPermLogFnumbers((Integer)allUserIdSet.size());
            int idx = 0;
            for (String oneUserId : allUserIdSet) {
                HashMap<String, Object> diffMap = new HashMap<String, Object>(3);
                diffMap.put("diffDimFuncMap", null == userDiffDimFuncMap.get(oneUserId) ? new HashMap(0) : userDiffDimFuncMap.get(oneUserId));
                diffMap.put("diffDimFieldMap", null == userDiffDimFieldMap.get(oneUserId) ? new HashMap(0) : userDiffDimFieldMap.get(oneUserId));
                diffMap.put("diffDimFpsMap", null == userDiffDimFpsMap.get(oneUserId) ? new HashMap(0) : userDiffDimFpsMap.get(oneUserId));
                diffMap.put("diffDrAndPrMap", null == userDiffDrAndPrMap.get(oneUserId) ? new HashMap(0) : userDiffDrAndPrMap.get(oneUserId));
                diffMap.put("langStr", RequestContext.get().getLang().name());
                diffMap.put("influenceUsers", Collections.singletonList(String.valueOf(oneUserId)));
                String formNum = permLogReq.getFormIdentity();
                String appId = StringUtils.isEmpty((String)permLogReq.getAppId()) ? BizAppServiceHelp.getAppIdByFormNum((String)formNum) : permLogReq.getAppId();
                String cloudId = StringUtils.isEmpty((String)permLogReq.getCloudId()) ? AppHelper.getMetaAppInfo((String)appId).getCloudId() : permLogReq.getCloudId();
                HashMap<String, Object> map = new HashMap<String, Object>(20);
                map.put("number", permLogFnumbers[idx]);
                map.put("busi_from", permLogReq.getBusiFrom());
                map.put("busi_type", permLogReq.getBusiType());
                map.put("cloud_id", cloudId);
                map.put("app_id", appId);
                map.put("form_identity", formNum);
                map.put("op", permLogReq.getOp());
                map.put("opbtn", permLogReq.getOpbtn());
                map.put("interface_method", permLogReq.getInterfaceMethod());
                map.put("op_item_id", permLogReq.getOpItemId());
                User user = (User)userInfoMap.get(Long.valueOf(oneUserId));
                if (null != user) {
                    map.put("op_item_number", user.getFnumber());
                    map.put("op_item_name", user.getFtruename());
                }
                map.put("diff_content", StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffMap)));
                map.put("oper_id", RequestContext.get().getCurrUserId());
                map.put("oper_org_id", RequestContext.get().getOrgId());
                map.put("oper_time", permLogReq.getOperTime());
                map.put("client_type", permLogReq.getClientType());
                map.put("client_ip", permLogReq.getClientIp());
                map.put("client_name", permLogReq.getClientType());
                ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
                list.add(map);
                BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
                BDLogHelper.addBDLog((BDLogInfo)info);
                ++idx;
            }
        }
        catch (Exception e) {
            log.warn("UserDirectPermService.userFuncPermRelateChange2PermLog error.", (Throwable)e);
        }
    }

    private static Map<String, Map<String, Object>> getDiffDimDrPrMap(Map<Long, Set<UserDrPrDim>> addUserUDRPRMap, Map<Long, Set<UserDrPrDim>> delUserUDRPRMap, Map<Long, Set<UserDrPrDim>> updateUserUDRPRMap, Set<String> userIdSet) {
        String DrDesc = ConstantsHelper.getDataRule();
        String delDesc = ConstantsHelper.getDel();
        EnumsDataChangeType delEDC = EnumsDataChangeType.DEL;
        String delOpDesc = delDesc + DrDesc;
        String addDesc = ConstantsHelper.getAdd();
        EnumsDataChangeType addEDC = EnumsDataChangeType.ADD;
        String addOpDesc = addDesc + DrDesc;
        String updateDesc = ConstantsHelper.getUpdate();
        EnumsDataChangeType updateEDC = EnumsDataChangeType.UPDATE;
        String updateOpDesc = updateDesc + DrDesc;
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(3);
        addUserUDRPRMap = null == addUserUDRPRMap ? new HashMap<Long, Set<UserDrPrDim>>(1) : addUserUDRPRMap;
        delUserUDRPRMap = null == delUserUDRPRMap ? new HashMap<Long, Set<UserDrPrDim>>(1) : delUserUDRPRMap;
        updateUserUDRPRMap = null == updateUserUDRPRMap ? new HashMap<Long, Set<UserDrPrDim>>(1) : updateUserUDRPRMap;
        for (String userId : userIdSet) {
            HashMap<String, List<DimNewDrPrPerm>> diffDimDrMap = new HashMap<String, List<DimNewDrPrPerm>>(3);
            diffDimDrMap.put("delDrPr", UserDirectPermService.getLogDimDrPrList(delUserUDRPRMap, delDesc, delEDC, delOpDesc));
            diffDimDrMap.put("addDrPr", UserDirectPermService.getLogDimDrPrList(addUserUDRPRMap, addDesc, addEDC, addOpDesc));
            diffDimDrMap.put("updateDrPr", UserDirectPermService.getLogDimDrPrList(updateUserUDRPRMap, updateDesc, updateEDC, updateOpDesc));
            resultMap.put(userId, diffDimDrMap);
        }
        return resultMap;
    }

    private static List<DimNewDrPrPerm> getLogDimDrPrList(Map<Long, Set<UserDrPrDim>> userUDRPRMap, String dimFuncDesc, EnumsDataChangeType DFC, String OpDesc) {
        ArrayList<DimNewDrPrPerm> list = new ArrayList<DimNewDrPrPerm>(10);
        DimNewDrPrPerm one = null;
        for (Map.Entry<Long, Set<UserDrPrDim>> userUDRPR : userUDRPRMap.entrySet()) {
            Long key = userUDRPR.getKey();
            Set<UserDrPrDim> value = userUDRPR.getValue();
            if (null == key || Objects.equals(0L, key) || null == value || value.isEmpty()) continue;
            for (UserDrPrDim userDrPrDim : value) {
                one = new DimNewDrPrPerm();
                String appId = userDrPrDim.getAppId();
                String entityNumber = userDrPrDim.getEntityNumber();
                one.setCloudId("");
                one.setAppId(appId);
                one.setEntityId(entityNumber);
                one.setPropKey(userDrPrDim.getPropKey());
                one.setPropEntNum(userDrPrDim.getPropEntNum());
                one.setDimId(userDrPrDim.getDimId());
                one.setIncludesuborg(userDrPrDim.getIncludesuborg());
                one.setDimType(userDrPrDim.getDimType());
                one.setOpDesc(OpDesc);
                one.setDataChangeType(DFC);
                one.setDataChangeTypeDesc(dimFuncDesc);
                one.setPreDataRuleId(userDrPrDim.getPreDataRuleId());
                one.setPreDataRuleName(userDrPrDim.getPreDataRuleName());
                one.setAfterDataRuleId(userDrPrDim.getAfterDataRuleId());
                one.setAfterDataRuleName(userDrPrDim.getAfterDataRuleName());
                list.add(one);
            }
        }
        return list;
    }

    private static Map<String, Map<String, Object>> getDiffDimDrMap(Map<Long, Set<UserDrDim>> addUserUDRMap, Map<Long, Set<UserDrDim>> delUserUDRMap, Map<Long, Set<UserDrDim>> updateUserUDRMap, Set<String> userIdSet) {
        String DrDesc = ConstantsHelper.getDataRule();
        String delDesc = ConstantsHelper.getDel();
        EnumsDataChangeType delEDC = EnumsDataChangeType.DEL;
        String delOpDesc = delDesc + DrDesc;
        String addDesc = ConstantsHelper.getAdd();
        EnumsDataChangeType addEDC = EnumsDataChangeType.ADD;
        String addOpDesc = addDesc + DrDesc;
        String updateDesc = ConstantsHelper.getUpdate();
        EnumsDataChangeType updateEDC = EnumsDataChangeType.UPDATE;
        String updateOpDesc = updateDesc + DrDesc;
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(3);
        addUserUDRMap = null == addUserUDRMap ? new HashMap<Long, Set<UserDrDim>>(1) : addUserUDRMap;
        delUserUDRMap = null == delUserUDRMap ? new HashMap<Long, Set<UserDrDim>>(1) : delUserUDRMap;
        updateUserUDRMap = null == updateUserUDRMap ? new HashMap<Long, Set<UserDrDim>>(1) : updateUserUDRMap;
        for (String userId : userIdSet) {
            HashMap<String, List<DimNewDrPerm>> diffDimDrMap = new HashMap<String, List<DimNewDrPerm>>(3);
            diffDimDrMap.put("delDr", UserDirectPermService.getLogDimDrList(delUserUDRMap, delDesc, delEDC, delOpDesc));
            diffDimDrMap.put("addDr", UserDirectPermService.getLogDimDrList(addUserUDRMap, addDesc, addEDC, addOpDesc));
            diffDimDrMap.put("updateDr", UserDirectPermService.getLogDimDrList(updateUserUDRMap, updateDesc, updateEDC, updateOpDesc));
            resultMap.put(userId, diffDimDrMap);
        }
        return resultMap;
    }

    private static List<DimNewDrPerm> getLogDimDrList(Map<Long, Set<UserDrDim>> userUDRMap, String dimFuncDesc, EnumsDataChangeType DFC, String OpDesc) {
        ArrayList<DimNewDrPerm> list = new ArrayList<DimNewDrPerm>(10);
        DimNewDrPerm one = null;
        for (Map.Entry<Long, Set<UserDrDim>> userUDR : userUDRMap.entrySet()) {
            Long key = userUDR.getKey();
            Set<UserDrDim> value = userUDR.getValue();
            if (null == key || Objects.equals(0L, key) || null == value || value.isEmpty()) continue;
            for (UserDrDim userDrDim : value) {
                one = new DimNewDrPerm();
                String appId = userDrDim.getAppId();
                String entityNumber = userDrDim.getEntityNumber();
                one.setCloudId("");
                one.setAppId(appId);
                one.setEntityId(entityNumber);
                one.setPermItemId(userDrDim.getPermItemId());
                one.setDimId(userDrDim.getDimId());
                one.setIncludesuborg(userDrDim.getIncludesuborg());
                one.setDimType(userDrDim.getDimType());
                one.setOpDesc(OpDesc);
                one.setDataChangeType(DFC);
                one.setDataChangeTypeDesc(dimFuncDesc);
                one.setPreDataRuleId(userDrDim.getPreDataRuleId());
                one.setPreDataRuleName(userDrDim.getPreDataRuleName());
                one.setAfterDataRuleId(userDrDim.getAfterDataRuleId());
                one.setAfterDataRuleName(userDrDim.getAfterDataRuleName());
                list.add(one);
            }
        }
        return list;
    }

    private static Map<String, Map<String, Object>> getDiffDimFpsMap(Map<Long, Set<UserFieldPermScheme>> addUserFPSMap, Map<Long, Set<UserFieldPermScheme>> delUserFPSMap, Map<Long, Set<UserFieldPermScheme>> updateUserFPSMap, Set<String> userIdSet) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(3);
        addUserFPSMap = null == addUserFPSMap ? new HashMap(0) : addUserFPSMap;
        delUserFPSMap = null == delUserFPSMap ? new HashMap(0) : delUserFPSMap;
        updateUserFPSMap = null == updateUserFPSMap ? new HashMap(0) : updateUserFPSMap;
        for (String userId : userIdSet) {
            Long userIdLong = Long.valueOf(userId);
            HashMap diffDimFpsMap = new HashMap(3);
            diffDimFpsMap.put("del", delUserFPSMap.get(userIdLong));
            diffDimFpsMap.put("add", addUserFPSMap.get(userIdLong));
            diffDimFpsMap.put("update", updateUserFPSMap.get(userIdLong));
            resultMap.put(userId, diffDimFpsMap);
        }
        return resultMap;
    }

    private static Map<String, Map<String, Object>> getDiffDimFieldMap(Map<Long, Set<UserFieldPermDim>> addUserUFPDMap, Map<Long, Set<UserFieldPermDim>> delUserUFPDMap, Map<Long, Set<UserFieldPermDim>> updateUserUFPDMap, Set<String> userIdSet) {
        String fieldPermDesc = ConstantsHelper.getFieldPerm();
        String delDesc = ConstantsHelper.getDel();
        EnumsDataChangeType delEDC = EnumsDataChangeType.DEL;
        String delOpDesc = delDesc + fieldPermDesc;
        String addDesc = ConstantsHelper.getAdd();
        EnumsDataChangeType addEDC = EnumsDataChangeType.ADD;
        String addOpDesc = addDesc + fieldPermDesc;
        String updateDesc = ConstantsHelper.getUpdate();
        EnumsDataChangeType updateEDC = EnumsDataChangeType.UPDATE;
        String updateOpDesc = updateDesc + fieldPermDesc;
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(3);
        addUserUFPDMap = null == addUserUFPDMap ? new HashMap<Long, Set<UserFieldPermDim>>(1) : addUserUFPDMap;
        delUserUFPDMap = null == delUserUFPDMap ? new HashMap<Long, Set<UserFieldPermDim>>(1) : delUserUFPDMap;
        updateUserUFPDMap = null == updateUserUFPDMap ? new HashMap<Long, Set<UserFieldPermDim>>(1) : updateUserUFPDMap;
        for (String userId : userIdSet) {
            HashMap<String, List<LogDimField>> diffDimFieldMap = new HashMap<String, List<LogDimField>>(3);
            diffDimFieldMap.put("del", UserDirectPermService.getLogDimFieldList(delUserUFPDMap, delDesc, delEDC, delOpDesc));
            diffDimFieldMap.put("add", UserDirectPermService.getLogDimFieldList(addUserUFPDMap, addDesc, addEDC, addOpDesc));
            diffDimFieldMap.put("update", UserDirectPermService.getLogDimFieldList(updateUserUFPDMap, updateDesc, updateEDC, updateOpDesc));
            resultMap.put(userId, diffDimFieldMap);
        }
        return resultMap;
    }

    private static List<LogDimField> getLogDimFieldList(Map<Long, Set<UserFieldPermDim>> userUFPDMap, String dimFuncDesc, EnumsDataChangeType DFC, String OpDesc) {
        ArrayList<LogDimField> list = new ArrayList<LogDimField>(10);
        LogDimField one = null;
        for (Map.Entry<Long, Set<UserFieldPermDim>> userUFPD : userUFPDMap.entrySet()) {
            Long key = userUFPD.getKey();
            Set<UserFieldPermDim> value = userUFPD.getValue();
            if (null == key || Objects.equals(0L, key) || null == value || value.isEmpty()) continue;
            for (UserFieldPermDim userFieldDim : value) {
                one = new LogDimField();
                String appId = userFieldDim.getAppId();
                String entityNumber = userFieldDim.getEntityNumber();
                one.setCloudId("");
                one.setAppId(appId);
                one.setEntityId(entityNumber);
                one.setFieldName(userFieldDim.getFieldName());
                one.setControlMode(userFieldDim.getControlMode());
                one.setDimId(userFieldDim.getDimId());
                one.setIncludesuborg(userFieldDim.getIncludeSub() != false ? "1" : "0");
                one.setDimType(userFieldDim.getDimType());
                one.setOpDesc(OpDesc);
                one.setDataChangeType(DFC);
                one.setDataChangeTypeDesc(dimFuncDesc);
                list.add(one);
            }
        }
        return list;
    }

    private static Map<String, Map<String, Object>> getDiffDimFuncMap(Map<Long, Set<UserFuncDim>> addUserUFDMap, Map<Long, Set<UserFuncDim>> delUserUFDMap, Map<Long, Set<UserFuncDim>> updateUserUFDMap, Set<String> userIdSet) {
        HashMap<Long, Map<String, Set<String>>> userAppEntSetMap = new HashMap<Long, Map<String, Set<String>>>(8);
        String funcPermDesc = ConstantsHelper.getFuncPerm();
        String dimFuncDelDesc = ConstantsHelper.getDel();
        EnumsDataChangeType delDFC = EnumsDataChangeType.DEL;
        String delOpDesc = dimFuncDelDesc + funcPermDesc;
        String dimFuncAddDesc = ConstantsHelper.getAdd();
        EnumsDataChangeType addDFC = EnumsDataChangeType.ADD;
        String addOpDesc = dimFuncAddDesc + funcPermDesc;
        String dimFuncUpdateDesc = ConstantsHelper.getUpdate();
        EnumsDataChangeType updateDFC = EnumsDataChangeType.UPDATE;
        String updateOpDesc = dimFuncUpdateDesc + funcPermDesc;
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(3);
        addUserUFDMap = null == addUserUFDMap ? new HashMap(1) : addUserUFDMap;
        delUserUFDMap = null == delUserUFDMap ? new HashMap(1) : delUserUFDMap;
        updateUserUFDMap = null == updateUserUFDMap ? new HashMap(1) : updateUserUFDMap;
        for (String string : userIdSet) {
            HashMap<String, List<LogDimFunc>> diffDimFuncMap = new HashMap<String, List<LogDimFunc>>(3);
            Long userIdL = Long.valueOf(string);
            diffDimFuncMap.put("del", UserDirectPermService.getLogDimFuncList(userIdL, (Set)delUserUFDMap.get(userIdL), dimFuncDelDesc, delDFC, delOpDesc, null));
            diffDimFuncMap.put("add", UserDirectPermService.getLogDimFuncList(userIdL, (Set)addUserUFDMap.get(userIdL), dimFuncAddDesc, addDFC, addOpDesc, userAppEntSetMap));
            diffDimFuncMap.put("update", UserDirectPermService.getLogDimFuncList(userIdL, (Set)updateUserUFDMap.get(userIdL), dimFuncUpdateDesc, updateDFC, updateOpDesc, userAppEntSetMap));
            resultMap.put(string, diffDimFuncMap);
        }
        if (null != userAppEntSetMap && !userAppEntSetMap.isEmpty()) {
            for (Map.Entry entry : userAppEntSetMap.entrySet()) {
                Long key = (Long)entry.getKey();
                Map value = (Map)entry.getValue();
                if (null == key || Objects.equals(0L, key) || null == value || value.isEmpty()) continue;
                HashMap<String, List> valueMap = new HashMap<String, List>(value.size());
                for (Map.Entry vv : value.entrySet()) {
                    String appId = (String)vv.getKey();
                    Set entNumSet = (Set)vv.getValue();
                    if (StringUtils.isEmpty((String)appId) || null == entNumSet || entNumSet.isEmpty()) continue;
                    valueMap.computeIfAbsent(appId, k -> new ArrayList(10)).addAll(entNumSet);
                }
                if (null == valueMap || valueMap.isEmpty()) continue;
                LicenseServiceHelper.addUserLicGroupByBizAppAndBizObj((Long)key, valueMap);
            }
        }
        return resultMap;
    }

    private static List<LogDimFunc> getLogDimFuncList(Long userIdL, Set<UserFuncDim> userUFDSet, String dimFuncDesc, EnumsDataChangeType DFC, String OpDesc, Map<Long, Map<String, Set<String>>> userAppEntListMap) {
        ArrayList<LogDimFunc> list = new ArrayList<LogDimFunc>(10);
        if (null == userUFDSet || userUFDSet.isEmpty()) {
            return list;
        }
        LogDimFunc one = null;
        for (UserFuncDim userFuncDim : userUFDSet) {
            one = new LogDimFunc();
            String appId = userFuncDim.getAppId();
            String entityNumber = userFuncDim.getEntityNumber();
            one.setUserId(userIdL);
            one.setCloudId("");
            one.setAppId(appId);
            one.setEntityId(entityNumber);
            one.setPermItemId(userFuncDim.getPermItemId());
            one.setDimId(userFuncDim.getDimId());
            one.setIncludesuborg(userFuncDim.getIncludeSub() != false ? "1" : "0");
            one.setDimType(userFuncDim.getDimType());
            one.setOpDesc(OpDesc);
            one.setDataChangeType(DFC);
            one.setDataChangeTypeDesc(dimFuncDesc);
            list.add(one);
            if (EnumsDataChangeType.ADD != DFC && EnumsDataChangeType.UPDATE != DFC) continue;
            userAppEntListMap.computeIfAbsent(userIdL, k -> new HashMap(8)).computeIfAbsent(appId, y -> new HashSet(8)).add(entityNumber);
        }
        return list;
    }

    public static PermResult userDirectAssignPerm(UserDirectAssignReq oriReq) {
        try {
            if (null == oriReq || null == oriReq.getReqList() || oriReq.getReqList().isEmpty()) {
                return PermResult.ok();
            }
            HashSet<Long> add_userIdSet = new HashSet<Long>(8);
            HashSet<String> add_appIdSet = new HashSet<String>(8);
            HashSet<String> add_entNumSet = new HashSet<String>(8);
            HashSet<String> add_permItemIdSet = new HashSet<String>(8);
            HashMap<String, Set> add_dimTypeDimIdSetMap = new HashMap<String, Set>(8);
            HashSet<String> add_fromTypeDescSet = new HashSet<String>(8);
            HashSet<Long> del_userIdSet = new HashSet<Long>(8);
            HashSet<String> del_dimTypeSet = new HashSet<String>(8);
            HashSet<Long> del_dimIdSet = new HashSet<Long>(8);
            HashSet<String> del_appIdSet = new HashSet<String>(8);
            HashSet<String> del_entNumSet = new HashSet<String>(8);
            HashSet<String> del_permItemIdSet = new HashSet<String>(8);
            HashSet<String> del_fromTypeDescSet = new HashSet<String>(8);
            List reqList = oriReq.getReqList();
            for (UserDirectAssignPermReq req : reqList) {
                List delList;
                Object one2;
                if (null == req) continue;
                Long userId = req.getUserId();
                String dimType = req.getDimType();
                if (null == userId || Objects.equals(0L, userId) || StringUtils.isEmpty((String)dimType)) continue;
                List addList = req.getAddList();
                if (null != addList && !addList.isEmpty()) {
                    add_userIdSet.add(userId);
                    for (Object one2 : addList) {
                        if (null == one2) continue;
                        add_dimTypeDimIdSetMap.computeIfAbsent(dimType, k -> new HashSet(8)).add(one2.getDimId());
                        add_appIdSet.add(one2.getAppId());
                        add_entNumSet.add(one2.getEntityNumber());
                        add_permItemIdSet.add(one2.getPermItemId());
                        add_fromTypeDescSet.add(one2.getFromTypeDesc());
                    }
                }
                if (null == (delList = req.getDelList()) || delList.isEmpty()) continue;
                del_userIdSet.add(userId);
                del_dimTypeSet.add(dimType);
                one2 = delList.iterator();
                while (one2.hasNext()) {
                    DimFuncPermReq one3 = (DimFuncPermReq)one2.next();
                    del_dimIdSet.add(one3.getDimId());
                    del_appIdSet.add(one3.getAppId());
                    del_entNumSet.add(one3.getEntityNumber());
                    del_permItemIdSet.add(one3.getPermItemId());
                    del_fromTypeDescSet.add(one3.getFromTypeDesc());
                }
            }
            GetBaseDataDynMapReq baseDataDynMapReq = new GetBaseDataDynMapReq();
            baseDataDynMapReq.setUserIdSet(add_userIdSet);
            baseDataDynMapReq.setAppIdSet(add_appIdSet);
            baseDataDynMapReq.setEntNumSet(add_entNumSet);
            baseDataDynMapReq.setPermItemIdSet(add_permItemIdSet);
            GetBaseDataDynMapResp baseDataDynMap = PermCommonUtil.getBaseDataDynMap((GetBaseDataDynMapReq)baseDataDynMapReq);
            Map userDynMap = baseDataDynMap.getUserDynMap();
            Map appDynMap = baseDataDynMap.getAppDynMap();
            Map entDynMap = baseDataDynMap.getEntDynMap();
            Map permItemDynMap = baseDataDynMap.getPermItemDynMap();
            HashMap<String, Map> dimTypeDynMap = new HashMap<String, Map>(8);
            for (Map.Entry add_dimTypeDimIdSet : add_dimTypeDimIdSetMap.entrySet()) {
                Map dimDynMapByDs;
                String dimType = (String)add_dimTypeDimIdSet.getKey();
                Set dimIdSet = (Set)add_dimTypeDimIdSet.getValue();
                if (StringUtils.isEmpty((String)dimType) || null == dimIdSet || dimIdSet.isEmpty() || null == (dimDynMapByDs = IsoDimHelper.getDimDynMapByDs(new ArrayList(dimIdSet), (String)dimType)) || dimDynMapByDs.isEmpty()) continue;
                for (Map.Entry dimDynMap : dimDynMapByDs.entrySet()) {
                    dimTypeDynMap.computeIfAbsent(dimType, k -> new HashMap(8)).put((Long)dimDynMap.getKey(), dimDynMap.getValue());
                }
            }
            ArrayList<DynamicObject> addDynList = new ArrayList<DynamicObject>(10);
            DynamicObject dyn = null;
            for (UserDirectAssignPermReq req : reqList) {
                List addList;
                if (null == req) continue;
                Long userId = req.getUserId();
                String dimType = req.getDimType();
                if (null == userId || Objects.equals(0L, userId) || StringUtils.isEmpty((String)dimType) || null == (addList = req.getAddList()) || addList.isEmpty()) continue;
                for (DimFuncPermReq one : addList) {
                    if (null == one) continue;
                    dyn = BusinessDataServiceHelper.newDynamicObject((String)"perm_userpermdetail");
                    dyn.set("user_id", (Object)userId);
                    dyn.set("user", userDynMap.get(userId));
                    dyn.set("dimtype", (Object)dimType);
                    Map dimIdDynMap = null == dimTypeDynMap.get(dimType) ? new HashMap(0) : (Map)dimTypeDynMap.get(dimType);
                    Long dimId = one.getDimId();
                    dyn.set("dimid_id", (Object)dimId);
                    dyn.set("dimid", dimIdDynMap.get(dimId));
                    dyn.set("includesub", (Object)(null == one.getIncludeSub() ? "0" : (one.getIncludeSub() != false ? "1" : "0")));
                    String appId = one.getAppId();
                    dyn.set("bizapp", (Object)appId);
                    dyn.set("bizapp", appDynMap.get(appId));
                    String entNum = one.getEntityNumber();
                    dyn.set("entitytype_id", (Object)entNum);
                    dyn.set("entitytype", entDynMap.get(entNum));
                    String permItemId = one.getPermItemId();
                    dyn.set("permitem_id", (Object)permItemId);
                    dyn.set("permitem", permItemDynMap.get(permItemId));
                    dyn.set("fromtypedesc", (Object)one.getFromTypeDesc());
                    addDynList.add(dyn);
                }
            }
            PermResult addResult = UserDirectPermService.userDirectAssignPerm_add(addDynList, add_fromTypeDescSet, oriReq);
            if (!addResult.isOk()) {
                return addResult;
            }
            PermResult delResult = UserDirectPermService.userDirectAssignPerm_del(del_userIdSet, del_dimTypeSet, del_dimIdSet, del_appIdSet, del_entNumSet, del_permItemIdSet, del_fromTypeDescSet, oriReq);
            if (!delResult.isOk()) {
                return delResult;
            }
            return PermResult.ok();
        }
        catch (Exception e) {
            log.warn("UserDirectPermService_userDirectAssignPerm_exception", (Throwable)e);
            return PermResult.fail((String)e.getLocalizedMessage());
        }
    }

    private static PermResult userDirectAssignPerm_add(List<DynamicObject> addDynList, Set<String> add_fromTypeDescSet, UserDirectAssignReq oriReq) {
        if (null != addDynList && !addDynList.isEmpty()) {
            OperationResult opResult;
            OperateOption option = OperateOption.create();
            if (PermCommonUtil.isEnablePermLog()) {
                option.setVariableValue("ENTSAVE_PERMLOG", "1");
                option.setVariableValue("permlog_op", "save");
                option.setVariableValue("permlog_opbtn", ConstantsHelper.getSave());
                option.setVariableValue("permlog_interfacemethod", "UserDirectPermService.userDirectAssignPerm_add");
                option.setVariableValue("permlog_busitype", "userdirect_save");
                option.setVariableValue("permlog_formnum", "");
            }
            option.setVariableValue("ishasright", oriReq.isSkipCheckFunPermission() ? String.valueOf(Boolean.TRUE) : String.valueOf(Boolean.FALSE));
            boolean skipCheckAdminDataRange = oriReq.isSkipCheckAdminDataRange();
            option.setVariableValue("skipCheckAdminDataRange", skipCheckAdminDataRange ? String.valueOf(Boolean.TRUE) : String.valueOf(Boolean.FALSE));
            if (!skipCheckAdminDataRange) {
                Map enumsYesNoMap = EnumsYesNo.getMap();
                option.setVariableValue("yesNoMap", SerializationUtils.toJsonString((Object)enumsYesNoMap));
                Map permCtrlTypeMap = IsoDimHelper.getEntPermCtrlTypeMap(null);
                option.setVariableValue("permCtrlTypeMap", SerializationUtils.toJsonString((Object)permCtrlTypeMap));
                Map permCtrlTypeNumMap = IsoDimHelper.getBigPermCtrlTypeMap(null);
                option.setVariableValue("bigPermCtrlTypeMap", SerializationUtils.toJsonString((Object)permCtrlTypeNumMap));
                GetPlainPermItemListReq getPlainPermItemListReq = new GetPlainPermItemListReq();
                getPlainPermItemListReq.setDimType("DIM_ORG");
                getPlainPermItemListReq.setReturnByField(true);
                getPlainPermItemListReq.setReturnFieldSet((Set)Sets.newHashSet((Object[])new String[]{"appNumber", "entityNumber", "permItemNumber"}));
                List plainPermItemList = PermItemHelper.getPlainPermItemList((GetPlainPermItemListReq)getPlainPermItemListReq);
                HashSet plainPermItemSet = new HashSet(plainPermItemList);
                option.setVariableValue("plainPermItemSet", SerializationUtils.toJsonString(plainPermItemSet));
                long currUserId = RequestContext.get().getCurrUserId();
                HashSet adminChargeAppSet = new HashSet(AdminPermCache.getAdminChargeApps((Long)currUserId, null));
                option.setVariableValue("adminChargeAppSet", SerializationUtils.toJsonString(adminChargeAppSet));
                Map allPermItemNumberIdMap = PermItemHelper.getAllPermItemNumberIdMap();
                option.setVariableValue("allPermItemNumberIdMap", SerializationUtils.toJsonString((Object)allPermItemNumberIdMap));
            }
            if (!(opResult = OperationServiceHelper.executeOperate((String)"save", (String)"perm_userpermdetail", (DynamicObject[])addDynList.toArray(new DynamicObject[addDynList.size()]), (OperateOption)option)).isSuccess()) {
                List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
                if (null != allErrorOrValidateInfo && !allErrorOrValidateInfo.isEmpty()) {
                    List collect = allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
                    return PermResult.fail((String)String.join((CharSequence)"\r\n", collect));
                }
                String message = opResult.getMessage();
                if (StringUtils.isNotEmpty((String)message)) {
                    return PermResult.fail((String)message);
                }
            }
        }
        return PermResult.ok();
    }

    private static PermResult userDirectAssignPerm_del(Set<Long> del_userIdSet, Set<String> del_dimTypeSet, Set<Long> del_dimIdSet, Set<String> del_appIdSet, Set<String> del_entNumSet, Set<String> del_permItemIdSet, Set<String> del_fromTypeDescSet, UserDirectAssignReq oriReq) {
        if (!(null != del_userIdSet && !del_userIdSet.isEmpty() || null != del_dimTypeSet && !del_dimTypeSet.isEmpty() || null != del_dimIdSet && !del_dimIdSet.isEmpty() || null != del_appIdSet && !del_appIdSet.isEmpty() || null != del_entNumSet && !del_entNumSet.isEmpty() || null != del_permItemIdSet && !del_permItemIdSet.isEmpty())) {
            return PermResult.ok();
        }
        GetUserFuncDimReq userFuncDimReq = new GetUserFuncDimReq();
        userFuncDimReq.setReturnType(Integer.valueOf(2));
        userFuncDimReq.setUserIdSet(del_userIdSet);
        userFuncDimReq.setDimTypeSet(del_dimTypeSet);
        userFuncDimReq.setDimIdSet(del_dimIdSet);
        userFuncDimReq.setAppIdSet(del_appIdSet);
        userFuncDimReq.setEntNumSet(del_entNumSet);
        userFuncDimReq.setPermItemIdSet(del_permItemIdSet);
        Map<String, UserFuncDim> delUserFuncDimMap = UserDirectPermService.getUserFuncDimMap(userFuncDimReq);
        if (null != delUserFuncDimMap && !delUserFuncDimMap.isEmpty()) {
            OperationResult opResult;
            OperateOption option = OperateOption.create();
            if (PermCommonUtil.isEnablePermLog()) {
                option.setVariableValue("ENTSAVE_PERMLOG", "1");
                option.setVariableValue("permlog_op", "delete");
                option.setVariableValue("permlog_opbtn", ConstantsHelper.getDel());
                option.setVariableValue("permlog_interfacemethod", "UserDirectPermService.userDirectAssignPerm_del");
                option.setVariableValue("permlog_busitype", "userdirectlist_del");
                option.setVariableValue("permlog_formnum", "");
            }
            option.setVariableValue("ishasright", oriReq.isSkipCheckFunPermission() ? String.valueOf(Boolean.TRUE) : String.valueOf(Boolean.FALSE));
            boolean skipCheckAdminDataRange = oriReq.isSkipCheckAdminDataRange();
            option.setVariableValue("skipCheckAdminDataRange", skipCheckAdminDataRange ? String.valueOf(Boolean.TRUE) : String.valueOf(Boolean.FALSE));
            if (!skipCheckAdminDataRange) {
                long currUserId = RequestContext.get().getCurrUserId();
                AbstractPermissionServiceImpl service = (AbstractPermissionServiceImpl)PermissionServiceImplFactory.getImpl(null);
                UserScopeResult adminChargeUser = service.getAdminChargeUser(currUserId, false);
                boolean allUser = adminChargeUser.isAllUser();
                List userIDs = adminChargeUser.getUserIDs();
                option.setVariableValue("adminChargeUser_allUser", allUser ? "1" : "0");
                option.setVariableValue("adminChargeUser_userIDs", StrUtil.fast2JsonString((Object)userIDs));
                Map permCtrlTypeMap = IsoDimHelper.getEntPermCtrlTypeMap(null);
                option.setVariableValue("permCtrlTypeMap", SerializationUtils.toJsonString((Object)permCtrlTypeMap));
                Set<String> dimTypeSet = UserDirectPermService.getDimTypeSet((GetUserFuncDimReq)PermBuilder.of(GetUserFuncDimReq::new).with(GetUserFuncDimReq::setMainIdSet, delUserFuncDimMap.keySet()).build());
                Map dimHasPermDimResultMap = PermCtrlTypeService.getDimHasPermDimResultMap(dimTypeSet, (long)currUserId);
                option.setVariableValue("dimHasPermDimResultMap", SerializationUtils.toJsonString((Object)dimHasPermDimResultMap));
                List adminChargeApps = AdminPermCache.getAdminChargeApps((Long)currUserId, null);
                option.setVariableValue("adminChargeApps", SerializationUtils.toJsonString((Object)adminChargeApps));
            }
            if (!(opResult = OperationServiceHelper.executeOperate((String)"delete", (String)"perm_userpermdetail", (Object[])delUserFuncDimMap.keySet().toArray(), (OperateOption)option)).isSuccess()) {
                List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
                if (null != allErrorOrValidateInfo && !allErrorOrValidateInfo.isEmpty()) {
                    List collect = allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
                    return PermResult.fail((String)String.join((CharSequence)"\r\n", collect));
                }
                String message = opResult.getMessage();
                if (StringUtils.isNotEmpty((String)message)) {
                    return PermResult.fail((String)message);
                }
            }
        }
        return PermResult.ok();
    }
}

