/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service.admingroup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.AdmGrpApp;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.admin.AdmGrpOperationReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpAppReq;
import kd.bos.permission.model.perm.resp.admin.AdmGrpHasPermResp;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.CommonService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdmGrpAppService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(AdmGrpAppService.class);

    public static Map<Long, AdmGrpHasPermResp> getAssignableAdmGrpHasPerm(Set<Long> adminGroupIdSet) {
        if (kd.bos.util.CollectionUtils.isEmpty(adminGroupIdSet)) {
            return new HashMap<Long, AdmGrpHasPermResp>(0);
        }
        adminGroupIdSet.removeIf(x -> null == x || Objects.equals(0L, x));
        if (kd.bos.util.CollectionUtils.isEmpty(adminGroupIdSet)) {
            return new HashMap<Long, AdmGrpHasPermResp>(0);
        }
        return AdmGrpAppService.getAssignableAdmGrpHasPermPri(adminGroupIdSet);
    }

    private static Map<Long, AdmGrpHasPermResp> getAssignableAdmGrpHasPermPri(Set<Long> adminGroupIdSet) {
        if (kd.bos.util.CollectionUtils.isEmpty(adminGroupIdSet)) {
            return new HashMap<Long, AdmGrpHasPermResp>(0);
        }
        Map grpIdAllSuper = AdminGroupHelper.getGrpIdAllSuper(adminGroupIdSet, (boolean)true);
        Set collect = grpIdAllSuper.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map admGroupMap = AdminGroupHelper.getAdmGroupInfoMap(collect);
        AdmGrpHasPermResp topAdmGrpAppMap = AdmGrpAppService.getTopAdmGrpAppSetMap();
        HashMap<Long, AdmGrpHasPermResp> map = new HashMap<Long, AdmGrpHasPermResp>(8);
        for (Long adminGroupId : adminGroupIdSet) {
            GetAdmGrpAppReq req;
            Map<Long, Set<AdmGrpApp>> admGroupAppSetMap;
            AdmGroup curAdmGroup = (AdmGroup)admGroupMap.get(adminGroupId);
            if (null == curAdmGroup) continue;
            Set<AdmGrpApp> curSet = null;
            long currentGroupId = curAdmGroup.getId();
            long level = curAdmGroup.getLevel().intValue();
            long parent = curAdmGroup.getParent();
            while (level > 1L && kd.bos.util.CollectionUtils.isEmpty(curSet = (admGroupAppSetMap = AdmGrpAppService.getAdmGrpAppSetMap(req = (GetAdmGrpAppReq)PermBuilder.of(GetAdmGrpAppReq::new).with(GetAdmGrpAppReq::setAdminGroupIdSet, (Object)Sets.newHashSet((Object[])new Long[]{currentGroupId})).build())).get(currentGroupId))) {
                AdmGroup admGroup = (AdmGroup)admGroupMap.get(parent);
                currentGroupId = parent;
                level = admGroup.getLevel().intValue();
                parent = admGroup.getParent();
            }
            if (kd.bos.util.CollectionUtils.isNotEmpty(curSet)) {
                AdmGrpHasPermResp resp = new AdmGrpHasPermResp();
                resp.setAppSet(curSet);
                map.put(adminGroupId, resp);
                continue;
            }
            map.put(adminGroupId, topAdmGrpAppMap);
        }
        return map;
    }

    private static AdmGrpHasPermResp getTopAdmGrpAppSetMap() {
        String key = String.format("%s%s", "getTopAdmGrpAppSetMap_", RequestContext.get().getAccountId());
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, AdmGrpHasPermResp> map = new HashMap<String, AdmGrpHasPermResp>(8);
            AdmGrpHasPermResp topAdmGrpAppSetMapPri = AdmGrpAppService.getTopAdmGrpAppSetMapPri();
            if (null == topAdmGrpAppSetMapPri) {
                return map;
            }
            map.put("getTopAdmGrpAppSetMap_", topAdmGrpAppSetMapPri);
            return map;
        });
        return (AdmGrpHasPermResp)threadCacheMap.get("getTopAdmGrpAppSetMap_");
    }

    private static AdmGrpHasPermResp getTopAdmGrpAppSetMapPri() {
        AdmGrpHasPermResp resp = new AdmGrpHasPermResp();
        String langName = RequestContext.get().getLang().name();
        ArrayList<String> paramList = new ArrayList<String>(10);
        StringBuilder sbCloudAppSql = new StringBuilder();
        sbCloudAppSql.append("SELECT DISTINCT a.fid app_id ");
        sbCloudAppSql.append(" FROM t_meta_bizapp a ");
        sbCloudAppSql.append(" INNER JOIN t_meta_bizcloud cloud ON cloud.fid = a.fbizcloudid ");
        sbCloudAppSql.append(" LEFT JOIN t_meta_bizapp_l b ON a.fid = b.fid AND b.flocaleid = ? ");
        paramList.add(langName);
        sbCloudAppSql.append(" LEFT JOIN t_meta_bizcloud_l cloudl on cloudl.fid = cloud.fid and cloudl.flocaleid = ? ");
        paramList.add(langName);
        sbCloudAppSql.append(" WHERE a.fdeploystatus = '2' ");
        AdmGrpAppService.appendCloudFilter(sbCloudAppSql);
        AdmGrpAppService.appendAppFilter(sbCloudAppSql);
        try (DataSet finalDS = DB.queryDataSet((String)"AdmGrpAppService.getTopAdmGrpAppSetMap", (DBRoute)DBRoute.meta, (String)sbCloudAppSql.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));){
            Map appIdNameMap = AppHelper.getAllAppIdNameMap();
            Map allAppIdNumberMap = AppHelper.getAllAppIdNumberMap();
            Map extAppAndOrgnlAppRel = AppHelper.getExtAppAndOrgnlAppRel();
            HashSet<AdmGrpApp> appSet = new HashSet<AdmGrpApp>(8);
            AdmGrpApp one = null;
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                String appId = row.getString("app_id");
                String oriAppId = (String)extAppAndOrgnlAppRel.get(appId);
                String appName = (String)appIdNameMap.get(oriAppId);
                String appNum = (String)allAppIdNumberMap.get(oriAppId);
                one = new AdmGrpApp(null, null, null, null, oriAppId, appNum, appName);
                appSet.add(one);
            }
            resp.setAppSet(appSet);
        }
        return resp;
    }

    private static void appendCloudFilter(StringBuilder sb) {
        String cloudStr;
        List cloudIdsBlackListFromStd;
        StringBuilder cloud = new StringBuilder();
        String cloudIdBlackList = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (StringUtils.isNotEmpty((String)cloudIdBlackList)) {
            cloud.append(cloudIdBlackList);
        }
        if (!CollectionUtils.isEmpty((Collection)(cloudIdsBlackListFromStd = PermCommonUtil.getCloudIdsFromStdBlackList()))) {
            for (int i = 0; i < cloudIdsBlackListFromStd.size(); ++i) {
                cloudIdsBlackListFromStd.set(i, "'" + (String)cloudIdsBlackListFromStd.get(i) + "'");
            }
            String cloudIds = String.join((CharSequence)",", cloudIdsBlackListFromStd);
            if (StringUtils.isNotEmpty((String)cloudIds)) {
                if (StringUtils.isNotEmpty((String)cloud.toString())) {
                    cloud.append(',').append(cloudIds);
                } else {
                    cloud.append(cloudIds);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(cloudStr = cloud.toString()))) {
            sb.append(" and cloud.fid NOT IN (").append(cloudStr).append(')');
        }
        Set disabledCloudIds = null == ManageServiceHelper.getDisabledCloudIds() ? new HashSet(8) : ManageServiceHelper.getDisabledCloudIds();
        disabledCloudIds.add("2HGKCE94QELW");
        if (null != disabledCloudIds && !disabledCloudIds.isEmpty()) {
            String disabledCloudIdsStr = String.join((CharSequence)"','", disabledCloudIds);
            sb.append(" and cloud.fid NOT IN ('").append(disabledCloudIdsStr).append("')");
        }
    }

    private static void appendAppFilter(StringBuilder sb) {
        String appStr;
        List appIdsBlackListFromStd;
        StringBuilder app = new StringBuilder();
        String appIdBlackList = RunModeServiceHelper.getAppIdFromBlacklist();
        if (StringUtils.isNotEmpty((String)appIdBlackList)) {
            app.append(appIdBlackList);
        }
        if (!CollectionUtils.isEmpty((Collection)(appIdsBlackListFromStd = PermCommonUtil.getAppIdsFromStdBlackList()))) {
            for (int i = 0; i < appIdsBlackListFromStd.size(); ++i) {
                appIdsBlackListFromStd.set(i, "'" + (String)appIdsBlackListFromStd.get(i) + "'");
            }
            String appIds = String.join((CharSequence)",", appIdsBlackListFromStd);
            if (StringUtils.isNotEmpty((String)appIds)) {
                if (StringUtils.isNotEmpty((String)app.toString())) {
                    app.append(',').append(appIds);
                } else {
                    app.append(appIds);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(appStr = app.toString()))) {
            sb.append(" AND a.fid NOT IN (").append(appStr).append(')');
        }
        Set disabledAppIds = null == ManageServiceHelper.getDisabledAppIds() ? new HashSet(8) : ManageServiceHelper.getDisabledAppIds();
        disabledAppIds.add("2HGKTA7HH43C");
        if (null != disabledAppIds && !disabledAppIds.isEmpty()) {
            String disabledAppIdsStr = String.join((CharSequence)"','", disabledAppIds);
            sb.append(" AND a.fid NOT IN ('").append(disabledAppIdsStr).append("')");
        }
    }

    public static Map<Long, Set<AdmGrpApp>> getAdmGrpAppSetMap(GetAdmGrpAppReq req) {
        List<QFilter> filterList = AdmGrpAppService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdmGrpAppService.getAdmGrpAppSetMap", (String)"perm_admingroupapp", (String)"id, usergroup_id, usergroup.number, usergroup.name,  app", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            HashMap<Long, Set<AdmGrpApp>> map = new HashMap<Long, Set<AdmGrpApp>>(8);
            AdmGrpApp one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long adminGroupId = row.getLong("usergroup_id");
                String appId = row.getString("app");
                AppInfo appInfo = AppHelper.getMetaAppInfo((String)appId);
                one = new AdmGrpApp(row.getLong("id"), adminGroupId, row.getString("usergroup.number"), row.getString("usergroup.name"), appId, null == appInfo ? "" : appInfo.getNumber(), null == appInfo ? "" : appInfo.getName().getLocaleValue());
                map.computeIfAbsent(adminGroupId, k -> new HashSet(8)).add(one);
            }
            HashMap<Long, Set<AdmGrpApp>> hashMap = map;
            return hashMap;
        }
    }

    public static Map<Long, AdmGrpApp> getAdmGrpAppMap(GetAdmGrpAppReq req) {
        List<QFilter> filterList = AdmGrpAppService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdmGrpAppService.getAdmGrpAppMap", (String)"perm_admingroupapp", (String)"id, usergroup_id, usergroup.number, usergroup.name, usergroup.adminscheme,  app", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            boolean uniqueStrFilter;
            HashMap<Long, AdmGrpApp> map = new HashMap<Long, AdmGrpApp>(8);
            AdmGrpApp one = null;
            Set uniqueStrSet = req.getUniqueStrSet();
            boolean bl = uniqueStrFilter = null != uniqueStrSet && !uniqueStrSet.isEmpty();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                Long usergroup_id = row.getLong("usergroup_id");
                String appId = row.getString("app");
                AppInfo appInfo = AppHelper.getMetaAppInfo((String)appId);
                if (uniqueStrFilter && !uniqueStrSet.contains(usergroup_id + "|" + appId)) continue;
                one = new AdmGrpApp(id, usergroup_id, row.getString("usergroup.number"), row.getString("usergroup.name"), appId, null == appInfo ? "" : appInfo.getNumber(), null == appInfo ? "" : appInfo.getName().getLocaleValue());
                one.setAdminScheme(row.getLong("usergroup.adminscheme"));
                map.put(id, one);
            }
            HashMap<Long, AdmGrpApp> hashMap = map;
            return hashMap;
        }
    }

    private static List<QFilter> getFilter(GetAdmGrpAppReq req) {
        Map admGroupMap;
        Set collect;
        Set adminGroupNumSet;
        Set adminGroupIdSet;
        if (null == req) {
            req = new GetAdmGrpAppReq();
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set mainIdSet = req.getMainIdSet();
        if (!CollectionUtils.isEmpty((Collection)mainIdSet)) {
            filterList.add(new QFilter("id", "in", mainIdSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminGroupIdSet = req.getAdminGroupIdSet()))) {
            filterList.add(new QFilter("usergroup", "in", (Object)adminGroupIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminGroupNumSet = req.getAdminGroupNumSet())) && !CollectionUtils.isEmpty(collect = (admGroupMap = AdminGroupHelper.getAdminGrpMap((Set)adminGroupNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(AdmGroup::getId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("usergroup", "in", collect));
        }
        return filterList;
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            AdmGrpOperationReq req = (AdmGrpOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<Long, Set<AdmGrpApp>> afterDataMap = AdmGrpAppService.getAdmGrpAppSetMap(new GetAdmGrpAppReq(mainIdSet, null, null, null, null, null));
            Set<Long> adminGroupIdSet = afterDataMap.keySet();
            if (null == adminGroupIdSet || adminGroupIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, Set<AdmGrpApp>>>(){}));
            }
            HashMap<String, Map> saveDiffMap = new HashMap<String, Map>(8);
            for (Long adminGroupId : adminGroupIdSet) {
                Set pre = null == preDataMap.get(adminGroupId) ? new HashSet(0) : (Set)preDataMap.get(adminGroupId);
                Set<Object> after = null == afterDataMap.get(adminGroupId) ? new HashSet(0) : afterDataMap.get(adminGroupId);
                Sets.SetView del = Sets.difference(pre, after);
                Sets.SetView add = Sets.difference(after, pre);
                if (kd.bos.util.CollectionUtils.isEmpty((Collection)del) && kd.bos.util.CollectionUtils.isEmpty((Collection)add)) continue;
                String adminGroupIdStr = String.valueOf(adminGroupId);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("delAdmGrpApp", del);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("addAdmGrpApp", add);
            }
            AdminGroupService.saveOrDel((AdmGrpOperationReq)((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setMainIdSet, adminGroupIdSet.stream().map(String::valueOf).collect(Collectors.toSet())).with(PermOperationReq::setCurAppNum, (Object)req.getCurAppNum()).with(PermOperationReq::setCurFormNum, (Object)req.getCurFormNum()).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDoDelExcessData, (Object)req.getDoDelExcessData()).with(PermOperationReq::setDiffContentMap, saveDiffMap).with(PermOperationReq::setPermLogReq, (Object)req.getPermLogReq()).with(AdmGrpOperationReq::setPreAdmGroupMap, (Object)req.getPreAdmGroupMap()).with(AdmGrpOperationReq::setPreAdmUserIdSetMap, (Object)req.getPreAdmUserIdSetMap()).build()));
            super.afterMainEntitySaveExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            Set adminGroupIdSet;
            AdmGrpOperationReq req = (AdmGrpOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, Set<AdmGrpApp>>>(){}));
            }
            if (null == (adminGroupIdSet = preDataMap.keySet()) || adminGroupIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<Long, Set<AdmGrpApp>> afterDataMap = AdmGrpAppService.getAdmGrpAppSetMap(new GetAdmGrpAppReq(null, adminGroupIdSet, null, null, null, null));
            HashMap<String, Map> saveDiffMap = new HashMap<String, Map>(8);
            for (Long adminGroupId : adminGroupIdSet) {
                Set<Object> after;
                Set pre = null == preDataMap.get(adminGroupId) ? new HashSet(0) : (Set)preDataMap.get(adminGroupId);
                Sets.SetView del = Sets.difference(pre, after = null == afterDataMap.get(adminGroupId) ? new HashSet(0) : afterDataMap.get(adminGroupId));
                if (kd.bos.util.CollectionUtils.isEmpty((Collection)del)) continue;
                String adminGroupIdStr = String.valueOf(adminGroupId);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("delAdmGrpApp", del);
            }
            AdminGroupService.saveOrDel((AdmGrpOperationReq)((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setMainIdSet, adminGroupIdSet.stream().map(String::valueOf).collect(Collectors.toSet())).with(PermOperationReq::setCurAppNum, (Object)req.getCurAppNum()).with(PermOperationReq::setCurFormNum, (Object)req.getCurFormNum()).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDoDelExcessData, (Object)req.getDoDelExcessData()).with(PermOperationReq::setDiffContentMap, saveDiffMap).with(PermOperationReq::setPermLogReq, (Object)req.getPermLogReq()).with(AdmGrpOperationReq::setPreAdmGroupMap, (Object)req.getPreAdmGroupMap()).with(AdmGrpOperationReq::setPreAdmUserIdSetMap, (Object)req.getPreAdmUserIdSetMap()).build()));
            super.afterDelExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    public static void delExcessData(Set<String> admGrpIds, Set<AdmGrpApp> delAdmGrpApps) {
        if (null == admGrpIds || admGrpIds.isEmpty() || null == delAdmGrpApps || delAdmGrpApps.isEmpty()) {
            return;
        }
        ArrayList<Object[]> delParams = new ArrayList<Object[]>(10);
        for (String admGrpId : admGrpIds) {
            if (StringUtils.isEmpty((String)admGrpId)) continue;
            for (AdmGrpApp delOne : delAdmGrpApps) {
                if (null == delOne) continue;
                delParams.add(new Object[]{Long.valueOf(admGrpId), delOne.getAppId()});
            }
        }
        if (null == delParams || delParams.isEmpty()) {
            return;
        }
        String delSql = "DELETE FROM t_perm_admingroupapp WHERE fusergroupid = ? AND fappid = ? ";
        DB.executeBatch((DBRoute)DBRoute.permission, (String)delSql, delParams);
    }

    public static PermResult saveByAdmGrp(AdmGrpOperationReq req) {
        Map wllAddAppMap;
        Set value;
        String adminGroupId;
        String curAppNum = req.getCurAppNum();
        String curFormNum = req.getCurFormNum();
        String operEntNum = "perm_admingroupapp";
        String needClearAllCache = req.getNeedClearAllCache();
        String alreadyCheckBusiParam = req.getAlreadyCheckBusiParam();
        String doDelExcessData = req.getDoDelExcessData();
        Boolean entSavePermlog = req.getEntSavePermlog();
        PermLogReq permLogReq = req.getPermLogReq();
        String permLogInterfaceMethod = "AdmGrpAppService.saveByAdmGrp";
        Map willDelAppMap = req.getWillDelAppMap();
        if (null != willDelAppMap && !willDelAppMap.isEmpty()) {
            PermResult delRes;
            DynamicObject[] dynArr;
            Object dataMap;
            HashSet<Long> admGrpIdSet = new HashSet<Long>(8);
            HashSet<String> appIdSet = new HashSet<String>(8);
            HashSet<String> uniqueStrSet = new HashSet<String>(8);
            for (Map.Entry one : willDelAppMap.entrySet()) {
                adminGroupId = (String)one.getKey();
                value = (Set)one.getValue();
                if (StringUtils.isEmpty((String)adminGroupId) || null == value || value.isEmpty()) continue;
                admGrpIdSet.add(Long.valueOf(adminGroupId));
                for (AdmGrpApp innerOne : value) {
                    String appId = innerOne.getAppId();
                    appIdSet.add(appId);
                    uniqueStrSet.add(adminGroupId + "|" + appId);
                }
            }
            if (!(null == admGrpIdSet || admGrpIdSet.isEmpty() || null == (dataMap = AdmGrpAppService.getAdmGrpAppMap(new GetAdmGrpAppReq(null, admGrpIdSet, null, appIdSet, null, uniqueStrSet))) || dataMap.isEmpty() || null == (dynArr = BusinessDataServiceHelper.load((String)operEntNum, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", dataMap.keySet())})) || Objects.equals(0, dynArr.length) || (delRes = AdmGrpAppService.genOperateOptionAndExec((PermOperationReq)((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setOperEntnum, (Object)operEntNum).with(PermOperationReq::setOperationKey, (Object)"delete").with(PermOperationReq::setDataEntities, (Object)dynArr).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPermLogOp, (Object)"delete").with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getDel()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)permLogInterfaceMethod).build()))).isOk())) {
                return delRes;
            }
        }
        if (null != (wllAddAppMap = req.getWillAddAppMap()) && !wllAddAppMap.isEmpty()) {
            ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(wllAddAppMap.size());
            DynamicObject dyn = null;
            for (Map.Entry one : wllAddAppMap.entrySet()) {
                adminGroupId = (String)one.getKey();
                value = (Set)one.getValue();
                if (StringUtils.isEmpty((String)adminGroupId) || null == value || value.isEmpty()) continue;
                for (AdmGrpApp innerOne : value) {
                    dyn = BusinessDataServiceHelper.newDynamicObject((String)operEntNum);
                    dyn.set("usergroup_id", (Object)adminGroupId);
                    dyn.set("app", (Object)innerOne.getAppId());
                    dynList.add(dyn);
                }
            }
            PermResult addRes = AdmGrpAppService.genOperateOptionAndExec((PermOperationReq)((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setOperEntnum, (Object)operEntNum).with(PermOperationReq::setOperationKey, (Object)"save").with(PermOperationReq::setDataEntities, (Object)dynList.toArray(new DynamicObject[dynList.size()])).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPermLogOp, (Object)"save").with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getSave()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)permLogInterfaceMethod).build()));
            if (!addRes.isOk()) {
                return addRes;
            }
        }
        return PermResult.ok();
    }
}

