/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.service.admingroup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.ext.IPermExt;
import kd.bos.permission.cache.helper.AdminDomainHelper;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.AdminType;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.App;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.admin.AdmGrpOperationReq;
import kd.bos.permission.model.perm.req.admin.get.GetAdmGrpFunpermReq;
import kd.bos.permission.model.perm.req.admin.get.GetUserAdmGrpReq;
import kd.bos.permission.model.perm.resp.admin.AdmGrpHasPermResp;
import kd.bos.permission.model.perm.resp.common.GetBaseDataDynMapResp;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.CommonService;
import kd.bos.permission.service.admingroup.UserAdmGrpService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdmGrpFunpermService
extends CommonService
implements IPermExt {
    private static final Log log = LogFactory.getLog(AdmGrpFunpermService.class);

    public static AdmGrpHasPermResp getAdmGrpHasPermByUserId(Long userId) {
        AdmGrpHasPermResp resp = new AdmGrpHasPermResp();
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)userId);
        if (!adminUser) {
            resp.setHasAllFunperm(false);
            resp.setFunpermSet(new HashSet(0));
            return resp;
        }
        Set admGrpIdSet = UserAdmGrpService.getAdmGrpIdSet((GetUserAdmGrpReq)((GetUserAdmGrpReq)PermBuilder.of(GetUserAdmGrpReq::new).with(GetUserAdmGrpReq::setUserIdSet, (Object)Sets.newHashSet((Object[])new Long[]{userId})).build()));
        return AdmGrpFunpermService.getAssignedAdmGrpHasPerm(admGrpIdSet);
    }

    public static AdmGrpHasPermResp getAssignedAdmGrpHasPerm(Set<Long> admGrpIdSet) {
        AdmGrpHasPermResp resp = new AdmGrpHasPermResp();
        if (null == admGrpIdSet || admGrpIdSet.isEmpty()) {
            resp.setHasAllFunperm(false);
            resp.setFunpermSet(new HashSet(0));
            return resp;
        }
        DynamicObject[] dynArr = BusinessDataServiceHelper.load((Object[])admGrpIdSet.toArray(new Object[admGrpIdSet.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"perm_admingroup"));
        if (null == dynArr || Objects.equals(0, dynArr.length)) {
            resp.setHasAllFunperm(false);
            resp.setFunpermSet(new HashSet(0));
            return resp;
        }
        int length = dynArr.length;
        HashMap<Long, DynamicObject> dynMap = new HashMap<Long, DynamicObject>(length);
        for (int i = 0; i < length; ++i) {
            DynamicObject dyn = dynArr[i];
            if (null == dyn) continue;
            dynMap.put(dyn.getLong("id"), dyn);
        }
        AdminType adminType = PermissionServiceHelper.getAdminType((long)RequestContext.get().getCurrUserId());
        AdmGrpHasPermResp virtualAdminPerm = AdminSchemeHelper.getVirtualAdminPerm((AdminType)adminType, (boolean)true);
        Map grpIdAllSuper = AdminGroupHelper.getGrpIdAllSuper(admGrpIdSet, (boolean)true);
        Set collect = grpIdAllSuper.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map admGroupMap = AdminGroupHelper.getAdmGroupInfoMap(collect);
        boolean finalHasAllFunperm = false;
        HashSet finalFunpermSet = new HashSet(8);
        for (Long admGrpId : admGrpIdSet) {
            Set funpermSet;
            DynamicObject curAdmGrpDyn = (DynamicObject)dynMap.get(admGrpId);
            if (null == curAdmGrpDyn) continue;
            AdmGrpHasPermResp admGrpHasPerm = AdmGrpFunpermService.getAssignedAdmGrpHasPerm(curAdmGrpDyn, virtualAdminPerm, admGroupMap, null);
            boolean hasAllFunperm = admGrpHasPerm.isHasAllFunperm();
            if (hasAllFunperm) {
                finalHasAllFunperm = true;
            }
            if (null == (funpermSet = admGrpHasPerm.getFunpermSet()) || funpermSet.isEmpty()) continue;
            finalFunpermSet.addAll(funpermSet);
        }
        resp.setHasAllFunperm(finalHasAllFunperm);
        resp.setFunpermSet(finalFunpermSet);
        return resp;
    }

    public static AdmGrpHasPermResp getAssignedAdmGrpHasPerm(DynamicObject curAdmGrpDyn, AdmGrpHasPermResp virtualAdminPerm, Map<Long, AdmGroup> admGroupMap, Map<Long, Set<AdmGrpFunperm>> admGroupFunpermSetMap_param) {
        if (null == curAdmGrpDyn) {
            return new AdmGrpHasPermResp();
        }
        AdmGrpHasPermResp resp = new AdmGrpHasPermResp();
        AdmGroup curAdmGroup = new AdmGroup();
        curAdmGroup.setId(Long.valueOf(curAdmGrpDyn.getLong("id")));
        curAdmGroup.setNumber(curAdmGrpDyn.getString("number"));
        curAdmGroup.setName(curAdmGrpDyn.getString("name"));
        Long curAdmGrpId = curAdmGrpDyn.getLong("id");
        GetAdmGrpFunpermReq req = (GetAdmGrpFunpermReq)PermBuilder.of(GetAdmGrpFunpermReq::new).with(GetAdmGrpFunpermReq::setAdminGroupIdSet, (Object)Sets.newHashSet((Object[])new Long[]{curAdmGrpId})).build();
        Map<Long, Set<AdmGrpFunperm>> admGroupFunpermSetMap = AdmGrpFunpermService.getAdmGrpFunpermSetMap(req);
        Set<AdmGrpFunperm> curSet = admGroupFunpermSetMap.get(curAdmGrpId);
        AdmGroup admGroup = admGroupMap.get(curAdmGrpId);
        long level = admGroup.getLevel().intValue();
        long parentId = admGroup.getParent();
        Boolean isdomain = admGroup.domainGroup();
        long domainId = admGroup.getDomain();
        boolean domainDiff = false;
        while (level > 1L && kd.bos.util.CollectionUtils.isEmpty(curSet)) {
            admGroup = admGroupMap.get(parentId);
            level = admGroup.getLevel().intValue();
            Boolean p_isdomain = admGroup.domainGroup();
            req = (GetAdmGrpFunpermReq)PermBuilder.of(GetAdmGrpFunpermReq::new).with(GetAdmGrpFunpermReq::setAdminGroupIdSet, (Object)Sets.newHashSet((Object[])new Long[]{parentId})).build();
            admGroupFunpermSetMap = AdmGrpFunpermService.getAdmGrpFunpermSetMap(req);
            curSet = admGroupFunpermSetMap.get(parentId);
            if (null != isdomain && isdomain.booleanValue() && (null == p_isdomain || !p_isdomain.booleanValue())) {
                domainDiff = true;
            }
            parentId = admGroup.getParent();
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty(curSet)) {
            resp.setHasAllFunperm(false);
            resp.setFunpermSet(curSet);
            return resp;
        }
        if (domainDiff) {
            curSet = AdmGrpFunpermService.getDomainGrpFuncpermSet(domainId, curAdmGroup);
            curSet.addAll(virtualAdminPerm.getFunpermSet());
            resp.setHasAllFunperm(virtualAdminPerm.isHasAllFunperm());
            resp.setFunpermSet(curSet);
            return resp;
        }
        return virtualAdminPerm;
    }

    public static AdmGrpHasPermResp getAssignableAdmGrpHasPerm(DynamicObject curAdmGrpDyn, Long paramParentId, AdminType adminType, boolean mustQueryFunpermSet) {
        boolean parentAdmGrpIsdomain;
        if (null == curAdmGrpDyn) {
            return new AdmGrpHasPermResp();
        }
        AdmGroup curAdmGroup = new AdmGroup();
        curAdmGroup.setId(Long.valueOf(curAdmGrpDyn.getLong("id")));
        curAdmGroup.setNumber(curAdmGrpDyn.getString("number"));
        curAdmGroup.setName(curAdmGrpDyn.getString("name"));
        Map grpIdAllSuper = AdminGroupHelper.getGrpIdAllSuper((Set)Sets.newHashSet((Object[])new Long[]{curAdmGrpDyn.getLong("id")}), (boolean)true);
        Set collect = grpIdAllSuper.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map admGroupMap = AdminGroupHelper.getAdmGroupInfoMap(collect);
        AdmGroup admGroup = new AdmGroup();
        AdmGrpHasPermResp virtualAdminPerm = AdminSchemeHelper.getVirtualAdminPerm((AdminType)adminType, (boolean)mustQueryFunpermSet);
        AdmGroup parentGroup = (AdmGroup)admGroupMap.get(paramParentId);
        if (0L == paramParentId || null == parentGroup) {
            return virtualAdminPerm;
        }
        boolean curAdmGrpIsdomain = curAdmGrpDyn.getBoolean("isdomain");
        if (curAdmGrpIsdomain == (parentAdmGrpIsdomain = parentGroup.domainGroup())) {
            admGroup = (AdmGroup)admGroupMap.get(paramParentId);
        } else if (curAdmGrpIsdomain && !parentAdmGrpIsdomain) {
            admGroup.setId(Long.valueOf(curAdmGrpDyn.getLong("id")));
            admGroup.setNumber(curAdmGrpDyn.getString("number"));
            admGroup.setName(curAdmGrpDyn.getString("name"));
            admGroup.setLevel(Integer.valueOf(curAdmGrpDyn.getInt("level")));
            admGroup.setParent(Long.valueOf(curAdmGrpDyn.getLong("parent_id")));
            admGroup.setDomainGroup(curAdmGrpIsdomain);
            admGroup.setDomain(Long.valueOf(curAdmGrpDyn.getLong("domain_id")));
        } else {
            admGroup = (AdmGroup)admGroupMap.get(paramParentId);
        }
        boolean hasAllFunperm = false;
        Set<AdmGrpFunperm> curSet = null;
        long level = admGroup.getLevel().intValue();
        long parentId = admGroup.getParent();
        Boolean isdomain = admGroup.domainGroup();
        long domainId = admGroup.getDomain();
        while (level > 1L && kd.bos.util.CollectionUtils.isEmpty(curSet)) {
            if (AdmGrpFunpermService.curGroupDomainParentNotDomain(admGroup, admGroupMap)) {
                hasAllFunperm = virtualAdminPerm.isHasAllFunperm();
                curSet = AdmGrpFunpermService.getDomainGrpFuncpermSet(domainId, curAdmGroup);
                curSet.addAll(virtualAdminPerm.getFunpermSet());
            } else {
                GetAdmGrpFunpermReq req = (GetAdmGrpFunpermReq)PermBuilder.of(GetAdmGrpFunpermReq::new).with(GetAdmGrpFunpermReq::setAdminGroupIdSet, (Object)Sets.newHashSet((Object[])new Long[]{admGroup.getId()})).build();
                Map<Long, Set<AdmGrpFunperm>> admGroupFunpermSetMap = AdmGrpFunpermService.getAdmGrpFunpermSetMap(req);
                Set<AdmGrpFunperm> set = curSet = null == admGroup.getId() || Objects.equals(0L, admGroup.getId()) ? null : admGroupFunpermSetMap.get(admGroup.getId());
            }
            if (!kd.bos.util.CollectionUtils.isEmpty(curSet)) continue;
            admGroup = (AdmGroup)admGroupMap.get(parentId);
            level = admGroup.getLevel().intValue();
            parentId = admGroup.getParent();
            Boolean p_isdomain = admGroup.domainGroup();
            if (null == isdomain || !isdomain.booleanValue() || null != p_isdomain && p_isdomain.booleanValue()) continue;
            curSet = AdmGrpFunpermService.getDomainGrpFuncpermSet(domainId, curAdmGroup);
            curSet.addAll(virtualAdminPerm.getFunpermSet());
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty(curSet)) {
            AdmGrpHasPermResp resp = new AdmGrpHasPermResp();
            resp.setHasAllFunperm(hasAllFunperm);
            resp.setFunpermSet(curSet);
            return resp;
        }
        return virtualAdminPerm;
    }

    private static Set<AdmGrpFunperm> getDomainGrpFuncpermSet(long domainId, AdmGroup curAdmGroup) {
        Map domainIdAdmGrpFunpermSetMap = AdminDomainHelper.getDomainIdAdmGrpFunpermSetMap((Set)Sets.newHashSet((Object[])new Long[]{domainId}), (AdmGroup)curAdmGroup);
        return null == domainIdAdmGrpFunpermSetMap.get(domainId) ? new HashSet(0) : (Set)domainIdAdmGrpFunpermSetMap.get(domainId);
    }

    private static boolean curGroupDomainParentNotDomain(AdmGroup curAdmGroup, Map<Long, AdmGroup> admGroupMap) {
        boolean cur_isdomain = null == curAdmGroup ? false : curAdmGroup.domainGroup();
        Long parentId = null == curAdmGroup ? Long.valueOf(0L) : curAdmGroup.getParent();
        AdmGroup parentGrp = null == parentId || Objects.equals(0L, parentId) ? null : admGroupMap.get(parentId);
        boolean parent_isdomain = null == parentGrp ? false : parentGrp.domainGroup();
        return cur_isdomain && !parent_isdomain;
    }

    public static Map<Long, Set<AdmGrpFunperm>> getAdmGrpFunpermSetMap(GetAdmGrpFunpermReq req) {
        List<QFilter> filterList = AdmGrpFunpermService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdmGrpFunpermService.getAdmGrpFunpermSetMap", (String)"perm_admingroupfunperm", (String)"id, usergroup_id, usergroup.number, usergroup.name, app_id, app.number, app.name, entitynum_id, entitynum.name, permitem_id, permitem.number, permitem.name", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            HashMap<Long, Set<AdmGrpFunperm>> map = new HashMap<Long, Set<AdmGrpFunperm>>(8);
            AdmGrpFunperm one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long adminGroupId = row.getLong("usergroup_id");
                String app_id = row.getString("app_id");
                String entitynum_id = row.getString("entitynum_id");
                String permitem_id = row.getString("permitem_id");
                one = new AdmGrpFunperm(row.getLong("id"), adminGroupId, row.getString("usergroup.number"), row.getString("usergroup.name"), app_id, row.getString("app.number"), row.getString("app.name"), entitynum_id, row.getString("entitynum.name"), permitem_id, row.getString("permitem.number"), row.getString("permitem.name"));
                map.computeIfAbsent(adminGroupId, k -> new HashSet(8)).add(one);
            }
            HashMap<Long, Set<AdmGrpFunperm>> hashMap = map;
            return hashMap;
        }
    }

    public static Map<Long, AdmGrpFunperm> getAdmGrpFunpermMap(GetAdmGrpFunpermReq req) {
        List<QFilter> filterList = AdmGrpFunpermService.getFilter(req);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdmGrpFunpermService.getAdmGrpFunpermSetMap", (String)"perm_admingroupfunperm", (String)"id, usergroup_id, usergroup.number, usergroup.name, usergroup.adminscheme,  app_id, app.number, app.name, entitynum_id, entitynum.name, permitem_id, permitem.number, permitem.name", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            boolean uniqueStrFilter;
            HashMap<Long, AdmGrpFunperm> map = new HashMap<Long, AdmGrpFunperm>(8);
            AdmGrpFunperm one = null;
            Set uniqueStrSet = req.getUniqueStrSet();
            boolean bl = uniqueStrFilter = null != uniqueStrSet && !uniqueStrSet.isEmpty();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                Long usergroup_id = row.getLong("usergroup_id");
                String app_id = row.getString("app_id");
                String entitynum_id = row.getString("entitynum_id");
                String permitem_id = row.getString("permitem_id");
                if (uniqueStrFilter && !uniqueStrSet.contains(usergroup_id + "|" + app_id + "|" + entitynum_id + "|" + permitem_id)) continue;
                one = new AdmGrpFunperm(id, usergroup_id, row.getString("usergroup.number"), row.getString("usergroup.name"), app_id, row.getString("app.number"), row.getString("app.name"), entitynum_id, row.getString("entitynum.name"), permitem_id, row.getString("permitem.number"), row.getString("permitem.name"));
                one.setAdminScheme(row.getLong("usergroup.adminscheme"));
                map.put(id, one);
            }
            HashMap<Long, AdmGrpFunperm> hashMap = map;
            return hashMap;
        }
    }

    private static List<QFilter> getFilter(GetAdmGrpFunpermReq req) {
        Map permItemMap;
        Set collect;
        Set permItemNumSet;
        Set permItemIdSet;
        Set entNumSet;
        Map appMap;
        Set collect2;
        Set appNumSet;
        Set appIdSet;
        Map admGroupMap;
        Set collect3;
        Set adminGroupNumSet;
        Set adminGroupIdSet;
        if (null == req) {
            req = new GetAdmGrpFunpermReq();
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Set mainIdSet = req.getMainIdSet();
        if (!CollectionUtils.isEmpty((Collection)mainIdSet)) {
            filterList.add(new QFilter("id", "in", mainIdSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminGroupIdSet = req.getAdminGroupIdSet()))) {
            filterList.add(new QFilter("usergroup", "in", (Object)adminGroupIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(adminGroupNumSet = req.getAdminGroupNumSet())) && !CollectionUtils.isEmpty(collect3 = (admGroupMap = AdminGroupHelper.getAdminGrpMap((Set)adminGroupNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(AdmGroup::getId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("usergroup", "in", collect3));
        }
        if (!CollectionUtils.isEmpty((Collection)(appIdSet = req.getAppIdSet()))) {
            filterList.add(new QFilter("app", "in", (Object)appIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(appNumSet = req.getAppNumSet())) && !CollectionUtils.isEmpty(collect2 = (appMap = AppHelper.getAppMap((Set)appNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(App::getAppId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("app", "in", collect2));
        }
        if (!CollectionUtils.isEmpty((Collection)(entNumSet = req.getEntNumSet()))) {
            filterList.add(new QFilter("entitynum", "in", (Object)entNumSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(permItemIdSet = req.getPermItemIdSet()))) {
            filterList.add(new QFilter("permitem", "in", (Object)permItemIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(permItemNumSet = req.getPermItemNumSet())) && !CollectionUtils.isEmpty(collect = (permItemMap = PermItemHelper.getPermItemMap((Set)permItemNumSet, (String)"number")).values().stream().flatMap(x -> x.stream()).map(PermItem::getPermItemId).collect(Collectors.toSet()))) {
            filterList.add(new QFilter("permitem", "in", collect));
        }
        return filterList;
    }

    public PermResult afterMainEntitySave(PermOperationReq reqOri) {
        try {
            AdmGrpOperationReq req = (AdmGrpOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<Long, Set<AdmGrpFunperm>> afterDataMap = AdmGrpFunpermService.getAdmGrpFunpermSetMap(new GetAdmGrpFunpermReq(mainIdSet, null, null, null, null, null, null, null, null));
            Set<Long> adminGroupIdSet = afterDataMap.keySet();
            if (null == adminGroupIdSet || adminGroupIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap<String, Map> saveDiffMap = new HashMap<String, Map>(8);
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, Set<AdmGrpFunperm>>>(){}));
            }
            for (Long adminGroupId : adminGroupIdSet) {
                Set pre = null == preDataMap.get(adminGroupId) ? new HashSet(0) : (Set)preDataMap.get(adminGroupId);
                Set<Object> after = null == afterDataMap.get(adminGroupId) ? new HashSet(0) : afterDataMap.get(adminGroupId);
                Sets.SetView del = Sets.difference(pre, after);
                Sets.SetView add = Sets.difference(after, pre);
                if (kd.bos.util.CollectionUtils.isEmpty((Collection)del) && kd.bos.util.CollectionUtils.isEmpty((Collection)add)) continue;
                String adminGroupIdStr = String.valueOf(adminGroupId);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("delAdmGrpFunperm", del);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("addAdmGrpFunperm", add);
            }
            AdminGroupService.saveOrDel((AdmGrpOperationReq)((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setMainIdSet, adminGroupIdSet.stream().map(String::valueOf).collect(Collectors.toSet())).with(PermOperationReq::setCurAppNum, (Object)req.getCurAppNum()).with(PermOperationReq::setCurFormNum, (Object)req.getCurFormNum()).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDoDelExcessData, (Object)req.getDoDelExcessData()).with(PermOperationReq::setDiffContentMap, saveDiffMap).with(PermOperationReq::setPermLogReq, (Object)req.getPermLogReq()).with(AdmGrpOperationReq::setPreAdmGroupMap, (Object)req.getPreAdmGroupMap()).with(AdmGrpOperationReq::setPreAdmUserIdSetMap, (Object)req.getPreAdmUserIdSetMap()).build()));
            super.afterMainEntitySaveExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    public PermResult afterDel(PermOperationReq reqOri) {
        try {
            Set adminGroupIdSet;
            AdmGrpOperationReq req = (AdmGrpOperationReq)reqOri;
            Set mainIdSet = req.getMainIdSet();
            if (null == mainIdSet || mainIdSet.isEmpty()) {
                return PermResult.ok();
            }
            HashMap preDataMap = new HashMap(8);
            String preDataMapStr = req.getPreDataMapStr();
            if (StringUtils.isNotEmpty((String)preDataMapStr)) {
                String uncompress = StrUtil.uncompress((String)preDataMapStr);
                preDataMap.putAll((Map)new ObjectMapper().readValue(uncompress, (TypeReference)new TypeReference<HashMap<Long, Set<AdmGrpFunperm>>>(){}));
            }
            if (null == (adminGroupIdSet = preDataMap.keySet()) || adminGroupIdSet.isEmpty()) {
                return PermResult.ok();
            }
            Map<Long, Set<AdmGrpFunperm>> afterDataMap = AdmGrpFunpermService.getAdmGrpFunpermSetMap(new GetAdmGrpFunpermReq(null, adminGroupIdSet, null, null, null, null, null, null, null));
            HashMap<String, Map> saveDiffMap = new HashMap<String, Map>(8);
            for (Long adminGroupId : adminGroupIdSet) {
                Set<Object> after;
                Set pre = null == preDataMap.get(adminGroupId) ? new HashSet(0) : (Set)preDataMap.get(adminGroupId);
                Sets.SetView del = Sets.difference(pre, after = null == afterDataMap.get(adminGroupId) ? new HashSet(0) : afterDataMap.get(adminGroupId));
                if (kd.bos.util.CollectionUtils.isEmpty((Collection)del)) continue;
                String adminGroupIdStr = String.valueOf(adminGroupId);
                saveDiffMap.computeIfAbsent(adminGroupIdStr, k -> new HashMap()).put("delAdmGrpFunperm", del);
            }
            AdminGroupService.saveOrDel((AdmGrpOperationReq)((AdmGrpOperationReq)PermBuilder.of(AdmGrpOperationReq::new).with(PermOperationReq::setMainIdSet, adminGroupIdSet.stream().map(String::valueOf).collect(Collectors.toSet())).with(PermOperationReq::setCurAppNum, (Object)req.getCurAppNum()).with(PermOperationReq::setCurFormNum, (Object)req.getCurFormNum()).with(PermOperationReq::setNeedClearAllCache, (Object)req.getNeedClearAllCache()).with(PermOperationReq::setDoDelExcessData, (Object)req.getDoDelExcessData()).with(PermOperationReq::setDiffContentMap, saveDiffMap).with(PermOperationReq::setPermLogReq, (Object)req.getPermLogReq()).with(AdmGrpOperationReq::setPreAdmGroupMap, (Object)req.getPreAdmGroupMap()).with(AdmGrpOperationReq::setPreAdmUserIdSetMap, (Object)req.getPreAdmUserIdSetMap()).build()));
            super.afterDelExt((PermOperationReq)req);
        }
        catch (Exception e) {
            log.warn("{}.{} error.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), e});
            throw new KDBizException(e.getMessage());
        }
        return PermResult.ok();
    }

    public static PermResult saveByAdmGrp(AdmGrpOperationReq req) {
        Map willAddFunpermMap;
        String curAppNum = req.getCurAppNum();
        String curFormNum = req.getCurFormNum();
        String operEntNum = "perm_admingroupfunperm";
        String needClearAllCache = req.getNeedClearAllCache();
        String alreadyCheckBusiParam = req.getAlreadyCheckBusiParam();
        String doDelExcessData = req.getDoDelExcessData();
        Boolean entSavePermlog = req.getEntSavePermlog();
        PermLogReq permLogReq = req.getPermLogReq();
        String permLogInterfaceMethod = "AdmGrpFunpermService.saveByAdmGrp";
        Map willDelFunpermMap = req.getWillDelFunpermMap();
        if (null != willDelFunpermMap && !willDelFunpermMap.isEmpty()) {
            PermResult delRes;
            DynamicObject[] dynArr;
            Map<Long, AdmGrpFunperm> dataMap;
            HashSet<Long> admGrpIdSet = new HashSet<Long>(8);
            HashSet<String> appIdSet = new HashSet<String>(8);
            HashSet<String> entNumSet = new HashSet<String>(8);
            HashSet<String> permItemIdSet = new HashSet<String>(8);
            HashSet<String> uniqueStrSet = new HashSet<String>(8);
            for (Map.Entry one : willDelFunpermMap.entrySet()) {
                String adminGroupId = (String)one.getKey();
                Set value = (Set)one.getValue();
                if (StringUtils.isEmpty((String)adminGroupId) || null == value || value.isEmpty()) continue;
                admGrpIdSet.add(Long.valueOf(adminGroupId));
                for (AdmGrpFunperm innerOne : value) {
                    String appId = innerOne.getAppId();
                    String entNum = innerOne.getEntNum();
                    String permItemId = innerOne.getPermItemId();
                    appIdSet.add(appId);
                    entNumSet.add(entNum);
                    permItemIdSet.add(permItemId);
                    uniqueStrSet.add(adminGroupId + "|" + appId + "|" + entNum + "|" + permItemId);
                }
            }
            if (!(null == admGrpIdSet || admGrpIdSet.isEmpty() || null == (dataMap = AdmGrpFunpermService.getAdmGrpFunpermMap(new GetAdmGrpFunpermReq(null, admGrpIdSet, null, appIdSet, null, entNumSet, permItemIdSet, null, uniqueStrSet))) || dataMap.isEmpty() || null == (dynArr = BusinessDataServiceHelper.load((String)operEntNum, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", dataMap.keySet())})) || Objects.equals(0, dynArr.length) || (delRes = AdmGrpFunpermService.genOperateOptionAndExec((PermOperationReq)((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setOperEntnum, (Object)operEntNum).with(PermOperationReq::setOperationKey, (Object)"delete").with(PermOperationReq::setDataEntities, (Object)dynArr).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPermLogOp, (Object)"delete").with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getDel()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)permLogInterfaceMethod).build()))).isOk())) {
                return delRes;
            }
        }
        if (null != (willAddFunpermMap = req.getWillAddFunpermMap()) && !willAddFunpermMap.isEmpty()) {
            GetBaseDataDynMapResp baseDataDynMapResp = null == req.getBaseDataDynMapResp() ? new GetBaseDataDynMapResp() : req.getBaseDataDynMapResp();
            Map appDynMap = null == baseDataDynMapResp.getAppDynMap() ? new HashMap(0) : baseDataDynMapResp.getAppDynMap();
            Map entDynMap = null == baseDataDynMapResp.getEntDynMap() ? new HashMap(0) : baseDataDynMapResp.getEntDynMap();
            Map permItemDynMap = null == baseDataDynMapResp.getPermItemDynMap() ? new HashMap(0) : baseDataDynMapResp.getPermItemDynMap();
            ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(willAddFunpermMap.size());
            DynamicObject dyn = null;
            for (Map.Entry one : willAddFunpermMap.entrySet()) {
                String adminGroupId = (String)one.getKey();
                Set value = (Set)one.getValue();
                if (StringUtils.isEmpty((String)adminGroupId) || null == value || value.isEmpty()) continue;
                for (AdmGrpFunperm innerOne : value) {
                    dyn = BusinessDataServiceHelper.newDynamicObject((String)operEntNum);
                    dyn.set("usergroup_id", (Object)adminGroupId);
                    String appId = innerOne.getAppId();
                    dyn.set("app_id", (Object)appId);
                    dyn.set("app", appDynMap.get(appId));
                    String entNum = innerOne.getEntNum();
                    dyn.set("entitynum_id", (Object)entNum);
                    dyn.set("entitynum", entDynMap.get(entNum));
                    String permItemId = innerOne.getPermItemId();
                    dyn.set("permitem_id", (Object)permItemId);
                    dyn.set("permitem", permItemDynMap.get(permItemId));
                    dynList.add(dyn);
                }
            }
            PermResult addRes = AdmGrpFunpermService.genOperateOptionAndExec((PermOperationReq)((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)curFormNum).with(PermOperationReq::setOperEntnum, (Object)operEntNum).with(PermOperationReq::setOperationKey, (Object)"save").with(PermOperationReq::setDataEntities, (Object)dynList.toArray(new DynamicObject[dynList.size()])).with(PermOperationReq::setNeedClearAllCache, (Object)needClearAllCache).with(PermOperationReq::setAlreadyCheckBusiParam, (Object)alreadyCheckBusiParam).with(PermOperationReq::setDoDelExcessData, (Object)doDelExcessData).with(PermOperationReq::setEntSavePermlog, (Object)entSavePermlog).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setPermLogOp, (Object)"save").with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getSave()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)permLogInterfaceMethod).build()));
            if (!addRes.isOk()) {
                return addRes;
            }
        }
        return PermResult.ok();
    }
}

