/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.impexp.imp;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.EnumsYesNo;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.imp.UserDisPermImportBean;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.bat.aftersave.UserDirectDisPermAfterSaveReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermUserReq;
import kd.bos.permission.model.perm.req.permitem.GetPlainPermItemListReq;
import kd.bos.permission.model.perm.req.user.GetUserDisFuncDimReq;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermUserResp;
import kd.bos.permission.model.perm.user.UserFuncDim;
import kd.bos.permission.service.UserDisPermService;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class UserDisPermDetailImportPlugin
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(UserDisPermDetailImportPlugin.class);

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return super.getBatchImportSize();
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(ctx);
            formView.setVisible(Boolean.FALSE, new String[]{"radiofield1", "radiofield2"});
            IFormView parentView = formView.getParentView();
            if (parentView instanceof ListView) {
                String billFormId = ((ListView)parentView).getBillFormId();
                ctx.addOption("permImportFormNum", (Object)billFormId);
            }
        }
        catch (Exception e) {
            log.warn("UserDisPermDetailImportPlugin.setContext error", (Throwable)e);
        }
        return super.setContext(rc, ctx, startArgs);
    }

    protected MainEntityType buildMainEntityType(JSONObject billdata) {
        try {
            MainEntityType entityType = super.buildMainEntityType(billdata);
            entityType = (MainEntityType)entityType.clone();
            String controlFlag = "dimtype";
            IsoDimHelper.rewriteMainEntityType((String)controlFlag, null, (MainEntityType)entityType);
            BasedataEntityType bdet = (BasedataEntityType)entityType;
            if (null == bdet) {
                return entityType;
            }
            ItemClassTypeProp dimentitynum = (ItemClassTypeProp)bdet.getProperty(controlFlag);
            if (null != dimentitynum) {
                dimentitynum.setEditable(true);
            }
            this.mainEntityType = entityType;
            return entityType;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String billFormId = this.getBillFormId();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)billFormId);
        if (null == met) {
            return items;
        }
        BasedataEntityType bdet = (BasedataEntityType)met;
        if (null == bdet) {
            return items;
        }
        String numberProperty = bdet.getNumberProperty();
        if (StringUtils.isNotEmpty((String)numberProperty)) {
            for (IDataEntityProperty p : met.getProperties()) {
                if (!Objects.equals(numberProperty, p.getName())) continue;
                items.add(new ComboItem(p.getDisplayName(), p.getName()));
            }
        }
        return items;
    }

    public String getDefaultImportType() {
        return "new";
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        if (null == billdatas || billdatas.isEmpty()) {
            super.beforeSave(billdatas, logger);
            return;
        }
        this.commonParam2Ctx();
        HashMap<Integer, List> beforeSaveFailedErrorMap = new HashMap<Integer, List>(8);
        Map yesNoMap = (Map)this.ctx.getOption().get("yesNoMap");
        for (ImportBillData bill : billdatas) {
            JSONObject data;
            if (bill.isEmpty() || (data = bill.getData()) == null || !data.containsKey((Object)"includesub")) continue;
            String includesuborg = data.getString("includesub");
            if (yesNoMap.values().contains(includesuborg)) continue;
            beforeSaveFailedErrorMap.computeIfAbsent(bill.getStartIndex(), k -> new ArrayList(10)).add(String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleImportPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), includesuborg));
        }
        this.ctx.addOption("beforeSaveFailedErrorMap", beforeSaveFailedErrorMap);
        super.beforeSave(billdatas, logger);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        List value;
        Integer row;
        Object currentImportType = this.ctx.getOption().get("importtype");
        EnumsImportType enumsImportType = EnumsImportType.getImportTypeEnum(currentImportType);
        if (null == enumsImportType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u5bfc\u5165\u7c7b\u578b\u3002", (String)"RoleAndFuncImportPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        List<String> keyFieldList = null;
        Object keyFields = this.ctx.getOption().get("KeyFields");
        if (!Objects.isNull(keyFields)) {
            keyFieldList = Arrays.stream(((String)keyFields).split(",")).filter(x -> StringUtils.isNotEmpty((String)x)).collect(Collectors.toList());
        }
        Map bigPermCtrlTypeMap = (Map)this.ctx.getOption().get("bigPermCtrlTypeMap");
        HashMap<Integer, List<String>> paramFailedErrorMap = new HashMap<Integer, List<String>>(8);
        Object beforeSaveFailedErrorMapObj = this.ctx.getOption().get("beforeSaveFailedErrorMap");
        Map beforeSaveFailedErrorMap = null == beforeSaveFailedErrorMapObj ? new HashMap(0) : (Map)beforeSaveFailedErrorMapObj;
        for (Map.Entry failedError : beforeSaveFailedErrorMap.entrySet()) {
            Integer row2 = (Integer)failedError.getKey();
            List value2 = (List)failedError.getValue();
            paramFailedErrorMap.computeIfAbsent(row2, k -> new ArrayList(10)).addAll(value2);
        }
        PermBeforeSaveCheckReq req = this.wrapPermBeforeSaveCheckReq(rowdatas, enumsImportType, keyFieldList, bigPermCtrlTypeMap, paramFailedErrorMap);
        req.getCheckNeedParamMap().put("yesNoMap", (Map)this.ctx.getOption().get("yesNoMap"));
        req.getCheckNeedParamMap().put("bigPermCtrlTypeMap", bigPermCtrlTypeMap);
        req.getCheckNeedParamMap().put("plainPermItemSet", (Set)this.ctx.getOption().get("plainPermItemSet"));
        req.getCheckNeedParamMap().put("appNumEntNumSetMap", (Map)this.ctx.getOption().get("appNumEntNumSetMap"));
        req.getCheckNeedParamMap().put("entNumPermItemNumSetMap", (Map)this.ctx.getOption().get("entNumPermItemNumSetMap"));
        req.getCheckNeedParamMap().put("adminChargeAppSet", (Set)this.ctx.getOption().get("adminChargeAppSet"));
        req.getCheckNeedParamMap().put("allAppInfo", (Map)this.ctx.getOption().get("allAppInfo"));
        req.getCheckNeedParamMap().put("allPermItemNumberIdMap", (Map)this.ctx.getOption().get("allPermItemNumberIdMap"));
        PermCheckResp resp = UserDisPermDetailImportPlugin.getUserDisPermService().beforeSaveCheck(req);
        Map passedMap = resp.getPassedMap();
        HashMap<Integer, List> failedErrorMap = resp.getFailedErrorMap();
        if (null == failedErrorMap) {
            failedErrorMap = new HashMap<Integer, List>(1);
        }
        for (Map.Entry failedError : paramFailedErrorMap.entrySet()) {
            row = (Integer)failedError.getKey();
            value = (List)failedError.getValue();
            if (null == row || null == value || value.isEmpty()) continue;
            failedErrorMap.computeIfAbsent(row, k -> new ArrayList(10)).addAll(value);
        }
        for (Map.Entry failedError : failedErrorMap.entrySet()) {
            row = (Integer)failedError.getKey();
            value = (List)failedError.getValue();
            if (null == row || null == value || value.isEmpty()) continue;
            value.stream().forEach(x -> logger.log(row, x));
        }
        PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"userdirect_disfunlist_import", (boolean)false);
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            JSONObject data;
            ImportBillData bill = it.next();
            if (bill.isEmpty() || null == (data = bill.getData())) continue;
            try {
                int row3 = bill.getStartIndex();
                if (failedErrorMap.containsKey(row3)) {
                    it.remove();
                    logger.fail();
                    logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
                    continue;
                }
                UserDisPermDetailImportPlugin.replaceFieldValue(passedMap, data, row3, permLogBusiType);
            }
            catch (Throwable throwable) {
                log.warn("UserDisPermDetailImportPlugin.save error.", throwable);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    logger.log(Integer.valueOf(rowdatas.get(0).getStartIndex()), throwable);
                } else {
                    logger.log(Integer.valueOf(rowdatas.get(0).getStartIndex()), ResManager.loadKDString((String)"\u6570\u636e\u5305\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"RoleAndFuncImportPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                }
                it.remove();
                logger.fail();
                logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
            }
        }
        ApiResult apiResult = super.save(rowdatas, logger);
        if (null == apiResult) {
            return null;
        }
        Object apiData = apiResult.getData();
        if (null == apiData) {
            return null;
        }
        HashSet<String> mainIdSet = new HashSet<String>(8);
        List saveResult = (List)apiData;
        for (Map map : saveResult) {
            Integer dindex = (Integer)map.get("dindex");
            Boolean success = (Boolean)map.get("success");
            String successMainId = (String)map.get("id");
            if (!Boolean.TRUE.equals(success) || StringUtils.isEmpty((String)successMainId)) continue;
            mainIdSet.add(successMainId);
        }
        if (null == mainIdSet || mainIdSet.isEmpty()) {
            return apiResult;
        }
        Map<Long, Set<UserFuncDim>> addUserDisUFDMap = UserDisPermDetailImportPlugin.getAddUserDisUFDMap(mainIdSet);
        PermLogReq permLogReq = this.wrapPermLogReq();
        UserDirectDisPermAfterSaveReq afterSaveReq = (UserDirectDisPermAfterSaveReq)PermBuilder.of(UserDirectDisPermAfterSaveReq::new).with(PermOperationReq::setEnumsImportType, (Object)enumsImportType).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(UserDirectDisPermAfterSaveReq::setAddUserUFDMap, addUserDisUFDMap).build();
        UserDisPermDetailImportPlugin.getUserDisPermService().afterMainEntitySave((PermOperationReq)afterSaveReq);
        return apiResult;
    }

    private static Map<Long, Set<UserFuncDim>> getAddUserDisUFDMap(Set<String> mainIdSet) {
        HashMap<Long, Set<UserFuncDim>> addUserDisUFDMap = new HashMap<Long, Set<UserFuncDim>>(8);
        GetUserDisFuncDimReq req = new GetUserDisFuncDimReq();
        req.setReturnType(Integer.valueOf(2));
        req.setMainIdSet(mainIdSet);
        Map userDisFuncDimMap = UserDisPermService.getUserFuncDimMap((GetUserDisFuncDimReq)req);
        for (Map.Entry userDisFuncDim : userDisFuncDimMap.entrySet()) {
            UserFuncDim value = (UserFuncDim)userDisFuncDim.getValue();
            if (null == value) continue;
            addUserDisUFDMap.computeIfAbsent(value.getUserId(), k -> new HashSet(8)).add(value);
        }
        return addUserDisUFDMap;
    }

    private PermLogReq wrapPermLogReq() {
        if (!PermCommonUtil.isEnablePermLog()) {
            return null;
        }
        String appNum = "";
        String formShowParameterAppId = this.ctx.getFormShowParameterAppId();
        if (StringUtils.isNotEmpty((String)formShowParameterAppId)) {
            appNum = formShowParameterAppId;
        }
        String checkRightAppId = this.ctx.getCheckRightAppId();
        if (StringUtils.isEmpty((String)appNum) && StringUtils.isNotEmpty((String)checkRightAppId)) {
            appNum = checkRightAppId;
        }
        if (StringUtils.isEmpty((String)appNum)) {
            appNum = this.ctx.getAppId();
        }
        String appId = AppHelper.getMetaAppInfo((String)appNum).getId();
        String formNum = this.ctx.getBillFormId();
        String appIdByFormNum = StringUtils.isEmpty((String)appId) ? BizAppServiceHelp.getAppIdByFormNum((String)formNum) : appId;
        String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
        PermLogReq permLogReq = new PermLogReq();
        PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"userdirect_disfunlist_import");
        permLogReq.setBusiFrom(null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
        permLogReq.setBusiType(null == permLogBusiType ? "" : permLogBusiType.getBusiType());
        permLogReq.setFormIdentity(formNum);
        permLogReq.setAppId(appIdByFormNum);
        permLogReq.setCloudId(cloudId);
        permLogReq.setOp("importdata");
        permLogReq.setOpbtn(ConstantsHelper.getImportData());
        permLogReq.setInterfaceMethod("UserDisPermDetailImportPlugin.wrapPermLogReq");
        permLogReq.setOperTime(TimeServiceHelper.now());
        permLogReq.setClientType(RequestContext.get().getClient());
        permLogReq.setClientIp(RequestContext.get().getLoginIP());
        return permLogReq;
    }

    private static UserDisPermService getUserDisPermService() {
        return (UserDisPermService)PermServiceFactory.getService((String)"UserDisPermService");
    }

    private void commonParam2Ctx() {
        Object allPermItemNumberIdMapObj;
        Object allAppInfoObj;
        Object plainPermItemSetObj;
        Object bigPermCtrlTypeMapObj;
        Object yesNoMapObj = this.ctx.getOption().get("yesNoMap");
        if (null == yesNoMapObj) {
            Map yesNoMap = EnumsYesNo.getMap();
            this.ctx.addOption("yesNoMap", (Object)yesNoMap);
        }
        if (null == (bigPermCtrlTypeMapObj = this.ctx.getOption().get("bigPermCtrlTypeMap"))) {
            PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq(null, null, null, null, null);
            Map bigPermCtrlTypeMap = IsoDimHelper.getBigPermCtrlTypeMap((PermCtrlTypeReq)permCtrlTypeReq);
            this.ctx.addOption("bigPermCtrlTypeMap", (Object)bigPermCtrlTypeMap);
        }
        if (null == (plainPermItemSetObj = this.ctx.getOption().get("plainPermItemSet"))) {
            GetPlainPermItemListReq req = new GetPlainPermItemListReq();
            req.setDimType("DIM_ORG");
            req.setReturnByField(true);
            req.setReturnFieldSet((Set)Sets.newHashSet((Object[])new String[]{"appNumber", "entityNumber", "permItemNumber"}));
            List plainPermItemList = PermItemHelper.getPlainPermItemList((GetPlainPermItemListReq)req);
            HashSet plainPermItemSet = new HashSet(plainPermItemList);
            this.ctx.addOption("plainPermItemSet", plainPermItemSet);
            HashMap<String, Set> appNumEntNumSetMap = new HashMap<String, Set>(8);
            HashMap<String, Set> entNumPermItemNumSetMap = new HashMap<String, Set>(8);
            for (PermItem permItem : plainPermItemSet) {
                appNumEntNumSetMap.computeIfAbsent(permItem.getAppNumber(), k -> new HashSet(8)).add(permItem.getEntityNumber());
                entNumPermItemNumSetMap.computeIfAbsent(permItem.getEntityNumber(), k -> new HashSet(8)).add(permItem.getPermItemNumber());
            }
            this.ctx.addOption("appNumEntNumSetMap", appNumEntNumSetMap);
            this.ctx.addOption("entNumPermItemNumSetMap", entNumPermItemNumSetMap);
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Object adminChargeAppSetObj = this.ctx.getOption().get("adminChargeAppSet");
        if (null == adminChargeAppSetObj) {
            HashSet adminChargeAppSet = new HashSet(AdminPermCache.getAdminChargeApps((Long)currUserId, null));
            this.ctx.addOption("adminChargeAppSet", adminChargeAppSet);
        }
        if (null == (allAppInfoObj = this.ctx.getOption().get("allAppInfo"))) {
            Map allAppInfo = AppMetadataCache.getAllAppInfo();
            this.ctx.addOption("allAppInfo", (Object)allAppInfo);
        }
        if (null == (allPermItemNumberIdMapObj = this.ctx.getOption().get("allPermItemNumberIdMap"))) {
            Map allPermItemNumberIdMap = PermItemHelper.getAllPermItemNumberIdMap();
            this.ctx.addOption("allPermItemNumberIdMap", (Object)allPermItemNumberIdMap);
        }
    }

    private static void replaceFieldValue(Map<Integer, UserDisPermImportBean> passedMap, JSONObject data, int row, PermLogBusiType permLogBusiType) {
        UserDisPermImportBean importBean = passedMap.get(row);
        if (null == importBean) {
            return;
        }
        data.put("dimtype", (Object)importBean.getDimType());
        data.put("fromtypedesc", (Object)(null == permLogBusiType ? "import" : permLogBusiType.getBusiTypeDesc()));
    }

    /*
     * WARNING - void declaration
     */
    private PermBeforeSaveCheckReq wrapPermBeforeSaveCheckReq(List<ImportBillData> billdatas, EnumsImportType enumsImportType, List<String> keyFieldList, Map<String, PermCtrlType> bigPermCtrlTypeMap, Map<Integer, List<String>> paramFailedErrorMap) {
        void var27_35;
        ArrayList<UserDisPermImportBean> importBeanList = new ArrayList<UserDisPermImportBean>(billdatas.size());
        HashSet<String> userNumSet = new HashSet<String>(8);
        HashSet<String> appNumSet = new HashSet<String>(8);
        HashSet<String> entNumSet = new HashSet<String>(8);
        HashSet<String> permItemNumSet = new HashSet<String>(8);
        HashSet<String> permItemIdSet = new HashSet<String>(8);
        HashMap<String, Set> dimTypeSmallDimNumSetMap = new HashMap<String, Set>(8);
        long currUserId = RequestContext.get().getCurrUserId();
        UserDisPermImportBean importBean = null;
        for (ImportBillData bill : billdatas) {
            void var31_39;
            String string;
            void var27_28;
            String string2;
            String importprop2;
            String importprop3;
            String importprop4;
            JSONObject import_dimtype;
            String importprop5;
            JSONObject data;
            if (bill.isEmpty() || (data = bill.getData()) == null) continue;
            importBean = new UserDisPermImportBean();
            importBean.setLineNum(bill.getStartIndex());
            String userNumber = "";
            JSONObject user = data.getJSONObject("user");
            if (null != user && StringUtils.isNotEmpty((String)(importprop5 = user.getString("importprop"))) && StringUtils.isNotEmpty((String)(userNumber = user.getString(importprop5)))) {
                userNumSet.add(userNumber);
            }
            importBean.setUserNumber(userNumber);
            String dimTypeBig = "";
            if (data.containsKey((Object)"import_dimtype") && null != (import_dimtype = data.getJSONObject("import_dimtype")) && StringUtils.isNotEmpty((String)(importprop4 = import_dimtype.getString("importprop")))) {
                dimTypeBig = import_dimtype.getString(importprop4);
            }
            String dimType = "";
            PermCtrlType permCtrlType = bigPermCtrlTypeMap.get(dimTypeBig);
            if (null != permCtrlType) {
                dimType = permCtrlType.getBizobjectid();
            }
            importBean.setDimType(dimType);
            importBean.setDimTypeBig(dimTypeBig);
            String dimNum = "";
            JSONObject itemclass = data.getJSONObject("dimid");
            if (null != itemclass && StringUtils.isNotEmpty((String)(importprop3 = itemclass.getString("importprop")))) {
                dimNum = itemclass.getString(importprop3);
            }
            importBean.setDimNum(dimNum);
            dimTypeSmallDimNumSetMap.computeIfAbsent(dimType, k -> new HashSet(8)).add(dimNum);
            Boolean includesuborg = data.getBooleanValue("includesub");
            importBean.setIncludeSub(includesuborg);
            String string3 = "";
            JSONObject bizapp = data.getJSONObject("bizapp");
            if (null != bizapp && StringUtils.isNotEmpty((String)(importprop2 = bizapp.getString("importprop"))) && StringUtils.isNotEmpty((String)(string2 = bizapp.getString(importprop2)))) {
                appNumSet.add(string2);
            }
            importBean.setAppNumber((String)var27_28);
            String entNum = "";
            JSONObject entitytype = data.getJSONObject("entitytype");
            if (null != entitytype && StringUtils.isNotEmpty((String)(string = entitytype.getString("importprop"))) && StringUtils.isNotEmpty((String)(entNum = entitytype.getString(string)))) {
                entNumSet.add(entNum);
            }
            importBean.setEntityNumber(entNum);
            String string4 = "";
            String permItemNum = "";
            JSONObject permitem = data.getJSONObject("permitem");
            if (null != permitem) {
                if (permitem.containsKey((Object)"id") && StringUtils.isNotEmpty((String)permitem.getString("id"))) {
                    String string5 = permitem.getString("id");
                    permItemIdSet.add(string5);
                }
                if (permitem.containsKey((Object)"number") && StringUtils.isNotEmpty((String)permitem.getString("number"))) {
                    permItemNum = permitem.getString("number");
                    permItemNumSet.add(permItemNum);
                }
            }
            importBean.setPermItemId((String)var31_39);
            importBean.setPermItemNumber(permItemNum);
            importBeanList.add(importBean);
        }
        HashMap<String, Object> importCheckParamMap = new HashMap<String, Object>(8);
        Map userNumMap = new HashMap(1);
        Map userNumExistMap = new HashMap(1);
        if (CollectionUtils.isNotEmpty(userNumSet)) {
            userNumMap = UserHelper.getUserMap(userNumSet, (String)"number");
            userNumExistMap = PermVerifyUtil.getExistMapByNum((String)"bos_user", userNumSet);
        }
        importCheckParamMap.put("userNumMap", userNumMap);
        importCheckParamMap.put("userNumExistMap", userNumExistMap);
        HashMap<String, Map> dimTypeDimNumDimMap = new HashMap<String, Map>(1);
        HashMap<String, GetHasPermPermCtrlObjResp> dimTypeAdminHasPermPermCtrlObjMap = new HashMap<String, GetHasPermPermCtrlObjResp>(1);
        HashMap<String, Map> dimTypeDimNumExistMap = new HashMap<String, Map>(1);
        HashMap<String, GetHasPermUserResp> dimTypeAdminHasPermUserMap = new HashMap<String, GetHasPermUserResp>(1);
        HashSet dimIdSet = null;
        if (null != dimTypeSmallDimNumSetMap && !dimTypeSmallDimNumSetMap.isEmpty()) {
            int size = dimTypeSmallDimNumSetMap.size();
            dimTypeDimNumDimMap = new HashMap(size);
            dimTypeAdminHasPermPermCtrlObjMap = new HashMap(size);
            dimTypeDimNumExistMap = new HashMap(size);
            dimTypeAdminHasPermUserMap = new HashMap(size);
            dimIdSet = new HashSet(8);
            for (Map.Entry entry : dimTypeSmallDimNumSetMap.entrySet()) {
                String dimTypeSmall = (String)entry.getKey();
                Set dimNumSet = (Set)entry.getValue();
                if (StringUtils.isEmpty((String)dimTypeSmall) || CollectionUtils.isEmpty((Collection)dimNumSet)) continue;
                Map dimNumDimSetMap = IsoDimHelper.getDimSetMap((Set)dimNumSet, (String)"number", (String)dimTypeSmall);
                dimTypeDimNumDimMap.put(dimTypeSmall, dimNumDimSetMap);
                Set set = dimNumDimSetMap.values().stream().flatMap(x -> x.stream()).map(Dim::getDimId).collect(Collectors.toSet());
                GetHasPermPermCtrlObjResp adminHasPermPermCtrlObj = PermCtrlTypeService.getAdminHasPermPermCtrlObj((GetHasPermPermCtrlObjReq)new GetHasPermPermCtrlObjReq(dimTypeSmall, Long.valueOf(currUserId), set, dimNumSet));
                dimTypeAdminHasPermPermCtrlObjMap.put(dimTypeSmall, adminHasPermPermCtrlObj);
                Map dimNumExistMap = PermVerifyUtil.getExistMapByNum((String)dimTypeSmall, (Set)dimNumSet);
                dimTypeDimNumExistMap.put(dimTypeSmall, dimNumExistMap);
                GetHasPermUserResp adminHasPermUser = PermCtrlTypeService.getAdminHasPermUser((GetHasPermUserReq)new GetHasPermUserReq(dimTypeSmall, Long.valueOf(currUserId), null, userNumSet));
                dimTypeAdminHasPermUserMap.put(dimTypeSmall, adminHasPermUser);
                dimIdSet.addAll(set);
            }
        }
        importCheckParamMap.put("dimTypeDimNumDimMap", dimTypeDimNumDimMap);
        importCheckParamMap.put("dimTypeAdminHasPermPermCtrlObjMap", dimTypeAdminHasPermPermCtrlObjMap);
        importCheckParamMap.put("dimTypeDimNumExistMap", dimTypeDimNumExistMap);
        importCheckParamMap.put("dimTypeAdminHasPermUserMap", dimTypeAdminHasPermUserMap);
        Map userDisFuncDimMap = UserDisPermService.getUserFuncDimMap((GetUserDisFuncDimReq)new GetUserDisFuncDimReq(Integer.valueOf(1), null, null, userNumSet, null, appNumSet, entNumSet, permItemIdSet, permItemNumSet, dimTypeDimNumDimMap.keySet(), dimIdSet, null));
        importCheckParamMap.put("userDisFuncDimMap", userDisFuncDimMap);
        Map appMap = null;
        if (CollectionUtils.isNotEmpty(appNumSet)) {
            appMap = AppHelper.getAppMap(appNumSet, (String)"number");
        }
        importCheckParamMap.put("appMap", appMap);
        Object var27_33 = null;
        HashMap<String, String> formCtrlTypeMap = null;
        if (CollectionUtils.isNotEmpty(entNumSet)) {
            Map map = FormHelper.getEntMap(entNumSet, (String)"number");
            Map permControlTypeMap = PermCommonUtil.getPermControlType(entNumSet);
            if (null != permControlTypeMap && !permControlTypeMap.isEmpty()) {
                formCtrlTypeMap = new HashMap<String, String>(permControlTypeMap.size());
                for (Map.Entry entry : permControlTypeMap.entrySet()) {
                    String dimension;
                    boolean emptyObject;
                    boolean controlFunction;
                    String key = (String)entry.getKey();
                    PermissionControlType value = (PermissionControlType)entry.getValue();
                    if (StringUtils.isEmpty((String)key) || null == value || !(controlFunction = value.isControlFunction()) || (emptyObject = value.isEmptyObject()) || StringUtils.isEmpty((String)(dimension = value.getDimension()))) continue;
                    formCtrlTypeMap.put(key, dimension);
                }
            }
        }
        importCheckParamMap.put("entMap", var27_35);
        importCheckParamMap.put("formCtrlTypeMap", formCtrlTypeMap);
        Map permItemMap = null;
        Map permItemExistMap = null;
        if (CollectionUtils.isNotEmpty(permItemNumSet)) {
            permItemMap = PermItemHelper.getPermItemMap(permItemNumSet, (String)"number");
        }
        if (CollectionUtils.isNotEmpty(permItemIdSet)) {
            permItemExistMap = PermItemHelper.getPermItemMap(permItemIdSet);
        }
        importCheckParamMap.put("permItemMap", permItemMap);
        importCheckParamMap.put("permItemExistMap", permItemExistMap);
        PermBeforeSaveCheckReq permBeforeSaveCheckReq = new PermBeforeSaveCheckReq();
        permBeforeSaveCheckReq.setEnumsImportType(enumsImportType);
        permBeforeSaveCheckReq.setKeyFieldList(keyFieldList);
        permBeforeSaveCheckReq.setNeedCheckBeanList(importBeanList);
        permBeforeSaveCheckReq.setCheckNeedParamMap(importCheckParamMap);
        return permBeforeSaveCheckReq;
    }
}

