/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.OrgUserHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.model.PermUserRole;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.permission.model.perm.DimUserEdit;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class RoleAssignUserMultiTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(RoleAssignUserMultiTask.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"RoleAssignUserMultiTask", (int)1);
    private static String systemTypeFormplugin = "bos-permission-formplugin";
    private static final String ROLE = "role";
    private static final String PGCACHE_NOTLOADEDBUTDEL_LEFTIDS = "pgcache_notLoadedButDel_LeftIds";
    private static final String PGCACHE_LOADEDANDMODIFIEDDATAMAP = "pgcache_loadedAndModifiedDataMap";
    private static final String PGCACHE_BATCHADDDATAMAP = "pgcache_batchAddDataMap";
    private static final String PGCACHE_ISLEFTDIM = "pgcache_isleftdim";
    private static final String PGCACHE_DIMTABKEYS = "pgcache_dimtabkeys";
    private static final String ENDTIMECONST = "2999-12-31 23:59:59";

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"RoleAssignUserMultiTask_0", (String)systemTypeFormplugin, (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        try {
            this.dealMainBusi(params);
            desc = ResManager.loadKDString((String)"\u64cd\u4f5c\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u3002", (String)"RoleAssignUserMultiTask_1", (String)systemTypeFormplugin, (Object[])new Object[0]);
            int progress = 98;
            this.feedbackProgress(progress, desc, null);
        }
        catch (Exception e) {
            log.warn("RoleAssignUserMultiTask.execute error", (Throwable)e);
            this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:%1$s", (String)"RoleAssignUserMultiTask_2", (String)systemTypeFormplugin, (Object[])new Object[0]), e.getMessage()), null);
        }
    }

    private void dealMainBusi(Map<String, Object> params) {
        try {
            Map batchAddDataMap;
            String jsonMap;
            String pageId = (String)params.get("pageId");
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            IDataModel dataModel = view.getModel();
            DynamicObject role = (DynamicObject)dataModel.getValue(ROLE);
            if (null == role) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89d2\u8272", (String)"RoleAssignUserMultiTask_3", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return;
            }
            String roleId = role.getString("id");
            int progress = 5;
            this.feedbackProgress(progress, ResManager.loadKDString((String)"\u754c\u9762\u6570\u636e\u83b7\u53d6\u5b8c\u6bd5\uff0c\u51c6\u5907\u8fdb\u884c\u89e3\u6790\u3002", (String)"RoleAssignUserMultiTask_4", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
            Map<String, Object> notLoadedButDelDataParamMap = this.getNotLoadedButDelDataParam(roleId, view, pageId);
            progress = 15;
            this.feedbackProgress(progress, ResManager.loadKDString((String)"\u754c\u9762\u4fe1\u606f\u89e3\u6790\u4e2d\u3002", (String)"RoleAssignUserMultiTask_5", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
            Map<String, Object> loadedAndModifiedDataParamMap = this.getLoadedAndModifiedDataParam(roleId, view, pageId, params);
            progress = 25;
            this.feedbackProgress(progress, ResManager.loadKDString((String)"\u754c\u9762\u4fe1\u606f\u89e3\u6790\u4e2d\u3002", (String)"RoleAssignUserMultiTask_5", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
            HashSet<String> dimType4log = new HashSet<String>(8);
            HashSet<Long> dimId4log = new HashSet<Long>(8);
            HashSet<Long> userId4log = new HashSet<Long>(8);
            if (PermCommonUtil.isEnablePermLog() && null != (jsonMap = view.getPageCache().get(PGCACHE_BATCHADDDATAMAP)) && !StringUtils.isEmpty((String)jsonMap) && null != (batchAddDataMap = (Map)SerializationUtils.fromJsonString((String)jsonMap, Map.class)) && !batchAddDataMap.isEmpty()) {
                int count = 0;
                int maxCount = 1000000;
                for (Map.Entry entry : batchAddDataMap.entrySet()) {
                    int valueCount;
                    String key = (String)entry.getKey();
                    List value = (List)entry.getValue();
                    int n = valueCount = value != null ? value.size() : 0;
                    if (key.contains("user$")) {
                        String[] userSplit = key.split("\\$");
                        if (userSplit.length == 0) continue;
                        int userCount = userSplit.length - 1;
                        count += userCount * valueCount;
                        for (int i = 1; i < userSplit.length; ++i) {
                            ++userCount;
                            String userId = userSplit[i];
                            userId4log.add(Long.valueOf(userId));
                        }
                    } else {
                        String[] dimSplit = key.split("\\$");
                        if (dimSplit.length == 0) continue;
                        int dimCount = dimSplit.length - 1;
                        count += dimCount * valueCount;
                        String dimType = dimSplit[0];
                        dimType4log.add(dimType);
                        for (int i = 1; i < dimSplit.length; ++i) {
                            Long dimId = Long.valueOf(dimSplit[i]);
                            dimId4log.add(dimId);
                        }
                    }
                    if (count <= maxCount) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u914d\u6570\u636e\u91cf\u8f83\u5927\uff0c\u5efa\u8bae\u51cf\u5c11\u5206\u914d\u91cf\u6216\u8bbe\u7f6e\u201c\u5206\u914d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u201d\u3002", (String)"RoleAssignUserMultiTask_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                }
            }
            if (this.isStop()) {
                this.stop();
            }
            Future saveDataFuture = pool.submit((Callable)new /* Unavailable Anonymous Inner Class!! */);
            this.cycle2GetDataSaveProgress(progress, saveDataFuture, 98);
        }
        catch (Exception e) {
            log.warn("RoleAssignUserMultiTask.dealMainBusi error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private void busiAfterSave(String roleId, Map<String, Object> diffMap, Map<String, Object> params) throws Exception {
        HashSet changedUserIdSet = new HashSet(1);
        HashSet lisenceUserIdSet = new HashSet(1);
        List delList = new LinkedList();
        List addList = new LinkedList();
        if (!CollectionUtils.isEmpty(diffMap)) {
            delList = (List)diffMap.get("del");
            addList = (List)diffMap.get("add");
            Set addUserIdSet = addList.stream().map(PermUserRole::getFuserid).collect(Collectors.toSet());
            changedUserIdSet.addAll(delList.stream().map(PermUserRole::getFuserid).collect(Collectors.toSet()));
            changedUserIdSet.addAll(addUserIdSet);
            lisenceUserIdSet.addAll(addUserIdSet);
        }
        if (!CollectionUtils.isEmpty(changedUserIdSet)) {
            UserHasPermOrgCache.clearUserLoginOrgs(changedUserIdSet);
            LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)roleId, (String)RequestContext.get().getLang().toString());
            List newDRAppEntityList = newDataRule.getNewDRAppEntityList();
            PermCommonUtil.cancelShowForm(new ArrayList(changedUserIdSet), (List)newDRAppEntityList, (boolean)false);
        }
        Map appEntity = PermissionServiceHelper.getAppEntityByRoleSet((Set)Sets.newHashSet((Object[])new String[]{roleId}));
        LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList(lisenceUserIdSet), (Map)appEntity);
        if (!(!PermCommonUtil.isEnablePermLog() || CollectionUtils.isEmpty(diffMap) || CollectionUtils.isEmpty(delList) && CollectionUtils.isEmpty(addList))) {
            String opbtn = ConstantsHelper.getSave();
            diffMap.put("langStr", RequestContext.get().getLang().name());
            this.commRoleAssignUserMulti2PermLog("baritem_save", opbtn, StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffMap)), params);
        }
        PermissionServiceHelper.clearAllCache();
        if (!PermFormCommonUtil.isSingleOrg((String)"bos_org")) {
            HashSet<String> roleIdSet = new HashSet<String>(1);
            roleIdSet.add(roleId);
            Map roleDimTypeSetMap = PermRoleHelper.getRoleDimTypeSetMap(roleIdSet, (boolean)false, (boolean)true);
            Set roleHasDimTypes = (Set)roleDimTypeSetMap.get(roleId);
            if (roleHasDimTypes != null && !roleHasDimTypes.isEmpty()) {
                String sql = "select distinct ur.fdimtype from t_perm_userrole ur join t_perm_ctrltype ct on (ur.fdimtype = ct.fbizobjectid and ct.fsystreefilter = '1') where ur.froleid = ?";
                List roleAssignDimTypes = (List)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])new Object[]{roleId}, resultSet -> {
                    ArrayList<String> result = new ArrayList<String>(10);
                    while (resultSet.next()) {
                        result.add(resultSet.getString("fdimtype"));
                    }
                    return result;
                });
                roleAssignDimTypes.forEach(roleHasDimTypes::remove);
                roleHasDimTypes.remove("bos_objecttype");
                if (!roleHasDimTypes.isEmpty()) {
                    StringBuilder dontAssignDimType = new StringBuilder();
                    DynamicObjectCollection dimTypeObjCol = QueryServiceHelper.query((String)"perm_ctrltype", (String)"name", (QFilter[])new QFilter[]{new QFilter("bizobjectid", "in", (Object)roleHasDimTypes)});
                    for (DynamicObject dimTypeObj : dimTypeObjCol) {
                        dontAssignDimType.append("\u201c").append(dimTypeObj.getString("name")).append("\u201d\uff0c");
                    }
                    if (dontAssignDimType.length() != 0) {
                        dontAssignDimType.deleteCharAt(dontAssignDimType.length() - 1);
                        this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002\u5b58\u5728\u672a\u6388\u6743\u7684\u6743\u9650\u7c7b\u578b\uff1a%s\u3002\u5982\u4e0d\u6388\u6743\u5219\u4f1a\u5f71\u54cd\u6743\u9650\u7c7b\u578b\u5bf9\u5e94\u5185\u5bb9\u4e0d\u53ef\u4f7f\u7528\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"RoleAssignUserMultiTask_7", (String)"bos-permission-formplugin", (Object[])new Object[]{dontAssignDimType.toString()}), 8000);
                        return;
                    }
                }
            }
        }
        this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RoleAssignUserMultiTask_8", (String)"bos-permission-formplugin", (Object[])new Object[0]), 3000);
    }

    private void commRoleAssignUserMulti2PermLog(String op, String opbtn, String diffContent, Map<String, Object> params) {
        String opItemNumber = (String)params.get("roleNumber");
        try {
            String opItemId = (String)params.get("roleId");
            String opItemName = (String)params.get("roleName");
            String appId = (String)params.get("appId");
            String formNum = (String)params.get("formNum");
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            String pageId = (String)params.get("pageId");
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            boolean isLeftDim = Boolean.parseBoolean(view.getPageCache().get(PGCACHE_ISLEFTDIM));
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", PermLogUtil.getPermLogFnumber());
            map.put("busi_from", kd.bos.permission.log.helper.ConstantsHelper.getCommonRoleAssignorguserBusifrom((String)formNum));
            PermLogBusiType permLogBusiType = isLeftDim ? PermLogService.getPermLogBusiType((String)"common_role_assignorguser") : PermLogService.getPermLogBusiType((String)"common_role_assignuserorg");
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.task.RoleAssignUserMultiTask.commRoleAssignUserMulti2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", diffContent);
            map.put("oper_id", Long.parseLong(params.get("oper_id").toString()));
            map.put("oper_org_id", Long.parseLong(params.get("oper_org_id").toString()));
            map.put("oper_time", TimeServiceHelper.now());
            map.put("client_type", params.get("client_type"));
            map.put("client_ip", params.get("client_ip"));
            map.put("client_name", params.get("client_name"));
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("RoleAssignUserMultiTask.commRoleAssignUserMulti2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private static void save2DB(Map<String, Object> notLoadedButDelDataParamMap, Map<String, Object> loadedAndModifiedDataParamMap, String pageId, Map<String, Object> params) {
        try (TXHandle txHandle = TX.required();){
            try {
                List deleteParamList;
                List updateParamList;
                List notLoadedButDelDataParamList = (List)notLoadedButDelDataParamMap.get("deleteParamList");
                if (!notLoadedButDelDataParamList.isEmpty()) {
                    String notLoadedButDelDataSql = (String)notLoadedButDelDataParamMap.get("deleteSql");
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)notLoadedButDelDataSql, (List)notLoadedButDelDataParamList);
                } else if (notLoadedButDelDataParamMap.get("deleteSqlBuilder") != null) {
                    DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)((SqlBuilder)notLoadedButDelDataParamMap.get("deleteSqlBuilder")));
                }
                List insertParamList = (List)loadedAndModifiedDataParamMap.get("insertParamList");
                if (!insertParamList.isEmpty()) {
                    String insertSql = (String)loadedAndModifiedDataParamMap.get("insertSql");
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)insertSql, (List)insertParamList);
                }
                if (!(updateParamList = (List)loadedAndModifiedDataParamMap.get("updateParamList")).isEmpty()) {
                    String updateSql = (String)loadedAndModifiedDataParamMap.get("updateSql");
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)updateSql, (List)updateParamList);
                }
                if (!(deleteParamList = (List)loadedAndModifiedDataParamMap.get("deleteParamList")).isEmpty()) {
                    String deleteSql = (String)loadedAndModifiedDataParamMap.get("deleteSql");
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)deleteSql, (List)deleteParamList);
                }
                IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
                IDataModel dataModel = view.getModel();
                DynamicObject role = (DynamicObject)dataModel.getValue(ROLE);
                String roleId = role.getString("id");
                RoleAssignUserMultiTask.saveBatchAddData(roleId, view, params);
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.warn("RoleAssignUserMultiTask.save2DB error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    private static void saveBatchAddData(String roleId, IFormView view, Map<String, Object> params) {
        String jsonMap = view.getPageCache().get(PGCACHE_BATCHADDDATAMAP);
        if (null == jsonMap || StringUtils.isEmpty((String)jsonMap)) {
            return;
        }
        Map batchAddDataMap = (Map)SerializationUtils.fromJsonString((String)jsonMap, Map.class);
        if (null == batchAddDataMap || batchAddDataMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : batchAddDataMap.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (null == value || value.isEmpty()) continue;
            if (key.contains("user$")) {
                RoleAssignUserMultiTask.saveUserLeft(roleId, key, value, params);
                continue;
            }
            RoleAssignUserMultiTask.saveUserRight(roleId, key, value, params);
        }
    }

    private static void saveUserRight(String roleId, String key, List<String> value, Map<String, Object> params) {
        String[] dimSplit = key.split("\\$");
        if (dimSplit.length == 0) {
            return;
        }
        HashSet<String> queryDBDimTypeSet = new HashSet<String>(8);
        HashSet<Long> queryDBDimIdSet = new HashSet<Long>(8);
        HashSet<Long> queryDBUserIdSet = new HashSet<Long>(8);
        HashSet<String> dimUserStrSet = new HashSet<String>(8);
        String dimType = dimSplit[0];
        queryDBDimTypeSet.add(dimType);
        for (int i = 1; i < dimSplit.length; ++i) {
            if (dimUserStrSet.size() > 1000000) {
                Set dbDimUserStrSet = OrgUserHelper.getDimUserStrSet((Set)Sets.newHashSet((Object[])new String[]{roleId}), queryDBDimTypeSet, queryDBDimIdSet, queryDBUserIdSet, (boolean)false);
                Sets.SetView dbNotExistsDimUserSet = Sets.difference(dimUserStrSet, (Set)dbDimUserStrSet);
                RoleAssignUserMultiTask.handleInsertParamListAndSave(roleId, (Sets.SetView<String>)dbNotExistsDimUserSet, params);
                dimUserStrSet.clear();
                queryDBDimIdSet.clear();
                queryDBUserIdSet.clear();
            }
            Long dimId = Long.valueOf(dimSplit[i]);
            queryDBDimIdSet.add(dimId);
            for (String v : value) {
                String userId = v.split("\\$")[1];
                queryDBUserIdSet.add(Long.valueOf(userId));
                dimUserStrSet.add(dimType + "$" + dimId + "$" + userId);
            }
        }
        Set dbDimUserStrSet = OrgUserHelper.getDimUserStrSet((Set)Sets.newHashSet((Object[])new String[]{roleId}), queryDBDimTypeSet, queryDBDimIdSet, queryDBUserIdSet, (boolean)false);
        Sets.SetView dbNotExistsDimUserSet = Sets.difference(dimUserStrSet, (Set)dbDimUserStrSet);
        RoleAssignUserMultiTask.handleInsertParamListAndSave(roleId, (Sets.SetView<String>)dbNotExistsDimUserSet, params);
    }

    private static void saveUserLeft(String roleId, String key, List<String> value, Map<String, Object> params) {
        String[] userSplit = key.split("\\$");
        if (userSplit.length == 0) {
            return;
        }
        HashSet<String> queryDBDimTypeSet = new HashSet<String>(8);
        HashSet<Long> queryDBDimIdSet = new HashSet<Long>(8);
        HashSet<Long> queryDBUserIdSet = new HashSet<Long>(8);
        HashSet<String> dimUserStrSet = new HashSet<String>(8);
        for (int i = 1; i < userSplit.length; ++i) {
            if (dimUserStrSet.size() > 1000000) {
                Set dbDimUserStrSet = OrgUserHelper.getDimUserStrSet((Set)Sets.newHashSet((Object[])new String[]{roleId}), queryDBDimTypeSet, queryDBDimIdSet, queryDBUserIdSet, (boolean)false);
                Sets.SetView dbNotExistsDimUserSet = Sets.difference(dimUserStrSet, (Set)dbDimUserStrSet);
                RoleAssignUserMultiTask.handleInsertParamListAndSave(roleId, (Sets.SetView<String>)dbNotExistsDimUserSet, params);
                dimUserStrSet.clear();
                queryDBDimIdSet.clear();
                queryDBUserIdSet.clear();
            }
            String userId = userSplit[i];
            queryDBUserIdSet.add(Long.valueOf(userId));
            for (String v : value) {
                dimUserStrSet.add(v + "$" + userId);
                String[] split = v.split("\\$");
                queryDBDimTypeSet.add(split[0]);
                queryDBDimIdSet.add(Long.valueOf(split[1]));
            }
        }
        Set dbDimUserStrSet = OrgUserHelper.getDimUserStrSet((Set)Sets.newHashSet((Object[])new String[]{roleId}), queryDBDimTypeSet, queryDBDimIdSet, queryDBUserIdSet, (boolean)false);
        Sets.SetView dbNotExistsDimUserSet = Sets.difference(dimUserStrSet, (Set)dbDimUserStrSet);
        RoleAssignUserMultiTask.handleInsertParamListAndSave(roleId, (Sets.SetView<String>)dbNotExistsDimUserSet, params);
    }

    private static void handleInsertParamListAndSave(String roleId, Sets.SetView<String> dbNotExistsDimUserSet, Map<String, Object> params) {
        int size = dbNotExistsDimUserSet.size();
        if (size == 0) {
            return;
        }
        String[] ids = DB.genStringIds((String)"t_perm_userrole", (int)size);
        Date defalueEndTime = DateUtil.toDate((String)ENDTIMECONST, (String)"yyyy-MM-dd HH:mm:ss");
        int index = 0;
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(size);
        String fromtypedesc = RoleAssignUserMultiTask.getFromtypedesc(params);
        long currUserId = RequestContext.get().getCurrUserId();
        Date curTime = new Date();
        for (String dimUser : dbNotExistsDimUserSet) {
            String[] split = dimUser.split("\\$");
            long dimId = Long.parseLong(split[1]);
            long userId = Long.parseLong(split[2]);
            insertParamList.add(new Object[]{ids[index++], dimId, userId, roleId, Character.valueOf('2'), split[0], defalueEndTime, fromtypedesc, currUserId, curTime, currUserId, curTime});
        }
        if (null != insertParamList && !insertParamList.isEmpty()) {
            String batchAddInsertSql = "insert into t_perm_userrole(fid, forgid, fuserid, froleid,fsource, fdimtype,fendtime, ffromtypedesc, fcreaterfield, fcreatedatefield, fmodifierfield, fmodifydatefield) values (?,?,?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.permission, (String)batchAddInsertSql, insertParamList);
        }
    }

    private static String getFromtypedesc(Map<String, Object> params) {
        String formNum = (String)params.get("formNum");
        return kd.bos.permission.log.helper.ConstantsHelper.getCommonRoleAssignorguserBusifrom((String)formNum);
    }

    private Map<String, Object> getLoadedAndModifiedDataParam(String roleId, IFormView view, String pageId, Map<String, Object> params) {
        HashSet<String> dimTypeForlogSet = new HashSet<String>(8);
        HashSet<Long> dimIdForlogSet = new HashSet<Long>(8);
        HashSet<Long> userIdForlogSet = new HashSet<Long>(8);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("dimTypeForlogSet", dimTypeForlogSet);
        map.put("dimIdForlogSet", dimIdForlogSet);
        map.put("userIdForlogSet", userIdForlogSet);
        StringBuilder insertSql = new StringBuilder("insert into t_perm_userrole(fid, forgid, fuserid, froleid, fisincludesuborg, fsource, fdimtype, fstarttime, fendtime, ffromtypedesc, fcreaterfield, fcreatedatefield, fmodifierfield, fmodifydatefield) ").append("values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        map.put("insertSql", insertSql.toString());
        map.put("insertParamList", new ArrayList(1));
        StringBuilder updateSql = new StringBuilder("update t_perm_userrole set fisincludesuborg = ? , fstarttime = ? , fendtime = ? , ffromtypedesc = ?, fmodifierfield = ?, fmodifydatefield = ? ").append(" where froleid = ? and forgid = ? and fdimtype = ? and fuserid = ? ");
        map.put("updateSql", updateSql.toString());
        map.put("updateParamList", new ArrayList(1));
        StringBuilder deleteSql = new StringBuilder("delete from t_perm_userrole where froleid = ? and forgid = ? and fdimtype = ? and fuserid = ? ");
        map.put("deleteSql", deleteSql.toString());
        map.put("deleteParamList", new ArrayList(1));
        Map<String, String> loadedAndModifiedDataMap = this.getLoadedAndModifiedDataMap(view);
        Collection<String> values = loadedAndModifiedDataMap.values();
        if (!values.isEmpty()) {
            ArrayList dimUserEdits = new ArrayList(10);
            for (String value : values) {
                if (StringUtils.isEmpty((String)value)) continue;
                dimUserEdits.addAll(SerializationUtils.fromJsonStringToList((String)value, DimUserEdit.class));
            }
            int size = dimUserEdits.size();
            String[] ids = DB.genStringIds((String)"t_perm_userrole", (int)size);
            int index = 0;
            ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(size);
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(size);
            ArrayList<Object[]> deleteParamList = new ArrayList<Object[]>(size);
            String fromtypedesc = RoleAssignUserMultiTask.getFromtypedesc(params);
            long currUserId = RequestContext.get().getCurrUserId();
            Date curTime = new Date();
            for (DimUserEdit dimUserEdit : dimUserEdits) {
                DimUserEdit.DataStatus dataStatus = dimUserEdit.getDataStatus();
                Long dimId = dimUserEdit.getDimId();
                Long userId = dimUserEdit.getUserId();
                Boolean includeSub = dimUserEdit.getIncludeSub();
                String dimType = dimUserEdit.getDimType();
                Date startTime = dimUserEdit.getStartTime();
                Date endTime = dimUserEdit.getEndTime();
                if (DimUserEdit.DataStatus.INSERT.equals((Object)dataStatus)) {
                    insertParamList.add(new Object[]{ids[index++], dimId, userId, roleId, includeSub, Character.valueOf('2'), dimType, startTime, endTime, fromtypedesc, currUserId, curTime, currUserId, curTime});
                } else if (DimUserEdit.DataStatus.UPDATE.equals((Object)dataStatus)) {
                    updateParamList.add(new Object[]{includeSub, startTime, endTime, fromtypedesc, currUserId, curTime, roleId, dimId, dimType, userId});
                } else if (DimUserEdit.DataStatus.DELETE.equals((Object)dataStatus)) {
                    deleteParamList.add(new Object[]{roleId, dimId, dimType, userId});
                }
                dimTypeForlogSet.add(dimType);
                dimIdForlogSet.add(dimId);
                userIdForlogSet.add(userId);
            }
            map.put("insertParamList", insertParamList);
            map.put("updateParamList", updateParamList);
            map.put("deleteParamList", deleteParamList);
        }
        return map;
    }

    private Map<String, String> getLoadedAndModifiedDataMap(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String json = pageCache.get(PGCACHE_LOADEDANDMODIFIEDDATAMAP);
        if (StringUtils.isEmpty((String)json)) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            pageCache.put(PGCACHE_LOADEDANDMODIFIEDDATAMAP, SerializationUtils.toJsonString(map));
            return map;
        }
        return (Map)SerializationUtils.fromJsonString((String)json, Map.class);
    }

    private Map<String, Object> getNotLoadedButDelDataParam(String roleId, IFormView view, String pageId) {
        HashSet<String> dimTypeForlogSet = new HashSet<String>(8);
        HashSet<Long> dimIdForlogSet = new HashSet<Long>(8);
        HashSet<Long> userIdForlogSet = new HashSet<Long>(8);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("deleteSql", "");
        map.put("deleteParamList", new ArrayList(1));
        map.put("dimTypeForlogSet", dimTypeForlogSet);
        map.put("dimIdForlogSet", dimIdForlogSet);
        map.put("userIdForlogSet", userIdForlogSet);
        String delDimIds = view.getPageCache().get(PGCACHE_NOTLOADEDBUTDEL_LEFTIDS);
        if (StringUtils.isEmpty((String)delDimIds) || Objects.equals("[]", delDimIds)) {
            return map;
        }
        List delLeftIdsList = (List)SerializationUtils.fromJsonString((String)delDimIds, List.class);
        ArrayList<Object[]> deleteParamList = new ArrayList<Object[]>(delLeftIdsList.size());
        HashSet<String> delDimInfoStrSet = new HashSet<String>(delLeftIdsList.size());
        for (String delLeftIds : delLeftIdsList) {
            String[] split = delLeftIds.split("\\$");
            if ("user".equals(split[0])) {
                userIdForlogSet.add(Long.valueOf(split[1]));
                continue;
            }
            String dimType = split[0];
            Long dimId = Long.valueOf(split[1]);
            dimTypeForlogSet.add(dimType);
            dimIdForlogSet.add(dimId);
            delDimInfoStrSet.add(dimType + dimId);
        }
        if (!CollectionUtils.isEmpty(delDimInfoStrSet)) {
            Set delUserRoleIds;
            SqlBuilder sb = new SqlBuilder();
            sb.append("select CONCAT(fdimtype,forgid) as res, fid ", new Object[0]);
            sb.append("from t_perm_userrole ", new Object[0]);
            sb.append(" where froleid = ?", new Object[]{roleId});
            if (!CollectionUtils.isEmpty(dimTypeForlogSet)) {
                sb.appendIn(" and fdimtype ", dimTypeForlogSet.toArray());
            }
            if (!CollectionUtils.isEmpty(dimIdForlogSet)) {
                sb.appendIn(" and forgid ", dimIdForlogSet.toArray());
            }
            if (!(delUserRoleIds = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sb, rs -> {
                HashSet<String> result = new HashSet<String>(10);
                while (rs.next()) {
                    String res = rs.getString("res");
                    if (!delDimInfoStrSet.contains(res)) continue;
                    result.add(rs.getString("fid"));
                }
                return result;
            })).isEmpty()) {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("delete from t_perm_userrole ", new Object[0]);
                sqlBuilder.appendIn(" where fid ", delUserRoleIds.toArray());
                map.put("deleteSqlBuilder", sqlBuilder);
            }
        }
        if (null != userIdForlogSet && !userIdForlogSet.isEmpty()) {
            List userIdList = userIdForlogSet.stream().map(String::valueOf).collect(Collectors.toList());
            String userIdStr = String.join((CharSequence)",", userIdList);
            map.put("deleteSql", "delete from t_perm_userrole where froleid = ? and fuserid in (" + userIdStr + ")");
            deleteParamList.add(new Object[]{roleId});
            map.put("deleteParamList", deleteParamList);
            return map;
        }
        return map;
    }

    private void cycle2GetDataSaveProgress(int progress, Future<Object> saveDataFuture, int target) throws ExecutionException {
        Object o = null;
        while (progress < target) {
            try {
                o = saveDataFuture.get(500L, TimeUnit.MILLISECONDS);
                if (1 != (Integer)o) continue;
                progress = target;
            }
            catch (InterruptedException e) {
                progress = this.dataSavingProgress(progress, target);
            }
            catch (TimeoutException e) {
                progress = this.dataSavingProgress(progress, target);
            }
        }
        if (o == null || 1 != (Integer)o) {
            try {
                saveDataFuture.get();
            }
            catch (InterruptedException e) {
                log.warn("RoleAssignUserMultiTask_cycle2GetDataSaveProgress saveDataFuture.get error.", (Throwable)e);
                this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:%1$s", (String)"RoleAssignUserMultiTask_2", (String)systemTypeFormplugin, (Object[])new Object[0]), e.getMessage()), null);
            }
        }
    }

    private int dataSavingProgress(int progress, int target) {
        String desc = ResManager.loadKDString((String)"\u6570\u636e\u5b58\u50a8\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"RoleAssignUserMultiTask_9", (String)systemTypeFormplugin, (Object[])new Object[0]);
        if (progress < target - 1) {
            ++progress;
        }
        this.feedbackProgress(progress, desc, null);
        return progress;
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }

    static /* synthetic */ void access$000(Map x0, Map x1, String x2, Map x3) {
        RoleAssignUserMultiTask.save2DB(x0, x1, x2, x3);
    }

    static /* synthetic */ void access$100(RoleAssignUserMultiTask x0, String x1, Map x2, Map x3) throws Exception {
        x0.busiAfterSave(x1, x2, x3);
    }
}

