/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.model.UgRoleDim;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.formplugin.RoleAssignUserPlugin;
import kd.bos.permission.formplugin.RoleAssignUsrGrpPlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.permission.service.UserGroupService;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class RoleAssignUsrGrpTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(RoleAssignUsrGrpTask.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"RoleAssignUsrGrpTask", (int)1);

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"RoleAssignUsrGrpTask_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        try {
            String pageId = (String)params.get("pageId");
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            IDataModel dataModel = view.getModel();
            DynamicObject role = (DynamicObject)dataModel.getValue("role_number");
            if (null == role) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89d2\u8272", (String)"RoleAssignUsrGrpTask_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), null);
                return;
            }
            String roleId = (String)role.getPkValue();
            Long ugrCount = UserGroupHelper.getCountByRoleId((String)roleId);
            desc = ResManager.loadKDString((String)"\u6d89\u53ca\u6570\u636e\u51c6\u5907\u5b8c\u6bd5\uff0c\u5f00\u59cb\u83b7\u53d6\u754c\u9762\u6570\u636e\u3002", (String)"RoleAssignUsrGrpTask_2", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 5;
            this.feedbackProgress(progress, desc, null);
            boolean dimObjInLeft = (Boolean)params.get("dimObjInLeft");
            if (dimObjInLeft) {
                this.saveDimUsrGrp(ugrCount, dataModel, params);
            }
            desc = ResManager.loadKDString((String)"\u64cd\u4f5c\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u3002", (String)"RoleAssignUsrGrpTask_3", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 98;
            this.feedbackProgress(progress, desc, null);
        }
        catch (Exception e) {
            log.warn("RoleAssignUsrGrpTask.execute error", (Throwable)e);
            this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:%1$s", (String)"RoleAssignUsrGrpTask_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), e.getMessage()), null);
        }
    }

    private void saveDimUsrGrp(Long ugrCount, IDataModel dataModel, Map<String, Object> params) {
        String systemTypeFormplugin = "bos-permission-formplugin";
        try {
            String ctrlTypeName = (String)params.get("ctrlTypeName");
            DynamicObjectCollection dimObjs = dataModel.getEntryEntity("dimlist");
            int dimObjsSize = dimObjs.size();
            if (0 == dimObjsSize && 0L == ugrCount) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"RoleAssignUsrGrpTask_5", (String)"bos-permission-formplugin", (Object[])new Object[]{ctrlTypeName}), null);
                return;
            }
            String desc = ResManager.loadKDString((String)"\u754c\u9762\u6570\u636e\u83b7\u53d6\u5b8c\u6bd5\uff0c\u51c6\u5907\u8fdb\u884c\u89e3\u6790\u3002", (String)"RoleAssignUsrGrpTask_6", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 10;
            this.feedbackProgress(progress, desc, null);
            DynamicObject role = (DynamicObject)dataModel.getValue("role_number");
            String roleId = (String)role.getPkValue();
            HashSet<Long> lisenceUserIds = new HashSet<Long>(16);
            String pageId = (String)params.get("pageId");
            Set mayChangedDimIdSet = RoleAssignUsrGrpPlugin.getMayChangedDimId((String)pageId);
            if (CollectionUtils.isEmpty((Collection)mayChangedDimIdSet)) {
                this.busiAfterSave(roleId, lisenceUserIds, null, params);
                return;
            }
            mayChangedDimIdSet.remove("null");
            Set mayChangedDimIdSetL = mayChangedDimIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            HashSet<String> checkDuplicRoleDimUsrGrp = new HashSet<String>(dimObjsSize);
            String curCtrlTypeEntNum = (String)params.get("curCtrlTypeEntNum");
            String curCtrlType = (String)params.get("curCtrlType");
            String dimFieldKey = (String)params.get("dimFieldKey");
            boolean isSingleOrg = PermFormCommonUtil.isSingleOrg((String)curCtrlType);
            boolean checkOrgDim = IsoDimHelper.checkOrgDim((String)curCtrlType);
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(dimObjsSize);
            DynamicObject dimObj = null;
            DynamicObject usrGrp = null;
            Object dimObjId = null;
            String dimObjName = null;
            Long usrGrpId = null;
            String usrGrpName = null;
            Boolean includeSubOrg = Boolean.FALSE;
            for (int i = 0; i < dimObjsSize; ++i) {
                dimObj = (DynamicObject)dimObjs.get(i);
                dimObjId = dimObj.get(dimFieldKey + "_id");
                if (!mayChangedDimIdSetL.contains(dimObjId)) continue;
                dimObjName = checkOrgDim ? dimObj.getString(dimFieldKey + ".name") : dimObj.getString("dim_name");
                DynamicObjectCollection usrGrpCollection = dimObj.getDynamicObjectCollection("usrgrplist");
                int usrGrpColSize = usrGrpCollection.size();
                if (0 == usrGrpColSize && !isSingleOrg) {
                    this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u6dfb\u52a0\u7528\u6237\u7ec4\u3002", (String)"RoleAssignUsrGrpTask_7", (String)systemTypeFormplugin, (Object[])new Object[0]), dimObjName), null);
                    return;
                }
                for (int j = 0; j < usrGrpColSize; ++j) {
                    DynamicObject row = (DynamicObject)usrGrpCollection.get(j);
                    usrGrp = (DynamicObject)row.get("usrgrp");
                    if (null == usrGrp) continue;
                    usrGrpId = usrGrp.getLong("id");
                    usrGrpName = usrGrp.getString("name");
                    includeSubOrg = row.getBoolean("includesub");
                    if (!checkDuplicRoleDimUsrGrp.add(roleId + curCtrlTypeEntNum + dimObjId + usrGrpId)) {
                        String roleName = role.getString("name");
                        this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u89d2\u8272-%1$s-\u7528\u6237\u7ec4\uff0c\u89d2\u8272\uff1a%2$s\uff0c%3$s\uff1a%4$s\uff0c\u7528\u6237\u7ec4\uff1a%5$s\u3002", (String)"RoleAssignUsrGrpTask_8", (String)systemTypeFormplugin, (Object[])new Object[0]), ctrlTypeName, roleName, ctrlTypeName, dimObjName, usrGrpName), null);
                        return;
                    }
                    String fisincludesuborg = includeSubOrg == false ? "0" : "1";
                    DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_usrgrprole");
                    saveObj.set("dimtype", (Object)curCtrlTypeEntNum);
                    saveObj.set("dimid", dimObjId);
                    saveObj.set("includesub", (Object)fisincludesuborg);
                    saveObj.set("usrgrpid", (Object)usrGrpId);
                    saveObj.set("role", (Object)roleId);
                    saveList.add(saveObj);
                    lisenceUserIds.addAll(UserGroupService.getUsersIdByUsrGrpId((Long)usrGrpId));
                    desc = ResManager.loadKDString((String)"\u754c\u9762\u4fe1\u606f\u89e3\u6790\u4e2d\u3002", (String)"RoleAssignUsrGrpTask_9", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                    progress = 10 + 10 / dimObjsSize * i;
                    this.feedbackProgress(progress, desc, null);
                }
            }
            desc = ResManager.loadKDString((String)"\u754c\u9762\u4fe1\u606f\u89e3\u6790\u5b8c\u6bd5\uff0c\u8fdb\u884c\u6570\u636e\u5b58\u50a8\u3002", (String)"RoleAssignUsrGrpTask_10", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 20;
            this.feedbackProgress(progress, desc, null);
            if (this.isStop()) {
                this.stop();
            }
            Future future = pool.submit((Callable)new /* Unavailable Anonymous Inner Class!! */);
            Object o = null;
            int target = 98;
            while (progress < target) {
                try {
                    o = future.get(500L, TimeUnit.MILLISECONDS);
                    if (1 != (Integer)o) continue;
                    progress = target;
                }
                catch (InterruptedException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
                catch (TimeoutException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
            }
        }
        catch (Exception e) {
            log.warn("RoleAssignUsrGrpTask.saveDimUsrGrp error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private int dataSavingProgress(int progress, int target) {
        String desc = ResManager.loadKDString((String)"\u6570\u636e\u5b58\u50a8\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"RoleAssignUsrGrpTask_11", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        if (progress < target - 1) {
            ++progress;
        }
        this.feedbackProgress(progress, desc, null);
        return progress;
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }

    private void busiAfterSave(String roleId, Set<Long> lisenceUserIds, Map<String, Object> diffMap, Map<String, Object> params) throws Exception {
        HashSet changedUsrGrpIdSet = new HashSet(1);
        List delList = new LinkedList();
        List addList = new LinkedList();
        if (diffMap != null && !diffMap.isEmpty()) {
            delList = (List)diffMap.get("del");
            addList = (List)diffMap.get("add");
            Set delUsrGrpIdSet = delList.stream().map(UgRoleDim::getUsrGrpId).collect(Collectors.toSet());
            changedUsrGrpIdSet.addAll(delUsrGrpIdSet);
            Set addUsrGrpIdSet = addList.stream().map(UgRoleDim::getUsrGrpId).collect(Collectors.toSet());
            changedUsrGrpIdSet.addAll(addUsrGrpIdSet);
        }
        if (!CollectionUtils.isEmpty(changedUsrGrpIdSet)) {
            Set changedUserIdSet = UserGroupHelper.getUserListBySet(changedUsrGrpIdSet);
            UserHasPermOrgCache.clearUserLoginOrgs((Collection)changedUserIdSet);
            LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)roleId, (String)RequestContext.get().getLang().toString());
            List newDRAppEntityList = newDataRule.getNewDRAppEntityList();
            PermCommonUtil.cancelShowForm(new ArrayList(changedUserIdSet), (List)newDRAppEntityList, (boolean)false);
        }
        CacheMrg.clearAllCache();
        CacheMrg.clearHasEnableOldAdmin();
        HashSet<String> roleIds = new HashSet<String>();
        roleIds.add(roleId);
        Map appEntity = PermissionServiceHelper.getAppEntityByRoleSet(roleIds);
        LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList<Long>(lisenceUserIds), (Map)appEntity);
        String pageId = (String)params.get("pageId");
        boolean dimObjInLeft = (Boolean)params.get("dimObjInLeft");
        RoleAssignUserPlugin.clearMayChangedDimOrUserIdSetPageCache((String)pageId, (boolean)dimObjInLeft);
        if (!(!PermCommonUtil.isEnablePermLog() || diffMap == null || diffMap.isEmpty() || CollectionUtils.isEmpty(delList) && CollectionUtils.isEmpty(addList))) {
            String opbtn = ConstantsHelper.getSave();
            diffMap.put("langStr", RequestContext.get().getLang().name());
            RoleAssignUsrGrpTask.commRoleAssignDimUsrGrp2PermLog("bar_save", opbtn, StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffMap)), params);
        }
        this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RoleAssignUsrGrpTask_12", (String)"bos-permission-formplugin", (Object[])new Object[0]), 3000);
    }

    private void saveDimUsrGrp2DB(String roleId, Set<String> mayChangedDimIdSet, List<DynamicObject> saveList, String curCtrlTypeEntNum) {
        if (CollectionUtils.isEmpty(saveList) && CollectionUtils.isEmpty(mayChangedDimIdSet)) {
            return;
        }
        try (TXHandle txHandle = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(mayChangedDimIdSet)) {
                    StringBuilder delSb = new StringBuilder();
                    delSb.append("delete from t_perm_usrgrprole where froleid = '").append(roleId).append('\'');
                    delSb.append(" and fdimtype ='").append(curCtrlTypeEntNum).append("' and fincludesub in ('0','1')");
                    String mayChangedDimIdStr = String.join((CharSequence)",", mayChangedDimIdSet);
                    delSb.append(" and fdimid in (").append(mayChangedDimIdStr).append(")");
                    DB.execute((DBRoute)DBRoute.base, (String)delSb.toString());
                }
                if (!CollectionUtils.isEmpty(saveList)) {
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.warn("RoleAssignUsrGrpTask.saveDimUsrGrp2DB error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    private void saveUserDim2DB(String roleId, Set<String> mayChangedUserIdSet, List<DynamicObject> saveList, String curCtrlTypeEntNum) {
        if (CollectionUtils.isEmpty(saveList) && CollectionUtils.isEmpty(mayChangedUserIdSet)) {
            return;
        }
        String mayChangedUserIdStr = String.join((CharSequence)",", mayChangedUserIdSet);
        try (TXHandle txHandle = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(mayChangedUserIdSet)) {
                    StringBuilder delSb = new StringBuilder();
                    delSb.append("delete from t_perm_userrole where froleid = '").append(roleId).append('\'');
                    delSb.append(" and fdimtype ='").append(curCtrlTypeEntNum).append("' and fisincludesuborg in ('0','1')");
                    delSb.append(" and fuserid in (").append(mayChangedUserIdStr).append(")");
                    DB.execute((DBRoute)DBRoute.base, (String)delSb.toString());
                }
                if (!CollectionUtils.isEmpty(saveList)) {
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.warn("RoleAssignUsrGrpTask.saveUserDim2DB error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    private static void commRoleAssignDimUsrGrp2PermLog(String op, String opbtn, String diffContent, Map<String, Object> params) {
        String opItemNumber = (String)params.get("roleNumber");
        try {
            String opItemId = (String)params.get("roleId");
            String opItemName = (String)params.get("roleName");
            String appId = (String)params.get("appId");
            String formNum = (String)params.get("formNum");
            String cloudId = AppMetadataCache.getAppInfo((String)appId).getCloudId();
            boolean dimObjInLeft = (Boolean)params.get("dimObjInLeft");
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", PermLogUtil.getPermLogFnumber());
            map.put("busi_from", kd.bos.permission.log.helper.ConstantsHelper.getCommonRoleAssignorguserBusifrom((String)formNum));
            PermLogBusiType permLogBusiType = dimObjInLeft ? PermLogService.getPermLogBusiType((String)"common_role_assigndimusrgrp") : PermLogService.getPermLogBusiType((String)"common_role_assignusrgrpdim");
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", BizAppServiceHelp.getAppIdByFormNum((String)formNum));
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.task.RoleAssignUsrGrpTask.commRoleAssignDimUsrGrp2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", diffContent);
            map.put("oper_id", Long.parseLong(params.get("oper_id").toString()));
            map.put("oper_org_id", Long.parseLong(params.get("oper_org_id").toString()));
            map.put("oper_time", TimeServiceHelper.now());
            map.put("client_type", params.get("client_type"));
            map.put("client_ip", params.get("client_ip"));
            map.put("client_name", params.get("client_name"));
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("RoleAssignUsrGrpTask.commRoleAssignDimUsrGrp2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    static /* synthetic */ void access$000(RoleAssignUsrGrpTask x0, String x1, Set x2, List x3, String x4) {
        x0.saveDimUsrGrp2DB(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$100(RoleAssignUsrGrpTask x0, String x1, Set x2, Map x3, Map x4) throws Exception {
        x0.busiAfterSave(x1, x2, x3, x4);
    }
}

