/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.DirectDisFunHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.formplugin.plugin.UserAssignDisFunPlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.formplugin.util.PermPageCacheUtil;
import kd.bos.permission.log.model.LogDimDis;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class UserAssignDisFunTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(UserAssignDisFunTask.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"UserAssignDisFunTask", (int)2);
    private static final String DISFUN_MAY_CHANGED_DIMID = "disfunMayChangedDimId";

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"UserAssignDisFunTask_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        try {
            String pageId = (String)params.get("pageId");
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            IDataModel dataModel = view.getModel();
            this.saveDisablePerm(params, dataModel, view);
            desc = ResManager.loadKDString((String)"\u64cd\u4f5c\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u3002", (String)"UserAssignDisFunTask_1", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 98;
            this.feedbackProgress(progress, desc, null);
        }
        catch (Exception e) {
            logger.warn("UserAssignDisFunTask.execute error", (Throwable)e);
            this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:%1$s", (String)"UserAssignDisFunTask_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), e.getMessage()), null);
        }
    }

    private void saveDisablePerm(Map<String, Object> params, IDataModel dataModel, IFormView view) {
        String systemTypeFormplugin = "bos-permission-formplugin";
        try {
            DynamicObject u = (DynamicObject)dataModel.getValue("user");
            Long uId = (Long)u.getPkValue();
            if (null == uId || uId == 0L) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25:\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728", (String)"UserAssignDisFunTask_3", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return;
            }
            Long adminId = RequestContext.get().getCurrUserId();
            if (adminId.equals(uId)) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserAssignDisFunTask_4", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return;
            }
            List robotIds = PermCommonUtil.getRobotIds();
            DynamicObjectCollection dimObjs = dataModel.getEntryEntity("list_org");
            int dimObjsSize = dimObjs.size();
            if (robotIds.contains(uId) && dimObjsSize > 0) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u76f4\u63a5\u7981\u6743\u3002", (String)"UserAssignDisFunTask_5", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return;
            }
            String curCtrlTypeEntityNum = (String)params.get("curCtrlTypeEntityNum");
            String curCtrlTypeName = (String)params.get("curCtrlTypeName");
            Long urCount = DirectDisFunHelper.getCountByUserId((Long)uId, (String)curCtrlTypeEntityNum);
            if (0 == dimObjsSize && 0L == urCount) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"UserAssignDisFunTask_6", (String)"bos-permission-formplugin", (Object[])new Object[]{curCtrlTypeName}), null);
                return;
            }
            String desc = ResManager.loadKDString((String)"\u76f4\u63a5\u7981\u6743\u754c\u9762\u6570\u636e\u83b7\u53d6\u5b8c\u6bd5\uff0c\u51c6\u5907\u8fdb\u884c\u89e3\u6790\u3002", (String)"UserAssignDisFunTask_7", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 10;
            this.feedbackProgress(progress, desc, null);
            String pageId = (String)params.get("pageId");
            Set disfunMayChangedDimIdSet_ = UserAssignDisFunPlugin.getMayChangedDimId((String)pageId);
            if (CollectionUtils.isEmpty((Collection)disfunMayChangedDimIdSet_)) {
                this.busiAfterSave(null, null, params, u);
                return;
            }
            disfunMayChangedDimIdSet_.remove("null");
            Set<Long> disfunMayChangedDimIdSet = disfunMayChangedDimIdSet_.stream().map(Long::valueOf).collect(Collectors.toSet());
            PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
            String appNum = permPageCacheUtil.get("FormShowParam_appNum");
            ArrayList<Future> busiFutureList = new ArrayList<Future>(dimObjsSize);
            Map<String, String> nodeIdAndNameMap = this.getNodeIdAndNameMap(permPageCacheUtil);
            TreeView allFuncPermTreeView = (TreeView)view.getControl("tree_allperm");
            TreeView disablePermTreeView = (TreeView)view.getControl("tree_disfunperm");
            boolean isSingleOrg = PermFormCommonUtil.isSingleOrg((String)curCtrlTypeEntityNum);
            DynamicObject dimObj = null;
            String dimObjName = "";
            String dimObjFieldKey = "";
            boolean isOrgDimType = (Boolean)params.get("isOrgDimType");
            dimObjFieldKey = isOrgDimType ? "org_number" : "dim_num";
            for (int i = 0; i < dimObjsSize; ++i) {
                dimObj = (DynamicObject)dimObjs.get(i);
                Long curDimObjId = Long.parseLong(dimObj.getString("dim_identity"));
                if (!disfunMayChangedDimIdSet.contains(curDimObjId)) continue;
                DynamicObject dimFieldObj = dimObj.getDynamicObject(dimObjFieldKey);
                dimObjName = dimFieldObj == null ? "null" : dimFieldObj.getString("name");
                Object includeSubOrg = dimObj.get("org_include_sub");
                busiFutureList.add(pool.submit(this.wrapParamCallable(uId, appNum, nodeIdAndNameMap, curDimObjId, includeSubOrg, curCtrlTypeEntityNum, allFuncPermTreeView, disablePermTreeView, permPageCacheUtil, disfunMayChangedDimIdSet, dimObjName, i, isSingleOrg)));
                desc = ResManager.loadKDString((String)"\u7981\u7528\u6743\u9650\u754c\u9762\u4fe1\u606f\u89e3\u6790\u4e2d\u3002", (String)"UserAssignDisFunTask_8", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                this.feedbackProgress(progress += 10 / dimObjsSize * i, desc, null);
            }
            desc = ResManager.loadKDString((String)"\u7981\u7528\u6743\u9650\u754c\u9762\u4fe1\u606f\u89e3\u6790\u5b8c\u6bd5\uff0c\u8fdb\u884c\u6570\u636e\u5b58\u50a8\u3002", (String)"UserAssignDisFunTask_9", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 20;
            this.feedbackProgress(progress, desc, null);
            ArrayList forSaveObjs = new ArrayList(dimObjsSize);
            for (Future busiFuture : busiFutureList) {
                Map futureMap = (Map)busiFuture.get();
                List forSaveObjs_future = (List)futureMap.get("forSaveObjs");
                String busiCheckMsg = (String)futureMap.get("busiCheckMsg");
                if (StringUtils.isNotEmpty((String)busiCheckMsg)) {
                    this.wrapFeedBack(false, "errorNotice", busiCheckMsg, null);
                    return;
                }
                forSaveObjs.addAll(forSaveObjs_future);
            }
            if (this.isStop()) {
                this.stop();
            }
            Future future = pool.submit((Callable)new /* Unavailable Anonymous Inner Class!! */);
            Object o = null;
            int target = 98;
            while (progress < target) {
                try {
                    o = future.get(500L, TimeUnit.MILLISECONDS);
                    if (1 != (Integer)o) continue;
                    progress = target;
                }
                catch (InterruptedException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
                catch (TimeoutException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
            }
        }
        catch (Exception e) {
            logger.warn("UserAssignDisFunTask.saveDisablePerm error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private void busiAfterSave(List<LogDimDis> preList, List<LogDimDis> afterList, Map<String, Object> params, DynamicObject u) {
        String pageId = (String)params.get("pageId");
        this.clearDisFunMayChangedDimId(pageId);
        String save_ok = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserAssignDisFunTask_10", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(preList) && CollectionUtils.isEmpty(afterList)) {
            this.wrapFeedBack(true, "successNotice", save_ok, 3000);
            return;
        }
        Map diffDimDisMap = LogDimDis.logCompareMutiThread(preList, afterList);
        boolean enablePermLog = PermCommonUtil.isEnablePermLog();
        if (!enablePermLog || CollectionUtils.isEmpty((Map)diffDimDisMap)) {
            this.wrapFeedBack(true, "successNotice", save_ok, 3000);
            return;
        }
        List add = (List)diffDimDisMap.get("add");
        List del = (List)diffDimDisMap.get("del");
        if (CollectionUtils.isEmpty((Collection)add) && CollectionUtils.isEmpty((Collection)del)) {
            this.wrapFeedBack(true, "successNotice", save_ok, 3000);
            return;
        }
        Long uId = (Long)u.getPkValue();
        this.reloadCache(uId);
        PermCommonUtil.cancelShowForm(Collections.singletonList(uId), null, (boolean)false);
        HashMap<String, Object> logMap = new HashMap<String, Object>(2);
        logMap.put("langStr", RequestContext.get().getLang().name());
        logMap.put("diffDimDisMap", CollectionUtils.isEmpty((Map)diffDimDisMap) ? new HashMap(1) : diffDimDisMap);
        logMap.put("influenceUsers", Collections.singletonList(String.valueOf(uId)));
        String userName = u.getString("name");
        String userNumber = u.getString("number");
        String opbtn = ConstantsHelper.getSave();
        this.save2PermLog("baritem_save", opbtn, String.valueOf(uId), userNumber, userName, logMap, params);
        this.wrapFeedBack(true, "successNotice", save_ok, 3000);
    }

    private void save2PermLog(String op, String opbtn, String opItemId, String opItemNumber, String opItemName, Map<String, Object> diffLogMap, Map<String, Object> params) {
        try {
            String appId = (String)params.get("appId");
            String cloudId = AppMetadataCache.getAppInfo((String)appId).getCloudId();
            String formNum = (String)params.get("formNum");
            HashMap<String, String> map = new HashMap<String, String>(20);
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"userdirect_disfun_save");
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", BizAppServiceHelp.getAppIdByFormNum((String)formNum));
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.task.UserAssignDisFunTask.save2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffLogMap)));
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("UserAssignDisFunTask.save2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private Callable<Map<String, Object>> wrapParamCallable(Long userId, String appNum, Map<String, String> nodeIdAndNameMap, Long curDimObjId, Object includeSubOrg, String curCtrlTypeEntityNum, TreeView allFuncPermTreeView, TreeView disablePermTreeView, PermPageCacheUtil permPageCacheUtil, Set<Long> disfunMayChangedDimIdSet, String dimObjName, int i, boolean isSingleOrg) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void saveDisFun2DB(Set<Long> disfunMayChangedDimIdSet, Long userId, String curCtrlTypeEntityNum, List<DynamicObject> forSaveObjs) {
        try (TXHandle h = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(disfunMayChangedDimIdSet)) {
                    List disfunMayChangedDimIdList = disfunMayChangedDimIdSet.stream().map(String::valueOf).collect(Collectors.toList());
                    DB.execute((DBRoute)DBRoute.permission, (String)("delete from t_perm_disfunperm where fuserid = ? and forgid in(" + String.join((CharSequence)",", disfunMayChangedDimIdList) + ") and fdimtype = ? "), (Object[])new Object[]{userId, curCtrlTypeEntityNum});
                }
                if (!CollectionUtils.isEmpty(forSaveObjs)) {
                    int size = forSaveObjs.size();
                    ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
                    String[] ids = DB.genStringIds((String)"t_perm_disfunperm", (int)size);
                    int index = 0;
                    for (DynamicObject objs : forSaveObjs) {
                        paramList.add(new Object[]{objs.get("bizapp"), objs.get("permitem"), objs.get("entitytype"), objs.get("org"), objs.get("user"), objs.get("includesuborg"), objs.get("dimtype"), objs.get("source"), ids[index++]});
                    }
                    String sql = "insert into t_perm_disfunperm(fbizroleid,fbizappid,fpermitemid,fentitytypeid,forgid,fuserid,fisincludesuborg,fdimtype,fsource,ffrom,fentryid,fid) values (0,?,?,?,?,?,?,?,?,0,' ',?)";
                    SqlUtil.syncInsert(paramList, (String)sql, null, (DBRoute)DBRoute.basedata, (boolean)true);
                }
            }
            catch (Exception e) {
                logger.warn("UserAssignDisFunTask.saveDisFun2DB tx error", (Throwable)e);
                h.markRollback();
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    protected void reloadCache(Long userId) {
        CacheMrg.clearAllCache();
    }

    private final Map<String, String> getNodeIdAndNameMap(PermPageCacheUtil permPageCacheUtil) {
        HashMap<String, String> map = null;
        String nodeIdAndNameMap = permPageCacheUtil.get("nodeIdAndNameMap");
        if (StringUtils.isEmpty((String)nodeIdAndNameMap)) {
            map = new HashMap();
            permPageCacheUtil.put("nodeIdAndNameMap", SerializationUtils.toJsonString(map));
        } else {
            map = (Map)SerializationUtils.fromJsonString((String)nodeIdAndNameMap, Map.class);
        }
        return map;
    }

    private void clearDisFunMayChangedDimId(String pageId) {
        String type = CacheMrg.getType4UserDirectDisFunPerm();
        String key = "disfunMayChangedDimId_" + pageId;
        CacheMrg.clearCache((String)type, (String)key);
    }

    private int dataSavingProgress(int progress, int target) {
        String desc = ResManager.loadKDString((String)"\u6570\u636e\u5b58\u50a8\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"UserAssignDisFunTask_12", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        if (progress < target - 1) {
            ++progress;
        }
        this.feedbackProgress(progress, desc, null);
        return progress;
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }

    static /* synthetic */ void access$000(UserAssignDisFunTask x0, Set x1, Long x2, String x3, List x4) {
        x0.saveDisFun2DB(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$100(UserAssignDisFunTask x0, List x1, List x2, Map x3, DynamicObject x4) {
        x0.busiAfterSave(x1, x2, x3, x4);
    }

    static /* synthetic */ Log access$200() {
        return logger;
    }
}

