/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.TreeListBizApps;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TreeListBizAppsPlugin
extends StandardTreeListPlugin
implements RowClickEventListener,
ItemClickListener {
    protected static final String BTN_NEW = "btnnew";
    protected static final String BTN_EDIT = "btnedit";
    protected static final String BTN_DELETE = "btndel";
    private static final String NUMBER = "number";

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.getRoot();
        root.setIsOpened(true);
        root.setChildren(this.getCloudNodes());
        this.setBarItemEnable(false, true);
    }

    public void afterBindData(EventObject e) {
        TreeNode currNode = null;
        Map currNodeMap = this.getTreeListView().getTreeView().getTreeState().getFocusNode();
        currNode = currNodeMap == null ? this.getTreeModel().getRoot() : (TreeNode)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)currNodeMap), TreeNode.class);
        this.getTreeListView().getTreeView().focusNode(currNode);
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(nodeId, 20);
        List<TreeNode> childNodes = this.getChildNodes(root, parent);
        e.setChildNodes(childNodes);
        if (parent != null) {
            this.getTreeListView().getTreeView().expand(nodeId);
        }
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        this.getTreeModel().setNodeClickExpand(false);
        super.treeNodeClick(treenodeevent);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        TreeNode root = this.getTreeModel().getRoot();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            Map<String, String> apps = this.searchApp(searchText);
            Set<String> clouds = this.searchCloud(root, searchText);
            clouds.addAll(apps.values());
            root.iterate(2, node -> {
                List currChildren;
                if (!(node.getChildren() != null && node.getChildren().size() != 0 || !clouds.contains(node.getId()) && !apps.containsKey(node.getId()) || (currChildren = node.getChildren()) != null && currChildren.size() != 0)) {
                    List<TreeNode> children = this.getChildNodes(root, (TreeNode)node);
                    this.getTreeModel().addNodes((Object)node.getId(), children);
                }
            });
        }
        super.search(evt);
    }

    private List<String> searchBillApp(String searchText) {
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImportFilter = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        String s = "%%%s%%";
        QFilter likeFilter = new QFilter(NUMBER, "like", (Object)String.format(s, searchText)).or("name", "like", (Object)String.format(s, searchText));
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImportFilter, likeFilter};
        filters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])filters, (String)"dentityid");
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"bizappid", (QFilter[])filters);
        HashSet<String> apps = new HashSet<String>(objects.length);
        for (DynamicObject object : objects) {
            apps.add(object.getString("bizappid_id"));
        }
        return new ArrayList<String>(apps);
    }

    protected Map<String, String> searchApp(String searchText) {
        List<String> billApps = this.searchBillApp(searchText);
        String likeExp = String.format("%%%s%%", searchText);
        List objs = TreeListBizApps.getApps((QFilter[])new QFilter[]{new QFilter("name", "like", (Object)likeExp).or(NUMBER, "like", (Object)likeExp).or("id", "in", billApps)}, (boolean)true);
        HashMap<String, String> apps = new HashMap<String, String>(objs != null ? objs.size() : 0);
        for (DynamicObject obj : objs) {
            apps.put(obj.getString("id"), obj.getString("bizcloud_id"));
        }
        return apps;
    }

    private Set<String> searchCloud(TreeNode root, String searchText) {
        HashSet<String> cloud = new HashSet<String>();
        for (TreeNode node : root.getChildren()) {
            if (!node.getText().contains(searchText)) continue;
            cloud.add(node.getId());
        }
        return cloud;
    }

    private List<TreeNode> getChildNodes(TreeNode root, TreeNode parent) {
        if (StringUtils.equals((CharSequence)parent.getId(), (CharSequence)root.getId())) {
            return this.getCloudNodes();
        }
        switch ((String)parent.getData()) {
            case "cloud": {
                return this.getAppNodesBy(parent.getId());
            }
            case "app": {
                return this.getBillNodesBy(this.getAppIdsBy(parent.getId()));
            }
        }
        return new ArrayList<TreeNode>();
    }

    protected boolean isTopNode(String currNodeId) {
        String rootId = this.getTreeModel().getRoot().getId();
        return StringUtils.equals((CharSequence)rootId, (CharSequence)currNodeId);
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{BTN_EDIT, BTN_DELETE});
        }
    }

    protected List<String> getBillIdInApp(String appNodeId) {
        List<String> appIds = this.getAppIdsBy(appNodeId);
        if (appIds.isEmpty()) {
            return appIds;
        }
        List<TreeNode> billNodes = this.getBillNodesBy(appIds);
        return billNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
    }

    protected List<String> getBillIdInCloud(String cloudId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT C.FID ").append("FROM t_meta_bizcloud A LEFT JOIN t_meta_bizapp B ON A.FID = B.FBIZCLOUDID ").append("LEFT JOIN t_meta_mainentityinfo C  ON C.FBIZAPPID = B.FID ").append("WHERE A.FID = ? AND C.fenableimport = '1' ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)cloudId)};
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(rs.getFetchSize());
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, (ResultSetHandler)action);
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"cloud");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>();
        }
        for (TreeNode cloud : clouds) {
            cloud.setChildren(new ArrayList());
        }
        return clouds;
    }

    protected List<TreeNode> getAppNodesBy(String cloudNodeId) {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree((String[])new String[]{cloudNodeId}, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null || clouds.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        List apps = ((TreeNode)clouds.get(0)).getChildren();
        if (apps == null || apps.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        for (TreeNode app : apps) {
            if (app == null) continue;
            app.setChildren(new ArrayList(0));
        }
        return apps;
    }

    private List<String> getAppIdsBy(String appId) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        String masterId = allApps.stream().filter(obj -> StringUtils.equals((CharSequence)appId, (CharSequence)obj.getString("id"))).findFirst().map(app -> {
            String tType = app.getString("type");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)tType)) {
                return app.getString("id");
            }
            return app.getString("masterid");
        }).orElse("");
        if (StringUtils.isBlank((CharSequence)masterId)) {
            return new ArrayList<String>();
        }
        return allApps.stream().filter(obj -> {
            String tId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            return StringUtils.equals((CharSequence)masterId, (CharSequence)tId) || StringUtils.equals((CharSequence)masterId, (CharSequence)tMasterId);
        }).map(obj -> obj.getString("id")).collect(Collectors.toList());
    }

    protected List<TreeNode> getBillNodesBy(List<String> appIds) {
        String fields = "id, number, name, bizappid";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel", "KMModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImportFilter = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter appIdFilter = new QFilter("bizappid", "in", appIds);
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImportFilter, appIdFilter};
        filters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])filters, (String)"dentityid");
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)fields, (QFilter[])filters);
        ArrayList<TreeNode> billNodes = new ArrayList<TreeNode>(objects.length);
        for (DynamicObject object : objects) {
            String nodeId = object.getString("id");
            String name = object.getLocaleString("name").toString();
            String parentId = object.getString("bizappid_id");
            String data = object.getString(NUMBER);
            TreeNode node = this.createTreeNode(nodeId, name, parentId, data);
            billNodes.add(node);
        }
        return billNodes;
    }

    private TreeNode createTreeNode(String nodeId, String name, String parentId, String data) {
        TreeNode node = new TreeNode();
        node.setText(name);
        node.setParentid(parentId);
        node.setId(nodeId);
        node.setData((Object)data);
        return node;
    }
}

