/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.plugin.PrivacyLabelFieldUtils;
import kd.bos.privacy.plugin.PrivacySchemeConfigPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PrivacySchemeConfigPlugin
extends AbstractBillPlugIn
implements EntryGridBindDataListener,
RowClickEventListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(PrivacySchemeConfigPlugin.class);
    public static final String DEFAULT = "default";
    private static final String SCHEME_ENTRY = "t_privacy_scheme_config";
    private static final String ENCRYPT_ENTRY = "t_privacy_scheme_encrypt";
    private static final String DECRYPT_ENTRY = "t_privacy_scheme_desen";
    private static final String DESENSITIZE_AUTHORITY = "desenauthority";
    private static final String AUTHORITY_FIELDIDENT = "authorityfieldident";
    private static final String DECRYPTION_CONTROL = "decryptioncontrol";
    private static final String DECRYPTION_FIELDIDENT = "decryptionfieldident";
    private static final String DESENSITIZE = "DESENSITIZE";
    private static final String DECRYPT_MESSAGE_TEMPLATE = "template";
    private static final String ENCRYPT_LABEL_ID = "encryptlabelid";
    private static final String DENSE_LABEL_ID = "denselabelid";
    private static final String FDESENSITIZE_RULE = "fdesensitize_rule";
    private static final String FDESEN_RULE_BASEDATA = "fdesen_rule_basedata";
    public static final String ENCRYPT_SCHEMES = "encryptSchemes";
    private static final String FDENSE_FIELD_TYPE = "fdense_field_type";
    private static final String FDESEN_RULE_BASEDATA_ID = "fdesen_rule_basedata_id";
    private static final String FDENSE_ENTITY_NUMBER = "fdense_entity_number";
    private static final String FDENSE_FIELD_IDENT = "fdense_field_ident";
    private static final String FDENSE_APP_NAME = "fdense_app_name";
    private static final String NO = "NO";
    private final String FDATALABELID = "fdatalabelid";
    private final String DENSE_LOCALE = "denselocale";
    private final String DENSEFIELDLOCALE = "fdensefieldlocale";
    private static final String SHOW_ENCRYPT_DATA = "showencryptdata";
    private static final String SHOW_DECRYPT_DATA = "showdecryptdata";
    private static final String FENCRYPT_FIELD_IDENT = "fencrypt_field_ident";
    private static final String FENCRYPT_FIELD_DESC = "fencrypt_field_desc";
    private static final String FENCRYPT_ALGORITHM = "fencrypt_algorithm";
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";
    private static final String CACHE_STRATEGY = "fieldStrategy";
    private static final String CACHE_DESENSITIZE_STRATEGY = "DesensitizeStrategy";
    private IDB idb = new /* Unavailable Anonymous Inner Class!! */;
    private IQueryServiceHelper queryServiceHelper = new /* Unavailable Anonymous Inner Class!! */;
    private IBusinessDataServiceHelper businessDataServiceHelper = new /* Unavailable Anonymous Inner Class!! */;

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain", "toolbarap", "advcontoolbarap", "advcontoolbarap1"});
        super.registerListener(e);
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENCRYPT_ENTRY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        EntryGrid decryptEntryGrid = (EntryGrid)this.getControl(DECRYPT_ENTRY);
        decryptEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
        this.addClickListeners(new String[]{AUTHORITY_FIELDIDENT, DECRYPTION_FIELDIDENT, DECRYPT_MESSAGE_TEMPLATE});
        BasedataEdit dataLabel = (BasedataEdit)this.getView().getControl("fdatalabelid");
        dataLabel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit desenRule = (BasedataEdit)this.getView().getControl(FDESEN_RULE_BASEDATA);
        desenRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        int i;
        int entryRowCount;
        if (e.getOperationResult() == null) {
            return;
        }
        if ("savesplittask".equals(e.getOperateKey()) && this.getView().getFormShowParameter() instanceof BillShowParameter) {
            this.clearCache();
        } else if ("delete".equals(e.getOperateKey())) {
            this.clearCache();
        } else if ("batchfillentry_desen".equals(e.getOperateKey())) {
            this.getModel().endInit();
            entryRowCount = this.getModel().getEntryRowCount(DECRYPT_ENTRY);
            for (i = 0; i < entryRowCount; ++i) {
                this.getView().updateView(FDESEN_RULE_BASEDATA, i);
            }
        } else if ("batchfillentry_encrypt".equals(e.getOperateKey())) {
            this.getModel().endInit();
            entryRowCount = this.getModel().getEntryRowCount(ENCRYPT_ENTRY);
            for (i = 0; i < entryRowCount; ++i) {
                this.getView().updateView(FENCRYPT_ALGORITHM, i);
            }
        }
        List errorResult = e.getOperationResult().getAllErrorInfo();
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection authority = this.getModel().getEntryEntity(DESENSITIZE_AUTHORITY);
        Boolean isDensenPerm = !this.isCheckDensenPerm() && authority.size() > 0;
        if (errorResult.size() > 0) {
            e.getOperationResult().setShowMessage(false);
            for (OperateErrorInfo opInfo : errorResult) {
                String message = opInfo.getMessage();
                if (!StringUtils.isNotBlank((CharSequence)message)) continue;
                String[] split = message.split("\u3002");
                sb.append(split[0]).append("\uff0c");
            }
            if (StringUtils.isNotBlank((CharSequence)sb)) {
                sb = sb.deleteCharAt(sb.length() - 1);
            }
            String error = String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u7b97\u6cd5\u5df2\u8c03\u6574\uff0c\u4efb\u52a1%s\u5df2\u4ea7\u751f\uff0c\u8bf7\u524d\u5f80\u201c\u9690\u79c1\u4e2d\u5fc3-\u6570\u636e\u5904\u7406\u201d\u83dc\u5355\u6267\u884c\u76f8\u5173\u4efb\u52a1\u3002", (String)"PrivacySchemeConfigPlugin_0", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), sb);
            if (isDensenPerm.booleanValue()) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener("privacy_task", (IFormPlugin)this);
                this.getView().showConfirm(error, MessageBoxOptions.OK, listener);
            } else {
                this.getView().showConfirm(error, MessageBoxOptions.OK);
            }
        } else if (isDensenPerm.booleanValue()) {
            String message = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u8131\u654f\u6743\u9650\u914d\u7f6e\u751f\u6548\uff0c\u8bf7\u524d\u5f80\u201c\u9690\u79c1\u4e2d\u5fc3-\u5168\u5c40\u63a7\u5236\u201d\u83dc\u5355\u5f00\u542f\u201c\u8131\u654f\u6743\u9650\u7b56\u7565\u201d\u5f00\u5173\u3002", (String)"PrivacySchemeConfigPlugin_20", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.OK);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "authorityfieldident": {
                this.showFormPrivacySchemeFieldSelect("addAuthorityEntry");
                break;
            }
            case "decryptionfieldident": {
                this.showFormPrivacySchemeFieldSelect("addDecryptionEntry");
                break;
            }
            case "template": {
                this.showForm("privacy_decrypt_message");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        if ("fdatalabelid".equals(event.getProperty().getName())) {
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            QFilter filter = new QFilter("id", "!=", pkValue);
            DynamicObjectCollection selectedLabel = this.queryServiceHelper.query(SCHEME_ENTRY, "fdatalabelid", new QFilter[]{filter});
            ArrayList<Object> selectedLabelId = new ArrayList<Object>(selectedLabel.size());
            for (DynamicObject dynamicObject : selectedLabel) {
                selectedLabelId.add(dynamicObject.get("fdatalabelid"));
            }
            QFilter labelFilter = new QFilter("id", "not in", selectedLabelId);
            param.getListFilterParameter().getQFilters().add(labelFilter);
        } else if (FDESEN_RULE_BASEDATA.equals(event.getProperty().getName())) {
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            Object fieldType = this.getModel().getValue(FDENSE_FIELD_TYPE, event.getRow());
            QFilter filter = new QFilter("range", "like", (Object)String.format("%s,%s,%s", "%", fieldType, "%")).or("range", "like", (Object)String.format("%s,%s,%s", "%", "all", "%"));
            param.getListFilterParameter().getQFilters().add(filter);
            param.getListFilterParameter().setOrderBy("createtime");
        }
    }

    private void showFormPrivacySchemeFieldSelect(String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("mainPageId", (Object)this.getView().getPageId());
        showParameter.setCustomParam("schemeId", this.getModel().getDataEntity().getPkValue());
        showParameter.setFormId("privacy_scheme_fieldsel");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(showParameter);
    }

    private void showForm(String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String content = (String)this.getView().getModel().getValue(DECRYPT_MESSAGE_TEMPLATE);
        parameter.setFormId(formId);
        parameter.setCustomParam("entityNumber", (Object)this.getModel().getDataEntityType().getName());
        parameter.setCustomParam("value", (Object)content);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "templateCallBack"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("addAuthorityEntry".equals(actionId)) {
            DynamicObjectCollection returnData = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            this.addEntryDataByEntryKey(returnData, DESENSITIZE_AUTHORITY, "authority");
        } else if ("addDecryptionEntry".equals(actionId)) {
            DynamicObjectCollection returnData = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            this.addEntryDataByEntryKey(returnData, DECRYPTION_CONTROL, "decryption");
        } else if ("templateCallBack".equals(actionId)) {
            this.getModel().setValue(DECRYPT_MESSAGE_TEMPLATE, closedCallBackEvent.getReturnData());
        }
    }

    private void addEntryDataByEntryKey(DynamicObjectCollection returnData, String entryKey, String prefix) {
        if (CollectionUtils.isEmpty((Collection)returnData)) {
            return;
        }
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex(entryKey);
        if (returnData.size() > 1) {
            model.appendEntryRow(entryKey, rowIndex, returnData.size() - 1);
        }
        for (DynamicObject returnDatum : returnData) {
            this.getModel().setValue(prefix + "fieldident", returnDatum.get("fieldident"), rowIndex);
            this.getModel().setValue(prefix + "fieldname", returnDatum.get("fieldname"), rowIndex);
            this.getModel().setValue(prefix + "entityname", returnDatum.get("entityname"), rowIndex);
            this.getModel().setValue(prefix + "entitynumber", returnDatum.get("entitynumber"), rowIndex);
            this.getModel().setValue(prefix + "labelid", returnDatum.get("labelid"), rowIndex);
            ++rowIndex;
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals(FENCRYPT_ALGORITHM)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENCRYPT_ENTRY);
            entryGrid.setStopUpdateCell(true);
        } else if (e.getProperty().getName().equals(FDESEN_RULE_BASEDATA)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(DECRYPT_ENTRY);
            entryGrid.setStopUpdateCell(true);
        }
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("fdatalabelid".equalsIgnoreCase(e.getProperty().getName())) {
            DynamicObject datalabel = (DynamicObject)this.getModel().getValue("fdatalabelid");
            this.getModel().deleteEntryData(ENCRYPT_ENTRY);
            this.getModel().deleteEntryData(DECRYPT_ENTRY);
            this.getModel().deleteEntryData(DESENSITIZE_AUTHORITY);
            this.getModel().getDataEntity().set("denselocale", (Object)DEFAULT);
            this.getView().updateView("denselocale");
            this.getModel().beginInit();
            this.loadPrivacyDataTags(datalabel == null ? null : datalabel.get("id"));
            this.getModel().endInit();
            this.getModel().updateCache();
            this.complementDenseMuliData();
            this.getView().updateView(ENCRYPT_ENTRY);
            this.getView().updateView(DECRYPT_ENTRY);
        } else if ("denselocale".equalsIgnoreCase(e.getProperty().getName())) {
            this.getView().updateView(DECRYPT_ENTRY);
        } else if (e.getProperty().getName().equals(SHOW_ENCRYPT_DATA)) {
            this.getView().updateView(ENCRYPT_ENTRY);
        } else if (e.getProperty().getName().equals(SHOW_DECRYPT_DATA)) {
            this.getView().updateView(DECRYPT_ENTRY);
        } else if (e.getProperty().getName().equals(FENCRYPT_ALGORITHM)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENCRYPT_ENTRY);
            entryGrid.setStopUpdateCell(false);
            this.getView().updateView(ENCRYPT_ENTRY);
        } else if (e.getProperty().getName().equals(FDESEN_RULE_BASEDATA)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(DECRYPT_ENTRY);
            entryGrid.setStopUpdateCell(false);
            ChangeData changeData = e.getChangeSet()[0];
            String value = (String)this.getModel().getValue("denselocale");
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            DynamicObject changeRowData = changeData.getDataEntity();
            String fieldType = changeRowData.getString(FDENSE_FIELD_TYPE);
            if ("1112".equals(fieldType) && StringUtils.equals((CharSequence)value, (CharSequence)DEFAULT) && oldValue != null) {
                this.updateDenseMuliData(oldValue.getPkValue(), newValue == null ? null : newValue.getPkValue(), changeData.getRowIndex());
            }
            this.getView().updateView(DECRYPT_ENTRY);
        }
    }

    public void beforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        e.setPredicate(e.getPredicate().and(rowItem -> {
            IDataEntityProperty selProp = rowItem.getSelProp();
            boolean isFull = true;
            if (FDESEN_RULE_BASEDATA.equals(selProp.getName())) {
                String ruleRange;
                DynamicObject currentRow = this.getModel().getEntryRowEntity(DECRYPT_ENTRY, rowItem.getRow());
                String fieldType = currentRow.getString(FDENSE_FIELD_TYPE);
                String denseLocale = (String)this.getModel().getValue("denselocale");
                String denseFieldLocale = currentRow.getString("fdensefieldlocale");
                if (StringUtils.isBlank((CharSequence)denseFieldLocale)) {
                    denseFieldLocale = DEFAULT;
                }
                if (!denseLocale.equals(denseFieldLocale)) {
                    return false;
                }
                DynamicObject desenRule = (DynamicObject)rowItem.getValue();
                if (desenRule != null && StringUtils.isNotBlank((CharSequence)(ruleRange = desenRule.getString("range")))) {
                    String[] rangeStr;
                    for (String range : rangeStr = ruleRange.split(",")) {
                        if (StringUtils.isBlank((CharSequence)range)) continue;
                        if ("all".equals(range)) {
                            isFull = true;
                            break;
                        }
                        if (fieldType.equals(range)) {
                            isFull = true;
                            break;
                        }
                        isFull = false;
                    }
                }
                if (isFull && "1112".equals(fieldType)) {
                    DynamicObject oldValue = (DynamicObject)currentRow.get(FDESEN_RULE_BASEDATA);
                    DynamicObject newValue = (DynamicObject)rowItem.getValue();
                    if (StringUtils.equals((CharSequence)denseLocale, (CharSequence)DEFAULT) && StringUtils.equals((CharSequence)denseFieldLocale, (CharSequence)DEFAULT)) {
                        this.updateDenseMuliData(oldValue.getPkValue(), newValue == null ? null : newValue.getPkValue(), rowItem.getRow());
                    }
                }
            }
            return isFull;
        }));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDenseLocaleCombo();
        this.initEncryptionScheme();
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
        if ("0".equals(this.getModel().getValue("fscheme_status"))) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u6b63\u5728\u53d1\u5e03\u4e2d\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"PrivacySchemeConfigPlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void afterLoadData(EventObject e) {
        if (this.checkStatus()) {
            this.getModel().setValue("fscheme_status", (Object)0);
        } else {
            this.getModel().setValue("fscheme_status", (Object)1);
        }
        DynamicObject dataLabel = (DynamicObject)this.getModel().getValue("fdatalabelid");
        if (dataLabel == null) {
            return;
        }
        this.appendPrivacyDataTags(dataLabel.get("id"));
        this.initDesensitizationRules();
        this.complementDenseMuliData();
        this.updateEncryptCache();
        this.getModel().setDataChanged(false);
    }

    private List<String> getModelEntryId(String entryKey, String fieldKey) {
        DynamicObjectCollection encryptData = this.getModel().getEntryEntity(entryKey);
        ArrayList<String> entryIdList = new ArrayList<String>();
        for (DynamicObject data : encryptData) {
            entryIdList.add(data.getString(fieldKey));
        }
        return entryIdList;
    }

    private void loadPrivacyDataTags(Object id) {
        DynamicObjectCollection dObjColl;
        if (StringUtils.isBlank((Object)id)) {
            return;
        }
        this.loadNoDesensitizationRules();
        DynamicObject dObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"privacy_data_tags");
        if (dObj != null && (dObjColl = dObj.getDynamicObjectCollection("ffeildsentry")) != null) {
            for (DynamicObject row : dObjColl) {
                this.addEncryptEntryRowData(row);
                this.addDecryptEntryRowData(row);
            }
        }
    }

    private void appendPrivacyDataTags(Object id) {
        DynamicObjectCollection dObjColl;
        if (StringUtils.isBlank((Object)id)) {
            return;
        }
        List<String> encryptEntryIds = this.getModelEntryId(ENCRYPT_ENTRY, ENCRYPT_LABEL_ID);
        List<String> decryptEntryIds = this.getModelEntryId(DECRYPT_ENTRY, DENSE_LABEL_ID);
        DynamicObject dObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"privacy_data_tags");
        if (dObj != null && (dObjColl = dObj.getDynamicObjectCollection("ffeildsentry")) != null) {
            for (DynamicObject row : dObjColl) {
                String entryId = row.getString("id");
                if (!encryptEntryIds.contains(entryId)) {
                    this.addEncryptEntryRowData(row);
                }
                if (decryptEntryIds.contains(entryId)) continue;
                this.addDecryptEntryRowData(row);
            }
        }
    }

    private void addEncryptEntryRowData(DynamicObject row) {
        IDataModel model = this.getModel();
        if (row.getString("ffield_type").equals("1111")) {
            return;
        }
        String fieldName = row.getString("ffield_name");
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            return;
        }
        String tableName = row.getString("ftable_name");
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return;
        }
        String entityNumber = row.getString("fentity_number");
        ILocaleString entityName = row.getLocaleString("fentity_name");
        String fieldKey = row.getString("ffield_ident");
        ILocaleString fieldDesc = row.getLocaleString("ffield_desc");
        Map<String, String> strMap = this.getFieldStrategyMap(entityNumber);
        String strategy = strMap.get(fieldKey);
        if (StringUtils.isNotBlank((CharSequence)strategy) && strategy.contains("noenc")) {
            log.info(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s(%2$s)\u7684\u5b57\u6bb5%3$s(%4$s)\u5df2\u914d\u7f6e\u4e0d\u5141\u8bb8\u52a0\u5bc6\uff0c\u6545\u4e0d\u5c55\u793a\u5728\u52a0\u5bc6\u89c4\u5219\u4e2d", (String)"PrivacySchemeConfigPlugin_17", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), entityNumber, entityName, fieldKey, fieldDesc));
            return;
        }
        model.beginInit();
        Integer rowIndex = this.getModel().createNewEntryRow(ENCRYPT_ENTRY);
        model.setValue(ENCRYPT_LABEL_ID, row.get("id"), rowIndex.intValue());
        model.setValue(FENCRYPT_FIELD_IDENT, (Object)fieldKey, rowIndex.intValue());
        model.setValue("fencrypt_field_name", (Object)fieldName, rowIndex.intValue());
        model.setValue("fencrypt_field_type", (Object)row.getString("ffield_type"), rowIndex.intValue());
        model.setValue(FENCRYPT_FIELD_DESC, (Object)fieldDesc, rowIndex.intValue());
        model.setValue("fencrypt_table_name", (Object)tableName, rowIndex.intValue());
        String algorithm = this.queryExistEncryptAlgorithm(row);
        if (StringUtils.isNotBlank((CharSequence)algorithm)) {
            model.setValue(FENCRYPT_ALGORITHM, (Object)this.queryExistEncryptAlgorithm(row), rowIndex.intValue());
        }
        model.setValue("fencrypt_status", (Object)Character.valueOf('1'), rowIndex.intValue());
        model.setValue("fencrypt_entity_number", (Object)entityNumber, rowIndex.intValue());
        model.setValue("fencrypt_entity_name", (Object)entityName, rowIndex.intValue());
        model.setValue("fencrypt_app_number", (Object)row.getString("fapp_number"), rowIndex.intValue());
        model.setValue("fencrypt_app_name", (Object)row.getLocaleString("fapp_name"), rowIndex.intValue());
        model.setValue("fencrypt_cloud_number", (Object)row.getString("fcloud_number"), rowIndex.intValue());
        model.setValue("fencrypt_cloud_name", (Object)row.getLocaleString("fcloud_name"), rowIndex.intValue());
        model.setValue("approute", (Object)row.getString("approute"), rowIndex.intValue());
        model.endInit();
    }

    private Map<String, String> getFieldStrategyMap(String entityNumber) {
        String str = this.getPageCache().get(CACHE_STRATEGY);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        }
        Map strMap = PrivacyLabelFieldUtils.getFieldStrategyMap((String)entityNumber);
        this.getPageCache().put(CACHE_STRATEGY, SerializationUtils.toJsonString((Object)strMap));
        return strMap;
    }

    private String queryExistEncryptAlgorithm(DynamicObject row) {
        String sql = "select fencrypt_algorithm from t_privacy_scheme_encrypt where fencrypt_table_name = ? and fencrypt_field_name = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fencrypt_table_name", 12, (Object)row.getString("ftable_name")), new SqlParameter(":fencrypt_field_name", 12, (Object)row.getString("ffield_name"))};
        try {
            return (String)this.idb.query(new DBRoute("sys"), sql, params, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws SQLException {
                    String encryptAlgorithm = null;
                    if (rs.next()) {
                        encryptAlgorithm = rs.getString(1);
                    }
                    return encryptAlgorithm;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    private void addDecryptEntryRowData(DynamicObject row) {
        IDataModel model = this.getModel();
        String entityNumber = row.getString("fentity_number");
        ILocaleString entityName = row.getLocaleString("fentity_name");
        String fieldKey = row.getString("ffield_ident");
        ILocaleString fieldDesc = row.getLocaleString("ffield_desc");
        Map<String, String> strMap = this.getFieldStrategyMap(entityNumber);
        String strategy = strMap.get(fieldKey);
        if (StringUtils.isNotBlank((CharSequence)strategy) && strategy.contains("nodes")) {
            log.info(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s(%2$s)\u7684\u5b57\u6bb5%3$s(%4$s)\u5df2\u914d\u7f6e\u4e0d\u5141\u8bb8\u8131\u654f\uff0c\u6545\u4e0d\u5728\u8131\u654f\u89c4\u5219\u4e2d\u5c55\u793a\u3002", (String)"PrivacySchemeConfigPlugin_18", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), entityNumber, entityName, fieldKey, fieldDesc));
            return;
        }
        Integer rowIndex_dense = this.getModel().createNewEntryRow(DECRYPT_ENTRY);
        model.setValue(DENSE_LABEL_ID, row.get("id"), rowIndex_dense.intValue());
        model.setValue(FDENSE_FIELD_IDENT, (Object)fieldKey, rowIndex_dense.intValue());
        model.setValue("fdense_field_name", (Object)row.getString("ffield_name"), rowIndex_dense.intValue());
        model.setValue(FDENSE_FIELD_TYPE, (Object)row.getString("ffield_type"), rowIndex_dense.intValue());
        String desen = this.getView().getPageCache().get(NO);
        if (StringUtils.isNotBlank((CharSequence)desen)) {
            model.setValue(FDESEN_RULE_BASEDATA, (Object)desen, rowIndex_dense.intValue());
        }
        model.setValue(FDENSE_ENTITY_NUMBER, (Object)entityNumber, rowIndex_dense.intValue());
        model.setValue("fdense_app_number", (Object)row.getString("fapp_number"), rowIndex_dense.intValue());
        model.setValue("fdense_cloud_number", (Object)row.getString("fcloud_number"), rowIndex_dense.intValue());
        model.setValue("fdense_field_desc", (Object)fieldDesc, rowIndex_dense.intValue());
        model.setValue("fdense_table_name", (Object)row.getString("ftable_name"), rowIndex_dense.intValue());
        model.setValue("fdense_entity_name", (Object)entityName, rowIndex_dense.intValue());
        model.setValue(FDENSE_APP_NAME, (Object)row.getLocaleString("fapp_name"), rowIndex_dense.intValue());
        model.setValue("fdense_cloud_name", (Object)row.getLocaleString("fcloud_name"), rowIndex_dense.intValue());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("savesplittask".equals(operate.getOperateKey()) && this.getView().getFormShowParameter() instanceof BillShowParameter) {
            super.beforeDoOperation(args);
            boolean isConfirm = "SecondaryConfirmation".equals(operate.getParameter().get("sourceName"));
            if (isConfirm) {
                return;
            }
            if (this.checkContentChange(operate)) {
                args.setCancel(true);
                return;
            }
            if (this.checkStatus()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u6b63\u5728\u53d1\u5e03\u4e2d\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"PrivacySchemeConfigPlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.checkLabelRepeatReference()) {
                args.setCancel(true);
                return;
            }
            if (this.checkDifferentEncryption()) {
                args.setCancel(true);
                return;
            }
            if (this.checkDesensitizeAuthority()) {
                args.setCancel(true);
                return;
            }
            if (this.checkDifferentEncryptionWithDataBase()) {
                args.setCancel(true);
                return;
            }
            if (this.checkEncryptionScheme()) {
                args.setCancel(true);
                return;
            }
            this.updateEncryptCache();
        } else if ("delete".equals(operate.getOperateKey())) {
            QFilter encryptFilter;
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            QFilter filter = new QFilter("fdatalabelid", "=", pkValue);
            QFilter[] filters = new QFilter[]{filter, encryptFilter = new QFilter("t_privacy_scheme_encrypt.fencrypt_algorithm", "!=", (Object)NO)};
            DynamicObject config = this.businessDataServiceHelper.loadSingle(SCHEME_ENTRY, "id", filters);
            if (config != null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9690\u79c1\u65b9\u6848\u4e2d\u5df2\u6709\u6570\u636e\u88ab\u52a0\u5bc6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PrivacySchemeConfigPlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("batchfillentry_desen".equals(operate.getOperateKey())) {
            this.getModel().getDataEntity(true);
            this.getModel().beginInit();
        } else if ("batchfillentry_encrypt".equals(operate.getOperateKey())) {
            this.getModel().getDataEntity(true);
            this.getModel().beginInit();
        }
    }

    private void initDenseLocaleCombo() {
        if (!this.isMuliEnv()) {
            return;
        }
        ComboEdit denselocale = (ComboEdit)this.getView().getControl("denselocale");
        List enableLangs = ((IInteService)ServiceFactory.getService(IInteService.class)).getMultiLangEnabledLang();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(6);
        ComboItem defaultItem = new ComboItem();
        defaultItem.setValue(DEFAULT);
        defaultItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9ed8\u8ba4", (String)"PrivacySchemeConfigPlugin_3", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])));
        comboItems.add(defaultItem);
        for (EnabledLang lang : enableLangs) {
            ComboItem item = new ComboItem();
            item.setValue(lang.getNumber());
            item.setCaption(new LocaleString(lang.getName()));
            comboItems.add(item);
        }
        denselocale.setComboItems(comboItems);
        denselocale.selectedStore((ComboItem)comboItems.get(0));
        this.getModel().setValue("denselocale", (Object)((ComboItem)comboItems.get(0)).getValue());
        EntryGrid decryptEntry = (EntryGrid)this.getView().getControl(DECRYPT_ENTRY);
        for (Control ctl : decryptEntry.getControls()) {
            if (!"fdensefieldlocale".equals(ctl.getKey())) continue;
            ((ComboEdit)ctl).setComboItems(comboItems);
            break;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals("SecondaryConfirmation") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("sourceName", "SecondaryConfirmation");
            option.setVariableValue("sourceEvent", "Operation");
            this.getView().invokeOperation("savesplittask", option);
        } else if (callBackId.equals("privacy_task")) {
            DynamicObjectCollection authority = this.getModel().getEntryEntity(DESENSITIZE_AUTHORITY);
            if (!this.isCheckDensenPerm() && authority.size() > 0) {
                String message = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u8131\u654f\u6743\u9650\u914d\u7f6e\u751f\u6548\uff0c\u8bf7\u524d\u5f80\u201c\u9690\u79c1\u4e2d\u5fc3-\u5168\u5c40\u63a7\u5236\u201d\u83dc\u5355\u5f00\u542f\u201c\u8131\u654f\u6743\u9650\u7b56\u7565\u201d\u5f00\u5173\u3002", (String)"PrivacySchemeConfigPlugin_20", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.OK);
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        boolean showEncryptData = (Boolean)this.getModel().getValue(SHOW_ENCRYPT_DATA);
        boolean showDecryptData = (Boolean)this.getModel().getValue(SHOW_DECRYPT_DATA);
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        List rowDatas = e.getRows();
        if (showEncryptData && ENCRYPT_ENTRY.equals(entryGrid.getEntryKey())) {
            this._filterEntryData(FENCRYPT_ALGORITHM, rowDatas);
        } else if (DECRYPT_ENTRY.equals(entryGrid.getEntryKey())) {
            if (showDecryptData) {
                this._filterEntryData(FDESEN_RULE_BASEDATA_ID, rowDatas);
            }
            this.filterEntryDataByLocale(rowDatas);
        }
        e.setReloadRows(true);
    }

    private void filterEntryDataByLocale(List<RowDataEntity> datas) {
        String denseLocale = this.getModel().getDataEntity().getString("denselocale");
        boolean isDefault = false;
        if (DEFAULT.equalsIgnoreCase(denseLocale) || StringUtils.isEmpty((CharSequence)denseLocale)) {
            isDefault = true;
        }
        Iterator<RowDataEntity> iterator = datas.iterator();
        while (iterator.hasNext()) {
            String locale = iterator.next().getDataEntity().getString("fdensefieldlocale");
            if (isDefault) {
                if (StringUtils.isEmpty((CharSequence)locale)) continue;
                iterator.remove();
                continue;
            }
            if (denseLocale.equals(locale)) continue;
            iterator.remove();
        }
    }

    private void _filterEntryData(String filterField, List<RowDataEntity> datas) {
        HashMap<String, String> strategyMap = new HashMap<String, String>(1);
        Map data = this.businessDataServiceHelper.loadFromCache("privacy_desen_rules", "id,number", new QFilter[]{new QFilter("number", "=", (Object)NO)});
        for (DynamicObject value : data.values()) {
            String number = value.getString("number");
            strategyMap.put(value.getString("id"), number);
        }
        Iterator<RowDataEntity> iterator = datas.iterator();
        while (iterator.hasNext()) {
            String encrypt = iterator.next().getDataEntity().getString(filterField);
            if (!NO.equals(encrypt = strategyMap.getOrDefault(encrypt, encrypt)) && !"FOLLOW".equals(encrypt)) continue;
            iterator.remove();
        }
    }

    private boolean isMuliEnv() {
        boolean isHasMuliProp = false;
        String isHasMuliPropStr = this.getPageCache().get("isHasMuliProp");
        if (StringUtils.isEmpty((CharSequence)isHasMuliPropStr)) {
            ComboEdit denselocale = (ComboEdit)this.getView().getControl("denselocale");
            List enableLangs = ((IInteService)ServiceFactory.getService(IInteService.class)).getMultiLangEnabledLang();
            if (enableLangs == null || enableLangs.isEmpty() || enableLangs.size() == 1 && ((EnabledLang)enableLangs.get((int)0)).isDefault.booleanValue()) {
                denselocale.setVisible(null, false);
                this.getModel().setValue("denselocale", (Object)DEFAULT);
                EntryGrid decryptEntry = (EntryGrid)this.getView().getControl(DECRYPT_ENTRY);
                for (Control ctl : decryptEntry.getControls()) {
                    if (!"fdensefieldlocale".equals(ctl.getKey())) continue;
                    ((FieldEdit)ctl).setVisible(null, false);
                    break;
                }
            } else {
                isHasMuliProp = true;
            }
            this.getPageCache().put("isHasMuliProp", String.valueOf(isHasMuliProp));
        } else {
            isHasMuliProp = "true".equalsIgnoreCase(isHasMuliPropStr);
        }
        return isHasMuliProp;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    private boolean checkDifferentEncryption() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENCRYPT_ENTRY);
        HashMap<String, ArrayList<DynamicObject>> encrypt = new HashMap<String, ArrayList<DynamicObject>>(10);
        for (DynamicObject dynamicObject : entryEntity) {
            String key = String.format("%s_%s", dynamicObject.getString("fencrypt_table_name").toLowerCase(), dynamicObject.getString("fencrypt_field_name").toLowerCase());
            ArrayList<DynamicObject> encryptObjects = (ArrayList<DynamicObject>)encrypt.get(key);
            if (encryptObjects == null) {
                encryptObjects = new ArrayList<DynamicObject>();
                encrypt.put(key, encryptObjects);
            }
            encryptObjects.add(dynamicObject);
        }
        StringBuilder errorMsg = new StringBuilder();
        for (List value : encrypt.values()) {
            if (value.size() <= 1) continue;
            String encryptType = null;
            for (DynamicObject dynamicObject : value) {
                String currentType = dynamicObject.getString(FENCRYPT_ALGORITHM);
                if (StringUtils.isBlank(encryptType)) {
                    encryptType = currentType;
                    continue;
                }
                if (currentType.equals(encryptType)) continue;
                errorMsg.append(String.format("[%s/%s]\u3001", dynamicObject.get(FENCRYPT_FIELD_IDENT), dynamicObject.get(FENCRYPT_FIELD_DESC)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg.toString())) {
            errorMsg = errorMsg.deleteCharAt(errorMsg.length() - 1);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u91c7\u7528\u4e86\u76f8\u540c\u7684\u7269\u7406\u8868\u5b58\u50a8\uff0c\u52a0\u5bc6\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u4e3a\u4e00\u81f4\u540e\u4fdd\u5b58\u3002", (String)"PrivacySchemeConfigPlugin_4", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), errorMsg.toString()));
            return true;
        }
        return false;
    }

    private boolean checkContentChange(FormOperate operate) {
        boolean isConfirm = "MessageCallBackType".equals(operate.getParameter().get("sourceName"));
        if (isConfirm) {
            return false;
        }
        String cache = this.getPageCache().get(ENCRYPT_ENTRY);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return false;
        }
        Map encryptAlgorithmMap = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENCRYPT_ENTRY);
        for (DynamicObject dynamicObject : entryEntity) {
            String encryptAlgorithm = (String)encryptAlgorithmMap.get(dynamicObject.getString("id"));
            if (!StringUtils.isNotBlank((CharSequence)encryptAlgorithm) || StringUtils.equals((CharSequence)encryptAlgorithm, (CharSequence)dynamicObject.getString(FENCRYPT_ALGORITHM))) continue;
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("contentChange", (AbstractOperate)operate);
            String confirmTip = ResManager.loadKDString((String)"\u52a0\u5bc6\u7b97\u6cd5\u53d8\u66f4\uff0c\u4f1a\u89e6\u53d1\u4e1a\u52a1\u6570\u636e\u8fdb\u884c\u6570\u636e\u8fc1\u79fb\uff0c\u786e\u8ba4\u4fee\u6539\u5417\uff1f", (String)"PrivacySchemeConfigPlugin_5", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
            return true;
        }
        return false;
    }

    private boolean checkStatus() {
        String sql = "select fid from t_privacy_scheme_encrypt where  fid = ? and fencrypt_status != ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", -5, this.getModel().getDataEntity().getPkValue()), new SqlParameter(":fencrypt_status", 12, (Object)Character.valueOf('1'))};
        return (Boolean)this.idb.query(new DBRoute("sys"), sql, params, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    private boolean checkLabelRepeatReference() {
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object pkId = this.getModel().getDataEntity().getPkValue();
        String formId = formShowParameter.getFormId();
        DynamicObject labelId = (DynamicObject)this.getModel().getValue("fdatalabelid");
        if (labelId == null) {
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter("fdatalabelid", "=", labelId.get("id")).and(new QFilter("id", "!=", pkId))};
        boolean exists = this.queryServiceHelper.exists(formId, filters);
        if (exists) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6807\u7b7e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e\u3002", (String)"PrivacySchemeConfigPlugin_6", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkDifferentEncryptionWithDataBase() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENCRYPT_ENTRY);
        HashMap<String, HashMap<String, Object>> encrypt = new HashMap<String, HashMap<String, Object>>(16);
        for (Object dynamicObject : entryEntity) {
            String string = dynamicObject.getString("approute");
            String tableName = dynamicObject.getString("fencrypt_table_name");
            String fieldName = dynamicObject.getString("fencrypt_field_name");
            if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)tableName) || StringUtils.isBlank((CharSequence)fieldName)) continue;
            String key = String.format("%s$%s", string, tableName);
            HashMap<String, Object> encryptObjects = (HashMap<String, Object>)encrypt.get(key);
            if (encryptObjects == null) {
                encryptObjects = new HashMap<String, Object>(16);
                encrypt.put(key, encryptObjects);
            }
            encryptObjects.put(fieldName, dynamicObject);
        }
        StringBuilder errorMsg = new StringBuilder();
        for (Map.Entry entry : encrypt.entrySet()) {
            String key = (String)entry.getKey();
            String[] tableData = key.split("\\$");
            Map entryDataValue = (Map)entry.getValue();
            QFilter idFilter = new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue());
            QFilter filter = new QFilter("t_privacy_scheme_encrypt.fencrypt_table_name", "=", (Object)tableData[1]).and(new QFilter("t_privacy_scheme_encrypt.fencrypt_field_name", "in", (Object)entryDataValue.keySet().toArray()));
            QFilter[] filters = new QFilter[]{idFilter, filter};
            DynamicObject[] dataCollection = this.businessDataServiceHelper.load(this.getModel().getDataEntityType().getName(), "fid,fscheme_code,fscheme_name,t_privacy_scheme_encrypt.fencrypt_field_name,t_privacy_scheme_encrypt.fencrypt_field_ident,t_privacy_scheme_encrypt.fencrypt_field_desc,t_privacy_scheme_encrypt.fencrypt_algorithm", filters);
            HashMap<String, List> encryptDataWithDataBase = new HashMap<String, List>(16);
            for (DynamicObject value : dataCollection) {
                DynamicObjectCollection data = (DynamicObjectCollection)value.get(ENCRYPT_ENTRY);
                for (DynamicObject entryRow : data) {
                    String fieldName = entryRow.getString("fencrypt_field_name");
                    if (!entryDataValue.containsKey(fieldName)) continue;
                    List fieldNameMap = encryptDataWithDataBase.getOrDefault(fieldName, new ArrayList());
                    if (CollectionUtils.isEmpty((Collection)fieldNameMap)) {
                        encryptDataWithDataBase.put(fieldName, fieldNameMap);
                    }
                    HashMap<String, String> rowData = new HashMap<String, String>(10);
                    rowData.put("id", value.getString("id"));
                    rowData.put("fscheme_code", value.getString("fscheme_code"));
                    rowData.put("fscheme_name", value.getString("fscheme_name"));
                    rowData.put(FENCRYPT_FIELD_IDENT, entryRow.getString(FENCRYPT_FIELD_IDENT));
                    rowData.put(FENCRYPT_FIELD_DESC, entryRow.getString(FENCRYPT_FIELD_DESC));
                    rowData.put(FENCRYPT_ALGORITHM, entryRow.getString(FENCRYPT_ALGORITHM));
                    fieldNameMap.add(rowData);
                }
            }
            for (Map.Entry entry2 : entryDataValue.entrySet()) {
                StringBuilder errorRowMsg = new StringBuilder();
                List maps = (List)encryptDataWithDataBase.get(entry2.getKey());
                if (CollectionUtils.isEmpty((Collection)maps)) continue;
                for (Map map : maps) {
                    if (((String)map.get(FENCRYPT_ALGORITHM)).equals(((DynamicObject)entry2.getValue()).get(FENCRYPT_ALGORITHM))) continue;
                    errorRowMsg.append(String.format(ResManager.loadKDString((String)"[%1$s/%2$s]\u7684[%3$s/%4$s]%5$s", (String)"PrivacySchemeConfigPlugin_7", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), map.get("fscheme_code"), map.get("fscheme_name"), map.get(FENCRYPT_FIELD_IDENT), map.get(FENCRYPT_FIELD_DESC), "\u3001"));
                }
                if (!StringUtils.isNotBlank((CharSequence)errorRowMsg.toString())) continue;
                errorMsg.append(String.format(ResManager.loadKDString((String)ResManager.loadKDString((String)"[%1$s]\u4e0e%2$s%3$s", (String)"PrivacySchemeConfigPlugin_22", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), (String)"PrivacySchemeConfigPlugin_8", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), ((DynamicObject)entry2.getValue()).get(FENCRYPT_FIELD_IDENT), errorRowMsg.deleteCharAt(errorRowMsg.length() - 1).toString(), ","));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg.toString())) {
            errorMsg = errorMsg.deleteCharAt(errorMsg.length() - 1);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("SecondaryConfirmation", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u91c7\u7528\u4e86\u76f8\u540c\u7684\u7269\u7406\u8868\u5b58\u50a8\uff0c\u4f46\u52a0\u5bc6\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u5f53\u524d\u65b9\u52a0\u5bc6\u7b97\u6cd5\u5c06\u8986\u76d6\u5176\u4ed6\u65b9\u6848\u4e2d\u7684\u52a0\u5bc6\u7b97\u6cd5\uff0c\u786e\u8ba4\u7ee7\u7eed\u5417\uff1f", (String)"PrivacySchemeConfigPlugin_9", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), errorMsg.toString()), MessageBoxOptions.OKCancel, confirmCallBacks);
            return true;
        }
        return false;
    }

    private boolean checkDesensitizeAuthority() {
        DynamicObjectCollection authority = this.getModel().getEntryEntity(DESENSITIZE_AUTHORITY);
        StringBuilder userInputMessage = new StringBuilder();
        StringBuilder fieldInputMessage = new StringBuilder();
        StringBuilder otherInputMessage = new StringBuilder();
        HashMap<String, Map<Object, Set<Integer>>> userIdMap = new HashMap<String, Map<Object, Set<Integer>>>(16);
        HashMap<String, Map<Object, Set<Integer>>> roleIdMap = new HashMap<String, Map<Object, Set<Integer>>>(16);
        for (int i = 0; i < authority.size(); ++i) {
            DynamicObject row = (DynamicObject)authority.get(i);
            DynamicObjectCollection userField = row.getDynamicObjectCollection("userfield");
            if (userField == null || userField.isEmpty()) {
                userInputMessage.append('[').append(i + 1).append(']');
                continue;
            }
            if (StringUtils.isBlank((CharSequence)row.getString(AUTHORITY_FIELDIDENT))) {
                fieldInputMessage.append('[').append(i + 1).append(']');
                continue;
            }
            String formPolicy = row.getString("formpolicy");
            String exportPolicy = row.getString("exportpolicy");
            String printPolicy = row.getString("printpolicy");
            if (StringUtils.isBlank((CharSequence)formPolicy) && StringUtils.isBlank((CharSequence)exportPolicy) && StringUtils.isBlank((CharSequence)printPolicy) || DESENSITIZE.equals(formPolicy) && DESENSITIZE.equals(exportPolicy) && DESENSITIZE.equals(printPolicy)) {
                otherInputMessage.append('[').append(i + 1).append(']');
                continue;
            }
            String key = String.format("%s$%s", row.getString("authorityentitynumber"), row.getString(AUTHORITY_FIELDIDENT));
            this.verifyDuplicateData(key, row.getDynamicObjectCollection("userfield"), userIdMap, "fbasedataid_id", i);
            this.verifyDuplicateData(key, row.getDynamicObjectCollection("rolefield"), roleIdMap, "fbasedataid_id", i);
        }
        if (StringUtils.isNotBlank((CharSequence)userInputMessage.toString())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8131\u654f\u6743\u9650\u4e2d\u7b2c%s\u884c\u6570\u636e\u672a\u6307\u5b9a\u6388\u6743\u7528\u6237\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PrivacySchemeConfigPlugin_10", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), userInputMessage.toString()));
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)fieldInputMessage.toString())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8131\u654f\u6743\u9650\u4e2d\u7b2c%s\u884c\u6570\u636e\u672a\u6307\u5b9a\u8131\u654f\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PrivacySchemeConfigPlugin_11", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), fieldInputMessage.toString()));
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)otherInputMessage.toString())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8131\u654f\u6743\u9650\u4e2d\u63a7\u5236\u7b56\u7565\u6bcf\u884c\u81f3\u5c11\u6709\u4e00\u9879\u4e3a\u975e\u9ed8\u8ba4\u7b56\u7565\uff0c\u7b2c%s\u884c\u8bf7\u4fee\u6539\u3002", (String)"PrivacySchemeConfigPlugin_12", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), otherInputMessage.toString()));
            return true;
        }
        StringBuilder userErrorMessages = this.buildErrorMessage(userIdMap, ResManager.loadKDString((String)"\u8131\u654f\u6743\u9650\u4e2d\u7b2c[%s]\u884c\u7684\u6388\u6743\u7528\u6237\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"PrivacySchemeConfigPlugin_13", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
        StringBuilder roleErrorMessages = this.buildErrorMessage(roleIdMap, ResManager.loadKDString((String)"\u8131\u654f\u6743\u9650\u4e2d\u7b2c[%s]\u884c\u7684\u6388\u6743\u89d2\u8272\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"PrivacySchemeConfigPlugin_14", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
        if (StringUtils.isNotBlank((CharSequence)userErrorMessages.toString()) || StringUtils.isNotBlank((CharSequence)roleErrorMessages.toString())) {
            StringBuilder message = StringUtils.isNotBlank((CharSequence)userErrorMessages.toString()) ? userErrorMessages.append((CharSequence)roleErrorMessages) : roleErrorMessages;
            message.deleteCharAt(message.length() - 1).append("\u3002");
            this.getView().showErrorNotification(message.toString());
            return true;
        }
        return false;
    }

    private boolean isCheckDensenPerm() {
        DynamicObject globalDObj = QueryServiceHelper.queryOne((String)"privacy_global_control", (String)"checkdesenperm", null);
        if (globalDObj != null) {
            return globalDObj.getBoolean("checkdesenperm");
        }
        return false;
    }

    private void verifyDuplicateData(String key, DynamicObjectCollection dataCollection, Map<String, Map<Object, Set<Integer>>> repeatMap, String fieldKey, int currentIndex) {
        for (DynamicObject data : dataCollection) {
            Object baseDataId;
            Map<Object, Set<Integer>> indexMap = repeatMap.get(key);
            if (indexMap == null) {
                indexMap = new HashMap<Object, Set<Integer>>();
                repeatMap.put(key, indexMap);
            }
            if ((baseDataId = data.get(fieldKey)) == null) continue;
            Set<Integer> index = indexMap.get(baseDataId);
            if (index == null) {
                index = new HashSet<Integer>(10);
                indexMap.put(baseDataId, index);
            }
            index.add(currentIndex + 1);
        }
    }

    private StringBuilder buildErrorMessage(Map<String, Map<Object, Set<Integer>>> repeatMap, String message) {
        StringBuilder userErrorMessages = new StringBuilder();
        for (Map<Object, Set<Integer>> value : repeatMap.values()) {
            HashSet<Integer> errorIndex = new HashSet<Integer>();
            for (Set<Integer> indexes : value.values()) {
                if (indexes.size() <= 1) continue;
                errorIndex.addAll(indexes);
            }
            if (errorIndex.isEmpty()) continue;
            userErrorMessages.append(String.format(message, StringUtils.join((Object[])errorIndex.toArray(), (String)"]\u3001[")));
        }
        return userErrorMessages;
    }

    private void complementDenseMuliData() {
        if (!this.isMuliEnv()) {
            return;
        }
        List enableLangs = ((IInteService)ServiceFactory.getService(IInteService.class)).getMultiLangEnabledLang();
        ArrayList<String> allLangs = new ArrayList<String>(enableLangs.size());
        for (EnabledLang lang : enableLangs) {
            allLangs.add(lang.getNumber());
        }
        LinkedHashMap<String, Item> filterMap = new LinkedHashMap<String, Item>(8);
        DynamicObjectCollection decryptColl = this.getModel().getEntryEntity(DECRYPT_ENTRY);
        block1: for (DynamicObject dynamicObject : decryptColl) {
            if (!"1112".equals(dynamicObject.getString(FDENSE_FIELD_TYPE))) continue;
            String fdense_entity_number = dynamicObject.getString(FDENSE_ENTITY_NUMBER);
            String fdense_field_ident = dynamicObject.getString(FDENSE_FIELD_IDENT);
            String fdense_app_name = dynamicObject.getString(FDENSE_APP_NAME);
            String filterMapKey = fdense_entity_number + fdense_field_ident + fdense_app_name;
            Item item = (Item)filterMap.get(filterMapKey);
            if (item == null) {
                item = new Item();
                item.setDynamicObject(dynamicObject);
                item.setLangs(new ArrayList<String>(allLangs));
                filterMap.put(filterMapKey, item);
            }
            String locale = dynamicObject.getString("fdensefieldlocale");
            Iterator<String> it = item.getLangs().iterator();
            while (it.hasNext()) {
                String tmpLocale = it.next();
                if (locale == null || !locale.equalsIgnoreCase(tmpLocale)) continue;
                it.remove();
                continue block1;
            }
        }
        this.getModel().beginInit();
        for (Map.Entry entry : filterMap.entrySet()) {
            DynamicObject dynamicObject = ((Item)entry.getValue()).getDynamicObject();
            for (String lang : ((Item)entry.getValue()).getLangs()) {
                IDataModel model = this.getModel();
                Integer rowIndex = this.getModel().createNewEntryRow(DECRYPT_ENTRY);
                model.setValue(FDENSE_FIELD_IDENT, dynamicObject.get(FDENSE_FIELD_IDENT), rowIndex.intValue());
                model.setValue("fdense_field_name", dynamicObject.get("fdense_field_name"), rowIndex.intValue());
                model.setValue(FDENSE_FIELD_TYPE, dynamicObject.get(FDENSE_FIELD_TYPE), rowIndex.intValue());
                model.setValue(FDESEN_RULE_BASEDATA, dynamicObject.get(FDESEN_RULE_BASEDATA_ID), rowIndex.intValue());
                model.setValue(FDENSE_ENTITY_NUMBER, dynamicObject.get(FDENSE_ENTITY_NUMBER), rowIndex.intValue());
                model.setValue("fdense_app_number", dynamicObject.get("fdense_app_number"), rowIndex.intValue());
                model.setValue("fdense_cloud_number", dynamicObject.get("fdense_cloud_number"), rowIndex.intValue());
                model.setValue("fdense_field_desc", dynamicObject.get("fdense_field_desc"), rowIndex.intValue());
                model.setValue("fdense_table_name", dynamicObject.get("fdense_table_name"), rowIndex.intValue());
                model.setValue("fdense_entity_name", dynamicObject.get("fdense_entity_name"), rowIndex.intValue());
                model.setValue(FDENSE_APP_NAME, dynamicObject.get(FDENSE_APP_NAME), rowIndex.intValue());
                model.setValue("fdense_cloud_name", dynamicObject.get("fdense_cloud_name"), rowIndex.intValue());
                model.setValue(DENSE_LABEL_ID, dynamicObject.get(DENSE_LABEL_ID), rowIndex.intValue());
                model.setValue("fdensefieldlocale", (Object)lang, rowIndex.intValue());
            }
        }
        this.getModel().endInit();
    }

    private void action_denseLocaleChange(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        boolean isNeed = false;
        isNeed = newValue == null || oldValue == null ? newValue != oldValue : !newValue.equals(oldValue);
        if (isNeed) {
            ComboEdit fdesensitize_rule = (ComboEdit)this.getView().getControl(FDESENSITIZE_RULE);
            ComboProp comboProp = (ComboProp)fdesensitize_rule.getProperty();
            List comboItems = comboProp.getComboItems();
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(6);
            for (ValueMapItem valueMapItem : comboItems) {
                ComboItem comboItem = new ComboItem(valueMapItem.getName(), valueMapItem.getValue());
                comboItem.setItemVisible(valueMapItem.isItemVisible());
                list.add(comboItem);
            }
            if (!StringUtils.isEmpty((CharSequence)((String)newValue)) && !DEFAULT.equalsIgnoreCase((String)newValue)) {
                for (ComboItem comboItem : list) {
                    if (!"FOLLOW".equals(comboItem.getValue())) continue;
                    comboItem.setItemVisible(true);
                    break;
                }
            }
            fdesensitize_rule.setComboItems(list);
        }
    }

    private void initDesensitizationRules() {
        String key;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DECRYPT_ENTRY);
        HashMap<String, String> desenRules = new HashMap<String, String>(entryEntity.size());
        HashSet<String> numberOrIdList = new HashSet<String>(10);
        for (DynamicObject dynamicObject : entryEntity) {
            String numberOrId = dynamicObject.getString(FDESEN_RULE_BASEDATA_ID);
            if (StringUtils.isNotBlank((CharSequence)numberOrId)) {
                numberOrIdList.add(numberOrId);
            }
            if (!"1112".equals(dynamicObject.getString(FDENSE_FIELD_TYPE)) || !StringUtils.isBlank((CharSequence)dynamicObject.getString("fdensefieldlocale"))) continue;
            key = String.format("%s$%s$%s", dynamicObject.getString(FDENSE_APP_NAME), dynamicObject.getString(FDENSE_ENTITY_NUMBER), dynamicObject.getString(FDENSE_FIELD_IDENT));
            desenRules.put(key, dynamicObject.getString(FDESEN_RULE_BASEDATA_ID));
        }
        int rowCount = this.getModel().getEntryRowCount(DECRYPT_ENTRY);
        this.getModel().beginInit();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject row = this.getModel().getEntryRowEntity(DECRYPT_ENTRY, i);
            if (!"FOLLOW".equals(row.getString(FDESEN_RULE_BASEDATA_ID))) continue;
            key = String.format("%s$%s$%s", row.getString(FDENSE_APP_NAME), row.getString(FDENSE_ENTITY_NUMBER), row.getString(FDENSE_FIELD_IDENT));
            String rule = desenRules.getOrDefault(key, "FOLLOW");
            this.getModel().setValue(FDESEN_RULE_BASEDATA_ID, (Object)rule, i);
            this.getModel().setValue(FDESEN_RULE_BASEDATA, (Object)rule, i);
        }
        QFilter numberFilter = new QFilter("number", "in", (Object)numberOrIdList.toArray());
        this.setDesensitizationRules(numberOrIdList, numberFilter);
        this.getModel().endInit();
    }

    private void setDesensitizationRules(Set<String> numberOrIdList, QFilter filter) {
        if (CollectionUtils.isEmpty(numberOrIdList)) {
            return;
        }
        Map data = this.businessDataServiceHelper.loadFromCache("privacy_desen_rules", "id, number, name", new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Map)data)) {
            return;
        }
        HashMap<String, String> encryptSchemesMap = new HashMap<String, String>(data.size());
        for (DynamicObject scheme : data.values()) {
            encryptSchemesMap.put(scheme.getString("number"), scheme.getPkValue().toString());
        }
        int rowCount = this.getModel().getEntryRowCount(DECRYPT_ENTRY);
        for (int i = 0; i < rowCount; ++i) {
            String rule = this.getModel().getValue(FDESEN_RULE_BASEDATA_ID, i).toString();
            Object value = this.getModel().getValue(FDESEN_RULE_BASEDATA, i);
            if (!StringUtils.isNotEmpty((CharSequence)rule) || value != null) continue;
            String ruleId = (String)encryptSchemesMap.get(rule);
            if (StringUtils.isNotEmpty((CharSequence)ruleId)) {
                rule = ruleId;
            }
            this.getModel().setValue(FDESEN_RULE_BASEDATA, (Object)rule, i);
        }
    }

    private void initEncryptionScheme() {
        ComboEdit fencrypt_algorithm = (ComboEdit)this.getControl(FENCRYPT_ALGORITHM);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(6);
        ComboItem defaultItem = new ComboItem();
        defaultItem.setValue(NO);
        defaultItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u52a0\u5bc6", (String)"PrivacySchemeConfigPlugin_15", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])));
        comboItems.add(defaultItem);
        QFilter filter = new QFilter("number", "!=", (Object)"LICENCE-SIGNATURE");
        Map data = this.businessDataServiceHelper.loadFromCache("perm_encryptionscheme", "id, number, name, enable", new QFilter[]{filter});
        ArrayList encryptSchemes = new ArrayList(data.values());
        HashMap<Object, String> encryptSchemesMap = new HashMap<Object, String>(encryptSchemes.size());
        for (DynamicObject scheme : encryptSchemes) {
            ComboItem item = new ComboItem();
            item.setValue(scheme.getPkValue().toString());
            item.setCaption(new LocaleString(scheme.getString("name")));
            item.setItemVisible(scheme.getBoolean("enable"));
            comboItems.add(item);
            encryptSchemesMap.put(scheme.getPkValue(), scheme.getString("name"));
        }
        fencrypt_algorithm.setComboItems(comboItems);
        this.getPageCache().put(ENCRYPT_SCHEMES, SerializationUtils.toJsonString(encryptSchemesMap));
    }

    private void updateEncryptCache() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENCRYPT_ENTRY);
        HashMap<String, String> encryptAlgorithmMap = new HashMap<String, String>(16);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (StringUtils.isBlank((CharSequence)dynamicObject.getString("id"))) continue;
            encryptAlgorithmMap.put(dynamicObject.getString("id"), dynamicObject.getString(FENCRYPT_ALGORITHM));
        }
        this.getPageCache().put(ENCRYPT_ENTRY, CollectionUtils.isEmpty(encryptAlgorithmMap) ? null : SerializationUtils.toJsonString(encryptAlgorithmMap));
    }

    private boolean checkEncryptionScheme() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENCRYPT_ENTRY);
        String encryptSchemesStr = this.getPageCache().get(ENCRYPT_SCHEMES);
        if (StringUtils.isEmpty((CharSequence)encryptSchemesStr)) {
            return false;
        }
        Map encryptSchemes = (Map)SerializationUtils.fromJsonString((String)encryptSchemesStr, Map.class);
        if (encryptSchemes.isEmpty()) {
            return false;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Long schemeId;
            String fencrypt_algorithm = dynamicObject.getString(FENCRYPT_ALGORITHM);
            if (!StringUtils.isNotEmpty((CharSequence)fencrypt_algorithm) || NO.equals(fencrypt_algorithm) || PermissionServiceHelper.checkSchemeEnable((long)(schemeId = Long.valueOf(Long.parseLong(fencrypt_algorithm))))) continue;
            String schemesName = (String)encryptSchemes.get(fencrypt_algorithm);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u3010%s\u3011\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrivacySchemeConfigPlugin_16", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[]{schemesName}), new Object[0]));
            return true;
        }
        return false;
    }

    private void updateDenseMuliData(Object oldValue, Object newValue, int rowIndex) {
        DynamicObject currentRow = this.getModel().getEntryRowEntity(DECRYPT_ENTRY, rowIndex);
        String key = String.format("%s$%s$%s", currentRow.getString(FDENSE_APP_NAME), currentRow.getString(FDENSE_ENTITY_NUMBER), currentRow.getString(FDENSE_FIELD_IDENT));
        int rowCount = this.getModel().getEntryRowCount(DECRYPT_ENTRY);
        for (int i = 0; i < rowCount; ++i) {
            if (i == rowIndex) continue;
            DynamicObject row = this.getModel().getEntryRowEntity(DECRYPT_ENTRY, i);
            String entityNumber = row.getString(FDENSE_ENTITY_NUMBER);
            String fieldIdent = row.getString(FDENSE_FIELD_IDENT);
            String appName = row.getString(FDENSE_APP_NAME);
            String rowKey = String.format("%s$%s$%s", appName, entityNumber, fieldIdent);
            if (!StringUtils.equals((CharSequence)key, (CharSequence)rowKey) || !oldValue.equals(row.getString(FDESEN_RULE_BASEDATA_ID))) continue;
            this.getModel().setValue(FDESEN_RULE_BASEDATA, newValue, i);
        }
    }

    protected void clearCache() {
        PrivacyDataCenterManager.clearCache();
    }

    private void loadNoDesensitizationRules() {
        if (StringUtils.isBlank((CharSequence)this.getView().getPageCache().get(NO))) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"loadDesensitizationRules", (String)"privacy_desen_rules", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)NO)}, null);){
                while (dataSet.hasNext()) {
                    Row data = dataSet.next();
                    this.getView().getPageCache().put(NO, data.getString("id"));
                }
            }
        }
    }

    static class Item {
        private List<String> langs;
        private DynamicObject dynamicObject;

        Item() {
        }

        public List<String> getLangs() {
            return this.langs;
        }

        public void setLangs(List<String> langs) {
            this.langs = langs;
        }

        public DynamicObject getDynamicObject() {
            return this.dynamicObject;
        }

        public void setDynamicObject(DynamicObject dynamicObject) {
            this.dynamicObject = dynamicObject;
        }
    }
}

