/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.aspect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.server.next.IScheduleMonitorAspect;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.smc.ManageServiceHelper;

public class ScheduleNextMonitorAspect
implements IScheduleMonitorAspect {
    private static final Log logger = LogFactory.getLog(ScheduleNextMonitorAspect.class);

    public Set<String> getDisabledAppNum() {
        return (Set)ThreadCache.get((Object)"Sch.getDisabledAppNum", () -> {
            HashSet<String> sets = new HashSet<String>(8);
            Set<String> appids = this.getDisableAppIds();
            for (String appId : appids) {
                String appNum = BizAppServiceHelp.getAppNumByAppId((String)appId);
                sets.add(appNum);
            }
            return sets;
        });
    }

    private Set<String> getDisableAppIds() {
        try {
            HashSet<String> sets = new HashSet<String>(6);
            Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
            sets.addAll(disabledAppIds);
            Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
            DynamicObjectCollection coll = BizAppServiceHelp.getAllBizAppsByCloudID(new ArrayList(disabledCloudIds));
            for (DynamicObject dObj : coll) {
                String id = dObj.getString("id");
                if (!StringUtils.isNotEmpty((CharSequence)id)) continue;
                sets.add(id);
            }
            return sets;
        }
        catch (Throwable t) {
            logger.error("Schedule*** error,getDisableAppIds", t);
            return Collections.emptySet();
        }
    }
}

